// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include <grpc/support/port_platform.h>

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_9_10_11.h"
namespace grpc_core {
namespace geometry_9_10_11 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[2] = {0x30, 0x31};
const uint16_t HuffDecoderCommon::table1_0_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085,
    0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085};
const uint8_t HuffDecoderCommon::table1_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table1_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table1_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table1_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table1_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint16_t HuffDecoderCommon::table1_5_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
    0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
    0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186, 0x0186};
const uint8_t HuffDecoderCommon::table1_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table1_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table1_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table1_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table1_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table1_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table1_11_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0287, 0x0287, 0x0287, 0x0287};
const uint8_t HuffDecoderCommon::table1_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint16_t HuffDecoderCommon::table1_12_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0087, 0x0087, 0x0087, 0x0087,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0287, 0x0287, 0x0287, 0x0287,
    0x0307, 0x0307, 0x0307, 0x0307, 0x0387, 0x0387, 0x0387, 0x0387};
const uint8_t HuffDecoderCommon::table1_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table1_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table1_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint16_t HuffDecoderCommon::table1_15_ops_[32] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0087, 0x0087, 0x0087, 0x0087,
    0x0107, 0x0107, 0x0107, 0x0107, 0x0187, 0x0187, 0x0187, 0x0187,
    0x0208, 0x0208, 0x0288, 0x0288, 0x0308, 0x0308, 0x0388, 0x0388,
    0x0408, 0x0408, 0x0488, 0x0488, 0x0019, 0x0029, 0x0039, 0x0049};
const uint8_t* const HuffDecoderCommon::table1_emit_[16] = {
    table1_0_emit_,  table1_1_emit_,  table1_2_emit_,  table1_3_emit_,
    table1_4_emit_,  table1_5_emit_,  table1_6_emit_,  table1_7_emit_,
    table1_8_emit_,  table1_9_emit_,  table1_10_emit_, table1_11_emit_,
    table1_12_emit_, table1_13_emit_, table1_14_emit_, table1_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_ops_[16] = {
    table1_0_ops_,  table1_0_ops_,  table1_0_ops_,  table1_0_ops_,
    table1_0_ops_,  table1_5_ops_,  table1_5_ops_,  table1_5_ops_,
    table1_5_ops_,  table1_5_ops_,  table1_5_ops_,  table1_11_ops_,
    table1_12_ops_, table1_12_ops_, table1_12_ops_, table1_15_ops_,
};
const uint8_t HuffDecoderCommon::table12_0_inner_[5] = {0x00, 0x01, 0x05, 0x09,
                                                        0x02};
const uint8_t HuffDecoderCommon::table12_0_outer_[8] = {0, 1, 2, 3, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table13_0_emit_[9] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table13_0_inner_[11] = {
    0x00, 0x01, 0x05, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x1d, 0x21, 0x02};
const uint8_t HuffDecoderCommon::table13_0_outer_[16] = {
    0, 0, 0, 1, 0, 2, 0, 3, 4, 5, 6, 7, 8, 9, 0, 10};
const uint8_t HuffDecoderCommon::table14_0_emit_[11] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table14_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15,
    0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x25, 0x29, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table15_0_emit_[14] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b,
    0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00,
    0x21, 0x00, 0x25, 0x00, 0x29, 0x2d, 0x31, 0x35, 0x02};
const uint8_t HuffDecoderCommon::table16_0_emit_[33] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x23, 0x3e,
    0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table16_0_ops_[128] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5e, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x66,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x6e, 0x01, 0x01, 0x01, 0x72, 0x01, 0x01, 0x01, 0x76,
    0x01, 0x7a, 0x01, 0x7e, 0x01, 0x82, 0x01, 0x03};
const uint8_t HuffDecoderCommon::table17_0_emit_[44] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20,
    0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c,
    0x34, 0x7c, 0x35, 0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table17_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table17_1_emit_[28] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64,
    0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d,
    0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72, 0x7c, 0x75};
const uint8_t HuffDecoderCommon::table17_1_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table17_2_emit_[20] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63,
    0x23, 0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74};
const uint8_t HuffDecoderCommon::table17_2_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table17_3_emit_[20] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63,
    0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74};
const uint8_t HuffDecoderCommon::table17_4_emit_[2] = {0x00, 0x24};
const uint8_t HuffDecoderCommon::table17_4_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table17_5_emit_[2] = {0x40, 0x5b};
const uint8_t HuffDecoderCommon::table17_6_emit_[2] = {0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table17_7_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                       0x7b};
const uint8_t HuffDecoderCommon::table17_7_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table17_emit_[8] = {
    table17_0_emit_, table17_1_emit_, table17_2_emit_, table17_3_emit_,
    table17_4_emit_, table17_5_emit_, table17_6_emit_, table17_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table17_ops_[8] = {
    table17_0_ops_, table17_1_ops_, table17_2_ops_, table17_2_ops_,
    table17_4_ops_, table17_4_ops_, table17_4_ops_, table17_7_ops_,
};
const uint16_t HuffDecoderCommon::table18_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table18_1_emit_[92] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44,
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a};
const uint16_t HuffDecoderCommon::table18_1_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_2_emit_[72] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23, 0x65,
    0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25,
    0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39, 0x23, 0x3d, 0x23, 0x41,
    0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68,
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72, 0x23, 0x75};
const uint16_t HuffDecoderCommon::table18_2_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table18_3_emit_[72] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e, 0x65,
    0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25,
    0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39, 0x3e, 0x3d, 0x3e, 0x41,
    0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68,
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72, 0x3e, 0x75};
const uint8_t HuffDecoderCommon::table18_4_emit_[40] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63,
    0x00, 0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74,
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63,
    0x24, 0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74};
const uint16_t HuffDecoderCommon::table18_4_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table18_5_emit_[40] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63,
    0x40, 0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74,
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63,
    0x5b, 0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74};
const uint8_t HuffDecoderCommon::table18_6_emit_[40] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63,
    0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74,
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63,
    0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74};
const uint16_t HuffDecoderCommon::table18_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table18_emit_[8] = {
    table17_0_emit_, table18_1_emit_, table18_2_emit_, table18_3_emit_,
    table18_4_emit_, table18_5_emit_, table18_6_emit_, table17_7_emit_,
};
const uint16_t* const HuffDecoderCommon::table18_ops_[8] = {
    table18_0_ops_, table18_1_ops_, table18_2_ops_, table18_2_ops_,
    table18_4_ops_, table18_4_ops_, table18_4_ops_, table18_7_ops_,
};
const uint8_t HuffDecoderCommon::table10_0_emit_[1] = {0x7c};
const uint16_t HuffDecoderCommon::table10_0_ops_[64] = {
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002};
const uint8_t HuffDecoderCommon::table10_4_emit_[1] = {0x23};
const uint16_t HuffDecoderCommon::table10_4_ops_[64] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003};
const uint8_t HuffDecoderCommon::table10_6_emit_[1] = {0x3e};
const uint8_t HuffDecoderCommon::table10_8_emit_[1] = {0x00};
const uint16_t HuffDecoderCommon::table10_8_ops_[64] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table10_9_emit_[1] = {0x24};
const uint8_t HuffDecoderCommon::table10_10_emit_[1] = {0x40};
const uint8_t HuffDecoderCommon::table10_11_emit_[1] = {0x5b};
const uint8_t HuffDecoderCommon::table10_12_emit_[1] = {0x5d};
const uint8_t HuffDecoderCommon::table10_13_emit_[1] = {0x7e};
const uint8_t HuffDecoderCommon::table10_14_emit_[2] = {0x5e, 0x7d};
const uint16_t HuffDecoderCommon::table10_14_ops_[64] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
    0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
    0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
    0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105};
const uint8_t HuffDecoderCommon::table10_15_emit_[6] = {0x3c, 0x60, 0x7b,
                                                        0x5c, 0xc3, 0xd0};
const uint16_t HuffDecoderCommon::table10_15_ops_[64] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
    0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x030a, 0x040a, 0x050a, 0x001a, 0x002a, 0x003a, 0x004a, 0x005a,
    0x006a, 0x007a, 0x008a, 0x009a, 0x00aa, 0x00ba, 0x00ca, 0x00da};
const uint8_t* const HuffDecoderCommon::table10_emit_[16] = {
    table10_0_emit_,  table10_0_emit_,  table10_0_emit_,  table10_0_emit_,
    table10_4_emit_,  table10_4_emit_,  table10_6_emit_,  table10_6_emit_,
    table10_8_emit_,  table10_9_emit_,  table10_10_emit_, table10_11_emit_,
    table10_12_emit_, table10_13_emit_, table10_14_emit_, table10_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table10_ops_[16] = {
    table10_0_ops_, table10_0_ops_, table10_0_ops_,  table10_0_ops_,
    table10_4_ops_, table10_4_ops_, table10_4_ops_,  table10_4_ops_,
    table10_8_ops_, table10_8_ops_, table10_8_ops_,  table10_8_ops_,
    table10_8_ops_, table10_8_ops_, table10_14_ops_, table10_15_ops_,
};
const uint8_t HuffDecoderCommon::table26_0_emit_[8] = {0x9a, 0x9c, 0xa0, 0xa3,
                                                       0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table26_0_inner_[8] = {0x03, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b, 0x1f};
const uint8_t HuffDecoderCommon::table27_0_emit_[8] = {0xb2, 0xb5, 0xb9, 0xba,
                                                       0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table28_0_emit_[16] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e,
    0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table28_0_inner_[16] = {
    0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c,
    0x44, 0x4c, 0x54, 0x5c, 0x64, 0x6c, 0x74, 0x7c};
const uint8_t HuffDecoderCommon::table29_0_emit_[7] = {0xe6, 0x81, 0x84, 0x85,
                                                       0x86, 0x88, 0x92};
const uint8_t HuffDecoderCommon::table29_0_inner_[7] = {0x02, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b};
const uint8_t HuffDecoderCommon::table32_0_inner_[5] = {0x00, 0x02, 0x04, 0x06,
                                                        0x01};
const uint8_t HuffDecoderCommon::table31_0_emit_[12] = {
    0xc6, 0xe4, 0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table31_0_inner_[12] = {
    0x03, 0x0b, 0x13, 0x1b, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x4c, 0x54, 0x5c};
const uint8_t HuffDecoderCommon::table34_0_emit_[5] = {0xbc, 0xbf, 0xc5, 0xe7,
                                                       0xef};
const uint8_t HuffDecoderCommon::table34_0_inner_[7] = {0x00, 0x04, 0x08, 0x0c,
                                                        0x10, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table35_0_emit_[17] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91,
    0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table35_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x15,
    0x19, 0x1d, 0x21, 0x25, 0x29, 0x2d, 0x31, 0x35, 0x39, 0x3d, 0x41,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table36_0_emit_[21] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f,
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table36_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x15,
    0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29, 0x00,
    0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41,
    0x45, 0x49, 0x4d, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table37_0_emit_[36] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f, 0xab,
    0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0, 0xc1, 0xc8,
    0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint8_t HuffDecoderCommon::table37_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x19,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25,
    0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31,
    0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d,
    0x00, 0x00, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51,
    0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81,
    0x85, 0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table38_0_emit_[55] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f,
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0,
    0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf,
    0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint8_t HuffDecoderCommon::table38_0_ops_[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x45,
    0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x51,
    0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69,
    0x00, 0x6d, 0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81,
    0x00, 0x85, 0x00, 0x89, 0x00, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1, 0xa5,
    0xa9, 0xad, 0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0xd5,
    0xd9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table39_0_emit_[40] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63,
    0xbc, 0x65, 0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74,
    0xbf, 0x30, 0xbf, 0x31, 0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63,
    0xbf, 0x65, 0xbf, 0x69, 0xbf, 0x6f, 0xbf, 0x73, 0xbf, 0x74};
const uint8_t HuffDecoderCommon::table39_0_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50,
    0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52};
const uint8_t HuffDecoderCommon::table39_1_emit_[40] = {
    0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61, 0xc5, 0x63,
    0xc5, 0x65, 0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74,
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63,
    0xe7, 0x65, 0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74};
const uint8_t HuffDecoderCommon::table39_2_emit_[22] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef, 0x63, 0xef,
    0x65, 0xef, 0x69, 0xef, 0x6f, 0xef, 0x73, 0xef, 0x74, 0x09, 0x8e};
const uint8_t HuffDecoderCommon::table39_2_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56};
const uint8_t HuffDecoderCommon::table39_3_emit_[4] = {0x90, 0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table39_3_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table39_4_emit_[4] = {0xab, 0xce, 0xd7, 0xe1};
const uint8_t HuffDecoderCommon::table39_5_emit_[6] = {0xec, 0xed, 0xc7,
                                                       0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table39_5_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16};
const uint8_t HuffDecoderCommon::table39_6_emit_[17] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda,
    0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint8_t HuffDecoderCommon::table39_6_ops_[64] = {
    0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01,
    0x0a, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01,
    0x01, 0x16, 0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x1e, 0x01,
    0x01, 0x01, 0x22, 0x01, 0x01, 0x01, 0x26, 0x01, 0x01, 0x01, 0x2a,
    0x01, 0x01, 0x01, 0x2e, 0x01, 0x01, 0x01, 0x32, 0x01, 0x01, 0x01,
    0x36, 0x01, 0x01, 0x01, 0x3a, 0x01, 0x3e, 0x01, 0x42};
const uint8_t HuffDecoderCommon::table39_7_emit_[46] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table39_7_ops_[64] = {
    0x01, 0x02, 0x01, 0x06, 0x01, 0x0a, 0x01, 0x0e, 0x01, 0x12, 0x01,
    0x16, 0x01, 0x1a, 0x01, 0x1e, 0x01, 0x22, 0x01, 0x26, 0x01, 0x2a,
    0x01, 0x2e, 0x01, 0x32, 0x01, 0x36, 0x01, 0x3a, 0x01, 0x3e, 0x01,
    0x42, 0x46, 0x4a, 0x4e, 0x52, 0x56, 0x5a, 0x5e, 0x62, 0x66, 0x6a,
    0x6e, 0x72, 0x76, 0x7a, 0x7e, 0x82, 0x86, 0x8a, 0x8e, 0x92, 0x96,
    0x9a, 0x9e, 0xa2, 0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0x03};
const uint8_t* const HuffDecoderCommon::table39_emit_[8] = {
    table39_0_emit_, table39_1_emit_, table39_2_emit_, table39_3_emit_,
    table39_4_emit_, table39_5_emit_, table39_6_emit_, table39_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table39_ops_[8] = {
    table39_0_ops_, table39_0_ops_, table39_2_ops_, table39_3_ops_,
    table39_3_ops_, table39_5_ops_, table39_6_ops_, table39_7_ops_,
};
const uint8_t HuffDecoderCommon::table40_0_emit_[72] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63, 0xbc, 0x65,
    0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74, 0xbc, 0x20, 0xbc, 0x25,
    0xbc, 0x2d, 0xbc, 0x2e, 0xbc, 0x2f, 0xbc, 0x33, 0xbc, 0x34, 0xbc, 0x35,
    0xbc, 0x36, 0xbc, 0x37, 0xbc, 0x38, 0xbc, 0x39, 0xbc, 0x3d, 0xbc, 0x41,
    0xbc, 0x5f, 0xbc, 0x62, 0xbc, 0x64, 0xbc, 0x66, 0xbc, 0x67, 0xbc, 0x68,
    0xbc, 0x6c, 0xbc, 0x6d, 0xbc, 0x6e, 0xbc, 0x70, 0xbc, 0x72, 0xbc, 0x75};
const uint8_t HuffDecoderCommon::table40_1_emit_[72] = {
    0xbf, 0x30, 0xbf, 0x31, 0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63, 0xbf, 0x65,
    0xbf, 0x69, 0xbf, 0x6f, 0xbf, 0x73, 0xbf, 0x74, 0xbf, 0x20, 0xbf, 0x25,
    0xbf, 0x2d, 0xbf, 0x2e, 0xbf, 0x2f, 0xbf, 0x33, 0xbf, 0x34, 0xbf, 0x35,
    0xbf, 0x36, 0xbf, 0x37, 0xbf, 0x38, 0xbf, 0x39, 0xbf, 0x3d, 0xbf, 0x41,
    0xbf, 0x5f, 0xbf, 0x62, 0xbf, 0x64, 0xbf, 0x66, 0xbf, 0x67, 0xbf, 0x68,
    0xbf, 0x6c, 0xbf, 0x6d, 0xbf, 0x6e, 0xbf, 0x70, 0xbf, 0x72, 0xbf, 0x75};
const uint8_t HuffDecoderCommon::table40_2_emit_[72] = {
    0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61, 0xc5, 0x63, 0xc5, 0x65,
    0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74, 0xc5, 0x20, 0xc5, 0x25,
    0xc5, 0x2d, 0xc5, 0x2e, 0xc5, 0x2f, 0xc5, 0x33, 0xc5, 0x34, 0xc5, 0x35,
    0xc5, 0x36, 0xc5, 0x37, 0xc5, 0x38, 0xc5, 0x39, 0xc5, 0x3d, 0xc5, 0x41,
    0xc5, 0x5f, 0xc5, 0x62, 0xc5, 0x64, 0xc5, 0x66, 0xc5, 0x67, 0xc5, 0x68,
    0xc5, 0x6c, 0xc5, 0x6d, 0xc5, 0x6e, 0xc5, 0x70, 0xc5, 0x72, 0xc5, 0x75};
const uint8_t HuffDecoderCommon::table40_3_emit_[72] = {
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63, 0xe7, 0x65,
    0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74, 0xe7, 0x20, 0xe7, 0x25,
    0xe7, 0x2d, 0xe7, 0x2e, 0xe7, 0x2f, 0xe7, 0x33, 0xe7, 0x34, 0xe7, 0x35,
    0xe7, 0x36, 0xe7, 0x37, 0xe7, 0x38, 0xe7, 0x39, 0xe7, 0x3d, 0xe7, 0x41,
    0xe7, 0x5f, 0xe7, 0x62, 0xe7, 0x64, 0xe7, 0x66, 0xe7, 0x67, 0xe7, 0x68,
    0xe7, 0x6c, 0xe7, 0x6d, 0xe7, 0x6e, 0xe7, 0x70, 0xe7, 0x72, 0xe7, 0x75};
const uint8_t HuffDecoderCommon::table40_4_emit_[72] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef, 0x63, 0xef, 0x65,
    0xef, 0x69, 0xef, 0x6f, 0xef, 0x73, 0xef, 0x74, 0xef, 0x20, 0xef, 0x25,
    0xef, 0x2d, 0xef, 0x2e, 0xef, 0x2f, 0xef, 0x33, 0xef, 0x34, 0xef, 0x35,
    0xef, 0x36, 0xef, 0x37, 0xef, 0x38, 0xef, 0x39, 0xef, 0x3d, 0xef, 0x41,
    0xef, 0x5f, 0xef, 0x62, 0xef, 0x64, 0xef, 0x66, 0xef, 0x67, 0xef, 0x68,
    0xef, 0x6c, 0xef, 0x6d, 0xef, 0x6e, 0xef, 0x70, 0xef, 0x72, 0xef, 0x75};
const uint8_t HuffDecoderCommon::table40_5_emit_[40] = {
    0x09, 0x30, 0x09, 0x31, 0x09, 0x32, 0x09, 0x61, 0x09, 0x63,
    0x09, 0x65, 0x09, 0x69, 0x09, 0x6f, 0x09, 0x73, 0x09, 0x74,
    0x8e, 0x30, 0x8e, 0x31, 0x8e, 0x32, 0x8e, 0x61, 0x8e, 0x63,
    0x8e, 0x65, 0x8e, 0x69, 0x8e, 0x6f, 0x8e, 0x73, 0x8e, 0x74};
const uint8_t HuffDecoderCommon::table40_6_emit_[40] = {
    0x90, 0x30, 0x90, 0x31, 0x90, 0x32, 0x90, 0x61, 0x90, 0x63,
    0x90, 0x65, 0x90, 0x69, 0x90, 0x6f, 0x90, 0x73, 0x90, 0x74,
    0x91, 0x30, 0x91, 0x31, 0x91, 0x32, 0x91, 0x61, 0x91, 0x63,
    0x91, 0x65, 0x91, 0x69, 0x91, 0x6f, 0x91, 0x73, 0x91, 0x74};
const uint8_t HuffDecoderCommon::table40_7_emit_[40] = {
    0x94, 0x30, 0x94, 0x31, 0x94, 0x32, 0x94, 0x61, 0x94, 0x63,
    0x94, 0x65, 0x94, 0x69, 0x94, 0x6f, 0x94, 0x73, 0x94, 0x74,
    0x9f, 0x30, 0x9f, 0x31, 0x9f, 0x32, 0x9f, 0x61, 0x9f, 0x63,
    0x9f, 0x65, 0x9f, 0x69, 0x9f, 0x6f, 0x9f, 0x73, 0x9f, 0x74};
const uint8_t HuffDecoderCommon::table40_8_emit_[40] = {
    0xab, 0x30, 0xab, 0x31, 0xab, 0x32, 0xab, 0x61, 0xab, 0x63,
    0xab, 0x65, 0xab, 0x69, 0xab, 0x6f, 0xab, 0x73, 0xab, 0x74,
    0xce, 0x30, 0xce, 0x31, 0xce, 0x32, 0xce, 0x61, 0xce, 0x63,
    0xce, 0x65, 0xce, 0x69, 0xce, 0x6f, 0xce, 0x73, 0xce, 0x74};
const uint8_t HuffDecoderCommon::table40_9_emit_[40] = {
    0xd7, 0x30, 0xd7, 0x31, 0xd7, 0x32, 0xd7, 0x61, 0xd7, 0x63,
    0xd7, 0x65, 0xd7, 0x69, 0xd7, 0x6f, 0xd7, 0x73, 0xd7, 0x74,
    0xe1, 0x30, 0xe1, 0x31, 0xe1, 0x32, 0xe1, 0x61, 0xe1, 0x63,
    0xe1, 0x65, 0xe1, 0x69, 0xe1, 0x6f, 0xe1, 0x73, 0xe1, 0x74};
const uint8_t HuffDecoderCommon::table40_10_emit_[40] = {
    0xec, 0x30, 0xec, 0x31, 0xec, 0x32, 0xec, 0x61, 0xec, 0x63,
    0xec, 0x65, 0xec, 0x69, 0xec, 0x6f, 0xec, 0x73, 0xec, 0x74,
    0xed, 0x30, 0xed, 0x31, 0xed, 0x32, 0xed, 0x61, 0xed, 0x63,
    0xed, 0x65, 0xed, 0x69, 0xed, 0x6f, 0xed, 0x73, 0xed, 0x74};
const uint8_t HuffDecoderCommon::table40_11_emit_[4] = {0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table40_11_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e};
const uint8_t HuffDecoderCommon::table40_12_emit_[8] = {0xc0, 0xc1, 0xc8, 0xc9,
                                                        0xca, 0xcd, 0xd2, 0xd5};
const uint16_t HuffDecoderCommon::table40_12_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e};
const uint8_t HuffDecoderCommon::table40_13_emit_[9] = {
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint16_t HuffDecoderCommon::table40_13_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022};
const uint8_t HuffDecoderCommon::table40_14_emit_[16] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4,
    0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd};
const uint16_t HuffDecoderCommon::table40_14_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0026,
    0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000, 0x0000, 0x002e,
    0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0036,
    0x0000, 0x0000, 0x0000, 0x003a, 0x0000, 0x0000, 0x0000, 0x003e};
const uint8_t HuffDecoderCommon::table40_15_emit_[30] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c,
    0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table40_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0006, 0x0000, 0x000a,
    0x0000, 0x000e, 0x0000, 0x0012, 0x0000, 0x0016, 0x0000, 0x001a,
    0x0000, 0x001e, 0x0000, 0x0022, 0x0000, 0x0026, 0x0000, 0x002a,
    0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a,
    0x0000, 0x003e, 0x0000, 0x0042, 0x0000, 0x0046, 0x0000, 0x004a,
    0x0000, 0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a,
    0x0000, 0x005e, 0x0000, 0x0062, 0x0000, 0x0066, 0x0000, 0x006a,
    0x0000, 0x006e, 0x0000, 0x0072, 0x0000, 0x0076, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table40_emit_[16] = {
    table40_0_emit_,  table40_1_emit_,  table40_2_emit_,  table40_3_emit_,
    table40_4_emit_,  table40_5_emit_,  table40_6_emit_,  table40_7_emit_,
    table40_8_emit_,  table40_9_emit_,  table40_10_emit_, table40_11_emit_,
    table40_12_emit_, table40_13_emit_, table40_14_emit_, table40_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table40_ops_[16] = {
    table18_2_ops_,  table18_2_ops_,  table18_2_ops_,  table18_2_ops_,
    table18_2_ops_,  table18_4_ops_,  table18_4_ops_,  table18_4_ops_,
    table18_4_ops_,  table18_4_ops_,  table18_4_ops_,  table40_11_ops_,
    table40_12_ops_, table40_13_ops_, table40_14_ops_, table40_15_ops_,
};
const uint8_t HuffDecoderCommon::table33_0_emit_[1] = {0xbc};
const uint8_t HuffDecoderCommon::table33_2_emit_[1] = {0xbf};
const uint8_t HuffDecoderCommon::table33_4_emit_[1] = {0xc5};
const uint8_t HuffDecoderCommon::table33_6_emit_[1] = {0xe7};
const uint8_t HuffDecoderCommon::table33_8_emit_[1] = {0xef};
const uint8_t HuffDecoderCommon::table33_10_emit_[1] = {0x09};
const uint16_t HuffDecoderCommon::table33_10_ops_[64] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table33_11_emit_[1] = {0x8e};
const uint8_t HuffDecoderCommon::table33_12_emit_[1] = {0x90};
const uint8_t HuffDecoderCommon::table33_13_emit_[1] = {0x91};
const uint8_t HuffDecoderCommon::table33_14_emit_[1] = {0x94};
const uint8_t HuffDecoderCommon::table33_15_emit_[1] = {0x9f};
const uint8_t HuffDecoderCommon::table33_16_emit_[1] = {0xab};
const uint8_t HuffDecoderCommon::table33_17_emit_[1] = {0xce};
const uint8_t HuffDecoderCommon::table33_18_emit_[1] = {0xd7};
const uint8_t HuffDecoderCommon::table33_19_emit_[1] = {0xe1};
const uint8_t HuffDecoderCommon::table33_20_emit_[1] = {0xec};
const uint8_t HuffDecoderCommon::table33_21_emit_[1] = {0xed};
const uint8_t HuffDecoderCommon::table33_22_emit_[2] = {0xc7, 0xcf};
const uint16_t HuffDecoderCommon::table33_22_ops_[64] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026};
const uint8_t HuffDecoderCommon::table33_23_emit_[2] = {0xea, 0xeb};
const uint8_t HuffDecoderCommon::table33_24_emit_[4] = {0xc0, 0xc1, 0xc8, 0xc9};
const uint16_t HuffDecoderCommon::table33_24_ops_[64] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067};
const uint8_t HuffDecoderCommon::table33_25_emit_[4] = {0xca, 0xcd, 0xd2, 0xd5};
const uint8_t HuffDecoderCommon::table33_26_emit_[4] = {0xda, 0xdb, 0xee, 0xf0};
const uint8_t HuffDecoderCommon::table33_27_emit_[5] = {0xf2, 0xf3, 0xff, 0xcb,
                                                        0xcc};
const uint16_t HuffDecoderCommon::table33_27_ops_[64] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088};
const uint8_t HuffDecoderCommon::table33_28_emit_[8] = {0xd3, 0xd4, 0xd6, 0xdd,
                                                        0xde, 0xdf, 0xf1, 0xf4};
const uint16_t HuffDecoderCommon::table33_28_ops_[64] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
    0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
    0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
    0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8};
const uint8_t HuffDecoderCommon::table33_29_emit_[8] = {0xf5, 0xf6, 0xf7, 0xf8,
                                                        0xfa, 0xfb, 0xfc, 0xfd};
const uint8_t HuffDecoderCommon::table33_30_emit_[15] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12};
const uint16_t HuffDecoderCommon::table33_30_ops_[64] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0089, 0x0089, 0x0089, 0x0089,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x0109, 0x0109, 0x0109, 0x0109,
    0x0129, 0x0129, 0x0129, 0x0129, 0x0149, 0x0149, 0x0149, 0x0149,
    0x0169, 0x0169, 0x0169, 0x0169, 0x0189, 0x0189, 0x0189, 0x0189,
    0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01c9, 0x01c9, 0x01c9, 0x01c9};
const uint8_t HuffDecoderCommon::table33_31_emit_[18] = {
    0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c,
    0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table33_31_ops_[64] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0089, 0x0089, 0x0089, 0x0089, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00e9, 0x00e9, 0x00e9, 0x00e9,
    0x0109, 0x0109, 0x0109, 0x0109, 0x0129, 0x0129, 0x0129, 0x0129,
    0x0149, 0x0149, 0x0149, 0x0149, 0x0169, 0x0169, 0x0169, 0x0169,
    0x0189, 0x0189, 0x0189, 0x0189, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
    0x01c9, 0x01c9, 0x01c9, 0x01c9, 0x01eb, 0x020b, 0x022b, 0x001b};
const uint8_t* const HuffDecoderCommon::table33_emit_[32] = {
    table33_0_emit_,  table33_0_emit_,  table33_2_emit_,  table33_2_emit_,
    table33_4_emit_,  table33_4_emit_,  table33_6_emit_,  table33_6_emit_,
    table33_8_emit_,  table33_8_emit_,  table33_10_emit_, table33_11_emit_,
    table33_12_emit_, table33_13_emit_, table33_14_emit_, table33_15_emit_,
    table33_16_emit_, table33_17_emit_, table33_18_emit_, table33_19_emit_,
    table33_20_emit_, table33_21_emit_, table33_22_emit_, table33_23_emit_,
    table33_24_emit_, table33_25_emit_, table33_26_emit_, table33_27_emit_,
    table33_28_emit_, table33_29_emit_, table33_30_emit_, table33_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table33_ops_[32] = {
    table10_8_ops_,  table10_8_ops_,  table10_8_ops_,  table10_8_ops_,
    table10_8_ops_,  table10_8_ops_,  table10_8_ops_,  table10_8_ops_,
    table10_8_ops_,  table10_8_ops_,  table33_10_ops_, table33_10_ops_,
    table33_10_ops_, table33_10_ops_, table33_10_ops_, table33_10_ops_,
    table33_10_ops_, table33_10_ops_, table33_10_ops_, table33_10_ops_,
    table33_10_ops_, table33_10_ops_, table33_22_ops_, table33_22_ops_,
    table33_24_ops_, table33_24_ops_, table33_24_ops_, table33_27_ops_,
    table33_28_ops_, table33_28_ops_, table33_30_ops_, table33_31_ops_,
};
}  // namespace geometry_9_10_11
}  // namespace grpc_core
