# RBE toolchain configuration (Linux and Windows)

## Linux
The `rbe_ubuntu2004` directory contains the autogenerated toolchain configuration for linux RBE.
Run `generate_linux_rbe_configs.sh` to regenerate.

## Windows

The `rbe_windows_bazel_6.3.2_vs2019` directory contains the autogenerated toolchain configuration for windows RBE.
The configuration was generated by the `rbe_configs_gen` tool (just as the linux RBE config),
but since it's a windows configuration, it needs to be run on a windows machine.

In order to regenerate:
- Clone `grpc` repository in a kokoro debug windows VM (see internal documentation for how to create one)
- Run `generate_windows_rbe_configs.sh` to regenerate the configs locally on the VM.
- Copy the generated configs back to your workstation (e.g. via `gcloud compute scp` command)

Note that the bazel version denotes the bazel version that was used to generate the toolchain configuration. The configuration
can be use with different bazel versions (as long as it works).

Also see go/rbe-windows-user-guide

# Windows RBE docker image

The `dockerfile/rbe_windows2019` directory contains the dockerfile to rebuild the docker image we use on RBE windows workers. See go/rbe-windows-user-guide.

Note that for linux, we use a docker image under `tools/dockerfile` (since for Linux RBE docker image is simply of the testing docker images
we maintain)

## How to rebuild the Windows RBE docker image and use it for Windows RBE

On a kokoro debug windows VM, run the following:
- `docker build -t us-docker.pkg.dev/grpc-testing/testing-images-public/rbe_windows2019 third_party/toolchains/dockerfile/rbe_windows2019`
- To be able to authenticate when pushing the image to GAR, run `gcloud auth configure-docker us-docker.pkg.dev`
- `docker push us-docker.pkg.dev/grpc-testing/testing-images-public/rbe_windows2019`
- Update the `generate_windows_rbe_configs.sh` with the newly built & pushed image's SHA256 digest.
- Regenerate the Windows RBE toolchain with the instructions above.
