/*
 * SMP support for R-Mobile / SH-Mobile
 *
 * Copyright (C) 2014-2015  Renesas Electronics Corporation
 * Copyright (C) 2010  Magnus Damm
 * Copyright (C) 2010  Takashi Yoshii
 *
 * Based on vexpress, Copyright (c) 2003 ARM Limited, All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/init.h>
#include <linux/linkage.h>
#include <linux/threads.h>
#include <asm/memory.h>

	__CPUINIT

#ifdef CONFIG_SMP
ENTRY(shmobile_invalidate_start)
	bl	v7_invalidate_l1

	mrc	p15, 0, r0, c0, c0, 0		/* get Main ID */
	ubfx	r1, r0, #4, #4			/* r1=Lo 4bit of Primary Part */
	cmp	r1, #0x07
	bne	1f
	ubfx	r1, r0, #8, #8			/* r1=Hi 8bit of Primary Part */
	cmp	r1, #0xC0
	bne	1f
	/* CA7 setup */
	/* CNTVOFF has to be initialized either from non-secure Hypervisor
	 * mode or secure Monitor mode with SCR.NS==1. If TrustZone is enabled
	 * then it should be handled by the secure code */
	cps	0x16
	mrc	p15, 0, r1, c1, c1, 0		/* get Secure Config */
	orr	r0, r1, #1
	mcr	p15, 0, r0, c1, c1, 0		/* Set Non Secure bit */
	isb
	mov	r0, #0
	mcrr	p15, 4, r0, r0, c14		/* CNTVOFF = 0 */
	isb
	mcr	p15, 0, r1, c1, c1, 0		/* Set Secure bit */
	isb
	cps	0x13
1:

	b	secondary_startup
ENDPROC(shmobile_invalidate_start)
#endif

ENTRY(rcar_cpu_resume)
	bl	v7_invalidate_l1
	bl	rcar_l2_restore
	ldr     r0, 1f
	bx	r0
ENDPROC(rcar_cpu_resume)

ENTRY(rcar_l2_restore)
	ldr	r1, 2f
	tst	r1, #1			@ is CA15
	beq	_exit_init_l2_a15	@ is CA7, skip L2(A)CTLR setting

	ldr	r1, 3f
	mcr 	p15, 1, r1, c9 , c0, 2

	ldr	r1, 4f
	mcr	p15, 1, r1, c15, c0, 0
_exit_init_l2_a15:

	bx	lr
ENDPROC(rcar_l2_restore)

	.globl	cpu_resume_phys_addr
cpu_resume_phys_addr:
1:	.space	4
	.globl	is_a15_l2shutdown
is_a15_l2shutdown:
2:	.space	4
	.globl	l2ctlr_value
l2ctlr_value:
3:	.space	4
	.globl	l2actlr_value
l2actlr_value:
4:	.space	4

/*
 * Reset vector for secondary CPUs.
 * This will be mapped at address 0 by SBAR register.
 * We need _long_ jump to the physical address.
 */
	.arm
	.align  12
ENTRY(shmobile_boot_vector)
	ldr     r0, 2f
	ldr     r1, 1f
	bx	r1

ENDPROC(shmobile_boot_vector)

	.align	2
	.globl	shmobile_boot_fn
shmobile_boot_fn:
1:	.space	4
	.globl	shmobile_boot_arg
shmobile_boot_arg:
2:	.space	4
	.globl	shmobile_boot_size
shmobile_boot_size:
	.long	. - shmobile_boot_vector

/*
 * Per-CPU SMP boot function/argument selection code based on MPIDR
 */

ENTRY(shmobile_smp_boot)
						@ r0 = MPIDR_HWID_BITMASK
	mrc	p15, 0, r1, c0, c0, 5		@ r1 = MPIDR
	and	r0, r1, r0			@ r0 = cpu_logical_map() value
	mov	r1, #0				@ r1 = CPU index
	adr	r5, 1f				@ array of per-cpu mpidr values
	adr	r6, 2f				@ array of per-cpu functions
	adr	r7, 3f				@ array of per-cpu arguments

shmobile_smp_boot_find_mpidr:
	ldr	r8, [r5, r1, lsl #2]
	cmp	r8, r0
	bne	shmobile_smp_boot_next

	ldr	r9, [r6, r1, lsl #2]
	cmp	r9, #0
	bne	shmobile_smp_boot_found

shmobile_smp_boot_next:
	add	r1, r1, #1
	cmp	r1, #NR_CPUS
	blo	shmobile_smp_boot_find_mpidr

	b	shmobile_smp_sleep

shmobile_smp_boot_found:
	ldr	r0, [r7, r1, lsl #2]
	mov	pc, r9
ENDPROC(shmobile_smp_boot)

ENTRY(shmobile_smp_sleep)
	wfi
	b	shmobile_smp_boot
ENDPROC(shmobile_smp_sleep)

	.globl	shmobile_smp_mpidr
shmobile_smp_mpidr:
1:	.space	NR_CPUS * 4
	.globl	shmobile_smp_fn
shmobile_smp_fn:
2:	.space	NR_CPUS * 4
	.globl	shmobile_smp_arg
shmobile_smp_arg:
3:	.space	NR_CPUS * 4
