// SPDX-License-Identifier: GPL-2.0
/*
 * Omnivision OV2312 RGB-IR Image Sensor driver
 *
 * Copyright (c) 2022 Jai Luthra <j-luthra@ti.com>
 */

#include <linux/types.h>
#include <linux/media-bus-format.h>

#define OV2312_CHIP_ID	0x2311
#define OV2312_FRAMERATE_DEFAULT 60

#define OV2312_OUT_WIDTH	1600
#define OV2312_OUT_HEIGHT	1300
#define OV2312_VTS		0x0588

#define OV2312_SYS_MODE_SEL	0x0100
#define OV2312_SC_CHIP_ID_HI	0x300a
#define OV2312_SC_CHIP_ID_LO	0x300b
#define OV2312_AEC_PK_EXPO_HI	0x3501
#define OV2312_AEC_PK_EXPO_LO	0x3502
#define OV2312_AEC_PK_AGAIN_HI	0x3508
#define OV2312_AEC_PK_AGAIN_LO	0x3509
#define OV2312_AEC_PK_DGAIN_HI	0x350a
#define OV2312_AEC_PK_DGAIN_LO	0x350b
#define OV2312_TIMING_VFLIP	0x3820
#define OV2312_TIMING_HFLIP	0x3821

/* Exposure control */
#define OV2312_EXPOSURE_MAX	(OV2312_VTS - 12)
#define OV2312_EXPOSURE_DEFAULT 0x057c
#define OV2312_IR_EXPOSURE	0x0090
#define OV2312_IR_STROBE	OV2312_IR_EXPOSURE
#define OV2312_IR_STROBE_START	(OV2312_VTS - OV2312_IR_EXPOSURE - 7)

/* Analog gain control */
#define OV2312_AGAIN_MAX	0x1FF
#define OV2312_AGAIN_DEFAULT	0x010

/* Digital gain control */
#define OV2312_DGAIN_MAX	0x0FFF
#define OV2312_DGAIN_DEFAULT	0x0100

static const struct v4l2_area ov2312_framesizes[] = {
	{
		.width		= OV2312_OUT_WIDTH,
		.height		= OV2312_OUT_HEIGHT,
	},
};

static const u32 ov2312_mbus_formats[] = {
	MEDIA_BUS_FMT_SBGGI10_1X10,
};


static const struct regmap_config ov2312_regmap_config = {
	.reg_bits = 16,
	.val_bits = 8,
};

static const struct reg_sequence ov2312_1600x1300_60fps_AB[] = {
	{0x0103, 0x01},
	{0x0100, 0x00},
	{0x010c, 0x02},
	{0x010b, 0x01},
	{0x0300, 0x01},
	{0x0302, 0x32},
	{0x0303, 0x00},
	{0x0304, 0x03},
	{0x0305, 0x02},
	{0x0306, 0x01},
	{0x030d, 0x5a},
	{0x030e, 0x04},
	{0x3001, 0x02},
	{0x3004, 0x00},
	{0x3005, 0x00},
	{0x3006, 0x0a},
	{0x3011, 0x0d},
	{0x3014, 0x04},
	{0x301c, 0xf0},
	{0x3020, 0x20},
	{0x302c, 0x00},
	{0x302d, 0x00},
	{0x302e, 0x00},
	{0x302f, 0x03},
	{0x3030, 0x10},
	{0x303f, 0x03},
	{0x3103, 0x00},
	{0x3106, 0x08},
	{0x31ff, 0x01},
	{0x3501, 0x05},
	{0x3502, 0x7c},
	{0x3506, 0x00},
	{0x3507, 0x00},
	{0x3620, 0x67},
	{0x3633, 0x78},
	{0x3662, 0x65},
	{0x3664, 0xb0},
	{0x3666, 0x70},
	{0x3670, 0x68},
	{0x3674, 0x10},
	{0x3675, 0x00},
	{0x367e, 0x90},
	{0x3680, 0x84},
	{0x36a2, 0x04},
	{0x36a3, 0x80},
	{0x36b0, 0x00},
	{0x3700, 0x35},
	{0x3704, 0x39},
	{0x370a, 0x50},
	{0x3712, 0x00},
	{0x3713, 0x02},
	{0x3778, 0x00},
	{0x379b, 0x01},
	{0x379c, 0x10},
	{0x3800, 0x00},
	{0x3801, 0x00},
	{0x3802, 0x00},
	{0x3803, 0x00},
	{0x3804, 0x06},
	{0x3805, 0x4f},
	{0x3806, 0x05},
	{0x3807, 0x23},
	{0x3808, 0x06},
	{0x3809, 0x40},
	{0x380a, 0x05},
	{0x380b, 0x14},
	{0x380c, 0x03},
	{0x380d, 0xa8},
	{0x380e, (OV2312_VTS >> 8) & 0xff},
	{0x380f, OV2312_VTS & 0xff},
	{0x3810, 0x00},
	{0x3811, 0x08},
	{0x3812, 0x00},
	{0x3813, 0x08},
	{0x3814, 0x11},
	{0x3815, 0x11},
	{0x3816, 0x00},
	{0x3817, 0x01},
	{0x3818, 0x00},
	{0x3819, 0x05},
	{0x382b, 0x5a},
	{0x382c, 0x0a},
	{0x382d, 0xf8},
	{0x3881, 0x44},
	{0x3882, 0x02},
	{0x3883, 0x8c},
	{0x3885, 0x07},
	{0x389d, 0x03},
	{0x38a6, 0x00},
	{0x38a7, 0x01},
	{0x38b3, 0x07},
	{0x38b1, 0x00},
	{0x38e5, 0x02},
	{0x38e7, 0x00},
	{0x38e8, 0x00},
	{0x3910, 0xff},
	{0x3911, 0xff},
	{0x3912, 0x08},
	{0x3913, 0x00},
	{0x3914, 0x00},
	{0x3915, 0x00},
	{0x391c, 0x00},
	{0x3920, 0xff},
	{0x3921, 0x80},
	{0x3922, 0x00},
	{0x3923, 0x00},
	{0x3924, 0x05},
	{0x3925, 0x00},
	{0x3926, 0x00},
	{0x3927, 0x00},
	{0x3928, 0x1a},
	{0x392d, 0x03},
	{0x392e, 0xa8},
	{0x392f, 0x08},
	{0x4001, 0x00},
	{0x4003, 0x40},
	{0x4008, 0x04},
	{0x4009, 0x1b},
	{0x400c, 0x04},
	{0x400d, 0x1b},
	{0x4010, 0xf4},
	{0x4011, 0x00},
	{0x4016, 0x00},
	{0x4017, 0x04},
	{0x4042, 0x11},
	{0x4043, 0x70},
	{0x4045, 0x00},
	{0x4409, 0x5f},
	{0x4509, 0x00},
	{0x450b, 0x00},
	{0x4600, 0x00},
	{0x4601, 0x80},
	{0x4708, 0x09},
	{0x470c, 0x81},
	{0x4710, 0x06},
	{0x4711, 0x00},
	{0x4800, 0x00},
	{0x481f, 0x30},
	{0x4837, 0x14},
	{0x4f00, 0x00},
	{0x4f07, 0x00},
	{0x4f08, 0x03},
	{0x4f09, 0x08},
	{0x4f0c, 0x05},
	{0x4f0d, 0xb4},
	{0x4f10, 0x00},
	{0x4f11, 0x00},
	{0x4f12, 0x07},
	{0x4f13, 0xe2},
	{0x5000, 0x9f},
	{0x5001, 0x20},
	{0x5026, 0x00},
	{0x5c00, 0x00},
	{0x5c01, 0x2c},
	{0x5c02, 0x00},
	{0x5c03, 0x7f},
	{0x5e00, 0x00},
	{0x5e01, 0x41},
	{0x38b1, 0x02},
	{0x0100, 0x01},
	{0x3006, 0x08},/* Strobe control  */
	{0x3004, 0x02},
	{0x3007, 0x02},
	{0x301c, 0x20},
	{0x3020, 0x20},
	{0x3025, 0x02},
	{0x382c, 0x0a},
	{0x382d, 0xf8},
	{0x3920, 0xff},
	{0x3921, 0x00},
	{0x3923, 0x00},
	{0x3924, 0x00},
	{0x3925, 0x00},
	{0x3926, 0x00},
	{0x3927, 0x00},
	{0x3928, 0x80},
	{0x392b, 0x00},
	{0x392c, 0x00},
	{0x392d, 0x03},
	{0x392e, 0xa8},
	{0x392f, 0x0b},
	{0x38b3, 0x07},
	{0x3885, 0x07},
	{0x382b, 0x3a},
	{0x3670, 0x68},
	{0x301C, 0xF0},/* AB mode - Group auto switch example setting */
	{0x3209, 0x01},/* Stay in Group A for 1 Frame */
	{0x320A, 0x01},/* Stay in Group B for 1 Frame */
	{0x320B, 0x00},
	{0x320C, 0x00},
	{0x3208, 0x01},/* Group A (IR Dominant VC0) */
	{OV2312_AEC_PK_EXPO_HI, (OV2312_IR_EXPOSURE >> 8) & 0xff},
	{OV2312_AEC_PK_EXPO_LO, OV2312_IR_EXPOSURE & 0xff},
	{OV2312_AEC_PK_AGAIN_HI, 0x01},
	{OV2312_AEC_PK_AGAIN_LO, 0x00},
	{OV2312_AEC_PK_DGAIN_HI, 0x01},
	{OV2312_AEC_PK_DGAIN_LO, 0x00},
	{0x3920, 0xff},/* IR Strobe duty cycle */
	{0x3927, (OV2312_IR_STROBE >> 8) & 0xff},
	{0x3928, OV2312_IR_STROBE & 0xff},
	{0x3929, (OV2312_IR_STROBE_START >> 8) & 0xff},
	{0x392a, OV2312_IR_STROBE_START & 0xff},
	{0x4813, 0x01},/* VC=1. This register takes effect from next frame */
	{0x3208, 0x11},

};
