/* SPDX-License-Identifier: GPL-2.0 */
/*
 * firmware header
 *
 * Copyright (c) Imagination Technologies Ltd.
 * Copyright (c) 2021 Texas Instruments Incorporated - http://www.ti.com/
 *
 * Authors:
 *	Sunita Nadampalli <sunitan@ti.com>
 *
 * Re-written for upstreming
 *	Sidraya Jayagond <sidraya.bj@pathpartnertech.com>
 */

#ifndef _REGCONV_H_topazhp_core_regs_h
#define _REGCONV_H_topazhp_core_regs_h

/* Register CR_LRITC_CACHE_CHUNK_CONFIG */
#define MASK_TOPAZHP_CR_CACHE_CHUNKS_PRIORITY 0x000000FF
#define SHIFT_TOPAZHP_CR_CACHE_CHUNKS_PRIORITY 0
#define MASK_TOPAZHP_CR_CACHE_CHUNKS_MAX 0x0000FF00
#define SHIFT_TOPAZHP_CR_CACHE_CHUNKS_MAX 8
#define MASK_TOPAZHP_CR_CACHE_CHUNKS_PER_MB 0x00FF0000
#define SHIFT_TOPAZHP_CR_CACHE_CHUNKS_PER_MB 16

/* Register CR_SEQ_CUR_PIC_ROW_STRIDE */
#define MASK_TOPAZHP_CR_CUR_PIC_LUMA_STRIDE 0x0000FFC0
#define SHIFT_TOPAZHP_CR_CUR_PIC_LUMA_STRIDE 6
#define MASK_TOPAZHP_CR_CUR_PIC_CHROMA_STRIDE 0xFFC00000
#define SHIFT_TOPAZHP_CR_CUR_PIC_CHROMA_STRIDE 22

/* Register CR_SEQUENCER_CONFIG */
#define MASK_TOPAZHP_CR_ENCODER_STANDARD 0x00000007
#define SHIFT_TOPAZHP_CR_ENCODER_STANDARD 0
#define TOPAZHP_CR_ENCODER_STANDARD_H264		0x00000002		/* H264 encode */
#define MASK_TOPAZHP_CR_FRAME_STORE_FORMAT 0x00000030
#define SHIFT_TOPAZHP_CR_FRAME_STORE_FORMAT 4

/* 4:2:0 frame, with Luma, Cb and Cr all in separate planes (if the frame
 * store actually contains 4:2:2 chroma, the chroma stride can be doubled
 * so that it is read as 4:2:0)
 */
#define MASK_TOPAZHP_CR_FRAME_STORE_CHROMA_SWAP 0x00000040
#define SHIFT_TOPAZHP_CR_FRAME_STORE_CHROMA_SWAP 6
#define MASK_TOPAZHP_CR_FIELD_MODE  0x00000080
#define SHIFT_TOPAZHP_CR_FIELD_MODE 7
#define MASK_TOPAZHP_CR_REF_PIC0_VALID 0x00000100
#define SHIFT_TOPAZHP_CR_REF_PIC0_VALID 8
#define MASK_TOPAZHP_CR_REF_PIC1_VALID 0x00000200
#define SHIFT_TOPAZHP_CR_REF_PIC1_VALID 9
#define MASK_TOPAZHP_CR_REF_PIC1_EQUAL_PIC0 0x00000400
#define SHIFT_TOPAZHP_CR_REF_PIC1_EQUAL_PIC0 10
#define MASK_TOPAZHP_CR_ABOVE_OUT_OF_SLICE_VALID 0x00000800
#define SHIFT_TOPAZHP_CR_ABOVE_OUT_OF_SLICE_VALID 11
#define MASK_TOPAZHP_CR_TEMPORAL_COL_IN_VALID 0x00001000
#define SHIFT_TOPAZHP_CR_TEMPORAL_COL_IN_VALID 12
#define MASK_TOPAZHP_CR_TEMPORAL_PIC0_BELOW_IN_VALID 0x00002000
#define SHIFT_TOPAZHP_CR_TEMPORAL_PIC0_BELOW_IN_VALID 13
#define MASK_TOPAZHP_CR_TEMPORAL_PIC1_BELOW_IN_VALID 0x00004000
#define SHIFT_TOPAZHP_CR_TEMPORAL_PIC1_BELOW_IN_VALID 14
#define MASK_TOPAZHP_CR_DEBLOCK_ENABLE 0x00008000
#define SHIFT_TOPAZHP_CR_DEBLOCK_ENABLE 15
#define MASK_TOPAZHP_CR_WRITE_TEMPORAL_COL_VALID 0x00010000
#define SHIFT_TOPAZHP_CR_WRITE_TEMPORAL_COL_VALID 16
#define MASK_TOPAZHP_CR_WRITE_TEMPORAL_PIC0_BELOW_VALID 0x00020000
#define SHIFT_TOPAZHP_CR_WRITE_TEMPORAL_PIC0_BELOW_VALID 17
#define MASK_TOPAZHP_CR_WRITE_TEMPORAL_PIC1_BELOW_VALID 0x00040000
#define SHIFT_TOPAZHP_CR_WRITE_TEMPORAL_PIC1_BELOW_VALID 18
#define MASK_TOPAZHP_CR_WRITE_MB_FIRST_STAGE_VALID 0x00200000
#define SHIFT_TOPAZHP_CR_WRITE_MB_FIRST_STAGE_VALID 21
#define MASK_TOPAZHP_CR_MB_CONTROL_IN_VALID 0x00800000
#define SHIFT_TOPAZHP_CR_MB_CONTROL_IN_VALID 23
#define MASK_TOPAZHP_CR_BEST_MULTIPASS_OUT_VALID 0x10000000
#define SHIFT_TOPAZHP_CR_BEST_MULTIPASS_OUT_VALID 28
#define MASK_TOPAZHP_CR_BEST_MVS_OUT_DISABLE 0x40000000
#define SHIFT_TOPAZHP_CR_BEST_MVS_OUT_DISABLE 30
#define MASK_TOPAZHP_CR_SLICE_TYPE  0x00030000
#define SHIFT_TOPAZHP_CR_SLICE_TYPE 16
#define TOPAZHP_CR_SLICE_TYPE_B_SLICE		0x00000002		/* B-slice */
#define TOPAZHP_CR_SLICE_TYPE_P_SLICE		0x00000001		/* P-slice */
#define TOPAZHP_CR_SLICE_TYPE_I_SLICE		0x00000000		/* I-slice */
#define MASK_TOPAZHP_CR_MVCALC_RESTRICT_PICTURE 0x00010000
#define SHIFT_TOPAZHP_CR_MVCALC_RESTRICT_PICTURE 16

/* Register CR_MVCALC_CONFIG */
#define MASK_TOPAZHP_CR_MVCALC_GRID_MB_X_STEP 0x0000000F
#define SHIFT_TOPAZHP_CR_MVCALC_GRID_MB_X_STEP 0
#define MASK_TOPAZHP_CR_MVCALC_GRID_MB_Y_STEP 0x00000F00
#define SHIFT_TOPAZHP_CR_MVCALC_GRID_MB_Y_STEP 8
#define MASK_TOPAZHP_CR_MVCALC_GRID_SUB_STEP 0x000F0000
#define SHIFT_TOPAZHP_CR_MVCALC_GRID_SUB_STEP 16
#define MASK_TOPAZHP_CR_MVCALC_GRID_DISABLE 0x00800000
#define SHIFT_TOPAZHP_CR_MVCALC_GRID_DISABLE 23
#define MASK_TOPAZHP_CR_MVCALC_IPE0_JITTER_FACTOR 0x03000000
#define SHIFT_TOPAZHP_CR_MVCALC_IPE0_JITTER_FACTOR 24
#define MASK_TOPAZHP_CR_MVCALC_IPE1_JITTER_FACTOR 0x0C000000
#define SHIFT_TOPAZHP_CR_MVCALC_IPE1_JITTER_FACTOR 26
#define MASK_TOPAZHP_CR_MVCALC_JITTER_POINTER_RST 0x10000000
#define MASK_TOPAZHP_CR_MVCALC_NO_PSEUDO_DUPLICATES 0x20000000
#define SHIFT_TOPAZHP_CR_MVCALC_NO_PSEUDO_DUPLICATES 29
#define MASK_TOPAZHP_CR_MVCALC_DUP_VEC_MARGIN 0xC0000000
#define SHIFT_TOPAZHP_CR_MVCALC_DUP_VEC_MARGIN 30

/* Register CR_MVCALC_COLOCATED */
#define MASK_TOPAZHP_CR_COL_DIST_SCALE_FACT 0x000007FF
#define SHIFT_TOPAZHP_CR_COL_DIST_SCALE_FACT 0

/* Register CR_MVCALC_BELOW */
#define MASK_TOPAZHP_CR_PIC0_DIST_SCALE_FACTOR 0x000007FF
#define SHIFT_TOPAZHP_CR_PIC0_DIST_SCALE_FACTOR 0
#define MASK_TOPAZHP_CR_PIC1_DIST_SCALE_FACTOR 0x07FF0000
#define SHIFT_TOPAZHP_CR_PIC1_DIST_SCALE_FACTOR 16

/* Register CR_PREFETCH_QP */
#define MASK_TOPAZHP_CR_SKIPPED_CODED_SCALE_IDX 0x00007000
#define SHIFT_TOPAZHP_CR_SKIPPED_CODED_SCALE_IDX 12
#define MASK_TOPAZHP_CR_INTER_INTRA_SCALE_IDX 0x00000700
#define SHIFT_TOPAZHP_CR_INTER_INTRA_SCALE_IDX 8

/* Register CR_MB_HOST_CONTROL */
#define MASK_TOPAZHP_CR_MB_HOST_QP  0x00000001
#define SHIFT_TOPAZHP_CR_MB_HOST_QP 0
#define MASK_TOPAZHP_CR_MB_HOST_SKIPPED_CODED_SCALE 0x00000002
#define SHIFT_TOPAZHP_CR_MB_HOST_SKIPPED_CODED_SCALE 1
#define MASK_TOPAZHP_CR_MB_HOST_INTER_INTRA_SCALE 0x00000004
#define SHIFT_TOPAZHP_CR_MB_HOST_INTER_INTRA_SCALE 2
#define MASK_TOPAZHP_CR_H264COMP_8X8_TRANSFORM 0x00000001
#define SHIFT_TOPAZHP_CR_H264COMP_8X8_TRANSFORM 0
#define MASK_TOPAZHP_CR_H264COMP_CONSTRAINED_INTRA 0x00000002
#define SHIFT_TOPAZHP_CR_H264COMP_CONSTRAINED_INTRA 1
#define MASK_TOPAZHP_CR_H264COMP_8X8_CAVLC 0x00000004
#define SHIFT_TOPAZHP_CR_H264COMP_8X8_CAVLC 2
#define MASK_TOPAZHP_CR_H264COMP_DEFAULT_SCALING_LIST 0x00000008
#define SHIFT_TOPAZHP_CR_H264COMP_DEFAULT_SCALING_LIST 3
#define MASK_TOPAZHP_CR_H264COMP_ADAPT_ROUND_ENABLE 0x00000010
#define SHIFT_TOPAZHP_CR_H264COMP_ADAPT_ROUND_ENABLE 4
#define MASK_TOPAZHP_CR_H264COMP_VIDEO_CONF_ENABLE 0x00000020
#define SHIFT_TOPAZHP_CR_H264COMP_VIDEO_CONF_ENABLE 5
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_8X8_INTER_LUMA_ENABLE 0x00000080
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_8X8_INTER_LUMA_ENABLE 7
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTER_CR_ENABLE 0x00000100
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTER_CR_ENABLE 8
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTER_CB_ENABLE 0x00000200
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTER_CB_ENABLE 9
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTER_LUMA_ENABLE 0x00000400
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTER_LUMA_ENABLE 10
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_8X8_INTRA_LUMA_ENABLE 0x00000800
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_8X8_INTRA_LUMA_ENABLE 11
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTRA_CR_ENABLE 0x00001000
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTRA_CR_ENABLE 12
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTRA_CB_ENABLE 0x00002000
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTRA_CB_ENABLE 13
#define MASK_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTRA_LUMA_ENABLE 0x00004000
#define SHIFT_TOPAZHP_CR_H264COMP_CUSTOM_QUANT_4X4_INTRA_LUMA_ENABLE 14
#define MASK_TOPAZHP_CR_H264COMP_LOSSLESS 0x00010000
#define SHIFT_TOPAZHP_CR_H264COMP_LOSSLESS 16
#define MASK_TOPAZHP_CR_H264COMP_LOSSLESS_8X8_PREFILTER 0x00020000
#define SHIFT_TOPAZHP_CR_H264COMP_LOSSLESS_8X8_PREFILTER 17

/* The Intra8x8 Pre-filter is performed in Lossless Mode. H.264 standard lossless. */
#define TOPAZHP_CR_H264COMP_LOSSLESS_8X8_PREFILTER_FILTER		0x00000001

/* The Intra8x8 Pre-filter is bypassed in Lossless Mode. x264  compatibility mode for lossless. */
#define TOPAZHP_CR_H264COMP_LOSSLESS_8X8_PREFILTER_BYPASS		0x00000000

/* Register CR_IPE_CONTROL */
#define MASK_TOPAZHP_CR_IPE_BLOCKSIZE 0x00000003
#define SHIFT_TOPAZHP_CR_IPE_BLOCKSIZE 0
#define MASK_TOPAZHP_CR_IPE_16X8_ENABLE 0x00000004
#define SHIFT_TOPAZHP_CR_IPE_16X8_ENABLE 2
#define MASK_TOPAZHP_CR_IPE_8X16_ENABLE 0x00000008
#define SHIFT_TOPAZHP_CR_IPE_8X16_ENABLE 3
#define MASK_TOPAZHP_CR_IPE_Y_FINE_SEARCH 0x00000030
#define SHIFT_TOPAZHP_CR_IPE_Y_FINE_SEARCH 4
#define MASK_TOPAZHP_CR_IPE_4X4_SEARCH 0x00000040
#define SHIFT_TOPAZHP_CR_IPE_4X4_SEARCH 6
#define MASK_TOPAZHP_CR_IPE_LRITC_BOUNDARY 0x00000300
#define SHIFT_TOPAZHP_CR_IPE_LRITC_BOUNDARY 8
#define MASK_TOPAZHP_CR_IPE_HIGH_LATENCY 0x00001000
#define SHIFT_TOPAZHP_CR_IPE_HIGH_LATENCY 12
#define MASK_TOPAZHP_CR_IPE_MV_NUMBER_RESTRICTION 0x00004000
#define SHIFT_TOPAZHP_CR_IPE_MV_NUMBER_RESTRICTION 14

/* Register CR_IPE_VECTOR_CLIPPING */
#define MASK_TOPAZHP_CR_IPE_VECTOR_CLIPPING_X 0x000000FF
#define SHIFT_TOPAZHP_CR_IPE_VECTOR_CLIPPING_X 0
#define MASK_TOPAZHP_CR_IPE_VECTOR_CLIPPING_Y 0x0000FF00
#define SHIFT_TOPAZHP_CR_IPE_VECTOR_CLIPPING_Y 8
#define MASK_TOPAZHP_CR_IPE_VECTOR_CLIPPING_ENABLED 0x00010000
#define SHIFT_TOPAZHP_CR_IPE_VECTOR_CLIPPING_ENABLED 16

/* Register CR_JMCOMP_CARC_CONTROL_0 */
#define MASK_TOPAZHP_CR_CARC_NEG_SCALE 0x3F000000
#define SHIFT_TOPAZHP_CR_CARC_NEG_SCALE 24
#define MASK_TOPAZHP_CR_CARC_NEG_RANGE 0x001F0000
#define SHIFT_TOPAZHP_CR_CARC_NEG_RANGE 16
#define MASK_TOPAZHP_CR_CARC_POS_SCALE 0x00003F00
#define SHIFT_TOPAZHP_CR_CARC_POS_SCALE 8
#define MASK_TOPAZHP_CR_CARC_POS_RANGE 0x0000001F
#define SHIFT_TOPAZHP_CR_CARC_POS_RANGE 0

/* Register CR_JMCOMP_CARC_CONTROL_1 */
#define MASK_TOPAZHP_CR_CARC_SHIFT  0x03000000
#define SHIFT_TOPAZHP_CR_CARC_SHIFT 24
#define MASK_TOPAZHP_CR_CARC_CUTOFF 0x00F00000
#define SHIFT_TOPAZHP_CR_CARC_CUTOFF 20
#define MASK_TOPAZHP_CR_CARC_THRESHOLD 0x0007FF00
#define SHIFT_TOPAZHP_CR_CARC_THRESHOLD 8
#define MASK_TOPAZHP_CR_SPE_MVD_CLIP_ENABLE 0x80000000
#define SHIFT_TOPAZHP_CR_SPE_MVD_CLIP_ENABLE 31

/* Register CR_PRED_COMB_CONTROL */
#define MASK_TOPAZHP_CR_INTRA4X4_DISABLE 0x00000001
#define SHIFT_TOPAZHP_CR_INTRA4X4_DISABLE 0
#define MASK_TOPAZHP_CR_INTRA8X8_DISABLE 0x00000002
#define SHIFT_TOPAZHP_CR_INTRA8X8_DISABLE 1
#define MASK_TOPAZHP_CR_INTRA16X16_DISABLE 0x00000004
#define SHIFT_TOPAZHP_CR_INTRA16X16_DISABLE 2
#define MASK_TOPAZHP_CR_INTER8X8_DISABLE 0x00000010
#define SHIFT_TOPAZHP_CR_INTER8X8_DISABLE 4
#define MASK_TOPAZHP_CR_B_PIC0_DISABLE 0x00000100
#define SHIFT_TOPAZHP_CR_B_PIC0_DISABLE 8
#define MASK_TOPAZHP_CR_B_PIC1_DISABLE 0x00000200
#define SHIFT_TOPAZHP_CR_B_PIC1_DISABLE 9
#define MASK_TOPAZHP_CR_INTER_INTRA_SCALE_ENABLE 0x00001000
#define SHIFT_TOPAZHP_CR_INTER_INTRA_SCALE_ENABLE 12
#define MASK_TOPAZHP_CR_CUMULATIVE_BIASES_ENABLE 0x00000800
#define SHIFT_TOPAZHP_CR_CUMULATIVE_BIASES_ENABLE 11
#define MASK_TOPAZHP_CR_SKIPPED_CODED_SCALE_ENABLE 0x00002000
#define SHIFT_TOPAZHP_CR_SKIPPED_CODED_SCALE_ENABLE 13

#endif
