/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Map;
import org.json.JSONObject;

public final class MethodCall {
    public final String method;
    public final Object arguments;

    public MethodCall(@NonNull String method, @Nullable Object arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    @Nullable
    public <T> T arguments() {
        return (T)this.arguments;
    }

    @Nullable
    public <T> T argument(@NonNull String key) {
        if (this.arguments == null) {
            return null;
        }
        if (this.arguments instanceof Map) {
            return (T)((Map)this.arguments).get(key);
        }
        if (this.arguments instanceof JSONObject) {
            return (T)((JSONObject)this.arguments).opt(key);
        }
        throw new ClassCastException();
    }

    public boolean hasArgument(@NonNull String key) {
        if (this.arguments == null) {
            return false;
        }
        if (this.arguments instanceof Map) {
            return ((Map)this.arguments).containsKey(key);
        }
        if (this.arguments instanceof JSONObject) {
            return ((JSONObject)this.arguments).has(key);
        }
        throw new ClassCastException();
    }
}

