/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.android.FlutterImageView;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;

public class PlatformOverlayView
extends FlutterImageView {
    @Nullable
    private AccessibilityEventsDelegate accessibilityDelegate;

    public PlatformOverlayView(@NonNull Context context, int width, int height, @NonNull AccessibilityEventsDelegate accessibilityDelegate) {
        super(context, width, height, FlutterImageView.SurfaceKind.overlay);
        this.accessibilityDelegate = accessibilityDelegate;
    }

    public PlatformOverlayView(@NonNull Context context) {
        this(context, 1, 1, (AccessibilityEventsDelegate)null);
    }

    public PlatformOverlayView(@NonNull Context context, @NonNull AttributeSet attrs) {
        this(context, 1, 1, (AccessibilityEventsDelegate)null);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        if (this.accessibilityDelegate != null && this.accessibilityDelegate.onAccessibilityHoverEvent(event, true)) {
            return true;
        }
        return super.onHoverEvent(event);
    }
}

