CIL (Common Intermediate Language)
===============
## Table of Contents

* [Introduction](cil_introduction.md#Introduction)
  * [Design Philosophy](cil_introduction.md#design-philosophy)
  * [Goals and Primary Features](cil_introduction.md#goals-and-primary-features)
  * [Design Overview](cil_introduction.md#design-overview)

* [CIL Information](cil_reference_guide.md#cil-information)
  * [Declarations](cil_reference_guide.md#declarations)
  * [Definitions](cil_reference_guide.md#definitions)
  * [Symbol Character Set](cil_reference_guide.md#symbol-character-set)
  * [String Character Set](cil_reference_guide.md#string-character-set)
  * [Comments](cil_reference_guide.md#comments)
  * [Namespaces](cil_reference_guide.md#namespaces)
  * [Global Namespace](cil_reference_guide.md#global-namespace)
  * [Expressions](cil_reference_guide.md#expressions)
  * [Name String](cil_reference_guide.md#name-string)
  * [Example CIL Policy](../test/policy.cil)

* [Access Vector Rules](cil_access_vector_rules.md#access-vector-rules)
  * [allow](cil_access_vector_rules.md#allow)
  * [auditallow](cil_access_vector_rules.md#auditallow)
  * [dontaudit](cil_access_vector_rules.md#dontaudit)
  * [neverallow](cil_access_vector_rules.md#neverallow)
  * [allowx](cil_access_vector_rules.md#allowx)
  * [auditallowx](cil_access_vector_rules.md#auditallowx)
  * [dontauditx](cil_access_vector_rules.md#dontauditx)
  * [neverallowx](cil_access_vector_rules.md#neverallowx)

* [Call / Macro Statements](cil_call_macro_statements.md#call--macro-statements)
  * [call](cil_call_macro_statements.md#call)
  * [macro](cil_call_macro_statements.md#macro)

* [Class and Permission Statements](cil_class_and_permission_statements.md#class-and-permission-statements)
  * [common](cil_class_and_permission_statements.md#common)
  * [classcommon](cil_class_and_permission_statements.md#classcommon)
  * [class](cil_class_and_permission_statements.md#class)
  * [classorder](cil_class_and_permission_statements.md#classorder)
  * [classpermission](cil_class_and_permission_statements.md#classpermission)
  * [classpermissionset](cil_class_and_permission_statements.md#classpermissionset)
  * [classmap](cil_class_and_permission_statements.md#classmap)
  * [classmapping](cil_class_and_permission_statements.md#classmapping)
  * [permissionx](cil_class_and_permission_statements.md#permissionx)

* [Conditional Statements](cil_conditional_statements.md#conditional-statements)
  * [boolean](cil_conditional_statements.md#boolean)
  * [booleanif](cil_conditional_statements.md#booleanif)
  * [tunable](cil_conditional_statements.md#tunable)
  * [tunableif](cil_conditional_statements.md#tunableif)

* [Constraint Statements](cil_constraint_statements.md#constraint-statements)
  * [constrain](cil_constraint_statements.md#constrain)
  * [validatetrans](cil_constraint_statements.md#validatetrans)
  * [mlsconstrain](cil_constraint_statements.md#mlsconstrain)
  * [mlsvalidatetrans](cil_constraint_statements.md#mlsvalidatetrans)

* [Container Statements](cil_container_statements.md#container-statements)
  * [block](cil_container_statements.md#block)
  * [blockabstract](cil_container_statements.md#blockabstract)
  * [blockinherit](cil_container_statements.md#blockinherit)
  * [optional](cil_container_statements.md#optional)
  * [in](cil_container_statements.md#in)

* [Context Statement](cil_context_statement.md#context-statement)
  * [context](cil_context_statement.md#context)

* [Default Object Statements](cil_default_object_statements.md#default-object-statements)
  * [defaultuser](cil_default_object_statements.md#defaultuser)
  * [defaultrole](cil_default_object_statements.md#defaultrole)
  * [defaulttype](cil_default_object_statements.md#defaulttype)
  * [defaultrange](cil_default_object_statements.md#defaultrange)

* [File Labeling Statements](cil_file_labeling_statements.md#file-labeling-statements)
  * [filecon](cil_file_labeling_statements.md#filecon)
  * [fsuse](cil_file_labeling_statements.md#fsuse)
  * [genfscon](cil_file_labeling_statements.md#genfscon)

* [Multi-Level Security Labeling Statements](cil_mls_labeling_statements.md#multi-level-security-labeling-statements)
  * [sensitivity](cil_mls_labeling_statements.md#sensitivity)
  * [sensitivityalias](cil_mls_labeling_statements.md#sensitivityalias)
  * [sensitivityaliasactual](cil_mls_labeling_statements.md#sensitivityaliasactual)
  * [sensitivityorder](cil_mls_labeling_statements.md#sensitivityorder)
  * [category](cil_mls_labeling_statements.md#category)
  * [categoryalias](cil_mls_labeling_statements.md#categoryalias)
  * [categoryaliasactual](cil_mls_labeling_statements.md#categoryaliasactual)
  * [categoryorder](cil_mls_labeling_statements.md#categoryorder)
  * [categoryset](cil_mls_labeling_statements.md#categoryset)
  * [sensitivitycategory](cil_mls_labeling_statements.md#sensitivitycategory)
  * [level](cil_mls_labeling_statements.md#level)
  * [levelrange](cil_mls_labeling_statements.md#levelrange)
  * [rangetransition](cil_mls_labeling_statements.md#rangetransition)
  * [mlsconstrain](cil_mls_labeling_statements.md#mlsconstrain)
  * [mlsvalidatetrans](cil_mls_labeling_statements.md#mlsvalidatetrans)

* [Network Labeling Statements](cil_network_labeling_statements.md#network-labeling-statements)
  * [ipaddr](cil_network_labeling_statements.md#ipaddr)
  * [netifcon](cil_network_labeling_statements.md#netifcon)
  * [nodecon](cil_network_labeling_statements.md#nodecon)
  * [portcon](cil_network_labeling_statements.md#portcon)

* [Policy Configuration Statements](cil_policy_config_statements.md#policy-configuration-statements)
  * [mls](cil_policy_config_statements.md#mls)
  * [handleunknown](cil_policy_config_statements.md#handleunknown)
  * [policycap](cil_policy_config_statements.md#policycap)

* [Role Statements](cil_role_statements.md#role-statements)
  * [role](cil_role_statements.md#role)
  * [roletype](cil_role_statements.md#roletype)
  * [roleattribute](cil_role_statements.md#roleattribute)
  * [roleattributeset](cil_role_statements.md#roleattributeset)
  * [roleallow](cil_role_statements.md#roleallow)
  * [roletransition](cil_role_statements.md#roletransition)
  * [rolebounds](cil_role_statements.md#rolebounds)

* [SID Statements](cil_sid_statements.md#sid-statements)
  * [sid](cil_sid_statements.md#sid)
  * [sidorder](cil_sid_statements.md#sidorder)
  * [sidcontext](cil_sid_statements.md#sidcontext)

* [Type Statements](cil_type_statements.md#type-statements)
  * [type](cil_type_statements.md#type)
  * [typealias](cil_type_statements.md#typealias)
  * [typealiasactual](cil_type_statements.md#typealiasactual)
  * [typeattribute](cil_type_statements.md#typeattribute)
  * [typeattributeset](cil_type_statements.md#typeattributeset)
  * [expandtypeattribute](cil_type_statements.md#expandtypeattribute)
  * [typebounds](cil_type_statements.md#typebounds)
  * [typechange](cil_type_statements.md#typechange)
  * [typemember](cil_type_statements.md#typemember)
  * [typetransition](cil_type_statements.md#typetransition)
  * [typepermissive](cil_type_statements.md#typepermissive)

* [User Statements](cil_user_statements.md#user-statements)
  * [user](cil_user_statements.md#user)
  * [userrole](cil_user_statements.md#userrole)
  * [userattribute](cil_user_statements.md#userattribute)
  * [userattributeset](cil_user_statements.md#userattributeset)
  * [userlevel](cil_user_statements.md#userlevel)
  * [userrange](cil_user_statements.md#userrange)
  * [userbounds](cil_user_statements.md#userbounds)
  * [userprefix](cil_user_statements.md#userprefix)
  * [selinuxuser](cil_user_statements.md#selinuxuser)
  * [selinuxuserdefault](cil_user_statements.md#selinuxuserdefault)

* [Infiniband Statements](cil_infiniband_statements.md#infiniband-statements)
  * [ibpkeycon](cil_infiniband_statements.md#ibpkeycon)
  * [ibendportcon](cil_infiniband_statements.md#ibendportcon)

* [Xen Statements](cil_xen_statements.md#xen-statements)
  * [iomemcon](cil_xen_statements.md#iomemcon)
  * [ioportcon](cil_xen_statements.md#ioportcon)
  * [pcidevicecon](cil_xen_statements.md#pcidevicecon)
  * [pirqcon](cil_xen_statements.md#pirqcon)
  * [devicetreecon](cil_xen_statements.md#devicetreecon)

* [Example Policy](../test/policy.cil#example-policy)
