/*
 * Copyright 2020-2023 Toyota Connected North America
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef CONFIG_COMMON_H_
#define CONFIG_COMMON_H_

#include <array>

#include <EGL/egl.h>

#include <waypp/waypp.h>

#ifndef BUILD_BACKEND_WAYLAND_EGL
#define BUILD_BACKEND_WAYLAND_EGL 1
#endif
#ifndef BUILD_BACKEND_WAYLAND_VULKAN
#define BUILD_BACKEND_WAYLAND_VULKAN 0
#endif
#ifndef BUILD_BACKEND_WAYLAND_DRM_LEASED
#define BUILD_BACKEND_WAYLAND_DRM_LEASED 0
#endif
#ifndef BUILD_BACKEND_DRM_KMS_EGL
#define BUILD_BACKEND_DRM_KMS_EGL 0
#endif
#ifndef BUILD_BACKEND_DRM_KMS_VULKAN
#define BUILD_BACKEND_DRM_KMS_VULKAN 0
#endif
#ifndef BUILD_BACKEND_HEADLESS_EGL
#define BUILD_BACKEND_HEADLESS_EGL 0
#endif

#define BUILD_EGL_TRANSPARENCY 1
#define BUILD_EGL_ENABLE_3D 1
#define BUILD_EGL_ENABLE_MULTISAMPLE 1

#define BUILD_CRASH_HANDLER 0
#if BUILD_CRASH_HANDLER
static constexpr char kCrashHandlerDsn[] = "";
static constexpr char kCrashHandlerRelease[] = "ivi-homescreen@_0_dev";
static constexpr char kCrashpadBinaryPath[] = "/crashpad_handler";
static constexpr char kCrashpadAttachments[] = "";
static constexpr char kCrashpadTags[] = "";
#endif

#define DEBUG_PLATFORM_MESSAGES 0

#define ENABLE_LTO 1
#define ENABLE_DLT 0
#define ENABLE_PLUGINS 1

#define BUILD_DOCS 0
#define BUILD_UNIT_TESTS 0
#define UNIT_TEST_SAVE_GOLDENS 0

// GIT
constexpr char kGitBranch[] = "v2.0";
constexpr char kGitCommitHash[] = "dd6d9224";

// Path prefix comes from CMAKE_INSTALL_PREFIX
constexpr char kPathPrefix[] = "/usr";

// Screen Size
constexpr int32_t kDefaultViewWidth = 1920;
constexpr int32_t kDefaultViewHeight = 720;
constexpr int kEglBufferSize = 24;

// Logging
constexpr int32_t kLogFlushInterval = 5;
constexpr int32_t kVmLogChunkMax = 10;

// Scale Factor
constexpr double kDefaultBufferScale = 1.0;
constexpr double kDefaultPixelRatio = 1.0;

// Cursor
constexpr int kCursorSize = 24;
constexpr char kCursorKindBasic[] = "left_ptr";
constexpr char kCursorKindClick[] = "hand";
constexpr char kCursorKindText[] = "left_ptr";
constexpr char kCursorKindForbidden[] = "pirate";

// Mouse/Touch
static constexpr int kMaxTouchFinger = 10;
static constexpr int kPointerEventModulus = 2;
static constexpr int kMaxPointerEvent =
    kMaxTouchFinger * (15 * kPointerEventModulus);

// Locale
constexpr char kDefaultLocaleLanguageCode[] = "en";
constexpr char kDefaultLocaleCountryCode[] = "US";
constexpr char kDefaultLocaleScriptCode[] = "";

// Bundle folder paths
constexpr char kViewConfigToml[] = "config.toml";
constexpr char kBundleFlutterAssets[] = "data/flutter_assets";
constexpr char kBundleAot[] = "lib/libapp.so";
// Bundle folder override paths
constexpr char kBundleIcudtl[] = "data/icudtl.dat";
constexpr char kBundleEngine[] = "lib/libflutter_engine.so";
// System paths
constexpr char kSystemEngine[] = "libflutter_engine.so";
constexpr char kSystemIcudtl[] = "share/flutter/icudtl.dat";

// Install path constants
static constexpr char kApplicationName[] = "flutter-auto";
static constexpr char kXdgApplicationDir[] = "." "flutter-auto";
static constexpr char kXdgConfigDir[] = ".config";

// DLT Logging
static constexpr char kDltAppId[] = "HMIF";
static constexpr char kDltAppIdDescription[] = "HMI Flutter";
static constexpr char kDltContextId[] = "FEMB";
static constexpr char kDltContextIdDescription[] = "Flutter Embedder";

// Compositor Surface
constexpr unsigned int kCompSurfExpectedInterfaceVersion = 0x00010000;

static constexpr std::array<EGLint, 5> kEglContextAttribs = {{
    // clang-format off
    EGL_CONTEXT_MAJOR_VERSION, 3,
    EGL_CONTEXT_MAJOR_VERSION, 2,
    EGL_NONE
    // clang-format on
}};

static constexpr std::array<EGLint, 27> kEglConfigAttribs = {{
    // clang-format off
    EGL_SURFACE_TYPE, EGL_WINDOW_BIT,
    EGL_RENDERABLE_TYPE, EGL_OPENGL_ES3_BIT,
    EGL_RENDERABLE_TYPE, EGL_OPENGL_ES2_BIT,

    EGL_RED_SIZE, 8,
    EGL_GREEN_SIZE, 8,
    EGL_BLUE_SIZE, 8,
#if BUILD_EGL_TRANSPARENCY
    EGL_ALPHA_SIZE, 8,
#else
    EGL_ALPHA_SIZE, 0,
#endif
#if BUILD_EGL_ENABLE_3D
    EGL_STENCIL_SIZE, 8,
    EGL_DEPTH_SIZE, 16,
#else
    EGL_STENCIL_SIZE, 0,
    EGL_DEPTH_SIZE, 0,
#endif
#if BUILD_EGL_ENABLE_MULTISAMPLE
    EGL_SAMPLE_BUFFERS, 1,
    EGL_SAMPLES, 4,
#else
    EGL_SAMPLE_BUFFERS, 0,
    EGL_SAMPLES, 0,
#endif

    EGL_NONE // termination sentinel
    // clang-format on
}};


static constexpr std::array<EGLint, 13> kEglConfigAttribsFallBack = {{
    // clang-format off
    EGL_SURFACE_TYPE, EGL_WINDOW_BIT,
    EGL_RENDERABLE_TYPE, EGL_OPENGL_ES2_BIT,

    EGL_RED_SIZE, 1,
    EGL_GREEN_SIZE, 1,
    EGL_BLUE_SIZE, 1,
    EGL_ALPHA_SIZE, 2,
    EGL_NONE // termination sentinel
    // clang-format on
}};


// All vkCreate* functions take an optional allocator. For now, we select the
// default allocator by passing in a null pointer, and we highlight the argument
// by using the VKALLOC constant.
constexpr struct VkAllocationCallbacks* VKALLOC = nullptr;

#define ENV32BIT 0
#define ENV64BIT 1

#endif //CONFIG_COMMON_H_
