#include "pmu-events/pmu-events.h"
struct pmu_event pme_ampere_emag[] = {
{
	.name = "ase_spec",
	.event = "event=0x74",
	.desc = "Operation speculatively executed, Advanced SIMD instruction",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, Advanced SIMD instruction",
},
{
	.name = "br_immed_spec",
	.event = "event=0x78",
	.desc = "Branch speculatively executed, immediate branch",
	.topic = "branch",
	.long_desc = "Branch speculatively executed, immediate branch",
},
{
	.name = "br_indirect_spec",
	.event = "event=0x7a",
	.desc = "Branch speculatively executed, indirect branch",
	.topic = "branch",
	.long_desc = "Branch speculatively executed, indirect branch",
},
{
	.name = "br_mis_pred",
	.event = "event=0x10",
	.desc = "Branch mispredicted",
	.topic = "branch",
	.long_desc = "Mispredicted or not predicted branch speculatively executed",
},
{
	.name = "br_mispred_retired",
	.event = "event=0x22",
	.desc = "Mispredicted branch retired",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, mispredicted branch. This event counts any branch counted by BR_RETIRED which is not correctly predicted and causes a pipeline flush",
},
{
	.name = "br_pred",
	.event = "event=0x12",
	.desc = "Predictable branch",
	.topic = "branch",
	.long_desc = "Predictable branch speculatively executed",
},
{
	.name = "br_retired",
	.event = "event=0x21",
	.desc = "Branch retired",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, branch. This event counts all branches, taken or not. This excludes exception entries, debug entries and CCFAIL branches",
},
{
	.name = "br_return_spec",
	.event = "event=0x79",
	.desc = "Branch speculatively executed, procedure return",
	.topic = "branch",
	.long_desc = "Branch speculatively executed, procedure return",
},
{
	.name = "btb_mis_pred",
	.event = "event=0x102",
	.desc = "BTB misprediction",
	.topic = "cache",
	.long_desc = "Branch target buffer misprediction",
},
{
	.name = "bus_access",
	.event = "event=0x19",
	.desc = "Bus access",
	.topic = "bus",
	.long_desc = "Bus access",
},
{
	.name = "bus_access_normal",
	.event = "event=0x64",
	.desc = "Bus access, Normal",
	.topic = "bus",
	.long_desc = "Bus access, Normal",
},
{
	.name = "bus_access_not_shared",
	.event = "event=0x63",
	.desc = "Bus access, not Normal, Cacheable, Shareable",
	.topic = "bus",
	.long_desc = "Bus access, not Normal, Cacheable, Shareable",
},
{
	.name = "bus_access_periph",
	.event = "event=0x65",
	.desc = "Bus access, peripheral",
	.topic = "bus",
	.long_desc = "Bus access, peripheral",
},
{
	.name = "bus_access_rd",
	.event = "event=0x60",
	.desc = "Bus access read",
	.topic = "bus",
	.long_desc = "Bus access read",
},
{
	.name = "bus_access_shared",
	.event = "event=0x62",
	.desc = "Bus access, Normal, Cacheable, Shareable",
	.topic = "bus",
	.long_desc = "Bus access, Normal, Cacheable, Shareable",
},
{
	.name = "bus_access_wr",
	.event = "event=0x61",
	.desc = "Bus access write",
	.topic = "bus",
	.long_desc = "Bus access write",
},
{
	.name = "bx_stall",
	.event = "event=0x10c",
	.desc = "BX stalled",
	.topic = "pipeline",
	.long_desc = "BX Op non-issue",
},
{
	.name = "cid_write_retired",
	.event = "event=0xb",
	.desc = "Write to CONTEXTIDR",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, condition code check pass, write to CONTEXTIDR",
},
{
	.name = "cpu_cycles",
	.event = "event=0x11",
	.desc = "Clock cycles",
	.topic = "clock",
	.long_desc = "The number of core clock cycles",
},
{
	.name = "crypto_spec",
	.event = "event=0x77",
	.desc = "Operation speculatively executed, Cryptographic instruction",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, Cryptographic instruction",
},
{
	.name = "decode_stall",
	.event = "event=0x108",
	.desc = "Decode starved",
	.topic = "pipeline",
	.long_desc = "Decode starved for instruction cycle",
},
{
	.name = "dispatch_stall",
	.event = "event=0x109",
	.desc = "Dispatch stalled",
	.topic = "pipeline",
	.long_desc = "Op dispatch stalled cycle",
},
{
	.name = "dmb_spec",
	.event = "event=0x7e",
	.desc = "Barrier speculatively executed, DMB",
	.topic = "instruction",
	.long_desc = "Barrier speculatively executed, DMB",
},
{
	.name = "dp_spec",
	.event = "event=0x73",
	.desc = "Operation speculatively executed, integer data processing",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, integer data processing",
},
{
	.name = "dsb_spec",
	.event = "event=0x7d",
	.desc = "Barrier speculatively executed, DSB",
	.topic = "instruction",
	.long_desc = "Barrier speculatively executed, DSB",
},
{
	.name = "dtb_miss",
	.event = "event=0x104",
	.desc = "DTB miss",
	.topic = "cache",
	.long_desc = "DTB miss",
},
{
	.name = "exc_dabort",
	.event = "event=0x84",
	.desc = "Exception taken, Data Abort and SError",
	.topic = "exception",
	.long_desc = "Exception taken, Data Abort and SError",
},
{
	.name = "exc_fiq",
	.event = "event=0x87",
	.desc = "Exception taken, FIQ",
	.topic = "exception",
	.long_desc = "Exception taken, FIQ",
},
{
	.name = "exc_hvc",
	.event = "event=0x8a",
	.desc = "Exception taken, Hypervisor Call",
	.topic = "exception",
	.long_desc = "Exception taken, Hypervisor Call",
},
{
	.name = "exc_irq",
	.event = "event=0x86",
	.desc = "Exception taken, IRQ",
	.topic = "exception",
	.long_desc = "Exception taken, IRQ",
},
{
	.name = "exc_pabort",
	.event = "event=0x83",
	.desc = "Exception taken, Instruction Abort",
	.topic = "exception",
	.long_desc = "Exception taken, Instruction Abort",
},
{
	.name = "exc_return",
	.event = "event=0xa",
	.desc = "Exception return",
	.topic = "exception",
	.long_desc = "Instruction architecturally executed, condition check pass, exception return",
},
{
	.name = "exc_svc",
	.event = "event=0x82",
	.desc = "Exception taken, Supervisor Call",
	.topic = "exception",
	.long_desc = "Exception taken, Supervisor Call",
},
{
	.name = "exc_taken",
	.event = "event=0x9",
	.desc = "Exception taken",
	.topic = "exception",
	.long_desc = "Exception taken",
},
{
	.name = "exc_trap_dabort",
	.event = "event=0x8c",
	.desc = "Exception taken, Data Abort or SError not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, Data Abort or SError not taken locally",
},
{
	.name = "exc_trap_fiq",
	.event = "event=0x8f",
	.desc = "Exception taken, FIQ not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, FIQ not taken locally",
},
{
	.name = "exc_trap_irq",
	.event = "event=0x8e",
	.desc = "Exception taken, IRQ not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, IRQ not taken locally",
},
{
	.name = "exc_trap_other",
	.event = "event=0x8d",
	.desc = "Exception taken, Other traps not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, Other traps not taken locally",
},
{
	.name = "exc_trap_pabort",
	.event = "event=0x8b",
	.desc = "Exception taken, Instruction Abort not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, Instruction Abort not taken locally",
},
{
	.name = "exc_undef",
	.event = "event=0x81",
	.desc = "Exception taken, Other synchronous",
	.topic = "exception",
	.long_desc = "Exception taken, Other synchronous",
},
{
	.name = "fsu_clock_off_cycles",
	.event = "event=0x101",
	.desc = "FSU clocking gated off cycle",
	.topic = "clock",
	.long_desc = "FSU clocking gated off cycle",
},
{
	.name = "fx_stall",
	.event = "event=0x10f",
	.desc = "FX stalled",
	.topic = "pipeline",
	.long_desc = "FX Op non-issue",
},
{
	.name = "inst_retired",
	.event = "event=0x8",
	.desc = "Instruction retired",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed",
},
{
	.name = "inst_spec",
	.event = "event=0x1b",
	.desc = "Speculatively executed",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed",
},
{
	.name = "isb_spec",
	.event = "event=0x7c",
	.desc = "Barrier speculatively executed, ISB",
	.topic = "instruction",
	.long_desc = "Barrier speculatively executed, ISB",
},
{
	.name = "itb_miss",
	.event = "event=0x103",
	.desc = "ITB miss",
	.topic = "cache",
	.long_desc = "ITB miss",
},
{
	.name = "ixa_stall",
	.event = "event=0x10a",
	.desc = "IXA stalled",
	.topic = "pipeline",
	.long_desc = "IXA Op non-issue",
},
{
	.name = "ixb_stall",
	.event = "event=0x10b",
	.desc = "IXB stalled",
	.topic = "pipeline",
	.long_desc = "IXB Op non-issue",
},
{
	.name = "l1_stage2_tlb_refill",
	.event = "event=0x111",
	.desc = "L1 stage 2 TLB refill",
	.topic = "cache",
	.long_desc = "Level 1 stage 2 TLB refill",
},
{
	.name = "l1d_cache_access",
	.event = "event=0x4",
	.desc = "L1D cache access",
	.topic = "cache",
	.long_desc = "Level 1 data cache access",
},
{
	.name = "l1d_cache_inval",
	.event = "event=0x48",
	.desc = "L1D cache invalidate",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache invalidate",
},
{
	.name = "l1d_cache_late_miss",
	.event = "event=0x105",
	.desc = "L1D cache late miss",
	.topic = "cache",
	.long_desc = "Level 1 data cache late miss",
},
{
	.name = "l1d_cache_prefetch",
	.event = "event=0x106",
	.desc = "L1D cache prefetch",
	.topic = "cache",
	.long_desc = "Level 1 data cache prefetch request",
},
{
	.name = "l1d_cache_rd",
	.event = "event=0x40",
	.desc = "L1D cache access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache access, read",
},
{
	.name = "l1d_cache_refill",
	.event = "event=0x3",
	.desc = "L1D cache refill",
	.topic = "cache",
	.long_desc = "Level 1 data cache refill",
},
{
	.name = "l1d_cache_refill_rd",
	.event = "event=0x42",
	.desc = "L1D cache refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache refill, read",
},
{
	.name = "l1d_cache_wr",
	.event = "event=0x41",
	.desc = "L1D cache access, write",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache access, write",
},
{
	.name = "l1d_tlb_access",
	.event = "event=0x25",
	.desc = "L1D TLB access",
	.topic = "cache",
	.long_desc = "Level 1 data TLB access. This event counts any load or store operation which accesses the data L1 TLB",
},
{
	.name = "l1d_tlb_refill",
	.event = "event=0x5",
	.desc = "L1D TLB refill",
	.topic = "cache",
	.long_desc = "Level 1 data TLB refill",
},
{
	.name = "l1d_tlb_refill_rd",
	.event = "event=0x4c",
	.desc = "L1D tlb refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data TLB refill, read",
},
{
	.name = "l1d_tlb_refill_wr",
	.event = "event=0x4d",
	.desc = "L1D tlb refill, write",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data TLB refill, write",
},
{
	.name = "l1i_cache_access",
	.event = "event=0x14",
	.desc = "L1I cache access",
	.topic = "cache",
	.long_desc = "Level 1 instruction cache access",
},
{
	.name = "l1i_cache_refill",
	.event = "event=0x1",
	.desc = "L1I cache refill",
	.topic = "cache",
	.long_desc = "Level 1 instruction cache refill",
},
{
	.name = "l1i_tlb_access",
	.event = "event=0x26",
	.desc = "L1I TLB access",
	.topic = "cache",
	.long_desc = "Level 1 instruction TLB access. This event counts any instruction fetch which accesses the instruction L1 TLB",
},
{
	.name = "l1i_tlb_refill",
	.event = "event=0x2",
	.desc = "L1I TLB refill",
	.topic = "cache",
	.long_desc = "Level 1 instruction TLB refill",
},
{
	.name = "l2d_cache_access",
	.event = "event=0x16",
	.desc = "L2D cache access",
	.topic = "cache",
	.long_desc = "Level 2 data cache access",
},
{
	.name = "l2d_cache_inval",
	.event = "event=0x58",
	.desc = "L2D cache invalidate",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache invalidate",
},
{
	.name = "l2d_cache_prefetch",
	.event = "event=0x107",
	.desc = "L2D cache prefetch",
	.topic = "cache",
	.long_desc = "Level 2 data cache prefetch request",
},
{
	.name = "l2d_cache_rd",
	.event = "event=0x50",
	.desc = "L2D cache access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache access, read",
},
{
	.name = "l2d_cache_refill",
	.event = "event=0x17",
	.desc = "L2D cache refill",
	.topic = "cache",
	.long_desc = "Level 2 data refill",
},
{
	.name = "l2d_cache_refill_rd",
	.event = "event=0x52",
	.desc = "L2D cache refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache refill, read",
},
{
	.name = "l2d_cache_refill_wr",
	.event = "event=0x53",
	.desc = "L2D cache refill, write",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache refill, write",
},
{
	.name = "l2d_cache_wb",
	.event = "event=0x18",
	.desc = "L2D cache Write-Back",
	.topic = "cache",
	.long_desc = "Level 2 data cache, Write-Back",
},
{
	.name = "l2d_cache_wb_clean",
	.event = "event=0x57",
	.desc = "L2D cache Write-Back, cleaning and coherency",
	.topic = "cache",
	.long_desc = "Level 2 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l2d_cache_wb_victim",
	.event = "event=0x56",
	.desc = "L2D cache Write-Back, victim",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache Write-Back, victim",
},
{
	.name = "l2d_cache_wr",
	.event = "event=0x51",
	.desc = "L2D cache access, write",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache access, write",
},
{
	.name = "l2d_tlb_access",
	.event = "event=0x34",
	.desc = "L2D TLB access",
	.topic = "cache",
	.long_desc = "Level 2 access to data TLB that caused a page table walk. This event counts on any data access which causes L2D_TLB_REFILL to count",
},
{
	.name = "l2i_tlb_access",
	.event = "event=0x35",
	.desc = "L2I TLB access",
	.topic = "cache",
	.long_desc = "Level 2 access to instruciton TLB that caused a page table walk. This event counts on any instruciton access which causes L2I_TLB_REFILL to count",
},
{
	.name = "ld_spec",
	.event = "event=0x70",
	.desc = "Operation speculatively executed, load",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, load",
},
{
	.name = "ldrex_spec",
	.event = "event=0x6c",
	.desc = "Exclusive operation speculatively executed, LDREX or LDX",
	.topic = "intrinsic",
	.long_desc = "Exclusive operation speculatively executed, LDREX or LDX",
},
{
	.name = "ldst_spec",
	.event = "event=0x72",
	.desc = "Operation speculatively executed, load or store",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, load or store",
},
{
	.name = "lx_stall",
	.event = "event=0x10d",
	.desc = "LX stalled",
	.topic = "pipeline",
	.long_desc = "LX Op non-issue",
},
{
	.name = "mem_access",
	.event = "event=0x13",
	.desc = "Memory access",
	.topic = "memory",
	.long_desc = "Data memory access",
},
{
	.name = "mem_access_rd",
	.event = "event=0x66",
	.desc = "Data memory access, read",
	.topic = "memory",
	.long_desc = "Data memory access, read",
},
{
	.name = "mem_access_wr",
	.event = "event=0x67",
	.desc = "Data memory access, write",
	.topic = "memory",
	.long_desc = "Data memory access, write",
},
{
	.name = "mem_error",
	.event = "event=0x1a",
	.desc = "Memory error",
	.topic = "memory",
	.long_desc = "Local memory error. This event counts any correctable or uncorrectable memory error (ECC or parity) in the protected core RAMs",
},
{
	.name = "nop_spec",
	.event = "event=0x100",
	.desc = "Speculatively executed, NOP",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, NOP",
},
{
	.name = "page_walk_l0_stage1_hit",
	.event = "event=0x112",
	.desc = "Page walk, L0 stage-1 hit",
	.topic = "cache",
	.long_desc = "Page walk cache level-0 stage-1 hit",
},
{
	.name = "page_walk_l1_stage1_hit",
	.event = "event=0x113",
	.desc = "Page walk, L1 stage-1 hit",
	.topic = "cache",
	.long_desc = "Page walk cache level-1 stage-1 hit",
},
{
	.name = "page_walk_l1_stage2_hit",
	.event = "event=0x115",
	.desc = "Page walk, L1 stage-2 hit",
	.topic = "cache",
	.long_desc = "Page walk cache level-1 stage-2 hit",
},
{
	.name = "page_walk_l2_stage1_hit",
	.event = "event=0x114",
	.desc = "Page walk, L2 stage-1 hit",
	.topic = "cache",
	.long_desc = "Page walk cache level-2 stage-1 hit",
},
{
	.name = "page_walk_l2_stage2_hit",
	.event = "event=0x116",
	.desc = "Page walk, L2 stage-2 hit",
	.topic = "cache",
	.long_desc = "Page walk cache level-2 stage-2 hit",
},
{
	.name = "pc_write_spec",
	.event = "event=0x76",
	.desc = "Operation speculatively executed, software change of the PC",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, software change of the PC",
},
{
	.name = "rc_ld_spec",
	.event = "event=0x90",
	.desc = "Release consistency operation speculatively executed, Load-Acquire",
	.topic = "instruction",
	.long_desc = "Release consistency operation speculatively executed, Load-Acquire",
},
{
	.name = "rc_st_spec",
	.event = "event=0x91",
	.desc = "Release consistency operation speculatively executed, Store-Release",
	.topic = "instruction",
	.long_desc = "Release consistency operation speculatively executed, Store-Release",
},
{
	.name = "st_spec",
	.event = "event=0x71",
	.desc = "Operation speculatively executed, store",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, store",
},
{
	.name = "strex_fail_spec",
	.event = "event=0x6e",
	.desc = "Exclusive operation speculatively executed, STREX or STX fail",
	.topic = "intrinsic",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX fail",
},
{
	.name = "strex_pass_spec",
	.event = "event=0x6d",
	.desc = "Exclusive operation speculatively executed, STREX or STX pass",
	.topic = "intrinsic",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX pass",
},
{
	.name = "strex_spec",
	.event = "event=0x6f",
	.desc = "Exclusive operation speculatively executed, STREX or STX",
	.topic = "intrinsic",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX",
},
{
	.name = "sw_incr",
	.event = "event=0",
	.desc = "Software increment",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, software increment",
},
{
	.name = "sx_stall",
	.event = "event=0x10e",
	.desc = "SX stalled",
	.topic = "pipeline",
	.long_desc = "SX Op non-issue",
},
{
	.name = "ttbr_write_retired",
	.event = "event=0x1c",
	.desc = "Instruction executed, TTBR write",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed (condition check pass), write to TTBR",
},
{
	.name = "unaligned_ld_spec",
	.event = "event=0x68",
	.desc = "Unaligned access, read",
	.topic = "memory",
	.long_desc = "Unaligned access, read",
},
{
	.name = "unaligned_ldst_spec",
	.event = "event=0x6a",
	.desc = "Unaligned access",
	.topic = "memory",
	.long_desc = "Unaligned access",
},
{
	.name = "unaligned_st_spec",
	.event = "event=0x69",
	.desc = "Unaligned access, write",
	.topic = "memory",
	.long_desc = "Unaligned access, write",
},
{
	.name = "vfp_spec",
	.event = "event=0x75",
	.desc = "Operation speculatively executed, floating-point instruction",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, floating-point instruction",
},
{
	.name = "wait_cycles",
	.event = "event=0x110",
	.desc = "Wait state cycle",
	.topic = "clock",
	.long_desc = "Wait state cycle",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_event pme_arm_cortex_a53[] = {
{
	.name = "agu_dep_stall",
	.event = "event=0xe5",
	.desc = "Cycles there is an interlock for a load/store instruction waiting for data to calculate the address in the AGU",
	.topic = "pipeline",
},
{
	.name = "br_cond",
	.event = "event=0xc9",
	.desc = "Conditional branch executed",
	.topic = "branch",
},
{
	.name = "br_cond_mispred",
	.event = "event=0xcc",
	.desc = "Conditional branch mispredicted",
	.topic = "branch",
},
{
	.name = "br_indirect_mispred",
	.event = "event=0xca",
	.desc = "Indirect branch mispredicted",
	.topic = "branch",
},
{
	.name = "br_indirect_mispred_addr",
	.event = "event=0xcb",
	.desc = "Indirect branch mispredicted because of address miscompare",
	.topic = "branch",
},
{
	.name = "br_indirect_spec",
	.event = "event=0x7a",
	.desc = "Branch speculatively executed, indirect branch",
	.topic = "branch",
	.long_desc = "Branch speculatively executed, indirect branch",
},
{
	.name = "bus_access_rd",
	.event = "event=0x60",
	.desc = "Bus access read",
	.topic = "bus",
	.long_desc = "Bus access read",
},
{
	.name = "bus_access_wr",
	.event = "event=0x61",
	.desc = "Bus access write",
	.topic = "bus",
	.long_desc = "Bus access write",
},
{
	.name = "decode_dep_stall",
	.event = "event=0xe3",
	.desc = "Cycles the DPU IQ is empty and there is a pre-decode error being processed",
	.topic = "pipeline",
},
{
	.name = "exc_fiq",
	.event = "event=0x87",
	.desc = "Exception taken, FIQ",
	.topic = "other",
	.long_desc = "Exception taken, FIQ",
},
{
	.name = "exc_irq",
	.event = "event=0x86",
	.desc = "Exception taken, IRQ",
	.topic = "other",
	.long_desc = "Exception taken, IRQ",
},
{
	.name = "ext_mem_req",
	.event = "event=0xc0",
	.desc = "External memory request",
	.topic = "memory",
},
{
	.name = "ext_mem_req_nc",
	.event = "event=0xc1",
	.desc = "Non-cacheable external memory request",
	.topic = "memory",
},
{
	.name = "ext_snoop",
	.event = "event=0xc8",
	.desc = "SCU Snooped data from another CPU for this CPU",
	.topic = "cache",
},
{
	.name = "ic_dep_stall",
	.event = "event=0xe1",
	.desc = "Cycles the DPU IQ is empty and there is an instruction cache miss being processed",
	.topic = "pipeline",
},
{
	.name = "iutlb_dep_stall",
	.event = "event=0xe2",
	.desc = "Cycles the DPU IQ is empty and there is an instruction micro-TLB miss being processed",
	.topic = "pipeline",
},
{
	.name = "l1d_cache_err",
	.event = "event=0xd1",
	.desc = "L1 Data Cache (data, tag or dirty) memory error, correctable or non-correctable",
	.topic = "other",
},
{
	.name = "l1i_cache_err",
	.event = "event=0xd0",
	.desc = "L1 Instruction Cache (data or tag) memory error",
	.topic = "other",
},
{
	.name = "ld_dep_stall",
	.event = "event=0xe7",
	.desc = "Cycles there is a stall in the Wr stage because of a load miss",
	.topic = "pipeline",
},
{
	.name = "other_interlock_stall",
	.event = "event=0xe4",
	.desc = "Cycles there is an interlock other than  Advanced SIMD/Floating-point instructions or load/store instruction",
	.topic = "pipeline",
},
{
	.name = "other_iq_dep_stall",
	.event = "event=0xe0",
	.desc = "Cycles that the DPU IQ is empty and that is not because of a recent micro-TLB miss, instruction cache miss or pre-decode error",
	.topic = "pipeline",
},
{
	.name = "pre_decode_err",
	.event = "event=0xc6",
	.desc = "Pre-decode error",
	.topic = "other",
},
{
	.name = "prefetch_linefill",
	.event = "event=0xc2",
	.desc = "Linefill because of prefetch",
	.topic = "cache",
},
{
	.name = "prefetch_linefill_drop",
	.event = "event=0xc3",
	.desc = "Instruction Cache Throttle occurred",
	.topic = "cache",
},
{
	.name = "read_alloc",
	.event = "event=0xc5",
	.desc = "Read allocate mode",
	.topic = "cache",
},
{
	.name = "read_alloc_enter",
	.event = "event=0xc4",
	.desc = "Entering read allocate mode",
	.topic = "cache",
},
{
	.name = "simd_dep_stall",
	.event = "event=0xe6",
	.desc = "Cycles there is an interlock for an Advanced SIMD/Floating-point operation",
	.topic = "pipeline",
},
{
	.name = "st_dep_stall",
	.event = "event=0xe8",
	.desc = "Cycles there is a stall in the Wr stage because of a store",
	.topic = "pipeline",
},
{
	.name = "stall_sb_full",
	.event = "event=0xc7",
	.desc = "Data Write operation that stalls the pipeline because the store buffer is full",
	.topic = "pipeline",
},
{
	.name = "tlb_err",
	.event = "event=0xd2",
	.desc = "TLB memory error",
	.topic = "other",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_event pme_arm_cortex_a57_a72[] = {
{
	.name = "ase_spec",
	.event = "event=0x74",
	.desc = "Operation speculatively executed, Advanced SIMD instruction",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, Advanced SIMD instruction",
},
{
	.name = "br_immed_spec",
	.event = "event=0x78",
	.desc = "Branch speculatively executed, immediate branch",
	.topic = "core imp def",
	.long_desc = "Branch speculatively executed, immediate branch",
},
{
	.name = "br_indirect_spec",
	.event = "event=0x7a",
	.desc = "Branch speculatively executed, indirect branch",
	.topic = "core imp def",
	.long_desc = "Branch speculatively executed, indirect branch",
},
{
	.name = "br_return_spec",
	.event = "event=0x79",
	.desc = "Branch speculatively executed, procedure return",
	.topic = "core imp def",
	.long_desc = "Branch speculatively executed, procedure return",
},
{
	.name = "bus_access_normal",
	.event = "event=0x64",
	.desc = "Bus access, Normal",
	.topic = "core imp def",
	.long_desc = "Bus access, Normal",
},
{
	.name = "bus_access_not_shared",
	.event = "event=0x63",
	.desc = "Bus access, not Normal, Cacheable, Shareable",
	.topic = "core imp def",
	.long_desc = "Bus access, not Normal, Cacheable, Shareable",
},
{
	.name = "bus_access_periph",
	.event = "event=0x65",
	.desc = "Bus access, peripheral",
	.topic = "core imp def",
	.long_desc = "Bus access, peripheral",
},
{
	.name = "bus_access_rd",
	.event = "event=0x60",
	.desc = "Bus access read",
	.topic = "core imp def",
	.long_desc = "Bus access read",
},
{
	.name = "bus_access_shared",
	.event = "event=0x62",
	.desc = "Bus access, Normal, Cacheable, Shareable",
	.topic = "core imp def",
	.long_desc = "Bus access, Normal, Cacheable, Shareable",
},
{
	.name = "bus_access_wr",
	.event = "event=0x61",
	.desc = "Bus access write",
	.topic = "core imp def",
	.long_desc = "Bus access write",
},
{
	.name = "crypto_spec",
	.event = "event=0x77",
	.desc = "Operation speculatively executed, Cryptographic instruction",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, Cryptographic instruction",
},
{
	.name = "dmb_spec",
	.event = "event=0x7e",
	.desc = "Barrier speculatively executed, DMB",
	.topic = "core imp def",
	.long_desc = "Barrier speculatively executed, DMB",
},
{
	.name = "dp_spec",
	.event = "event=0x73",
	.desc = "Operation speculatively executed, integer data processing",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, integer data processing",
},
{
	.name = "dsb_spec",
	.event = "event=0x7d",
	.desc = "Barrier speculatively executed, DSB",
	.topic = "core imp def",
	.long_desc = "Barrier speculatively executed, DSB",
},
{
	.name = "exc_dabort",
	.event = "event=0x84",
	.desc = "Exception taken, Data Abort and SError",
	.topic = "core imp def",
	.long_desc = "Exception taken, Data Abort and SError",
},
{
	.name = "exc_fiq",
	.event = "event=0x87",
	.desc = "Exception taken, FIQ",
	.topic = "core imp def",
	.long_desc = "Exception taken, FIQ",
},
{
	.name = "exc_hvc",
	.event = "event=0x8a",
	.desc = "Exception taken, Hypervisor Call",
	.topic = "core imp def",
	.long_desc = "Exception taken, Hypervisor Call",
},
{
	.name = "exc_irq",
	.event = "event=0x86",
	.desc = "Exception taken, IRQ",
	.topic = "core imp def",
	.long_desc = "Exception taken, IRQ",
},
{
	.name = "exc_pabort",
	.event = "event=0x83",
	.desc = "Exception taken, Instruction Abort",
	.topic = "core imp def",
	.long_desc = "Exception taken, Instruction Abort",
},
{
	.name = "exc_smc",
	.event = "event=0x88",
	.desc = "Exception taken, Secure Monitor Call",
	.topic = "core imp def",
	.long_desc = "Exception taken, Secure Monitor Call",
},
{
	.name = "exc_svc",
	.event = "event=0x82",
	.desc = "Exception taken, Supervisor Call",
	.topic = "core imp def",
	.long_desc = "Exception taken, Supervisor Call",
},
{
	.name = "exc_trap_dabort",
	.event = "event=0x8c",
	.desc = "Exception taken, Data Abort or SError not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, Data Abort or SError not taken locally",
},
{
	.name = "exc_trap_fiq",
	.event = "event=0x8f",
	.desc = "Exception taken, FIQ not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, FIQ not taken locally",
},
{
	.name = "exc_trap_irq",
	.event = "event=0x8e",
	.desc = "Exception taken, IRQ not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, IRQ not taken locally",
},
{
	.name = "exc_trap_other",
	.event = "event=0x8d",
	.desc = "Exception taken, Other traps not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, Other traps not taken locally",
},
{
	.name = "exc_trap_pabort",
	.event = "event=0x8b",
	.desc = "Exception taken, Instruction Abort not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, Instruction Abort not taken locally",
},
{
	.name = "exc_undef",
	.event = "event=0x81",
	.desc = "Exception taken, Other synchronous",
	.topic = "core imp def",
	.long_desc = "Exception taken, Other synchronous",
},
{
	.name = "isb_spec",
	.event = "event=0x7c",
	.desc = "Barrier speculatively executed, ISB",
	.topic = "core imp def",
	.long_desc = "Barrier speculatively executed, ISB",
},
{
	.name = "l1d_cache_inval",
	.event = "event=0x48",
	.desc = "L1D cache invalidate",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache invalidate",
},
{
	.name = "l1d_cache_rd",
	.event = "event=0x40",
	.desc = "L1D cache access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache access, read",
},
{
	.name = "l1d_cache_refill_rd",
	.event = "event=0x42",
	.desc = "L1D cache refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, read",
},
{
	.name = "l1d_cache_refill_wr",
	.event = "event=0x43",
	.desc = "L1D cache refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, write",
},
{
	.name = "l1d_cache_wb_clean",
	.event = "event=0x47",
	.desc = "L1D cache Write-Back, cleaning and coherency",
	.topic = "core imp def",
	.long_desc = "Level 1 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l1d_cache_wb_victim",
	.event = "event=0x46",
	.desc = "L1D cache Write-Back, victim",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache Write-Back, victim",
},
{
	.name = "l1d_cache_wr",
	.event = "event=0x41",
	.desc = "L1D cache access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache access, write",
},
{
	.name = "l1d_tlb_refill_rd",
	.event = "event=0x4c",
	.desc = "L1D tlb refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data TLB refill, read",
},
{
	.name = "l1d_tlb_refill_wr",
	.event = "event=0x4d",
	.desc = "L1D tlb refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data TLB refill, write",
},
{
	.name = "l2d_cache_inval",
	.event = "event=0x58",
	.desc = "L2D cache invalidate",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache invalidate",
},
{
	.name = "l2d_cache_rd",
	.event = "event=0x50",
	.desc = "L2D cache access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache access, read",
},
{
	.name = "l2d_cache_refill_rd",
	.event = "event=0x52",
	.desc = "L2D cache refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache refill, read",
},
{
	.name = "l2d_cache_refill_wr",
	.event = "event=0x53",
	.desc = "L2D cache refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache refill, write",
},
{
	.name = "l2d_cache_wb_clean",
	.event = "event=0x57",
	.desc = "L2D cache Write-Back, cleaning and coherency",
	.topic = "core imp def",
	.long_desc = "Level 2 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l2d_cache_wb_victim",
	.event = "event=0x56",
	.desc = "L2D cache Write-Back, victim",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache Write-Back, victim",
},
{
	.name = "l2d_cache_wr",
	.event = "event=0x51",
	.desc = "L2D cache access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache access, write",
},
{
	.name = "ld_spec",
	.event = "event=0x70",
	.desc = "Operation speculatively executed, load",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, load",
},
{
	.name = "ldrex_spec",
	.event = "event=0x6c",
	.desc = "Exclusive operation speculatively executed, LDREX or LDX",
	.topic = "core imp def",
	.long_desc = "Exclusive operation speculatively executed, LDREX or LDX",
},
{
	.name = "ldst_spec",
	.event = "event=0x72",
	.desc = "Operation speculatively executed, load or store",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, load or store",
},
{
	.name = "mem_access_rd",
	.event = "event=0x66",
	.desc = "Data memory access, read",
	.topic = "core imp def",
	.long_desc = "Data memory access, read",
},
{
	.name = "mem_access_wr",
	.event = "event=0x67",
	.desc = "Data memory access, write",
	.topic = "core imp def",
	.long_desc = "Data memory access, write",
},
{
	.name = "pc_write_spec",
	.event = "event=0x76",
	.desc = "Operation speculatively executed, software change of the PC",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, software change of the PC",
},
{
	.name = "rc_ld_spec",
	.event = "event=0x90",
	.desc = "Release consistency operation speculatively executed, Load-Acquire",
	.topic = "core imp def",
	.long_desc = "Release consistency operation speculatively executed, Load-Acquire",
},
{
	.name = "rc_st_spec",
	.event = "event=0x91",
	.desc = "Release consistency operation speculatively executed, Store-Release",
	.topic = "core imp def",
	.long_desc = "Release consistency operation speculatively executed, Store-Release",
},
{
	.name = "st_spec",
	.event = "event=0x71",
	.desc = "Operation speculatively executed, store",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, store",
},
{
	.name = "strex_fail_spec",
	.event = "event=0x6e",
	.desc = "Exclusive operation speculatively executed, STREX or STX fail",
	.topic = "core imp def",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX fail",
},
{
	.name = "strex_pass_spec",
	.event = "event=0x6d",
	.desc = "Exclusive operation speculatively executed, STREX or STX pass",
	.topic = "core imp def",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX pass",
},
{
	.name = "unaligned_ld_spec",
	.event = "event=0x68",
	.desc = "Unaligned access, read",
	.topic = "core imp def",
	.long_desc = "Unaligned access, read",
},
{
	.name = "unaligned_ldst_spec",
	.event = "event=0x6a",
	.desc = "Unaligned access",
	.topic = "core imp def",
	.long_desc = "Unaligned access",
},
{
	.name = "unaligned_st_spec",
	.event = "event=0x69",
	.desc = "Unaligned access, write",
	.topic = "core imp def",
	.long_desc = "Unaligned access, write",
},
{
	.name = "vfp_spec",
	.event = "event=0x75",
	.desc = "Operation speculatively executed, floating-point instruction",
	.topic = "core imp def",
	.long_desc = "Operation speculatively executed, floating-point instruction",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_event pme_arm_cortex_a76_n1[] = {
{
	.name = "ase_spec",
	.event = "event=0x74",
	.desc = "Operation speculatively executed, Advanced SIMD instruction",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, Advanced SIMD instruction",
},
{
	.name = "br_immed_spec",
	.event = "event=0x78",
	.desc = "Branch speculatively executed, immediate branch",
	.topic = "instruction",
	.long_desc = "Branch speculatively executed, immediate branch",
},
{
	.name = "br_indirect_spec",
	.event = "event=0x7a",
	.desc = "Branch speculatively executed, indirect branch",
	.topic = "instruction",
	.long_desc = "Branch speculatively executed, indirect branch",
},
{
	.name = "br_mis_pred",
	.event = "event=0x10",
	.desc = "Mispredicted or not predicted branch speculatively executed",
	.topic = "branch",
	.long_desc = "Mispredicted or not predicted branch speculatively executed. This event counts any predictable branch instruction which is mispredicted either due to dynamic misprediction or because the MMU is off and the branches are statically predicted not taken",
},
{
	.name = "br_mis_pred_retired",
	.event = "event=0x22",
	.desc = "Instruction architecturally executed, mispredicted branch",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, mispredicted branch. This event counts any branch counted by BR_RETIRED which is not correctly predicted and causes a pipeline flush",
},
{
	.name = "br_pred",
	.event = "event=0x12",
	.desc = "Predictable branch speculatively executed",
	.topic = "branch",
	.long_desc = "Predictable branch speculatively executed. This event counts all predictable branches",
},
{
	.name = "br_retired",
	.event = "event=0x21",
	.desc = "Instruction architecturally executed, branch",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, branch. This event counts all branches, taken or not. This excludes exception entries, debug entries and CCFAIL branches",
},
{
	.name = "br_return_spec",
	.event = "event=0x79",
	.desc = "Branch speculatively executed, procedure return",
	.topic = "instruction",
	.long_desc = "Branch speculatively executed, procedure return",
},
{
	.name = "bus_access",
	.event = "event=0x19",
	.desc = "Bus access",
	.topic = "bus",
	.long_desc = "Bus access. This event counts for every beat of data transferred over the data channels between the core and the SCU. If both read and write data beats are transferred on a given cycle, this event is counted twice on that cycle. This event counts the sum of BUS_ACCESS_RD and BUS_ACCESS_WR",
},
{
	.name = "bus_access_rd",
	.event = "event=0x60",
	.desc = "Bus access read",
	.topic = "bus",
	.long_desc = "Bus access read",
},
{
	.name = "bus_access_wr",
	.event = "event=0x61",
	.desc = "Bus access write",
	.topic = "bus",
	.long_desc = "Bus access write",
},
{
	.name = "bus_cycles",
	.event = "event=0x1d",
	.desc = "Bus cycles. This event duplicates CPU_CYCLES",
	.topic = "bus",
},
{
	.name = "cid_write_retired",
	.event = "event=0xb",
	.desc = "Instruction architecturally executed, condition code check pass, write to CONTEXTIDR",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, condition code check pass, write to CONTEXTIDR. This event only counts writes to CONTEXTIDR in AArch32 state, and via the CONTEXTIDR_EL1 mnemonic in AArch64 state",
},
{
	.name = "cpu_cycles",
	.event = "event=0x11",
	.desc = "The number of core clock cycles",
	.topic = "bus",
},
{
	.name = "crypto_spec",
	.event = "event=0x77",
	.desc = "Operation speculatively executed, Cryptographic instruction",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, Cryptographic instruction",
},
{
	.name = "dmb_spec",
	.event = "event=0x7e",
	.desc = "Barrier speculatively executed, DMB",
	.topic = "instruction",
	.long_desc = "Barrier speculatively executed, DMB",
},
{
	.name = "dp_spec",
	.event = "event=0x73",
	.desc = "Operation speculatively executed, integer data processing",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, integer data processing",
},
{
	.name = "dsb_spec",
	.event = "event=0x7d",
	.desc = "Barrier speculatively executed, DSB",
	.topic = "instruction",
	.long_desc = "Barrier speculatively executed, DSB",
},
{
	.name = "dtlb_walk",
	.event = "event=0x34",
	.desc = "Access to data TLB that caused a page table walk",
	.topic = "cache",
	.long_desc = "Access to data TLB that caused a page table walk. This event counts on any data access which causes L2D_TLB_REFILL to count",
},
{
	.name = "exc_dabort",
	.event = "event=0x84",
	.desc = "Exception taken, Data Abort and SError",
	.topic = "exception",
	.long_desc = "Exception taken, Data Abort and SError",
},
{
	.name = "exc_fiq",
	.event = "event=0x87",
	.desc = "Exception taken, FIQ",
	.topic = "exception",
	.long_desc = "Exception taken, FIQ",
},
{
	.name = "exc_hvc",
	.event = "event=0x8a",
	.desc = "Exception taken, Hypervisor Call",
	.topic = "exception",
	.long_desc = "Exception taken, Hypervisor Call",
},
{
	.name = "exc_irq",
	.event = "event=0x86",
	.desc = "Exception taken, IRQ",
	.topic = "exception",
	.long_desc = "Exception taken, IRQ",
},
{
	.name = "exc_pabort",
	.event = "event=0x83",
	.desc = "Exception taken, Instruction Abort",
	.topic = "exception",
	.long_desc = "Exception taken, Instruction Abort",
},
{
	.name = "exc_return",
	.event = "event=0xa",
	.desc = "Instruction architecturally executed, condition code check pass, exception return",
	.topic = "instruction",
},
{
	.name = "exc_smc",
	.event = "event=0x88",
	.desc = "Exception taken, Secure Monitor Call",
	.topic = "exception",
	.long_desc = "Exception taken, Secure Monitor Call",
},
{
	.name = "exc_svc",
	.event = "event=0x82",
	.desc = "Exception taken, Supervisor Call",
	.topic = "exception",
	.long_desc = "Exception taken, Supervisor Call",
},
{
	.name = "exc_taken",
	.event = "event=0x9",
	.desc = "Exception taken",
	.topic = "exception",
},
{
	.name = "exc_trap_dabort",
	.event = "event=0x8c",
	.desc = "Exception taken, Data Abort or SError not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, Data Abort or SError not taken locally",
},
{
	.name = "exc_trap_fiq",
	.event = "event=0x8f",
	.desc = "Exception taken, FIQ not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, FIQ not taken locally",
},
{
	.name = "exc_trap_irq",
	.event = "event=0x8e",
	.desc = "Exception taken, IRQ not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, IRQ not taken locally",
},
{
	.name = "exc_trap_other",
	.event = "event=0x8d",
	.desc = "Exception taken, Other traps not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, Other traps not taken locally",
},
{
	.name = "exc_trap_pabort",
	.event = "event=0x8b",
	.desc = "Exception taken, Instruction Abort not taken locally",
	.topic = "exception",
	.long_desc = "Exception taken, Instruction Abort not taken locally",
},
{
	.name = "exc_undef",
	.event = "event=0x81",
	.desc = "Exception taken, Other synchronous",
	.topic = "exception",
	.long_desc = "Exception taken, Other synchronous",
},
{
	.name = "inst_retired",
	.event = "event=0x8",
	.desc = "Instruction architecturally executed",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed. This event counts all retired instructions, including those that fail their condition check",
},
{
	.name = "inst_spec",
	.event = "event=0x1b",
	.desc = "Operation speculatively executed",
	.topic = "instruction",
},
{
	.name = "isb_spec",
	.event = "event=0x7c",
	.desc = "Barrier speculatively executed, ISB",
	.topic = "instruction",
	.long_desc = "Barrier speculatively executed, ISB",
},
{
	.name = "itlb_walk",
	.event = "event=0x35",
	.desc = "Access to instruction TLB that caused a page table walk",
	.topic = "cache",
	.long_desc = "Access to instruction TLB that caused a page table walk. This event counts on any instruction access which causes L2D_TLB_REFILL to count",
},
{
	.name = "l1d_cache",
	.event = "event=0x4",
	.desc = "L1 data cache access",
	.topic = "cache",
	.long_desc = "L1 data cache access. This event counts any load or store operation or page table walk access which looks up in the L1 data cache. In particular, any access which could count the L1D_CACHE_REFILL event causes this event to count",
},
{
	.name = "l1d_cache_inval",
	.event = "event=0x48",
	.desc = "L1D cache invalidate",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache invalidate",
},
{
	.name = "l1d_cache_rd",
	.event = "event=0x40",
	.desc = "L1D cache access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache access, read",
},
{
	.name = "l1d_cache_refill",
	.event = "event=0x3",
	.desc = "L1 data cache refill",
	.topic = "cache",
	.long_desc = "L1 data cache refill. This event counts any load or store operation or page table walk access which causes data to be read from outside the L1, including accesses which do not allocate into L1",
},
{
	.name = "l1d_cache_refill_inner",
	.event = "event=0x44",
	.desc = "L1D cache refill, inner",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache refill, inner",
},
{
	.name = "l1d_cache_refill_outer",
	.event = "event=0x45",
	.desc = "L1D cache refill, outer",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache refill, outer",
},
{
	.name = "l1d_cache_refill_rd",
	.event = "event=0x42",
	.desc = "L1D cache refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache refill, read",
},
{
	.name = "l1d_cache_refill_wr",
	.event = "event=0x43",
	.desc = "L1D cache refill, write",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache refill, write",
},
{
	.name = "l1d_cache_wb",
	.event = "event=0x15",
	.desc = "L1 data cache Write-Back",
	.topic = "cache",
	.long_desc = "L1 data cache Write-Back. This event counts any write-back of data from the L1 data cache to L2 or L3. This counts both victim line evictions and snoops, including cache maintenance operations",
},
{
	.name = "l1d_cache_wb_clean",
	.event = "event=0x47",
	.desc = "L1D cache Write-Back, cleaning and coherency",
	.topic = "cache",
	.long_desc = "Level 1 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l1d_cache_wb_victim",
	.event = "event=0x46",
	.desc = "L1D cache Write-Back, victim",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache Write-Back, victim",
},
{
	.name = "l1d_cache_wr",
	.event = "event=0x41",
	.desc = "L1D cache access, write",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data cache access, write",
},
{
	.name = "l1d_tlb",
	.event = "event=0x25",
	.desc = "Level 1 data TLB access",
	.topic = "cache",
	.long_desc = "Level 1 data TLB access. This event counts any load or store operation which accesses the data L1 TLB. If both a load and a store are executed on a cycle, this event counts twice. This event counts regardless of whether the MMU is enabled",
},
{
	.name = "l1d_tlb_rd",
	.event = "event=0x4e",
	.desc = "L1D tlb access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data or unified TLB access, read",
},
{
	.name = "l1d_tlb_refill",
	.event = "event=0x5",
	.desc = "L1 data TLB refill",
	.topic = "cache",
	.long_desc = "L1 data TLB refill. This event counts any refill of the data L1 TLB from the L2 TLB. This includes refills that result in a translation fault",
},
{
	.name = "l1d_tlb_refill_rd",
	.event = "event=0x4c",
	.desc = "L1D tlb refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data TLB refill, read",
},
{
	.name = "l1d_tlb_refill_wr",
	.event = "event=0x4d",
	.desc = "L1D tlb refill, write",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data TLB refill, write",
},
{
	.name = "l1d_tlb_wr",
	.event = "event=0x4f",
	.desc = "L1D tlb access, write",
	.topic = "cache",
	.long_desc = "Attributable Level 1 data or unified TLB access, write",
},
{
	.name = "l1i_cache",
	.event = "event=0x14",
	.desc = "L1 instruction cache access",
	.topic = "cache",
	.long_desc = "Level 1 instruction cache access or Level 0 Macro-op cache access. This event counts any instruction fetch which accesses the L1 instruction cache or L0 Macro-op cache",
},
{
	.name = "l1i_cache_refill",
	.event = "event=0x1",
	.desc = "L1 instruction cache refill",
	.topic = "cache",
	.long_desc = "L1 instruction cache refill. This event counts any instruction fetch which misses in the cache",
},
{
	.name = "l1i_tlb",
	.event = "event=0x26",
	.desc = "Level 1 instruction TLB access",
	.topic = "cache",
	.long_desc = "Level 1 instruction TLB access. This event counts any instruction fetch which accesses the instruction L1 TLB.This event counts regardless of whether the MMU is enabled",
},
{
	.name = "l1i_tlb_refill",
	.event = "event=0x2",
	.desc = "L1 instruction TLB refill",
	.topic = "cache",
	.long_desc = "L1 instruction TLB refill. This event counts any refill of the instruction L1 TLB from the L2 TLB. This includes refills that result in a translation fault",
},
{
	.name = "l2d_cache",
	.event = "event=0x16",
	.desc = "L2 data cache access",
	.topic = "cache",
	.long_desc = "L2 data cache access. This event counts any transaction from L1 which looks up in the L2 cache, and any write-back from the L1 to the L2. Snoops from outside the core and cache maintenance operations are not counted",
},
{
	.name = "l2d_cache_allocate",
	.event = "event=0x20",
	.desc = "L2 data cache allocation without refill",
	.topic = "cache",
	.long_desc = "L2 data cache allocation without refill. This event counts any full cache line write into the L2 cache which does not cause a linefill, including write-backs from L1 to L2 and full-line writes which do not allocate into L1",
},
{
	.name = "l2d_cache_inval",
	.event = "event=0x58",
	.desc = "L2D cache invalidate",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache invalidate",
},
{
	.name = "l2d_cache_rd",
	.event = "event=0x50",
	.desc = "L2D cache access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache access, read",
},
{
	.name = "l2d_cache_refill",
	.event = "event=0x17",
	.desc = "L2 data cache refill",
	.topic = "cache",
	.long_desc = "L2 data cache refill. This event counts any cacheable transaction from L1 which causes data to be read from outside the core. L2 refills caused by stashes into L2 should not be counted",
},
{
	.name = "l2d_cache_refill_rd",
	.event = "event=0x52",
	.desc = "L2D cache refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache refill, read",
},
{
	.name = "l2d_cache_refill_wr",
	.event = "event=0x53",
	.desc = "L2D cache refill, write",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache refill, write",
},
{
	.name = "l2d_cache_wb",
	.event = "event=0x18",
	.desc = "L2 data cache write-back",
	.topic = "cache",
	.long_desc = "L2 data cache write-back. This event counts any write-back of data from the L2 cache to outside the core. This includes snoops to the L2 which return data, regardless of whether they cause an invalidation. Invalidations from the L2 which do not write data outside of the core and snoops which return data from the L1 are not counted",
},
{
	.name = "l2d_cache_wb_clean",
	.event = "event=0x57",
	.desc = "L2D cache Write-Back, cleaning and coherency",
	.topic = "cache",
	.long_desc = "Level 2 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l2d_cache_wb_victim",
	.event = "event=0x56",
	.desc = "L2D cache Write-Back, victim",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache Write-Back, victim",
},
{
	.name = "l2d_cache_wr",
	.event = "event=0x51",
	.desc = "L2D cache access, write",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data cache access, write",
},
{
	.name = "l2d_tlb",
	.event = "event=0x2f",
	.desc = "Attributable L2 data or unified TLB access",
	.topic = "cache",
	.long_desc = "Attributable L2 data or unified TLB access. This event counts on any access to the L2 TLB (caused by a refill of any of the L1 TLBs). This event does not count if the MMU is disabled",
},
{
	.name = "l2d_tlb_rd",
	.event = "event=0x5e",
	.desc = "L2D cache access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data or unified TLB access, read",
},
{
	.name = "l2d_tlb_refill",
	.event = "event=0x2d",
	.desc = "Attributable L2 data or unified TLB refill",
	.topic = "cache",
	.long_desc = "Attributable L2 data or unified TLB refill. This event counts on anyrefill of the L2 TLB, caused by either an instruction or data access.This event does not count if the MMU is disabled",
},
{
	.name = "l2d_tlb_refill_rd",
	.event = "event=0x5c",
	.desc = "L2D cache refill, read",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data or unified TLB refill, read",
},
{
	.name = "l2d_tlb_refill_wr",
	.event = "event=0x5d",
	.desc = "L2D cache refill, write",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data or unified TLB refill, write",
},
{
	.name = "l2d_tlb_wr",
	.event = "event=0x5f",
	.desc = "L2D cache access, write",
	.topic = "cache",
	.long_desc = "Attributable Level 2 data or unified TLB access, write",
},
{
	.name = "l3d_cache",
	.event = "event=0x2b",
	.desc = "Attributable Level 3 unified cache access",
	.topic = "cache",
	.long_desc = "Attributable Level 3 unified cache access. This event counts for any cacheable read transaction returning datafrom the SCU, or for any cacheable write to the SCU",
},
{
	.name = "l3d_cache_allocate",
	.event = "event=0x29",
	.desc = "Allocation without refill",
	.topic = "cache",
	.long_desc = "This event counts any full cache line write into the L3 cache which does not cause a linefill, including write-backs from L2 to L3 and full-line writes which do not allocate into L2",
},
{
	.name = "l3d_cache_rd",
	.event = "event=0xa0",
	.desc = "Attributable Level 3 data or unified cache access, read",
	.topic = "cache",
	.long_desc = "Attributable Level 3 data or unified cache access, read",
},
{
	.name = "l3d_cache_refill",
	.event = "event=0x2a",
	.desc = "Attributable Level 3 unified cache refill",
	.topic = "cache",
	.long_desc = "Attributable Level 3 unified cache refill. This event counts for any cacheable read transaction returning datafrom the SCU for which the data source was outside the cluster. Transactions such as ReadUnique are counted here as 'read' transactions, even though they can be generated by store instructions",
},
{
	.name = "ld_spec",
	.event = "event=0x70",
	.desc = "Operation speculatively executed, load",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, load",
},
{
	.name = "ldrex_spec",
	.event = "event=0x6c",
	.desc = "Exclusive operation speculatively executed, LDREX or LDX",
	.topic = "instruction",
	.long_desc = "Exclusive operation speculatively executed, LDREX or LDX",
},
{
	.name = "ldst_spec",
	.event = "event=0x72",
	.desc = "Operation speculatively executed, load or store",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, load or store",
},
{
	.name = "ll_cache_miss_rd",
	.event = "event=0x37",
	.desc = "Last level cache miss, read",
	.topic = "cache",
},
{
	.name = "ll_cache_rd",
	.event = "event=0x36",
	.desc = "Last level cache access, read",
	.topic = "cache",
},
{
	.name = "mem_access",
	.event = "event=0x13",
	.desc = "Data memory access",
	.topic = "memory",
	.long_desc = "Data memory access. This event counts memory accesses due to load or store instructions. This event counts the sum of MEM_ACCESS_RD and MEM_ACCESS_WR",
},
{
	.name = "mem_access_rd",
	.event = "event=0x66",
	.desc = "Data memory access, read",
	.topic = "memory",
	.long_desc = "Data memory access, read",
},
{
	.name = "mem_access_wr",
	.event = "event=0x67",
	.desc = "Data memory access, write",
	.topic = "memory",
	.long_desc = "Data memory access, write",
},
{
	.name = "memory_error",
	.event = "event=0x1a",
	.desc = "Local memory error",
	.topic = "exception",
	.long_desc = "Local memory error. This event counts any correctable or uncorrectable memory error (ECC or parity) in the protected core RAMs",
},
{
	.name = "pc_write_spec",
	.event = "event=0x76",
	.desc = "Operation speculatively executed, software change of the PC",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, software change of the PC",
},
{
	.name = "rc_ld_spec",
	.event = "event=0x90",
	.desc = "Release consistency operation speculatively executed, Load-Acquire",
	.topic = "instruction",
	.long_desc = "Release consistency operation speculatively executed, Load-Acquire",
},
{
	.name = "rc_st_spec",
	.event = "event=0x91",
	.desc = "Release consistency operation speculatively executed, Store-Release",
	.topic = "instruction",
	.long_desc = "Release consistency operation speculatively executed, Store-Release",
},
{
	.name = "remote_access",
	.event = "event=0x31",
	.desc = "Access to another socket in a multi-socket system",
	.topic = "other",
},
{
	.name = "st_spec",
	.event = "event=0x71",
	.desc = "Operation speculatively executed, store",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, store",
},
{
	.name = "stall_backend",
	.event = "event=0x24",
	.desc = "No operation issued because of the backend",
	.topic = "pipeline",
	.long_desc = "No operation issued because of the backend. The counter counts on any cycle fetched instructions are not dispatched due to resource constraints",
},
{
	.name = "stall_frontend",
	.event = "event=0x23",
	.desc = "No operation issued because of the frontend",
	.topic = "pipeline",
	.long_desc = "No operation issued because of the frontend. The counter counts on any cycle when there are no fetched instructions available to dispatch",
},
{
	.name = "strex_fail_spec",
	.event = "event=0x6e",
	.desc = "Exclusive operation speculatively executed, STREX or STX fail",
	.topic = "instruction",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX fail",
},
{
	.name = "strex_pass_spec",
	.event = "event=0x6d",
	.desc = "Exclusive operation speculatively executed, STREX or STX pass",
	.topic = "instruction",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX pass",
},
{
	.name = "strex_spec",
	.event = "event=0x6f",
	.desc = "Exclusive operation speculatively executed, STREX or STX",
	.topic = "instruction",
	.long_desc = "Exclusive operation speculatively executed, STREX or STX",
},
{
	.name = "sw_incr",
	.event = "event=0",
	.desc = "Software increment",
	.topic = "instruction",
	.long_desc = "Software increment. Instruction architecturally executed (condition code check pass)",
},
{
	.name = "ttbr_write_retired",
	.event = "event=0x1c",
	.desc = "Instruction architecturally executed, condition code check pass, write to TTBR",
	.topic = "instruction",
	.long_desc = "Instruction architecturally executed, condition code check pass, write to TTBR. This event only counts writes to TTBR0/TTBR1 in AArch32 state and TTBR0_EL1/TTBR1_EL1 in AArch64 state",
},
{
	.name = "unaligned_ld_spec",
	.event = "event=0x68",
	.desc = "Unaligned access, read",
	.topic = "memory",
	.long_desc = "Unaligned access, read",
},
{
	.name = "unaligned_ldst_spec",
	.event = "event=0x6a",
	.desc = "Unaligned access",
	.topic = "memory",
	.long_desc = "Unaligned access",
},
{
	.name = "unaligned_st_spec",
	.event = "event=0x69",
	.desc = "Unaligned access, write",
	.topic = "memory",
	.long_desc = "Unaligned access, write",
},
{
	.name = "vfp_spec",
	.event = "event=0x75",
	.desc = "Operation speculatively executed, floating-point instruction",
	.topic = "instruction",
	.long_desc = "Operation speculatively executed, floating-point instruction",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_event pme_cavium_thunderx2[] = {
{
	.name = "bus_access_rd",
	.event = "event=0x60",
	.desc = "Bus access read",
	.topic = "core imp def",
	.long_desc = "Bus access read",
},
{
	.name = "bus_access_wr",
	.event = "event=0x61",
	.desc = "Bus access write",
	.topic = "core imp def",
	.long_desc = "Bus access write",
},
{
	.name = "exc_dabort",
	.event = "event=0x84",
	.desc = "Exception taken, Data Abort and SError",
	.topic = "core imp def",
	.long_desc = "Exception taken, Data Abort and SError",
},
{
	.name = "exc_fiq",
	.event = "event=0x87",
	.desc = "Exception taken, FIQ",
	.topic = "core imp def",
	.long_desc = "Exception taken, FIQ",
},
{
	.name = "exc_hvc",
	.event = "event=0x8a",
	.desc = "Exception taken, Hypervisor Call",
	.topic = "core imp def",
	.long_desc = "Exception taken, Hypervisor Call",
},
{
	.name = "exc_irq",
	.event = "event=0x86",
	.desc = "Exception taken, IRQ",
	.topic = "core imp def",
	.long_desc = "Exception taken, IRQ",
},
{
	.name = "exc_pabort",
	.event = "event=0x83",
	.desc = "Exception taken, Instruction Abort",
	.topic = "core imp def",
	.long_desc = "Exception taken, Instruction Abort",
},
{
	.name = "exc_smc",
	.event = "event=0x88",
	.desc = "Exception taken, Secure Monitor Call",
	.topic = "core imp def",
	.long_desc = "Exception taken, Secure Monitor Call",
},
{
	.name = "exc_svc",
	.event = "event=0x82",
	.desc = "Exception taken, Supervisor Call",
	.topic = "core imp def",
	.long_desc = "Exception taken, Supervisor Call",
},
{
	.name = "exc_trap_dabort",
	.event = "event=0x8c",
	.desc = "Exception taken, Data Abort or SError not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, Data Abort or SError not taken locally",
},
{
	.name = "exc_trap_fiq",
	.event = "event=0x8f",
	.desc = "Exception taken, FIQ not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, FIQ not taken locally",
},
{
	.name = "exc_trap_irq",
	.event = "event=0x8e",
	.desc = "Exception taken, IRQ not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, IRQ not taken locally",
},
{
	.name = "exc_trap_other",
	.event = "event=0x8d",
	.desc = "Exception taken, Other traps not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, Other traps not taken locally",
},
{
	.name = "exc_trap_pabort",
	.event = "event=0x8b",
	.desc = "Exception taken, Instruction Abort not taken locally",
	.topic = "core imp def",
	.long_desc = "Exception taken, Instruction Abort not taken locally",
},
{
	.name = "exc_undef",
	.event = "event=0x81",
	.desc = "Exception taken, Other synchronous",
	.topic = "core imp def",
	.long_desc = "Exception taken, Other synchronous",
},
{
	.name = "l1d_cache_inval",
	.event = "event=0x48",
	.desc = "L1D cache invalidate",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache invalidate",
},
{
	.name = "l1d_cache_rd",
	.event = "event=0x40",
	.desc = "L1D cache access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache access, read",
},
{
	.name = "l1d_cache_refill_inner",
	.event = "event=0x44",
	.desc = "L1D cache refill, inner",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, inner",
},
{
	.name = "l1d_cache_refill_outer",
	.event = "event=0x45",
	.desc = "L1D cache refill, outer",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, outer",
},
{
	.name = "l1d_cache_refill_rd",
	.event = "event=0x42",
	.desc = "L1D cache refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, read",
},
{
	.name = "l1d_cache_refill_wr",
	.event = "event=0x43",
	.desc = "L1D cache refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, write",
},
{
	.name = "l1d_cache_wb_clean",
	.event = "event=0x47",
	.desc = "L1D cache Write-Back, cleaning and coherency",
	.topic = "core imp def",
	.long_desc = "Level 1 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l1d_cache_wb_victim",
	.event = "event=0x46",
	.desc = "L1D cache Write-Back, victim",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache Write-Back, victim",
},
{
	.name = "l1d_cache_wr",
	.event = "event=0x41",
	.desc = "L1D cache access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache access, write",
},
{
	.name = "l1d_tlb_rd",
	.event = "event=0x4e",
	.desc = "L1D tlb access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data or unified TLB access, read",
},
{
	.name = "l1d_tlb_refill_rd",
	.event = "event=0x4c",
	.desc = "L1D tlb refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data TLB refill, read",
},
{
	.name = "l1d_tlb_refill_wr",
	.event = "event=0x4d",
	.desc = "L1D tlb refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data TLB refill, write",
},
{
	.name = "l1d_tlb_wr",
	.event = "event=0x4f",
	.desc = "L1D tlb access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data or unified TLB access, write",
},
{
	.name = "l2d_tlb_rd",
	.event = "event=0x5e",
	.desc = "L2D cache access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data or unified TLB access, read",
},
{
	.name = "l2d_tlb_refill_rd",
	.event = "event=0x5c",
	.desc = "L2D cache refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data or unified TLB refill, read",
},
{
	.name = "l2d_tlb_refill_wr",
	.event = "event=0x5d",
	.desc = "L2D cache refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data or unified TLB refill, write",
},
{
	.name = "l2d_tlb_wr",
	.event = "event=0x5f",
	.desc = "L2D cache access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data or unified TLB access, write",
},
{
	.name = "mem_access_rd",
	.event = "event=0x66",
	.desc = "Data memory access, read",
	.topic = "core imp def",
	.long_desc = "Data memory access, read",
},
{
	.name = "mem_access_wr",
	.event = "event=0x67",
	.desc = "Data memory access, write",
	.topic = "core imp def",
	.long_desc = "Data memory access, write",
},
{
	.name = "unaligned_ld_spec",
	.event = "event=0x68",
	.desc = "Unaligned access, read",
	.topic = "core imp def",
	.long_desc = "Unaligned access, read",
},
{
	.name = "unaligned_ldst_spec",
	.event = "event=0x6a",
	.desc = "Unaligned access",
	.topic = "core imp def",
	.long_desc = "Unaligned access",
},
{
	.name = "unaligned_st_spec",
	.event = "event=0x69",
	.desc = "Unaligned access, write",
	.topic = "core imp def",
	.long_desc = "Unaligned access, write",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_event pme_hisilicon_hip08[] = {
{
	.name = "exe_stall_cycle",
	.event = "event=0x7001",
	.desc = "Cycles of that the number of issue ups are less than 4",
	.topic = "core imp def",
	.long_desc = "Cycles of that the number of issuing micro operations are less than 4",
},
{
	.name = "fetch_bubble",
	.event = "event=0x2014",
	.desc = "Instructions can receive, but not send",
	.topic = "core imp def",
	.long_desc = "Instructions can receive, but not send",
},
{
	.name = "hit_on_prf",
	.event = "event=0x6014",
	.desc = "Hit on prefetched data",
	.topic = "core imp def",
	.long_desc = "Hit on prefetched data",
},
{
	.name = "if_is_stall",
	.event = "event=0x1044",
	.desc = "Instruction fetch stall cycles",
	.topic = "core imp def",
	.long_desc = "Instruction fetch stall cycles",
},
{
	.name = "iq_is_empty",
	.event = "event=0x1043",
	.desc = "Instruction queue is empty",
	.topic = "core imp def",
	.long_desc = "Instruction queue is empty",
},
{
	.name = "l1d_cache_inval",
	.event = "event=0x48",
	.desc = "L1D cache invalidate",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache invalidate",
},
{
	.name = "l1d_cache_rd",
	.event = "event=0x40",
	.desc = "L1D cache access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache access, read",
},
{
	.name = "l1d_cache_refill_rd",
	.event = "event=0x42",
	.desc = "L1D cache refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, read",
},
{
	.name = "l1d_cache_refill_wr",
	.event = "event=0x43",
	.desc = "L1D cache refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache refill, write",
},
{
	.name = "l1d_cache_wb_clean",
	.event = "event=0x47",
	.desc = "L1D cache Write-Back, cleaning and coherency",
	.topic = "core imp def",
	.long_desc = "Level 1 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l1d_cache_wb_victim",
	.event = "event=0x46",
	.desc = "L1D cache Write-Back, victim",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache Write-Back, victim",
},
{
	.name = "l1d_cache_wr",
	.event = "event=0x41",
	.desc = "L1D cache access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data cache access, write",
},
{
	.name = "l1d_tlb_rd",
	.event = "event=0x4e",
	.desc = "L1D tlb access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data or unified TLB access, read",
},
{
	.name = "l1d_tlb_refill_rd",
	.event = "event=0x4c",
	.desc = "L1D tlb refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data TLB refill, read",
},
{
	.name = "l1d_tlb_refill_wr",
	.event = "event=0x4d",
	.desc = "L1D tlb refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data TLB refill, write",
},
{
	.name = "l1d_tlb_wr",
	.event = "event=0x4f",
	.desc = "L1D tlb access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 1 data or unified TLB access, write",
},
{
	.name = "l1i_cache_prf",
	.event = "event=0x102e",
	.desc = "L1I cache prefetch access count",
	.topic = "core imp def",
	.long_desc = "Level 1 instruction cache prefetch access count",
},
{
	.name = "l1i_cache_prf_refill",
	.event = "event=0x102f",
	.desc = "L1I cache miss due to prefetch access count",
	.topic = "core imp def",
	.long_desc = "Level 1 instruction cache miss due to prefetch access count",
},
{
	.name = "l2d_cache_inval",
	.event = "event=0x58",
	.desc = "L2D cache invalidate",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache invalidate",
},
{
	.name = "l2d_cache_rd",
	.event = "event=0x50",
	.desc = "L2D cache access, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache access, read",
},
{
	.name = "l2d_cache_refill_rd",
	.event = "event=0x52",
	.desc = "L2D cache refill, read",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache refill, read",
},
{
	.name = "l2d_cache_refill_wr",
	.event = "event=0x53",
	.desc = "L2D cache refill, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache refill, write",
},
{
	.name = "l2d_cache_wb_clean",
	.event = "event=0x57",
	.desc = "L2D cache Write-Back, cleaning and coherency",
	.topic = "core imp def",
	.long_desc = "Level 2 data cache Write-Back, cleaning and coherency",
},
{
	.name = "l2d_cache_wb_victim",
	.event = "event=0x56",
	.desc = "L2D cache Write-Back, victim",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache Write-Back, victim",
},
{
	.name = "l2d_cache_wr",
	.event = "event=0x51",
	.desc = "L2D cache access, write",
	.topic = "core imp def",
	.long_desc = "Attributable Level 2 data cache access, write",
},
{
	.name = "mem_stall_anyload",
	.event = "event=0x7004",
	.desc = "No any micro operation is issued and meanwhile any load operation is not resolved",
	.topic = "core imp def",
	.long_desc = "No any micro operation is issued and meanwhile any load operation is not resolved",
},
{
	.name = "mem_stall_l1miss",
	.event = "event=0x7006",
	.desc = "No any micro operation is issued and meanwhile there is any load operation missing L1 cache and pending data refill",
	.topic = "core imp def",
	.long_desc = "No any micro operation is issued and meanwhile there is any load operation missing L1 cache and pending data refill",
},
{
	.name = "mem_stall_l2miss",
	.event = "event=0x7007",
	.desc = "No any micro operation is issued and meanwhile there is any load operation missing both L1 and L2 cache and pending data refill from L3 cache",
	.topic = "core imp def",
	.long_desc = "No any micro operation is issued and meanwhile there is any load operation missing both L1 and L2 cache and pending data refill from L3 cache",
},
{
	.name = "prf_req",
	.event = "event=0x6013",
	.desc = "Prefetch request from LSU",
	.topic = "core imp def",
	.long_desc = "Prefetch request from LSU",
},
{
	.name = "uncore_hisi_ddrc.act_cmd",
	.event = "event=0x5",
	.desc = "DDRC active commands. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC active commands",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.flux_rcmd",
	.event = "event=0x3",
	.desc = "DDRC read commands. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC read commands",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.flux_rd",
	.event = "event=0x1",
	.desc = "DDRC total read operations. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC total read operations",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.flux_wcmd",
	.event = "event=0x2",
	.desc = "DDRC write commands. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC write commands",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.flux_wr",
	.event = "event=0",
	.desc = "DDRC total write operations. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC total write operations",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.pre_cmd",
	.event = "event=0x4",
	.desc = "DDRC precharge commands. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC precharge commands",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.rnk_chg",
	.event = "event=0x6",
	.desc = "DDRC rank commands. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC rank commands",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_ddrc.rw_chg",
	.event = "event=0x7",
	.desc = "DDRC read and write changes. Unit: hisi_sccl,ddrc ",
	.topic = "uncore ddrc",
	.long_desc = "DDRC read and write changes",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = "uncore_hisi_hha.rd_ddr_128b",
	.event = "event=0x1e",
	.desc = "The number of read operations sent by HHA to DDRC which size is 128 bytes. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of read operations sent by HHA to DDRC which size is 128 bytes",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.rd_ddr_64b",
	.event = "event=0x1c",
	.desc = "The number of read operations sent by HHA to DDRC which size is 64 bytes. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of read operations sent by HHA to DDRC which size is 64bytes",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.rx_ccix",
	.event = "event=0x3",
	.desc = "Count of the number of operations that HHA has received from CCIX. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "Count of the number of operations that HHA has received from CCIX",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.rx_ops_num",
	.event = "event=0",
	.desc = "The number of all operations received by the HHA. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of all operations received by the HHA",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.rx_outer",
	.event = "event=0x1",
	.desc = "The number of all operations received by the HHA from another socket. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of all operations received by the HHA from another socket",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.rx_sccl",
	.event = "event=0x2",
	.desc = "The number of all operations received by the HHA from another SCCL in this socket. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of all operations received by the HHA from another SCCL in this socket",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.spill_num",
	.event = "event=0x20",
	.desc = "Count of the number of spill operations that the HHA has sent. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "Count of the number of spill operations that the HHA has sent",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.spill_success",
	.event = "event=0x21",
	.desc = "Count of the number of successful spill operations that the HHA has sent. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "Count of the number of successful spill operations that the HHA has sent",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.wr_ddr_128b",
	.event = "event=0x1f",
	.desc = "The number of write operations sent by HHA to DDRC which size is 128 bytes. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of write operations sent by HHA to DDRC which size is 128 bytes",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_hha.wr_ddr_64b",
	.event = "event=0x1d",
	.desc = "The number of write operations sent by HHA to DDRC which size is 64 bytes. Unit: hisi_sccl,hha ",
	.topic = "uncore hha",
	.long_desc = "The number of write operations sent by HHA to DDRC which size is 64 bytes",
	.pmu = "hisi_sccl,hha",
},
{
	.name = "uncore_hisi_l3c.back_invalid",
	.event = "event=0x29",
	.desc = "Count of the number of L3C back invalid operations. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of L3C back invalid operations",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.prefetch_drop",
	.event = "event=0x42",
	.desc = "Count of the number of prefetch drops from this L3C. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of prefetch drops from this L3C",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.rd_cpipe",
	.event = "event=0",
	.desc = "Total read accesses. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Total read accesses",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.rd_hit_cpipe",
	.event = "event=0x2",
	.desc = "Total read hits. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Total read hits",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.rd_hit_spipe",
	.event = "event=0x22",
	.desc = "Count of the number of read lines that hits in spipe of this L3C. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of read lines that hits in spipe of this L3C",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.rd_spipe",
	.event = "event=0x20",
	.desc = "Count of the number of read lines that come from this cluster of CPU core in spipe. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of read lines that come from this cluster of CPU core in spipe",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.retry_cpu",
	.event = "event=0x40",
	.desc = "Count of the number of retry that L3C suppresses the CPU operations. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of retry that L3C suppresses the CPU operations",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.retry_ring",
	.event = "event=0x41",
	.desc = "Count of the number of retry that L3C suppresses the ring operations. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of retry that L3C suppresses the ring operations",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.victim_num",
	.event = "event=0x4",
	.desc = "l3c precharge commands. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "l3c precharge commands",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.wr_cpipe",
	.event = "event=0x1",
	.desc = "Total write accesses. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Total write accesses",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.wr_hit_cpipe",
	.event = "event=0x3",
	.desc = "Total write hits. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Total write hits",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.wr_hit_spipe",
	.event = "event=0x23",
	.desc = "Count of the number of write lines that hits in spipe of this L3C. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of write lines that hits in spipe of this L3C",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = "uncore_hisi_l3c.wr_spipe",
	.event = "event=0x21",
	.desc = "Count of the number of write lines that come from this cluster of CPU core in spipe. Unit: hisi_sccl,l3c ",
	.topic = "uncore l3c",
	.long_desc = "Count of the number of write lines that come from this cluster of CPU core in spipe",
	.pmu = "hisi_sccl,l3c",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_event pme_test_cpu[] = {
{
	.name = "bp_l1_btb_correct",
	.event = "event=0x8a",
	.desc = "L1 BTB Correction",
	.topic = "branch",
},
{
	.name = "bp_l2_btb_correct",
	.event = "event=0x8b",
	.desc = "L2 BTB Correction",
	.topic = "branch",
},
{
	.name = "dispatch_blocked.any",
	.event = "umask=0x20,period=200000,event=0x9",
	.desc = "Memory cluster signals to block micro-op dispatch for any reason",
	.topic = "other",
},
{
	.name = "eist_trans",
	.event = "umask=0x0,period=200000,event=0x3a",
	.desc = "Number of Enhanced Intel SpeedStep(R) Technology (EIST) transitions",
	.topic = "other",
},
{
	.name = "segment_reg_loads.any",
	.event = "umask=0x80,period=200000,event=0x6",
	.desc = "Number of segment register loads",
	.topic = "other",
},
{
	.name = "unc_cbo_xsnp_response.miss_eviction",
	.event = "umask=0x81,event=0x22",
	.desc = "Unit: uncore_cbox A cross-core snoop resulted from L3 Eviction which misses in some processor core",
	.topic = "uncore",
	.long_desc = "A cross-core snoop resulted from L3 Eviction which misses in some processor core",
	.pmu = "uncore_cbox",
},
{
	.name = "uncore_hisi_ddrc.flux_wcmd",
	.event = "event=0x2",
	.desc = "DDRC write commands. Unit: hisi_sccl,ddrc ",
	.topic = "uncore",
	.long_desc = "DDRC write commands",
	.pmu = "hisi_sccl,ddrc",
},
{
	.name = 0,
	.event = 0,
	.desc = 0,
},
};
struct pmu_events_map pmu_events_map[] = {
{
	.cpuid = "0x00000000410fd030",
	.version = "v1",
	.type = "core",
	.table = pme_arm_cortex_a53
},
{
	.cpuid = "0x00000000410fd070",
	.version = "v1",
	.type = "core",
	.table = pme_arm_cortex_a57_a72
},
{
	.cpuid = "0x00000000410fd080",
	.version = "v1",
	.type = "core",
	.table = pme_arm_cortex_a57_a72
},
{
	.cpuid = "0x00000000410fd0b0",
	.version = "v1",
	.type = "core",
	.table = pme_arm_cortex_a76_n1
},
{
	.cpuid = "0x00000000410fd0c0",
	.version = "v1",
	.type = "core",
	.table = pme_arm_cortex_a76_n1
},
{
	.cpuid = "0x00000000420f1000",
	.version = "v1",
	.type = "core",
	.table = pme_arm_cortex_a53
},
{
	.cpuid = "0x00000000420f5160",
	.version = "v1",
	.type = "core",
	.table = pme_cavium_thunderx2
},
{
	.cpuid = "0x00000000430f0af0",
	.version = "v1",
	.type = "core",
	.table = pme_cavium_thunderx2
},
{
	.cpuid = "0x00000000480fd010",
	.version = "v1",
	.type = "core",
	.table = pme_hisilicon_hip08
},
{
	.cpuid = "0x00000000500f0000",
	.version = "v1",
	.type = "core",
	.table = pme_ampere_emag
},
{
	.cpuid = "testcpu",
	.version = "v1",
	.type = "core",
	.table = pme_test_cpu,
},
{
	.cpuid = 0,
	.version = 0,
	.type = 0,
	.table = 0,
},
};
