#!/usr/bin/env python3
# /********************************************************************************
# * Copyright (c) 2025 Contributors to the Eclipse Foundation
# *
# * See the NOTICE file(s) distributed with this work for additional
# * information regarding copyright ownership.
# *
# * This program and the accompanying materials are made available under the
# * terms of the Apache License 2.0 which is available at
# * http://www.apache.org/licenses/LICENSE-2.0
# *
# * SPDX-License-Identifier: Apache-2.0
# ********************************************************************************/
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*******************************************************************************
Copyright (c) 2024 Contributors to the Eclipse Foundation

See the NOTICE file(s) distributed with this work for additional
information regarding copyright ownership.

This program and the accompanying materials are made available under the
terms of the Apache License 2.0 which is available at
http://www.apache.org/licenses/LICENSE-2.0

SPDX-License-Identifier: Apache-2.0
******************************************************************************

Please do not add optional fields due to older proto3 versions limitations
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import kuksa.val.v2.types_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetValueRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_ID_FIELD_NUMBER: builtins.int
    @property
    def signal_id(self) -> kuksa.val.v2.types_pb2.SignalID: ...
    def __init__(
        self,
        *,
        signal_id: kuksa.val.v2.types_pb2.SignalID | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["signal_id", b"signal_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["signal_id", b"signal_id"]) -> None: ...

global___GetValueRequest = GetValueRequest

@typing.final
class GetValueResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_POINT_FIELD_NUMBER: builtins.int
    @property
    def data_point(self) -> kuksa.val.v2.types_pb2.Datapoint: ...
    def __init__(
        self,
        *,
        data_point: kuksa.val.v2.types_pb2.Datapoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data_point", b"data_point"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data_point", b"data_point"]) -> None: ...

global___GetValueResponse = GetValueResponse

@typing.final
class GetValuesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_IDS_FIELD_NUMBER: builtins.int
    @property
    def signal_ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[kuksa.val.v2.types_pb2.SignalID]: ...
    def __init__(
        self,
        *,
        signal_ids: collections.abc.Iterable[kuksa.val.v2.types_pb2.SignalID] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signal_ids", b"signal_ids"]) -> None: ...

global___GetValuesRequest = GetValuesRequest

@typing.final
class GetValuesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_POINTS_FIELD_NUMBER: builtins.int
    @property
    def data_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[kuksa.val.v2.types_pb2.Datapoint]: ...
    def __init__(
        self,
        *,
        data_points: collections.abc.Iterable[kuksa.val.v2.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_points", b"data_points"]) -> None: ...

global___GetValuesResponse = GetValuesResponse

@typing.final
class SubscribeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_PATHS_FIELD_NUMBER: builtins.int
    BUFFER_SIZE_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    buffer_size: builtins.int
    """Specifies the number of messages that can be buffered for
    slow subscribers before the oldest messages are dropped.
    Default (0) results in that only latest message is kept.
    Maximum value supported is implementation dependent.
    """
    @property
    def signal_paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def filter(self) -> kuksa.val.v2.types_pb2.Filter: ...
    def __init__(
        self,
        *,
        signal_paths: collections.abc.Iterable[builtins.str] | None = ...,
        buffer_size: builtins.int = ...,
        filter: kuksa.val.v2.types_pb2.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["buffer_size", b"buffer_size", "filter", b"filter", "signal_paths", b"signal_paths"]) -> None: ...

global___SubscribeRequest = SubscribeRequest

@typing.final
class SubscribeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class EntriesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> kuksa.val.v2.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: kuksa.val.v2.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, kuksa.val.v2.types_pb2.Datapoint]: ...
    def __init__(
        self,
        *,
        entries: collections.abc.Mapping[builtins.str, kuksa.val.v2.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["entries", b"entries"]) -> None: ...

global___SubscribeResponse = SubscribeResponse

@typing.final
class SubscribeByIdRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_IDS_FIELD_NUMBER: builtins.int
    BUFFER_SIZE_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    buffer_size: builtins.int
    """Specifies the number of messages that can be buffered for
    slow subscribers before the oldest messages are dropped.
    Default (0) results in that only latest message is kept.
    Maximum value supported is implementation dependent.
    """
    @property
    def signal_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    @property
    def filter(self) -> kuksa.val.v2.types_pb2.Filter: ...
    def __init__(
        self,
        *,
        signal_ids: collections.abc.Iterable[builtins.int] | None = ...,
        buffer_size: builtins.int = ...,
        filter: kuksa.val.v2.types_pb2.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["buffer_size", b"buffer_size", "filter", b"filter", "signal_ids", b"signal_ids"]) -> None: ...

global___SubscribeByIdRequest = SubscribeByIdRequest

@typing.final
class SubscribeByIdResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class EntriesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> kuksa.val.v2.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: kuksa.val.v2.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, kuksa.val.v2.types_pb2.Datapoint]: ...
    def __init__(
        self,
        *,
        entries: collections.abc.Mapping[builtins.int, kuksa.val.v2.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["entries", b"entries"]) -> None: ...

global___SubscribeByIdResponse = SubscribeByIdResponse

@typing.final
class ActuateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_ID_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    @property
    def signal_id(self) -> kuksa.val.v2.types_pb2.SignalID: ...
    @property
    def value(self) -> kuksa.val.v2.types_pb2.Value: ...
    def __init__(
        self,
        *,
        signal_id: kuksa.val.v2.types_pb2.SignalID | None = ...,
        value: kuksa.val.v2.types_pb2.Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["signal_id", b"signal_id", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["signal_id", b"signal_id", "value", b"value"]) -> None: ...

global___ActuateRequest = ActuateRequest

@typing.final
class ActuateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ActuateResponse = ActuateResponse

@typing.final
class BatchActuateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTUATE_REQUESTS_FIELD_NUMBER: builtins.int
    @property
    def actuate_requests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActuateRequest]: ...
    def __init__(
        self,
        *,
        actuate_requests: collections.abc.Iterable[global___ActuateRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actuate_requests", b"actuate_requests"]) -> None: ...

global___BatchActuateRequest = BatchActuateRequest

@typing.final
class BatchActuateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___BatchActuateResponse = BatchActuateResponse

@typing.final
class ListMetadataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    root: builtins.str
    """Root path to be used when listing metadata
    Shall correspond to a VSS branch, e.g. "Vehicle", "Vehicle.Cabin"
    Metadata for all signals under that branch will be returned unless filtered by filter.
    NOTE: Currently Databroker supports also signals and wildcards in root but that may
          be removed in a future release!
    """
    filter: builtins.str
    """NOTE : Currently not considered by Databroker, all signals matching root are returned"""
    def __init__(
        self,
        *,
        root: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "root", b"root"]) -> None: ...

global___ListMetadataRequest = ListMetadataRequest

@typing.final
class ListMetadataResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[kuksa.val.v2.types_pb2.Metadata]: ...
    def __init__(
        self,
        *,
        metadata: collections.abc.Iterable[kuksa.val.v2.types_pb2.Metadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["metadata", b"metadata"]) -> None: ...

global___ListMetadataResponse = ListMetadataResponse

@typing.final
class PublishValueRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_ID_FIELD_NUMBER: builtins.int
    DATA_POINT_FIELD_NUMBER: builtins.int
    @property
    def signal_id(self) -> kuksa.val.v2.types_pb2.SignalID: ...
    @property
    def data_point(self) -> kuksa.val.v2.types_pb2.Datapoint: ...
    def __init__(
        self,
        *,
        signal_id: kuksa.val.v2.types_pb2.SignalID | None = ...,
        data_point: kuksa.val.v2.types_pb2.Datapoint | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data_point", b"data_point", "signal_id", b"signal_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data_point", b"data_point", "signal_id", b"signal_id"]) -> None: ...

global___PublishValueRequest = PublishValueRequest

@typing.final
class PublishValueResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PublishValueResponse = PublishValueResponse

@typing.final
class PublishValuesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataPointsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> kuksa.val.v2.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: kuksa.val.v2.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    REQUEST_ID_FIELD_NUMBER: builtins.int
    DATA_POINTS_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """/ Unique request id for the stream that can be used to match the corresponding response."""
    @property
    def data_points(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, kuksa.val.v2.types_pb2.Datapoint]: ...
    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        data_points: collections.abc.Mapping[builtins.int, kuksa.val.v2.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data_points", b"data_points", "request_id", b"request_id"]) -> None: ...

global___PublishValuesRequest = PublishValuesRequest

@typing.final
class PublishValuesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class StatusEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> kuksa.val.v2.types_pb2.Error: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: kuksa.val.v2.types_pb2.Error | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    REQUEST_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """/ Unique request id for the stream that can be used to match the corresponding request."""
    @property
    def status(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, kuksa.val.v2.types_pb2.Error]: ...
    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        status: collections.abc.Mapping[builtins.int, kuksa.val.v2.types_pb2.Error] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "status", b"status"]) -> None: ...

global___PublishValuesResponse = PublishValuesResponse

@typing.final
class ProvideActuationRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTUATOR_IDENTIFIERS_FIELD_NUMBER: builtins.int
    @property
    def actuator_identifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[kuksa.val.v2.types_pb2.SignalID]: ...
    def __init__(
        self,
        *,
        actuator_identifiers: collections.abc.Iterable[kuksa.val.v2.types_pb2.SignalID] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actuator_identifiers", b"actuator_identifiers"]) -> None: ...

global___ProvideActuationRequest = ProvideActuationRequest

@typing.final
class ProvideActuationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ProvideActuationResponse = ProvideActuationResponse

@typing.final
class ProvideSignalRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SignalsSampleIntervalsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> kuksa.val.v2.types_pb2.SampleInterval: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: kuksa.val.v2.types_pb2.SampleInterval | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SIGNALS_SAMPLE_INTERVALS_FIELD_NUMBER: builtins.int
    @property
    def signals_sample_intervals(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, kuksa.val.v2.types_pb2.SampleInterval]: ...
    def __init__(
        self,
        *,
        signals_sample_intervals: collections.abc.Mapping[builtins.int, kuksa.val.v2.types_pb2.SampleInterval] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signals_sample_intervals", b"signals_sample_intervals"]) -> None: ...

global___ProvideSignalRequest = ProvideSignalRequest

@typing.final
class ProvideSignalResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ProvideSignalResponse = ProvideSignalResponse

@typing.final
class BatchActuateStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTUATE_REQUESTS_FIELD_NUMBER: builtins.int
    @property
    def actuate_requests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActuateRequest]: ...
    def __init__(
        self,
        *,
        actuate_requests: collections.abc.Iterable[global___ActuateRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["actuate_requests", b"actuate_requests"]) -> None: ...

global___BatchActuateStreamRequest = BatchActuateStreamRequest

@typing.final
class BatchActuateStreamResponse(google.protobuf.message.Message):
    """Message that shall be used by provider to indicate if an actuation request was accepted."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    @property
    def signal_id(self) -> kuksa.val.v2.types_pb2.SignalID: ...
    @property
    def error(self) -> kuksa.val.v2.types_pb2.Error: ...
    def __init__(
        self,
        *,
        signal_id: kuksa.val.v2.types_pb2.SignalID | None = ...,
        error: kuksa.val.v2.types_pb2.Error | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["error", b"error", "signal_id", b"signal_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["error", b"error", "signal_id", b"signal_id"]) -> None: ...

global___BatchActuateStreamResponse = BatchActuateStreamResponse

@typing.final
class UpdateFilterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FiltersUpdateEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> kuksa.val.v2.types_pb2.Filter: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: kuksa.val.v2.types_pb2.Filter | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    REQUEST_ID_FIELD_NUMBER: builtins.int
    FILTERS_UPDATE_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """/ Unique request id for the stream that can be used to match the corresponding response."""
    @property
    def filters_update(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, kuksa.val.v2.types_pb2.Filter]:
        """Databroker sends filters to provider.
        In case provider restarts, databroker will send local filters stored
        to continue the provider sending same signals with same filter.
        """

    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        filters_update: collections.abc.Mapping[builtins.int, kuksa.val.v2.types_pb2.Filter] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filters_update", b"filters_update", "request_id", b"request_id"]) -> None: ...

global___UpdateFilterRequest = UpdateFilterRequest

@typing.final
class UpdateFilterResponse(google.protobuf.message.Message):
    """Only returned if there is a filter error on provider side"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    FILTER_ERROR_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """/ Unique request id for the stream that can be used to match the corresponding request."""
    filter_error: kuksa.val.v2.types_pb2.FilterError.ValueType
    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        filter_error: kuksa.val.v2.types_pb2.FilterError.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter_error", b"filter_error", "request_id", b"request_id"]) -> None: ...

global___UpdateFilterResponse = UpdateFilterResponse

@typing.final
class ProviderErrorIndication(google.protobuf.message.Message):
    """Send to indicate an error on provider side"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_ERROR_FIELD_NUMBER: builtins.int
    provider_error: kuksa.val.v2.types_pb2.ProviderError.ValueType
    def __init__(
        self,
        *,
        provider_error: kuksa.val.v2.types_pb2.ProviderError.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["provider_error", b"provider_error"]) -> None: ...

global___ProviderErrorIndication = ProviderErrorIndication

@typing.final
class GetProviderValueRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    SIGNAL_IDS_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """/ Unique request id for the stream that can be used to match the corresponding response."""
    @property
    def signal_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        signal_ids: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["request_id", b"request_id", "signal_ids", b"signal_ids"]) -> None: ...

global___GetProviderValueRequest = GetProviderValueRequest

@typing.final
class GetProviderValueResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class EntriesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.int
        @property
        def value(self) -> kuksa.val.v2.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.int = ...,
            value: kuksa.val.v2.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    REQUEST_ID_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    request_id: builtins.int
    """/ Unique request id for the stream that can be used to match the corresponding request."""
    @property
    def entries(self) -> google.protobuf.internal.containers.MessageMap[builtins.int, kuksa.val.v2.types_pb2.Datapoint]: ...
    def __init__(
        self,
        *,
        request_id: builtins.int = ...,
        entries: collections.abc.Mapping[builtins.int, kuksa.val.v2.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["entries", b"entries", "request_id", b"request_id"]) -> None: ...

global___GetProviderValueResponse = GetProviderValueResponse

@typing.final
class OpenProviderStreamRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDE_ACTUATION_REQUEST_FIELD_NUMBER: builtins.int
    PUBLISH_VALUES_REQUEST_FIELD_NUMBER: builtins.int
    BATCH_ACTUATE_STREAM_RESPONSE_FIELD_NUMBER: builtins.int
    PROVIDE_SIGNAL_REQUEST_FIELD_NUMBER: builtins.int
    UPDATE_FILTER_RESPONSE_FIELD_NUMBER: builtins.int
    GET_PROVIDER_VALUE_RESPONSE_FIELD_NUMBER: builtins.int
    PROVIDER_ERROR_INDICATION_FIELD_NUMBER: builtins.int
    @property
    def provide_actuation_request(self) -> global___ProvideActuationRequest:
        """Inform server of an actuator this provider provides."""

    @property
    def publish_values_request(self) -> global___PublishValuesRequest:
        """Publish a value."""

    @property
    def batch_actuate_stream_response(self) -> global___BatchActuateStreamResponse:
        """Sent to acknowledge the acceptance of a batch actuate
        request.
        """

    @property
    def provide_signal_request(self) -> global___ProvideSignalRequest:
        """Inform server of a signal this provider provides."""

    @property
    def update_filter_response(self) -> global___UpdateFilterResponse:
        """Update filter response"""

    @property
    def get_provider_value_response(self) -> global___GetProviderValueResponse:
        """GetValue response"""

    @property
    def provider_error_indication(self) -> global___ProviderErrorIndication:
        """Indication of error on provider side"""

    def __init__(
        self,
        *,
        provide_actuation_request: global___ProvideActuationRequest | None = ...,
        publish_values_request: global___PublishValuesRequest | None = ...,
        batch_actuate_stream_response: global___BatchActuateStreamResponse | None = ...,
        provide_signal_request: global___ProvideSignalRequest | None = ...,
        update_filter_response: global___UpdateFilterResponse | None = ...,
        get_provider_value_response: global___GetProviderValueResponse | None = ...,
        provider_error_indication: global___ProviderErrorIndication | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "batch_actuate_stream_response", b"batch_actuate_stream_response", "get_provider_value_response", b"get_provider_value_response", "provide_actuation_request", b"provide_actuation_request", "provide_signal_request", b"provide_signal_request", "provider_error_indication", b"provider_error_indication", "publish_values_request", b"publish_values_request", "update_filter_response", b"update_filter_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "batch_actuate_stream_response", b"batch_actuate_stream_response", "get_provider_value_response", b"get_provider_value_response", "provide_actuation_request", b"provide_actuation_request", "provide_signal_request", b"provide_signal_request", "provider_error_indication", b"provider_error_indication", "publish_values_request", b"publish_values_request", "update_filter_response", b"update_filter_response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["provide_actuation_request", "publish_values_request", "batch_actuate_stream_response", "provide_signal_request", "update_filter_response", "get_provider_value_response", "provider_error_indication"] | None: ...

global___OpenProviderStreamRequest = OpenProviderStreamRequest

@typing.final
class OpenProviderStreamResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDE_ACTUATION_RESPONSE_FIELD_NUMBER: builtins.int
    PUBLISH_VALUES_RESPONSE_FIELD_NUMBER: builtins.int
    BATCH_ACTUATE_STREAM_REQUEST_FIELD_NUMBER: builtins.int
    PROVIDE_SIGNAL_RESPONSE_FIELD_NUMBER: builtins.int
    UPDATE_FILTER_REQUEST_FIELD_NUMBER: builtins.int
    GET_PROVIDER_VALUE_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def provide_actuation_response(self) -> global___ProvideActuationResponse:
        """Response to a provide actuator request."""

    @property
    def publish_values_response(self) -> global___PublishValuesResponse:
        """Acknowledgement that a published value was received."""

    @property
    def batch_actuate_stream_request(self) -> global___BatchActuateStreamRequest:
        """Send a batch actuate request to a provider."""

    @property
    def provide_signal_response(self) -> global___ProvideSignalResponse:
        """Response to a provide sensor request."""

    @property
    def update_filter_request(self) -> global___UpdateFilterRequest:
        """Filter request"""

    @property
    def get_provider_value_request(self) -> global___GetProviderValueRequest:
        """GetValue request from client forwarded to provider"""

    def __init__(
        self,
        *,
        provide_actuation_response: global___ProvideActuationResponse | None = ...,
        publish_values_response: global___PublishValuesResponse | None = ...,
        batch_actuate_stream_request: global___BatchActuateStreamRequest | None = ...,
        provide_signal_response: global___ProvideSignalResponse | None = ...,
        update_filter_request: global___UpdateFilterRequest | None = ...,
        get_provider_value_request: global___GetProviderValueRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "batch_actuate_stream_request", b"batch_actuate_stream_request", "get_provider_value_request", b"get_provider_value_request", "provide_actuation_response", b"provide_actuation_response", "provide_signal_response", b"provide_signal_response", "publish_values_response", b"publish_values_response", "update_filter_request", b"update_filter_request"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "batch_actuate_stream_request", b"batch_actuate_stream_request", "get_provider_value_request", b"get_provider_value_request", "provide_actuation_response", b"provide_actuation_response", "provide_signal_response", b"provide_signal_response", "publish_values_response", b"publish_values_response", "update_filter_request", b"update_filter_request"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["provide_actuation_response", "publish_values_response", "batch_actuate_stream_request", "provide_signal_response", "update_filter_request", "get_provider_value_request"] | None: ...

global___OpenProviderStreamResponse = OpenProviderStreamResponse

@typing.final
class GetServerInfoRequest(google.protobuf.message.Message):
    """Nothing yet"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetServerInfoRequest = GetServerInfoRequest

@typing.final
class GetServerInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    COMMIT_HASH_FIELD_NUMBER: builtins.int
    name: builtins.str
    version: builtins.str
    commit_hash: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        commit_hash: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["commit_hash", b"commit_hash", "name", b"name", "version", b"version"]) -> None: ...

global___GetServerInfoResponse = GetServerInfoResponse
