/* SPDX-License-Identifier: GPL-2.0 */

#include <string.h>

static const char *errno_to_name__x86(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__alpha(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EDEADLK";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EAGAIN";
	case 36: return "EINPROGRESS";
	case 37: return "EALREADY";
	case 38: return "ENOTSOCK";
	case 39: return "EDESTADDRREQ";
	case 40: return "EMSGSIZE";
	case 41: return "EPROTOTYPE";
	case 42: return "ENOPROTOOPT";
	case 43: return "EPROTONOSUPPORT";
	case 44: return "ESOCKTNOSUPPORT";
	case 45: return "EOPNOTSUPP";
	case 46: return "EPFNOSUPPORT";
	case 47: return "EAFNOSUPPORT";
	case 48: return "EADDRINUSE";
	case 49: return "EADDRNOTAVAIL";
	case 50: return "ENETDOWN";
	case 51: return "ENETUNREACH";
	case 52: return "ENETRESET";
	case 53: return "ECONNABORTED";
	case 54: return "ECONNRESET";
	case 55: return "ENOBUFS";
	case 56: return "EISCONN";
	case 57: return "ENOTCONN";
	case 58: return "ESHUTDOWN";
	case 59: return "ETOOMANYREFS";
	case 60: return "ETIMEDOUT";
	case 61: return "ECONNREFUSED";
	case 62: return "ELOOP";
	case 63: return "ENAMETOOLONG";
	case 64: return "EHOSTDOWN";
	case 65: return "EHOSTUNREACH";
	case 66: return "ENOTEMPTY";
	case 68: return "EUSERS";
	case 69: return "EDQUOT";
	case 70: return "ESTALE";
	case 71: return "EREMOTE";
	case 77: return "ENOLCK";
	case 78: return "ENOSYS";
	case 80: return "ENOMSG";
	case 81: return "EIDRM";
	case 82: return "ENOSR";
	case 83: return "ETIME";
	case 84: return "EBADMSG";
	case 85: return "EPROTO";
	case 86: return "ENODATA";
	case 87: return "ENOSTR";
	case 88: return "ECHRNG";
	case 89: return "EL2NSYNC";
	case 90: return "EL3HLT";
	case 91: return "EL3RST";
	case 92: return "ENOPKG";
	case 93: return "ELNRNG";
	case 94: return "EUNATCH";
	case 95: return "ENOCSI";
	case 96: return "EL2HLT";
	case 97: return "EBADE";
	case 98: return "EBADR";
	case 99: return "EXFULL";
	case 100: return "ENOANO";
	case 101: return "EBADRQC";
	case 102: return "EBADSLT";
	case 104: return "EBFONT";
	case 105: return "ENONET";
	case 106: return "ENOLINK";
	case 107: return "EADV";
	case 108: return "ESRMNT";
	case 109: return "ECOMM";
	case 110: return "EMULTIHOP";
	case 111: return "EDOTDOT";
	case 112: return "EOVERFLOW";
	case 113: return "ENOTUNIQ";
	case 114: return "EBADFD";
	case 115: return "EREMCHG";
	case 116: return "EILSEQ";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "ELIBACC";
	case 123: return "ELIBBAD";
	case 124: return "ELIBSCN";
	case 125: return "ELIBMAX";
	case 126: return "ELIBEXEC";
	case 127: return "ERESTART";
	case 128: return "ESTRPIPE";
	case 129: return "ENOMEDIUM";
	case 130: return "EMEDIUMTYPE";
	case 131: return "ECANCELED";
	case 132: return "ENOKEY";
	case 133: return "EKEYEXPIRED";
	case 134: return "EKEYREVOKED";
	case 135: return "EKEYREJECTED";
	case 136: return "EOWNERDEAD";
	case 137: return "ENOTRECOVERABLE";
	case 138: return "ERFKILL";
	case 139: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__arc(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__arm(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__arm64(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__csky(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__mips(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "ENOMSG";
	case 36: return "EIDRM";
	case 37: return "ECHRNG";
	case 38: return "EL2NSYNC";
	case 39: return "EL3HLT";
	case 40: return "EL3RST";
	case 41: return "ELNRNG";
	case 42: return "EUNATCH";
	case 43: return "ENOCSI";
	case 44: return "EL2HLT";
	case 45: return "EDEADLK";
	case 46: return "ENOLCK";
	case 50: return "EBADE";
	case 51: return "EBADR";
	case 52: return "EXFULL";
	case 53: return "ENOANO";
	case 54: return "EBADRQC";
	case 55: return "EBADSLT";
	case 56: return "EDEADLOCK";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 73: return "EDOTDOT";
	case 74: return "EMULTIHOP";
	case 77: return "EBADMSG";
	case 78: return "ENAMETOOLONG";
	case 79: return "EOVERFLOW";
	case 80: return "ENOTUNIQ";
	case 81: return "EBADFD";
	case 82: return "EREMCHG";
	case 83: return "ELIBACC";
	case 84: return "ELIBBAD";
	case 85: return "ELIBSCN";
	case 86: return "ELIBMAX";
	case 87: return "ELIBEXEC";
	case 88: return "EILSEQ";
	case 89: return "ENOSYS";
	case 90: return "ELOOP";
	case 91: return "ERESTART";
	case 92: return "ESTRPIPE";
	case 93: return "ENOTEMPTY";
	case 94: return "EUSERS";
	case 95: return "ENOTSOCK";
	case 96: return "EDESTADDRREQ";
	case 97: return "EMSGSIZE";
	case 98: return "EPROTOTYPE";
	case 99: return "ENOPROTOOPT";
	case 120: return "EPROTONOSUPPORT";
	case 121: return "ESOCKTNOSUPPORT";
	case 122: return "EOPNOTSUPP";
	case 123: return "EPFNOSUPPORT";
	case 124: return "EAFNOSUPPORT";
	case 125: return "EADDRINUSE";
	case 126: return "EADDRNOTAVAIL";
	case 127: return "ENETDOWN";
	case 128: return "ENETUNREACH";
	case 129: return "ENETRESET";
	case 130: return "ECONNABORTED";
	case 131: return "ECONNRESET";
	case 132: return "ENOBUFS";
	case 133: return "EISCONN";
	case 134: return "ENOTCONN";
	case 135: return "EUCLEAN";
	case 137: return "ENOTNAM";
	case 138: return "ENAVAIL";
	case 139: return "EISNAM";
	case 140: return "EREMOTEIO";
	case 141: return "EINIT";
	case 142: return "EREMDEV";
	case 143: return "ESHUTDOWN";
	case 144: return "ETOOMANYREFS";
	case 145: return "ETIMEDOUT";
	case 146: return "ECONNREFUSED";
	case 147: return "EHOSTDOWN";
	case 148: return "EHOSTUNREACH";
	case 149: return "EALREADY";
	case 150: return "EINPROGRESS";
	case 151: return "ESTALE";
	case 158: return "ECANCELED";
	case 159: return "ENOMEDIUM";
	case 160: return "EMEDIUMTYPE";
	case 161: return "ENOKEY";
	case 162: return "EKEYEXPIRED";
	case 163: return "EKEYREVOKED";
	case 164: return "EKEYREJECTED";
	case 165: return "EOWNERDEAD";
	case 166: return "ENOTRECOVERABLE";
	case 167: return "ERFKILL";
	case 168: return "EHWPOISON";
	case 1133: return "EDQUOT";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__parisc(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "ENOMSG";
	case 36: return "EIDRM";
	case 37: return "ECHRNG";
	case 38: return "EL2NSYNC";
	case 39: return "EL3HLT";
	case 40: return "EL3RST";
	case 41: return "ELNRNG";
	case 42: return "EUNATCH";
	case 43: return "ENOCSI";
	case 44: return "EL2HLT";
	case 45: return "EDEADLK";
	case 46: return "ENOLCK";
	case 47: return "EILSEQ";
	case 50: return "ENONET";
	case 51: return "ENODATA";
	case 52: return "ETIME";
	case 53: return "ENOSR";
	case 54: return "ENOSTR";
	case 55: return "ENOPKG";
	case 57: return "ENOLINK";
	case 58: return "EADV";
	case 59: return "ESRMNT";
	case 60: return "ECOMM";
	case 61: return "EPROTO";
	case 64: return "EMULTIHOP";
	case 66: return "EDOTDOT";
	case 67: return "EBADMSG";
	case 68: return "EUSERS";
	case 69: return "EDQUOT";
	case 70: return "ESTALE";
	case 71: return "EREMOTE";
	case 72: return "EOVERFLOW";
	case 160: return "EBADE";
	case 161: return "EBADR";
	case 162: return "EXFULL";
	case 163: return "ENOANO";
	case 164: return "EBADRQC";
	case 165: return "EBADSLT";
	case 166: return "EBFONT";
	case 167: return "ENOTUNIQ";
	case 168: return "EBADFD";
	case 169: return "EREMCHG";
	case 170: return "ELIBACC";
	case 171: return "ELIBBAD";
	case 172: return "ELIBSCN";
	case 173: return "ELIBMAX";
	case 174: return "ELIBEXEC";
	case 175: return "ERESTART";
	case 176: return "ESTRPIPE";
	case 177: return "EUCLEAN";
	case 178: return "ENOTNAM";
	case 179: return "ENAVAIL";
	case 180: return "EISNAM";
	case 181: return "EREMOTEIO";
	case 182: return "ENOMEDIUM";
	case 183: return "EMEDIUMTYPE";
	case 184: return "ENOKEY";
	case 185: return "EKEYEXPIRED";
	case 186: return "EKEYREVOKED";
	case 187: return "EKEYREJECTED";
	case 215: return "ENOSYM";
	case 216: return "ENOTSOCK";
	case 217: return "EDESTADDRREQ";
	case 218: return "EMSGSIZE";
	case 219: return "EPROTOTYPE";
	case 220: return "ENOPROTOOPT";
	case 221: return "EPROTONOSUPPORT";
	case 222: return "ESOCKTNOSUPPORT";
	case 223: return "EOPNOTSUPP";
	case 224: return "EPFNOSUPPORT";
	case 225: return "EAFNOSUPPORT";
	case 226: return "EADDRINUSE";
	case 227: return "EADDRNOTAVAIL";
	case 228: return "ENETDOWN";
	case 229: return "ENETUNREACH";
	case 230: return "ENETRESET";
	case 231: return "ECONNABORTED";
	case 232: return "ECONNRESET";
	case 233: return "ENOBUFS";
	case 234: return "EISCONN";
	case 235: return "ENOTCONN";
	case 236: return "ESHUTDOWN";
	case 237: return "ETOOMANYREFS";
	case 238: return "ETIMEDOUT";
	case 239: return "ECONNREFUSED";
	case 240: return "EREMOTERELEASE";
	case 241: return "EHOSTDOWN";
	case 242: return "EHOSTUNREACH";
	case 244: return "EALREADY";
	case 245: return "EINPROGRESS";
	case 247: return "ENOTEMPTY";
	case 248: return "ENAMETOOLONG";
	case 249: return "ELOOP";
	case 251: return "ENOSYS";
	case 253: return "ECANCELLED";
	case 254: return "EOWNERDEAD";
	case 255: return "ENOTRECOVERABLE";
	case 256: return "ERFKILL";
	case 257: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__powerpc(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 58: return "EDEADLOCK";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__riscv(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__s390(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__sh(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__sparc(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 36: return "EINPROGRESS";
	case 37: return "EALREADY";
	case 38: return "ENOTSOCK";
	case 39: return "EDESTADDRREQ";
	case 40: return "EMSGSIZE";
	case 41: return "EPROTOTYPE";
	case 42: return "ENOPROTOOPT";
	case 43: return "EPROTONOSUPPORT";
	case 44: return "ESOCKTNOSUPPORT";
	case 45: return "EOPNOTSUPP";
	case 46: return "EPFNOSUPPORT";
	case 47: return "EAFNOSUPPORT";
	case 48: return "EADDRINUSE";
	case 49: return "EADDRNOTAVAIL";
	case 50: return "ENETDOWN";
	case 51: return "ENETUNREACH";
	case 52: return "ENETRESET";
	case 53: return "ECONNABORTED";
	case 54: return "ECONNRESET";
	case 55: return "ENOBUFS";
	case 56: return "EISCONN";
	case 57: return "ENOTCONN";
	case 58: return "ESHUTDOWN";
	case 59: return "ETOOMANYREFS";
	case 60: return "ETIMEDOUT";
	case 61: return "ECONNREFUSED";
	case 62: return "ELOOP";
	case 63: return "ENAMETOOLONG";
	case 64: return "EHOSTDOWN";
	case 65: return "EHOSTUNREACH";
	case 66: return "ENOTEMPTY";
	case 67: return "EPROCLIM";
	case 68: return "EUSERS";
	case 69: return "EDQUOT";
	case 70: return "ESTALE";
	case 71: return "EREMOTE";
	case 72: return "ENOSTR";
	case 73: return "ETIME";
	case 74: return "ENOSR";
	case 75: return "ENOMSG";
	case 76: return "EBADMSG";
	case 77: return "EIDRM";
	case 78: return "EDEADLK";
	case 79: return "ENOLCK";
	case 80: return "ENONET";
	case 81: return "ERREMOTE";
	case 82: return "ENOLINK";
	case 83: return "EADV";
	case 84: return "ESRMNT";
	case 85: return "ECOMM";
	case 86: return "EPROTO";
	case 87: return "EMULTIHOP";
	case 88: return "EDOTDOT";
	case 89: return "EREMCHG";
	case 90: return "ENOSYS";
	case 91: return "ESTRPIPE";
	case 92: return "EOVERFLOW";
	case 93: return "EBADFD";
	case 94: return "ECHRNG";
	case 95: return "EL2NSYNC";
	case 96: return "EL3HLT";
	case 97: return "EL3RST";
	case 98: return "ELNRNG";
	case 99: return "EUNATCH";
	case 100: return "ENOCSI";
	case 101: return "EL2HLT";
	case 102: return "EBADE";
	case 103: return "EBADR";
	case 104: return "EXFULL";
	case 105: return "ENOANO";
	case 106: return "EBADRQC";
	case 107: return "EBADSLT";
	case 108: return "EDEADLOCK";
	case 109: return "EBFONT";
	case 110: return "ELIBEXEC";
	case 111: return "ENODATA";
	case 112: return "ELIBBAD";
	case 113: return "ENOPKG";
	case 114: return "ELIBACC";
	case 115: return "ENOTUNIQ";
	case 116: return "ERESTART";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EILSEQ";
	case 123: return "ELIBMAX";
	case 124: return "ELIBSCN";
	case 125: return "ENOMEDIUM";
	case 126: return "EMEDIUMTYPE";
	case 127: return "ECANCELED";
	case 128: return "ENOKEY";
	case 129: return "EKEYEXPIRED";
	case 130: return "EKEYREVOKED";
	case 131: return "EKEYREJECTED";
	case 132: return "EOWNERDEAD";
	case 133: return "ENOTRECOVERABLE";
	case 134: return "ERFKILL";
	case 135: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__xtensa(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

static const char *errno_to_name__generic(int err)
{
	switch (err) {
	case 1: return "EPERM";
	case 2: return "ENOENT";
	case 3: return "ESRCH";
	case 4: return "EINTR";
	case 5: return "EIO";
	case 6: return "ENXIO";
	case 7: return "E2BIG";
	case 8: return "ENOEXEC";
	case 9: return "EBADF";
	case 10: return "ECHILD";
	case 11: return "EAGAIN";
	case 12: return "ENOMEM";
	case 13: return "EACCES";
	case 14: return "EFAULT";
	case 15: return "ENOTBLK";
	case 16: return "EBUSY";
	case 17: return "EEXIST";
	case 18: return "EXDEV";
	case 19: return "ENODEV";
	case 20: return "ENOTDIR";
	case 21: return "EISDIR";
	case 22: return "EINVAL";
	case 23: return "ENFILE";
	case 24: return "EMFILE";
	case 25: return "ENOTTY";
	case 26: return "ETXTBSY";
	case 27: return "EFBIG";
	case 28: return "ENOSPC";
	case 29: return "ESPIPE";
	case 30: return "EROFS";
	case 31: return "EMLINK";
	case 32: return "EPIPE";
	case 33: return "EDOM";
	case 34: return "ERANGE";
	case 35: return "EDEADLK";
	case 36: return "ENAMETOOLONG";
	case 37: return "ENOLCK";
	case 38: return "ENOSYS";
	case 39: return "ENOTEMPTY";
	case 40: return "ELOOP";
	case 42: return "ENOMSG";
	case 43: return "EIDRM";
	case 44: return "ECHRNG";
	case 45: return "EL2NSYNC";
	case 46: return "EL3HLT";
	case 47: return "EL3RST";
	case 48: return "ELNRNG";
	case 49: return "EUNATCH";
	case 50: return "ENOCSI";
	case 51: return "EL2HLT";
	case 52: return "EBADE";
	case 53: return "EBADR";
	case 54: return "EXFULL";
	case 55: return "ENOANO";
	case 56: return "EBADRQC";
	case 57: return "EBADSLT";
	case 59: return "EBFONT";
	case 60: return "ENOSTR";
	case 61: return "ENODATA";
	case 62: return "ETIME";
	case 63: return "ENOSR";
	case 64: return "ENONET";
	case 65: return "ENOPKG";
	case 66: return "EREMOTE";
	case 67: return "ENOLINK";
	case 68: return "EADV";
	case 69: return "ESRMNT";
	case 70: return "ECOMM";
	case 71: return "EPROTO";
	case 72: return "EMULTIHOP";
	case 73: return "EDOTDOT";
	case 74: return "EBADMSG";
	case 75: return "EOVERFLOW";
	case 76: return "ENOTUNIQ";
	case 77: return "EBADFD";
	case 78: return "EREMCHG";
	case 79: return "ELIBACC";
	case 80: return "ELIBBAD";
	case 81: return "ELIBSCN";
	case 82: return "ELIBMAX";
	case 83: return "ELIBEXEC";
	case 84: return "EILSEQ";
	case 85: return "ERESTART";
	case 86: return "ESTRPIPE";
	case 87: return "EUSERS";
	case 88: return "ENOTSOCK";
	case 89: return "EDESTADDRREQ";
	case 90: return "EMSGSIZE";
	case 91: return "EPROTOTYPE";
	case 92: return "ENOPROTOOPT";
	case 93: return "EPROTONOSUPPORT";
	case 94: return "ESOCKTNOSUPPORT";
	case 95: return "EOPNOTSUPP";
	case 96: return "EPFNOSUPPORT";
	case 97: return "EAFNOSUPPORT";
	case 98: return "EADDRINUSE";
	case 99: return "EADDRNOTAVAIL";
	case 100: return "ENETDOWN";
	case 101: return "ENETUNREACH";
	case 102: return "ENETRESET";
	case 103: return "ECONNABORTED";
	case 104: return "ECONNRESET";
	case 105: return "ENOBUFS";
	case 106: return "EISCONN";
	case 107: return "ENOTCONN";
	case 108: return "ESHUTDOWN";
	case 109: return "ETOOMANYREFS";
	case 110: return "ETIMEDOUT";
	case 111: return "ECONNREFUSED";
	case 112: return "EHOSTDOWN";
	case 113: return "EHOSTUNREACH";
	case 114: return "EALREADY";
	case 115: return "EINPROGRESS";
	case 116: return "ESTALE";
	case 117: return "EUCLEAN";
	case 118: return "ENOTNAM";
	case 119: return "ENAVAIL";
	case 120: return "EISNAM";
	case 121: return "EREMOTEIO";
	case 122: return "EDQUOT";
	case 123: return "ENOMEDIUM";
	case 124: return "EMEDIUMTYPE";
	case 125: return "ECANCELED";
	case 126: return "ENOKEY";
	case 127: return "EKEYEXPIRED";
	case 128: return "EKEYREVOKED";
	case 129: return "EKEYREJECTED";
	case 130: return "EOWNERDEAD";
	case 131: return "ENOTRECOVERABLE";
	case 132: return "ERFKILL";
	case 133: return "EHWPOISON";
	default:
		return "(unknown)";
	}
}

const char *arch_syscalls__strerrno(const char *arch, int err)
{
	if (!strcmp(arch, "x86"))
		return errno_to_name__x86(err);
	if (!strcmp(arch, "alpha"))
		return errno_to_name__alpha(err);
	if (!strcmp(arch, "arc"))
		return errno_to_name__arc(err);
	if (!strcmp(arch, "arm"))
		return errno_to_name__arm(err);
	if (!strcmp(arch, "arm64"))
		return errno_to_name__arm64(err);
	if (!strcmp(arch, "csky"))
		return errno_to_name__csky(err);
	if (!strcmp(arch, "mips"))
		return errno_to_name__mips(err);
	if (!strcmp(arch, "parisc"))
		return errno_to_name__parisc(err);
	if (!strcmp(arch, "powerpc"))
		return errno_to_name__powerpc(err);
	if (!strcmp(arch, "riscv"))
		return errno_to_name__riscv(err);
	if (!strcmp(arch, "s390"))
		return errno_to_name__s390(err);
	if (!strcmp(arch, "sh"))
		return errno_to_name__sh(err);
	if (!strcmp(arch, "sparc"))
		return errno_to_name__sparc(err);
	if (!strcmp(arch, "xtensa"))
		return errno_to_name__xtensa(err);
	return errno_to_name__generic(err);
}
