/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "../../../../git/formats/ctf/metadata/ctf-parser.y"

/*
 * ctf-parser.y
 *
 * Common Trace Format Metadata Grammar.
 *
 * Copyright 2010 - Mathieu Desnoyers <mathieu.desnoyers@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <glib.h>
#include <errno.h>
#include <inttypes.h>
#include <babeltrace/list.h>
#include <babeltrace/babeltrace-internal.h>
#include "ctf-scanner.h"
#include "ctf-parser.h"
#include "ctf-ast.h"
#include "objstack.h"

BT_HIDDEN
int yydebug;

/* Join two lists, put "add" at the end of "head".  */
static inline void
_bt_list_splice_tail (struct bt_list_head *add, struct bt_list_head *head)
{
	/* Do nothing if the list which gets added is empty.  */
	if (add != add->next) {
		add->next->prev = head->prev;
		add->prev->next = head;
		head->prev->next = add->next;
		head->prev = add->prev;
	}
}

BT_HIDDEN
int yyparse(struct ctf_scanner *scanner, yyscan_t yyscanner);
BT_HIDDEN
int yylex(union YYSTYPE *yyval, yyscan_t yyscanner);
BT_HIDDEN
int yylex_init_extra(struct ctf_scanner *scanner, yyscan_t * ptr_yy_globals);
BT_HIDDEN
int yylex_destroy(yyscan_t yyscanner);
BT_HIDDEN
void yyrestart(FILE * in_str, yyscan_t yyscanner);
BT_HIDDEN
int yyget_lineno(yyscan_t yyscanner);
BT_HIDDEN
char *yyget_text(yyscan_t yyscanner);

static const char *node_type_to_str[] = {
#define ENTRY(S)	[S] = #S,
	FOREACH_CTF_NODES(ENTRY)
#undef ENTRY
};

/*
 * Static node for out of memory errors. Only "type" is used. lineno is
 * always left at 0. The rest of the node content can be overwritten,
 * but is never used.
 */
static struct ctf_node error_node = {
	.type = NODE_ERROR,
};

BT_HIDDEN
const char *node_type(struct ctf_node *node)
{
	if (node->type < NR_NODE_TYPES)
		return node_type_to_str[node->type];
	else
		return NULL;
}

void setstring(struct ctf_scanner *scanner, YYSTYPE *lvalp, const char *src)
{
	lvalp->s = objstack_alloc(scanner->objstack, strlen(src) + 1);
	strcpy(lvalp->s, src);
}

static
int str_check(size_t str_len, size_t offset, size_t len)
{
	/* check overflow */
	if (offset + len < offset)
		return -1;
	if (offset + len > str_len)
		return -1;
	return 0;
}

static
int bt_isodigit(int c)
{
	switch (c) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
		return 1;
	default:
		return 0;
	}
}

static
int parse_base_sequence(const char *src, size_t len, size_t pos,
		char *buffer, size_t *buf_len, int base)
{
	const size_t max_char = 3;
	int nr_char = 0;

	while (!str_check(len, pos, 1) && nr_char < max_char) {
		char c = src[pos++];

		if (base == 8) {
			if (bt_isodigit(c))
				buffer[nr_char++] = c;
			else
				break;
		} else if (base == 16) {
			if (isxdigit(c))
				buffer[nr_char++] = c;
			else
				break;

		} else {
			/* Unsupported base */
			return -1;
		}
	}
	assert(nr_char > 0);
	buffer[nr_char] = '\0';
	*buf_len = nr_char;
	return 0;
}

static
int import_basic_string(struct ctf_scanner *scanner, YYSTYPE *lvalp,
		size_t len, const char *src, char delim)
{
	size_t pos = 0, dpos = 0;

	if (str_check(len, pos, 1))
		return -1;
	if (src[pos++] != delim)
		return -1;

	while (src[pos] != delim) {
		char c;

		if (str_check(len, pos, 1))
			return -1;
		c = src[pos++];
		if (c == '\\') {
			if (str_check(len, pos, 1))
				return -1;
			c = src[pos++];

			switch (c) {
			case 'a':
				c = '\a';
				break;
			case 'b':
				c = '\b';
				break;
			case 'f':
				c = '\f';
				break;
			case 'n':
				c = '\n';
				break;
			case 'r':
				c = '\r';
				break;
			case 't':
				c = '\t';
				break;
			case 'v':
				c = '\v';
				break;
			case '\\':
				c = '\\';
				break;
			case '\'':
				c = '\'';
				break;
			case '\"':
				c = '\"';
				break;
			case '?':
				c = '?';
				break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			{
				char oct_buffer[4];
				size_t oct_len;

				if (parse_base_sequence(src, len, pos - 1,
						oct_buffer, &oct_len, 8))
					return -1;
				c = strtoul(&oct_buffer[0], NULL, 8);
				pos += oct_len - 1;
				break;
			}
			case 'x':
			{
				char hex_buffer[4];
				size_t hex_len;

				if (parse_base_sequence(src, len, pos,
						hex_buffer, &hex_len, 16))
					return -1;
				c = strtoul(&hex_buffer[0], NULL, 16);
				pos += hex_len;
				break;
			}
			default:
				return -1;
			}
		}
		if (str_check(len, dpos, 1))
			return -1;
		lvalp->s[dpos++] = c;
	}

	if (str_check(len, dpos, 1))
		return -1;
	lvalp->s[dpos++] = '\0';

	if (str_check(len, pos, 1))
		return -1;
	if (src[pos++] != delim)
		return -1;

	if (str_check(len, pos, 1))
		return -1;
	if (src[pos] != '\0')
		return -1;
	return 0;
}

int import_string(struct ctf_scanner *scanner, YYSTYPE *lvalp,
		const char *src, char delim)
{
	size_t len;

	len = strlen(src) + 1;
	lvalp->s = objstack_alloc(scanner->objstack, len);
	if (src[0] == 'L') {
		// TODO: import wide string
		printfl_error(yyget_lineno(scanner),
			"Wide string not supported yet.");
		return -1;
	} else {
		return import_basic_string(scanner, lvalp, len, src, delim);
	}
}

static void init_scope(struct ctf_scanner_scope *scope,
		       struct ctf_scanner_scope *parent)
{
	scope->parent = parent;
	scope->types = g_hash_table_new_full(g_str_hash, g_str_equal,
					     NULL, NULL);
}

static void finalize_scope(struct ctf_scanner_scope *scope)
{
	g_hash_table_destroy(scope->types);
}

static void push_scope(struct ctf_scanner *scanner)
{
	struct ctf_scanner_scope *ns;

	printf_debug("push scope\n");
	ns = malloc(sizeof(struct ctf_scanner_scope));
	init_scope(ns, scanner->cs);
	scanner->cs = ns;
}

static void pop_scope(struct ctf_scanner *scanner)
{
	struct ctf_scanner_scope *os;

	printf_debug("pop scope\n");
	os = scanner->cs;
	scanner->cs = os->parent;
	finalize_scope(os);
	free(os);
}

static int lookup_type(struct ctf_scanner_scope *s, const char *id)
{
	int ret;

	ret = (int) (long) g_hash_table_lookup(s->types, id);
	printf_debug("lookup %p %s %d\n", s, id, ret);
	return ret;
}

BT_HIDDEN
int is_type(struct ctf_scanner *scanner, const char *id)
{
	struct ctf_scanner_scope *it;
	int ret = 0;

	for (it = scanner->cs; it != NULL; it = it->parent) {
		if (lookup_type(it, id)) {
			ret = 1;
			break;
		}
	}
	printf_debug("is type %s %d\n", id, ret);
	return ret;
}

static void add_type(struct ctf_scanner *scanner, char *id)
{
	printf_debug("add type %s\n", id);
	if (lookup_type(scanner->cs, id))
		return;
	g_hash_table_insert(scanner->cs->types, id, id);
}

static struct ctf_node *make_node(struct ctf_scanner *scanner,
				  enum node_type type)
{
	struct ctf_node *node;

	node = objstack_alloc(scanner->objstack, sizeof(*node));
	if (!node) {
		printfl_fatal(yyget_lineno(scanner->scanner), "out of memory");
		return &error_node;
	}
	node->type = type;
	node->lineno = yyget_lineno(scanner->scanner);
	BT_INIT_LIST_HEAD(&node->tmp_head);
	bt_list_add(&node->siblings, &node->tmp_head);

	switch (type) {
	case NODE_ROOT:
		node->type = NODE_ERROR;
		printfn_fatal(node, "trying to create root node");
		break;

	case NODE_EVENT:
		BT_INIT_LIST_HEAD(&node->u.event.declaration_list);
		break;
	case NODE_STREAM:
		BT_INIT_LIST_HEAD(&node->u.stream.declaration_list);
		break;
	case NODE_ENV:
		BT_INIT_LIST_HEAD(&node->u.env.declaration_list);
		break;
	case NODE_TRACE:
		BT_INIT_LIST_HEAD(&node->u.trace.declaration_list);
		break;
	case NODE_CLOCK:
		BT_INIT_LIST_HEAD(&node->u.clock.declaration_list);
		break;
	case NODE_CALLSITE:
		BT_INIT_LIST_HEAD(&node->u.callsite.declaration_list);
		break;

	case NODE_CTF_EXPRESSION:
		BT_INIT_LIST_HEAD(&node->u.ctf_expression.left);
		BT_INIT_LIST_HEAD(&node->u.ctf_expression.right);
		break;
	case NODE_UNARY_EXPRESSION:
		break;

	case NODE_TYPEDEF:
		BT_INIT_LIST_HEAD(&node->u._typedef.type_declarators);
		break;
	case NODE_TYPEALIAS_TARGET:
		BT_INIT_LIST_HEAD(&node->u.typealias_target.type_declarators);
		break;
	case NODE_TYPEALIAS_ALIAS:
		BT_INIT_LIST_HEAD(&node->u.typealias_alias.type_declarators);
		break;
	case NODE_TYPEALIAS:
		break;

	case NODE_TYPE_SPECIFIER:
		break;
	case NODE_TYPE_SPECIFIER_LIST:
		BT_INIT_LIST_HEAD(&node->u.type_specifier_list.head);
		break;
	case NODE_POINTER:
		break;
	case NODE_TYPE_DECLARATOR:
		BT_INIT_LIST_HEAD(&node->u.type_declarator.pointers);
		break;

	case NODE_FLOATING_POINT:
		BT_INIT_LIST_HEAD(&node->u.floating_point.expressions);
		break;
	case NODE_INTEGER:
		BT_INIT_LIST_HEAD(&node->u.integer.expressions);
		break;
	case NODE_STRING:
		BT_INIT_LIST_HEAD(&node->u.string.expressions);
		break;
	case NODE_ENUMERATOR:
		BT_INIT_LIST_HEAD(&node->u.enumerator.values);
		break;
	case NODE_ENUM:
		BT_INIT_LIST_HEAD(&node->u._enum.enumerator_list);
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		BT_INIT_LIST_HEAD(&node->u.struct_or_variant_declaration.type_declarators);
		break;
	case NODE_VARIANT:
		BT_INIT_LIST_HEAD(&node->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		BT_INIT_LIST_HEAD(&node->u._struct.declaration_list);
		BT_INIT_LIST_HEAD(&node->u._struct.min_align);
		break;

	case NODE_UNKNOWN:
	default:
		node->type = NODE_ERROR;
		printfn_fatal(node, "unknown node type '%d'", (int) type);
		break;
	}

	return node;
}

static int reparent_ctf_expression(struct ctf_node *node,
				   struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_EVENT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.stream.declaration_list);
		break;
	case NODE_ENV:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.env.declaration_list);
		break;
	case NODE_TRACE:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.trace.declaration_list);
		break;
	case NODE_CLOCK:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.clock.declaration_list);
		break;
	case NODE_CALLSITE:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.callsite.declaration_list);
		break;
	case NODE_FLOATING_POINT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.floating_point.expressions);
		break;
	case NODE_INTEGER:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.integer.expressions);
		break;
	case NODE_STRING:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.string.expressions);
		break;

	case NODE_ROOT:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPEALIAS:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUMERATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_VARIANT:
	case NODE_STRUCT:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type '%d'", (int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_typedef(struct ctf_node *node, struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_ROOT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.root.declaration_list);
		break;
	case NODE_EVENT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.stream.declaration_list);
		break;
	case NODE_ENV:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.env.declaration_list);
		break;
	case NODE_TRACE:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.trace.declaration_list);
		break;
	case NODE_CLOCK:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.clock.declaration_list);
		break;
	case NODE_CALLSITE:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.callsite.declaration_list);
		break;
	case NODE_VARIANT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u._struct.declaration_list);
		break;

	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPEALIAS:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUMERATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type %d", parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_typealias(struct ctf_node *node, struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_ROOT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.root.declaration_list);
		break;
	case NODE_EVENT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.stream.declaration_list);
		break;
	case NODE_ENV:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.env.declaration_list);
		break;
	case NODE_TRACE:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.trace.declaration_list);
		break;
	case NODE_CLOCK:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.clock.declaration_list);
		break;
	case NODE_CALLSITE:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.callsite.declaration_list);
		break;
	case NODE_VARIANT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		_bt_list_splice_tail(&node->tmp_head, &parent->u._struct.declaration_list);
		break;

	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPEALIAS:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUMERATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type '%d'", (int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_type_specifier(struct ctf_node *node,
				   struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_TYPE_SPECIFIER_LIST:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.type_specifier_list.head);
		break;

	case NODE_TYPE_SPECIFIER:
	case NODE_EVENT:
	case NODE_STREAM:
	case NODE_ENV:
	case NODE_TRACE:
	case NODE_CLOCK:
	case NODE_CALLSITE:
	case NODE_VARIANT:
	case NODE_STRUCT:
	case NODE_TYPEDEF:
	case NODE_TYPEALIAS_TARGET:
	case NODE_TYPEALIAS_ALIAS:
	case NODE_TYPE_DECLARATOR:
	case NODE_ENUM:
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
	case NODE_TYPEALIAS:
	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_POINTER:
	case NODE_ENUMERATOR:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type '%d'", (int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_type_specifier_list(struct ctf_node *node,
					struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_ROOT:
		bt_list_add_tail(&node->siblings, &parent->u.root.declaration_list);
		break;
	case NODE_EVENT:
		bt_list_add_tail(&node->siblings, &parent->u.event.declaration_list);
		break;
	case NODE_STREAM:
		bt_list_add_tail(&node->siblings, &parent->u.stream.declaration_list);
		break;
	case NODE_ENV:
		bt_list_add_tail(&node->siblings, &parent->u.env.declaration_list);
		break;
	case NODE_TRACE:
		bt_list_add_tail(&node->siblings, &parent->u.trace.declaration_list);
		break;
	case NODE_CLOCK:
		bt_list_add_tail(&node->siblings, &parent->u.clock.declaration_list);
		break;
	case NODE_CALLSITE:
		bt_list_add_tail(&node->siblings, &parent->u.callsite.declaration_list);
		break;
	case NODE_VARIANT:
		bt_list_add_tail(&node->siblings, &parent->u.variant.declaration_list);
		break;
	case NODE_STRUCT:
		bt_list_add_tail(&node->siblings, &parent->u._struct.declaration_list);
		break;
	case NODE_TYPEDEF:
		parent->u._typedef.type_specifier_list = node;
		break;
	case NODE_TYPEALIAS_TARGET:
		parent->u.typealias_target.type_specifier_list = node;
		break;
	case NODE_TYPEALIAS_ALIAS:
		parent->u.typealias_alias.type_specifier_list = node;
		break;
	case NODE_ENUM:
		parent->u._enum.container_type = node;
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		parent->u.struct_or_variant_declaration.type_specifier_list = node;
		break;
	case NODE_TYPE_DECLARATOR:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPEALIAS:
	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_POINTER:
	case NODE_ENUMERATOR:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type '%d'", (int) parent->type);
		return -EINVAL;
	}
	return 0;
}

static int reparent_type_declarator(struct ctf_node *node,
				    struct ctf_node *parent)
{
	switch (parent->type) {
	case NODE_TYPE_DECLARATOR:
		parent->u.type_declarator.type = TYPEDEC_NESTED;
		parent->u.type_declarator.u.nested.type_declarator = node;
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.struct_or_variant_declaration.type_declarators);
		break;
	case NODE_TYPEDEF:
		_bt_list_splice_tail(&node->tmp_head, &parent->u._typedef.type_declarators);
		break;
	case NODE_TYPEALIAS_TARGET:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.typealias_target.type_declarators);
		break;
	case NODE_TYPEALIAS_ALIAS:
		_bt_list_splice_tail(&node->tmp_head, &parent->u.typealias_alias.type_declarators);
		break;

	case NODE_ROOT:
	case NODE_EVENT:
	case NODE_STREAM:
	case NODE_ENV:
	case NODE_TRACE:
	case NODE_CLOCK:
	case NODE_CALLSITE:
	case NODE_VARIANT:
	case NODE_STRUCT:
	case NODE_TYPEALIAS:
	case NODE_ENUM:
	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_CTF_EXPRESSION:
	case NODE_TYPE_SPECIFIER:
	case NODE_TYPE_SPECIFIER_LIST:
	case NODE_POINTER:
	case NODE_ENUMERATOR:
	case NODE_UNARY_EXPRESSION:
		return -EPERM;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type '%d'", (int) parent->type);
		return -EINVAL;
	}
	return 0;
}

/*
 * set_parent_node
 *
 * Link node to parent. Returns 0 on success, -EPERM if it is not permitted to
 * create the link declared by the input, -ENOENT if node or parent is NULL,
 * -EINVAL if there is an internal structure problem.
 */
static int set_parent_node(struct ctf_node *node,
			 struct ctf_node *parent)
{
	if (!node || !parent)
		return -ENOENT;

	/* Note: Linking to parent will be done only by an external visitor */

	switch (node->type) {
	case NODE_ROOT:
		printfn_fatal(node, "trying to reparent root node");
		return -EINVAL;

	case NODE_EVENT:
		if (parent->type == NODE_ROOT) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.root.event);
		} else {
			return -EPERM;
		}
		break;
	case NODE_STREAM:
		if (parent->type == NODE_ROOT) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.root.stream);
		} else {
			return -EPERM;
		}
		break;
	case NODE_ENV:
		if (parent->type == NODE_ROOT) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.root.env);
		} else {
			return -EPERM;
		}
		break;
	case NODE_TRACE:
		if (parent->type == NODE_ROOT) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.root.trace);
		} else {
			return -EPERM;
		}
		break;
	case NODE_CLOCK:
		if (parent->type == NODE_ROOT) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.root.clock);
		} else {
			return -EPERM;
		}
		break;
	case NODE_CALLSITE:
		if (parent->type == NODE_ROOT) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.root.callsite);
		} else {
			return -EPERM;
		}
		break;

	case NODE_CTF_EXPRESSION:
		return reparent_ctf_expression(node, parent);
	case NODE_UNARY_EXPRESSION:
		if (parent->type == NODE_TYPE_DECLARATOR)
			parent->u.type_declarator.bitfield_len = node;
		else
			return -EPERM;
		break;

	case NODE_TYPEDEF:
		return reparent_typedef(node, parent);
	case NODE_TYPEALIAS_TARGET:
		if (parent->type == NODE_TYPEALIAS)
			parent->u.typealias.target = node;
		else
			return -EINVAL;
	case NODE_TYPEALIAS_ALIAS:
		if (parent->type == NODE_TYPEALIAS)
			parent->u.typealias.alias = node;
		else
			return -EINVAL;
	case NODE_TYPEALIAS:
		return reparent_typealias(node, parent);

	case NODE_POINTER:
		if (parent->type == NODE_TYPE_DECLARATOR) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u.type_declarator.pointers);
		} else
			return -EPERM;
		break;
	case NODE_TYPE_DECLARATOR:
		return reparent_type_declarator(node, parent);

	case NODE_TYPE_SPECIFIER_LIST:
		return reparent_type_specifier_list(node, parent);

	case NODE_TYPE_SPECIFIER:
		return reparent_type_specifier(node, parent);

	case NODE_FLOATING_POINT:
	case NODE_INTEGER:
	case NODE_STRING:
	case NODE_ENUM:
	case NODE_VARIANT:
	case NODE_STRUCT:
		return -EINVAL;	/* Dealt with internally within grammar */

	case NODE_ENUMERATOR:
		if (parent->type == NODE_ENUM) {
			_bt_list_splice_tail(&node->tmp_head, &parent->u._enum.enumerator_list);
		} else {
			return -EPERM;
		}
		break;
	case NODE_STRUCT_OR_VARIANT_DECLARATION:
		switch (parent->type) {
		case NODE_STRUCT:
			_bt_list_splice_tail(&node->tmp_head, &parent->u._struct.declaration_list);
			break;
		case NODE_VARIANT:
			_bt_list_splice_tail(&node->tmp_head, &parent->u.variant.declaration_list);
			break;
		default:
			return -EINVAL;
		}
		break;

	case NODE_UNKNOWN:
	default:
		printfn_fatal(node, "unknown node type '%d'", (int) parent->type);
		return -EINVAL;
	}
	return 0;
}

BT_HIDDEN
void yyerror(struct ctf_scanner *scanner, yyscan_t yyscanner, const char *str)
{
	printfl_error(yyget_lineno(scanner->scanner),
		"token \"%s\": %s\n",
		yyget_text(scanner->scanner), str);
}
 
BT_HIDDEN
int yywrap(void)
{
	return 1;
} 

#define reparent_error(scanner, str)				\
do {								\
	yyerror(scanner, scanner->scanner, YY_("reparent_error: " str)); \
	YYERROR;						\
} while (0)

static struct ctf_ast *ctf_ast_alloc(struct ctf_scanner *scanner)
{
	struct ctf_ast *ast;

	ast = objstack_alloc(scanner->objstack, sizeof(*ast));
	if (!ast)
		return NULL;
	ast->root.type = NODE_ROOT;
	BT_INIT_LIST_HEAD(&ast->root.tmp_head);
	BT_INIT_LIST_HEAD(&ast->root.u.root.declaration_list);
	BT_INIT_LIST_HEAD(&ast->root.u.root.trace);
	BT_INIT_LIST_HEAD(&ast->root.u.root.env);
	BT_INIT_LIST_HEAD(&ast->root.u.root.stream);
	BT_INIT_LIST_HEAD(&ast->root.u.root.event);
	BT_INIT_LIST_HEAD(&ast->root.u.root.clock);
	BT_INIT_LIST_HEAD(&ast->root.u.root.callsite);
	return ast;
}

int ctf_scanner_append_ast(struct ctf_scanner *scanner, FILE *input)
{
	/* Start processing new stream */
	yyrestart(input, scanner->scanner);
	if (yydebug)
		fprintf(stdout, "Scanner input is a%s.\n",
			isatty(fileno(input)) ? "n interactive tty" :
						" noninteractive file");
	return yyparse(scanner, scanner->scanner);
}

struct ctf_scanner *ctf_scanner_alloc(void)
{
	struct ctf_scanner *scanner;
	int ret;

	yydebug = babeltrace_debug;

	scanner = malloc(sizeof(*scanner));
	if (!scanner)
		return NULL;
	memset(scanner, 0, sizeof(*scanner));
	ret = yylex_init_extra(scanner, &scanner->scanner);
	if (ret) {
		printf_fatal("yylex_init error");
		goto cleanup_scanner;
	}
	scanner->objstack = objstack_create();
	if (!scanner->objstack)
		goto cleanup_lexer;
	scanner->ast = ctf_ast_alloc(scanner);
	if (!scanner->ast)
		goto cleanup_objstack;
	init_scope(&scanner->root_scope, NULL);
	scanner->cs = &scanner->root_scope;

	return scanner;

cleanup_objstack:
	objstack_destroy(scanner->objstack);
cleanup_lexer:
	ret = yylex_destroy(scanner->scanner);
	if (!ret)
		printf_fatal("yylex_destroy error");
cleanup_scanner:
	free(scanner);
	return NULL;
}

void ctf_scanner_free(struct ctf_scanner *scanner)
{
	int ret;

	if (!scanner)
		return;
	finalize_scope(&scanner->root_scope);
	objstack_destroy(scanner->objstack);
	ret = yylex_destroy(scanner->scanner);
	if (ret)
		printf_error("yylex_destroy error");
	free(scanner);
}


#line 1110 "ctf-parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_CTF_PARSER_H_INCLUDED
# define YY_YY_CTF_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    INTEGER_LITERAL = 258,         /* INTEGER_LITERAL  */
    STRING_LITERAL = 259,          /* STRING_LITERAL  */
    CHARACTER_LITERAL = 260,       /* CHARACTER_LITERAL  */
    LSBRAC = 261,                  /* LSBRAC  */
    RSBRAC = 262,                  /* RSBRAC  */
    LPAREN = 263,                  /* LPAREN  */
    RPAREN = 264,                  /* RPAREN  */
    LBRAC = 265,                   /* LBRAC  */
    RBRAC = 266,                   /* RBRAC  */
    RARROW = 267,                  /* RARROW  */
    STAR = 268,                    /* STAR  */
    PLUS = 269,                    /* PLUS  */
    MINUS = 270,                   /* MINUS  */
    LT = 271,                      /* LT  */
    GT = 272,                      /* GT  */
    TYPEASSIGN = 273,              /* TYPEASSIGN  */
    COLON = 274,                   /* COLON  */
    SEMICOLON = 275,               /* SEMICOLON  */
    DOTDOTDOT = 276,               /* DOTDOTDOT  */
    DOT = 277,                     /* DOT  */
    EQUAL = 278,                   /* EQUAL  */
    COMMA = 279,                   /* COMMA  */
    CONST = 280,                   /* CONST  */
    CHAR = 281,                    /* CHAR  */
    DOUBLE = 282,                  /* DOUBLE  */
    ENUM = 283,                    /* ENUM  */
    ENV = 284,                     /* ENV  */
    EVENT = 285,                   /* EVENT  */
    FLOATING_POINT = 286,          /* FLOATING_POINT  */
    FLOAT = 287,                   /* FLOAT  */
    INTEGER = 288,                 /* INTEGER  */
    INT = 289,                     /* INT  */
    LONG = 290,                    /* LONG  */
    SHORT = 291,                   /* SHORT  */
    SIGNED = 292,                  /* SIGNED  */
    STREAM = 293,                  /* STREAM  */
    STRING = 294,                  /* STRING  */
    STRUCT = 295,                  /* STRUCT  */
    TRACE = 296,                   /* TRACE  */
    CALLSITE = 297,                /* CALLSITE  */
    CLOCK = 298,                   /* CLOCK  */
    TYPEALIAS = 299,               /* TYPEALIAS  */
    TYPEDEF = 300,                 /* TYPEDEF  */
    UNSIGNED = 301,                /* UNSIGNED  */
    VARIANT = 302,                 /* VARIANT  */
    VOID = 303,                    /* VOID  */
    _BOOL = 304,                   /* _BOOL  */
    _COMPLEX = 305,                /* _COMPLEX  */
    _IMAGINARY = 306,              /* _IMAGINARY  */
    TOK_ALIGN = 307,               /* TOK_ALIGN  */
    IDENTIFIER = 308,              /* IDENTIFIER  */
    ID_TYPE = 309,                 /* ID_TYPE  */
    ERROR = 310                    /* ERROR  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define INTEGER_LITERAL 258
#define STRING_LITERAL 259
#define CHARACTER_LITERAL 260
#define LSBRAC 261
#define RSBRAC 262
#define LPAREN 263
#define RPAREN 264
#define LBRAC 265
#define RBRAC 266
#define RARROW 267
#define STAR 268
#define PLUS 269
#define MINUS 270
#define LT 271
#define GT 272
#define TYPEASSIGN 273
#define COLON 274
#define SEMICOLON 275
#define DOTDOTDOT 276
#define DOT 277
#define EQUAL 278
#define COMMA 279
#define CONST 280
#define CHAR 281
#define DOUBLE 282
#define ENUM 283
#define ENV 284
#define EVENT 285
#define FLOATING_POINT 286
#define FLOAT 287
#define INTEGER 288
#define INT 289
#define LONG 290
#define SHORT 291
#define SIGNED 292
#define STREAM 293
#define STRING 294
#define STRUCT 295
#define TRACE 296
#define CALLSITE 297
#define CLOCK 298
#define TYPEALIAS 299
#define TYPEDEF 300
#define UNSIGNED 301
#define VARIANT 302
#define VOID 303
#define _BOOL 304
#define _COMPLEX 305
#define _IMAGINARY 306
#define TOK_ALIGN 307
#define IDENTIFIER 308
#define ID_TYPE 309
#define ERROR 310

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 1060 "../../../../git/formats/ctf/metadata/ctf-parser.y"

	long long ll;
	unsigned long long ull;
	char c;
	char *s;
	struct ctf_node *n;

#line 1281 "ctf-parser.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif




int yyparse (struct ctf_scanner *scanner, yyscan_t yyscanner);


#endif /* !YY_YY_CTF_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_INTEGER_LITERAL = 3,            /* INTEGER_LITERAL  */
  YYSYMBOL_STRING_LITERAL = 4,             /* STRING_LITERAL  */
  YYSYMBOL_CHARACTER_LITERAL = 5,          /* CHARACTER_LITERAL  */
  YYSYMBOL_LSBRAC = 6,                     /* LSBRAC  */
  YYSYMBOL_RSBRAC = 7,                     /* RSBRAC  */
  YYSYMBOL_LPAREN = 8,                     /* LPAREN  */
  YYSYMBOL_RPAREN = 9,                     /* RPAREN  */
  YYSYMBOL_LBRAC = 10,                     /* LBRAC  */
  YYSYMBOL_RBRAC = 11,                     /* RBRAC  */
  YYSYMBOL_RARROW = 12,                    /* RARROW  */
  YYSYMBOL_STAR = 13,                      /* STAR  */
  YYSYMBOL_PLUS = 14,                      /* PLUS  */
  YYSYMBOL_MINUS = 15,                     /* MINUS  */
  YYSYMBOL_LT = 16,                        /* LT  */
  YYSYMBOL_GT = 17,                        /* GT  */
  YYSYMBOL_TYPEASSIGN = 18,                /* TYPEASSIGN  */
  YYSYMBOL_COLON = 19,                     /* COLON  */
  YYSYMBOL_SEMICOLON = 20,                 /* SEMICOLON  */
  YYSYMBOL_DOTDOTDOT = 21,                 /* DOTDOTDOT  */
  YYSYMBOL_DOT = 22,                       /* DOT  */
  YYSYMBOL_EQUAL = 23,                     /* EQUAL  */
  YYSYMBOL_COMMA = 24,                     /* COMMA  */
  YYSYMBOL_CONST = 25,                     /* CONST  */
  YYSYMBOL_CHAR = 26,                      /* CHAR  */
  YYSYMBOL_DOUBLE = 27,                    /* DOUBLE  */
  YYSYMBOL_ENUM = 28,                      /* ENUM  */
  YYSYMBOL_ENV = 29,                       /* ENV  */
  YYSYMBOL_EVENT = 30,                     /* EVENT  */
  YYSYMBOL_FLOATING_POINT = 31,            /* FLOATING_POINT  */
  YYSYMBOL_FLOAT = 32,                     /* FLOAT  */
  YYSYMBOL_INTEGER = 33,                   /* INTEGER  */
  YYSYMBOL_INT = 34,                       /* INT  */
  YYSYMBOL_LONG = 35,                      /* LONG  */
  YYSYMBOL_SHORT = 36,                     /* SHORT  */
  YYSYMBOL_SIGNED = 37,                    /* SIGNED  */
  YYSYMBOL_STREAM = 38,                    /* STREAM  */
  YYSYMBOL_STRING = 39,                    /* STRING  */
  YYSYMBOL_STRUCT = 40,                    /* STRUCT  */
  YYSYMBOL_TRACE = 41,                     /* TRACE  */
  YYSYMBOL_CALLSITE = 42,                  /* CALLSITE  */
  YYSYMBOL_CLOCK = 43,                     /* CLOCK  */
  YYSYMBOL_TYPEALIAS = 44,                 /* TYPEALIAS  */
  YYSYMBOL_TYPEDEF = 45,                   /* TYPEDEF  */
  YYSYMBOL_UNSIGNED = 46,                  /* UNSIGNED  */
  YYSYMBOL_VARIANT = 47,                   /* VARIANT  */
  YYSYMBOL_VOID = 48,                      /* VOID  */
  YYSYMBOL__BOOL = 49,                     /* _BOOL  */
  YYSYMBOL__COMPLEX = 50,                  /* _COMPLEX  */
  YYSYMBOL__IMAGINARY = 51,                /* _IMAGINARY  */
  YYSYMBOL_TOK_ALIGN = 52,                 /* TOK_ALIGN  */
  YYSYMBOL_IDENTIFIER = 53,                /* IDENTIFIER  */
  YYSYMBOL_ID_TYPE = 54,                   /* ID_TYPE  */
  YYSYMBOL_ERROR = 55,                     /* ERROR  */
  YYSYMBOL_YYACCEPT = 56,                  /* $accept  */
  YYSYMBOL_file = 57,                      /* file  */
  YYSYMBOL_keywords = 58,                  /* keywords  */
  YYSYMBOL_postfix_expression = 59,        /* postfix_expression  */
  YYSYMBOL_unary_expression = 60,          /* unary_expression  */
  YYSYMBOL_unary_expression_or_range = 61, /* unary_expression_or_range  */
  YYSYMBOL_declaration = 62,               /* declaration  */
  YYSYMBOL_event_declaration = 63,         /* event_declaration  */
  YYSYMBOL_event_declaration_begin = 64,   /* event_declaration_begin  */
  YYSYMBOL_event_declaration_end = 65,     /* event_declaration_end  */
  YYSYMBOL_stream_declaration = 66,        /* stream_declaration  */
  YYSYMBOL_stream_declaration_begin = 67,  /* stream_declaration_begin  */
  YYSYMBOL_stream_declaration_end = 68,    /* stream_declaration_end  */
  YYSYMBOL_env_declaration = 69,           /* env_declaration  */
  YYSYMBOL_env_declaration_begin = 70,     /* env_declaration_begin  */
  YYSYMBOL_env_declaration_end = 71,       /* env_declaration_end  */
  YYSYMBOL_trace_declaration = 72,         /* trace_declaration  */
  YYSYMBOL_trace_declaration_begin = 73,   /* trace_declaration_begin  */
  YYSYMBOL_trace_declaration_end = 74,     /* trace_declaration_end  */
  YYSYMBOL_clock_declaration = 75,         /* clock_declaration  */
  YYSYMBOL_clock_declaration_begin = 76,   /* clock_declaration_begin  */
  YYSYMBOL_clock_declaration_end = 77,     /* clock_declaration_end  */
  YYSYMBOL_callsite_declaration = 78,      /* callsite_declaration  */
  YYSYMBOL_callsite_declaration_begin = 79, /* callsite_declaration_begin  */
  YYSYMBOL_callsite_declaration_end = 80,  /* callsite_declaration_end  */
  YYSYMBOL_integer_declaration_specifiers = 81, /* integer_declaration_specifiers  */
  YYSYMBOL_declaration_specifiers = 82,    /* declaration_specifiers  */
  YYSYMBOL_type_declarator_list = 83,      /* type_declarator_list  */
  YYSYMBOL_integer_type_specifier = 84,    /* integer_type_specifier  */
  YYSYMBOL_type_specifier = 85,            /* type_specifier  */
  YYSYMBOL_struct_type_specifier = 86,     /* struct_type_specifier  */
  YYSYMBOL_struct_declaration_begin = 87,  /* struct_declaration_begin  */
  YYSYMBOL_struct_declaration_end = 88,    /* struct_declaration_end  */
  YYSYMBOL_variant_type_specifier = 89,    /* variant_type_specifier  */
  YYSYMBOL_variant_declaration_begin = 90, /* variant_declaration_begin  */
  YYSYMBOL_variant_declaration_end = 91,   /* variant_declaration_end  */
  YYSYMBOL_enum_type_specifier = 92,       /* enum_type_specifier  */
  YYSYMBOL_struct_or_variant_declaration_list = 93, /* struct_or_variant_declaration_list  */
  YYSYMBOL_struct_or_variant_declaration = 94, /* struct_or_variant_declaration  */
  YYSYMBOL_alias_declaration_specifiers = 95, /* alias_declaration_specifiers  */
  YYSYMBOL_struct_or_variant_declarator_list = 96, /* struct_or_variant_declarator_list  */
  YYSYMBOL_struct_or_variant_declarator = 97, /* struct_or_variant_declarator  */
  YYSYMBOL_enumerator_list = 98,           /* enumerator_list  */
  YYSYMBOL_enumerator = 99,                /* enumerator  */
  YYSYMBOL_abstract_declarator_list = 100, /* abstract_declarator_list  */
  YYSYMBOL_abstract_declarator = 101,      /* abstract_declarator  */
  YYSYMBOL_direct_abstract_declarator = 102, /* direct_abstract_declarator  */
  YYSYMBOL_alias_abstract_declarator_list = 103, /* alias_abstract_declarator_list  */
  YYSYMBOL_alias_abstract_declarator = 104, /* alias_abstract_declarator  */
  YYSYMBOL_direct_alias_abstract_declarator = 105, /* direct_alias_abstract_declarator  */
  YYSYMBOL_declarator = 106,               /* declarator  */
  YYSYMBOL_direct_declarator = 107,        /* direct_declarator  */
  YYSYMBOL_type_declarator = 108,          /* type_declarator  */
  YYSYMBOL_direct_type_declarator = 109,   /* direct_type_declarator  */
  YYSYMBOL_pointer = 110,                  /* pointer  */
  YYSYMBOL_type_qualifier_list = 111,      /* type_qualifier_list  */
  YYSYMBOL_ctf_assignment_expression_list = 112, /* ctf_assignment_expression_list  */
  YYSYMBOL_ctf_assignment_expression = 113 /* ctf_assignment_expression  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  72
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2199

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  56
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  58
/* YYNRULES -- Number of rules.  */
#define YYNRULES  233
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  444

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   310


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  1115,  1115,  1120,  1128,  1130,  1132,  1134,  1136,  1138,
    1140,  1142,  1144,  1146,  1148,  1150,  1152,  1154,  1156,  1158,
    1160,  1162,  1164,  1166,  1168,  1170,  1172,  1174,  1176,  1178,
    1180,  1188,  1194,  1200,  1206,  1212,  1218,  1224,  1228,  1236,
    1245,  1254,  1263,  1272,  1284,  1286,  1294,  1311,  1317,  1324,
    1326,  1328,  1330,  1332,  1334,  1336,  1338,  1349,  1359,  1369,
    1390,  1394,  1403,  1408,  1414,  1418,  1427,  1432,  1437,  1441,
    1450,  1455,  1460,  1464,  1473,  1478,  1483,  1487,  1496,  1501,
    1506,  1510,  1519,  1524,  1529,  1538,  1546,  1555,  1563,  1572,
    1580,  1589,  1597,  1599,  1607,  1612,  1617,  1622,  1627,  1632,
    1637,  1642,  1648,  1654,  1665,  1670,  1675,  1680,  1685,  1690,
    1695,  1700,  1705,  1710,  1715,  1720,  1725,  1731,  1737,  1745,
    1751,  1759,  1765,  1771,  1779,  1785,  1791,  1800,  1807,  1815,
    1823,  1829,  1835,  1843,  1852,  1864,  1869,  1874,  1881,  1889,
    1897,  1905,  1914,  1921,  1930,  1937,  1945,  1954,  1961,  1970,
    1980,  1985,  1990,  1996,  2003,  2010,  2018,  2025,  2033,  2039,
    2046,  2053,  2061,  2067,  2074,  2082,  2092,  2093,  2106,  2116,
    2127,  2137,  2147,  2168,  2177,  2185,  2196,  2205,  2210,  2224,
    2226,  2234,  2236,  2238,  2247,  2249,  2257,  2262,  2267,  2272,
    2277,  2283,  2289,  2295,  2304,  2306,  2314,  2316,  2325,  2330,
    2336,  2342,  2350,  2360,  2362,  2370,  2372,  2381,  2386,  2392,
    2400,  2410,  2412,  2420,  2426,  2432,  2443,  2445,  2453,  2460,
    2466,  2477,  2481,  2486,  2496,  2497,  2503,  2505,  2513,  2525,
    2537,  2548,  2558,  2568
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "INTEGER_LITERAL",
  "STRING_LITERAL", "CHARACTER_LITERAL", "LSBRAC", "RSBRAC", "LPAREN",
  "RPAREN", "LBRAC", "RBRAC", "RARROW", "STAR", "PLUS", "MINUS", "LT",
  "GT", "TYPEASSIGN", "COLON", "SEMICOLON", "DOTDOTDOT", "DOT", "EQUAL",
  "COMMA", "CONST", "CHAR", "DOUBLE", "ENUM", "ENV", "EVENT",
  "FLOATING_POINT", "FLOAT", "INTEGER", "INT", "LONG", "SHORT", "SIGNED",
  "STREAM", "STRING", "STRUCT", "TRACE", "CALLSITE", "CLOCK", "TYPEALIAS",
  "TYPEDEF", "UNSIGNED", "VARIANT", "VOID", "_BOOL", "_COMPLEX",
  "_IMAGINARY", "TOK_ALIGN", "IDENTIFIER", "ID_TYPE", "ERROR", "$accept",
  "file", "keywords", "postfix_expression", "unary_expression",
  "unary_expression_or_range", "declaration", "event_declaration",
  "event_declaration_begin", "event_declaration_end", "stream_declaration",
  "stream_declaration_begin", "stream_declaration_end", "env_declaration",
  "env_declaration_begin", "env_declaration_end", "trace_declaration",
  "trace_declaration_begin", "trace_declaration_end", "clock_declaration",
  "clock_declaration_begin", "clock_declaration_end",
  "callsite_declaration", "callsite_declaration_begin",
  "callsite_declaration_end", "integer_declaration_specifiers",
  "declaration_specifiers", "type_declarator_list",
  "integer_type_specifier", "type_specifier", "struct_type_specifier",
  "struct_declaration_begin", "struct_declaration_end",
  "variant_type_specifier", "variant_declaration_begin",
  "variant_declaration_end", "enum_type_specifier",
  "struct_or_variant_declaration_list", "struct_or_variant_declaration",
  "alias_declaration_specifiers", "struct_or_variant_declarator_list",
  "struct_or_variant_declarator", "enumerator_list", "enumerator",
  "abstract_declarator_list", "abstract_declarator",
  "direct_abstract_declarator", "alias_abstract_declarator_list",
  "alias_abstract_declarator", "direct_alias_abstract_declarator",
  "declarator", "direct_declarator", "type_declarator",
  "direct_type_declarator", "pointer", "type_qualifier_list",
  "ctf_assignment_expression_list", "ctf_assignment_expression", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-363)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-33)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    1998,  -363,  -363,  -363,    45,    22,    92,    94,  -363,   146,
    -363,  -363,  -363,  -363,   165,   194,    59,   204,   207,   228,
    2088,  2088,  -363,    57,  -363,  -363,  -363,  -363,  -363,   397,
    -363,  -363,   449,  -363,   501,  -363,   553,  -363,   605,  -363,
    -363,  1938,  -363,  1679,  2145,    75,   150,  -363,  -363,  -363,
     657,   709,  -363,   761,  -363,   241,   241,  -363,  -363,  -363,
    -363,   813,  -363,   865,  1756,  1786,  -363,    66,    47,   145,
    -363,  -363,  -363,  -363,  -363,  -363,  -363,  1281,    19,  1333,
    1333,   116,   218,   253,    45,  -363,  -363,    94,   305,   146,
     354,   387,   394,   443,  -363,   209,    59,  -363,  -363,  -363,
    2088,  2088,   450,    57,   502,   554,   606,   658,  -363,  -363,
     710,  -363,   131,    60,  -363,  2028,   449,   205,   234,  -363,
     501,   236,  -363,   553,   238,  -363,   605,  -363,  -363,  1816,
    -363,    30,  -363,  -363,  -363,  -363,  -363,  -363,  -363,  -363,
    -363,  -363,  -363,  -363,  -363,  -363,  -363,  -363,  -363,  -363,
    -363,  -363,   240,   243,   247,    48,  -363,  -363,  -363,   251,
    -363,  -363,  -363,  -363,  -363,  -363,  -363,    81,  -363,  1679,
    2145,  1679,  2145,  -363,   917,  -363,   969,  -363,  1021,  -363,
    -363,  1876,   252,  -363,   813,   254,  -363,   865,    35,    29,
    -363,   152,  -363,    54,     9,    36,  -363,   121,  -363,   271,
      39,   267,   274,   113,  -363,   132,  -363,  1906,  -363,   283,
    -363,   131,   131,  1756,  1786,  1281,   143,  1968,  2088,  1281,
    1816,  -363,   273,  -363,  -363,  -363,  -363,  -363,  -363,  -363,
    1786,   178,  1281,  1281,  1281,  1281,  -363,  1384,  1073,  1679,
    -363,  -363,    50,   300,    97,   349,  -363,  -363,  -363,  1876,
    1876,  -363,  2088,  2088,  1726,   246,  -363,  -363,  -363,  -363,
    -363,   286,  -363,  -363,   139,  2058,    35,  1177,    54,   292,
    -363,    36,  1281,   271,   294,   294,   289,   290,  1906,   291,
     299,  1906,  -363,  -363,  -363,   166,   295,   311,  -363,  -363,
    -363,  -363,  -363,  2118,  -363,  1786,   295,  -363,   185,  -363,
     303,  -363,  -363,  -363,  -363,  -363,  -363,  -363,  1125,   112,
    -363,  1435,  1679,  -363,  1486,  1679,   269,   279,  1756,  1786,
      37,  1281,  1816,  -363,   192,  -363,   313,   335,    43,   339,
    -363,  -363,  -363,  -363,  -363,  -363,  1846,  -363,  -363,   341,
    -363,  -363,   344,  -363,  -363,   294,   294,  -363,   294,   294,
    -363,  2058,  -363,   295,  -363,  1281,  -363,  -363,  1537,  -363,
     120,  -363,   138,   347,   348,   169,   202,   343,  -363,  1786,
     213,  -363,    33,  1281,  1281,   335,  1281,   181,  -363,  -363,
    -363,   215,  -363,   351,   350,  -363,  -363,  1906,  1906,  -363,
    -363,  -363,  -363,  1846,  -363,  -363,  -363,  1588,  -363,  1639,
    1281,  1281,  2058,  -363,  -363,   223,  -363,  -363,  -363,   356,
     352,   358,  -363,   181,  1229,   351,  -363,  -363,  1906,  1906,
    1906,  1906,   345,  -363,  -363,   364,   369,  1846,  -363,  -363,
    -363,  -363,  -363,  -363,   372,  -363,  -363,  -363,  -363,  -363,
    -363,   224,  -363,  -363
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,    88,   105,   110,     0,     0,     0,     0,   109,     0,
     107,   108,   106,   111,     0,   121,     0,     0,     0,     0,
       0,     0,   112,     0,   104,   113,   114,   115,   116,     0,
       2,    50,     0,    51,     0,    52,     0,    53,     0,    54,
      55,     0,    89,     0,     0,   162,   165,   124,    70,    62,
       0,     0,    66,     0,   135,   130,   131,   126,   166,    74,
      82,     0,    78,     0,   198,     0,   150,     0,     0,     0,
     125,   166,     1,     3,    34,    35,    36,     0,     0,     0,
       0,    88,   105,   110,    19,    26,    24,    16,   109,    17,
     107,   108,   106,   111,    25,   121,    21,    27,    29,    28,
       0,    23,   112,    20,   104,   113,   114,   115,    30,    31,
     116,    33,    44,     0,    60,     0,     0,     0,     0,    64,
       0,     0,    68,     0,     0,    72,     0,    49,    90,     0,
      91,   189,    22,     5,    10,    19,    16,     9,    17,     7,
       8,     6,    11,    18,    21,    23,    12,    20,     4,    13,
      14,    15,   186,   187,   188,     0,   184,    84,    94,     0,
      96,    97,    95,    98,    99,   100,   101,     0,    85,     0,
       0,     0,     0,   117,     0,   119,     0,   122,     0,   166,
     166,     0,     0,    80,     0,     0,    76,     0,   198,   221,
     199,     0,   194,   196,   198,     0,   218,     0,    92,   216,
       0,     0,     0,     0,   166,     0,   166,     0,    32,     0,
      63,    45,    46,   198,     0,     0,     0,     0,     0,     0,
       0,    61,     0,   226,    67,    65,    71,    69,    75,    73,
       0,     0,     0,     0,     0,     0,   152,     0,     0,     0,
      86,    87,     0,     0,     0,     0,   118,   120,   123,     0,
       0,   136,     0,     0,     0,   127,   167,    83,    81,    79,
      77,     0,   224,   222,     0,     0,   198,     0,   197,     0,
      57,     0,     0,   217,     0,     0,     0,     0,     0,     0,
       0,     0,   151,   137,    37,     0,   231,     0,    42,    43,
      39,    40,    41,   229,   228,     0,   232,   227,     0,    58,
      48,   193,   190,   191,   192,   158,   185,   102,     0,     0,
     154,     0,     0,   156,     0,     0,   128,   129,   198,     0,
       0,     0,     0,   213,     0,   179,   181,   211,     0,     0,
     200,   225,   223,   173,   175,   174,   207,   195,   202,     0,
     219,    93,     0,   166,   166,   142,   144,   140,   147,   149,
     145,     0,    38,   230,    56,     0,   103,   153,     0,   160,
       0,   163,     0,     0,     0,     0,     0,     0,   182,     0,
       0,   168,     0,     0,     0,   212,     0,   207,   176,   178,
     177,     0,   203,   205,   207,   201,   220,     0,     0,   166,
     166,   166,   166,   207,    47,   159,   155,     0,   157,     0,
       0,     0,     0,   170,   214,     0,   171,   180,   183,     0,
       0,     0,    59,   207,     0,   206,   138,   139,     0,     0,
       0,     0,   233,   161,   164,     0,     0,   207,   169,   215,
     132,   208,   204,   210,     0,   141,   143,   146,   148,   133,
     134,     0,   209,   172
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -363,  -363,   -29,   200,   -61,    34,   336,  -363,  -363,   264,
    -363,  -363,   261,  -363,  -363,   266,  -363,  -363,   265,  -363,
    -363,   203,  -363,  -363,   208,  -114,     0,  -127,  -148,   -31,
    -363,   190,    40,  -363,   -46,  -241,  -363,   -47,  -363,  -321,
    -363,    32,  -164,  -234,  -209,  -161,   214,  -362,  -342,    10,
      82,    73,  -189,   211,   -63,  -363,   -25,  -108
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    29,   111,   112,   113,   301,    30,    31,    32,   114,
      33,    34,   119,    35,    36,   122,    37,    38,   125,    39,
      63,   186,    40,    61,   183,   167,   115,   197,   168,    42,
      57,    58,   255,    70,    71,   283,    47,   181,   256,   336,
     324,   325,   155,   156,   191,   192,   193,   381,   382,   383,
     326,   327,   198,   199,   200,   264,   116,   117
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      41,   194,   231,   306,   285,   242,   269,   244,   222,   120,
     130,   123,   222,   126,   154,   222,   209,   188,   222,   241,
      64,    65,   204,   206,   207,   174,   176,   261,   178,    41,
     393,   422,    48,   130,   130,   411,   184,   347,   187,   210,
     350,   320,   189,   188,   195,   320,   189,   195,   189,   189,
     189,   320,   321,   232,   262,    43,   243,    66,   245,   236,
     267,   310,   190,   203,    44,   441,   222,    66,   222,    54,
     222,   432,   237,    67,   311,   309,   222,   306,   218,   222,
     306,   427,   341,   219,   130,   169,   323,   286,   190,   196,
     323,   239,   196,   296,   170,   241,   323,   241,    45,    46,
     213,   214,    49,   298,    50,   337,   240,   158,   313,   365,
      68,    69,    55,    56,   159,   160,   161,   162,   163,   201,
     202,   314,   -22,   357,   306,   194,   263,   164,   -22,   230,
     165,   396,   249,   250,   -22,   166,   358,   215,   -22,   -22,
     154,   270,   154,   216,   397,   271,   416,   417,   360,   398,
     194,   362,   189,   217,   287,    66,    51,   278,   294,   281,
     171,   205,   399,   306,   331,   306,   276,   277,   353,   172,
     265,   300,   300,   300,   300,    52,   266,   435,   436,   437,
     438,   254,   130,   130,   351,   279,   280,   402,   292,   377,
     266,   328,   366,   266,   189,   370,   288,   289,   299,   130,
     222,   332,   271,   194,    53,   354,   339,   254,   154,   271,
     154,   342,   371,   308,    59,   -18,   372,    60,   293,    53,
     295,   -18,   403,   130,    -5,   223,   271,   -18,   343,   344,
      -5,   -18,   -18,   406,   335,   412,    -5,   271,    62,   413,
      -5,    -5,   405,   428,   443,   179,   180,   271,   413,   254,
     254,    54,   318,   319,   224,   194,   226,   328,   228,   -10,
     368,   238,   130,   233,   130,   -10,   234,   302,   303,   304,
     235,   -10,   257,   384,   259,   -10,   -10,   272,   254,   211,
     212,   254,   154,   154,   274,   154,   154,   130,   130,   316,
     317,   275,   284,   297,   394,   330,   387,   388,   329,   389,
     390,   340,   391,   392,    66,   380,   345,   346,   348,   328,
     312,    -9,   408,   409,   384,   410,   349,    -9,   352,   271,
     335,   363,   369,    -9,   355,   240,   158,    -9,    -9,   154,
     384,   364,   373,   159,   160,   161,   162,   163,   130,   425,
     426,   374,   418,   419,   420,   421,   164,   376,   385,   165,
     384,   386,   404,   434,   166,   400,   401,   414,   377,   315,
      -7,   430,   380,   429,   384,    73,    -7,   431,   154,   413,
     154,   335,    -7,   439,   240,   158,    -7,    -7,   440,   442,
     221,   225,   159,   160,   161,   162,   163,   254,   254,   227,
     260,   229,   258,    -8,   415,   164,   380,    72,   165,    -8,
      -6,   375,   367,   166,   407,    -8,    -6,     0,   268,    -8,
      -8,   273,    -6,     0,     0,     0,    -6,    -6,   254,   254,
     254,   254,     1,     2,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,   -11,
       0,    28,    74,    75,    76,   -11,   -12,    77,     0,     0,
      78,   -11,   -12,    79,    80,   -11,   -11,     0,   -12,     0,
       0,     0,   -12,   -12,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,    74,    75,    76,     0,    -4,    77,
       0,     0,   118,     0,    -4,    79,    80,     0,     0,     0,
      -4,     0,     0,     0,    -4,    -4,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,    74,    75,    76,     0,
     -13,    77,     0,     0,   121,     0,   -13,    79,    80,     0,
       0,     0,   -13,     0,     0,     0,   -13,   -13,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    74,    75,
      76,     0,   -14,    77,     0,     0,   124,     0,   -14,    79,
      80,     0,     0,     0,   -14,     0,     0,     0,   -14,   -14,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
      74,    75,    76,     0,   -15,    77,     0,     0,   173,     0,
     -15,    79,    80,     0,     0,     0,   -15,     0,     0,     0,
     -15,   -15,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,    74,    75,    76,     0,   -32,    77,     0,     0,
     175,     0,   -32,    79,    80,     0,     0,     0,   -32,     0,
       0,     0,   -32,   -32,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,    74,    75,    76,     0,     0,    77,
       0,     0,   177,     0,     0,    79,    80,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,    74,    75,    76,     0,
       0,    77,     0,     0,   182,     0,     0,    79,    80,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    74,    75,
      76,     0,     0,    77,     0,     0,   185,     0,     0,    79,
      80,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
      74,    75,    76,     0,     0,    77,     0,     0,   246,     0,
       0,    79,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,   108,
     109,   110,    74,    75,    76,     0,     0,    77,     0,     0,
     247,     0,     0,    79,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,    74,    75,    76,     0,     0,    77,
       0,     0,   248,     0,     0,    79,    80,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,    74,    75,    76,     0,
       0,    77,     0,     0,   307,     0,     0,    79,    80,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,    74,    75,
      76,     0,     0,    77,     0,     0,   356,     0,     0,    79,
      80,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
      74,    75,    76,     0,   338,    77,     0,     0,     0,     0,
       0,    79,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   132,   133,   134,   135,    85,    86,   136,   137,
     138,   139,   140,   141,   142,    94,   143,   144,    97,    98,
      99,     0,   145,   146,   147,   148,   149,   150,   151,   108,
     109,   208,    74,    75,    76,     0,   433,    77,     0,     0,
       0,     0,     0,    79,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   132,   133,   134,   135,    85,    86,
     136,   137,   138,   139,   140,   141,   142,    94,   143,   144,
      97,    98,    99,     0,   145,   146,   147,   148,   149,   150,
     151,   108,   109,   208,    74,    75,    76,     0,     0,    77,
       0,     0,     0,     0,     0,    79,    80,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   132,   133,   134,   135,
      85,    86,   136,   137,   138,   139,   140,   141,   142,    94,
     143,   144,    97,    98,    99,     0,   145,   146,   147,   148,
     149,   150,   151,   108,   109,   208,    74,    75,    76,     0,
       0,    77,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   132,   133,
     134,   135,    85,    86,   136,   137,   138,   139,   140,   141,
     142,    94,   143,   144,    97,    98,    99,     0,   145,   146,
     147,   148,   149,   150,   151,   108,   109,   208,   131,     0,
       0,     0,     0,     0,     0,   305,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   132,
     133,   134,   135,    85,    86,   136,   137,   138,   139,   140,
     141,   142,    94,   143,   144,    97,    98,    99,     0,   145,
     146,   147,   148,   149,   150,   151,   108,   152,   153,   131,
       0,     0,     0,     0,     0,     0,   359,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     132,   133,   134,   135,    85,    86,   136,   137,   138,   139,
     140,   141,   142,    94,   143,   144,    97,    98,    99,     0,
     145,   146,   147,   148,   149,   150,   151,   108,   152,   153,
     131,     0,     0,     0,     0,     0,     0,   361,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   132,   133,   134,   135,    85,    86,   136,   137,   138,
     139,   140,   141,   142,    94,   143,   144,    97,    98,    99,
       0,   145,   146,   147,   148,   149,   150,   151,   108,   152,
     153,   131,     0,     0,     0,     0,     0,     0,   395,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   132,   133,   134,   135,    85,    86,   136,   137,
     138,   139,   140,   141,   142,    94,   143,   144,    97,    98,
      99,     0,   145,   146,   147,   148,   149,   150,   151,   108,
     152,   153,   131,     0,     0,     0,     0,     0,     0,   423,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   132,   133,   134,   135,    85,    86,   136,
     137,   138,   139,   140,   141,   142,    94,   143,   144,    97,
      98,    99,     0,   145,   146,   147,   148,   149,   150,   151,
     108,   152,   153,   131,     0,     0,     0,     0,     0,     0,
     424,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   132,   133,   134,   135,    85,    86,
     136,   137,   138,   139,   140,   141,   142,    94,   143,   144,
      97,    98,    99,   131,   145,   146,   147,   148,   149,   150,
     151,   108,   152,   153,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   132,   133,   134,   135,    85,    86,
     136,   137,   138,   139,   140,   141,   142,    94,   143,   144,
      97,    98,    99,     0,   145,   146,   147,   148,   149,   150,
     151,   108,   152,   153,   320,     0,     0,     0,     0,   189,
       0,     0,     0,     0,     0,   321,     0,     0,     0,     0,
       0,   128,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,   188,    15,    16,     0,     0,   189,
       0,   322,    22,    23,    24,    25,    26,    27,     0,   323,
      28,   128,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,   195,    15,    16,     0,     0,   189,
       0,     0,    22,    23,    24,    25,    26,    27,     0,   190,
      28,   128,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,   195,    15,    16,     0,     0,   189,
       0,     0,    22,    23,    24,    25,    26,    27,     0,   196,
      28,     1,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,   377,    15,    16,     0,     0,   189,
       0,     0,    22,    23,    24,    25,    26,    27,     0,   196,
      28,   378,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,     0,    15,    16,   251,     0,     0,
       0,     0,    22,    23,    24,    25,    26,    27,     0,   379,
      28,     1,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,     0,    15,    16,   282,     0,     0,
     252,   253,    22,    23,    24,    25,    26,    27,     0,     0,
      28,     1,     2,     3,     4,     0,     0,     7,     8,     9,
      10,    11,    12,    13,     0,    15,    16,     0,     0,     0,
     252,   253,    22,    23,    24,    25,    26,    27,   127,     0,
      28,     0,     0,   128,     2,     3,     4,     0,     0,     7,
       8,     9,    10,    11,    12,    13,     0,    15,    16,     0,
       0,     0,     0,   129,    22,    23,    24,    25,    26,    27,
       0,     0,    28,   132,   133,   134,   135,    85,    86,   136,
     137,   138,   139,   140,   141,   142,    94,   143,   144,    97,
      98,    99,     0,   145,   146,   147,   148,   149,   150,   151,
     108,   290,   291,     1,     2,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
       0,     0,    28,   128,     2,     3,     4,     0,     0,     7,
       8,     9,    10,    11,    12,    13,     0,    15,    16,     0,
       0,     0,     0,   220,    22,    23,    24,    25,    26,    27,
       0,     0,    28,   333,     2,     3,     4,     0,     0,     7,
       8,     9,    10,    11,    12,    13,     0,    15,    16,     0,
       0,     0,     0,     0,    22,    23,    24,    25,    26,    27,
       0,   334,    28,     1,     2,     3,     4,     0,     0,     7,
       8,     9,    10,    11,    12,    13,     0,    15,    16,     0,
       0,     0,     0,     0,    22,    23,    24,    25,    26,    27,
       0,     0,    28,   128,     2,     3,     4,     0,     0,     7,
       8,     9,    10,    11,    12,    13,     0,    15,    16,     0,
       0,     0,     0,     0,    22,    23,    24,    25,    26,    27,
     157,   158,    28,     0,     0,     0,     0,     0,   159,   160,
     161,   162,   163,     0,     0,     0,     0,     0,     0,     0,
       0,   164,     0,     0,   165,     0,     0,     0,     0,   166
};

static const yytype_int16 yycheck[] =
{
       0,    64,   129,   237,   213,   169,   195,   171,   116,    34,
      41,    36,   120,    38,    43,   123,    77,     8,   126,   167,
      20,    21,    68,    69,    71,    50,    51,   188,    53,    29,
     351,   393,    10,    64,    65,   377,    61,   278,    63,    20,
     281,     8,    13,     8,     8,     8,    13,     8,    13,    13,
      13,     8,    19,    23,    25,    10,   170,    10,   172,    11,
       6,    11,    53,    16,    19,   427,   174,    10,   176,    10,
     178,   413,    24,    16,    24,   239,   184,   311,    18,   187,
     314,   402,   271,    23,   115,    10,    53,   214,    53,    53,
      53,    10,    53,   220,    19,   243,    53,   245,    53,    54,
     100,   101,    10,   230,    10,   266,    25,    26,    11,   318,
      53,    54,    53,    54,    33,    34,    35,    36,    37,    53,
      54,    24,     6,    11,   358,   188,   189,    46,    12,   129,
      49,    11,   179,   180,    18,    54,    24,     6,    22,    23,
     169,    20,   171,    12,    24,    24,   387,   388,   312,    11,
     213,   315,    13,    22,   215,    10,    10,   204,   219,   206,
      10,    16,    24,   397,    25,   399,    53,    54,   295,    19,
      18,   232,   233,   234,   235,    10,    24,   418,   419,   420,
     421,   181,   213,   214,    18,    53,    54,    18,   217,     8,
      24,   254,   319,    24,    13,   322,    53,    54,    20,   230,
     308,   264,    24,   266,    10,    20,   267,   207,   237,    24,
     239,   272,    20,   238,    10,     6,    24,    10,   218,    10,
     220,    12,    20,   254,     6,    20,    24,    18,   274,   275,
      12,    22,    23,    20,   265,    20,    18,    24,    10,    24,
      22,    23,   369,    20,    20,    55,    56,    24,    24,   249,
     250,    10,   252,   253,    20,   318,    20,   320,    20,     6,
     321,    10,   293,    23,   295,    12,    23,   233,   234,   235,
      23,    18,    20,   336,    20,    22,    23,     6,   278,    79,
      80,   281,   311,   312,    17,   314,   315,   318,   319,   249,
     250,    17,     9,    20,   355,     9,   343,   344,    52,   345,
     346,     9,   348,   349,    10,   336,    17,    17,    17,   372,
      10,     6,   373,   374,   377,   376,    17,    12,     7,    24,
     351,    52,   322,    18,    21,    25,    26,    22,    23,   358,
     393,    52,    19,    33,    34,    35,    36,    37,   369,   400,
     401,     6,   389,   390,   391,   392,    46,     8,     7,    49,
     413,     7,     9,   414,    54,     8,     8,     6,     8,    10,
       6,     9,   393,     7,   427,    29,    12,     9,   397,    24,
     399,   402,    18,     9,    25,    26,    22,    23,     9,     7,
     116,   120,    33,    34,    35,    36,    37,   387,   388,   123,
     187,   126,   184,     6,   384,    46,   427,     0,    49,    12,
       6,   328,   320,    54,   372,    18,    12,    -1,   194,    22,
      23,   200,    18,    -1,    -1,    -1,    22,    23,   418,   419,
     420,   421,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,     6,
      -1,    54,     3,     4,     5,    12,     6,     8,    -1,    -1,
      11,    18,    12,    14,    15,    22,    23,    -1,    18,    -1,
      -1,    -1,    22,    23,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,     3,     4,     5,    -1,     6,     8,
      -1,    -1,    11,    -1,    12,    14,    15,    -1,    -1,    -1,
      18,    -1,    -1,    -1,    22,    23,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,     3,     4,     5,    -1,
       6,     8,    -1,    -1,    11,    -1,    12,    14,    15,    -1,
      -1,    -1,    18,    -1,    -1,    -1,    22,    23,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,     3,     4,
       5,    -1,     6,     8,    -1,    -1,    11,    -1,    12,    14,
      15,    -1,    -1,    -1,    18,    -1,    -1,    -1,    22,    23,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
       3,     4,     5,    -1,     6,     8,    -1,    -1,    11,    -1,
      12,    14,    15,    -1,    -1,    -1,    18,    -1,    -1,    -1,
      22,    23,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,     3,     4,     5,    -1,     6,     8,    -1,    -1,
      11,    -1,    12,    14,    15,    -1,    -1,    -1,    18,    -1,
      -1,    -1,    22,    23,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,     3,     4,     5,    -1,    -1,     8,
      -1,    -1,    11,    -1,    -1,    14,    15,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,     3,     4,     5,    -1,
      -1,     8,    -1,    -1,    11,    -1,    -1,    14,    15,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,     3,     4,
       5,    -1,    -1,     8,    -1,    -1,    11,    -1,    -1,    14,
      15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
       3,     4,     5,    -1,    -1,     8,    -1,    -1,    11,    -1,
      -1,    14,    15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,     3,     4,     5,    -1,    -1,     8,    -1,    -1,
      11,    -1,    -1,    14,    15,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,     3,     4,     5,    -1,    -1,     8,
      -1,    -1,    11,    -1,    -1,    14,    15,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,     3,     4,     5,    -1,
      -1,     8,    -1,    -1,    11,    -1,    -1,    14,    15,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,     3,     4,
       5,    -1,    -1,     8,    -1,    -1,    11,    -1,    -1,    14,
      15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
       3,     4,     5,    -1,     7,     8,    -1,    -1,    -1,    -1,
      -1,    14,    15,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,     3,     4,     5,    -1,     7,     8,    -1,    -1,
      -1,    -1,    -1,    14,    15,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,     3,     4,     5,    -1,    -1,     8,
      -1,    -1,    -1,    -1,    -1,    14,    15,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,     3,     4,     5,    -1,
      -1,     8,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,     4,    -1,
      -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,     4,
      -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,     4,    -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,     4,    -1,    -1,    -1,    -1,    -1,    -1,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,     4,    -1,    -1,    -1,    -1,    -1,    -1,
      11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,     4,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,     8,    -1,    -1,    -1,    -1,    13,
      -1,    -1,    -1,    -1,    -1,    19,    -1,    -1,    -1,    -1,
      -1,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,     8,    39,    40,    -1,    -1,    13,
      -1,    45,    46,    47,    48,    49,    50,    51,    -1,    53,
      54,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,     8,    39,    40,    -1,    -1,    13,
      -1,    -1,    46,    47,    48,    49,    50,    51,    -1,    53,
      54,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,     8,    39,    40,    -1,    -1,    13,
      -1,    -1,    46,    47,    48,    49,    50,    51,    -1,    53,
      54,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,     8,    39,    40,    -1,    -1,    13,
      -1,    -1,    46,    47,    48,    49,    50,    51,    -1,    53,
      54,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,    -1,    39,    40,    11,    -1,    -1,
      -1,    -1,    46,    47,    48,    49,    50,    51,    -1,    53,
      54,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,    -1,    39,    40,    11,    -1,    -1,
      44,    45,    46,    47,    48,    49,    50,    51,    -1,    -1,
      54,    25,    26,    27,    28,    -1,    -1,    31,    32,    33,
      34,    35,    36,    37,    -1,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    47,    48,    49,    50,    51,    20,    -1,
      54,    -1,    -1,    25,    26,    27,    28,    -1,    -1,    31,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      -1,    -1,    54,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      -1,    -1,    54,    25,    26,    27,    28,    -1,    -1,    31,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      -1,    -1,    54,    25,    26,    27,    28,    -1,    -1,    31,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    -1,
      -1,    -1,    -1,    -1,    46,    47,    48,    49,    50,    51,
      -1,    53,    54,    25,    26,    27,    28,    -1,    -1,    31,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    -1,
      -1,    -1,    -1,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    54,    25,    26,    27,    28,    -1,    -1,    31,
      32,    33,    34,    35,    36,    37,    -1,    39,    40,    -1,
      -1,    -1,    -1,    -1,    46,    47,    48,    49,    50,    51,
      25,    26,    54,    -1,    -1,    -1,    -1,    -1,    33,    34,
      35,    36,    37,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    -1,    -1,    -1,    -1,    54
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    54,    57,
      62,    63,    64,    66,    67,    69,    70,    72,    73,    75,
      78,    82,    85,    10,    19,    53,    54,    92,    10,    10,
      10,    10,    10,    10,    10,    53,    54,    86,    87,    10,
      10,    79,    10,    76,    82,    82,    10,    16,    53,    54,
      89,    90,     0,    62,     3,     4,     5,     8,    11,    14,
      15,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    58,    59,    60,    65,    82,   112,   113,    11,    68,
     112,    11,    71,   112,    11,    74,   112,    20,    25,    45,
      85,     4,    25,    26,    27,    28,    31,    32,    33,    34,
      35,    36,    37,    39,    40,    45,    46,    47,    48,    49,
      50,    51,    53,    54,    58,    98,    99,    25,    26,    33,
      34,    35,    36,    37,    46,    49,    54,    81,    84,    10,
      19,    10,    19,    11,   112,    11,   112,    11,   112,    87,
      87,    93,    11,    80,   112,    11,    77,   112,     8,    13,
      53,   100,   101,   102,   110,     8,    53,    83,   108,   109,
     110,    53,    54,    16,    90,    16,    90,    93,    54,    60,
      20,    59,    59,    82,    82,     6,    12,    22,    18,    23,
      45,    65,   113,    20,    20,    68,    20,    71,    20,    74,
      82,    83,    23,    23,    23,    23,    11,    24,    10,    10,
      25,    84,    98,    81,    98,    81,    11,    11,    11,    93,
      93,    11,    44,    45,    82,    88,    94,    20,    80,    20,
      77,   101,    25,   110,   111,    18,    24,     6,   102,   108,
      20,    24,     6,   109,    17,    17,    53,    54,    93,    53,
      54,    93,    11,    91,     9,   100,    83,    60,    53,    54,
      53,    54,    58,    82,    60,    82,    83,    20,    83,    20,
      60,    61,    61,    61,    61,    11,    99,    11,   112,    98,
      11,    24,    10,    11,    24,    10,    88,    88,    82,    82,
       8,    19,    45,    53,    96,    97,   106,   107,   110,    52,
       9,    25,   110,    25,    53,    85,    95,   101,     7,    60,
       9,   108,    60,    90,    90,    17,    17,    91,    17,    17,
      91,    18,     7,    83,    20,    21,    11,    11,    24,    11,
      98,    11,    98,    52,    52,   100,    83,   106,    60,    82,
      83,    20,    24,    19,     6,   107,     8,     8,    25,    53,
      85,   103,   104,   105,   110,     7,     7,    93,    93,    90,
      90,    90,    90,    95,    60,    11,    11,    24,    11,    24,
       8,     8,    18,    20,     9,    83,    20,    97,    60,    60,
      60,   104,    20,    24,     6,   105,    91,    91,    93,    93,
      93,    93,   103,    11,    11,    60,    60,    95,    20,     7,
       9,     9,   104,     7,    60,    91,    91,    91,    91,     9,
       9,   103,     7,    20
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    56,    57,    57,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    59,    59,    59,    59,    59,    59,    59,    59,    59,
      59,    59,    59,    59,    60,    60,    60,    61,    61,    62,
      62,    62,    62,    62,    62,    62,    62,    62,    62,    62,
      63,    63,    64,    65,    66,    66,    67,    68,    69,    69,
      70,    71,    72,    72,    73,    74,    75,    75,    76,    77,
      78,    78,    79,    80,    81,    81,    81,    81,    82,    82,
      82,    82,    83,    83,    84,    84,    84,    84,    84,    84,
      84,    84,    84,    84,    85,    85,    85,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    85,    85,    85,    85,
      85,    85,    85,    85,    85,    85,    85,    86,    86,    86,
      86,    86,    86,    86,    86,    87,    88,    89,    89,    89,
      89,    89,    89,    89,    89,    89,    89,    89,    89,    89,
      90,    91,    92,    92,    92,    92,    92,    92,    92,    92,
      92,    92,    92,    92,    92,    92,    93,    93,    94,    94,
      94,    94,    94,    95,    95,    95,    95,    95,    95,    96,
      96,    97,    97,    97,    98,    98,    99,    99,    99,    99,
      99,    99,    99,    99,   100,   100,   101,   101,   102,   102,
     102,   102,   102,   103,   103,   104,   104,   105,   105,   105,
     105,   106,   106,   107,   107,   107,   108,   108,   109,   109,
     109,   110,   110,   110,   111,   111,   112,   112,   113,   113,
     113,   113,   113,   113
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     4,     3,
       3,     3,     3,     3,     1,     2,     2,     3,     1,     2,
       1,     1,     1,     1,     1,     1,     5,     4,     4,     7,
       2,     3,     2,     2,     2,     3,     2,     2,     2,     3,
       2,     2,     2,     3,     2,     2,     3,     4,     1,     2,
       3,     4,     1,     2,     1,     1,     2,     2,     1,     1,
       2,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     4,     3,
       4,     1,     3,     4,     2,     2,     2,     3,     4,     4,
       1,     1,     7,     8,     8,     1,     1,     3,     6,     6,
       4,     7,     4,     7,     4,     4,     7,     4,     7,     4,
       1,     1,     3,     5,     4,     6,     4,     6,     4,     6,
       5,     7,     1,     5,     7,     1,     0,     2,     3,     5,
       4,     4,     7,     1,     1,     1,     2,     2,     2,     1,
       3,     1,     2,     3,     1,     3,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     0,     1,
       3,     4,     3,     1,     3,     1,     2,     0,     3,     4,
       3,     1,     2,     1,     3,     4,     1,     2,     1,     3,
       4,     1,     2,     3,     1,     2,     2,     3,     3,     3,
       4,     3,     3,     6
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct ctf_scanner *scanner, yyscan_t yyscanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  YY_USE (yyscanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct ctf_scanner *scanner, yyscan_t yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, struct ctf_scanner *scanner, yyscan_t yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner, yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, struct ctf_scanner *scanner, yyscan_t yyscanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  YY_USE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct ctf_scanner *scanner, yyscan_t yyscanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* file: declaration  */
#line 1116 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			if (set_parent_node((yyvsp[0].n), &ctf_scanner_get_ast(scanner)->root))
				reparent_error(scanner, "error reparenting to root");
		}
#line 3326 "ctf-parser.c"
    break;

  case 3: /* file: file declaration  */
#line 1121 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			if (set_parent_node((yyvsp[0].n), &ctf_scanner_get_ast(scanner)->root))
				reparent_error(scanner, "error reparenting to root");
		}
#line 3335 "ctf-parser.c"
    break;

  case 4: /* keywords: VOID  */
#line 1129 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3341 "ctf-parser.c"
    break;

  case 5: /* keywords: CHAR  */
#line 1131 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3347 "ctf-parser.c"
    break;

  case 6: /* keywords: SHORT  */
#line 1133 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3353 "ctf-parser.c"
    break;

  case 7: /* keywords: INT  */
#line 1135 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3359 "ctf-parser.c"
    break;

  case 8: /* keywords: LONG  */
#line 1137 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3365 "ctf-parser.c"
    break;

  case 9: /* keywords: FLOAT  */
#line 1139 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3371 "ctf-parser.c"
    break;

  case 10: /* keywords: DOUBLE  */
#line 1141 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3377 "ctf-parser.c"
    break;

  case 11: /* keywords: SIGNED  */
#line 1143 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3383 "ctf-parser.c"
    break;

  case 12: /* keywords: UNSIGNED  */
#line 1145 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3389 "ctf-parser.c"
    break;

  case 13: /* keywords: _BOOL  */
#line 1147 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3395 "ctf-parser.c"
    break;

  case 14: /* keywords: _COMPLEX  */
#line 1149 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3401 "ctf-parser.c"
    break;

  case 15: /* keywords: _IMAGINARY  */
#line 1151 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3407 "ctf-parser.c"
    break;

  case 16: /* keywords: FLOATING_POINT  */
#line 1153 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3413 "ctf-parser.c"
    break;

  case 17: /* keywords: INTEGER  */
#line 1155 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3419 "ctf-parser.c"
    break;

  case 18: /* keywords: STRING  */
#line 1157 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3425 "ctf-parser.c"
    break;

  case 19: /* keywords: ENUM  */
#line 1159 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3431 "ctf-parser.c"
    break;

  case 20: /* keywords: VARIANT  */
#line 1161 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3437 "ctf-parser.c"
    break;

  case 21: /* keywords: STRUCT  */
#line 1163 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3443 "ctf-parser.c"
    break;

  case 22: /* keywords: CONST  */
#line 1165 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3449 "ctf-parser.c"
    break;

  case 23: /* keywords: TYPEDEF  */
#line 1167 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3455 "ctf-parser.c"
    break;

  case 24: /* keywords: EVENT  */
#line 1169 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3461 "ctf-parser.c"
    break;

  case 25: /* keywords: STREAM  */
#line 1171 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3467 "ctf-parser.c"
    break;

  case 26: /* keywords: ENV  */
#line 1173 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3473 "ctf-parser.c"
    break;

  case 27: /* keywords: TRACE  */
#line 1175 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3479 "ctf-parser.c"
    break;

  case 28: /* keywords: CLOCK  */
#line 1177 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3485 "ctf-parser.c"
    break;

  case 29: /* keywords: CALLSITE  */
#line 1179 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3491 "ctf-parser.c"
    break;

  case 30: /* keywords: TOK_ALIGN  */
#line 1181 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.s) = yylval.s;		}
#line 3497 "ctf-parser.c"
    break;

  case 31: /* postfix_expression: IDENTIFIER  */
#line 1189 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
		}
#line 3507 "ctf-parser.c"
    break;

  case 32: /* postfix_expression: ID_TYPE  */
#line 1195 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
		}
#line 3517 "ctf-parser.c"
    break;

  case 33: /* postfix_expression: keywords  */
#line 1201 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
		}
#line 3527 "ctf-parser.c"
    break;

  case 34: /* postfix_expression: INTEGER_LITERAL  */
#line 1207 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_UNSIGNED_CONSTANT;
			(yyval.n)->u.unary_expression.u.unsigned_constant = (yyvsp[0].ull);
		}
#line 3537 "ctf-parser.c"
    break;

  case 35: /* postfix_expression: STRING_LITERAL  */
#line 1213 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = (yyvsp[0].s);
		}
#line 3547 "ctf-parser.c"
    break;

  case 36: /* postfix_expression: CHARACTER_LITERAL  */
#line 1219 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = (yyvsp[0].s);
		}
#line 3557 "ctf-parser.c"
    break;

  case 37: /* postfix_expression: LPAREN unary_expression RPAREN  */
#line 1225 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-1].n);
		}
#line 3565 "ctf-parser.c"
    break;

  case 38: /* postfix_expression: postfix_expression LSBRAC unary_expression RSBRAC  */
#line 1229 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_SBRAC;
			(yyval.n)->u.unary_expression.u.sbrac_exp = (yyvsp[-1].n);
			bt_list_splice(&((yyvsp[-3].n))->tmp_head, &((yyval.n))->tmp_head);
			bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
#line 3577 "ctf-parser.c"
    break;

  case 39: /* postfix_expression: postfix_expression DOT IDENTIFIER  */
#line 1237 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
			(yyval.n)->u.unary_expression.link = UNARY_DOTLINK;
			bt_list_splice(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->tmp_head);
			bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
#line 3590 "ctf-parser.c"
    break;

  case 40: /* postfix_expression: postfix_expression DOT ID_TYPE  */
#line 1246 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
			(yyval.n)->u.unary_expression.link = UNARY_DOTLINK;
			bt_list_splice(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->tmp_head);
			bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
#line 3603 "ctf-parser.c"
    break;

  case 41: /* postfix_expression: postfix_expression DOT keywords  */
#line 1255 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
			(yyval.n)->u.unary_expression.link = UNARY_DOTLINK;
			bt_list_splice(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->tmp_head);
			bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
#line 3616 "ctf-parser.c"
    break;

  case 42: /* postfix_expression: postfix_expression RARROW IDENTIFIER  */
#line 1264 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
			(yyval.n)->u.unary_expression.link = UNARY_ARROWLINK;
			bt_list_splice(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->tmp_head);
			bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
#line 3629 "ctf-parser.c"
    break;

  case 43: /* postfix_expression: postfix_expression RARROW ID_TYPE  */
#line 1273 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_UNARY_EXPRESSION);
			(yyval.n)->u.unary_expression.type = UNARY_STRING;
			(yyval.n)->u.unary_expression.u.string = yylval.s;
			(yyval.n)->u.unary_expression.link = UNARY_ARROWLINK;
			bt_list_splice(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->tmp_head);
			bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
		}
#line 3642 "ctf-parser.c"
    break;

  case 44: /* unary_expression: postfix_expression  */
#line 1285 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);				}
#line 3648 "ctf-parser.c"
    break;

  case 45: /* unary_expression: PLUS postfix_expression  */
#line 1287 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[0].n);
			if ((yyval.n)->u.unary_expression.type != UNARY_UNSIGNED_CONSTANT
				&& (yyval.n)->u.unary_expression.type != UNARY_SIGNED_CONSTANT) {
				reparent_error(scanner, "expecting numeric constant");
			}
		}
#line 3660 "ctf-parser.c"
    break;

  case 46: /* unary_expression: MINUS postfix_expression  */
#line 1295 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[0].n);
			if ((yyval.n)->u.unary_expression.type == UNARY_UNSIGNED_CONSTANT) {
				(yyval.n)->u.unary_expression.type = UNARY_SIGNED_CONSTANT;
				(yyval.n)->u.unary_expression.u.signed_constant =
					-((yyval.n)->u.unary_expression.u.unsigned_constant);
			} else if ((yyval.n)->u.unary_expression.type == UNARY_UNSIGNED_CONSTANT) {
				(yyval.n)->u.unary_expression.u.signed_constant =
					-((yyval.n)->u.unary_expression.u.signed_constant);
			} else {
				reparent_error(scanner, "expecting numeric constant");
			}
		}
#line 3678 "ctf-parser.c"
    break;

  case 47: /* unary_expression_or_range: unary_expression DOTDOTDOT unary_expression  */
#line 1312 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			_bt_list_splice_tail(&((yyvsp[0].n))->tmp_head, &((yyval.n))->tmp_head);
			(yyvsp[0].n)->u.unary_expression.link = UNARY_DOTDOTDOT;
		}
#line 3688 "ctf-parser.c"
    break;

  case 48: /* unary_expression_or_range: unary_expression  */
#line 1318 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);		}
#line 3694 "ctf-parser.c"
    break;

  case 49: /* declaration: declaration_specifiers SEMICOLON  */
#line 1325 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[-1].n);	}
#line 3700 "ctf-parser.c"
    break;

  case 50: /* declaration: event_declaration  */
#line 1327 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 3706 "ctf-parser.c"
    break;

  case 51: /* declaration: stream_declaration  */
#line 1329 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 3712 "ctf-parser.c"
    break;

  case 52: /* declaration: env_declaration  */
#line 1331 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 3718 "ctf-parser.c"
    break;

  case 53: /* declaration: trace_declaration  */
#line 1333 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 3724 "ctf-parser.c"
    break;

  case 54: /* declaration: clock_declaration  */
#line 1335 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 3730 "ctf-parser.c"
    break;

  case 55: /* declaration: callsite_declaration  */
#line 1337 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 3736 "ctf-parser.c"
    break;

  case 56: /* declaration: declaration_specifiers TYPEDEF declaration_specifiers type_declarator_list SEMICOLON  */
#line 1339 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-4].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 3751 "ctf-parser.c"
    break;

  case 57: /* declaration: TYPEDEF declaration_specifiers type_declarator_list SEMICOLON  */
#line 1350 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 3765 "ctf-parser.c"
    break;

  case 58: /* declaration: declaration_specifiers TYPEDEF type_declarator_list SEMICOLON  */
#line 1360 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-3].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 3779 "ctf-parser.c"
    break;

  case 59: /* declaration: TYPEALIAS declaration_specifiers abstract_declarator_list TYPEASSIGN alias_declaration_specifiers alias_abstract_declarator_list SEMICOLON  */
#line 1370 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEALIAS);
			(yyval.n)->u.typealias.target = make_node(scanner, NODE_TYPEALIAS_TARGET);
			(yyval.n)->u.typealias.alias = make_node(scanner, NODE_TYPEALIAS_ALIAS);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.target->u.typealias_target.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-5].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-4].n))->tmp_head, &((yyval.n))->u.typealias.target->u.typealias_target.type_declarators);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.alias->u.typealias_alias.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.typealias.alias->u.typealias_alias.type_declarators);
		}
#line 3801 "ctf-parser.c"
    break;

  case 60: /* event_declaration: event_declaration_begin event_declaration_end  */
#line 1391 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_EVENT);
		}
#line 3809 "ctf-parser.c"
    break;

  case 61: /* event_declaration: event_declaration_begin ctf_assignment_expression_list event_declaration_end  */
#line 1395 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_EVENT);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "event_declaration");
		}
#line 3819 "ctf-parser.c"
    break;

  case 62: /* event_declaration_begin: EVENT LBRAC  */
#line 1404 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 3825 "ctf-parser.c"
    break;

  case 63: /* event_declaration_end: RBRAC SEMICOLON  */
#line 1409 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 3831 "ctf-parser.c"
    break;

  case 64: /* stream_declaration: stream_declaration_begin stream_declaration_end  */
#line 1415 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STREAM);
		}
#line 3839 "ctf-parser.c"
    break;

  case 65: /* stream_declaration: stream_declaration_begin ctf_assignment_expression_list stream_declaration_end  */
#line 1419 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STREAM);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "stream_declaration");
		}
#line 3849 "ctf-parser.c"
    break;

  case 66: /* stream_declaration_begin: STREAM LBRAC  */
#line 1428 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 3855 "ctf-parser.c"
    break;

  case 67: /* stream_declaration_end: RBRAC SEMICOLON  */
#line 1433 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 3861 "ctf-parser.c"
    break;

  case 68: /* env_declaration: env_declaration_begin env_declaration_end  */
#line 1438 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENV);
		}
#line 3869 "ctf-parser.c"
    break;

  case 69: /* env_declaration: env_declaration_begin ctf_assignment_expression_list env_declaration_end  */
#line 1442 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENV);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "env declaration");
		}
#line 3879 "ctf-parser.c"
    break;

  case 70: /* env_declaration_begin: ENV LBRAC  */
#line 1451 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 3885 "ctf-parser.c"
    break;

  case 71: /* env_declaration_end: RBRAC SEMICOLON  */
#line 1456 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 3891 "ctf-parser.c"
    break;

  case 72: /* trace_declaration: trace_declaration_begin trace_declaration_end  */
#line 1461 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TRACE);
		}
#line 3899 "ctf-parser.c"
    break;

  case 73: /* trace_declaration: trace_declaration_begin ctf_assignment_expression_list trace_declaration_end  */
#line 1465 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TRACE);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "trace_declaration");
		}
#line 3909 "ctf-parser.c"
    break;

  case 74: /* trace_declaration_begin: TRACE LBRAC  */
#line 1474 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 3915 "ctf-parser.c"
    break;

  case 75: /* trace_declaration_end: RBRAC SEMICOLON  */
#line 1479 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 3921 "ctf-parser.c"
    break;

  case 76: /* clock_declaration: CLOCK clock_declaration_begin clock_declaration_end  */
#line 1484 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_CLOCK);
		}
#line 3929 "ctf-parser.c"
    break;

  case 77: /* clock_declaration: CLOCK clock_declaration_begin ctf_assignment_expression_list clock_declaration_end  */
#line 1488 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_CLOCK);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "trace_declaration");
		}
#line 3939 "ctf-parser.c"
    break;

  case 78: /* clock_declaration_begin: LBRAC  */
#line 1497 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 3945 "ctf-parser.c"
    break;

  case 79: /* clock_declaration_end: RBRAC SEMICOLON  */
#line 1502 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 3951 "ctf-parser.c"
    break;

  case 80: /* callsite_declaration: CALLSITE callsite_declaration_begin callsite_declaration_end  */
#line 1507 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_CALLSITE);
		}
#line 3959 "ctf-parser.c"
    break;

  case 81: /* callsite_declaration: CALLSITE callsite_declaration_begin ctf_assignment_expression_list callsite_declaration_end  */
#line 1511 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_CALLSITE);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "trace_declaration");
		}
#line 3969 "ctf-parser.c"
    break;

  case 82: /* callsite_declaration_begin: LBRAC  */
#line 1520 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 3975 "ctf-parser.c"
    break;

  case 83: /* callsite_declaration_end: RBRAC SEMICOLON  */
#line 1525 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 3981 "ctf-parser.c"
    break;

  case 84: /* integer_declaration_specifiers: CONST  */
#line 1530 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 3994 "ctf-parser.c"
    break;

  case 85: /* integer_declaration_specifiers: integer_type_specifier  */
#line 1539 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = (yyvsp[0].n);
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4006 "ctf-parser.c"
    break;

  case 86: /* integer_declaration_specifiers: integer_declaration_specifiers CONST  */
#line 1547 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = (yyvsp[-1].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4019 "ctf-parser.c"
    break;

  case 87: /* integer_declaration_specifiers: integer_declaration_specifiers integer_type_specifier  */
#line 1556 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-1].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4028 "ctf-parser.c"
    break;

  case 88: /* declaration_specifiers: CONST  */
#line 1564 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4041 "ctf-parser.c"
    break;

  case 89: /* declaration_specifiers: type_specifier  */
#line 1573 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = (yyvsp[0].n);
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4053 "ctf-parser.c"
    break;

  case 90: /* declaration_specifiers: declaration_specifiers CONST  */
#line 1581 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = (yyvsp[-1].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4066 "ctf-parser.c"
    break;

  case 91: /* declaration_specifiers: declaration_specifiers type_specifier  */
#line 1590 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-1].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4075 "ctf-parser.c"
    break;

  case 92: /* type_declarator_list: type_declarator  */
#line 1598 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 4081 "ctf-parser.c"
    break;

  case 93: /* type_declarator_list: type_declarator_list COMMA type_declarator  */
#line 1600 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->tmp_head);
		}
#line 4090 "ctf-parser.c"
    break;

  case 94: /* integer_type_specifier: CHAR  */
#line 1608 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_CHAR;
		}
#line 4099 "ctf-parser.c"
    break;

  case 95: /* integer_type_specifier: SHORT  */
#line 1613 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SHORT;
		}
#line 4108 "ctf-parser.c"
    break;

  case 96: /* integer_type_specifier: INT  */
#line 1618 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INT;
		}
#line 4117 "ctf-parser.c"
    break;

  case 97: /* integer_type_specifier: LONG  */
#line 1623 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_LONG;
		}
#line 4126 "ctf-parser.c"
    break;

  case 98: /* integer_type_specifier: SIGNED  */
#line 1628 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SIGNED;
		}
#line 4135 "ctf-parser.c"
    break;

  case 99: /* integer_type_specifier: UNSIGNED  */
#line 1633 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_UNSIGNED;
		}
#line 4144 "ctf-parser.c"
    break;

  case 100: /* integer_type_specifier: _BOOL  */
#line 1638 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_BOOL;
		}
#line 4153 "ctf-parser.c"
    break;

  case 101: /* integer_type_specifier: ID_TYPE  */
#line 1643 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_ID_TYPE;
			(yyval.n)->u.type_specifier.id_type = yylval.s;
		}
#line 4163 "ctf-parser.c"
    break;

  case 102: /* integer_type_specifier: INTEGER LBRAC RBRAC  */
#line 1649 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
		}
#line 4173 "ctf-parser.c"
    break;

  case 103: /* integer_type_specifier: INTEGER LBRAC ctf_assignment_expression_list RBRAC  */
#line 1655 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "integer reparent error");
		}
#line 4185 "ctf-parser.c"
    break;

  case 104: /* type_specifier: VOID  */
#line 1666 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_VOID;
		}
#line 4194 "ctf-parser.c"
    break;

  case 105: /* type_specifier: CHAR  */
#line 1671 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_CHAR;
		}
#line 4203 "ctf-parser.c"
    break;

  case 106: /* type_specifier: SHORT  */
#line 1676 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SHORT;
		}
#line 4212 "ctf-parser.c"
    break;

  case 107: /* type_specifier: INT  */
#line 1681 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INT;
		}
#line 4221 "ctf-parser.c"
    break;

  case 108: /* type_specifier: LONG  */
#line 1686 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_LONG;
		}
#line 4230 "ctf-parser.c"
    break;

  case 109: /* type_specifier: FLOAT  */
#line 1691 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_FLOAT;
		}
#line 4239 "ctf-parser.c"
    break;

  case 110: /* type_specifier: DOUBLE  */
#line 1696 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_DOUBLE;
		}
#line 4248 "ctf-parser.c"
    break;

  case 111: /* type_specifier: SIGNED  */
#line 1701 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_SIGNED;
		}
#line 4257 "ctf-parser.c"
    break;

  case 112: /* type_specifier: UNSIGNED  */
#line 1706 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_UNSIGNED;
		}
#line 4266 "ctf-parser.c"
    break;

  case 113: /* type_specifier: _BOOL  */
#line 1711 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_BOOL;
		}
#line 4275 "ctf-parser.c"
    break;

  case 114: /* type_specifier: _COMPLEX  */
#line 1716 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_COMPLEX;
		}
#line 4284 "ctf-parser.c"
    break;

  case 115: /* type_specifier: _IMAGINARY  */
#line 1721 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_IMAGINARY;
		}
#line 4293 "ctf-parser.c"
    break;

  case 116: /* type_specifier: ID_TYPE  */
#line 1726 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_ID_TYPE;
			(yyval.n)->u.type_specifier.id_type = yylval.s;
		}
#line 4303 "ctf-parser.c"
    break;

  case 117: /* type_specifier: FLOATING_POINT LBRAC RBRAC  */
#line 1732 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_FLOATING_POINT;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_FLOATING_POINT);
		}
#line 4313 "ctf-parser.c"
    break;

  case 118: /* type_specifier: FLOATING_POINT LBRAC ctf_assignment_expression_list RBRAC  */
#line 1738 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_FLOATING_POINT;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_FLOATING_POINT);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "floating point reparent error");
		}
#line 4325 "ctf-parser.c"
    break;

  case 119: /* type_specifier: INTEGER LBRAC RBRAC  */
#line 1746 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
		}
#line 4335 "ctf-parser.c"
    break;

  case 120: /* type_specifier: INTEGER LBRAC ctf_assignment_expression_list RBRAC  */
#line 1752 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_INTEGER;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_INTEGER);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "integer reparent error");
		}
#line 4347 "ctf-parser.c"
    break;

  case 121: /* type_specifier: STRING  */
#line 1760 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRING;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_STRING);
		}
#line 4357 "ctf-parser.c"
    break;

  case 122: /* type_specifier: STRING LBRAC RBRAC  */
#line 1766 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRING;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_STRING);
		}
#line 4367 "ctf-parser.c"
    break;

  case 123: /* type_specifier: STRING LBRAC ctf_assignment_expression_list RBRAC  */
#line 1772 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRING;
			(yyval.n)->u.type_specifier.node = make_node(scanner, NODE_STRING);
			if (set_parent_node((yyvsp[-1].n), (yyval.n)->u.type_specifier.node))
				reparent_error(scanner, "string reparent error");
		}
#line 4379 "ctf-parser.c"
    break;

  case 124: /* type_specifier: ENUM enum_type_specifier  */
#line 1780 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_ENUM;
			(yyval.n)->u.type_specifier.node = (yyvsp[0].n);
		}
#line 4389 "ctf-parser.c"
    break;

  case 125: /* type_specifier: VARIANT variant_type_specifier  */
#line 1786 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_VARIANT;
			(yyval.n)->u.type_specifier.node = (yyvsp[0].n);
		}
#line 4399 "ctf-parser.c"
    break;

  case 126: /* type_specifier: STRUCT struct_type_specifier  */
#line 1792 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER);
			(yyval.n)->u.type_specifier.type = TYPESPEC_STRUCT;
			(yyval.n)->u.type_specifier.node = (yyvsp[0].n);
		}
#line 4409 "ctf-parser.c"
    break;

  case 127: /* struct_type_specifier: struct_declaration_begin struct_or_variant_declaration_list struct_declaration_end  */
#line 1801 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
#line 4420 "ctf-parser.c"
    break;

  case 128: /* struct_type_specifier: IDENTIFIER struct_declaration_begin struct_or_variant_declaration_list struct_declaration_end  */
#line 1808 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[-3].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
#line 4432 "ctf-parser.c"
    break;

  case 129: /* struct_type_specifier: ID_TYPE struct_declaration_begin struct_or_variant_declaration_list struct_declaration_end  */
#line 1816 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[-3].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
#line 4444 "ctf-parser.c"
    break;

  case 130: /* struct_type_specifier: IDENTIFIER  */
#line 1824 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 0;
			(yyval.n)->u._struct.name = (yyvsp[0].s);
		}
#line 4454 "ctf-parser.c"
    break;

  case 131: /* struct_type_specifier: ID_TYPE  */
#line 1830 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 0;
			(yyval.n)->u._struct.name = (yyvsp[0].s);
		}
#line 4464 "ctf-parser.c"
    break;

  case 132: /* struct_type_specifier: struct_declaration_begin struct_or_variant_declaration_list struct_declaration_end TOK_ALIGN LPAREN unary_expression RPAREN  */
#line 1836 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			bt_list_add_tail(&((yyvsp[-1].n))->siblings, &(yyval.n)->u._struct.min_align);
			if ((yyvsp[-5].n) && set_parent_node((yyvsp[-5].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
#line 4476 "ctf-parser.c"
    break;

  case 133: /* struct_type_specifier: IDENTIFIER struct_declaration_begin struct_or_variant_declaration_list struct_declaration_end TOK_ALIGN LPAREN unary_expression RPAREN  */
#line 1844 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[-7].s);
			bt_list_add_tail(&((yyvsp[-1].n))->siblings, &(yyval.n)->u._struct.min_align);
			if ((yyvsp[-5].n) && set_parent_node((yyvsp[-5].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
#line 4489 "ctf-parser.c"
    break;

  case 134: /* struct_type_specifier: ID_TYPE struct_declaration_begin struct_or_variant_declaration_list struct_declaration_end TOK_ALIGN LPAREN unary_expression RPAREN  */
#line 1853 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_STRUCT);
			(yyval.n)->u._struct.has_body = 1;
			(yyval.n)->u._struct.name = (yyvsp[-7].s);
			bt_list_add_tail(&((yyvsp[-1].n))->siblings, &(yyval.n)->u._struct.min_align);
			if ((yyvsp[-5].n) && set_parent_node((yyvsp[-5].n), (yyval.n)))
				reparent_error(scanner, "struct reparent error");
		}
#line 4502 "ctf-parser.c"
    break;

  case 135: /* struct_declaration_begin: LBRAC  */
#line 1865 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 4508 "ctf-parser.c"
    break;

  case 136: /* struct_declaration_end: RBRAC  */
#line 1870 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 4514 "ctf-parser.c"
    break;

  case 137: /* variant_type_specifier: variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1875 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4525 "ctf-parser.c"
    break;

  case 138: /* variant_type_specifier: LT IDENTIFIER GT variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1882 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.choice = (yyvsp[-4].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4537 "ctf-parser.c"
    break;

  case 139: /* variant_type_specifier: LT ID_TYPE GT variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1890 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.choice = (yyvsp[-4].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4549 "ctf-parser.c"
    break;

  case 140: /* variant_type_specifier: IDENTIFIER variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1898 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[-3].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4561 "ctf-parser.c"
    break;

  case 141: /* variant_type_specifier: IDENTIFIER LT IDENTIFIER GT variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1906 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[-6].s);
			(yyval.n)->u.variant.choice = (yyvsp[-4].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4574 "ctf-parser.c"
    break;

  case 142: /* variant_type_specifier: IDENTIFIER LT IDENTIFIER GT  */
#line 1915 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[-3].s);
			(yyval.n)->u.variant.choice = (yyvsp[-1].s);
		}
#line 4585 "ctf-parser.c"
    break;

  case 143: /* variant_type_specifier: IDENTIFIER LT ID_TYPE GT variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1922 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[-6].s);
			(yyval.n)->u.variant.choice = (yyvsp[-4].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4598 "ctf-parser.c"
    break;

  case 144: /* variant_type_specifier: IDENTIFIER LT ID_TYPE GT  */
#line 1931 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[-3].s);
			(yyval.n)->u.variant.choice = (yyvsp[-1].s);
		}
#line 4609 "ctf-parser.c"
    break;

  case 145: /* variant_type_specifier: ID_TYPE variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1938 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[-3].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4621 "ctf-parser.c"
    break;

  case 146: /* variant_type_specifier: ID_TYPE LT IDENTIFIER GT variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1946 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[-6].s);
			(yyval.n)->u.variant.choice = (yyvsp[-4].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4634 "ctf-parser.c"
    break;

  case 147: /* variant_type_specifier: ID_TYPE LT IDENTIFIER GT  */
#line 1955 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[-3].s);
			(yyval.n)->u.variant.choice = (yyvsp[-1].s);
		}
#line 4645 "ctf-parser.c"
    break;

  case 148: /* variant_type_specifier: ID_TYPE LT ID_TYPE GT variant_declaration_begin struct_or_variant_declaration_list variant_declaration_end  */
#line 1962 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 1;
			(yyval.n)->u.variant.name = (yyvsp[-6].s);
			(yyval.n)->u.variant.choice = (yyvsp[-4].s);
			if ((yyvsp[-1].n) && set_parent_node((yyvsp[-1].n), (yyval.n)))
				reparent_error(scanner, "variant reparent error");
		}
#line 4658 "ctf-parser.c"
    break;

  case 149: /* variant_type_specifier: ID_TYPE LT ID_TYPE GT  */
#line 1971 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_VARIANT);
			(yyval.n)->u.variant.has_body = 0;
			(yyval.n)->u.variant.name = (yyvsp[-3].s);
			(yyval.n)->u.variant.choice = (yyvsp[-1].s);
		}
#line 4669 "ctf-parser.c"
    break;

  case 150: /* variant_declaration_begin: LBRAC  */
#line 1981 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	push_scope(scanner);	}
#line 4675 "ctf-parser.c"
    break;

  case 151: /* variant_declaration_end: RBRAC  */
#line 1986 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	pop_scope(scanner);	}
#line 4681 "ctf-parser.c"
    break;

  case 152: /* enum_type_specifier: LBRAC enumerator_list RBRAC  */
#line 1991 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4691 "ctf-parser.c"
    break;

  case 153: /* enum_type_specifier: COLON integer_declaration_specifiers LBRAC enumerator_list RBRAC  */
#line 1997 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			((yyval.n))->u._enum.container_type = (yyvsp[-3].n);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4702 "ctf-parser.c"
    break;

  case 154: /* enum_type_specifier: IDENTIFIER LBRAC enumerator_list RBRAC  */
#line 2004 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-3].s);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4713 "ctf-parser.c"
    break;

  case 155: /* enum_type_specifier: IDENTIFIER COLON integer_declaration_specifiers LBRAC enumerator_list RBRAC  */
#line 2011 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-5].s);
			((yyval.n))->u._enum.container_type = (yyvsp[-3].n);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4725 "ctf-parser.c"
    break;

  case 156: /* enum_type_specifier: ID_TYPE LBRAC enumerator_list RBRAC  */
#line 2019 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-3].s);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4736 "ctf-parser.c"
    break;

  case 157: /* enum_type_specifier: ID_TYPE COLON integer_declaration_specifiers LBRAC enumerator_list RBRAC  */
#line 2026 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-5].s);
			((yyval.n))->u._enum.container_type = (yyvsp[-3].n);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4748 "ctf-parser.c"
    break;

  case 158: /* enum_type_specifier: LBRAC enumerator_list COMMA RBRAC  */
#line 2034 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4758 "ctf-parser.c"
    break;

  case 159: /* enum_type_specifier: COLON integer_declaration_specifiers LBRAC enumerator_list COMMA RBRAC  */
#line 2040 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			((yyval.n))->u._enum.container_type = (yyvsp[-4].n);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4769 "ctf-parser.c"
    break;

  case 160: /* enum_type_specifier: IDENTIFIER LBRAC enumerator_list COMMA RBRAC  */
#line 2047 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-4].s);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4780 "ctf-parser.c"
    break;

  case 161: /* enum_type_specifier: IDENTIFIER COLON integer_declaration_specifiers LBRAC enumerator_list COMMA RBRAC  */
#line 2054 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-6].s);
			((yyval.n))->u._enum.container_type = (yyvsp[-4].n);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4792 "ctf-parser.c"
    break;

  case 162: /* enum_type_specifier: IDENTIFIER  */
#line 2062 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 0;
			(yyval.n)->u._enum.enum_id = (yyvsp[0].s);
		}
#line 4802 "ctf-parser.c"
    break;

  case 163: /* enum_type_specifier: ID_TYPE LBRAC enumerator_list COMMA RBRAC  */
#line 2068 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-4].s);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4813 "ctf-parser.c"
    break;

  case 164: /* enum_type_specifier: ID_TYPE COLON integer_declaration_specifiers LBRAC enumerator_list COMMA RBRAC  */
#line 2075 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 1;
			(yyval.n)->u._enum.enum_id = (yyvsp[-6].s);
			((yyval.n))->u._enum.container_type = (yyvsp[-4].n);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u._enum.enumerator_list);
		}
#line 4825 "ctf-parser.c"
    break;

  case 165: /* enum_type_specifier: ID_TYPE  */
#line 2083 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUM);
			(yyval.n)->u._enum.has_body = 0;
			(yyval.n)->u._enum.enum_id = (yyvsp[0].s);
		}
#line 4835 "ctf-parser.c"
    break;

  case 166: /* struct_or_variant_declaration_list: %empty  */
#line 2092 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = NULL;	}
#line 4841 "ctf-parser.c"
    break;

  case 167: /* struct_or_variant_declaration_list: struct_or_variant_declaration_list struct_or_variant_declaration  */
#line 2094 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			if ((yyvsp[-1].n)) {
				(yyval.n) = (yyvsp[-1].n);
				bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->tmp_head);
			} else {
				(yyval.n) = (yyvsp[0].n);
				bt_list_add_tail(&((yyval.n))->siblings, &((yyval.n))->tmp_head);
			}
		}
#line 4855 "ctf-parser.c"
    break;

  case 168: /* struct_or_variant_declaration: declaration_specifiers struct_or_variant_declarator_list SEMICOLON  */
#line 2107 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_STRUCT_OR_VARIANT_DECLARATION);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.struct_or_variant_declaration.type_declarators);
		}
#line 4869 "ctf-parser.c"
    break;

  case 169: /* struct_or_variant_declaration: declaration_specifiers TYPEDEF declaration_specifiers type_declarator_list SEMICOLON  */
#line 2117 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-4].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 4884 "ctf-parser.c"
    break;

  case 170: /* struct_or_variant_declaration: TYPEDEF declaration_specifiers type_declarator_list SEMICOLON  */
#line 2128 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 4898 "ctf-parser.c"
    break;

  case 171: /* struct_or_variant_declaration: declaration_specifiers TYPEDEF type_declarator_list SEMICOLON  */
#line 2138 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_bt_list_splice_tail(&((yyvsp[-3].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 4912 "ctf-parser.c"
    break;

  case 172: /* struct_or_variant_declaration: TYPEALIAS declaration_specifiers abstract_declarator_list TYPEASSIGN alias_declaration_specifiers alias_abstract_declarator_list SEMICOLON  */
#line 2148 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEALIAS);
			(yyval.n)->u.typealias.target = make_node(scanner, NODE_TYPEALIAS_TARGET);
			(yyval.n)->u.typealias.alias = make_node(scanner, NODE_TYPEALIAS_ALIAS);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.target->u.typealias_target.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-5].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-4].n))->tmp_head, &((yyval.n))->u.typealias.target->u.typealias_target.type_declarators);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.alias->u.typealias_alias.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.typealias.alias->u.typealias_alias.type_declarators);
		}
#line 4934 "ctf-parser.c"
    break;

  case 173: /* alias_declaration_specifiers: CONST  */
#line 2169 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4947 "ctf-parser.c"
    break;

  case 174: /* alias_declaration_specifiers: type_specifier  */
#line 2178 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = (yyvsp[0].n);
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4959 "ctf-parser.c"
    break;

  case 175: /* alias_declaration_specifiers: IDENTIFIER  */
#line 2186 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			add_type(scanner, (yyvsp[0].s));
			(yyval.n) = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_ID_TYPE;
			node->u.type_specifier.id_type = yylval.s;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4974 "ctf-parser.c"
    break;

  case 176: /* alias_declaration_specifiers: alias_declaration_specifiers CONST  */
#line 2197 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			(yyval.n) = (yyvsp[-1].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_CONST;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4987 "ctf-parser.c"
    break;

  case 177: /* alias_declaration_specifiers: alias_declaration_specifiers type_specifier  */
#line 2206 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-1].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 4996 "ctf-parser.c"
    break;

  case 178: /* alias_declaration_specifiers: alias_declaration_specifiers IDENTIFIER  */
#line 2211 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *node;

			add_type(scanner, (yyvsp[0].s));
			(yyval.n) = (yyvsp[-1].n);
			node = make_node(scanner, NODE_TYPE_SPECIFIER);
			node->u.type_specifier.type = TYPESPEC_ID_TYPE;
			node->u.type_specifier.id_type = yylval.s;
			bt_list_add_tail(&node->siblings, &((yyval.n))->u.type_specifier_list.head);
		}
#line 5011 "ctf-parser.c"
    break;

  case 179: /* struct_or_variant_declarator_list: struct_or_variant_declarator  */
#line 2225 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5017 "ctf-parser.c"
    break;

  case 180: /* struct_or_variant_declarator_list: struct_or_variant_declarator_list COMMA struct_or_variant_declarator  */
#line 2227 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->tmp_head);
		}
#line 5026 "ctf-parser.c"
    break;

  case 181: /* struct_or_variant_declarator: declarator  */
#line 2235 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5032 "ctf-parser.c"
    break;

  case 182: /* struct_or_variant_declarator: COLON unary_expression  */
#line 2237 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5038 "ctf-parser.c"
    break;

  case 183: /* struct_or_variant_declarator: declarator COLON unary_expression  */
#line 2239 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			if (set_parent_node((yyvsp[0].n), (yyvsp[-2].n)))
				reparent_error(scanner, "struct_or_variant_declarator");
		}
#line 5048 "ctf-parser.c"
    break;

  case 184: /* enumerator_list: enumerator  */
#line 2248 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5054 "ctf-parser.c"
    break;

  case 185: /* enumerator_list: enumerator_list COMMA enumerator  */
#line 2250 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->tmp_head);
		}
#line 5063 "ctf-parser.c"
    break;

  case 186: /* enumerator: IDENTIFIER  */
#line 2258 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[0].s);
		}
#line 5072 "ctf-parser.c"
    break;

  case 187: /* enumerator: ID_TYPE  */
#line 2263 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[0].s);
		}
#line 5081 "ctf-parser.c"
    break;

  case 188: /* enumerator: keywords  */
#line 2268 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[0].s);
		}
#line 5090 "ctf-parser.c"
    break;

  case 189: /* enumerator: STRING_LITERAL  */
#line 2273 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[0].s);
		}
#line 5099 "ctf-parser.c"
    break;

  case 190: /* enumerator: IDENTIFIER EQUAL unary_expression_or_range  */
#line 2278 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[-2].s);
			bt_list_splice(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
#line 5109 "ctf-parser.c"
    break;

  case 191: /* enumerator: ID_TYPE EQUAL unary_expression_or_range  */
#line 2284 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[-2].s);
			bt_list_splice(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
#line 5119 "ctf-parser.c"
    break;

  case 192: /* enumerator: keywords EQUAL unary_expression_or_range  */
#line 2290 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[-2].s);
			bt_list_splice(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
#line 5129 "ctf-parser.c"
    break;

  case 193: /* enumerator: STRING_LITERAL EQUAL unary_expression_or_range  */
#line 2296 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_ENUMERATOR);
			(yyval.n)->u.enumerator.id = (yyvsp[-2].s);
			bt_list_splice(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u.enumerator.values);
		}
#line 5139 "ctf-parser.c"
    break;

  case 194: /* abstract_declarator_list: abstract_declarator  */
#line 2305 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5145 "ctf-parser.c"
    break;

  case 195: /* abstract_declarator_list: abstract_declarator_list COMMA abstract_declarator  */
#line 2307 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->tmp_head);
		}
#line 5154 "ctf-parser.c"
    break;

  case 196: /* abstract_declarator: direct_abstract_declarator  */
#line 2315 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5160 "ctf-parser.c"
    break;

  case 197: /* abstract_declarator: pointer direct_abstract_declarator  */
#line 2317 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[0].n);
			bt_list_splice(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
#line 5169 "ctf-parser.c"
    break;

  case 198: /* direct_abstract_declarator: %empty  */
#line 2325 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
                        (yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			/* id is NULL */
		}
#line 5179 "ctf-parser.c"
    break;

  case 199: /* direct_abstract_declarator: IDENTIFIER  */
#line 2331 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			(yyval.n)->u.type_declarator.u.id = (yyvsp[0].s);
		}
#line 5189 "ctf-parser.c"
    break;

  case 200: /* direct_abstract_declarator: LPAREN abstract_declarator RPAREN  */
#line 2337 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-1].n);
		}
#line 5199 "ctf-parser.c"
    break;

  case 201: /* direct_abstract_declarator: direct_abstract_declarator LSBRAC unary_expression RSBRAC  */
#line 2343 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-3].n);
			BT_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
#line 5211 "ctf-parser.c"
    break;

  case 202: /* direct_abstract_declarator: direct_abstract_declarator LSBRAC RSBRAC  */
#line 2351 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-2].n);
			(yyval.n)->u.type_declarator.u.nested.abstract_array = 1;
		}
#line 5222 "ctf-parser.c"
    break;

  case 203: /* alias_abstract_declarator_list: alias_abstract_declarator  */
#line 2361 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5228 "ctf-parser.c"
    break;

  case 204: /* alias_abstract_declarator_list: alias_abstract_declarator_list COMMA alias_abstract_declarator  */
#line 2363 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->tmp_head);
		}
#line 5237 "ctf-parser.c"
    break;

  case 205: /* alias_abstract_declarator: direct_alias_abstract_declarator  */
#line 2371 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5243 "ctf-parser.c"
    break;

  case 206: /* alias_abstract_declarator: pointer direct_alias_abstract_declarator  */
#line 2373 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[0].n);
			bt_list_splice(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
#line 5252 "ctf-parser.c"
    break;

  case 207: /* direct_alias_abstract_declarator: %empty  */
#line 2381 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
                        (yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			/* id is NULL */
		}
#line 5262 "ctf-parser.c"
    break;

  case 208: /* direct_alias_abstract_declarator: LPAREN alias_abstract_declarator RPAREN  */
#line 2387 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-1].n);
		}
#line 5272 "ctf-parser.c"
    break;

  case 209: /* direct_alias_abstract_declarator: direct_alias_abstract_declarator LSBRAC unary_expression RSBRAC  */
#line 2393 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-3].n);
			BT_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
#line 5284 "ctf-parser.c"
    break;

  case 210: /* direct_alias_abstract_declarator: direct_alias_abstract_declarator LSBRAC RSBRAC  */
#line 2401 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-2].n);
			(yyval.n)->u.type_declarator.u.nested.abstract_array = 1;
		}
#line 5295 "ctf-parser.c"
    break;

  case 211: /* declarator: direct_declarator  */
#line 2411 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5301 "ctf-parser.c"
    break;

  case 212: /* declarator: pointer direct_declarator  */
#line 2413 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[0].n);
			bt_list_splice(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
#line 5310 "ctf-parser.c"
    break;

  case 213: /* direct_declarator: IDENTIFIER  */
#line 2421 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			(yyval.n)->u.type_declarator.u.id = (yyvsp[0].s);
		}
#line 5320 "ctf-parser.c"
    break;

  case 214: /* direct_declarator: LPAREN declarator RPAREN  */
#line 2427 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-1].n);
		}
#line 5330 "ctf-parser.c"
    break;

  case 215: /* direct_declarator: direct_declarator LSBRAC unary_expression RSBRAC  */
#line 2433 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-3].n);
			BT_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
#line 5342 "ctf-parser.c"
    break;

  case 216: /* type_declarator: direct_type_declarator  */
#line 2444 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[0].n);	}
#line 5348 "ctf-parser.c"
    break;

  case 217: /* type_declarator: pointer direct_type_declarator  */
#line 2446 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[0].n);
			bt_list_splice(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.pointers);
		}
#line 5357 "ctf-parser.c"
    break;

  case 218: /* direct_type_declarator: IDENTIFIER  */
#line 2454 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			add_type(scanner, (yyvsp[0].s));
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_ID;
			(yyval.n)->u.type_declarator.u.id = (yyvsp[0].s);
		}
#line 5368 "ctf-parser.c"
    break;

  case 219: /* direct_type_declarator: LPAREN type_declarator RPAREN  */
#line 2461 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-1].n);
		}
#line 5378 "ctf-parser.c"
    break;

  case 220: /* direct_type_declarator: direct_type_declarator LSBRAC unary_expression RSBRAC  */
#line 2467 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_TYPE_DECLARATOR);
			(yyval.n)->u.type_declarator.type = TYPEDEC_NESTED;
			(yyval.n)->u.type_declarator.u.nested.type_declarator = (yyvsp[-3].n);
			BT_INIT_LIST_HEAD(&((yyval.n))->u.type_declarator.u.nested.length);
			_bt_list_splice_tail(&((yyvsp[-1].n))->tmp_head, &((yyval.n))->u.type_declarator.u.nested.length);
		}
#line 5390 "ctf-parser.c"
    break;

  case 221: /* pointer: STAR  */
#line 2478 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_POINTER);
		}
#line 5398 "ctf-parser.c"
    break;

  case 222: /* pointer: STAR pointer  */
#line 2482 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_POINTER);
			bt_list_splice(&((yyvsp[0].n))->tmp_head, &((yyval.n))->tmp_head);
		}
#line 5407 "ctf-parser.c"
    break;

  case 223: /* pointer: STAR type_qualifier_list pointer  */
#line 2487 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = make_node(scanner, NODE_POINTER);
			(yyval.n)->u.pointer.const_qualifier = 1;
			bt_list_splice(&((yyvsp[0].n))->tmp_head, &((yyval.n))->tmp_head);
		}
#line 5417 "ctf-parser.c"
    break;

  case 226: /* ctf_assignment_expression_list: ctf_assignment_expression SEMICOLON  */
#line 2504 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {	(yyval.n) = (yyvsp[-1].n);	}
#line 5423 "ctf-parser.c"
    break;

  case 227: /* ctf_assignment_expression_list: ctf_assignment_expression_list ctf_assignment_expression SEMICOLON  */
#line 2506 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			(yyval.n) = (yyvsp[-2].n);
			bt_list_add_tail(&((yyvsp[-1].n))->siblings, &((yyval.n))->tmp_head);
		}
#line 5432 "ctf-parser.c"
    break;

  case 228: /* ctf_assignment_expression: unary_expression EQUAL unary_expression  */
#line 2514 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			/*
			 * Because we have left and right, cannot use
			 * set_parent_node.
			 */
			(yyval.n) = make_node(scanner, NODE_CTF_EXPRESSION);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u.ctf_expression.left);
			if ((yyvsp[-2].n)->u.unary_expression.type != UNARY_STRING)
				reparent_error(scanner, "ctf_assignment_expression left expects string");
			_bt_list_splice_tail(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u.ctf_expression.right);
		}
#line 5448 "ctf-parser.c"
    break;

  case 229: /* ctf_assignment_expression: unary_expression TYPEASSIGN declaration_specifiers  */
#line 2526 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			/*
			 * Because we have left and right, cannot use
			 * set_parent_node.
			 */
			(yyval.n) = make_node(scanner, NODE_CTF_EXPRESSION);
			_bt_list_splice_tail(&((yyvsp[-2].n))->tmp_head, &((yyval.n))->u.ctf_expression.left);
			if ((yyvsp[-2].n)->u.unary_expression.type != UNARY_STRING)
				reparent_error(scanner, "ctf_assignment_expression left expects string");
			bt_list_add_tail(&((yyvsp[0].n))->siblings, &((yyval.n))->u.ctf_expression.right);
		}
#line 5464 "ctf-parser.c"
    break;

  case 230: /* ctf_assignment_expression: declaration_specifiers TYPEDEF declaration_specifiers type_declarator_list  */
#line 2538 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_bt_list_splice_tail(&((yyvsp[-3].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-1].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 5479 "ctf-parser.c"
    break;

  case 231: /* ctf_assignment_expression: TYPEDEF declaration_specifiers type_declarator_list  */
#line 2549 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u._typedef.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-1].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 5493 "ctf-parser.c"
    break;

  case 232: /* ctf_assignment_expression: declaration_specifiers TYPEDEF type_declarator_list  */
#line 2559 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			_bt_list_splice_tail(&((yyvsp[-2].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			(yyval.n) = make_node(scanner, NODE_TYPEDEF);
			((yyval.n))->u.struct_or_variant_declaration.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u._typedef.type_declarators);
		}
#line 5507 "ctf-parser.c"
    break;

  case 233: /* ctf_assignment_expression: TYPEALIAS declaration_specifiers abstract_declarator_list TYPEASSIGN alias_declaration_specifiers alias_abstract_declarator_list  */
#line 2569 "../../../../git/formats/ctf/metadata/ctf-parser.y"
                {
			struct ctf_node *list;

			(yyval.n) = make_node(scanner, NODE_TYPEALIAS);
			(yyval.n)->u.typealias.target = make_node(scanner, NODE_TYPEALIAS_TARGET);
			(yyval.n)->u.typealias.alias = make_node(scanner, NODE_TYPEALIAS_ALIAS);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.target->u.typealias_target.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-4].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[-3].n))->tmp_head, &((yyval.n))->u.typealias.target->u.typealias_target.type_declarators);

			list = make_node(scanner, NODE_TYPE_SPECIFIER_LIST);
			(yyval.n)->u.typealias.alias->u.typealias_alias.type_specifier_list = list;
			_bt_list_splice_tail(&((yyvsp[-1].n))->u.type_specifier_list.head, &list->u.type_specifier_list.head);
			_bt_list_splice_tail(&((yyvsp[0].n))->tmp_head, &((yyval.n))->u.typealias.alias->u.typealias_alias.type_declarators);
		}
#line 5529 "ctf-parser.c"
    break;


#line 5533 "ctf-parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (scanner, yyscanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

