#ifndef LIBICAL_GLIB_PRIVATE_H
#define LIBICAL_GLIB_PRIVATE_H

#include "libical-glib.h"

/* Private methods for ICalArray */

ICalArray *	i_cal_array_new_full		(icalarray *native,
						 GObject *owner,
						 gboolean is_global_memory);

GObject *	i_cal_array_element_at		(ICalArray *array,
						 gint position);

/* Private methods for ICalAttach */

ICalAttach *	i_cal_attach_new_full		(icalattach *native,
						 GObject *owner);

/* Private methods for ICalCompIter */

ICalCompIter *	i_cal_comp_iter_new_full	(struct icalcompiter native);

struct icalcompiter 
		i_cal_comp_iter_new_default	(void);

/* Private methods for ICalComponent */

ICalComponent *	i_cal_component_new_full	(icalcomponent *native,
						 GObject *owner);

/* Private methods for ICalDatetimeperiod */

ICalDatetimeperiod *
		i_cal_datetimeperiod_new_full	(struct icaldatetimeperiodtype native);

struct icaldatetimeperiodtype 
		i_cal_datetimeperiod_new_default
						(void);

/* Private methods for ICalDuration */

ICalDuration *	i_cal_duration_new_full		(struct icaldurationtype native);

/* Private methods for ICalGeo */

ICalGeo *	i_cal_geo_new_full		(struct icalgeotype native);

struct icalgeotype 
		i_cal_geo_new_default		(void);

/* Private methods for ICalParameter */

ICalParameter *	i_cal_parameter_new_full	(icalparameter *native,
						 GObject *owner);

/* Private methods for ICalParser */

ICalParser *	i_cal_parser_new_full		(icalparser *native,
						 GObject *owner);

/* Private methods for ICalPeriod */

ICalPeriod *	i_cal_period_new_full		(struct icalperiodtype native);

/* Private methods for ICalProperty */

ICalProperty *	i_cal_property_new_full		(icalproperty *native,
						 GObject *owner);

/* Private methods for ICalRecurIterator */

ICalRecurIterator *
		i_cal_recur_iterator_new_full	(icalrecur_iterator *native,
						 GObject *owner);

/* Private methods for ICalRecurrence */

ICalRecurrence *
		i_cal_recurrence_new_full	(struct icalrecurrencetype native);

struct icalrecurrencetype 
		i_cal_recurrence_new_default	(void);

/* Private methods for ICalReqstat */

ICalReqstat *	i_cal_reqstat_new_full		(struct icalreqstattype native);

struct icalreqstattype 
		i_cal_reqstat_new_default	(void);

/* Private methods for ICalTimeSpan */

ICalTimeSpan *	i_cal_time_span_new_full	(struct icaltime_span native);

/* Private methods for ICalTime */

ICalTime *	i_cal_time_new_full		(struct icaltimetype native);

/* Private methods for ICalTimezone */

ICalTimezone *	i_cal_timezone_new_full		(icaltimezone *native,
						 GObject *owner,
						 gboolean is_global_memory);

void		i_cal_timezone_destroy		(icaltimezone *zone);

void		i_cal_timezone_array_destroy	(icalarray *zones_array);

/* Private methods for ICalTrigger */

ICalTrigger *	i_cal_trigger_new_full		(struct icaltriggertype native);

/* Private methods for ICalValue */

ICalValue *	i_cal_value_new_full		(icalvalue *native,
						 GObject *owner);
#endif
