/* Generated by wayland-scanner 1.22.0 */

#ifndef IVI_HMI_CONTROLLER_CLIENT_PROTOCOL_H
#define IVI_HMI_CONTROLLER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ivi_hmi_controller The ivi_hmi_controller protocol
 * @section page_ifaces_ivi_hmi_controller Interfaces
 * - @subpage page_iface_ivi_hmi_controller - set up and control IVI style UI
 * @section page_copyright_ivi_hmi_controller Copyright
 * <pre>
 *
 * Copyright (C) 2013 DENSO CORPORATION
 * Copyright (c) 2013 BMW Car IT GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ivi_hmi_controller;
struct wl_seat;

#ifndef IVI_HMI_CONTROLLER_INTERFACE
#define IVI_HMI_CONTROLLER_INTERFACE
/**
 * @page page_iface_ivi_hmi_controller ivi_hmi_controller
 * @section page_iface_ivi_hmi_controller_desc Description
 * @section page_iface_ivi_hmi_controller_api API
 * See @ref iface_ivi_hmi_controller.
 */
/**
 * @defgroup iface_ivi_hmi_controller The ivi_hmi_controller interface
 */
extern const struct wl_interface ivi_hmi_controller_interface;
#endif

#ifndef IVI_HMI_CONTROLLER_LAYOUT_MODE_ENUM
#define IVI_HMI_CONTROLLER_LAYOUT_MODE_ENUM
enum ivi_hmi_controller_layout_mode {
	IVI_HMI_CONTROLLER_LAYOUT_MODE_TILING = 0,
	IVI_HMI_CONTROLLER_LAYOUT_MODE_SIDE_BY_SIDE = 1,
	IVI_HMI_CONTROLLER_LAYOUT_MODE_FULL_SCREEN = 2,
	IVI_HMI_CONTROLLER_LAYOUT_MODE_RANDOM = 3,
};
#endif /* IVI_HMI_CONTROLLER_LAYOUT_MODE_ENUM */

#ifndef IVI_HMI_CONTROLLER_HOME_ENUM
#define IVI_HMI_CONTROLLER_HOME_ENUM
enum ivi_hmi_controller_home {
	IVI_HMI_CONTROLLER_HOME_OFF = 0,
	IVI_HMI_CONTROLLER_HOME_ON = 1,
};
#endif /* IVI_HMI_CONTROLLER_HOME_ENUM */

/**
 * @ingroup iface_ivi_hmi_controller
 * @struct ivi_hmi_controller_listener
 */
struct ivi_hmi_controller_listener {
	/**
	 * notify controlling workspace end
	 *
	 * 
	 */
	void (*workspace_end_control)(void *data,
				      struct ivi_hmi_controller *ivi_hmi_controller,
				      int32_t is_controlled);
};

/**
 * @ingroup iface_ivi_hmi_controller
 */
static inline int
ivi_hmi_controller_add_listener(struct ivi_hmi_controller *ivi_hmi_controller,
				const struct ivi_hmi_controller_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_hmi_controller,
				     (void (**)(void)) listener, data);
}

#define IVI_HMI_CONTROLLER_UI_READY 0
#define IVI_HMI_CONTROLLER_WORKSPACE_CONTROL 1
#define IVI_HMI_CONTROLLER_SWITCH_MODE 2
#define IVI_HMI_CONTROLLER_HOME 3

/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_WORKSPACE_END_CONTROL_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_UI_READY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_WORKSPACE_CONTROL_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_SWITCH_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_HOME_SINCE_VERSION 1

/** @ingroup iface_ivi_hmi_controller */
static inline void
ivi_hmi_controller_set_user_data(struct ivi_hmi_controller *ivi_hmi_controller, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_hmi_controller, user_data);
}

/** @ingroup iface_ivi_hmi_controller */
static inline void *
ivi_hmi_controller_get_user_data(struct ivi_hmi_controller *ivi_hmi_controller)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_hmi_controller);
}

static inline uint32_t
ivi_hmi_controller_get_version(struct ivi_hmi_controller *ivi_hmi_controller)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_hmi_controller);
}

/** @ingroup iface_ivi_hmi_controller */
static inline void
ivi_hmi_controller_destroy(struct ivi_hmi_controller *ivi_hmi_controller)
{
	wl_proxy_destroy((struct wl_proxy *) ivi_hmi_controller);
}

/**
 * @ingroup iface_ivi_hmi_controller
 */
static inline void
ivi_hmi_controller_UI_ready(struct ivi_hmi_controller *ivi_hmi_controller)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_hmi_controller,
			 IVI_HMI_CONTROLLER_UI_READY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_hmi_controller), 0);
}

/**
 * @ingroup iface_ivi_hmi_controller
 *
 * Reference protocol to control a surface by server.
 * To control a surface by server, it gives seat to the server
 * to e.g. control Home screen. Home screen has several workspaces
 * to group launchers of wayland application. These workspaces
 * are drawn on a horizontally long surface to be controlled
 * by motion of input device. E.g. A motion from right to left
 * happens, the viewport of surface is controlled in the ivi-shell
 * by using ivi-layout. client can recognizes the end of controlling
 * by event "workspace_end_control".
 */
static inline void
ivi_hmi_controller_workspace_control(struct ivi_hmi_controller *ivi_hmi_controller, struct wl_seat *seat, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_hmi_controller,
			 IVI_HMI_CONTROLLER_WORKSPACE_CONTROL, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_hmi_controller), 0, seat, serial);
}

/**
 * @ingroup iface_ivi_hmi_controller
 *
 * hmi-controller loaded to ivi-shall implements 4 types of layout
 * as a reference; tiling, side by side, full_screen, and random.
 */
static inline void
ivi_hmi_controller_switch_mode(struct ivi_hmi_controller *ivi_hmi_controller, uint32_t layout_mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_hmi_controller,
			 IVI_HMI_CONTROLLER_SWITCH_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_hmi_controller), 0, layout_mode);
}

/**
 * @ingroup iface_ivi_hmi_controller
 *
 * home screen is a reference implementation of launcher to launch
 * wayland applications. The home screen has several workspaces to
 * group wayland applications. By defining the following keys in
 * weston.ini, user can add launcher icon to launch a wayland application
 * to a workspace.
 * [ivi-launcher]
 * workspace-id=0
 * : id of workspace to add a launcher
 * icon-id=4001
 * : ivi id of ivi_surface to draw an icon
 * icon=/home/user/review/build-ivi-shell/data/icon_ivi_flower.png
 * : path to icon image
 * path=/home/user/review/build-ivi-shell/weston-dnd
 * : path to wayland application
 */
static inline void
ivi_hmi_controller_home(struct ivi_hmi_controller *ivi_hmi_controller, uint32_t home)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_hmi_controller,
			 IVI_HMI_CONTROLLER_HOME, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_hmi_controller), 0, home);
}

#ifdef  __cplusplus
}
#endif

#endif
