const char* ExtensionToString(Extension extension) {
  switch (extension) {
    case Extension::kSPV_AMDX_shader_enqueue:
      return "SPV_AMDX_shader_enqueue";
    case Extension::kSPV_AMD_gcn_shader:
      return "SPV_AMD_gcn_shader";
    case Extension::kSPV_AMD_gpu_shader_half_float:
      return "SPV_AMD_gpu_shader_half_float";
    case Extension::kSPV_AMD_gpu_shader_half_float_fetch:
      return "SPV_AMD_gpu_shader_half_float_fetch";
    case Extension::kSPV_AMD_gpu_shader_int16:
      return "SPV_AMD_gpu_shader_int16";
    case Extension::kSPV_AMD_shader_ballot:
      return "SPV_AMD_shader_ballot";
    case Extension::kSPV_AMD_shader_early_and_late_fragment_tests:
      return "SPV_AMD_shader_early_and_late_fragment_tests";
    case Extension::kSPV_AMD_shader_explicit_vertex_parameter:
      return "SPV_AMD_shader_explicit_vertex_parameter";
    case Extension::kSPV_AMD_shader_fragment_mask:
      return "SPV_AMD_shader_fragment_mask";
    case Extension::kSPV_AMD_shader_image_load_store_lod:
      return "SPV_AMD_shader_image_load_store_lod";
    case Extension::kSPV_AMD_shader_trinary_minmax:
      return "SPV_AMD_shader_trinary_minmax";
    case Extension::kSPV_AMD_texture_gather_bias_lod:
      return "SPV_AMD_texture_gather_bias_lod";
    case Extension::kSPV_ARM_core_builtins:
      return "SPV_ARM_core_builtins";
    case Extension::kSPV_EXT_demote_to_helper_invocation:
      return "SPV_EXT_demote_to_helper_invocation";
    case Extension::kSPV_EXT_descriptor_indexing:
      return "SPV_EXT_descriptor_indexing";
    case Extension::kSPV_EXT_fragment_fully_covered:
      return "SPV_EXT_fragment_fully_covered";
    case Extension::kSPV_EXT_fragment_invocation_density:
      return "SPV_EXT_fragment_invocation_density";
    case Extension::kSPV_EXT_fragment_shader_interlock:
      return "SPV_EXT_fragment_shader_interlock";
    case Extension::kSPV_EXT_mesh_shader:
      return "SPV_EXT_mesh_shader";
    case Extension::kSPV_EXT_opacity_micromap:
      return "SPV_EXT_opacity_micromap";
    case Extension::kSPV_EXT_physical_storage_buffer:
      return "SPV_EXT_physical_storage_buffer";
    case Extension::kSPV_EXT_shader_atomic_float16_add:
      return "SPV_EXT_shader_atomic_float16_add";
    case Extension::kSPV_EXT_shader_atomic_float_add:
      return "SPV_EXT_shader_atomic_float_add";
    case Extension::kSPV_EXT_shader_atomic_float_min_max:
      return "SPV_EXT_shader_atomic_float_min_max";
    case Extension::kSPV_EXT_shader_image_int64:
      return "SPV_EXT_shader_image_int64";
    case Extension::kSPV_EXT_shader_stencil_export:
      return "SPV_EXT_shader_stencil_export";
    case Extension::kSPV_EXT_shader_tile_image:
      return "SPV_EXT_shader_tile_image";
    case Extension::kSPV_EXT_shader_viewport_index_layer:
      return "SPV_EXT_shader_viewport_index_layer";
    case Extension::kSPV_GOOGLE_decorate_string:
      return "SPV_GOOGLE_decorate_string";
    case Extension::kSPV_GOOGLE_hlsl_functionality1:
      return "SPV_GOOGLE_hlsl_functionality1";
    case Extension::kSPV_GOOGLE_user_type:
      return "SPV_GOOGLE_user_type";
    case Extension::kSPV_INTEL_arbitrary_precision_fixed_point:
      return "SPV_INTEL_arbitrary_precision_fixed_point";
    case Extension::kSPV_INTEL_arbitrary_precision_floating_point:
      return "SPV_INTEL_arbitrary_precision_floating_point";
    case Extension::kSPV_INTEL_arbitrary_precision_integers:
      return "SPV_INTEL_arbitrary_precision_integers";
    case Extension::kSPV_INTEL_bfloat16_conversion:
      return "SPV_INTEL_bfloat16_conversion";
    case Extension::kSPV_INTEL_blocking_pipes:
      return "SPV_INTEL_blocking_pipes";
    case Extension::kSPV_INTEL_cache_controls:
      return "SPV_INTEL_cache_controls";
    case Extension::kSPV_INTEL_debug_module:
      return "SPV_INTEL_debug_module";
    case Extension::kSPV_INTEL_device_side_avc_motion_estimation:
      return "SPV_INTEL_device_side_avc_motion_estimation";
    case Extension::kSPV_INTEL_float_controls2:
      return "SPV_INTEL_float_controls2";
    case Extension::kSPV_INTEL_fp_fast_math_mode:
      return "SPV_INTEL_fp_fast_math_mode";
    case Extension::kSPV_INTEL_fp_max_error:
      return "SPV_INTEL_fp_max_error";
    case Extension::kSPV_INTEL_fpga_argument_interfaces:
      return "SPV_INTEL_fpga_argument_interfaces";
    case Extension::kSPV_INTEL_fpga_buffer_location:
      return "SPV_INTEL_fpga_buffer_location";
    case Extension::kSPV_INTEL_fpga_cluster_attributes:
      return "SPV_INTEL_fpga_cluster_attributes";
    case Extension::kSPV_INTEL_fpga_dsp_control:
      return "SPV_INTEL_fpga_dsp_control";
    case Extension::kSPV_INTEL_fpga_invocation_pipelining_attributes:
      return "SPV_INTEL_fpga_invocation_pipelining_attributes";
    case Extension::kSPV_INTEL_fpga_latency_control:
      return "SPV_INTEL_fpga_latency_control";
    case Extension::kSPV_INTEL_fpga_loop_controls:
      return "SPV_INTEL_fpga_loop_controls";
    case Extension::kSPV_INTEL_fpga_memory_accesses:
      return "SPV_INTEL_fpga_memory_accesses";
    case Extension::kSPV_INTEL_fpga_memory_attributes:
      return "SPV_INTEL_fpga_memory_attributes";
    case Extension::kSPV_INTEL_fpga_reg:
      return "SPV_INTEL_fpga_reg";
    case Extension::kSPV_INTEL_function_pointers:
      return "SPV_INTEL_function_pointers";
    case Extension::kSPV_INTEL_global_variable_fpga_decorations:
      return "SPV_INTEL_global_variable_fpga_decorations";
    case Extension::kSPV_INTEL_global_variable_host_access:
      return "SPV_INTEL_global_variable_host_access";
    case Extension::kSPV_INTEL_inline_assembly:
      return "SPV_INTEL_inline_assembly";
    case Extension::kSPV_INTEL_io_pipes:
      return "SPV_INTEL_io_pipes";
    case Extension::kSPV_INTEL_kernel_attributes:
      return "SPV_INTEL_kernel_attributes";
    case Extension::kSPV_INTEL_long_composites:
      return "SPV_INTEL_long_composites";
    case Extension::kSPV_INTEL_loop_fuse:
      return "SPV_INTEL_loop_fuse";
    case Extension::kSPV_INTEL_media_block_io:
      return "SPV_INTEL_media_block_io";
    case Extension::kSPV_INTEL_memory_access_aliasing:
      return "SPV_INTEL_memory_access_aliasing";
    case Extension::kSPV_INTEL_optnone:
      return "SPV_INTEL_optnone";
    case Extension::kSPV_INTEL_runtime_aligned:
      return "SPV_INTEL_runtime_aligned";
    case Extension::kSPV_INTEL_shader_integer_functions2:
      return "SPV_INTEL_shader_integer_functions2";
    case Extension::kSPV_INTEL_split_barrier:
      return "SPV_INTEL_split_barrier";
    case Extension::kSPV_INTEL_subgroups:
      return "SPV_INTEL_subgroups";
    case Extension::kSPV_INTEL_unstructured_loop_controls:
      return "SPV_INTEL_unstructured_loop_controls";
    case Extension::kSPV_INTEL_usm_storage_classes:
      return "SPV_INTEL_usm_storage_classes";
    case Extension::kSPV_INTEL_variable_length_array:
      return "SPV_INTEL_variable_length_array";
    case Extension::kSPV_INTEL_vector_compute:
      return "SPV_INTEL_vector_compute";
    case Extension::kSPV_KHR_16bit_storage:
      return "SPV_KHR_16bit_storage";
    case Extension::kSPV_KHR_8bit_storage:
      return "SPV_KHR_8bit_storage";
    case Extension::kSPV_KHR_bit_instructions:
      return "SPV_KHR_bit_instructions";
    case Extension::kSPV_KHR_cooperative_matrix:
      return "SPV_KHR_cooperative_matrix";
    case Extension::kSPV_KHR_device_group:
      return "SPV_KHR_device_group";
    case Extension::kSPV_KHR_expect_assume:
      return "SPV_KHR_expect_assume";
    case Extension::kSPV_KHR_float_controls:
      return "SPV_KHR_float_controls";
    case Extension::kSPV_KHR_fragment_shader_barycentric:
      return "SPV_KHR_fragment_shader_barycentric";
    case Extension::kSPV_KHR_fragment_shading_rate:
      return "SPV_KHR_fragment_shading_rate";
    case Extension::kSPV_KHR_integer_dot_product:
      return "SPV_KHR_integer_dot_product";
    case Extension::kSPV_KHR_linkonce_odr:
      return "SPV_KHR_linkonce_odr";
    case Extension::kSPV_KHR_multiview:
      return "SPV_KHR_multiview";
    case Extension::kSPV_KHR_no_integer_wrap_decoration:
      return "SPV_KHR_no_integer_wrap_decoration";
    case Extension::kSPV_KHR_non_semantic_info:
      return "SPV_KHR_non_semantic_info";
    case Extension::kSPV_KHR_physical_storage_buffer:
      return "SPV_KHR_physical_storage_buffer";
    case Extension::kSPV_KHR_post_depth_coverage:
      return "SPV_KHR_post_depth_coverage";
    case Extension::kSPV_KHR_ray_cull_mask:
      return "SPV_KHR_ray_cull_mask";
    case Extension::kSPV_KHR_ray_query:
      return "SPV_KHR_ray_query";
    case Extension::kSPV_KHR_ray_tracing:
      return "SPV_KHR_ray_tracing";
    case Extension::kSPV_KHR_ray_tracing_position_fetch:
      return "SPV_KHR_ray_tracing_position_fetch";
    case Extension::kSPV_KHR_shader_atomic_counter_ops:
      return "SPV_KHR_shader_atomic_counter_ops";
    case Extension::kSPV_KHR_shader_ballot:
      return "SPV_KHR_shader_ballot";
    case Extension::kSPV_KHR_shader_clock:
      return "SPV_KHR_shader_clock";
    case Extension::kSPV_KHR_shader_draw_parameters:
      return "SPV_KHR_shader_draw_parameters";
    case Extension::kSPV_KHR_storage_buffer_storage_class:
      return "SPV_KHR_storage_buffer_storage_class";
    case Extension::kSPV_KHR_subgroup_rotate:
      return "SPV_KHR_subgroup_rotate";
    case Extension::kSPV_KHR_subgroup_uniform_control_flow:
      return "SPV_KHR_subgroup_uniform_control_flow";
    case Extension::kSPV_KHR_subgroup_vote:
      return "SPV_KHR_subgroup_vote";
    case Extension::kSPV_KHR_terminate_invocation:
      return "SPV_KHR_terminate_invocation";
    case Extension::kSPV_KHR_uniform_group_instructions:
      return "SPV_KHR_uniform_group_instructions";
    case Extension::kSPV_KHR_variable_pointers:
      return "SPV_KHR_variable_pointers";
    case Extension::kSPV_KHR_vulkan_memory_model:
      return "SPV_KHR_vulkan_memory_model";
    case Extension::kSPV_KHR_workgroup_memory_explicit_layout:
      return "SPV_KHR_workgroup_memory_explicit_layout";
    case Extension::kSPV_NVX_multiview_per_view_attributes:
      return "SPV_NVX_multiview_per_view_attributes";
    case Extension::kSPV_NV_bindless_texture:
      return "SPV_NV_bindless_texture";
    case Extension::kSPV_NV_compute_shader_derivatives:
      return "SPV_NV_compute_shader_derivatives";
    case Extension::kSPV_NV_cooperative_matrix:
      return "SPV_NV_cooperative_matrix";
    case Extension::kSPV_NV_displacement_micromap:
      return "SPV_NV_displacement_micromap";
    case Extension::kSPV_NV_fragment_shader_barycentric:
      return "SPV_NV_fragment_shader_barycentric";
    case Extension::kSPV_NV_geometry_shader_passthrough:
      return "SPV_NV_geometry_shader_passthrough";
    case Extension::kSPV_NV_mesh_shader:
      return "SPV_NV_mesh_shader";
    case Extension::kSPV_NV_ray_tracing:
      return "SPV_NV_ray_tracing";
    case Extension::kSPV_NV_ray_tracing_motion_blur:
      return "SPV_NV_ray_tracing_motion_blur";
    case Extension::kSPV_NV_sample_mask_override_coverage:
      return "SPV_NV_sample_mask_override_coverage";
    case Extension::kSPV_NV_shader_image_footprint:
      return "SPV_NV_shader_image_footprint";
    case Extension::kSPV_NV_shader_invocation_reorder:
      return "SPV_NV_shader_invocation_reorder";
    case Extension::kSPV_NV_shader_sm_builtins:
      return "SPV_NV_shader_sm_builtins";
    case Extension::kSPV_NV_shader_subgroup_partitioned:
      return "SPV_NV_shader_subgroup_partitioned";
    case Extension::kSPV_NV_shading_rate:
      return "SPV_NV_shading_rate";
    case Extension::kSPV_NV_stereo_view_rendering:
      return "SPV_NV_stereo_view_rendering";
    case Extension::kSPV_NV_viewport_array2:
      return "SPV_NV_viewport_array2";
    case Extension::kSPV_QCOM_image_processing:
      return "SPV_QCOM_image_processing";
    case Extension::kSPV_VALIDATOR_ignore_type_decl_unique:
      return "SPV_VALIDATOR_ignore_type_decl_unique";
  }

  return "";
}


    bool GetExtensionFromString(const char* str, Extension* extension) {
        static const char* known_ext_strs[] = { "SPV_AMDX_shader_enqueue", "SPV_AMD_gcn_shader", "SPV_AMD_gpu_shader_half_float", "SPV_AMD_gpu_shader_half_float_fetch", "SPV_AMD_gpu_shader_int16", "SPV_AMD_shader_ballot", "SPV_AMD_shader_early_and_late_fragment_tests", "SPV_AMD_shader_explicit_vertex_parameter", "SPV_AMD_shader_fragment_mask", "SPV_AMD_shader_image_load_store_lod", "SPV_AMD_shader_trinary_minmax", "SPV_AMD_texture_gather_bias_lod", "SPV_ARM_core_builtins", "SPV_EXT_demote_to_helper_invocation", "SPV_EXT_descriptor_indexing", "SPV_EXT_fragment_fully_covered", "SPV_EXT_fragment_invocation_density", "SPV_EXT_fragment_shader_interlock", "SPV_EXT_mesh_shader", "SPV_EXT_opacity_micromap", "SPV_EXT_physical_storage_buffer", "SPV_EXT_shader_atomic_float16_add", "SPV_EXT_shader_atomic_float_add", "SPV_EXT_shader_atomic_float_min_max", "SPV_EXT_shader_image_int64", "SPV_EXT_shader_stencil_export", "SPV_EXT_shader_tile_image", "SPV_EXT_shader_viewport_index_layer", "SPV_GOOGLE_decorate_string", "SPV_GOOGLE_hlsl_functionality1", "SPV_GOOGLE_user_type", "SPV_INTEL_arbitrary_precision_fixed_point", "SPV_INTEL_arbitrary_precision_floating_point", "SPV_INTEL_arbitrary_precision_integers", "SPV_INTEL_bfloat16_conversion", "SPV_INTEL_blocking_pipes", "SPV_INTEL_cache_controls", "SPV_INTEL_debug_module", "SPV_INTEL_device_side_avc_motion_estimation", "SPV_INTEL_float_controls2", "SPV_INTEL_fp_fast_math_mode", "SPV_INTEL_fp_max_error", "SPV_INTEL_fpga_argument_interfaces", "SPV_INTEL_fpga_buffer_location", "SPV_INTEL_fpga_cluster_attributes", "SPV_INTEL_fpga_dsp_control", "SPV_INTEL_fpga_invocation_pipelining_attributes", "SPV_INTEL_fpga_latency_control", "SPV_INTEL_fpga_loop_controls", "SPV_INTEL_fpga_memory_accesses", "SPV_INTEL_fpga_memory_attributes", "SPV_INTEL_fpga_reg", "SPV_INTEL_function_pointers", "SPV_INTEL_global_variable_fpga_decorations", "SPV_INTEL_global_variable_host_access", "SPV_INTEL_inline_assembly", "SPV_INTEL_io_pipes", "SPV_INTEL_kernel_attributes", "SPV_INTEL_long_composites", "SPV_INTEL_loop_fuse", "SPV_INTEL_media_block_io", "SPV_INTEL_memory_access_aliasing", "SPV_INTEL_optnone", "SPV_INTEL_runtime_aligned", "SPV_INTEL_shader_integer_functions2", "SPV_INTEL_split_barrier", "SPV_INTEL_subgroups", "SPV_INTEL_unstructured_loop_controls", "SPV_INTEL_usm_storage_classes", "SPV_INTEL_variable_length_array", "SPV_INTEL_vector_compute", "SPV_KHR_16bit_storage", "SPV_KHR_8bit_storage", "SPV_KHR_bit_instructions", "SPV_KHR_cooperative_matrix", "SPV_KHR_device_group", "SPV_KHR_expect_assume", "SPV_KHR_float_controls", "SPV_KHR_fragment_shader_barycentric", "SPV_KHR_fragment_shading_rate", "SPV_KHR_integer_dot_product", "SPV_KHR_linkonce_odr", "SPV_KHR_multiview", "SPV_KHR_no_integer_wrap_decoration", "SPV_KHR_non_semantic_info", "SPV_KHR_physical_storage_buffer", "SPV_KHR_post_depth_coverage", "SPV_KHR_ray_cull_mask", "SPV_KHR_ray_query", "SPV_KHR_ray_tracing", "SPV_KHR_ray_tracing_position_fetch", "SPV_KHR_shader_atomic_counter_ops", "SPV_KHR_shader_ballot", "SPV_KHR_shader_clock", "SPV_KHR_shader_draw_parameters", "SPV_KHR_storage_buffer_storage_class", "SPV_KHR_subgroup_rotate", "SPV_KHR_subgroup_uniform_control_flow", "SPV_KHR_subgroup_vote", "SPV_KHR_terminate_invocation", "SPV_KHR_uniform_group_instructions", "SPV_KHR_variable_pointers", "SPV_KHR_vulkan_memory_model", "SPV_KHR_workgroup_memory_explicit_layout", "SPV_NVX_multiview_per_view_attributes", "SPV_NV_bindless_texture", "SPV_NV_compute_shader_derivatives", "SPV_NV_cooperative_matrix", "SPV_NV_displacement_micromap", "SPV_NV_fragment_shader_barycentric", "SPV_NV_geometry_shader_passthrough", "SPV_NV_mesh_shader", "SPV_NV_ray_tracing", "SPV_NV_ray_tracing_motion_blur", "SPV_NV_sample_mask_override_coverage", "SPV_NV_shader_image_footprint", "SPV_NV_shader_invocation_reorder", "SPV_NV_shader_sm_builtins", "SPV_NV_shader_subgroup_partitioned", "SPV_NV_shading_rate", "SPV_NV_stereo_view_rendering", "SPV_NV_viewport_array2", "SPV_QCOM_image_processing", "SPV_VALIDATOR_ignore_type_decl_unique" };
        static const Extension known_ext_ids[] = { Extension::kSPV_AMDX_shader_enqueue, Extension::kSPV_AMD_gcn_shader, Extension::kSPV_AMD_gpu_shader_half_float, Extension::kSPV_AMD_gpu_shader_half_float_fetch, Extension::kSPV_AMD_gpu_shader_int16, Extension::kSPV_AMD_shader_ballot, Extension::kSPV_AMD_shader_early_and_late_fragment_tests, Extension::kSPV_AMD_shader_explicit_vertex_parameter, Extension::kSPV_AMD_shader_fragment_mask, Extension::kSPV_AMD_shader_image_load_store_lod, Extension::kSPV_AMD_shader_trinary_minmax, Extension::kSPV_AMD_texture_gather_bias_lod, Extension::kSPV_ARM_core_builtins, Extension::kSPV_EXT_demote_to_helper_invocation, Extension::kSPV_EXT_descriptor_indexing, Extension::kSPV_EXT_fragment_fully_covered, Extension::kSPV_EXT_fragment_invocation_density, Extension::kSPV_EXT_fragment_shader_interlock, Extension::kSPV_EXT_mesh_shader, Extension::kSPV_EXT_opacity_micromap, Extension::kSPV_EXT_physical_storage_buffer, Extension::kSPV_EXT_shader_atomic_float16_add, Extension::kSPV_EXT_shader_atomic_float_add, Extension::kSPV_EXT_shader_atomic_float_min_max, Extension::kSPV_EXT_shader_image_int64, Extension::kSPV_EXT_shader_stencil_export, Extension::kSPV_EXT_shader_tile_image, Extension::kSPV_EXT_shader_viewport_index_layer, Extension::kSPV_GOOGLE_decorate_string, Extension::kSPV_GOOGLE_hlsl_functionality1, Extension::kSPV_GOOGLE_user_type, Extension::kSPV_INTEL_arbitrary_precision_fixed_point, Extension::kSPV_INTEL_arbitrary_precision_floating_point, Extension::kSPV_INTEL_arbitrary_precision_integers, Extension::kSPV_INTEL_bfloat16_conversion, Extension::kSPV_INTEL_blocking_pipes, Extension::kSPV_INTEL_cache_controls, Extension::kSPV_INTEL_debug_module, Extension::kSPV_INTEL_device_side_avc_motion_estimation, Extension::kSPV_INTEL_float_controls2, Extension::kSPV_INTEL_fp_fast_math_mode, Extension::kSPV_INTEL_fp_max_error, Extension::kSPV_INTEL_fpga_argument_interfaces, Extension::kSPV_INTEL_fpga_buffer_location, Extension::kSPV_INTEL_fpga_cluster_attributes, Extension::kSPV_INTEL_fpga_dsp_control, Extension::kSPV_INTEL_fpga_invocation_pipelining_attributes, Extension::kSPV_INTEL_fpga_latency_control, Extension::kSPV_INTEL_fpga_loop_controls, Extension::kSPV_INTEL_fpga_memory_accesses, Extension::kSPV_INTEL_fpga_memory_attributes, Extension::kSPV_INTEL_fpga_reg, Extension::kSPV_INTEL_function_pointers, Extension::kSPV_INTEL_global_variable_fpga_decorations, Extension::kSPV_INTEL_global_variable_host_access, Extension::kSPV_INTEL_inline_assembly, Extension::kSPV_INTEL_io_pipes, Extension::kSPV_INTEL_kernel_attributes, Extension::kSPV_INTEL_long_composites, Extension::kSPV_INTEL_loop_fuse, Extension::kSPV_INTEL_media_block_io, Extension::kSPV_INTEL_memory_access_aliasing, Extension::kSPV_INTEL_optnone, Extension::kSPV_INTEL_runtime_aligned, Extension::kSPV_INTEL_shader_integer_functions2, Extension::kSPV_INTEL_split_barrier, Extension::kSPV_INTEL_subgroups, Extension::kSPV_INTEL_unstructured_loop_controls, Extension::kSPV_INTEL_usm_storage_classes, Extension::kSPV_INTEL_variable_length_array, Extension::kSPV_INTEL_vector_compute, Extension::kSPV_KHR_16bit_storage, Extension::kSPV_KHR_8bit_storage, Extension::kSPV_KHR_bit_instructions, Extension::kSPV_KHR_cooperative_matrix, Extension::kSPV_KHR_device_group, Extension::kSPV_KHR_expect_assume, Extension::kSPV_KHR_float_controls, Extension::kSPV_KHR_fragment_shader_barycentric, Extension::kSPV_KHR_fragment_shading_rate, Extension::kSPV_KHR_integer_dot_product, Extension::kSPV_KHR_linkonce_odr, Extension::kSPV_KHR_multiview, Extension::kSPV_KHR_no_integer_wrap_decoration, Extension::kSPV_KHR_non_semantic_info, Extension::kSPV_KHR_physical_storage_buffer, Extension::kSPV_KHR_post_depth_coverage, Extension::kSPV_KHR_ray_cull_mask, Extension::kSPV_KHR_ray_query, Extension::kSPV_KHR_ray_tracing, Extension::kSPV_KHR_ray_tracing_position_fetch, Extension::kSPV_KHR_shader_atomic_counter_ops, Extension::kSPV_KHR_shader_ballot, Extension::kSPV_KHR_shader_clock, Extension::kSPV_KHR_shader_draw_parameters, Extension::kSPV_KHR_storage_buffer_storage_class, Extension::kSPV_KHR_subgroup_rotate, Extension::kSPV_KHR_subgroup_uniform_control_flow, Extension::kSPV_KHR_subgroup_vote, Extension::kSPV_KHR_terminate_invocation, Extension::kSPV_KHR_uniform_group_instructions, Extension::kSPV_KHR_variable_pointers, Extension::kSPV_KHR_vulkan_memory_model, Extension::kSPV_KHR_workgroup_memory_explicit_layout, Extension::kSPV_NVX_multiview_per_view_attributes, Extension::kSPV_NV_bindless_texture, Extension::kSPV_NV_compute_shader_derivatives, Extension::kSPV_NV_cooperative_matrix, Extension::kSPV_NV_displacement_micromap, Extension::kSPV_NV_fragment_shader_barycentric, Extension::kSPV_NV_geometry_shader_passthrough, Extension::kSPV_NV_mesh_shader, Extension::kSPV_NV_ray_tracing, Extension::kSPV_NV_ray_tracing_motion_blur, Extension::kSPV_NV_sample_mask_override_coverage, Extension::kSPV_NV_shader_image_footprint, Extension::kSPV_NV_shader_invocation_reorder, Extension::kSPV_NV_shader_sm_builtins, Extension::kSPV_NV_shader_subgroup_partitioned, Extension::kSPV_NV_shading_rate, Extension::kSPV_NV_stereo_view_rendering, Extension::kSPV_NV_viewport_array2, Extension::kSPV_QCOM_image_processing, Extension::kSPV_VALIDATOR_ignore_type_decl_unique };
        const auto b = std::begin(known_ext_strs);
        const auto e = std::end(known_ext_strs);
        const auto found = std::equal_range(
            b, e, str, [](const char* str1, const char* str2) {
                return std::strcmp(str1, str2) < 0;
            });
        if (found.first == e || found.first == found.second) return false;

        *extension = known_ext_ids[found.first - b];
        return true;
    }
    

const char* CapabilityToString(spv::Capability capability) {
  switch (capability) {
    case spv::Capability::Matrix:
      return "Matrix";
    case spv::Capability::Shader:
      return "Shader";
    case spv::Capability::Geometry:
      return "Geometry";
    case spv::Capability::Tessellation:
      return "Tessellation";
    case spv::Capability::Addresses:
      return "Addresses";
    case spv::Capability::Linkage:
      return "Linkage";
    case spv::Capability::Kernel:
      return "Kernel";
    case spv::Capability::Vector16:
      return "Vector16";
    case spv::Capability::Float16Buffer:
      return "Float16Buffer";
    case spv::Capability::Float16:
      return "Float16";
    case spv::Capability::Float64:
      return "Float64";
    case spv::Capability::Int64:
      return "Int64";
    case spv::Capability::Int64Atomics:
      return "Int64Atomics";
    case spv::Capability::ImageBasic:
      return "ImageBasic";
    case spv::Capability::ImageReadWrite:
      return "ImageReadWrite";
    case spv::Capability::ImageMipmap:
      return "ImageMipmap";
    case spv::Capability::Pipes:
      return "Pipes";
    case spv::Capability::Groups:
      return "Groups";
    case spv::Capability::DeviceEnqueue:
      return "DeviceEnqueue";
    case spv::Capability::LiteralSampler:
      return "LiteralSampler";
    case spv::Capability::AtomicStorage:
      return "AtomicStorage";
    case spv::Capability::Int16:
      return "Int16";
    case spv::Capability::TessellationPointSize:
      return "TessellationPointSize";
    case spv::Capability::GeometryPointSize:
      return "GeometryPointSize";
    case spv::Capability::ImageGatherExtended:
      return "ImageGatherExtended";
    case spv::Capability::StorageImageMultisample:
      return "StorageImageMultisample";
    case spv::Capability::UniformBufferArrayDynamicIndexing:
      return "UniformBufferArrayDynamicIndexing";
    case spv::Capability::SampledImageArrayDynamicIndexing:
      return "SampledImageArrayDynamicIndexing";
    case spv::Capability::StorageBufferArrayDynamicIndexing:
      return "StorageBufferArrayDynamicIndexing";
    case spv::Capability::StorageImageArrayDynamicIndexing:
      return "StorageImageArrayDynamicIndexing";
    case spv::Capability::ClipDistance:
      return "ClipDistance";
    case spv::Capability::CullDistance:
      return "CullDistance";
    case spv::Capability::ImageCubeArray:
      return "ImageCubeArray";
    case spv::Capability::SampleRateShading:
      return "SampleRateShading";
    case spv::Capability::ImageRect:
      return "ImageRect";
    case spv::Capability::SampledRect:
      return "SampledRect";
    case spv::Capability::GenericPointer:
      return "GenericPointer";
    case spv::Capability::Int8:
      return "Int8";
    case spv::Capability::InputAttachment:
      return "InputAttachment";
    case spv::Capability::SparseResidency:
      return "SparseResidency";
    case spv::Capability::MinLod:
      return "MinLod";
    case spv::Capability::Sampled1D:
      return "Sampled1D";
    case spv::Capability::Image1D:
      return "Image1D";
    case spv::Capability::SampledCubeArray:
      return "SampledCubeArray";
    case spv::Capability::SampledBuffer:
      return "SampledBuffer";
    case spv::Capability::ImageBuffer:
      return "ImageBuffer";
    case spv::Capability::ImageMSArray:
      return "ImageMSArray";
    case spv::Capability::StorageImageExtendedFormats:
      return "StorageImageExtendedFormats";
    case spv::Capability::ImageQuery:
      return "ImageQuery";
    case spv::Capability::DerivativeControl:
      return "DerivativeControl";
    case spv::Capability::InterpolationFunction:
      return "InterpolationFunction";
    case spv::Capability::TransformFeedback:
      return "TransformFeedback";
    case spv::Capability::GeometryStreams:
      return "GeometryStreams";
    case spv::Capability::StorageImageReadWithoutFormat:
      return "StorageImageReadWithoutFormat";
    case spv::Capability::StorageImageWriteWithoutFormat:
      return "StorageImageWriteWithoutFormat";
    case spv::Capability::MultiViewport:
      return "MultiViewport";
    case spv::Capability::SubgroupDispatch:
      return "SubgroupDispatch";
    case spv::Capability::NamedBarrier:
      return "NamedBarrier";
    case spv::Capability::PipeStorage:
      return "PipeStorage";
    case spv::Capability::GroupNonUniform:
      return "GroupNonUniform";
    case spv::Capability::GroupNonUniformVote:
      return "GroupNonUniformVote";
    case spv::Capability::GroupNonUniformArithmetic:
      return "GroupNonUniformArithmetic";
    case spv::Capability::GroupNonUniformBallot:
      return "GroupNonUniformBallot";
    case spv::Capability::GroupNonUniformShuffle:
      return "GroupNonUniformShuffle";
    case spv::Capability::GroupNonUniformShuffleRelative:
      return "GroupNonUniformShuffleRelative";
    case spv::Capability::GroupNonUniformClustered:
      return "GroupNonUniformClustered";
    case spv::Capability::GroupNonUniformQuad:
      return "GroupNonUniformQuad";
    case spv::Capability::ShaderLayer:
      return "ShaderLayer";
    case spv::Capability::ShaderViewportIndex:
      return "ShaderViewportIndex";
    case spv::Capability::UniformDecoration:
      return "UniformDecoration";
    case spv::Capability::CoreBuiltinsARM:
      return "CoreBuiltinsARM";
    case spv::Capability::TileImageColorReadAccessEXT:
      return "TileImageColorReadAccessEXT";
    case spv::Capability::TileImageDepthReadAccessEXT:
      return "TileImageDepthReadAccessEXT";
    case spv::Capability::TileImageStencilReadAccessEXT:
      return "TileImageStencilReadAccessEXT";
    case spv::Capability::FragmentShadingRateKHR:
      return "FragmentShadingRateKHR";
    case spv::Capability::SubgroupBallotKHR:
      return "SubgroupBallotKHR";
    case spv::Capability::DrawParameters:
      return "DrawParameters";
    case spv::Capability::WorkgroupMemoryExplicitLayoutKHR:
      return "WorkgroupMemoryExplicitLayoutKHR";
    case spv::Capability::WorkgroupMemoryExplicitLayout8BitAccessKHR:
      return "WorkgroupMemoryExplicitLayout8BitAccessKHR";
    case spv::Capability::WorkgroupMemoryExplicitLayout16BitAccessKHR:
      return "WorkgroupMemoryExplicitLayout16BitAccessKHR";
    case spv::Capability::SubgroupVoteKHR:
      return "SubgroupVoteKHR";
    case spv::Capability::StorageBuffer16BitAccess:
      return "StorageBuffer16BitAccess";
    case spv::Capability::UniformAndStorageBuffer16BitAccess:
      return "UniformAndStorageBuffer16BitAccess";
    case spv::Capability::StoragePushConstant16:
      return "StoragePushConstant16";
    case spv::Capability::StorageInputOutput16:
      return "StorageInputOutput16";
    case spv::Capability::DeviceGroup:
      return "DeviceGroup";
    case spv::Capability::MultiView:
      return "MultiView";
    case spv::Capability::VariablePointersStorageBuffer:
      return "VariablePointersStorageBuffer";
    case spv::Capability::VariablePointers:
      return "VariablePointers";
    case spv::Capability::AtomicStorageOps:
      return "AtomicStorageOps";
    case spv::Capability::SampleMaskPostDepthCoverage:
      return "SampleMaskPostDepthCoverage";
    case spv::Capability::StorageBuffer8BitAccess:
      return "StorageBuffer8BitAccess";
    case spv::Capability::UniformAndStorageBuffer8BitAccess:
      return "UniformAndStorageBuffer8BitAccess";
    case spv::Capability::StoragePushConstant8:
      return "StoragePushConstant8";
    case spv::Capability::DenormPreserve:
      return "DenormPreserve";
    case spv::Capability::DenormFlushToZero:
      return "DenormFlushToZero";
    case spv::Capability::SignedZeroInfNanPreserve:
      return "SignedZeroInfNanPreserve";
    case spv::Capability::RoundingModeRTE:
      return "RoundingModeRTE";
    case spv::Capability::RoundingModeRTZ:
      return "RoundingModeRTZ";
    case spv::Capability::RayQueryProvisionalKHR:
      return "RayQueryProvisionalKHR";
    case spv::Capability::RayQueryKHR:
      return "RayQueryKHR";
    case spv::Capability::RayTraversalPrimitiveCullingKHR:
      return "RayTraversalPrimitiveCullingKHR";
    case spv::Capability::RayTracingKHR:
      return "RayTracingKHR";
    case spv::Capability::TextureSampleWeightedQCOM:
      return "TextureSampleWeightedQCOM";
    case spv::Capability::TextureBoxFilterQCOM:
      return "TextureBoxFilterQCOM";
    case spv::Capability::TextureBlockMatchQCOM:
      return "TextureBlockMatchQCOM";
    case spv::Capability::Float16ImageAMD:
      return "Float16ImageAMD";
    case spv::Capability::ImageGatherBiasLodAMD:
      return "ImageGatherBiasLodAMD";
    case spv::Capability::FragmentMaskAMD:
      return "FragmentMaskAMD";
    case spv::Capability::StencilExportEXT:
      return "StencilExportEXT";
    case spv::Capability::ImageReadWriteLodAMD:
      return "ImageReadWriteLodAMD";
    case spv::Capability::Int64ImageEXT:
      return "Int64ImageEXT";
    case spv::Capability::ShaderClockKHR:
      return "ShaderClockKHR";
    case spv::Capability::ShaderEnqueueAMDX:
      return "ShaderEnqueueAMDX";
    case spv::Capability::SampleMaskOverrideCoverageNV:
      return "SampleMaskOverrideCoverageNV";
    case spv::Capability::GeometryShaderPassthroughNV:
      return "GeometryShaderPassthroughNV";
    case spv::Capability::ShaderViewportIndexLayerEXT:
      return "ShaderViewportIndexLayerEXT";
    case spv::Capability::ShaderViewportMaskNV:
      return "ShaderViewportMaskNV";
    case spv::Capability::ShaderStereoViewNV:
      return "ShaderStereoViewNV";
    case spv::Capability::PerViewAttributesNV:
      return "PerViewAttributesNV";
    case spv::Capability::FragmentFullyCoveredEXT:
      return "FragmentFullyCoveredEXT";
    case spv::Capability::MeshShadingNV:
      return "MeshShadingNV";
    case spv::Capability::ImageFootprintNV:
      return "ImageFootprintNV";
    case spv::Capability::MeshShadingEXT:
      return "MeshShadingEXT";
    case spv::Capability::FragmentBarycentricKHR:
      return "FragmentBarycentricKHR";
    case spv::Capability::ComputeDerivativeGroupQuadsNV:
      return "ComputeDerivativeGroupQuadsNV";
    case spv::Capability::FragmentDensityEXT:
      return "FragmentDensityEXT";
    case spv::Capability::GroupNonUniformPartitionedNV:
      return "GroupNonUniformPartitionedNV";
    case spv::Capability::ShaderNonUniform:
      return "ShaderNonUniform";
    case spv::Capability::RuntimeDescriptorArray:
      return "RuntimeDescriptorArray";
    case spv::Capability::InputAttachmentArrayDynamicIndexing:
      return "InputAttachmentArrayDynamicIndexing";
    case spv::Capability::UniformTexelBufferArrayDynamicIndexing:
      return "UniformTexelBufferArrayDynamicIndexing";
    case spv::Capability::StorageTexelBufferArrayDynamicIndexing:
      return "StorageTexelBufferArrayDynamicIndexing";
    case spv::Capability::UniformBufferArrayNonUniformIndexing:
      return "UniformBufferArrayNonUniformIndexing";
    case spv::Capability::SampledImageArrayNonUniformIndexing:
      return "SampledImageArrayNonUniformIndexing";
    case spv::Capability::StorageBufferArrayNonUniformIndexing:
      return "StorageBufferArrayNonUniformIndexing";
    case spv::Capability::StorageImageArrayNonUniformIndexing:
      return "StorageImageArrayNonUniformIndexing";
    case spv::Capability::InputAttachmentArrayNonUniformIndexing:
      return "InputAttachmentArrayNonUniformIndexing";
    case spv::Capability::UniformTexelBufferArrayNonUniformIndexing:
      return "UniformTexelBufferArrayNonUniformIndexing";
    case spv::Capability::StorageTexelBufferArrayNonUniformIndexing:
      return "StorageTexelBufferArrayNonUniformIndexing";
    case spv::Capability::RayTracingPositionFetchKHR:
      return "RayTracingPositionFetchKHR";
    case spv::Capability::RayTracingNV:
      return "RayTracingNV";
    case spv::Capability::RayTracingMotionBlurNV:
      return "RayTracingMotionBlurNV";
    case spv::Capability::VulkanMemoryModel:
      return "VulkanMemoryModel";
    case spv::Capability::VulkanMemoryModelDeviceScope:
      return "VulkanMemoryModelDeviceScope";
    case spv::Capability::PhysicalStorageBufferAddresses:
      return "PhysicalStorageBufferAddresses";
    case spv::Capability::ComputeDerivativeGroupLinearNV:
      return "ComputeDerivativeGroupLinearNV";
    case spv::Capability::RayTracingProvisionalKHR:
      return "RayTracingProvisionalKHR";
    case spv::Capability::CooperativeMatrixNV:
      return "CooperativeMatrixNV";
    case spv::Capability::FragmentShaderSampleInterlockEXT:
      return "FragmentShaderSampleInterlockEXT";
    case spv::Capability::FragmentShaderShadingRateInterlockEXT:
      return "FragmentShaderShadingRateInterlockEXT";
    case spv::Capability::ShaderSMBuiltinsNV:
      return "ShaderSMBuiltinsNV";
    case spv::Capability::FragmentShaderPixelInterlockEXT:
      return "FragmentShaderPixelInterlockEXT";
    case spv::Capability::DemoteToHelperInvocation:
      return "DemoteToHelperInvocation";
    case spv::Capability::DisplacementMicromapNV:
      return "DisplacementMicromapNV";
    case spv::Capability::RayTracingOpacityMicromapEXT:
      return "RayTracingOpacityMicromapEXT";
    case spv::Capability::ShaderInvocationReorderNV:
      return "ShaderInvocationReorderNV";
    case spv::Capability::BindlessTextureNV:
      return "BindlessTextureNV";
    case spv::Capability::RayQueryPositionFetchKHR:
      return "RayQueryPositionFetchKHR";
    case spv::Capability::RayTracingDisplacementMicromapNV:
      return "RayTracingDisplacementMicromapNV";
    case spv::Capability::SubgroupShuffleINTEL:
      return "SubgroupShuffleINTEL";
    case spv::Capability::SubgroupBufferBlockIOINTEL:
      return "SubgroupBufferBlockIOINTEL";
    case spv::Capability::SubgroupImageBlockIOINTEL:
      return "SubgroupImageBlockIOINTEL";
    case spv::Capability::SubgroupImageMediaBlockIOINTEL:
      return "SubgroupImageMediaBlockIOINTEL";
    case spv::Capability::RoundToInfinityINTEL:
      return "RoundToInfinityINTEL";
    case spv::Capability::FloatingPointModeINTEL:
      return "FloatingPointModeINTEL";
    case spv::Capability::IntegerFunctions2INTEL:
      return "IntegerFunctions2INTEL";
    case spv::Capability::FunctionPointersINTEL:
      return "FunctionPointersINTEL";
    case spv::Capability::IndirectReferencesINTEL:
      return "IndirectReferencesINTEL";
    case spv::Capability::AsmINTEL:
      return "AsmINTEL";
    case spv::Capability::AtomicFloat32MinMaxEXT:
      return "AtomicFloat32MinMaxEXT";
    case spv::Capability::AtomicFloat64MinMaxEXT:
      return "AtomicFloat64MinMaxEXT";
    case spv::Capability::AtomicFloat16MinMaxEXT:
      return "AtomicFloat16MinMaxEXT";
    case spv::Capability::VectorComputeINTEL:
      return "VectorComputeINTEL";
    case spv::Capability::VectorAnyINTEL:
      return "VectorAnyINTEL";
    case spv::Capability::ExpectAssumeKHR:
      return "ExpectAssumeKHR";
    case spv::Capability::SubgroupAvcMotionEstimationINTEL:
      return "SubgroupAvcMotionEstimationINTEL";
    case spv::Capability::SubgroupAvcMotionEstimationIntraINTEL:
      return "SubgroupAvcMotionEstimationIntraINTEL";
    case spv::Capability::SubgroupAvcMotionEstimationChromaINTEL:
      return "SubgroupAvcMotionEstimationChromaINTEL";
    case spv::Capability::VariableLengthArrayINTEL:
      return "VariableLengthArrayINTEL";
    case spv::Capability::FunctionFloatControlINTEL:
      return "FunctionFloatControlINTEL";
    case spv::Capability::FPGAMemoryAttributesINTEL:
      return "FPGAMemoryAttributesINTEL";
    case spv::Capability::FPFastMathModeINTEL:
      return "FPFastMathModeINTEL";
    case spv::Capability::ArbitraryPrecisionIntegersINTEL:
      return "ArbitraryPrecisionIntegersINTEL";
    case spv::Capability::ArbitraryPrecisionFloatingPointINTEL:
      return "ArbitraryPrecisionFloatingPointINTEL";
    case spv::Capability::UnstructuredLoopControlsINTEL:
      return "UnstructuredLoopControlsINTEL";
    case spv::Capability::FPGALoopControlsINTEL:
      return "FPGALoopControlsINTEL";
    case spv::Capability::KernelAttributesINTEL:
      return "KernelAttributesINTEL";
    case spv::Capability::FPGAKernelAttributesINTEL:
      return "FPGAKernelAttributesINTEL";
    case spv::Capability::FPGAMemoryAccessesINTEL:
      return "FPGAMemoryAccessesINTEL";
    case spv::Capability::FPGAClusterAttributesINTEL:
      return "FPGAClusterAttributesINTEL";
    case spv::Capability::LoopFuseINTEL:
      return "LoopFuseINTEL";
    case spv::Capability::FPGADSPControlINTEL:
      return "FPGADSPControlINTEL";
    case spv::Capability::MemoryAccessAliasingINTEL:
      return "MemoryAccessAliasingINTEL";
    case spv::Capability::FPGAInvocationPipeliningAttributesINTEL:
      return "FPGAInvocationPipeliningAttributesINTEL";
    case spv::Capability::FPGABufferLocationINTEL:
      return "FPGABufferLocationINTEL";
    case spv::Capability::ArbitraryPrecisionFixedPointINTEL:
      return "ArbitraryPrecisionFixedPointINTEL";
    case spv::Capability::USMStorageClassesINTEL:
      return "USMStorageClassesINTEL";
    case spv::Capability::RuntimeAlignedAttributeINTEL:
      return "RuntimeAlignedAttributeINTEL";
    case spv::Capability::IOPipesINTEL:
      return "IOPipesINTEL";
    case spv::Capability::BlockingPipesINTEL:
      return "BlockingPipesINTEL";
    case spv::Capability::FPGARegINTEL:
      return "FPGARegINTEL";
    case spv::Capability::DotProductInputAll:
      return "DotProductInputAll";
    case spv::Capability::DotProductInput4x8Bit:
      return "DotProductInput4x8Bit";
    case spv::Capability::DotProductInput4x8BitPacked:
      return "DotProductInput4x8BitPacked";
    case spv::Capability::DotProduct:
      return "DotProduct";
    case spv::Capability::RayCullMaskKHR:
      return "RayCullMaskKHR";
    case spv::Capability::CooperativeMatrixKHR:
      return "CooperativeMatrixKHR";
    case spv::Capability::BitInstructions:
      return "BitInstructions";
    case spv::Capability::GroupNonUniformRotateKHR:
      return "GroupNonUniformRotateKHR";
    case spv::Capability::AtomicFloat32AddEXT:
      return "AtomicFloat32AddEXT";
    case spv::Capability::AtomicFloat64AddEXT:
      return "AtomicFloat64AddEXT";
    case spv::Capability::LongCompositesINTEL:
      return "LongCompositesINTEL";
    case spv::Capability::OptNoneINTEL:
      return "OptNoneINTEL";
    case spv::Capability::AtomicFloat16AddEXT:
      return "AtomicFloat16AddEXT";
    case spv::Capability::DebugInfoModuleINTEL:
      return "DebugInfoModuleINTEL";
    case spv::Capability::BFloat16ConversionINTEL:
      return "BFloat16ConversionINTEL";
    case spv::Capability::SplitBarrierINTEL:
      return "SplitBarrierINTEL";
    case spv::Capability::FPGAClusterAttributesV2INTEL:
      return "FPGAClusterAttributesV2INTEL";
    case spv::Capability::FPGAKernelAttributesv2INTEL:
      return "FPGAKernelAttributesv2INTEL";
    case spv::Capability::FPMaxErrorINTEL:
      return "FPMaxErrorINTEL";
    case spv::Capability::FPGALatencyControlINTEL:
      return "FPGALatencyControlINTEL";
    case spv::Capability::FPGAArgumentInterfacesINTEL:
      return "FPGAArgumentInterfacesINTEL";
    case spv::Capability::GlobalVariableHostAccessINTEL:
      return "GlobalVariableHostAccessINTEL";
    case spv::Capability::GlobalVariableFPGADecorationsINTEL:
      return "GlobalVariableFPGADecorationsINTEL";
    case spv::Capability::GroupUniformArithmeticKHR:
      return "GroupUniformArithmeticKHR";
    case spv::Capability::CacheControlsINTEL:
      return "CacheControlsINTEL";
    case spv::Capability::Max:
      assert(0 && "Attempting to convert spv::Capability::Max to string");
      return "";
  }

  return "";
}