MLN_LAYER_PLUGIN_HEADERS = [
    "src/mbgl/plugin/plugin_layer.hpp",
    "src/mbgl/plugin/plugin_layer_factory.hpp",
    "src/mbgl/plugin/plugin_layer_impl.hpp",
    "src/mbgl/plugin/plugin_layer_render.hpp",
    "src/mbgl/plugin/plugin_layer_properties.hpp",
]

MLN_LAYER_PLUGIN_SOURCE = [
    "src/mbgl/plugin/plugin_layer.cpp",
    "src/mbgl/plugin/plugin_layer_factory.cpp",
    "src/mbgl/plugin/plugin_layer_impl.cpp",
    "src/mbgl/plugin/plugin_layer_render.cpp",
    "src/mbgl/plugin/plugin_layer_properties.cpp",
]

MLN_PUBLIC_GENERATED_STYLE_HEADERS = [
    "include/mbgl/style/layers/circle_layer.hpp",
    "include/mbgl/style/layers/fill_layer.hpp",
    "include/mbgl/style/layers/line_layer.hpp",
    "include/mbgl/style/layers/symbol_layer.hpp",
    "include/mbgl/style/layers/heatmap_layer.hpp",
    "include/mbgl/style/layers/fill_extrusion_layer.hpp",
    "include/mbgl/style/layers/raster_layer.hpp",
    "include/mbgl/style/layers/hillshade_layer.hpp",
    "include/mbgl/style/layers/background_layer.hpp",
    "include/mbgl/style/layers/location_indicator_layer.hpp",
    "include/mbgl/style/light.hpp",
]

MLN_PRIVATE_GENERATED_STYLE_HEADERS = [
    "src/mbgl/style/layers/fill_layer_properties.hpp",
    "src/mbgl/style/layers/line_layer_properties.hpp",
    "src/mbgl/style/layers/symbol_layer_properties.hpp",
    "src/mbgl/style/layers/circle_layer_properties.hpp",
    "src/mbgl/style/layers/heatmap_layer_properties.hpp",
    "src/mbgl/style/layers/fill_extrusion_layer_properties.hpp",
    "src/mbgl/style/layers/raster_layer_properties.hpp",
    "src/mbgl/style/layers/hillshade_layer_properties.hpp",
    "src/mbgl/style/layers/background_layer_properties.hpp",
    "src/mbgl/style/layers/location_indicator_layer_properties.hpp",
]

MLN_GENERATED_STYLE_SOURCE = [
    "src/mbgl/style/layers/fill_layer_properties.cpp",
    "src/mbgl/style/layers/fill_layer.cpp",
    "src/mbgl/style/layers/line_layer_properties.cpp",
    "src/mbgl/style/layers/line_layer.cpp",
    "src/mbgl/style/layers/symbol_layer_properties.cpp",
    "src/mbgl/style/layers/symbol_layer.cpp",
    "src/mbgl/style/layers/circle_layer_properties.cpp",
    "src/mbgl/style/layers/circle_layer.cpp",
    "src/mbgl/style/layers/heatmap_layer_properties.cpp",
    "src/mbgl/style/layers/heatmap_layer.cpp",
    "src/mbgl/style/layers/fill_extrusion_layer_properties.cpp",
    "src/mbgl/style/layers/fill_extrusion_layer.cpp",
    "src/mbgl/style/layers/raster_layer_properties.cpp",
    "src/mbgl/style/layers/raster_layer.cpp",
    "src/mbgl/style/layers/hillshade_layer_properties.cpp",
    "src/mbgl/style/layers/hillshade_layer.cpp",
    "src/mbgl/style/layers/background_layer_properties.cpp",
    "src/mbgl/style/layers/background_layer.cpp",
    "src/mbgl/style/layers/location_indicator_layer_properties.cpp",
    "src/mbgl/style/layers/location_indicator_layer.cpp",
    "src/mbgl/style/light.cpp",
]

MLN_GENERATED_SHADER_HEADERS = [
    "include/mbgl/shaders/shader_source.hpp",
    "include/mbgl/shaders/shader_manifest.hpp",
]

MLN_GENERATED_SHADER_SOURCE = [
    "src/mbgl/shaders/shader_source.cpp",
]

MLN_GENERATED_OPENGL_SHADER_HEADERS = [
    "include/mbgl/shaders/gl/background.hpp",
    "include/mbgl/shaders/gl/background_pattern.hpp",
    "include/mbgl/shaders/gl/circle.hpp",
    "include/mbgl/shaders/gl/clipping_mask.hpp",
    "include/mbgl/shaders/gl/collision_box.hpp",
    "include/mbgl/shaders/gl/collision_circle.hpp",
    "include/mbgl/shaders/gl/custom_geometry.hpp",
    "include/mbgl/shaders/gl/custom_symbol_icon.hpp",
    "include/mbgl/shaders/gl/debug.hpp",
    "include/mbgl/shaders/gl/fill.hpp",
    "include/mbgl/shaders/gl/fill_outline.hpp",
    "include/mbgl/shaders/gl/fill_pattern.hpp",
    "include/mbgl/shaders/gl/fill_outline_pattern.hpp",
    "include/mbgl/shaders/gl/fill_outline_triangulated.hpp",
    "include/mbgl/shaders/gl/fill_extrusion.hpp",
    "include/mbgl/shaders/gl/fill_extrusion_pattern.hpp",
    "include/mbgl/shaders/gl/heatmap.hpp",
    "include/mbgl/shaders/gl/heatmap_texture.hpp",
    "include/mbgl/shaders/gl/hillshade_prepare.hpp",
    "include/mbgl/shaders/gl/hillshade.hpp",
    "include/mbgl/shaders/gl/line_gradient.hpp",
    "include/mbgl/shaders/gl/line_pattern.hpp",
    "include/mbgl/shaders/gl/line_sdf.hpp",
    "include/mbgl/shaders/gl/line.hpp",
    "include/mbgl/shaders/gl/location_indicator.hpp",
    "include/mbgl/shaders/gl/location_indicator_textured.hpp",
    "include/mbgl/shaders/gl/raster.hpp",
    "include/mbgl/shaders/gl/symbol_icon.hpp",
    "include/mbgl/shaders/gl/symbol_sdf.hpp",
    "include/mbgl/shaders/gl/symbol_text_and_icon.hpp",
    "include/mbgl/shaders/gl/wide_vector.hpp",
    "include/mbgl/shaders/gl/prelude.hpp",
]

MLN_CORE_SOURCE = [
    "src/mbgl/actor/mailbox.cpp",
    "src/mbgl/actor/scheduler.cpp",
    "src/mbgl/algorithm/update_renderables.hpp",
    "src/mbgl/algorithm/update_tile_masks.hpp",
    "src/mbgl/annotation/annotation_manager.cpp",
    "src/mbgl/annotation/annotation_manager.hpp",
    "src/mbgl/annotation/annotation_source.cpp",
    "src/mbgl/annotation/annotation_source.hpp",
    "src/mbgl/annotation/annotation_tile.cpp",
    "src/mbgl/annotation/annotation_tile.hpp",
    "src/mbgl/annotation/fill_annotation_impl.cpp",
    "src/mbgl/annotation/fill_annotation_impl.hpp",
    "src/mbgl/annotation/line_annotation_impl.cpp",
    "src/mbgl/annotation/line_annotation_impl.hpp",
    "src/mbgl/annotation/render_annotation_source.cpp",
    "src/mbgl/annotation/render_annotation_source.hpp",
    "src/mbgl/annotation/shape_annotation_impl.cpp",
    "src/mbgl/annotation/shape_annotation_impl.hpp",
    "src/mbgl/annotation/symbol_annotation_impl.cpp",
    "src/mbgl/annotation/symbol_annotation_impl.hpp",
    "src/mbgl/geometry/anchor.hpp",
    "src/mbgl/geometry/debug_font_data.hpp",
    "src/mbgl/geometry/dem_data.cpp",
    "src/mbgl/geometry/dem_data.hpp",
    "src/mbgl/geometry/feature_index.cpp",
    "src/mbgl/geometry/feature_index.hpp",
    "src/mbgl/geometry/line_atlas.cpp",
    "src/mbgl/geometry/line_atlas.hpp",
    "src/mbgl/gfx/attribute.cpp",
    "src/mbgl/gfx/attribute.hpp",
    "src/mbgl/gfx/cull_face_mode.hpp",
    "src/mbgl/gfx/fill_generator.cpp",
    "src/mbgl/gfx/index_buffer.hpp",
    "src/mbgl/gfx/index_vector.hpp",
    "src/mbgl/gfx/offscreen_texture.hpp",
    "src/mbgl/gfx/polyline_generator.cpp",
    "src/mbgl/gfx/render_pass.hpp",
    "src/mbgl/gfx/renderer_backend.cpp",
    "src/mbgl/gfx/rendering_stats.cpp",
    "src/mbgl/gfx/shader_registry.cpp",
    "src/mbgl/gfx/shader_group.cpp",
    "src/mbgl/gfx/uniform.hpp",
    "src/mbgl/gfx/upload_pass.hpp",
    "src/mbgl/gfx/vertex_vector.hpp",
    "src/mbgl/layermanager/background_layer_factory.cpp",
    "src/mbgl/layermanager/circle_layer_factory.cpp",
    "src/mbgl/layermanager/custom_layer_factory.cpp",
    "src/mbgl/layermanager/fill_extrusion_layer_factory.cpp",
    "src/mbgl/layermanager/fill_layer_factory.cpp",
    "src/mbgl/layermanager/heatmap_layer_factory.cpp",
    "src/mbgl/layermanager/hillshade_layer_factory.cpp",
    "src/mbgl/layermanager/layer_factory.cpp",
    "src/mbgl/layermanager/layer_manager.cpp",
    "src/mbgl/layermanager/line_layer_factory.cpp",
    "src/mbgl/layermanager/location_indicator_layer_factory.cpp",
    "src/mbgl/layermanager/raster_layer_factory.cpp",
    "src/mbgl/layermanager/symbol_layer_factory.cpp",
    "src/mbgl/layout/circle_layout.hpp",
    "src/mbgl/layout/clip_lines.cpp",
    "src/mbgl/layout/clip_lines.hpp",
    "src/mbgl/layout/layout.hpp",
    "src/mbgl/layout/merge_lines.cpp",
    "src/mbgl/layout/merge_lines.hpp",
    "src/mbgl/layout/pattern_layout.hpp",
    "src/mbgl/layout/symbol_feature.hpp",
    "src/mbgl/layout/symbol_instance.cpp",
    "src/mbgl/layout/symbol_instance.hpp",
    "src/mbgl/layout/symbol_layout.cpp",
    "src/mbgl/layout/symbol_layout.hpp",
    "src/mbgl/layout/symbol_projection.cpp",
    "src/mbgl/layout/symbol_projection.hpp",
    "src/mbgl/map/map.cpp",
    "src/mbgl/map/map_impl.cpp",
    "src/mbgl/map/map_impl.hpp",
    "src/mbgl/map/map_options.cpp",
    "src/mbgl/map/map_projection.cpp",
    "src/mbgl/map/transform.cpp",
    "src/mbgl/map/transform.hpp",
    "src/mbgl/map/transform_state.cpp",
    "src/mbgl/map/transform_state.hpp",
    "src/mbgl/map/zoom_history.hpp",
    "src/mbgl/math/log2.cpp",
    "src/mbgl/platform/settings.cpp",
    "src/mbgl/renderer/backend_scope.cpp",
    "src/mbgl/renderer/bucket.hpp",
    "src/mbgl/renderer/bucket_parameters.cpp",
    "src/mbgl/renderer/bucket_parameters.hpp",
    "src/mbgl/renderer/buckets/circle_bucket.cpp",
    "src/mbgl/renderer/buckets/circle_bucket.hpp",
    "src/mbgl/renderer/buckets/debug_bucket.cpp",
    "src/mbgl/renderer/buckets/debug_bucket.hpp",
    "src/mbgl/renderer/buckets/fill_bucket.cpp",
    "src/mbgl/renderer/buckets/fill_bucket.hpp",
    "src/mbgl/renderer/buckets/fill_extrusion_bucket.cpp",
    "src/mbgl/renderer/buckets/fill_extrusion_bucket.hpp",
    "src/mbgl/renderer/buckets/heatmap_bucket.cpp",
    "src/mbgl/renderer/buckets/heatmap_bucket.hpp",
    "src/mbgl/renderer/buckets/hillshade_bucket.cpp",
    "src/mbgl/renderer/buckets/hillshade_bucket.hpp",
    "src/mbgl/renderer/buckets/line_bucket.cpp",
    "src/mbgl/renderer/buckets/line_bucket.hpp",
    "src/mbgl/renderer/buckets/raster_bucket.cpp",
    "src/mbgl/renderer/buckets/raster_bucket.hpp",
    "src/mbgl/renderer/buckets/symbol_bucket.cpp",
    "src/mbgl/renderer/buckets/symbol_bucket.hpp",
    "src/mbgl/renderer/cross_faded_property_evaluator.cpp",
    "src/mbgl/renderer/cross_faded_property_evaluator.hpp",
    "src/mbgl/renderer/data_driven_property_evaluator.hpp",
    "src/mbgl/renderer/group_by_layout.cpp",
    "src/mbgl/renderer/group_by_layout.hpp",
    "src/mbgl/renderer/image_manager.cpp",
    "src/mbgl/renderer/image_manager.hpp",
    "src/mbgl/renderer/image_manager_observer.hpp",
    "src/mbgl/renderer/layers/render_background_layer.cpp",
    "src/mbgl/renderer/layers/render_background_layer.hpp",
    "src/mbgl/renderer/layers/render_circle_layer.cpp",
    "src/mbgl/renderer/layers/render_circle_layer.hpp",
    "src/mbgl/renderer/layers/render_custom_layer.cpp",
    "src/mbgl/renderer/layers/render_custom_layer.hpp",
    "src/mbgl/renderer/layers/render_fill_extrusion_layer.cpp",
    "src/mbgl/renderer/layers/render_fill_extrusion_layer.hpp",
    "src/mbgl/renderer/layers/render_fill_layer.cpp",
    "src/mbgl/renderer/layers/render_fill_layer.hpp",
    "src/mbgl/renderer/layers/render_heatmap_layer.cpp",
    "src/mbgl/renderer/layers/render_heatmap_layer.hpp",
    "src/mbgl/renderer/layers/render_hillshade_layer.cpp",
    "src/mbgl/renderer/layers/render_hillshade_layer.hpp",
    "src/mbgl/renderer/layers/render_line_layer.cpp",
    "src/mbgl/renderer/layers/render_line_layer.hpp",
    "src/mbgl/renderer/layers/render_location_indicator_layer.cpp",
    "src/mbgl/renderer/layers/render_location_indicator_layer.hpp",
    "src/mbgl/renderer/layers/render_raster_layer.cpp",
    "src/mbgl/renderer/layers/render_raster_layer.hpp",
    "src/mbgl/renderer/layers/render_symbol_layer.cpp",
    "src/mbgl/renderer/layers/render_symbol_layer.hpp",
    "src/mbgl/renderer/paint_parameters.cpp",
    "src/mbgl/renderer/paint_parameters.hpp",
    "src/mbgl/renderer/paint_property_binder.hpp",
    "src/mbgl/renderer/paint_property_statistics.hpp",
    "src/mbgl/renderer/pattern_atlas.cpp",
    "src/mbgl/renderer/pattern_atlas.hpp",
    "src/mbgl/renderer/possibly_evaluated_property_value.hpp",
    "src/mbgl/renderer/property_evaluation_parameters.hpp",
    "src/mbgl/renderer/property_evaluator.hpp",
    "src/mbgl/renderer/render_layer.cpp",
    "src/mbgl/renderer/render_layer.hpp",
    "src/mbgl/renderer/render_light.cpp",
    "src/mbgl/renderer/render_light.hpp",
    "src/mbgl/renderer/render_orchestrator.cpp",
    "src/mbgl/renderer/render_orchestrator.hpp",
    "src/mbgl/renderer/render_pass.hpp",
    "src/mbgl/renderer/render_source.cpp",
    "src/mbgl/renderer/render_source.hpp",
    "src/mbgl/renderer/render_source_observer.hpp",
    "src/mbgl/renderer/render_static_data.cpp",
    "src/mbgl/renderer/render_static_data.hpp",
    "src/mbgl/renderer/render_tile.cpp",
    "src/mbgl/renderer/render_tile.hpp",
    "src/mbgl/renderer/render_tree.hpp",
    "src/mbgl/renderer/renderer.cpp",
    "src/mbgl/renderer/renderer_impl.cpp",
    "src/mbgl/renderer/renderer_impl.hpp",
    "src/mbgl/renderer/renderer_state.cpp",
    "src/mbgl/renderer/sources/render_custom_geometry_source.cpp",
    "src/mbgl/renderer/sources/render_custom_geometry_source.hpp",
    "src/mbgl/renderer/sources/render_geojson_source.cpp",
    "src/mbgl/renderer/sources/render_geojson_source.hpp",
    "src/mbgl/renderer/sources/render_image_source.cpp",
    "src/mbgl/renderer/sources/render_image_source.hpp",
    "src/mbgl/renderer/sources/render_raster_dem_source.cpp",
    "src/mbgl/renderer/sources/render_raster_dem_source.hpp",
    "src/mbgl/renderer/sources/render_raster_source.cpp",
    "src/mbgl/renderer/sources/render_raster_source.hpp",
    "src/mbgl/renderer/sources/render_tile_source.cpp",
    "src/mbgl/renderer/sources/render_tile_source.hpp",
    "src/mbgl/renderer/sources/render_vector_source.cpp",
    "src/mbgl/renderer/sources/render_vector_source.hpp",
    "src/mbgl/renderer/source_state.cpp",
    "src/mbgl/renderer/source_state.hpp",
    "src/mbgl/renderer/style_diff.cpp",
    "src/mbgl/renderer/style_diff.hpp",
    "src/mbgl/renderer/tile_mask.hpp",
    "src/mbgl/renderer/tile_parameters.hpp",
    "src/mbgl/renderer/tile_pyramid.cpp",
    "src/mbgl/renderer/tile_pyramid.hpp",
    "src/mbgl/renderer/tile_render_data.cpp",
    "src/mbgl/renderer/tile_render_data.hpp",
    "src/mbgl/renderer/transition_parameters.hpp",
    "src/mbgl/renderer/update_parameters.hpp",
    "src/mbgl/renderer/upload_parameters.hpp",
    "src/mbgl/shaders/attributes.hpp",
    "src/mbgl/shaders/program_parameters.cpp",
    "src/mbgl/shaders/segment.hpp",
    "src/mbgl/shaders/uniforms.hpp",
    "src/mbgl/sprite/sprite_loader.cpp",
    "src/mbgl/sprite/sprite_loader.hpp",
    "src/mbgl/sprite/sprite_loader_observer.hpp",
    "src/mbgl/sprite/sprite_parser.cpp",
    "src/mbgl/sprite/sprite_parser.hpp",
    "src/mbgl/storage/asset_file_source.hpp",
    "src/mbgl/storage/mbtiles_file_source.hpp",
    "src/mbgl/storage/file_source_manager.cpp",
    "src/mbgl/storage/http_file_source.hpp",
    "src/mbgl/storage/local_file_source.hpp",
    "src/mbgl/storage/main_resource_loader.hpp",
    "src/mbgl/storage/network_status.cpp",
    "src/mbgl/storage/pmtiles_file_source.hpp",
    "src/mbgl/storage/resource.cpp",
    "src/mbgl/storage/resource_options.cpp",
    "src/mbgl/storage/resource_transform.cpp",
    "src/mbgl/storage/response.cpp",
    "src/mbgl/style/collection.hpp",
    "src/mbgl/style/conversion/color_ramp_property_value.cpp",
    "src/mbgl/style/conversion/constant.cpp",
    "src/mbgl/style/conversion/coordinate.cpp",
    "src/mbgl/style/conversion/custom_geometry_source_options.cpp",
    "src/mbgl/style/conversion/filter.cpp",
    "src/mbgl/style/conversion/function.cpp",
    "src/mbgl/style/conversion/geojson.cpp",
    "src/mbgl/style/conversion/geojson_options.cpp",
    "src/mbgl/style/conversion/get_json_type.cpp",
    "src/mbgl/style/conversion/json.hpp",
    "src/mbgl/style/conversion/layer.cpp",
    "src/mbgl/style/conversion/light.cpp",
    "src/mbgl/style/conversion/position.cpp",
    "src/mbgl/style/conversion/property_value.cpp",
    "src/mbgl/style/conversion/raster_dem_options.cpp",
    "src/mbgl/style/conversion/rotation.cpp",
    "src/mbgl/style/conversion/source.cpp",
    "src/mbgl/style/conversion/stringify.hpp",
    "src/mbgl/style/conversion/tileset.cpp",
    "src/mbgl/style/conversion/transition_options.cpp",
    "src/mbgl/style/conversion/sprite.hpp",
    "src/mbgl/style/conversion/sprite.cpp",
    "src/mbgl/style/custom_tile_loader.cpp",
    "src/mbgl/style/custom_tile_loader.hpp",
    "src/mbgl/style/expression/assertion.cpp",
    "src/mbgl/style/expression/at.cpp",
    "src/mbgl/style/expression/boolean_operator.cpp",
    "src/mbgl/style/expression/case.cpp",
    "src/mbgl/style/expression/check_subtype.cpp",
    "src/mbgl/style/expression/coalesce.cpp",
    "src/mbgl/style/expression/coercion.cpp",
    "src/mbgl/style/expression/collator.cpp",
    "src/mbgl/style/expression/collator_expression.cpp",
    "src/mbgl/style/expression/comparison.cpp",
    "src/mbgl/style/expression/compound_expression.cpp",
    "src/mbgl/style/expression/distance.cpp",
    "src/mbgl/style/expression/dsl.cpp",
    "src/mbgl/style/expression/dsl_impl.hpp",
    "src/mbgl/style/expression/expression.cpp",
    "src/mbgl/style/expression/find_zoom_curve.cpp",
    "src/mbgl/style/expression/format_expression.cpp",
    "src/mbgl/style/expression/formatted.cpp",
    "src/mbgl/style/expression/get_covering_stops.cpp",
    "src/mbgl/style/expression/image.cpp",
    "src/mbgl/style/expression/image_expression.cpp",
    "src/mbgl/style/expression/in.cpp",
    "src/mbgl/style/expression/index_of.cpp",
    "src/mbgl/style/expression/interpolate.cpp",
    "src/mbgl/style/expression/is_constant.cpp",
    "src/mbgl/style/expression/is_expression.cpp",
    "src/mbgl/style/expression/length.cpp",
    "src/mbgl/style/expression/let.cpp",
    "src/mbgl/style/expression/literal.cpp",
    "src/mbgl/style/expression/match.cpp",
    "src/mbgl/style/expression/number_format.cpp",
    "src/mbgl/style/expression/parsing_context.cpp",
    "src/mbgl/style/expression/slice.cpp",
    "src/mbgl/style/expression/step.cpp",
    "src/mbgl/style/expression/util.cpp",
    "src/mbgl/style/expression/util.hpp",
    "src/mbgl/style/expression/value.cpp",
    "src/mbgl/style/expression/within.cpp",
    "src/mbgl/style/filter.cpp",
    "src/mbgl/style/sprite.cpp",
    "src/mbgl/style/image.cpp",
    "src/mbgl/style/image_impl.cpp",
    "src/mbgl/style/image_impl.hpp",
    "src/mbgl/style/layer.cpp",
    "src/mbgl/style/layer_impl.cpp",
    "src/mbgl/style/layer_impl.hpp",
    "src/mbgl/style/layer_observer.hpp",
    "src/mbgl/style/layers/background_layer_impl.cpp",
    "src/mbgl/style/layers/background_layer_impl.hpp",
    "src/mbgl/style/layers/circle_layer_impl.cpp",
    "src/mbgl/style/layers/circle_layer_impl.hpp",
    "src/mbgl/style/layers/custom_layer.cpp",
    "src/mbgl/style/layers/custom_layer_render_parameters.cpp",
    "src/mbgl/style/layers/custom_layer_impl.cpp",
    "src/mbgl/style/layers/custom_layer_impl.hpp",
    "src/mbgl/style/layers/fill_extrusion_layer_impl.cpp",
    "src/mbgl/style/layers/fill_extrusion_layer_impl.hpp",
    "src/mbgl/style/layers/fill_layer_impl.cpp",
    "src/mbgl/style/layers/fill_layer_impl.hpp",
    "src/mbgl/style/layers/heatmap_layer_impl.cpp",
    "src/mbgl/style/layers/heatmap_layer_impl.hpp",
    "src/mbgl/style/layers/hillshade_layer_impl.cpp",
    "src/mbgl/style/layers/hillshade_layer_impl.hpp",
    "src/mbgl/style/layers/line_layer_impl.cpp",
    "src/mbgl/style/layers/line_layer_impl.hpp",
    "src/mbgl/style/layers/location_indicator_layer_impl.cpp",
    "src/mbgl/style/layers/location_indicator_layer_impl.hpp",
    "src/mbgl/style/layers/raster_layer_impl.cpp",
    "src/mbgl/style/layers/raster_layer_impl.hpp",
    "src/mbgl/style/layers/symbol_layer_impl.cpp",
    "src/mbgl/style/layers/symbol_layer_impl.hpp",
    "src/mbgl/style/layout_property.hpp",
    "src/mbgl/style/light_impl.cpp",
    "src/mbgl/style/light_impl.hpp",
    "src/mbgl/style/light_observer.hpp",
    "src/mbgl/style/observer.hpp",
    "src/mbgl/style/paint_property.hpp",
    "src/mbgl/style/parser.cpp",
    "src/mbgl/style/parser.hpp",
    "src/mbgl/style/properties.hpp",
    "src/mbgl/style/property_expression.cpp",
    "src/mbgl/style/rapidjson_conversion.hpp",
    "src/mbgl/style/source.cpp",
    "src/mbgl/style/source_impl.cpp",
    "src/mbgl/style/source_impl.hpp",
    "src/mbgl/style/source_observer.hpp",
    "src/mbgl/style/sources/custom_geometry_source.cpp",
    "src/mbgl/style/sources/custom_geometry_source_impl.cpp",
    "src/mbgl/style/sources/custom_geometry_source_impl.hpp",
    "src/mbgl/style/sources/geojson_source.cpp",
    "src/mbgl/style/sources/geojson_source_impl.cpp",
    "src/mbgl/style/sources/geojson_source_impl.hpp",
    "src/mbgl/style/sources/image_source.cpp",
    "src/mbgl/style/sources/image_source_impl.cpp",
    "src/mbgl/style/sources/image_source_impl.hpp",
    "src/mbgl/style/sources/raster_dem_source.cpp",
    "src/mbgl/style/sources/tile_source.cpp",
    "src/mbgl/style/sources/raster_source.cpp",
    "src/mbgl/style/sources/tile_source_impl.cpp",
    "src/mbgl/style/sources/tile_source_impl.hpp",
    "src/mbgl/style/sources/vector_source.cpp",
    "src/mbgl/style/style.cpp",
    "src/mbgl/style/style_impl.cpp",
    "src/mbgl/style/style_impl.hpp",
    "src/mbgl/style/types.cpp",
    "src/mbgl/style/variable_anchor_offset_collection.cpp",
    "src/mbgl/text/bidi.hpp",
    "src/mbgl/text/check_max_angle.cpp",
    "src/mbgl/text/check_max_angle.hpp",
    "src/mbgl/text/collision_feature.cpp",
    "src/mbgl/text/collision_feature.hpp",
    "src/mbgl/text/collision_index.cpp",
    "src/mbgl/text/collision_index.hpp",
    "src/mbgl/text/cross_tile_symbol_index.cpp",
    "src/mbgl/text/cross_tile_symbol_index.hpp",
    "src/mbgl/text/get_anchors.cpp",
    "src/mbgl/text/get_anchors.hpp",
    "src/mbgl/text/glyph.cpp",
    "src/mbgl/text/glyph_manager.cpp",
    "src/mbgl/text/glyph_manager.hpp",
    "src/mbgl/text/glyph_manager_observer.hpp",
    "src/mbgl/text/glyph_pbf.cpp",
    "src/mbgl/text/glyph_pbf.hpp",
    "src/mbgl/text/language_tag.cpp",
    "src/mbgl/text/language_tag.hpp",
    "src/mbgl/text/local_glyph_rasterizer.hpp",
    "src/mbgl/text/placement.cpp",
    "src/mbgl/text/placement.hpp",
    "src/mbgl/text/quads.cpp",
    "src/mbgl/text/quads.hpp",
    "src/mbgl/text/shaping.cpp",
    "src/mbgl/text/shaping.hpp",
    "src/mbgl/text/tagged_string.cpp",
    "src/mbgl/text/tagged_string.hpp",
    "src/mbgl/text/harfbuzz.cpp",
    "src/mbgl/text/harfbuzz.hpp",
    "src/mbgl/tile/custom_geometry_tile.cpp",
    "src/mbgl/tile/custom_geometry_tile.hpp",
    "src/mbgl/tile/geojson_tile.cpp",
    "src/mbgl/tile/geojson_tile.hpp",
    "src/mbgl/tile/geojson_tile_data.hpp",
    "src/mbgl/tile/geometry_tile.cpp",
    "src/mbgl/tile/geometry_tile.hpp",
    "src/mbgl/tile/geometry_tile_data.cpp",
    "src/mbgl/tile/geometry_tile_data.hpp",
    "src/mbgl/tile/geometry_tile_worker.cpp",
    "src/mbgl/tile/geometry_tile_worker.hpp",
    "src/mbgl/tile/raster_dem_tile.cpp",
    "src/mbgl/tile/raster_dem_tile.hpp",
    "src/mbgl/tile/raster_dem_tile_worker.cpp",
    "src/mbgl/tile/raster_dem_tile_worker.hpp",
    "src/mbgl/tile/raster_tile.cpp",
    "src/mbgl/tile/raster_tile.hpp",
    "src/mbgl/tile/raster_tile_worker.cpp",
    "src/mbgl/tile/raster_tile_worker.hpp",
    "src/mbgl/tile/tile.cpp",
    "src/mbgl/tile/tile.hpp",
    "src/mbgl/tile/tile_cache.cpp",
    "src/mbgl/tile/tile_cache.hpp",
    "src/mbgl/tile/tile_id_hash.cpp",
    "src/mbgl/tile/tile_id_io.cpp",
    "src/mbgl/tile/tile_loader.hpp",
    "src/mbgl/tile/tile_loader_impl.hpp",
    "src/mbgl/tile/tile_loader_observer.hpp",
    "src/mbgl/tile/tile_observer.hpp",
    "src/mbgl/tile/tile_operation.cpp",
    "src/mbgl/tile/vector_tile.cpp",
    "src/mbgl/tile/vector_tile.hpp",
    "src/mbgl/tile/vector_tile_data.cpp",
    "src/mbgl/tile/vector_tile_data.hpp",
    "src/mbgl/util/action_journal.cpp",
    "src/mbgl/util/action_journal_impl.hpp",
    "src/mbgl/util/action_journal_impl.cpp",
    "src/mbgl/util/camera.cpp",
    "src/mbgl/util/camera.hpp",
    "src/mbgl/util/bounding_volumes.hpp",
    "src/mbgl/util/bounding_volumes.cpp",
    "src/mbgl/util/chrono.cpp",
    "src/mbgl/util/client_options.cpp",
    "src/mbgl/util/constants.cpp",
    "src/mbgl/util/convert.cpp",
    "src/mbgl/util/event.cpp",
    "src/mbgl/util/filesystem.hpp",
    "src/mbgl/util/font_stack.cpp",
    "src/mbgl/util/geo.cpp",
    "src/mbgl/util/geojson_impl.cpp",
    "src/mbgl/util/geometry_util.cpp",
    "src/mbgl/util/geometry_util.hpp",
    "src/mbgl/util/grid_index.cpp",
    "src/mbgl/util/grid_index.hpp",
    "src/mbgl/util/http_header.cpp",
    "src/mbgl/util/http_header.hpp",
    "src/mbgl/util/http_timeout.cpp",
    "src/mbgl/util/http_timeout.hpp",
    "src/mbgl/util/i18n.cpp",
    "src/mbgl/util/i18n.hpp",
    "src/mbgl/util/identity.cpp",
    "src/mbgl/util/interpolate.cpp",
    "src/mbgl/util/intersection_tests.cpp",
    "src/mbgl/util/intersection_tests.hpp",
    "src/mbgl/util/io.cpp",
    "src/mbgl/util/io.hpp",
    "src/mbgl/util/literal.hpp",
    "src/mbgl/util/logging.cpp",
    "src/mbgl/util/longest_common_subsequence.hpp",
    "src/mbgl/util/mapbox.cpp",
    "src/mbgl/util/mapbox.hpp",
    "src/mbgl/util/mat2.cpp",
    "src/mbgl/util/mat2.hpp",
    "src/mbgl/util/mat3.cpp",
    "src/mbgl/util/mat3.hpp",
    "src/mbgl/util/mat4.cpp",
    "src/mbgl/util/mat4.hpp",
    "src/mbgl/util/math.hpp",
    "src/mbgl/util/padding.cpp",
    "src/mbgl/util/premultiply.cpp",
    "src/mbgl/util/quaternion.cpp",
    "src/mbgl/util/quaternion.hpp",
    "src/mbgl/util/rapidjson.cpp",
    "src/mbgl/util/rapidjson.hpp",
    "src/mbgl/util/std.hpp",
    "src/mbgl/util/stopwatch.cpp",
    "src/mbgl/util/stopwatch.hpp",
    "src/mbgl/util/string.cpp",
    "src/mbgl/util/string_indexer.cpp",
    "src/mbgl/util/thread.cpp",
    "src/mbgl/util/thread_local.hpp",
    "src/mbgl/util/thread_pool.cpp",
    "src/mbgl/util/thread_pool.hpp",
    "src/mbgl/util/tile_coordinate.hpp",
    "src/mbgl/util/tile_cover.cpp",
    "src/mbgl/util/tile_cover.hpp",
    "src/mbgl/util/tile_cover_impl.cpp",
    "src/mbgl/util/tile_cover_impl.hpp",
    "src/mbgl/util/tile_range.hpp",
    "src/mbgl/util/default_style.cpp",
    "src/mbgl/util/tile_server_options.cpp",
    "src/mbgl/util/tiny_sdf.cpp",
    "src/mbgl/util/tiny_sdf.hpp",
    "src/mbgl/util/token.hpp",
    "src/mbgl/util/url.cpp",
    "src/mbgl/util/url.hpp",
    "src/mbgl/util/utf.hpp",
    "src/mbgl/util/version.cpp",
    "src/mbgl/util/version.hpp",
    "src/mbgl/util/work_request.cpp",
] + select({
    "//:rust": [
        "src/mbgl/util/color.rs.cpp",
    ],
    "//conditions:default": [
        "src/mbgl/util/color.cpp",
    ],
})

MLN_CORE_HEADERS = [
    "include/mbgl/gfx/command_encoder.hpp",
    "include/mbgl/gfx/debug_group.hpp",
    "include/mbgl/gfx/context.hpp",
    "include/mbgl/gfx/context_observer.hpp",
    "include/mbgl/actor/actor.hpp",
    "include/mbgl/actor/actor_ref.hpp",
    "include/mbgl/actor/aspiring_actor.hpp",
    "include/mbgl/actor/established_actor.hpp",
    "include/mbgl/actor/mailbox.hpp",
    "include/mbgl/actor/message.hpp",
    "include/mbgl/actor/scheduler.hpp",
    "include/mbgl/annotation/annotation.hpp",
    "include/mbgl/gfx/backend.hpp",
    "include/mbgl/gfx/backend_scope.hpp",
    "include/mbgl/gfx/color_mode.hpp",
    "include/mbgl/gfx/depth_mode.hpp",
    "include/mbgl/gfx/draw_mode.hpp",
    "include/mbgl/gfx/draw_scope.hpp",
    "include/mbgl/gfx/fill_generator.hpp",
    "include/mbgl/gfx/gfx_types.hpp",
    "include/mbgl/gfx/polyline_generator.hpp",
    "include/mbgl/gfx/renderbuffer.hpp",
    "include/mbgl/gfx/renderable.hpp",
    "include/mbgl/gfx/renderer_backend.hpp",
    "include/mbgl/gfx/rendering_stats.hpp",
    "include/mbgl/gfx/shader_registry.hpp",
    "include/mbgl/gfx/shader_group.hpp",
    "include/mbgl/gfx/shader.hpp",
    "include/mbgl/gfx/stencil_mode.hpp",
    "include/mbgl/gfx/types.hpp",
    "include/mbgl/gfx/vertex_buffer.hpp",
    "include/mbgl/i18n/collator.hpp",
    "include/mbgl/i18n/number_format.hpp",
    "include/mbgl/layermanager/background_layer_factory.hpp",
    "include/mbgl/layermanager/circle_layer_factory.hpp",
    "include/mbgl/layermanager/custom_layer_factory.hpp",
    "include/mbgl/layermanager/fill_extrusion_layer_factory.hpp",
    "include/mbgl/layermanager/fill_layer_factory.hpp",
    "include/mbgl/layermanager/heatmap_layer_factory.hpp",
    "include/mbgl/layermanager/hillshade_layer_factory.hpp",
    "include/mbgl/layermanager/layer_factory.hpp",
    "include/mbgl/layermanager/layer_manager.hpp",
    "include/mbgl/layermanager/line_layer_factory.hpp",
    "include/mbgl/layermanager/location_indicator_layer_factory.hpp",
    "include/mbgl/layermanager/raster_layer_factory.hpp",
    "include/mbgl/layermanager/symbol_layer_factory.hpp",
    "include/mbgl/map/bound_options.hpp",
    "include/mbgl/map/camera.hpp",
    "include/mbgl/map/change.hpp",
    "include/mbgl/map/map.hpp",
    "include/mbgl/map/map_observer.hpp",
    "include/mbgl/map/map_options.hpp",
    "include/mbgl/map/map_projection.hpp",
    "include/mbgl/map/mode.hpp",
    "include/mbgl/map/projection_mode.hpp",
    "include/mbgl/math/angles.hpp",
    "include/mbgl/math/clamp.hpp",
    "include/mbgl/math/log2.hpp",
    "include/mbgl/math/minmax.hpp",
    "include/mbgl/math/wrap.hpp",
    "include/mbgl/platform/settings.hpp",
    "include/mbgl/platform/thread.hpp",
    "include/mbgl/platform/time.hpp",
    "include/mbgl/renderer/query.hpp",
    "include/mbgl/renderer/renderer.hpp",
    "include/mbgl/renderer/renderer_frontend.hpp",
    "include/mbgl/renderer/renderer_observer.hpp",
    "include/mbgl/renderer/renderer_state.hpp",
    "include/mbgl/shaders/program_parameters.hpp",
    "include/mbgl/storage/database_file_source.hpp",
    "include/mbgl/storage/file_source.hpp",
    "include/mbgl/storage/file_source_manager.hpp",
    "include/mbgl/storage/network_status.hpp",
    "include/mbgl/storage/offline.hpp",
    "include/mbgl/storage/online_file_source.hpp",
    "include/mbgl/storage/resource.hpp",
    "include/mbgl/storage/resource_options.hpp",
    "include/mbgl/storage/resource_transform.hpp",
    "include/mbgl/storage/response.hpp",
    "include/mbgl/style/color_ramp_property_value.hpp",
    "include/mbgl/style/conversion.hpp",
    "include/mbgl/style/conversion/color_ramp_property_value.hpp",
    "include/mbgl/style/conversion/constant.hpp",
    "include/mbgl/style/conversion/coordinate.hpp",
    "include/mbgl/style/conversion/custom_geometry_source_options.hpp",
    "include/mbgl/style/conversion/filter.hpp",
    "include/mbgl/style/conversion/function.hpp",
    "include/mbgl/style/conversion/geojson.hpp",
    "include/mbgl/style/conversion/geojson_options.hpp",
    "include/mbgl/style/conversion/get_json_type.hpp",
    "include/mbgl/style/conversion/layer.hpp",
    "include/mbgl/style/conversion/light.hpp",
    "include/mbgl/style/conversion/position.hpp",
    "include/mbgl/style/conversion/property_value.hpp",
    "include/mbgl/style/conversion/raster_dem_options.hpp",
    "include/mbgl/style/conversion/rotation.hpp",
    "include/mbgl/style/conversion/source.hpp",
    "include/mbgl/style/conversion/tileset.hpp",
    "include/mbgl/style/conversion/transition_options.hpp",
    "include/mbgl/style/conversion_impl.hpp",
    "include/mbgl/style/expression/assertion.hpp",
    "include/mbgl/style/expression/at.hpp",
    "include/mbgl/style/expression/boolean_operator.hpp",
    "include/mbgl/style/expression/case.hpp",
    "include/mbgl/style/expression/check_subtype.hpp",
    "include/mbgl/style/expression/coalesce.hpp",
    "include/mbgl/style/expression/coercion.hpp",
    "include/mbgl/style/expression/collator.hpp",
    "include/mbgl/style/expression/collator_expression.hpp",
    "include/mbgl/style/expression/comparison.hpp",
    "include/mbgl/style/expression/compound_expression.hpp",
    "include/mbgl/style/expression/dsl.hpp",
    "include/mbgl/style/expression/distance.hpp",
    "include/mbgl/style/expression/error.hpp",
    "include/mbgl/style/expression/expression.hpp",
    "include/mbgl/style/expression/find_zoom_curve.hpp",
    "include/mbgl/style/expression/format_expression.hpp",
    "include/mbgl/style/expression/format_section_override.hpp",
    "include/mbgl/style/expression/formatted.hpp",
    "include/mbgl/style/expression/get_covering_stops.hpp",
    "include/mbgl/style/expression/image.hpp",
    "include/mbgl/style/expression/image_expression.hpp",
    "include/mbgl/style/expression/in.hpp",
    "include/mbgl/style/expression/index_of.hpp",
    "include/mbgl/style/expression/interpolate.hpp",
    "include/mbgl/style/expression/interpolator.hpp",
    "include/mbgl/style/expression/is_constant.hpp",
    "include/mbgl/style/expression/is_expression.hpp",
    "include/mbgl/style/expression/length.hpp",
    "include/mbgl/style/expression/let.hpp",
    "include/mbgl/style/expression/literal.hpp",
    "include/mbgl/style/expression/match.hpp",
    "include/mbgl/style/expression/number_format.hpp",
    "include/mbgl/style/expression/parsing_context.hpp",
    "include/mbgl/style/expression/slice.hpp",
    "include/mbgl/style/expression/step.hpp",
    "include/mbgl/style/expression/type.hpp",
    "include/mbgl/style/expression/value.hpp",
    "include/mbgl/style/expression/within.hpp",
    "include/mbgl/style/filter.hpp",
    "include/mbgl/style/image.hpp",
    "include/mbgl/style/layer.hpp",
    "include/mbgl/style/layer_properties.hpp",
    "include/mbgl/style/layers/custom_layer.hpp",
    "include/mbgl/style/layers/custom_layer_render_parameters.hpp",
    "include/mbgl/style/position.hpp",
    "include/mbgl/style/property_expression.hpp",
    "include/mbgl/style/property_value.hpp",
    "include/mbgl/style/rotation.hpp",
    "include/mbgl/style/source.hpp",
    "include/mbgl/style/sources/custom_geometry_source.hpp",
    "include/mbgl/style/sources/geojson_source.hpp",
    "include/mbgl/style/sources/image_source.hpp",
    "include/mbgl/style/sources/raster_dem_source.hpp",
    "include/mbgl/style/sources/tile_source.hpp",
    "include/mbgl/style/sources/raster_source.hpp",
    "include/mbgl/style/sources/vector_source.hpp",
    "include/mbgl/style/sprite.hpp",
    "include/mbgl/style/style.hpp",
    "include/mbgl/style/style_property.hpp",
    "include/mbgl/style/transition_options.hpp",
    "include/mbgl/style/types.hpp",
    "include/mbgl/style/undefined.hpp",
    "include/mbgl/style/variable_anchor_offset_collection.hpp",
    "include/mbgl/text/glyph.hpp",
    "include/mbgl/text/glyph_range.hpp",
    "include/mbgl/tile/tile_id.hpp",
    "include/mbgl/tile/tile_operation.hpp",
    "include/mbgl/tile/tile_necessity.hpp",
    "include/mbgl/util/action_journal.hpp",
    "include/mbgl/util/action_journal_options.hpp",
    "include/mbgl/util/async_request.hpp",
    "include/mbgl/util/async_task.hpp",
    "include/mbgl/util/bitmask_operations.hpp",
    "include/mbgl/util/char_array_buffer.hpp",
    "include/mbgl/util/chrono.hpp",
    "include/mbgl/util/client_options.hpp",
    "include/mbgl/util/color.hpp",
    "include/mbgl/util/compression.hpp",
    "include/mbgl/util/constants.hpp",
    "include/mbgl/util/containers.hpp",
    "include/mbgl/util/convert.hpp",
    "include/mbgl/util/default_style.hpp",
    "include/mbgl/util/enum.hpp",
    "include/mbgl/util/event.hpp",
    "include/mbgl/util/exception.hpp",
    "include/mbgl/util/expected.hpp",
    "include/mbgl/util/feature.hpp",
    "include/mbgl/util/font_stack.hpp",
    "include/mbgl/util/geo.hpp",
    "include/mbgl/util/geojson.hpp",
    "include/mbgl/util/geometry.hpp",
    "include/mbgl/util/hash.hpp",
    "include/mbgl/util/identity.hpp",
    "include/mbgl/util/ignore.hpp",
    "include/mbgl/util/image.hpp",
    "include/mbgl/util/immutable.hpp",
    "include/mbgl/util/indexed_tuple.hpp",
    "include/mbgl/util/instrumentation.hpp",
    "include/mbgl/util/interpolate.hpp",
    "include/mbgl/util/logging.hpp",
    "include/mbgl/util/lru_cache.hpp",
    "include/mbgl/util/monotonic_timer.hpp",
    "include/mbgl/util/noncopyable.hpp",
    "include/mbgl/util/padding.hpp",
    "include/mbgl/util/platform.hpp",
    "include/mbgl/util/premultiply.hpp",
    "include/mbgl/util/projection.hpp",
    "include/mbgl/util/range.hpp",
    "include/mbgl/util/rect.hpp",
    "include/mbgl/util/run_loop.hpp",
    "include/mbgl/util/scoped.hpp",
    "include/mbgl/util/size.hpp",
    "include/mbgl/util/string.hpp",
    "include/mbgl/util/string_indexer.hpp",
    "include/mbgl/util/tile_server_options.hpp",
    "include/mbgl/util/thread.hpp",
    "include/mbgl/util/tileset.hpp",
    "include/mbgl/util/timer.hpp",
    "include/mbgl/util/tiny_unordered_map.hpp",
    "include/mbgl/util/traits.hpp",
    "include/mbgl/util/type_list.hpp",
    "include/mbgl/util/unitbezier.hpp",
    "include/mbgl/util/util.hpp",
    "include/mbgl/util/variant.hpp",
    "include/mbgl/util/vectors.hpp",
    "include/mbgl/util/work_request.hpp",
    "include/mbgl/util/work_task.hpp",
    "include/mbgl/util/work_task_impl.hpp",
]

MLN_OPENGL_SOURCE = [
    "src/mbgl/gl/attribute.cpp",
    "src/mbgl/gl/attribute.hpp",
    "src/mbgl/gl/command_encoder.cpp",
    "src/mbgl/gl/command_encoder.hpp",
    "src/mbgl/gl/context.cpp",
    "src/mbgl/gl/context.hpp",
    "src/mbgl/gl/debugging_extension.cpp",
    "src/mbgl/gl/debugging_extension.hpp",
    "src/mbgl/gl/defines.hpp",
    "src/mbgl/gl/draw_scope_resource.hpp",
    "src/mbgl/gl/enum.cpp",
    "src/mbgl/gl/enum.hpp",
    "src/mbgl/gl/extension.hpp",
    "src/mbgl/gl/fence.cpp",
    "src/mbgl/gl/fence.hpp",
    "src/mbgl/gl/framebuffer.hpp",
    "src/mbgl/gl/index_buffer_resource.cpp",
    "src/mbgl/gl/index_buffer_resource.hpp",
    "src/mbgl/gl/object.cpp",
    "src/mbgl/gl/object.hpp",
    "src/mbgl/gl/offscreen_texture.cpp",
    "src/mbgl/gl/offscreen_texture.hpp",
    "src/mbgl/gl/render_pass.cpp",
    "src/mbgl/gl/render_pass.hpp",
    "src/mbgl/gl/renderbuffer_resource.cpp",
    "src/mbgl/gl/renderbuffer_resource.hpp",
    "src/mbgl/gl/renderer_backend.cpp",
    "src/mbgl/gl/resource_pool.cpp",
    "src/mbgl/gl/resource_pool.hpp",
    "src/mbgl/gl/state.hpp",
    "src/mbgl/gl/timestamp_query_extension.cpp",
    "src/mbgl/gl/timestamp_query_extension.hpp",
    "src/mbgl/gl/types.hpp",
    "src/mbgl/gl/uniform.cpp",
    "src/mbgl/gl/uniform.hpp",
    "src/mbgl/gl/upload_pass.cpp",
    "src/mbgl/gl/upload_pass.hpp",
    "src/mbgl/gl/value.cpp",
    "src/mbgl/gl/value.hpp",
    "src/mbgl/gl/vertex_array.cpp",
    "src/mbgl/gl/vertex_array.hpp",
    "src/mbgl/gl/vertex_buffer_resource.cpp",
    "src/mbgl/gl/vertex_buffer_resource.hpp",
    "src/mbgl/platform/gl_functions.cpp",
    "src/mbgl/shaders/gl/legacy/clipping_mask_program.hpp",
    "src/mbgl/shaders/gl/legacy/program_base.hpp",
    "src/mbgl/shaders/gl/legacy/program.hpp",
    "src/mbgl/shaders/gl/legacy/programs.cpp",
    "src/mbgl/shaders/gl/legacy/programs.hpp",
]

MLN_OPENGL_HEADERS = [
    "include/mbgl/gl/renderable_resource.hpp",
    "include/mbgl/gl/renderer_backend.hpp",
    "include/mbgl/platform/gl_functions.hpp",
]

MLN_DRAWABLES_SOURCE = [
    "src/mbgl/gfx/drawable.cpp",
    "src/mbgl/gfx/drawable_builder.cpp",
    "src/mbgl/gfx/drawable_builder_impl.hpp",
    "src/mbgl/gfx/drawable_builder_impl.cpp",
    "src/mbgl/gfx/drawable_atlases_tweaker.cpp",
    "src/mbgl/gfx/drawable_custom_layer_host_tweaker.cpp",
    "src/mbgl/gfx/dynamic_texture.cpp",
    "src/mbgl/gfx/dynamic_texture_atlas.cpp",
    "src/mbgl/gfx/gpu_expression.cpp",
    "src/mbgl/gfx/hillshade_prepare_drawable_data.hpp",
    "src/mbgl/gfx/image_drawable_data.hpp",
    "src/mbgl/gfx/line_drawable_data.hpp",
    "src/mbgl/gfx/symbol_drawable_data.hpp",
    "src/mbgl/gfx/collision_drawable_data.hpp",
    "src/mbgl/gfx/uniform_buffer.cpp",
    "src/mbgl/gfx/vertex_attribute.cpp",
    "src/mbgl/renderer/change_request.cpp",
    "src/mbgl/renderer/layer_group.cpp",
    "src/mbgl/renderer/tile_layer_group.cpp",
    "src/mbgl/renderer/layer_tweaker.cpp",
    "src/mbgl/renderer/render_target.cpp",
    "src/mbgl/renderer/layers/background_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/background_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/circle_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/circle_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/fill_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/fill_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/fill_extrusion_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/fill_extrusion_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/heatmap_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/heatmap_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/heatmap_texture_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/heatmap_texture_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/hillshade_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/hillshade_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/hillshade_prepare_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/hillshade_prepare_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/line_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/line_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/location_indicator_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/location_indicator_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/raster_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/raster_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/symbol_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/symbol_layer_tweaker.hpp",
    "src/mbgl/renderer/layers/collision_layer_tweaker.cpp",
    "src/mbgl/renderer/layers/collision_layer_tweaker.hpp",
    "src/mbgl/shaders/shader_program_base.cpp",
    "src/mbgl/style/layers/custom_drawable_layer.cpp",
    "src/mbgl/layermanager/custom_drawable_layer_factory.cpp",
    "src/mbgl/style/layers/custom_drawable_layer_impl.cpp",
    "src/mbgl/style/layers/custom_drawable_layer_impl.hpp",
    "src/mbgl/renderer/layers/render_custom_drawable_layer.cpp",
    "src/mbgl/renderer/layers/render_custom_drawable_layer.hpp",
]

MLN_DRAWABLES_HEADERS = [
    "include/mbgl/gfx/drawable.hpp",
    "include/mbgl/gfx/drawable_data.hpp",
    "include/mbgl/gfx/drawable_impl.hpp",
    "include/mbgl/gfx/drawable_builder.hpp",
    "include/mbgl/gfx/drawable_tweaker.hpp",
    "include/mbgl/gfx/drawable_atlases_tweaker.hpp",
    "include/mbgl/gfx/drawable_custom_layer_host_tweaker.hpp",
    "include/mbgl/gfx/dynamic_texture.hpp",
    "include/mbgl/gfx/dynamic_texture_atlas.hpp",
    "include/mbgl/gfx/gpu_expression.hpp",
    "include/mbgl/gfx/uniform_buffer.hpp",
    "include/mbgl/gfx/vertex_attribute.hpp",
    "include/mbgl/gfx/texture2d.hpp",
    "include/mbgl/renderer/change_request.hpp",
    "include/mbgl/renderer/layer_group.hpp",
    "include/mbgl/renderer/layer_tweaker.hpp",
    "include/mbgl/renderer/render_target.hpp",
    "include/mbgl/shaders/background_layer_ubo.hpp",
    "include/mbgl/shaders/circle_layer_ubo.hpp",
    "include/mbgl/shaders/collision_layer_ubo.hpp",
    "include/mbgl/shaders/custom_geometry_ubo.hpp",
    "include/mbgl/shaders/custom_drawable_layer_ubo.hpp",
    "include/mbgl/shaders/debug_layer_ubo.hpp",
    "include/mbgl/shaders/fill_layer_ubo.hpp",
    "include/mbgl/shaders/fill_extrusion_layer_ubo.hpp",
    "include/mbgl/shaders/heatmap_layer_ubo.hpp",
    "include/mbgl/shaders/heatmap_texture_layer_ubo.hpp",
    "include/mbgl/shaders/hillshade_layer_ubo.hpp",
    "include/mbgl/shaders/hillshade_prepare_layer_ubo.hpp",
    "include/mbgl/shaders/layer_ubo.hpp",
    "include/mbgl/shaders/line_layer_ubo.hpp",
    "include/mbgl/shaders/location_indicator_ubo.hpp",
    "include/mbgl/shaders/raster_layer_ubo.hpp",
    "include/mbgl/shaders/shader_defines.hpp",
    "include/mbgl/shaders/shader_program_base.hpp",
    "include/mbgl/shaders/symbol_layer_ubo.hpp",
    "include/mbgl/shaders/widevector_ubo.hpp",
    "include/mbgl/util/suppress_copies.hpp",
    "include/mbgl/style/layers/custom_drawable_layer.hpp",
    "include/mbgl/layermanager/custom_drawable_layer_factory.hpp",
]

MLN_DRAWABLES_GL_SOURCE = [
    "src/mbgl/gl/buffer_allocator.cpp",
    "src/mbgl/gl/drawable_gl.cpp",
    "src/mbgl/gl/drawable_gl_builder.cpp",
    "src/mbgl/gl/drawable_gl_impl.hpp",
    "src/mbgl/gl/layer_group_gl.cpp",
    "src/mbgl/gl/texture2d.cpp",
    "src/mbgl/gl/uniform_buffer_gl.cpp",
    "src/mbgl/gl/vertex_attribute_gl.cpp",
    "src/mbgl/shaders/gl/shader_info.cpp",
    "src/mbgl/shaders/gl/shader_program_gl.cpp",
]

MLN_DRAWABLES_GL_HEADERS = [
    "include/mbgl/gl/buffer_allocator.hpp",
    "include/mbgl/gl/drawable_gl.hpp",
    "include/mbgl/gl/drawable_gl_builder.hpp",
    "include/mbgl/gl/layer_group_gl.hpp",
    "include/mbgl/gl/uniform_buffer_gl.hpp",
    "include/mbgl/gl/vertex_attribute_gl.hpp",
    "include/mbgl/gl/texture2d.hpp",
    "include/mbgl/shaders/gl/shader_info.hpp",
    "include/mbgl/shaders/gl/shader_program_gl.hpp",
    "include/mbgl/shaders/gl/shader_group_gl.hpp",
]

MLN_DRAWABLES_MTL_SOURCE = [
    "src/mbgl/mtl/buffer_resource.cpp",
    "src/mbgl/mtl/command_encoder.cpp",
    "src/mbgl/mtl/context.cpp",
    "src/mbgl/mtl/drawable.cpp",
    "src/mbgl/mtl/drawable_impl.hpp",
    "src/mbgl/mtl/drawable_builder.cpp",
    "src/mbgl/mtl/index_buffer_resource.cpp",
    "src/mbgl/mtl/layer_group.cpp",
    "src/mbgl/mtl/mtl.cpp",
    "src/mbgl/mtl/offscreen_texture.cpp",
    "src/mbgl/mtl/renderer_backend.cpp",
    "src/mbgl/mtl/texture2d.cpp",
    "src/mbgl/mtl/render_pass.cpp",
    "src/mbgl/mtl/tile_layer_group.cpp",
    "src/mbgl/mtl/uniform_buffer.cpp",
    "src/mbgl/mtl/upload_pass.cpp",
    "src/mbgl/mtl/vertex_attribute.cpp",
    "src/mbgl/mtl/vertex_buffer_resource.cpp",
    "src/mbgl/shaders/mtl/shader_program.cpp",
    "src/mbgl/shaders/mtl/background.cpp",
    "src/mbgl/shaders/mtl/circle.cpp",
    "src/mbgl/shaders/mtl/collision.cpp",
    "src/mbgl/shaders/mtl/clipping_mask.cpp",
    "src/mbgl/shaders/mtl/custom_geometry.cpp",
    "src/mbgl/shaders/mtl/custom_symbol_icon.cpp",
    "src/mbgl/shaders/mtl/debug.cpp",
    "src/mbgl/shaders/mtl/fill.cpp",
    "src/mbgl/shaders/mtl/fill_extrusion.cpp",
    "src/mbgl/shaders/mtl/heatmap.cpp",
    "src/mbgl/shaders/mtl/heatmap_texture.cpp",
    "src/mbgl/shaders/mtl/hillshade.cpp",
    "src/mbgl/shaders/mtl/hillshade_prepare.cpp",
    "src/mbgl/shaders/mtl/line.cpp",
    "src/mbgl/shaders/mtl/location_indicator.cpp",
    "src/mbgl/shaders/mtl/raster.cpp",
    "src/mbgl/shaders/mtl/symbol.cpp",
    "src/mbgl/shaders/mtl/widevector.cpp",
    "src/mbgl/style/layers/mtl/custom_layer_render_parameters.cpp",
]

MLN_DRAWABLES_MTL_HEADERS = [
    "include/mbgl/mtl/buffer_resource.hpp",
    "include/mbgl/mtl/command_encoder.hpp",
    "include/mbgl/mtl/context.hpp",
    "include/mbgl/mtl/drawable.hpp",
    "include/mbgl/mtl/drawable_builder.hpp",
    "include/mbgl/mtl/index_buffer_resource.hpp",
    "include/mbgl/mtl/layer_group.hpp",
    "include/mbgl/mtl/mtl_fwd.hpp",
    "include/mbgl/mtl/offscreen_texture.hpp",
    "include/mbgl/mtl/render_pass.hpp",
    "include/mbgl/mtl/renderer_backend.hpp",
    "include/mbgl/mtl/renderable_resource.hpp",
    "include/mbgl/mtl/texture2d.hpp",
    "include/mbgl/mtl/tile_layer_group.hpp",
    "include/mbgl/mtl/uniform_buffer.hpp",
    "include/mbgl/mtl/upload_pass.hpp",
    "include/mbgl/mtl/vertex_attribute.hpp",
    "include/mbgl/mtl/vertex_buffer_resource.hpp",
    "include/mbgl/shaders/mtl/background.hpp",
    "include/mbgl/shaders/mtl/circle.hpp",
    "include/mbgl/shaders/mtl/clipping_mask.hpp",
    "include/mbgl/shaders/mtl/collision.hpp",
    "include/mbgl/shaders/mtl/common.hpp",
    "include/mbgl/shaders/mtl/custom_geometry.hpp",
    "include/mbgl/shaders/mtl/custom_symbol_icon.hpp",
    "include/mbgl/shaders/mtl/debug.hpp",
    "include/mbgl/shaders/mtl/fill.hpp",
    "include/mbgl/shaders/mtl/fill_extrusion.hpp",
    "include/mbgl/shaders/mtl/heatmap.hpp",
    "include/mbgl/shaders/mtl/heatmap_texture.hpp",
    "include/mbgl/shaders/mtl/hillshade.hpp",
    "include/mbgl/shaders/mtl/hillshade_prepare.hpp",
    "include/mbgl/shaders/mtl/line.hpp",
    "include/mbgl/shaders/mtl/location_indicator.hpp",
    "include/mbgl/shaders/mtl/raster.hpp",
    "include/mbgl/shaders/mtl/shader_group.hpp",
    "include/mbgl/shaders/mtl/shader_program.hpp",
    "include/mbgl/shaders/mtl/symbol.hpp",
    "include/mbgl/style/layers/mtl/custom_layer_render_parameters.hpp",
    "include/mbgl/shaders/mtl/widevector.hpp",
]

MLN_DRAWABLES_WEBGPU_SOURCE = [
    "src/mbgl/webgpu/buffer_resource.cpp",
    "src/mbgl/webgpu/command_encoder.cpp",
    "src/mbgl/webgpu/context.cpp",
    "src/mbgl/webgpu/draw_scope_resource.cpp",
    "src/mbgl/webgpu/drawable.cpp",
    "src/mbgl/webgpu/drawable_builder.cpp",
    "src/mbgl/webgpu/headless_backend.cpp",
    "src/mbgl/webgpu/index_buffer_resource.cpp",
    "src/mbgl/webgpu/layer_group.cpp",
    "src/mbgl/webgpu/offscreen_texture.cpp",
    "src/mbgl/webgpu/render_pass.cpp",
    "src/mbgl/webgpu/renderer_backend.cpp",
    "src/mbgl/webgpu/texture2d.cpp",
    "src/mbgl/webgpu/tile_layer_group.cpp",
    "src/mbgl/webgpu/uniform_buffer.cpp",
    "src/mbgl/webgpu/upload_pass.cpp",
    "src/mbgl/webgpu/vertex_attribute.cpp",
    "src/mbgl/webgpu/vertex_buffer_resource.cpp",
    "src/mbgl/shaders/webgpu/shader_program.cpp",
    "src/mbgl/shaders/webgpu/wgsl_preprocessor.cpp",
    "src/mbgl/shaders/webgpu/background.cpp",
    "src/mbgl/shaders/webgpu/circle.cpp",
    "src/mbgl/shaders/webgpu/clipping_mask.cpp",
    "src/mbgl/shaders/webgpu/collision.cpp",
    "src/mbgl/shaders/webgpu/custom_geometry.cpp",
    "src/mbgl/shaders/webgpu/custom_symbol_icon.cpp",
    "src/mbgl/shaders/webgpu/debug.cpp",
    "src/mbgl/shaders/webgpu/fill.cpp",
    "src/mbgl/shaders/webgpu/fill_extrusion.cpp",
    "src/mbgl/shaders/webgpu/heatmap.cpp",
    "src/mbgl/shaders/webgpu/heatmap_texture.cpp",
    "src/mbgl/shaders/webgpu/hillshade.cpp",
    "src/mbgl/shaders/webgpu/hillshade_prepare.cpp",
    "src/mbgl/shaders/webgpu/line.cpp",
    "src/mbgl/shaders/webgpu/location_indicator.cpp",
    "src/mbgl/shaders/webgpu/raster.cpp",
    "src/mbgl/shaders/webgpu/symbol.cpp",
    "src/mbgl/shaders/webgpu/widevector.cpp",
]

MLN_DRAWABLES_WEBGPU_HEADERS = [
    "include/mbgl/webgpu/buffer_resource.hpp",
    "include/mbgl/webgpu/command_encoder.hpp",
    "include/mbgl/webgpu/context.hpp",
    "include/mbgl/webgpu/draw_scope_resource.hpp",
    "include/mbgl/webgpu/drawable.hpp",
    "include/mbgl/webgpu/drawable_builder.hpp",
    "include/mbgl/webgpu/index_buffer_resource.hpp",
    "include/mbgl/webgpu/layer_group.hpp",
    "include/mbgl/webgpu/offscreen_texture.hpp",
    "include/mbgl/webgpu/render_pass.hpp",
    "include/mbgl/webgpu/renderable_resource.hpp",
    "include/mbgl/webgpu/renderer_backend.hpp",
    "include/mbgl/webgpu/texture2d.hpp",
    "include/mbgl/webgpu/tile_layer_group.hpp",
    "include/mbgl/webgpu/uniform_buffer.hpp",
    "include/mbgl/webgpu/upload_pass.hpp",
    "include/mbgl/webgpu/vertex_attribute.hpp",
    "include/mbgl/webgpu/vertex_buffer_resource.hpp",
    "include/mbgl/webgpu/wgpu_cpp_compat.hpp",
    "include/mbgl/shaders/webgpu/background.hpp",
    "include/mbgl/shaders/webgpu/circle.hpp",
    "include/mbgl/shaders/webgpu/clipping_mask.hpp",
    "include/mbgl/shaders/webgpu/collision.hpp",
    "include/mbgl/shaders/webgpu/common.hpp",
    "include/mbgl/shaders/webgpu/custom_geometry.hpp",
    "include/mbgl/shaders/webgpu/custom_symbol_icon.hpp",
    "include/mbgl/shaders/webgpu/debug.hpp",
    "include/mbgl/shaders/webgpu/fill.hpp",
    "include/mbgl/shaders/webgpu/fill_extrusion.hpp",
    "include/mbgl/shaders/webgpu/heatmap.hpp",
    "include/mbgl/shaders/webgpu/heatmap_texture.hpp",
    "include/mbgl/shaders/webgpu/hillshade.hpp",
    "include/mbgl/shaders/webgpu/hillshade_prepare.hpp",
    "include/mbgl/shaders/webgpu/line.hpp",
    "include/mbgl/shaders/webgpu/location_indicator.hpp",
    "include/mbgl/shaders/webgpu/raster.hpp",
    "include/mbgl/shaders/webgpu/shader_group.hpp",
    "include/mbgl/shaders/webgpu/shader_program.hpp",
    "include/mbgl/shaders/webgpu/symbol.hpp",
    "include/mbgl/shaders/webgpu/wgsl_preprocessor.hpp",
    "include/mbgl/shaders/webgpu/widevector.hpp",
]

MLN_SHAPING_HARFBUZZ_SRCS = [
    "src/mbgl/text/freetype.hpp",
    "src/mbgl/text/freetype.cpp",
    "src/mbgl/text/harfbuzz_impl.hpp",
    "src/mbgl/text/harfbuzz_impl.cpp",
]
