# Kotlin Design Proposal

## Motivation
10 years ago, [JetBrains released Kotlin](https://blog.jetbrains.com/kotlin/2011/07/hello-world-2/)
5 years ago, [Android got support for Kotlin](https://android-developers.googleblog.com/2017/05/android-announces-support-for-kotlin.html)
3 years ago, [Android became Kotlin-first](https://developer.android.com/kotlin/first)

The argument for Kotlin over Java is typically along the lines of Kotlin being an "easier" language than Java. Practically, this shows in Kotlin being less verbose, so fewer lines of code to make errors in. It also has static typing instead of strong typing so many types are inferred, and lastly, it has a Null type which avoids all the common NullPointer exceptions.

Kotlin seems like a natural successor language to java, because it brings some advantages with no real downsides. It has full interoperability allowing us to port files 1-1.

There are also intersting features being added to the language that we can explore in the future if we decide to invest in kotlin competence now - such as [Kotlin Multiplatform](https://kotlinlang.org/docs/multiplatform.html#full-stack-web-applications) for cross-platform compilation.

## Proposed Change

I propose that we port all our Android platform code, so we have a language less in our codebase. First the TestApp and then the SDK itself.


## API Modifications
No modifications are planned.

## Migration Plan and Compatibility
Full backward compatibility


## Rejected Alternatives
The alternative is that we go forward with java, meaning that we effectively should port our existing kotlin code to java, which I can't find evidence of any project ever attempting.
