package org.maplibre.android.integration

import androidx.test.filters.LargeTest
import androidx.test.internal.runner.junit4.AndroidJUnit4ClassRunner
import androidx.test.rule.ActivityTestRule
import org.maplibre.android.testapp.activity.maplayout.SimpleMapActivity
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

/**
 * Regression test that validates reopening an Activity with a SurfaceView
 */
@RunWith(AndroidJUnit4ClassRunner::class)
class SurfaceViewReopenTest : BaseIntegrationTest() {

    @get:Rule
    var activityRule: ActivityTestRule<SimpleMapActivity> = ActivityTestRule(SimpleMapActivity::class.java)

    @Test
    @LargeTest
    fun reopenSimpleMapActivity() {
        device.waitForIdle()
        device.pressHome()
        device.waitForIdle()
        device.launchActivity(activityRule.activity, SimpleMapActivity::class.java)
        device.waitForIdle()
    }
}
