# MapLibre Android Examples

Welcome to the examples documentation of MapLibre Android.

<div class="grid cards" markdown>

-   :material-clock-fast:{ .lg .middle } __Quickstart__

    ---

    Learn how to include MapLibre Android in your project

    [:octicons-arrow-right-24: Getting started](getting-started.md)

-   :fontawesome-brands-slack:{ .lg .middle } __Find us on Slack__

    ---

    Discuss the project and ask questions in the `#maplibre-android` channel

    [:octicons-arrow-right-24: Slack](https://osmus.slack.com/archives/C01G3D28DAB)

-   :fontawesome-solid-code:{ .lg .middle } __Contribute to these Docs__

    ---

    Share your own examples with the community!

    [:octicons-arrow-right-24: Documentation on GitHub](https://github.com/maplibre/maplibre-native/tree/main/platform/android/docs)

</div>


## Open-Source Apps Using MapLibre Android

You can learn how to use the API from MapLibre Android by stuying the source code of existing apps that intergrate MapLibre Android. Here are some open-source apps that use MapLibre Android:

- [Streetcomplete](https://github.com/streetcomplete/StreetComplete) ([source code](https://github.com/search?q=repo%3Astreetcomplete%2FStreetComplete%20maplibre&type=code))
- [The official Wikipedia app for Android](https://github.com/wikimedia/apps-android-wikipedia) ([source code](https://github.com/search?q=repo%3Awikimedia%2Fapps-android-wikipedia%20maplibre&type=code)).
- [MapLibreAndroidTestApp](https://github.com/maplibre/maplibre-native/tree/main/platform/android/MapLibreAndroidTestApp). This app is part of the MapLibre Native repository and is used for (automated) testing. Many of the examples in this documentation site come directly from this app.

## See Also

- [MapLibre Android API Documentation](https://maplibre.org/maplibre-native/android/api/)
- [Source code on GitHub](https://github.com/maplibre/maplibre-native/tree/main/platform/android)
- [Latest releases](https://github.com/maplibre/maplibre-native/releases?q=android-v11&expanded=true)
- [GitHub Discussions](https://github.com/maplibre/maplibre-native/discussions/categories/q-a?discussions_q=is%3Aopen+category%3AQ%26A+label%3Aandroid)
- [MapLibre on Slack](https://slack.openstreetmap.us). Join the `#maplibre-native` and `#maplibre-android` channels.
