message(STATUS "=== ARM64 TRIPLET LOADED ===")
message(STATUS "Loading custom ARM64 triplet from: ${CMAKE_CURRENT_LIST_FILE}")

set(VCPKG_TARGET_ARCHITECTURE arm64)
set(VCPKG_CRT_LINKAGE dynamic)
set(VCPKG_LIBRARY_LINKAGE static)

# Force Visual Studio generator instead of Ninja for ARM64
set(VCPKG_CMAKE_GENERATOR "Visual Studio 17 2022")
set(VCPKG_CMAKE_GENERATOR_PLATFORM "ARM64")

# Explicitly set the platform toolset
set(VCPKG_PLATFORM_TOOLSET v143)

message(STATUS "ARM64 Triplet Settings:")
message(STATUS "  VCPKG_TARGET_ARCHITECTURE: ${VCPKG_TARGET_ARCHITECTURE}")
message(STATUS "  VCPKG_CRT_LINKAGE: ${VCPKG_CRT_LINKAGE}")
message(STATUS "  VCPKG_LIBRARY_LINKAGE: ${VCPKG_LIBRARY_LINKAGE}")
message(STATUS "  VCPKG_CMAKE_GENERATOR: ${VCPKG_CMAKE_GENERATOR}")
message(STATUS "  VCPKG_CMAKE_GENERATOR_PLATFORM: ${VCPKG_CMAKE_GENERATOR_PLATFORM}")
message(STATUS "  VCPKG_PLATFORM_TOOLSET: ${VCPKG_PLATFORM_TOOLSET}")
message(STATUS "=== ARM64 TRIPLET LOADED ===")
