#if MLN_RENDER_BACKEND_OPENGL
#include <mbgl/test/util.hpp>

#include <mbgl/gfx/backend_scope.hpp>
#include <mbgl/gl/headless_backend.hpp>
#include <mbgl/gl/context.hpp>

#include <memory>

using namespace mbgl;

namespace {

static bool getFlag = false;
static bool setFlag = false;

} // namespace

struct MockGLObject {
    using Type = bool;
    static const Type Default;
    static Type Get() {
        getFlag = true;
        return true;
    }
    static void Set(const Type&) { setFlag = true; }
};

const bool MockGLObject::Default = false;

TEST(GLObject, Value) {
    setFlag = false;

    auto object = std::make_unique<gl::State<MockGLObject>>();
    EXPECT_EQ(object->getCurrentValue(), false);
    EXPECT_TRUE(object->isDirty());
    EXPECT_FALSE(setFlag);

    *object = false;
    EXPECT_EQ(object->getCurrentValue(), false);
    EXPECT_FALSE(object->isDirty());
    EXPECT_TRUE(setFlag);

    setFlag = false;
    *object = true;
    EXPECT_EQ(object->getCurrentValue(), true);
    EXPECT_FALSE(object->isDirty());
    EXPECT_TRUE(setFlag);
}

TEST(GLObject, Store) {
    gl::HeadlessBackend backend{{256, 256}};
    gfx::BackendScope scope{backend};

    gl::Context context{backend};
    EXPECT_TRUE(context.empty());

    gl::UniqueTexture texture = context.createUniqueTexture(
        {8, 8}, gfx::TexturePixelType::RGBA, gfx::TextureChannelDataType::UnsignedByte);
    EXPECT_NE(texture.get(), 0u);
    texture.reset();
    EXPECT_FALSE(context.empty(false));
    EXPECT_FALSE(context.empty(true));
    context.performCleanup();
    EXPECT_TRUE(context.empty(false));
    EXPECT_FALSE(context.empty(true));
    context.reset();
    EXPECT_TRUE(context.empty(false));
    EXPECT_TRUE(context.empty(true));

    context.reset();
    EXPECT_TRUE(context.empty(false));
    EXPECT_TRUE(context.empty(true));
}

#endif
