#pragma once

#include <mapbox/cheap_ruler.hpp>

// Pre-computed test expectations with turf.js

namespace cr = mapbox::cheap_ruler;

static const std::vector<double> turf_distance = {
    0.008378522721530966,
    0,
    0.010749717813535198,
    0.013838610971284946,
    0.013657697587927904,
    0.044013281621164545,
    0.0068391514197623125,
    0.10416972567189697,
    0.030891354635076577,
    0.019413765237647276,
    0.04263542169525046,
    0.0069116261879168155,
    0.582645708508002,
    0.018308680637617696,
    0.009577172911626559,
    0.017465334500943574,
    0.06613851306063838,
    0.3617719377192654,
    0.07753561751121403,
    0.13551122988625394,
    0.06598639029222791,
    0.10788718733352708,
    0.637754036319657,
    0.04744046409407494,
    0.019071666981656257,
    0.013911884201543205,
    0.026453803385838824,
    0.03993584290435518,
    0.5008820538480422,
    0.016568611251168885,
    0.05180738530903197,
    0.3119106296673429,
    0.017798808015935193,
    0.008016350616268752,
    0.007324494221885543,
    0.006909617037766451,
    0.01133329359318173,
    0.024542232038179984,
    0.13854858779974746,
    0.039494712699750543,
    0.002803669222998928,
    0.005515366276063487,
    0.005238469974132169,
    0.005880339789619507,
    0.005357898801346142,
    0.0051705154162532425,
    0.005070109623060704,
    0.0052577908286051914,
    0.00847519939173927,
    0.06303372152921366,
    0.019657925611790725,
    0.045304719345077606,
    0.11235257808731806,
    0.07172313743043487,
    0.03786245739823775,
    0.014737426160375995,
    0.012073619242440572,
    0.01944992465839253,
    0.4587699541978461,
    0.02021344170822001,
    0.04940583279333197,
    0.26541509069849073,
    0.10136117015958783,
    0.071051047335519,
    0.0839785094261126,
    0.13233952591634118,
    0.028947596386964588,
    0.450310288271311,
    0.02617846959013443,
    0.01773953006642692,
    0.03246883345774803,
    0.023279127631702524,
    0.013794142444291755,
    0.19974484175602678,
    0.0968663637124452,
    0.017337159580454113,
    0.013800054342251185,
    0.013308139694942028,
    0.01331222080564702,
    0.012080965868250661,
    0.009727373321527968,
    0.012964274265275947,
    0.016122067768646026,
    0.03863515912787102,
    0.019839914076975624,
    0.010301365066689631,
    0.010054214744799303,
    0.008762005427975264,
    0.008542780137735616,
    0.010518226790403411,
    0.09474686301917724,
    0.1342649575551186,
    0.02522592703114516,
    0.023008194493208647,
    0.04303616022369959,
    0.36251220899321573,
    0.019473754396392998,
    0.043524753809585405,
    0.06371623663872246,
    0.02758552742766217,
    0.026845476675765343,
    0.029432835806681268,
    0.4939597997561797,
    0.012276958817933555,
    0.03390371747191658,
    0.03878525490806829,
    0.03280401819558517,
    0.02996855089043349,
    0.043610944953640665,
    0.07463799480713804,
    0.054973280670314324,
    0.05362263439641399,
    0.03364472557328668,
    0.03257474948646934,
    0.035982127999637514,
    0.03017661243030025,
    0.04004558186048798,
    0.03846182853667192,
    0.017689723726582205,
    0.02581380073796066,
    0.03790654917278124,
    0.0370593711860446,
    0.06765988226898403,
    0.07684458549068582,
    0.05088930944950997,
    0.04274689073720004,
    0.031042698873467,
    0.6025557457581485,
    0.15761319510469404,
    0.09264826777038944,
    0.08001841776554604,
    0.011871825072563895,
    0.664627433433829,
    0.01917232375926572,
    0.01099493090349843,
    0.006261363451393286,
    0.0063648042581234765,
    0.009824297643237445,
    0.005584056437412894,
    0.028902860335050025,
    0.03687758065157599,
    0.013590391879516907,
    0.016166117999544854,
    0.011783888353457304,
    0.01494235041421174,
    0.009445375968215059,
    0.0063181221302946585,
    0.015727070675584043,
    0.011541912177440836,
    0.024826353234049702,
    0.5077727699239808,
    0.345931459929503,
    0.845643164225681,
    0.16794289804370816,
    0.10162406414747382,
    0.14123839370037056,
    0.003792191683109981,
    1.0299547040985766,
    0.026807856101721112,
    0.17653371969231604,
    0.12780393266727977,
    0.8908493894032292,
    0.05016778892928127,
    0.934681359703447,
    0.1104041562314812,
    0.31259370205263126,
    0.06284566928645681,
    0.0476296971944526,
    0.0830049159968845,
    0.009159661389404805,
    0.009991588429808441,
    0.015528991567811172,
    0.009214628598242817,
    0.04463082981364765,
    0.2761646624698818,
    0.02775785294501277,
    0.030920921663565613,
    0.030880088364676584,
    0.055419986988230405,
    0.041834856384027466,
    0.02589530670378627,
    0.046540107091908624,
    0.3004110613744119,
    0.20301909742424815,
    0.4951043096230534,
    0.11858115408807053,
    0.04279910991149764,
    0.023470200843156975,
    0.01592837521137288,
    0.028320290449247595,
    0.01914740566847937,
    0.08423100623656579,
    0.10575781800339631,
    0.016729639837999192,
    0.01928515125899576,
    0.08169190304672652,
    0.043987800607954874,
    0.054514411329818525,
    0.04298134155196387,
    0.031085953544609714,
    0.12615909276179177,
    0.0003465282173637971,
    0.058103130282949,
    0.07365046853595525,
    0.060615225341305666,
    0.04588259821425726,
    0.012813260692314313,
    0.7798777201137593,
    0.02613612797608842,
    0.013461529716750041,
    0.009893951634252595,
    0.030991193644600953,
    0.05620493774258541,
    0.3699038744925965,
    0.015097946393717242,
    0.06271302769749793,
    0.0020384128886200997,
    0.03567165517083371,
    0.014525490144668496,
    0.020607956055678806,
    0.0246435390331219,
    0.019879489642093223,
    0.019407494266871623,
    0.11583263922549474,
    0.03948876108912776,
    0.5294244867375493,
    0.1426857432967834,
    0.009697385429695126,
    0.00525992849031739,
    0.00430141196125398,
    0.005875039927428631,
    0.005522219552694836,
    0.0042607480963535544,
    0.005011184230011202,
    0.007821903345226908,
    0.009009616491770123,
    0.07680989084065051,
    0.07186045769829646,
    0.015555751145719514,
    0.015630740713881576,
    0.057320516556811474,
    0.07343146368625852,
    0.7843452939662691,
    0.07344594465684656,
    0.04994298205930179,
    0.031135505320641476,
    0.025933641798745768,
    0.01973190434263985,
    0.021311914846065032,
    0.025391967733273624,
    0.030199067305597543,
    0.3226950750643045,
    0.014203685630096484,
    0.01534037036997655,
    0.016453107333170788,
    0.010525597809363562,
    0.10166018086042491,
    0.05537516038147018,
    0.025057187459666765,
    0.03937935331770495,
    0.03732606414021839,
    0.03623014247507323,
    0.0303133933027351,
    0.01190830530874745,
    0.05028800045819346,
    0.17635692976160655,
    0.05953594686309811,
    0.020222535641001925,
    0.0805146256571518,
    0.02373659967645878,
    0.012165928750908704,
    0.0514820122407643,
    0.07815653280919697,
    0.23201058369437041,
    0.0340423547943379,
    0.03484151181059308,
    0.018298598649656068,
    0.029716445173173824,
    0.03187810305202435,
    0.010038564502119844,
    0.015603661528300027,
    0.0546445315444071,
    0.0205808711039938,
    0.014522895203654958,
    0.016252765900716146,
    0.019648594042289334,
    0.021480373184972493,
    0.016468148859886997,
    0.007782615606278065,
    0.016094168571066846,
    0.017228336077233373,
    0.01051829618341627,
    0.013373893984522116,
    0.5939814038121429,
    0.020783632669147317,
    0.09311654260907076,
    0.45806162186901805,
    0.016262433777165904,
    0.8009278300362112,
    0.05345785152641949,
    0.2849887196254366,
    0.033647685486223135,
    0.14550079382917516,
    0.03663536045894266,
    0.030880282999975885,
    0.29087772423039293,
    0.021630884822714493,
    0.02556252999484156,
    0.024271715891829745,
    0.05392513908839965,
    0.12206094837643991,
    0.06168160301572301,
    0.7690944309219785,
    0.005753846170923199,
    0.01336445751002951,
    0.02106355972240177,
    0.01879685972329176,
    0.0952444313427708,
    0.1078511795464463,
    0.6469708160164086,
    0.011508214196305674,
    0.04112686678910598,
    0.035610088844009874,
    0.026485811067702324,
    0.014370051474837841,
    0.014242735913957073,
    0.017811674662530638,
    0.05585618250055378,
    0.01738598064185313,
    0.07195021868945746,
    0.015339399943488055,
    0.34467463670324133,
    0.016179746130454448,
    0.06440448684565248,
    0.05608468433498269,
    0.04424636779988501,
    0.037440464051362185,
    0.057664402696718915,
    0.05762190400375552,
    0.06924174005124464,
    0.10847808154508215,
    0.0904310617110173,
    0.047983949715355446,
    0.009818685405935522,
    0.054721988898462984,
    0.034677157404038546,
    0.3509325669208246,
    1.0268344467822377,
    0.23944522020834375,
    0.23057234097441315,
    0.12663716357349866,
    0.06110408862755362,
    0.0706237379606926,
    0.08926016309905949,
    0.04690508445469457,
    0.028732090191940274,
    0.17809611583512075,
    0.029989165393382068,
    0.391596040835184,
    0.12205539606742612,
    0.29440576356307174,
    0.16589103850643355,
    0.006074718243210164,
    1.0268328659759098,
    0.02556053511771133,
    0.04029260310233885,
    0.041439782865155726,
    0.10228632526932319,
    0.08075810970675557,
    0.09598294305539697,
    0.39953051109714005,
    0.029306409486832358,
    0.09671994873655325,
    0.1627823795415789,
    0.02458907783680164,
    0.05986464703306779,
    0.09584181947018754,
    0.11580850896272278,
    0.12535825153862024,
    0.11179598232834778,
    0.058041800368261356,
    0.05131909973307807,
    0.0603260376812227,
    0.05596616469177014,
    0.23658290631261256,
    0.0875715634398609,
    0.40697930337242394,
    0.04985868432498091,
    0.2230670459299213,
    0.06725351272770712,
    0.4384349898078352,
    0.08775397845174246,
    0.3979923162137123,
    0.04290208100438889,
    0.013320545764006694,
    0.04458140027621235
};

static const std::vector<double> turf_bearing = {
    -63.16835850131531,
    0,
    -88.81417863186009,
    -91.84236975943857,
    -66.48043977763521,
    95.21979003833424,
    -100.30570881383704,
    150.61043051772228,
    -42.426806215464694,
    -23.550372000573976,
    -13.952505152879574,
    -43.59833577993832,
    132.99198010189937,
    166.41929543157306,
    177.20325520034712,
    -179.08016176339177,
    -170.23703380143226,
    11.337660289434671,
    -82.74731094370897,
    63.53130497081162,
    8.962738746772079,
    9.37241746920313,
    -168.57228731224598,
    28.730760752589035,
    31.624597764846637,
    29.367864287830926,
    40.81330085442227,
    42.194625737959534,
    54.716993037210045,
    -109.61289479694872,
    -105.95081303007647,
    -97.35442495838333,
    103.73738360872167,
    128.63753291604394,
    139.40255086492127,
    154.353076115606,
    172.41822883056525,
    -173.00067170261374,
    -157.88885299734986,
    -153.5843194614746,
    -135.57055814036255,
    -113.78745742707413,
    -92.43386994136272,
    -80.19821514884795,
    -62.824367973789435,
    -39.24535094117481,
    -19.378190579597625,
    -6.122391240486928,
    10.162381849878825,
    16.628046997768607,
    11.796298622071708,
    9.259418658966705,
    33.013988074027225,
    95.42809952694313,
    99.12772053947573,
    114.05171960306723,
    138.26425923091327,
    115.39825807756951,
    -78.13409883483345,
    -78.57409383589719,
    -87.160852199759,
    -108.19195718984352,
    86.91738524340066,
    84.70017282115018,
    87.95033104208615,
    90.43302815253836,
    78.02446742577152,
    87.86117672643189,
    -69.86932102730815,
    -82.07107484952823,
    -72.86553078555735,
    -65.13553755018475,
    -44.79817086959291,
    -110.571105457802,
    7.7069914618379975,
    14.357081966766243,
    37.06518971504373,
    44.04525332938273,
    66.87692305523359,
    86.3047355297261,
    107.98313958114178,
    119.27773275782387,
    133.08034139008478,
    136.03334417898122,
    147.83958090135633,
    166.35653589386422,
    -174.66648287441066,
    -152.70026365512155,
    -134.67606484413284,
    -102.21019447457768,
    -98.37013738611591,
    -85.39045487355833,
    -83.16251407128772,
    -79.41426027366361,
    -71.6199202393354,
    25.647805187311675,
    171.1662911122707,
    175.31992210998703,
    171.14075667901446,
    168.46991110160218,
    171.99557069100132,
    166.22310505740552,
    1.1490813990525728,
    -160.4320410335643,
    -163.99994946634425,
    -165.7728900157161,
    -173.45680597027817,
    -170.84905103756142,
    -174.09621979366605,
    -175.5476650357732,
    -178.24648292689753,
    -178.90151317182918,
    -172.65900564120977,
    -167.57442915983086,
    -155.7719187979583,
    -147.18225435271103,
    -144.4718825804975,
    -132.58756100092145,
    -127.58358614976032,
    -124.36541206185082,
    -117.43139970416347,
    -114.09107335076804,
    -98.50829769899121,
    -93.15284638637799,
    -92.50530269529919,
    -94.47703726903666,
    -100.11192008297043,
    59.77360017983539,
    9.143285027353551,
    13.771320155516808,
    18.804056386135507,
    24.65786911308088,
    -162.44500486120558,
    -67.84560294942295,
    -41.52913748098395,
    -31.493999863996763,
    -11.862722004156867,
    4.911415384854547,
    20.5768593094366,
    39.328103571820634,
    47.73104506840779,
    60.04949187845642,
    77.68453534325027,
    92.16377287776062,
    106.8766740367609,
    129.48750446573763,
    134.76457530705628,
    148.07063441375706,
    162.56674425873655,
    167.60958213096342,
    -147.58932438111154,
    -0.35602290379352103,
    36.377431696616014,
    149.50345988748333,
    88.36898545914883,
    -12.223747274643541,
    4.239696760480642,
    -175.4876519466847,
    0.5992644178179116,
    0.6673420115819962,
    0.2094907113015796,
    -111.81827272749739,
    0.6404507036839922,
    91.57935182920652,
    -88.72964175221959,
    -72.73595760634777,
    23.023787324470447,
    21.284935274447214,
    20.497437869075558,
    26.023401004269186,
    38.80671567232787,
    55.538280861535505,
    72.4357211583551,
    81.25555219912327,
    71.54335789800336,
    -96.67318521343546,
    -94.1256029846292,
    -92.8904417068675,
    -89.99983922215844,
    -81.74515005128639,
    -73.017109535514,
    -56.65379972139568,
    -75.85450215095052,
    -117.43602194323526,
    -0.5191133757264856,
    138.78810984843733,
    137.56824257563747,
    123.6752409593202,
    118.34970554664147,
    104.79079949099777,
    95.33306354879424,
    88.48636023444747,
    84.26539611797256,
    -89.23804769018248,
    126.44610739090022,
    6.304981289653255,
    9.538566926163998,
    13.280042951632822,
    19.166182380726028,
    21.51585631114597,
    -89.9996339244023,
    -164.35486815306686,
    -163.17151075342585,
    -169.4719802936045,
    -173.09313538953987,
    -173.68544129286698,
    -176.6550060133922,
    -179.38201633291828,
    19.85934450173753,
    26.825916744943097,
    30.042999793582226,
    32.87625705680969,
    30.58584499722022,
    25.48436330531482,
    -49.58528537111213,
    -45.66818093662166,
    -60.58696099977996,
    -44.178097235571066,
    -37.213574067968544,
    -29.02801030830766,
    -20.88386390872622,
    -10.016986251287301,
    -7.470516078862877,
    6.345968960148908,
    4.343209329511361,
    -144.91638104371413,
    91.78645944829398,
    100.57490882565328,
    115.0198771218778,
    126.49515676679046,
    132.9667450433102,
    143.6768700122894,
    152.57244080955854,
    162.6386056371201,
    174.5149571496929,
    180,
    -172.73016111884994,
    -173.57809345551524,
    -170.66439195019734,
    -161.16292504839234,
    -159.27915118031842,
    -162.90191364007953,
    6.149002598385885,
    -178.25002252904207,
    -179.67835798380287,
    -171.71629870718354,
    -163.02862431499696,
    -152.95560774414605,
    -145.55034082696017,
    -138.50963007714628,
    -130.96610418046026,
    -110.60445245954395,
    -63.488932754631335,
    -58.5296285047684,
    -40.784935262998765,
    -33.4011304023945,
    -15.899450270318724,
    -11.98079922175284,
    -8.147813628278488,
    0.8158694642281521,
    15.093060659786769,
    22.923229163325363,
    32.44078804116013,
    42.447012241263664,
    45.83427921173283,
    48.52837549516453,
    49.16371967470212,
    46.12898587570745,
    48.67322750744069,
    -89.99993112361511,
    -131.16855313987196,
    -132.21634274729973,
    -131.43505191524252,
    -131.12876979883848,
    -136.22759997049272,
    -148.82348281194703,
    -154.91921385645844,
    -165.80042858245199,
    -176.30209430550704,
    175.72884637650225,
    169.64893781173248,
    164.32272447851253,
    166.609539892841,
    171.1155850861851,
    166.3637807513156,
    175.0886195159549,
    178.0053467715306,
    -173.15552476803634,
    -163.24971275122377,
    -153.06780391136738,
    -140.2005052574728,
    -130.17077601985082,
    -118.29848203781941,
    96.31992932289273,
    93.37488183764101,
    98.65620852739153,
    -13.220894289645209,
    90.78374679182464,
    -122.38574263089491,
    90.11906042024525,
    90.91606631491278,
    89.24226505678728,
    87.1952301524552,
    89.99989371956251,
    92.89042347389294,
    -73.7442223661134,
    -116.5749747098209,
    -106.68941539794253,
    -96.5786003424879,
    -90.23620894320432,
    -89.42530845705083,
    -89.99982105641459,
    96.0164612641722,
    97.77709140355806,
    89.99996123049279,
    93.32997836025105,
    87.96524189628325,
    90.86961377588838,
    90.23605053342526,
    -44.50763881494917,
    -87.22999594921937,
    -91.08466221917038,
    -89.10502963081117,
    -82.51948924863764,
    -70.55890852242291,
    -61.55042515193161,
    -54.93400664520933,
    -43.708432529297596,
    -42.630819035108374,
    -40.89066031737039,
    -39.768718845646205,
    74.90365235947708,
    -164.2486209384613,
    -166.49009116775852,
    -170.9886716825588,
    -173.2072838154825,
    -176.56563073545988,
    -177.67795564677132,
    -179.256576114407,
    177.6794175196906,
    177.08641995168978,
    -179.7039343413944,
    -162.31174704216053,
    -88.05239082476302,
    104.83933395089112,
    90.91884342553296,
    89.99898193057349,
    -89.65566421438635,
    90.45177683075481,
    90.60742069201243,
    90.35190900335593,
    15.252229486307309,
    -176.88983601147055,
    -170.29517886206932,
    -167.69014730626628,
    -163.75539093753457,
    -160.78980004585748,
    -162.40423641636087,
    11.815918282011998,
    -89.89521786054206,
    -88.44037032865228,
    -90.4221071958824,
    -89.99998237874593,
    89.64945709813418,
    -97.7527834928843,
    -95.70334593407169,
    -92.4612675583479,
    -91.68219351312248,
    -90.94678497047079,
    -90.39810804835399,
    -163.10988605669783,
    18.40425036657263,
    18.419844554057384,
    17.853582297033203,
    12.289104432473655,
    8.709879040159981,
    2.2353614586368535,
    1.0172614149903392,
    -0.34171312935348624,
    0.7663441543155729,
    6.935793519460202,
    9.538556916896354,
    12.252956857370524,
    18.19480908504452,
    -175.0372577909854,
    -89.34475877505189,
    -158.31621119967375,
    -74.8695322495171,
    109.63776192527479,
    92.36950183161946,
    -10.475734036813332,
    90.2902405855761,
    -177.25427215646803,
    -89.10855416703986,
    -173.55458838862484,
    90.5716881361661
};

static const std::vector<cr::point> turf_destination = {
    { -96.92034100000001, 32.82927060622736 },
    { -96.92060772614725, 32.829305975369245 },
    { -96.92079439543319, 32.82931008237797 },
    { -96.92109595102636, 32.829318926002884 },
    { -96.92143033606274, 32.82932450415998 },
    { -96.92175049436656, 32.82938581393253 },
    { -96.92146736784431, 32.82936485157204 },
    { -96.92172490097579, 32.82937161249924 },
    { -96.9213630235027, 32.8285760913059 },
    { -96.92177070843935, 32.82880428175528 },
    { -96.92203788361117, 32.82899017678576 },
    { -96.92233149855905, 32.82939076851167 },
    { -96.92256548517682, 32.82946704822662 },
    { -96.91818769656206, 32.82592900640833 },
    { -96.91832325986564, 32.825805632710264 },
    { -96.91849903664684, 32.82575891598141 },
    { -96.91868196749337, 32.82564384425943 },
    { -96.91898098457527, 32.82510240477685 },
    { -96.91839818728636, 32.8283385839573 },
    { -96.91939827432712, 32.82847636744433 },
    { -96.91827631973166, 32.82907174007224 },
    { -96.91834125479305, 32.82971268589303 },
    { -96.91832704128093, 32.8307271881736 },
    { -96.91985130136207, 32.82516722942136 },
    { -96.91977856038616, 32.825603791320425 },
    { -96.91984148408056, 32.8258148548345 },
    { -96.91993702946877, 32.82599140014963 },
    { -96.91991915091329, 32.826241406696084 },
    { -96.91979779876095, 32.826579853154904 },
    { -96.91558705439019, 32.82925571745485 },
    { -96.91591658029526, 32.829282976817495 },
    { -96.91661047207285, 32.829234607705295 },
    { -96.92007967053509, 32.82895758586908 },
    { -96.9200521621881, 32.82900388634131 },
    { -96.92014087867756, 32.829045483451324 },
    { -96.92024377268062, 32.82908435082749 },
    { -96.92036379723118, 32.829119461406734 },
    { -96.92049790317056, 32.829111787443004 },
    { -96.92067803914178, 32.82898830051573 },
    { -96.92138209750365, 32.82793197154348 },
    { -96.9217141663508, 32.827713770769876 },
    { -96.92187716351988, 32.82779766780548 },
    { -96.92207102285543, 32.827881631620734 },
    { -96.92226470339185, 32.82798563055431 },
    { -96.92246216268975, 32.828102632325134 },
    { -96.92264635970814, 32.82823460404209 },
    { -96.92281225401825, 32.828382512213935 },
    { -96.92295880519139, 32.828539322759674 },
    { -96.92309097382822, 32.82870200101877 },
    { -96.92319872369181, 32.82889451176149 },
    { -96.92312705780591, 32.829556819195616 },
    { -96.9232028626346, 32.82985088699453 },
    { -96.9232411573597, 32.83037567828073 },
    { -96.92269992821585, 32.83134715565532 },
    { -96.9220470103152, 32.83141228122331 },
    { -96.92175545672075, 32.831486016562685 },
    { -96.92171723372269, 32.83156132277095 },
    { -96.921734306369, 32.8316111604673 },
    { -96.92164664653896, 32.831668489803576 },
    { -96.9265483183977, 32.83265027046581 },
    { -96.92685511412476, 32.832821461731555 },
    { -96.92747508633266, 32.83298002241657 },
    { -96.9302621268373, 32.832372910939625 },
    { -96.92926537384224, 32.832561085283594 },
    { -96.92859171846636, 32.832760503071036 },
    { -96.92777413074916, 32.8329291215357 },
    { -96.92643558565632, 32.833062897544984 },
    { -96.92620707047061, 32.83326078761194 },
    { -96.92146356644531, 32.83355674791104 },
    { -96.92179503322653, 32.8337837342936 },
    { -96.92204845102395, 32.83395270229553 },
    { -96.9224428137804, 32.834186607151885 },
    { -96.92272809550946, 32.834423403814895 },
    { -96.92288827790685, 32.83466104696409 },
    { -96.92494226054892, 32.83418049103243 },
    { -96.92485328363847, 32.83519469016151 },
    { -96.92485407643412, 32.835497598333895 },
    { -96.92480870102905, 32.83574916926978 },
    { -96.92475014863298, 32.83598835649724 },
    { -96.92465640380966, 32.83618911335752 },
    { -96.92456145502362, 32.83635039301763 },
    { -96.92449329255402, 32.83647814848498 },
    { -96.92439990743493, 32.836576332621924 },
    { -96.92429828977875, 32.83663289816016 },
    { -96.92403241904934, 32.83653879771671 },
    { -96.92393731871984, 32.836543983800375 },
    { -96.92392597882305, 32.8366104088374 },
    { -96.92394738757146, 32.83667702518138 },
    { -96.92399854388823, 32.83676378512602 },
    { -96.92406844480034, 32.8368666409214 },
    { -96.92418009097368, 32.837003544787805 },
    { -96.92518146526312, 32.837036448933326 },
    { -96.92660860730805, 32.83729030555763 },
    { -96.9268684835029, 32.83747406688541 },
    { -96.92709910606104, 32.837668685163564 },
    { -96.92752148718918, 32.837947112682556 },
    { -96.92582495878467, 32.84104130174476 },
    { -96.92577181513958, 32.841024204874486 },
    { -96.92570941035605, 32.84078977453039 },
    { -96.92557675694083, 32.8403789633218 },
    { -96.92548692274416, 32.840290723966085 },
    { -96.92541287907572, 32.840206009324746 },
    { -96.92530063370805, 32.84010277239874 },
    { -96.92515475186458, 32.84469596626941 },
    { -96.92515515797638, 32.84474454442302 },
    { -96.9252083791398, 32.84460346030672 },
    { -96.92526044659823, 32.84441666763957 },
    { -96.9252473860237, 32.844274120357106 },
    { -96.92524221144033, 32.84415777262634 },
    { -96.92523092269901, 32.843916578859954 },
    { -96.92523052056168, 32.84339549372804 },
    { -96.9251830757581, 32.843048472162685 },
    { -96.92512558963632, 32.842712469390584 },
    { -96.92510010191579, 32.842557440932126 },
    { -96.92510061543786, 32.842415342624996 },
    { -96.92518115035102, 32.84226313063035 },
    { -96.9252757385188, 32.84217676144705 },
    { -96.92544139007872, 32.84202419192918 },
    { -96.92565814381041, 32.84192937929272 },
    { -96.92571903404281, 32.84197028113293 },
    { -96.92585506965108, 32.841975855439806 },
    { -96.92612027958023, 32.84195406060516 },
    { -96.92638469759416, 32.84195185543719 },
    { -96.92700035587634, 32.84199419917395 },
    { -96.92771828543378, 32.84208705149566 },
    { -96.92815651411966, 32.842196372537174 },
    { -96.92850407135272, 32.84229412289962 },
    { -96.92871998933195, 32.84237126366221 },
    { -96.92303556750609, 32.845222756364045 },
    { -96.92265144507935, 32.84674456312207 },
    { -96.9222967307011, 32.84767464651239 },
    { -96.92189950489244, 32.8484749696396 },
    { -96.92172276419579, 32.848689496153796 },
    { -96.9237410893001, 32.843108190296135 },
    { -96.923802546131, 32.84328701670827 },
    { -96.92374965829724, 32.843472940765764 },
    { -96.9236514626933, 32.84363092836846 },
    { -96.92353000280231, 32.84379494600556 },
    { -96.92338332178431, 32.84398896076638 },
    { -96.9232224556523, 32.84413994035114 },
    { -96.92288446231687, 32.844442853078014 },
    { -96.92244837426914, 32.8447656678973 },
    { -96.92217622162691, 32.8449243543985 },
    { -96.92185905928895, 32.84505088281731 },
    { -96.92158293218587, 32.84514022404786 },
    { -96.92127788623063, 32.84519234965051 },
    { -96.92104596927354, 32.84522723186053 },
    { -96.92084223019, 32.84527384359657 },
    { -96.92059571034834, 32.84523815846969 },
    { -96.92039946444064, 32.84522115078961 },
    { -96.92018153243328, 32.84508279557485 },
    { -96.92293075844712, 32.8413060685728 },
    { -96.92278981214417, 32.844490946195606 },
    { -96.91725748845279, 32.85068440564823 },
    { -96.91617826911245, 32.84945342488996 },
    { -96.91492269293347, 32.84954698255384 },
    { -96.91507279822012, 32.85085305805673 },
    { -96.91489851558394, 32.85094963157779 },
    { -96.91559254022775, 32.84177868407015 },
    { -96.91541578881139, 32.842077197188324 },
    { -96.91521892350433, 32.84371915343081 },
    { -96.91503791956701, 32.844920536056705 },
    { -96.92370969579733, 32.84199332911104 },
    { -96.92352559723263, 32.84249151740852 },
    { -96.9133495208793, 32.842304086578224 },
    { -96.91435055467473, 32.84236802303858 },
    { -96.91736376818267, 32.843241314011124 },
    { -96.91691918097388, 32.843797947525246 },
    { -96.91655185513237, 32.84423091241846 },
    { -96.91605785663661, 32.84496119834133 },
    { -96.91583122001299, 32.845063795761554 },
    { -96.91558001680603, 32.84515969596507 },
    { -96.91525830338438, 32.84526189106002 },
    { -96.91497913504723, 32.84530737397885 },
    { -96.9143215696874, 32.84538613848035 },
    { -96.91133267086113, 32.84618717915156 },
    { -96.91144147769786, 32.84617049140981 },
    { -96.91158505725988, 32.84616007150336 },
    { -96.91172846628058, 32.84615291651313 },
    { -96.91213476159362, 32.84615702435345 },
    { -96.912391, 32.84621239377265 },
    { -96.91246923814964, 32.84627902435345 },
    { -96.91269853223814, 32.84650491651311 },
    { -96.91562893644198, 32.84715807150331 },
    { -96.91737052114979, 32.846307491409796 },
    { -96.91723228122223, 32.85074617915096 },
    { -96.91621037304874, 32.84992913847948 },
    { -96.91571580146685, 32.84962737397773 },
    { -96.9153216256599, 32.84948989105859 },
    { -96.91498690323063, 32.84939869596327 },
    { -96.91450969112039, 32.84930779575933 },
    { -96.91412204438035, 32.84926319833858 },
    { -96.9130380189888, 32.84925191241467 },
    { -96.9117296694325, 32.849312947520374 },
    { -96.91172705571321, 32.84927831400496 },
    { -96.91138023411317, 32.849136023030674 },
    { -96.91110422918695, 32.84982408656827 },
    { -96.91084713208613, 32.850169517397084 },
    { -96.91053498353314, 32.85059932909671 },
    { -96.91020684510828, 32.85091453604562 },
    { -96.909908771174, 32.851122153415716 },
    { -96.9110838227085, 32.85106719716819 },
    { -96.91091104294216, 32.851006684047555 },
    { -96.91091850811969, 32.85044663157913 },
    { -96.91089125672022, 32.849733058059954 },
    { -96.91079932847259, 32.84912698255514 },
    { -96.9106847733917, 32.84864942489266 },
    { -96.91052563309422, 32.848464405656216 },
    { -96.9104503638796, 32.84138094620757 },
    { -96.91019122863675, 32.84152706857188 },
    { -96.909963680057, 32.84155779559022 },
    { -96.90974976319653, 32.84155515080656 },
    { -96.90941051524207, 32.841707158486976 },
    { -96.90894698098482, 32.84205784361321 },
    { -96.907088047852, 32.8449732318619 },
    { -96.90705712898402, 32.844972349651776 },
    { -96.90738505824653, 32.845275224047036 },
    { -96.90725393055232, 32.845190882816425 },
    { -96.90737174860608, 32.84532535439583 },
    { -96.9073195827836, 32.84533166789337 },
    { -96.9072824639789, 32.84539385307118 },
    { -96.90723443684865, 32.84549894034094 },
    { -96.90713155058394, 32.845570960754024 },
    { -96.90702084565024, 32.84563794599061 },
    { -96.9067482915646, 32.846564928343774 },
    { -96.90658305728276, 32.846808940736665 },
    { -96.90970849593005, 32.84280201671265 },
    { -96.90805395125876, 32.84264819030043 },
    { -96.90782578893621, 32.84251649621324 },
    { -96.90765104983556, 32.84237896970015 },
    { -96.90749277157009, 32.84223664656806 },
    { -96.90732799202755, 32.842079563171204 },
    { -96.90717674658113, 32.84191675639983 },
    { -96.90704206968707, 32.84175826366903 },
    { -96.90691499740588, 32.84158912290766 },
    { -96.90679856537491, 32.841391372546596 },
    { -96.90669280511362, 32.84118105150652 },
    { -96.9066938088171, 32.84036519919393 },
    { -96.90667954376929, 32.839590855466795 },
    { -96.90660899268886, 32.8393190606389 },
    { -96.9065682357046, 32.83905085547807 },
    { -96.90669333896665, 32.83843228118014 },
    { -96.90683531022513, 32.83766337935074 },
    { -96.9058493401867, 32.844535191894416 },
    { -96.90579009265895, 32.8437347614251 },
    { -96.90571275338846, 32.84314413061774 },
    { -96.90568335053055, 32.8427243426205 },
    { -96.90568992027882, 32.84235744093508 },
    { -96.90571448391348, 32.84205446940046 },
    { -96.90577507033056, 32.84175047218241 },
    { -96.90588970181872, 32.841432493758276 },
    { -96.90607139760981, 32.84110657890376 },
    { -96.90924427251379, 32.83993677269292 },
    { -96.90932412469623, 32.839844120427756 },
    { -96.90941109238025, 32.839765667714516 },
    { -96.9094761887729, 32.83972646038609 },
    { -96.90949143753902, 32.83965354450662 },
    { -96.9097457551243, 32.840379966340876 },
    { -96.90982829424877, 32.84071377238854 },
    { -96.90982905264774, 32.840783009315054 },
    { -96.90978899510543, 32.840982723954376 },
    { -96.9096541510239, 32.84115196330865 },
    { -96.9094755291208, 32.84129677452172 },
    { -96.90927714334165, 32.84137120486853 },
    { -96.9091700108835, 32.84129430174039 },
    { -96.90876609180499, 32.84145311262188 },
    { -96.90733733141684, 32.8423466850824 },
    { -96.90684390666796, 32.8425400667973 },
    { -96.90667976396954, 32.842509305466734 },
    { -96.90602783642515, 32.84283044883231 },
    { -96.9062802255586, 32.84267354468892 },
    { -96.90637988293022, 32.84244464082416 },
    { -96.90679282812866, 32.84197678503523 },
    { -96.90742804933328, 32.84135502510003 },
    { -96.9093096344923, 32.83982640878158 },
    { -96.90957633247281, 32.839448983750096 },
    { -96.90978728295761, 32.83902479767383 },
    { -96.90989146055402, 32.8387198981243 },
    { -96.90999388620241, 32.838305332592356 },
    { -96.91004354245484, 32.83786414846141 },
    { -96.910066394355, 32.83761939299617 },
    { -96.91007046155549, 32.8373271133384 },
    { -96.90994976743183, 32.83670035648537 },
    { -96.90993922639949, 32.83636716925954 },
    { -96.90995885480693, 32.83608559832425 },
    { -96.90996464686559, 32.835791690151794 },
    { -96.90999659070908, 32.83546449101174 },
    { -96.91004166908012, 32.83512104695675 },
    { -96.91011885853125, 32.83482440380857 },
    { -96.91020213813562, 32.8346086071453 },
    { -96.91034250605827, 32.834331702289695 },
    { -96.91052593504799, 32.834065734289304 },
    { -96.91068039981232, 32.83385874790652 },
    { -96.91087788560367, 32.83365678760608 },
    { -96.90463542953506, 32.83292489754698 },
    { -96.90449088650593, 32.83277112153798 },
    { -96.90358630936747, 32.83250350307465 },
    { -96.90479021695444, 32.83637208523084 },
    { -96.90470246266294, 32.836230910887174 },
    { -96.91202899207734, 32.8322360224265 },
    { -96.91154896132278, 32.83209846174101 },
    { -96.90859475679387, 32.83192227047514 },
    { -96.90833234079028, 32.83179248980202 },
    { -96.90687768221198, 32.83172416046592 },
    { -96.90658876308076, 32.83159332277057 },
    { -96.90636454683248, 32.8314500165631 },
    { -96.90946092710227, 32.83205428121599 },
    { -96.90977902424702, 32.83184115564981 },
    { -96.91015472158404, 32.83165067826693 },
    { -96.91052898267965, 32.83150288697713 },
    { -96.9112247739368, 32.83137981917697 },
    { -96.91265206016878, 32.83127151173788 },
    { -96.91343580663084, 32.831154000995156 },
    { -96.90537803849678, 32.83031332274312 },
    { -96.90544558911877, 32.830192512197605 },
    { -96.90543348303062, 32.83008060402599 },
    { -96.90534168189792, 32.82995963230952 },
    { -96.90527614279657, 32.829857630539124 },
    { -96.90439482744506, 32.82973863160623 },
    { -96.90338069160265, 32.829630667791726 },
    { -96.90837537183168, 32.83367677072692 },
    { -96.90864247408625, 32.83358197150447 },
    { -96.9092286278605, 32.833477300486074 },
    { -96.90975778683836, 32.833386787416 },
    { -96.91018890496235, 32.8333244613814 },
    { -96.91048593761097, 32.833276350803445 },
    { -96.91077383813835, 32.833248483428406 },
    { -96.91108555891405, 32.83325388631932 },
    { -96.911656037352, 32.83353258584669 },
    { -96.91194125915716, 32.833565607685266 },
    { -96.91260613703052, 32.83397497679704 },
    { -96.91287366825213, 32.834003717435394 },
    { -96.90947673989618, 32.83473585312356 },
    { -96.9096893960709, 32.83452340666632 },
    { -96.91001755333926, 32.83389040012315 },
    { -96.91028013353335, 32.833324854811124 },
    { -96.91050608380527, 32.83286479129949 },
    { -96.91070135504911, 32.83246622940192 },
    { -96.91089890631574, 32.831888188170744 },
    { -96.91108067612203, 32.83131268588944 },
    { -96.91122561582051, 32.83063574006906 },
    { -96.91134268123285, 32.82960936744224 },
    { -96.91152479752446, 32.828746583956615 },
    { -96.91185890321435, 32.82828840477211 },
    { -96.9121429460756, 32.828246844255986 },
    { -96.91175689101942, 32.828078915978715 },
    { -96.91156667517494, 32.82803463270799 },
    { -96.90799324737107, 32.82799800640653 },
    { -96.91916255109285, 32.82801904822771 },
    { -96.91678353408332, 32.82797076851257 },
    { -96.91450013877316, 32.827920176786314 },
    { -96.91332930884246, 32.827887281755665 },
    { -96.91334197954883, 32.82839409130596 },
    { -96.91356812298534, 32.82773961249966 },
    { -96.91391466280625, 32.8269308515725 },
    { -96.91420753589344, 32.82650381393292 },
    { -96.91447968982843, 32.82624350416024 },
    { -96.915293077956, 32.8247219260031 },
    { -96.91557662496521, 32.82445808237808 },
    { -96.91490527680895, 32.82789997536924 },
    { -96.91639800000002, 32.82790060622736 },
    { -96.91973372334664, 32.82797397536925 },
    { -96.92169538978655, 32.827967082377995 },
    { -96.92194694254597, 32.82797392600294 },
    { -96.91114632526379, 32.82803950416009 },
    { -96.91160348003399, 32.82802081393272 },
    { -96.91221835065487, 32.82799985157229 },
    { -96.91284688086124, 32.82800161249959 },
    { -96.9141260137614, 32.827995091306086 },
    { -96.91517469340017, 32.82800628175562 },
    { -96.91638586344432, 32.82802617678628 },
    { -96.91781138884836, 32.824617768514706 },
    { -96.91789537076589, 32.82489904823005 },
    { -96.91775069192848, 32.82575800640849 },
    { -96.91739830014022, 32.82718763270885 },
    { -96.91752308915034, 32.82744291597945 },
    { -96.91760604628695, 32.82801684425629 },
    { -96.91774511911717, 32.828922404771156 },
    { -96.91790124953417, 32.830010583954504 },
    { -96.91808638066573, 32.831187367439334 },
    { -96.91824645048688, 32.83224474006578 },
    { -96.91834638886598, 32.832817685886084 },
    { -96.91842915877513, 32.83333018816722 },
    { -96.91846471341049, 32.83392022939806 },
    { -96.9184489944202, 32.83446079129487 },
    { -96.91883781971728, 32.83240685481398 },
    { -96.91994337233697, 32.83248340012787 },
    { -96.9217193101751, 32.82915340668562 },
    { -96.92239995502872, 32.82934285314428 },
    { -96.92031602448525, 32.828743717456945 },
    { -96.91975955095923, 32.82879597681961 },
    { -96.92077369032383, 32.83275160768903 },
    { -96.91999391775727, 32.83282958585012 },
    { -96.9203551842353, 32.829339886339575 },
    { -96.92096990474985, 32.82943248344921 },
    { -96.92113979465543, 32.82940235082567 },
    { -96.9208148234328, 32.8294894614045 }
};

static const std::vector<double> turf_lineDistance = {
    0.04662454909427901,
    0.0068391514197623125,
    0.09985216775589113,
    0.1114897011108262,
    0.07753561751121403,
    0.173873577625755,
    0.14681366156746842,
    0.06837599656020085,
    0.43073382183261627,
    0.15584656488988174,
    0.06961927450155198,
    0.4176778492245252,
    0.11346010319030365,
    0.4069191477510672,
    0.0912702817480534,
    0.21057858475480964,
    0.9731217926415133,
    0.3421517057131934,
    0.24832380027187234,
    0.345931459929503,
    0.269566962191182,
    0.003792191683109981,
    0.33114550846131696,
    0.05016778892928127,
    0.1104041562314812,
    0.2820059822767088,
    0.2592491201412077,
    0.20301909742424815,
    0.3324775424083908,
    0.016729639837999192,
    0.2542614100810735,
    0.2514112112841453,
    0.13668774071427742,
    0.3699064116077255,
    0.5100540014631532,
    0.27709292806311164,
    0.7806905867697003,
    0.7768297872678829,
    0.11390017527821808,
    0.016262433777165904,
    0.585110693926173,
    0.30913282118994834,
    0.26207433401586333,
    0.32168722472380185,
    0.6017929391701553,
    0.009818685405935522,
    0.3856097243248631,
    0.5966547247562556,
    0.44360635693488976,
    0.5884269163801416,
    0.3863202991166816,
    1.0477201274090444,
    0.0875715634398609,
    0.04985868432498091,
    0.06725351272770712,
    0.08775397845174246,
    0.04290208100438889,
    0.04458140027621235
};

static const std::vector<double> turf_area = {
    0.00001385291315291015,
    0.00038253063343961127,
    0.0004601665282670179,
    0.000025503489092274364,
    0.000595225685418049,
    0.0000274562733203963,
    0.010106783304640774,
    0.001104280981730458,
    0.00007467453869082208,
    0.00026115590644638464,
    0.0004233598602508744,
    0.010634164210050902,
    0.0001950421991985674,
    0.00045308678876159587,
    0.11642042926261091,
    0.0023790522112468416,
    0.008515769374449783,
    0.007485271287917676,
    0.0000991431197074571,
    0.006085169973921119,
    0.004123438747704956,
    0.010246920654428558,
    0.0017456776108892168,
    0.0012524502918429697,
    0.0002985554527856464,
    0.013319422885021871,
    0.03301062700761473,
    0.005952119850683508,
    0.07276896988546715,
    0.044671110786017286,
    0.00008921566232195025,
    0.0011521493461515583,
    0.002598288702578828,
    0.00017084098623693146,
    0.009460656476931052,
    0.008810544363699217,
    0.00009774280666531308,
    0.000016747619827861367,
    0.005292114515450739,
    0.00050350329460907,
    0.0013371547851014247,
    0.017404511466653897
};

static const std::vector<double> turf_along_dist = {
    0.023312274547139505,
    0.0034195757098811562,
    0.049926083877945567,
    0.0557448505554131,
    0.038767808755607015,
    0.0869367888128775,
    0.07340683078373421,
    0.034187998280100426,
    0.21536691091630814,
    0.07792328244494087,
    0.03480963725077599,
    0.2088389246122626,
    0.05673005159515183,
    0.2034595738755336,
    0.0456351408740267,
    0.10528929237740482,
    0.48656089632075666,
    0.1710758528565967,
    0.12416190013593617,
    0.1729657299647515,
    0.134783481095591,
    0.0018960958415549904,
    0.16557275423065848,
    0.025083894464640634,
    0.0552020781157406,
    0.1410029911383544,
    0.12962456007060386,
    0.10150954871212407,
    0.1662387712041954,
    0.008364819918999596,
    0.12713070504053675,
    0.12570560564207264,
    0.06834387035713871,
    0.18495320580386276,
    0.2550270007315766,
    0.13854646403155582,
    0.39034529338485013,
    0.38841489363394144,
    0.05695008763910904,
    0.008131216888582952,
    0.2925553469630865,
    0.15456641059497417,
    0.13103716700793167,
    0.16084361236190092,
    0.30089646958507765,
    0.004909342702967761,
    0.19280486216243156,
    0.2983273623781278,
    0.22180317846744488,
    0.2942134581900708,
    0.1931601495583408,
    0.5238600637045222,
    0.04378578171993045,
    0.024929342162490455,
    0.03362675636385356,
    0.04387698922587123,
    0.021451040502194443,
    0.022290700138106176
};

static const std::vector<cr::point> turf_along = {
    { -96.92058074705263, 32.838295790638604 },
    { -96.92038500000224, 32.838300500005154 },
    { -96.92017837949811, 32.837840876146984 },
    { -96.91575185809616, 32.834193910150304 },
    { -96.91550349979606, 32.83693300067325 },
    { -96.91447049297071, 32.838291837950294 },
    { -96.91528382138036, 32.83401702016945 },
    { -96.91074827033752, 32.837025468206356 },
    { -96.91465325332314, 32.83491180557744 },
    { -96.9133254981959, 32.83668815734806 },
    { -96.91774498947463, 32.8373234997933 },
    { -96.91858548156746, 32.8367137123682 },
    { -96.912125005592, 32.837061935308064 },
    { -96.91369409219625, 32.83774164388782 },
    { -96.91639766393256, 32.837037707584614 },
    { -96.91504330753082, 32.83916332521944 },
    { -96.91553969265065, 32.83839013773005 },
    { -96.91430070726516, 32.841204555275795 },
    { -96.91571233411688, 32.837779806500336 },
    { -96.9177544997986, 32.83499800000052 },
    { -96.91166706734954, 32.841629875937976 },
    { -96.9107185000003, 32.84265700000001 },
    { -96.91156370689538, 32.83493146645441 },
    { -96.92040000000762, 32.83366850000004 },
    { -96.91099049992684, 32.83367300138629 },
    { -96.91421262070213, 32.83569407895492 },
    { -96.91178370739728, 32.83716800028003 },
    { -96.91715300456607, 32.83775950369486 },
    { -96.9169767353908, 32.840679780152996 },
    { -96.91422649999899, 32.840554000031844 },
    { -96.91397243336206, 32.841584696234726 },
    { -96.91523149763671, 32.84157652148576 },
    { -96.91515150426642, 32.83399134463128 },
    { -96.9142729703425, 32.83879948063655 },
    { -96.9156392575161, 32.835658314541256 },
    { -96.91543436762962, 32.83921014952233 },
    { -96.91983675113876, 32.84033226350925 },
    { -96.92009207607055, 32.840359219198234 },
    { -96.91380542577559, 32.836522062530115 },
    { -96.91423699999902, 32.840453000030095 },
    { -96.91825697483056, 32.836559607150164 },
    { -96.91973317221228, 32.83716163055561 },
    { -96.91180206194203, 32.83642316543709 },
    { -96.91691026889121, 32.84079238934942 },
    { -96.91491045374221, 32.840000370933915 },
    { -96.9150394999991, 32.83688750001095 },
    { -96.91246302385605, 32.83675801387829 },
    { -96.91819499264128, 32.8367903863771 },
    { -96.91518494007596, 32.83533040554249 },
    { -96.91823942303637, 32.83693311262287 },
    { -96.91246139013954, 32.83690233470654 },
    { -96.91460659817584, 32.83801219845079 },
    { -96.91478449997625, 32.840559500872736 },
    { -96.91711949983032, 32.83722250026362 },
    { -96.91476949994939, 32.83659450051385 },
    { -96.91479349998943, 32.84045600087646 },
    { -96.91475749999225, 32.836883000209426 },
    { -96.91476449999463, 32.83676500022616 }
};

static const std::vector<double> turf_lineSlice = {
    0.018676803463204973,
    0.0027403004691342625,
    0.0398660924057463,
    0.04446856326668934,
    0.031068781600570992,
    0.06935062861161241,
    0.05864407770725445,
    0.02738946433808026,
    0.17194340067724667,
    0.062425250268892694,
    0.027897179178562482,
    0.16737293529254177,
    0.04543404915442931,
    0.1626655495109919,
    0.036564726727473594,
    0.08399080442136823,
    0.3888893870284878,
    0.13649098383658884,
    0.09926948806782267,
    0.13795991467073365,
    0.10778696255372587,
    0.0015123931765971925,
    0.1320632508079359,
    0.020007277614733015,
    0.04424096972304277,
    0.11264746401401557,
    0.10385609012115837,
    0.08127435006240627,
    0.13303959829411355,
    0.006704402992819479,
    0.10142852122895935,
    0.10028174144491304,
    0.054573146193032135,
    0.14766725949326992,
    0.20376574794349672,
    0.11058823108803342,
    0.31189004060932496,
    0.3103422255762966,
    0.04563922619445161,
    0.006517162427091035,
    0.23447174477127802,
    0.12386733468968403,
    0.10502105512101395,
    0.12872246637948387,
    0.2400138878407706,
    0.003934657129647942,
    0.1545266007655544,
    0.23909936135356857,
    0.17696967699870225,
    0.23580214129066726,
    0.15480959152734855,
    0.41791703759808313,
    0.035094313148852196,
    0.01997359910854999,
    0.026950444653916276,
    0.03516739283887676,
    0.01719229231376514,
    0.0178652399166501
};

static const std::vector<cr::box> turf_bufferPoint = {
    {{ -96.92206300843843, 32.83681412509083 }, { -96.91861893543, 32.83970785132817 }},
    {{ -96.92214300909791, 32.836848125090825 }, { -96.91869893477045, 32.839741851328164 }},
    {{ -96.92214300909791, 32.836848125090825 }, { -96.91869893477045, 32.839741851328164 }},
    {{ -96.92225800913668, 32.836850125090805 }, { -96.91881393473163, 32.83974385132815 }},
    {{ -96.9224060090591, 32.836846125090815 }, { -96.91896193480923, 32.83973985132816 }},
    {{ -96.92254001000953, 32.83689512509079 }, { -96.91909593385867, 32.83978885132814 }},
    {{ -96.92207100931128, 32.83685912509082 }, { -96.91862693455705, 32.83975285132816 }},
    {{ -96.92214300909791, 32.836848125090825 }, { -96.91869893477045, 32.839741851328164 }},
    {{ -96.92159599327083, 32.83603212509119 }, { -96.91815195059978, 32.838925851328526 }},
    {{ -96.92181899724693, 32.836237125091095 }, { -96.9183749466231, 32.83913085132843 }},
    {{ -96.92190200035026, 32.83639712509101 }, { -96.91845794351933, 32.83929085132836 }},
    {{ -96.92201200756558, 32.836769125090846 }, { -96.91856793630295, 32.83966285132819 }},
    {{ -96.92206300843843, 32.83681412509083 }, { -96.91861893543, 32.83970785132817 }},
    {{ -96.91750293916103, 32.83324212509243 }, { -96.91405900471734, 32.83613585132978 }},
    {{ -96.91745693605817, 32.833082125092524 }, { -96.91401300782061, 32.83597585132986 }},
    {{ -96.91745193439041, 32.83299612509255 }, { -96.91400800948864, 32.83588985132989 }},
    {{ -96.91745493134579, 32.832839125092626 }, { -96.91401101253369, 32.835732851329965 }},
    {{ -96.91757491998197, 32.83225312509288 }, { -96.91413102389916, 32.83514685133023 }},
    {{ -96.91681398182763, 32.83544212509144 }, { -96.91336996204461, 32.83833585132879 }},
    {{ -96.91763698353438, 32.83553012509141 }, { -96.91419296033762, 32.83842385132875 }},
    {{ -96.91633899406605, 32.836073125091154 }, { -96.91289494980445, 32.8389668513285 }},
    {{ -96.91622900543202, 32.836659125090904 }, { -96.91278493843684, 32.83955285132824 }},
    {{ -96.91604102399457, 32.83761612509046 }, { -96.91259691987165, 32.840509851327816 }},
    {{ -96.91739291499829, 32.831996125093006 }, { -96.91394902888356, 32.834889851330345 }},
    {{ -96.91714892225083, 32.83237012509284 }, { -96.91370502162997, 32.83526385133019 }},
    {{ -96.91704192508207, 32.83251612509276 }, { -96.91359801879831, 32.8354098513301 }},
    {{ -96.91696892719582, 32.83262512509271 }, { -96.91352501668426, 32.835518851330065 }},
    {{ -96.91678393068645, 32.83280512509264 }, { -96.91334001319315, 32.83569885132999 }},
    {{ -96.91649693584488, 32.833071125092516 }, { -96.91305300803398, 32.83596485132987 }},
    {{ -96.9121219862885, 32.83567212509135 }, { -96.90867795758311, 32.83856585132869 }},
    {{ -96.91228898531874, 32.83562212509136 }, { -96.90884495855302, 32.838515851328715 }},
    {{ -96.91282198283616, 32.83549412509143 }, { -96.90937796103594, 32.83838785132877 }},
    {{ -96.91613197587343, 32.83513512509158 }, { -96.9126879679997, 32.838028851328936 }},
    {{ -96.91594697513642, 32.835097125091615 }, { -96.91250296873679, 32.83799085132895 }},
    {{ -96.91587997426367, 32.83505212509162 }, { -96.91243596960967, 32.837945851328975 }},
    {{ -96.91582897329396, 32.835002125091656 }, { -96.91238497057954, 32.837895851328994 }},
    {{ -96.91579697220784, 32.83494612509167 }, { -96.91235297166578, 32.837839851329015 }},
    {{ -96.915780970249, 32.83484512509171 }, { -96.9123369736249, 32.83773885132906 }},
    {{ -96.91581296600165, 32.83462612509182 }, { -96.91236897787286, 32.83751985132916 }},
    {{ -96.91637094362142, 32.833472125092335 }, { -96.91292700025633, 32.83636585132968 }},
    {{ -96.91655893745447, 32.833154125092484 }, { -96.91311500642416, 32.83604785132982 }},
    {{ -96.9165799371054, 32.83313612509249 }, { -96.91313600677327, 32.83602985132983 }},
    {{ -96.91663393671753, 32.8331161250925 }, { -96.91319000716118, 32.836009851329834 }},
    {{ -96.91668993667875, 32.83311412509251 }, { -96.91324600719997, 32.83600785132984 }},
    {{ -96.91675193685329, 32.83312312509249 }, { -96.91330800702542, 32.83601685132983 }},
    {{ -96.91680293727993, 32.833145125092486 }, { -96.91335900659871, 32.83603885132984 }},
    {{ -96.91683793797807, 32.833181125092466 }, { -96.91339400590047, 32.83607485132981 }},
    {{ -96.91685593881195, 32.83322412509245 }, { -96.91341200506646, 32.836117851329796 }},
    {{ -96.91686193972342, 32.83327112509243 }, { -96.91341800415486, 32.836164851329784 }},
    {{ -96.91684594117791, 32.8333461250924 }, { -96.9134020027002, 32.836239851329736 }},
    {{ -96.9166529517084, 32.83388912509215 }, { -96.91320899216815, 32.83678285132949 }},
    {{ -96.9166099550635, 32.834062125092075 }, { -96.91316598881261, 32.836955851329414 }},
    {{ -96.91653196285982, 32.83446412509189 }, { -96.91308798101515, 32.83735785132922 }},
    {{ -96.91587697928689, 32.83531112509151 }, { -96.9124329645857, 32.83820485132886 }},
    {{ -96.91511297810382, 32.83525012509153 }, { -96.91166896576897, 32.83814385132888 }},
    {{ -96.91471297705651, 32.83519612509156 }, { -96.91126896681644, 32.83808985132891 }},
    {{ -96.91456897600918, 32.83514212509158 }, { -96.9111249678639, 32.838035851328925 }},
    {{ -96.91448297443822, 32.83506112509162 }, { -96.9110389694351, 32.83795485132896 }},
    {{ -96.91429497298361, 32.834986125091646 }, { -96.9108509708899, 32.83787985132899 }},
    {{ -96.91909898943054, 32.83583412509127 }, { -96.91565495444063, 32.83872785132861 }},
    {{ -96.91931099012878, 32.835870125091255 }, { -96.9158669537423, 32.83876385132859 }},
    {{ -96.91983899055546, 32.83589212509124 }, { -96.91639495331553, 32.838785851328595 }},
    {{ -96.92253697610617, 32.83514712509158 }, { -96.91909296776691, 32.83804085132892 }},
    {{ -96.9214539770565, 32.83519612509156 }, { -96.91800996681643, 32.83808985132891 }},
    {{ -96.9206969782008, 32.835255125091535 }, { -96.91725296567199, 32.83814885132888 }},
    {{ -96.91979897872444, 32.83528212509151 }, { -96.91635496514823, 32.838175851328856 }},
    {{ -96.9183829785499, 32.83527312509153 }, { -96.91493896532283, 32.838166851328864 }},
    {{ -96.91807997959722, 32.8353271250915 }, { -96.91463596427536, 32.83822085132884 }},
    {{ -96.91326498252585, 32.835478125091434 }, { -96.9098209613463, 32.83837185132878 }},
    {{ -96.91352798409686, 32.83555912509139 }, { -96.91008395977508, 32.83845285132874 }},
    {{ -96.91371598452355, 32.83558112509138 }, { -96.91027195934834, 32.83847485132872 }},
    {{ -96.9140479861915, 32.83566712509135 }, { -96.91060395768008, 32.838560851328694 }},
    {{ -96.9142739878983, 32.8357551250913 }, { -96.91082995597309, 32.83864885132865 }},
    {{ -96.91437798960509, 32.835843125091266 }, { -96.91093395426604, 32.83873685132861 }},
    {{ -96.91637897736683, 32.835212125091545 }, { -96.91293496650609, 32.83810585132889 }},
    {{ -96.91623999410484, 32.836075125091156 }, { -96.91279594976567, 32.8389688513285 }},
    {{ -96.91619399703357, 32.836226125091095 }, { -96.9127499468365, 32.83911985132844 }},
    {{ -96.91610499895377, 32.83632512509105 }, { -96.91266094491604, 32.8392188513284 }},
    {{ -96.91600600062179, 32.836411125091 }, { -96.91256194324774, 32.83930485132834 }},
    {{ -96.91587500153341, 32.83645812509098 }, { -96.912430942336, 32.839351851328324 }},
    {{ -96.91574600166918, 32.83646512509099 }, { -96.91230194220022, 32.83935885132834 }},
    {{ -96.91564700114552, 32.83643812509099 }, { -96.912202942724, 32.83933185132834 }},
    {{ -96.91552600003993, 32.83638112509103 }, { -96.91208194382972, 32.83927485132837 }},
    {{ -96.91539999811975, 32.83628212509107 }, { -96.91195594575017, 32.839175851328406 }},
    {{ -96.91511299327082, 32.83603212509119 }, { -96.91166895059978, 32.838925851328526 }},
    {{ -96.91499999034212, 32.83588112509125 }, { -96.91155595352893, 32.838774851328594 }},
    {{ -96.91497398859653, 32.835791125091305 }, { -96.91152995527474, 32.83868485132864 }},
    {{ -96.91498398685096, 32.835701125091326 }, { -96.91153995702057, 32.838594851328665 }},
    {{ -96.9150269854933, 32.83563112509135 }, { -96.91158295837842, 32.8385248513287 }},
    {{ -96.91509198444597, 32.83557712509138 }, { -96.91164795942592, 32.83847085132873 }},
    {{ -96.91520198405807, 32.8355571250914 }, { -96.91175795981388, 32.83845085132874 }},
    {{ -96.91620498165308, 32.835433125091456 }, { -96.9127609622192, 32.8383268513288 }},
    {{ -96.91763698353438, 32.83553012509141 }, { -96.91419296033762, 32.83842385132875 }},
    {{ -96.91790498405807, 32.8355571250914 }, { -96.91446095981388, 32.83845085132874 }},
    {{ -96.91814698479507, 32.83559512509137 }, { -96.91470295907675, 32.83848885132871 }},
    {{ -96.91858398716128, 32.83571712509132 }, { -96.9151399567102, 32.83861085132867 }},
    {{ -96.91690504414862, 32.83865512509 }, { -96.91346089971469, 32.84154885132734 }},
    {{ -96.91687304079277, 32.838482125090074 }, { -96.91342890307102, 32.84137585132741 }},
    {{ -96.91683503322767, 32.838092125090256 }, { -96.91339091063722, 32.840985851327595 }},
    {{ -96.91673002224884, 32.837526125090506 }, { -96.91328592161763, 32.840419851327844 }},
    {{ -96.91667101753538, 32.837283125090615 }, { -96.91322692633173, 32.84017685132796 }},
    {{ -96.9166310128996, 32.83704412509072 }, { -96.9131869309682, 32.83993785132806 }},
    {{ -96.91655600791474, 32.83678712509084 }, { -96.91311193595378, 32.83968085132818 }},
    {{ -96.9164500940436, 32.84122712508884 }, { -96.91300584981255, 32.844120851326174 }},
    {{ -96.91649409202596, 32.84112312508889 }, { -96.9130498518305, 32.84401685132623 }},
    {{ -96.91659408634168, 32.840830125089006 }, { -96.91314985751559, 32.84372385132636 }},
    {{ -96.91669607978447, 32.84049212508917 }, { -96.91325186407373, 32.843385851326516 }},
    {{ -96.91673607410037, 32.8401991250893 }, { -96.91329186975865, 32.84309285132664 }},
    {{ -96.91678706894014, 32.83993312508942 }, { -96.91334287491964, 32.84282685132677 }},
    {{ -96.91683506137448, 32.8395431250896 }, { -96.91339088248637, 32.842436851326944 }},
    {{ -96.91689704839683, 32.8388741250899 }, { -96.91345289546588, 32.84176785132724 }},
    {{ -96.9169150388142, 32.838380125090126 }, { -96.91347090504988, 32.84127385132747 }},
    {{ -96.91692602946458, 32.83789812509034 }, { -96.91348191440086, 32.84079185132768 }},
    {{ -96.91697202364541, 32.83759812509048 }, { -96.91352792022083, 32.84049185132781 }},
    {{ -96.9170470180979, 32.83731212509061 }, { -96.91360292576915, 32.84020585132795 }},
    {{ -96.91720501237589, 32.83701712509073 }, { -96.91376093149196, 32.83991085132807 }},
    {{ -96.91738000795353, 32.836789125090846 }, { -96.91393593591498, 32.83968285132819 }},
    {{ -96.91762900227046, 32.836496125090974 }, { -96.91418494159886, 32.83938985132831 }},
    {{ -96.91793199773183, 32.836262125091075 }, { -96.91448794613815, 32.839155851328414 }},
    {{ -96.91808199585044, 32.83616512509112 }, { -96.9146379480198, 32.83905885132847 }},
    {{ -96.91830999330962, 32.83603412509118 }, { -96.914865950561, 32.83892785132853 }},
    {{ -96.91866999026453, 32.83587712509125 }, { -96.91522595360651, 32.8387708513286 }},
    {{ -96.91903198762677, 32.83574112509132 }, { -96.91558795624465, 32.838634851328656 }},
    {{ -96.9197479858812, 32.83565112509135 }, { -96.91630395799046, 32.8385448513287 }},
    {{ -96.92056898514417, 32.83561312509138 }, { -96.91712495872758, 32.838506851328724 }},
    {{ -96.92111298475629, 32.83559312509138 }, { -96.91766895911556, 32.838486851328724 }},
    {{ -96.92156898417443, 32.83556312509139 }, { -96.9181249596975, 32.838456851328736 }},
    {{ -96.92189598322406, 32.83551412509142 }, { -96.91845196064797, 32.83840785132876 }},
    {{ -96.91632503611791, 32.838241125090185 }, { -96.91288090774655, 32.84113485132754 }},
    {{ -96.91605706325616, 32.83964012508955 }, { -96.91261288060439, 32.8425338513269 }},
    {{ -96.91582107895027, 32.84044912508918 }, { -96.91237686490803, 32.843342851326526 }},
    {{ -96.91554509216175, 32.841130125088874 }, { -96.91210085169466, 32.84402385132622 }},
    {{ -96.9154920940436, 32.84122712508884 }, { -96.91204784981255, 32.844120851326174 }},
    {{ -96.91763698353438, 32.83553012509141 }, { -96.91419296033762, 32.83842385132875 }},
    {{ -96.91782698479507, 32.83559512509137 }, { -96.91438295907676, 32.83848885132871 }},
    {{ -96.91790498623033, 32.83566912509136 }, { -96.91446095764131, 32.83856285132869 }},
    {{ -96.91793998716128, 32.83571712509132 }, { -96.9144959567102, 32.83861085132867 }},
    {{ -96.91795398824742, 32.83577312509131 }, { -96.91450995562391, 32.83866685132865 }},
    {{ -96.91794498995421, 32.83586112509127 }, { -96.91450095391689, 32.8387548513286 }},
    {{ -96.91792399086579, 32.835908125091244 }, { -96.91447995300516, 32.83880185132858 }},
    {{ -96.91772799476429, 32.83610912509115 }, { -96.9142839491061, 32.83900285132848 }},
    {{ -96.91743599908953, 32.83633212509104 }, { -96.91399194478024, 32.839225851328386 }},
    {{ -96.91731000027268, 32.83639312509102 }, { -96.91386594359693, 32.83928685132837 }},
    {{ -96.91714100087395, 32.836424125091014 }, { -96.91369694299557, 32.839317851328346 }},
    {{ -96.91701500079637, 32.83642012509102 }, { -96.91357094307315, 32.839313851328356 }},
    {{ -96.91686200003993, 32.83638112509103 }, { -96.9134179438297, 32.83927485132837 }},
    {{ -96.91678399899256, 32.836327125091046 }, { -96.91333994487724, 32.839220851328385 }},
    {{ -96.91673599821672, 32.83628712509106 }, { -96.91329194565319, 32.83918085132841 }},
    {{ -96.91664699588924, 32.83616712509113 }, { -96.91320294798099, 32.83906085132847 }},
    {{ -96.91660999396908, 32.83606812509117 }, { -96.91316594990144, 32.838961851328506 }},
    {{ -96.91655298974086, 32.83585012509127 }, { -96.91310895413027, 32.8387438513286 }},
    {{ -96.91946491499829, 32.831996125093006 }, { -96.91602102888356, 32.834889851330345 }},
    {{ -96.91948797531097, 32.8351061250916 }, { -96.9160439685622, 32.83799985132893 }},
    {{ -96.9141210940436, 32.84122712508884 }, { -96.91067684981255, 32.844120851326174 }},
    {{ -96.91320906880432, 32.83992612508941 }, { -96.90976487505543, 32.842819851326766 }},
    {{ -96.9121220693087, 32.83995212508941 }, { -96.90867787455099, 32.84284585132676 }},
    {{ -96.91244209338399, 32.84119312508886 }, { -96.90899785047226, 32.844086851326196 }},
    {{ -96.9124390940436, 32.84122712508884 }, { -96.90899484981256, 32.844120851326174 }},
    {{ -96.91330591499829, 32.831996125093006 }, { -96.90986202888357, 32.834889851330345 }},
    {{ -96.9133029196717, 32.83223712509289 }, { -96.90985902420945, 32.835130851330234 }},
    {{ -96.91328095044784, 32.83382412509218 }, { -96.90983699342891, 32.83671785132952 }},
    {{ -96.9132759727315, 32.834973125091665 }, { -96.90983197114207, 32.837866851329 }},
    {{ -96.92212491499828, 32.831996125093006 }, { -96.91868102888355, 32.834889851330345 }},
    {{ -96.92211892374401, 32.8324471250928 }, { -96.91867502013655, 32.83534085133014 }},
    {{ -96.91212191924508, 32.8322151250929 }, { -96.90867802463615, 32.83510885133024 }},
    {{ -96.9133029196717, 32.83223712509289 }, { -96.90985902420945, 32.835130851330234 }},
    {{ -96.91649693584488, 32.833071125092516 }, { -96.91305300803398, 32.83596485132987 }},
    {{ -96.9162339459292, 32.833591125092276 }, { -96.91278999794821, 32.83648485132962 }},
    {{ -96.91604895366716, 32.8339901250921 }, { -96.91260499020915, 32.836883851329446 }},
    {{ -96.9157379672235, 32.8346891250918 }, { -96.91229397665084, 32.83758285132914 }},
    {{ -96.91569496865867, 32.834763125091754 }, { -96.91225097521547, 32.83765685132909 }},
    {{ -96.91562797001627, 32.83483312509173 }, { -96.91218397385767, 32.83772685132906 }},
    {{ -96.91549097154844, 32.83491212509169 }, { -96.9120469723253, 32.83780585132903 }},
    {{ -96.9153969720333, 32.83493712509168 }, { -96.91195297184036, 32.837830851329024 }},
    {{ -96.91492497321636, 32.834998125091644 }, { -96.91148097065712, 32.83789185132899 }},
    {{ -96.91212198846075, 32.835784125091294 }, { -96.90867795541052, 32.83867785132863 }},
    {{ -96.9124169878983, 32.8357551250913 }, { -96.90897295597308, 32.83864885132865 }},
    {{ -96.91274698751039, 32.835735125091325 }, { -96.90930295636103, 32.83862885132866 }},
    {{ -96.91307698723887, 32.835721125091325 }, { -96.90963295663262, 32.838614851328664 }},
    {{ -96.91366998723886, 32.835721125091325 }, { -96.9102259566326, 32.838614851328664 }},
    {{ -96.91411298828622, 32.835775125091295 }, { -96.91066895558512, 32.83866885132864 }},
    {{ -96.91437798960509, 32.835843125091266 }, { -96.91093395426604, 32.83873685132861 }},
    {{ -96.91479399406605, 32.836073125091154 }, { -96.91134994980445, 32.8389668513285 }},
    {{ -96.91791100686734, 32.83673312509086 }, { -96.91446693700134, 32.83962685132821 }},
    {{ -96.91983899055546, 32.83589212509124 }, { -96.91639495331553, 32.838785851328595 }},
    {{ -96.9198870768939, 32.84034312508924 }, { -96.9164428669647, 32.84323685132657 }},
    {{ -96.91905106133568, 32.8395411250896 }, { -96.91560688252517, 32.84243485132695 }},
    {{ -96.91874205582643, 32.83925712508973 }, { -96.91529788803521, 32.84215085132708 }},
    {{ -96.91853305355679, 32.839140125089784 }, { -96.91508889030517, 32.84203385132712 }},
    {{ -96.9183830522377, 32.83907212508981 }, { -96.91493889162446, 32.84196585132715 }},
    {{ -96.9180900509768, 32.83900712508984 }, { -96.91464589288553, 32.84190085132718 }},
    {{ -96.91788605066641, 32.83899112508985 }, { -96.91444189319596, 32.84188485132719 }},
    {{ -96.9169850510544, 32.83901112508983 }, { -96.91354089280793, 32.84190485132717 }},
    {{ -96.91585905289725, 32.83910612508979 }, { -96.91241489096481, 32.84199985132713 }},
    {{ -96.91603805293605, 32.839108125089794 }, { -96.91259389092602, 32.84200185132714 }},
    {{ -96.915872050938, 32.83900512508984 }, { -96.91242789292434, 32.84189885132718 }},
    {{ -96.91577606509908, 32.83973512508951 }, { -96.91233187876121, 32.84262885132685 }},
    {{ -96.91569807266481, 32.84012512508934 }, { -96.91225387119442, 32.843018851326676 }},
    {{ -96.91556408191846, 32.84060212508912 }, { -96.91211986193943, 32.84349585132646 }},
    {{ -96.9154130889995, 32.84096712508895 }, { -96.91196885485739, 32.8438608513263 }},
    {{ -96.9152910940436, 32.84122712508884 }, { -96.91184684981255, 32.844120851326174 }},
    {{ -96.9166410940436, 32.84122712508884 }, { -96.91319684981255, 32.844120851326174 }},
    {{ -96.9166420939854, 32.841224125088836 }, { -96.91319784987074, 32.844117851326175 }},
    {{ -96.91682208428526, 32.84072412508907 }, { -96.9133778595723, 32.84361785132641 }},
    {{ -96.91696607165603, 32.84007312508936 }, { -96.91352187220332, 32.8429668513267 }},
    {{ -96.91704406116109, 32.839532125089605 }, { -96.91359988269978, 32.84242585132694 }},
    {{ -96.91709805320761, 32.83912212508979 }, { -96.91365389065439, 32.84201585132713 }},
    {{ -96.91710605097681, 32.83900712508984 }, { -96.91366189288554, 32.84190085132718 }},
    {{ -96.91719591499829, 32.831996125093006 }, { -96.91375202888356, 32.834889851330345 }},
    {{ -96.91710091928385, 32.83221712509291 }, { -96.91365702459737, 32.83511085133024 }},
    {{ -96.91703592137819, 32.832325125092865 }, { -96.91359202250273, 32.835218851330204 }},
    {{ -96.91698292287138, 32.83240212509282 }, { -96.91353902100933, 32.83529585133016 }},
    {{ -96.91680292740914, 32.832636125092705 }, { -96.91335901647092, 32.83552985133006 }},
    {{ -96.91649693584488, 32.833071125092516 }, { -96.91305300803398, 32.83596485132987 }},
    {{ -96.91479399406605, 32.836073125091154 }, { -96.91134994980445, 32.8389668513285 }},
    {{ -96.91491699577286, 32.836161125091124 }, { -96.9114729480974, 32.83905485132847 }},
    {{ -96.91539700341482, 32.836555125090946 }, { -96.91195294045433, 32.83944885132829 }},
    {{ -96.91541600358939, 32.83656412509095 }, { -96.91197194027974, 32.839457851328284 }},
    {{ -96.91568200805051, 32.83679412509083 }, { -96.91223793581798, 32.83968785132818 }},
    {{ -96.9157760100677, 32.83689812509079 }, { -96.91233193380047, 32.83979185132812 }},
    {{ -96.91588301320994, 32.837060125090716 }, { -96.91243893065779, 32.83995385132806 }},
    {{ -96.91597701722505, 32.83726712509063 }, { -96.91253292664213, 32.840160851327965 }},
    {{ -96.9160140206389, 32.83744312509054 }, { -96.91256992322779, 32.84033685132788 }},
    {{ -96.91604102399457, 32.83761612509046 }, { -96.91259691987165, 32.840509851327816 }},
    {{ -96.91590404407103, 32.83865112509 }, { -96.9124598997923, 32.84154485132734 }},
    {{ -96.915872050938, 32.83900512508984 }, { -96.91242789292434, 32.84189885132718 }},
    {{ -96.91912797538855, 32.835110125091596 }, { -96.91568396848461, 32.838003851328935 }},
    {{ -96.91760197461278, 32.83507012509161 }, { -96.91415796926053, 32.837963851328965 }},
    {{ -96.91749997430246, 32.83505412509162 }, { -96.91405596957087, 32.83794785132897 }},
    {{ -96.91744897391457, 32.835034125091624 }, { -96.91400496995882, 32.83792785132896 }},
    {{ -96.91741197346849, 32.83501112509164 }, { -96.91396797040495, 32.837904851328986 }},
    {{ -96.91736597277028, 32.83497512509165 }, { -96.91392197110326, 32.83786885132899 }},
    {{ -96.91733097199452, 32.83493512509168 }, { -96.91388697187915, 32.83782885132902 }},
    {{ -96.91730997133509, 32.8349011250917 }, { -96.91386597253866, 32.837794851329036 }},
    {{ -96.91729397050113, 32.834858125091706 }, { -96.91384997337273, 32.83775185132905 }},
    {{ -96.91728596914353, 32.83478812509174 }, { -96.91384197473054, 32.83768185132909 }},
    {{ -96.9172859675726, 32.83470712509179 }, { -96.91384197630171, 32.837600851329114 }},
    {{ -96.91738995428774, 32.83402212509209 }, { -96.91394598958846, 32.83691585132943 }},
    {{ -96.91747594183725, 32.833380125092376 }, { -96.91403200204074, 32.83627385132972 }},
    {{ -96.91750293916103, 32.83324212509243 }, { -96.91405900471734, 32.83613585132978 }},
    {{ -96.9175569365818, 32.833109125092506 }, { -96.91411300729696, 32.83600285132985 }},
    {{ -96.9177739272346, 32.83262712509272 }, { -96.91433001664547, 32.83552085133007 }},
    {{ -96.91800491499829, 32.831996125093006 }, { -96.91456102888357, 32.834889851330345 }},
    {{ -96.91710605097681, 32.83900712508984 }, { -96.91366189288554, 32.84190085132718 }},
    {{ -96.91713003817407, 32.83834712509014 }, { -96.9136859056901, 32.84124085132747 }},
    {{ -96.91713302946458, 32.83789812509034 }, { -96.91368891440086, 32.84079185132768 }},
    {{ -96.91718102409155, 32.83762112509046 }, { -96.91373691977464, 32.840514851327804 }},
    {{ -96.91726201976603, 32.83739812509056 }, { -96.91381792410078, 32.8402918513279 }},
    {{ -96.91735801670134, 32.83724012509064 }, { -96.91391392716592, 32.840133851327984 }},
    {{ -96.91748701363667, 32.83708212509072 }, { -96.91404293023102, 32.83997585132805 }},
    {{ -96.91766701031987, 32.836911125090786 }, { -96.91422293354829, 32.83980485132813 }},
    {{ -96.91791100686734, 32.83673312509086 }, { -96.91446693700134, 32.83962685132821 }},
    {{ -96.9211429870643, 32.83571212509132 }, { -96.91769895680719, 32.838605851328666 }},
    {{ -96.92127898816983, 32.83576912509129 }, { -96.9178349557015, 32.83866285132864 }},
    {{ -96.92141898956629, 32.83584112509127 }, { -96.91797495430484, 32.83873485132861 }},
    {{ -96.92153399173858, 32.83595312509122 }, { -96.91808995213223, 32.83884685132857 }},
    {{ -96.92159599327083, 32.83603212509119 }, { -96.91815195059978, 32.838925851328526 }},
    {{ -96.92189401031986, 32.836911125090786 }, { -96.91844993354829, 32.83980485132813 }},
    {{ -96.92201701976603, 32.83739812509056 }, { -96.91857292410077, 32.8402918513279 }},
    {{ -96.92205502409155, 32.83762112509046 }, { -96.91861091977464, 32.840514851327804 }},
    {{ -96.92204903095816, 32.83797512509031 }, { -96.91860491290703, 32.84086885132764 }},
    {{ -96.92194503724296, 32.83829912509015 }, { -96.91850090662132, 32.84119285132749 }},
    {{ -96.92179404306233, 32.83859912509002 }, { -96.91834990080113, 32.84149285132736 }},
    {{ -96.9216200475239, 32.83882912508992 }, { -96.91817589633894, 32.84172285132727 }},
    {{ -96.92153404905635, 32.83890812508988 }, { -96.91808989480624, 32.84180185132723 }},
    {{ -96.92114805516688, 32.839223125089745 }, { -96.91770388869487, 32.842116851327084 }},
    {{ -96.91973407553594, 32.84027312508926 }, { -96.91628986832288, 32.84316685132661 }},
    {{ -96.91925208232587, 32.8406231250891 }, { -96.91580786153199, 32.84351685132645 }},
    {{ -96.91909608477026, 32.84074912508905 }, { -96.91565185908723, 32.8436428513264 }},
    {{ -96.9184490940436, 32.84122712508884 }, { -96.91500484981255, 32.844120851326174 }},
    {{ -96.91870309404361, 32.84122712508884 }, { -96.91525884981256, 32.844120851326174 }},
    {{ -96.91880109264676, 32.841155125088875 }, { -96.9153568512096, 32.84404885132621 }},
    {{ -96.91920908661328, 32.84084412508902 }, { -96.91576485724394, 32.84373785132635 }},
    {{ -96.91983607759231, 32.840379125089214 }, { -96.91639186626621, 32.84327285132656 }},
    {{ -96.92170605097681, 32.83900712508984 }, { -96.91826189288554, 32.84190085132718 }},
    {{ -96.92195804668978, 32.83878612508993 }, { -96.91851389717318, 32.84167985132728 }},
    {{ -96.9221510414911, 32.838518125090054 }, { -96.91870690237259, 32.84141185132741 }},
    {{ -96.92223403860082, 32.83836912509012 }, { -96.91878990526328, 32.841262851327464 }},
    {{ -96.92231203357683, 32.838110125090246 }, { -96.918867910288, 32.841003851327585 }},
    {{ -96.92233402802918, 32.83782412509037 }, { -96.91888991583646, 32.84071785132771 }},
    {{ -96.92232602628341, 32.837734125090414 }, { -96.91888191758245, 32.84062785132776 }},
    {{ -96.92229602360662, 32.83759612509048 }, { -96.91885192025964, 32.84048985132782 }},
    {{ -96.92213801443192, 32.83712312509069 }, { -96.91869392943565, 32.84001685132803 }},
    {{ -96.92208701094057, 32.83694312509076 }, { -96.91864293292753, 32.83983685132811 }},
    {{ -96.92206300843843, 32.83681412509083 }, { -96.91861893543, 32.83970785132817 }},
    {{ -96.92202200568417, 32.836672125090885 }, { -96.91857793818467, 32.83956585132823 }},
    {{ -96.92200400227046, 32.836496125090974 }, { -96.91855994159886, 32.83938985132831 }},
    {{ -96.92199599852705, 32.836303125091064 }, { -96.9185519453428, 32.8391968513284 }},
    {{ -96.92201699567589, 32.83615612509112 }, { -96.91857294819438, 32.83904985132846 }},
    {{ -96.92204099437637, 32.836089125091156 }, { -96.91859694949407, 32.8389828513285 }},
    {{ -96.92211899187434, 32.83596012509121 }, { -96.91867495199645, 32.83885385132855 }},
    {{ -96.9222369895663, 32.83584112509127 }, { -96.91879295430485, 32.83873485132861 }},
    {{ -96.92232298838319, 32.8357801250913 }, { -96.91887895548814, 32.83867385132864 }},
    {{ -96.92244898727766, 32.83572312509131 }, { -96.91900495659381, 32.83861685132866 }},
    {{ -96.91613197587343, 32.83513512509158 }, { -96.9126879679997, 32.838028851328936 }},
    {{ -96.91590997566009, 32.8351241250916 }, { -96.91246596821304, 32.83801785132894 }},
    {{ -96.91492497321636, 32.834998125091644 }, { -96.91148097065712, 32.83789185132899 }},
    {{ -96.9160460509768, 32.83900712508984 }, { -96.91260189288553, 32.84190085132718 }},
    {{ -96.915872050938, 32.83900512508984 }, { -96.91242789292434, 32.84189885132718 }},
    {{ -96.92310897612555, 32.83514812509159 }, { -96.91966496774752, 32.838041851328924 }},
    {{ -96.92253697610617, 32.83514712509158 }, { -96.91909296776691, 32.83804085132892 }},
    {{ -96.91948797531097, 32.8351061250916 }, { -96.9160439685622, 32.83799985132893 }},
    {{ -96.91912797538855, 32.835110125091596 }, { -96.91568396848461, 32.838003851328935 }},
    {{ -96.91757297662981, 32.83517412509158 }, { -96.91412896724319, 32.838067851328915 }},
    {{ -96.91718097662981, 32.83517412509158 }, { -96.91373696724318, 32.838067851328915 }},
    {{ -96.91685097635828, 32.835160125091576 }, { -96.91340696751473, 32.838053851328915 }},
    {{ -96.91983899055546, 32.83589212509124 }, { -96.91639495331553, 32.838785851328595 }},
    {{ -96.92004598886807, 32.83580512509128 }, { -96.91660195500317, 32.838698851328616 }},
    {{ -96.92030798758799, 32.835739125091315 }, { -96.91686395628346, 32.83863285132866 }},
    {{ -96.9205659871031, 32.83571412509132 }, { -96.91712195676841, 32.83860785132867 }},
    {{ -96.9211429870643, 32.83571212509132 }, { -96.91769895680719, 32.838605851328666 }},
    {{ -96.92244898727766, 32.83572312509131 }, { -96.91900495659381, 32.83861685132866 }},
    {{ -96.92310898727766, 32.83572312509131 }, { -96.9196649565938, 32.83861685132866 }},
    {{ -96.91492497321636, 32.834998125091644 }, { -96.91148097065712, 32.83789185132899 }},
    {{ -96.9148639730806, 32.83499112509165 }, { -96.9114199707929, 32.83788485132899 }},
    {{ -96.9147209730806, 32.83499112509165 }, { -96.91127697079291, 32.83788485132899 }},
    {{ -96.91449597286727, 32.834980125091654 }, { -96.91105197100629, 32.837873851329 }},
    {{ -96.91429497298361, 32.834986125091646 }, { -96.9108509708899, 32.83787985132899 }},
    {{ -96.9132759727315, 32.834973125091665 }, { -96.90983197114207, 32.837866851329 }},
    {{ -96.91212197265392, 32.83496912509166 }, { -96.90867797121963, 32.83786285132901 }},
    {{ -96.91697505311063, 32.839117125089786 }, { -96.9135308907514, 32.842010851327124 }},
    {{ -96.91709805320761, 32.83912212508979 }, { -96.91365389065439, 32.84201585132713 }},
    {{ -96.91753805307184, 32.83911512508979 }, { -96.9140938907902, 32.84200885132714 }},
    {{ -96.91791905316883, 32.83912012508979 }, { -96.91447489069319, 32.842013851327124 }},
    {{ -96.91820005377018, 32.83915112508977 }, { -96.91475589009175, 32.842044851327124 }},
    {{ -96.91834505460432, 32.839194125089755 }, { -96.91490088925751, 32.84208785132709 }},
    {{ -96.91847905578763, 32.83925512508973 }, { -96.91503488807402, 32.842148851327075 }},
    {{ -96.9186350575723, 32.83934712508969 }, { -96.91519088628907, 32.84224085132703 }},
    {{ -96.9190480646141, 32.83971012508952 }, { -96.91560387924628, 32.84260385132687 }},
    {{ -96.91917406684502, 32.83982512508947 }, { -96.91572987701505, 32.8427188513268 }},
    {{ -96.91967807633132, 32.84031412508924 }, { -96.91623386752738, 32.843207851326596 }},
    {{ -96.91978307838768, 32.8404201250892 }, { -96.9163388654707, 32.84331385132655 }},
    {{ -96.9162220940436, 32.84122712508884 }, { -96.91277784981256, 32.844120851326174 }},
    {{ -96.91626909132755, 32.841087125088904 }, { -96.912824852529, 32.84398085132624 }},
    {{ -96.91643008040526, 32.84052412508915 }, { -96.91298586345285, 32.84341785132649 }},
    {{ -96.91652407074426, 32.84002612508938 }, { -96.91307987311522, 32.84291985132673 }},
    {{ -96.91658006308158, 32.83963112508957 }, { -96.91313588077902, 32.8425248513269 }},
    {{ -96.91660405656359, 32.839295125089706 }, { -96.91315988729797, 32.842188851327045 }},
    {{ -96.9166290465152, 32.83877712508994 }, { -96.91318489734778, 32.84167085132729 }},
    {{ -96.91663703646707, 32.83825912509018 }, { -96.91319290739735, 32.84115285132752 }},
    {{ -96.91660702440191, 32.83763712509046 }, { -96.91316291946426, 32.840530851327806 }},
    {{ -96.9165480055096, 32.83666312509089 }, { -96.91310393835924, 32.83955685132825 }},
    {{ -96.91655298974086, 32.83585012509127 }, { -96.91310895413027, 32.8387438513286 }},
    {{ -96.91670898176945, 32.83543912509145 }, { -96.91326496210282, 32.838332851328786 }},
    {{ -96.91681398182763, 32.83544212509144 }, { -96.91336996204461, 32.83833585132879 }},
    {{ -96.91624797938387, 32.83531612509151 }, { -96.91280396448872, 32.83820985132885 }},
    {{ -96.91587697928689, 32.83531112509151 }, { -96.9124329645857, 32.83820485132886 }},
    {{ -96.9121219792869, 32.83531112509151 }, { -96.9086779645857, 32.83820485132886 }},
    {{ -96.92310898035362, 32.83536612509148 }, { -96.91966496351884, 32.83825985132882 }},
    {{ -96.9205469800239, 32.83534912509149 }, { -96.9171029638486, 32.838242851328836 }},
    {{ -96.91807997959722, 32.8353271250915 }, { -96.91463596427536, 32.83822085132884 }},
    {{ -96.91672497946146, 32.83532012509149 }, { -96.91328096441114, 32.838213851328845 }},
    {{ -96.91655298974086, 32.83585012509127 }, { -96.91310895413027, 32.8387438513286 }},
    {{ -96.91659397744439, 32.835216125091556 }, { -96.91314996642849, 32.838109851328895 }},
    {{ -96.91675496210344, 32.834425125091904 }, { -96.91331098177162, 32.83731885132925 }},
    {{ -96.91686195411319, 32.8340131250921 }, { -96.91341798976302, 32.83690685132943 }},
    {{ -96.91694794930363, 32.83376512509221 }, { -96.9135039945733, 32.836658851329545 }},
    {{ -96.91757491998197, 32.83225312509288 }, { -96.91413102389916, 32.83514685133023 }},
    {{ -96.91767191499827, 32.831996125093006 }, { -96.91422802888354, 32.834889851330345 }},
    {{ -96.91681398182763, 32.83544212509144 }, { -96.91336996204461, 32.83833585132879 }},
    {{ -96.91811998186644, 32.835444125091456 }, { -96.91467596200583, 32.838337851328795 }},
    {{ -96.92126898326285, 32.835516125091424 }, { -96.91782496060918, 32.83840985132876 }},
    {{ -96.92304398304951, 32.835505125091416 }, { -96.91959996082257, 32.838398851328755 }},
    {{ -96.92310898304952, 32.835505125091416 }, { -96.91966496082256, 32.838398851328755 }},
    {{ -96.91212198413564, 32.835561125091395 }, { -96.90867795973627, 32.838454851328734 }},
    {{ -96.91239298353439, 32.83553012509141 }, { -96.90894896033761, 32.83842385132875 }},
    {{ -96.91282198283616, 32.83549412509143 }, { -96.90937796103594, 32.83838785132877 }},
    {{ -96.91326498252585, 32.835478125091434 }, { -96.9098209613463, 32.83837185132878 }},
    {{ -96.9143589820022, 32.83545112509144 }, { -96.91091496187005, 32.838344851328785 }},
    {{ -96.91522298176945, 32.83543912509145 }, { -96.91177896210282, 32.838332851328786 }},
    {{ -96.91624998165308, 32.835433125091456 }, { -96.9128059622192, 32.8383268513288 }},
    {{ -96.91749191499827, 32.831996125093006 }, { -96.91404802888356, 32.834889851330345 }},
    {{ -96.91739291984624, 32.83224612509289 }, { -96.91394902403492, 32.835139851330226 }},
    {{ -96.91706593584487, 32.833071125092516 }, { -96.91362200803398, 32.83596485132987 }},
    {{ -96.91653196285982, 32.83446412509189 }, { -96.91308798101515, 32.83735785132922 }},
    {{ -96.91647596704895, 32.83468012509178 }, { -96.91303197682542, 32.83757385132914 }},
    {{ -96.91637897736683, 32.835212125091545 }, { -96.91293496650609, 32.83810585132889 }},
    {{ -96.91633899406605, 32.836073125091154 }, { -96.91289494980445, 32.8389668513285 }},
    {{ -96.91631701425736, 32.837114125090686 }, { -96.91287292961024, 32.84000785132803 }},
    {{ -96.91632503611791, 32.838241125090185 }, { -96.91288090774655, 32.84113485132754 }},
    {{ -96.91630905561304, 32.83924612508974 }, { -96.91286488824862, 32.84213985132708 }},
    {{ -96.91623406566167, 32.8397641250895 }, { -96.91278987819858, 32.84265785132684 }},
    {{ -96.91614307448836, 32.84021912508929 }, { -96.9126988693706, 32.84311285132663 }},
    {{ -96.91600608477026, 32.84074912508905 }, { -96.91256185908722, 32.8436428513264 }},
    {{ -96.91581909404358, 32.84122712508884 }, { -96.91237484981255, 32.844120851326174 }},
    {{ -96.91603805293605, 32.839108125089794 }, { -96.91259389092602, 32.84200185132714 }},
    {{ -96.91697505311063, 32.839117125089786 }, { -96.9135308907514, 32.842010851327124 }},
    {{ -96.91858398716128, 32.83571712509132 }, { -96.9151399567102, 32.83861085132867 }},
    {{ -96.91909898943054, 32.83583412509127 }, { -96.91565495444063, 32.83872785132861 }},
    {{ -96.91685097635828, 32.835160125091576 }, { -96.91340696751473, 32.838053851328915 }},
    {{ -96.91613197587343, 32.83513512509158 }, { -96.9126879679997, 32.838028851328936 }},
    {{ -96.9169850510544, 32.83901112508983 }, { -96.91354089280793, 32.84190485132717 }},
    {{ -96.9160460509768, 32.83900712508984 }, { -96.91260189288553, 32.84190085132718 }},
    {{ -96.91624998165308, 32.835433125091456 }, { -96.9128059622192, 32.8383268513288 }},
    {{ -96.91670898176945, 32.83543912509145 }, { -96.91326496210282, 32.838332851328786 }},
    {{ -96.91672497946146, 32.83532012509149 }, { -96.91328096441114, 32.838213851328845 }},
    {{ -96.91624797938387, 32.83531612509151 }, { -96.91280396448872, 32.83820985132885 }}
};
