#!/usr/bin/env bash

MASON_NAME=cmake
MASON_VERSION=3.5.2
MASON_LIB_FILE=bin/cmake

. ${MASON_DIR}/mason.sh

function mason_load_source {
    mason_download \
        https://www.cmake.org/files/v3.5/cmake-${MASON_VERSION}.tar.gz \
        70cbd618e8ac39414928d79c949968e7dd7a5605

    mason_extract_tar_gz

    export MASON_BUILD_PATH=${MASON_ROOT}/.build/${MASON_NAME}-${MASON_VERSION}
}

function mason_compile {
    ./configure --prefix=${MASON_PREFIX}
    make -j${MASON_CONCURRENCY} VERBOSE=1
    make install
}

function mason_cflags {
    :
}

function mason_ldflags {
    :
}

function mason_clean {
    make clean
}

mason_run "$@"
