#!/usr/bin/env bash

LIB_VERSION=4.1.2

MASON_NAME=geojsonvt
MASON_VERSION=${LIB_VERSION}-cxx11abi
MASON_LIB_FILE=lib/libgeojsonvt.a

. ${MASON_DIR}/mason.sh

function mason_load_source {
    mason_download \
        https://github.com/mapbox/geojson-vt-cpp/archive/v${LIB_VERSION}.tar.gz \
        a98f44ee9f059e41a90dfed7e4c256c76ea4076a

    mason_extract_tar_gz

    export MASON_BUILD_PATH=${MASON_ROOT}/.build/geojson-vt-cpp-${LIB_VERSION}
}

function mason_compile {
    # setup mason
    rm -rf .mason
    ln -s ${MASON_DIR} .mason

    # Force Linux Makefiles when cross-compiling for Android
    if [[ ${MASON_PLATFORM:-} == 'android' ]] ; then
        export GYP_FLAVOR_SUFFIX=-linux
    fi

    # build
    INSTALL_PREFIX=${MASON_PREFIX} ./configure
    CXXFLAGS="-fPIC ${CFLAGS:-} ${CXXFLAGS:-}" make install
}

function mason_cflags {
    echo -I${MASON_PREFIX}/include
}

function mason_ldflags {
    :
}

function mason_static_libs {
    echo ${MASON_PREFIX}/lib/libgeojsonvt.a
}

mason_run "$@"
