# Protocol Documentation
<a name="top"></a>

## Table of Contents

- [kuksa/val/v2/val.proto](#kuksa_val_v2_val-proto)
    - [ActuateRequest](#kuksa-val-v2-ActuateRequest)
    - [ActuateResponse](#kuksa-val-v2-ActuateResponse)
    - [BatchActuateRequest](#kuksa-val-v2-BatchActuateRequest)
    - [BatchActuateResponse](#kuksa-val-v2-BatchActuateResponse)
    - [BatchActuateStreamRequest](#kuksa-val-v2-BatchActuateStreamRequest)
    - [BatchActuateStreamResponse](#kuksa-val-v2-BatchActuateStreamResponse)
    - [GetProviderValueRequest](#kuksa-val-v2-GetProviderValueRequest)
    - [GetProviderValueResponse](#kuksa-val-v2-GetProviderValueResponse)
    - [GetProviderValueResponse.EntriesEntry](#kuksa-val-v2-GetProviderValueResponse-EntriesEntry)
    - [GetServerInfoRequest](#kuksa-val-v2-GetServerInfoRequest)
    - [GetServerInfoResponse](#kuksa-val-v2-GetServerInfoResponse)
    - [GetValueRequest](#kuksa-val-v2-GetValueRequest)
    - [GetValueResponse](#kuksa-val-v2-GetValueResponse)
    - [GetValuesRequest](#kuksa-val-v2-GetValuesRequest)
    - [GetValuesResponse](#kuksa-val-v2-GetValuesResponse)
    - [ListMetadataRequest](#kuksa-val-v2-ListMetadataRequest)
    - [ListMetadataResponse](#kuksa-val-v2-ListMetadataResponse)
    - [OpenProviderStreamRequest](#kuksa-val-v2-OpenProviderStreamRequest)
    - [OpenProviderStreamResponse](#kuksa-val-v2-OpenProviderStreamResponse)
    - [ProvideActuationRequest](#kuksa-val-v2-ProvideActuationRequest)
    - [ProvideActuationResponse](#kuksa-val-v2-ProvideActuationResponse)
    - [ProvideSignalRequest](#kuksa-val-v2-ProvideSignalRequest)
    - [ProvideSignalRequest.SignalsSampleIntervalsEntry](#kuksa-val-v2-ProvideSignalRequest-SignalsSampleIntervalsEntry)
    - [ProvideSignalResponse](#kuksa-val-v2-ProvideSignalResponse)
    - [ProviderErrorIndication](#kuksa-val-v2-ProviderErrorIndication)
    - [PublishValueRequest](#kuksa-val-v2-PublishValueRequest)
    - [PublishValueResponse](#kuksa-val-v2-PublishValueResponse)
    - [PublishValuesRequest](#kuksa-val-v2-PublishValuesRequest)
    - [PublishValuesRequest.DataPointsEntry](#kuksa-val-v2-PublishValuesRequest-DataPointsEntry)
    - [PublishValuesResponse](#kuksa-val-v2-PublishValuesResponse)
    - [PublishValuesResponse.StatusEntry](#kuksa-val-v2-PublishValuesResponse-StatusEntry)
    - [SubscribeByIdRequest](#kuksa-val-v2-SubscribeByIdRequest)
    - [SubscribeByIdResponse](#kuksa-val-v2-SubscribeByIdResponse)
    - [SubscribeByIdResponse.EntriesEntry](#kuksa-val-v2-SubscribeByIdResponse-EntriesEntry)
    - [SubscribeRequest](#kuksa-val-v2-SubscribeRequest)
    - [SubscribeResponse](#kuksa-val-v2-SubscribeResponse)
    - [SubscribeResponse.EntriesEntry](#kuksa-val-v2-SubscribeResponse-EntriesEntry)
    - [UpdateFilterRequest](#kuksa-val-v2-UpdateFilterRequest)
    - [UpdateFilterRequest.FiltersUpdateEntry](#kuksa-val-v2-UpdateFilterRequest-FiltersUpdateEntry)
    - [UpdateFilterResponse](#kuksa-val-v2-UpdateFilterResponse)

    - [VAL](#kuksa-val-v2-VAL)

- [Scalar Value Types](#scalar-value-types)



<a name="kuksa_val_v2_val-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## kuksa/val/v2/val.proto
Please do not add optional fields due to older proto3 versions limitations


<a name="kuksa-val-v2-ActuateRequest"></a>

### ActuateRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_id | [SignalID](#kuksa-val-v2-SignalID) |  |  |
| value | [Value](#kuksa-val-v2-Value) |  |  |






<a name="kuksa-val-v2-ActuateResponse"></a>

### ActuateResponse







<a name="kuksa-val-v2-BatchActuateRequest"></a>

### BatchActuateRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| actuate_requests | [ActuateRequest](#kuksa-val-v2-ActuateRequest) | repeated |  |






<a name="kuksa-val-v2-BatchActuateResponse"></a>

### BatchActuateResponse







<a name="kuksa-val-v2-BatchActuateStreamRequest"></a>

### BatchActuateStreamRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| actuate_requests | [ActuateRequest](#kuksa-val-v2-ActuateRequest) | repeated |  |






<a name="kuksa-val-v2-BatchActuateStreamResponse"></a>

### BatchActuateStreamResponse
Message that shall be used by provider to indicate if an actuation request was accepted.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_id | [SignalID](#kuksa-val-v2-SignalID) |  |  |
| error | [Error](#kuksa-val-v2-Error) |  |  |






<a name="kuksa-val-v2-GetProviderValueRequest"></a>

### GetProviderValueRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| request_id | [uint32](#uint32) |  | Unique request id for the stream that can be used to match the corresponding response. |
| signal_ids | [int32](#int32) | repeated |  |






<a name="kuksa-val-v2-GetProviderValueResponse"></a>

### GetProviderValueResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| request_id | [uint32](#uint32) |  | Unique request id for the stream that can be used to match the corresponding request. |
| entries | [GetProviderValueResponse.EntriesEntry](#kuksa-val-v2-GetProviderValueResponse-EntriesEntry) | repeated |  |






<a name="kuksa-val-v2-GetProviderValueResponse-EntriesEntry"></a>

### GetProviderValueResponse.EntriesEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [int32](#int32) |  |  |
| value | [Datapoint](#kuksa-val-v2-Datapoint) |  |  |






<a name="kuksa-val-v2-GetServerInfoRequest"></a>

### GetServerInfoRequest
Nothing yet






<a name="kuksa-val-v2-GetServerInfoResponse"></a>

### GetServerInfoResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| name | [string](#string) |  |  |
| version | [string](#string) |  |  |
| commit_hash | [string](#string) |  |  |






<a name="kuksa-val-v2-GetValueRequest"></a>

### GetValueRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_id | [SignalID](#kuksa-val-v2-SignalID) |  |  |






<a name="kuksa-val-v2-GetValueResponse"></a>

### GetValueResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| data_point | [Datapoint](#kuksa-val-v2-Datapoint) |  |  |






<a name="kuksa-val-v2-GetValuesRequest"></a>

### GetValuesRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_ids | [SignalID](#kuksa-val-v2-SignalID) | repeated |  |






<a name="kuksa-val-v2-GetValuesResponse"></a>

### GetValuesResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| data_points | [Datapoint](#kuksa-val-v2-Datapoint) | repeated |  |






<a name="kuksa-val-v2-ListMetadataRequest"></a>

### ListMetadataRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| root | [string](#string) |  | Root path to be used when listing metadata Shall correspond to a VSS branch, e.g. &#34;Vehicle&#34;, &#34;Vehicle.Cabin&#34; Metadata for all signals under that branch will be returned unless filtered by filter. NOTE: Currently Databroker supports also signals and wildcards in root but that may be removed in a future release! |
| filter | [string](#string) |  | NOTE : Currently not considered by Databroker, all signals matching root are returned |






<a name="kuksa-val-v2-ListMetadataResponse"></a>

### ListMetadataResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| metadata | [Metadata](#kuksa-val-v2-Metadata) | repeated |  |






<a name="kuksa-val-v2-OpenProviderStreamRequest"></a>

### OpenProviderStreamRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| provide_actuation_request | [ProvideActuationRequest](#kuksa-val-v2-ProvideActuationRequest) |  | Inform server of an actuator this provider provides. |
| publish_values_request | [PublishValuesRequest](#kuksa-val-v2-PublishValuesRequest) |  | Publish a value. |
| batch_actuate_stream_response | [BatchActuateStreamResponse](#kuksa-val-v2-BatchActuateStreamResponse) |  | Sent to acknowledge the acceptance of a batch actuate request. |
| provide_signal_request | [ProvideSignalRequest](#kuksa-val-v2-ProvideSignalRequest) |  | Inform server of a signal this provider provides. |
| update_filter_response | [UpdateFilterResponse](#kuksa-val-v2-UpdateFilterResponse) |  | Update filter response |
| get_provider_value_response | [GetProviderValueResponse](#kuksa-val-v2-GetProviderValueResponse) |  | GetValue response |
| provider_error_indication | [ProviderErrorIndication](#kuksa-val-v2-ProviderErrorIndication) |  | Indication of error on provider side |






<a name="kuksa-val-v2-OpenProviderStreamResponse"></a>

### OpenProviderStreamResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| provide_actuation_response | [ProvideActuationResponse](#kuksa-val-v2-ProvideActuationResponse) |  | Response to a provide actuator request. |
| publish_values_response | [PublishValuesResponse](#kuksa-val-v2-PublishValuesResponse) |  | Acknowledgement that a published value was received. |
| batch_actuate_stream_request | [BatchActuateStreamRequest](#kuksa-val-v2-BatchActuateStreamRequest) |  | Send a batch actuate request to a provider. |
| provide_signal_response | [ProvideSignalResponse](#kuksa-val-v2-ProvideSignalResponse) |  | Response to a provide sensor request. |
| update_filter_request | [UpdateFilterRequest](#kuksa-val-v2-UpdateFilterRequest) |  | Filter request |
| get_provider_value_request | [GetProviderValueRequest](#kuksa-val-v2-GetProviderValueRequest) |  | GetValue request from client forwarded to provider |






<a name="kuksa-val-v2-ProvideActuationRequest"></a>

### ProvideActuationRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| actuator_identifiers | [SignalID](#kuksa-val-v2-SignalID) | repeated |  |






<a name="kuksa-val-v2-ProvideActuationResponse"></a>

### ProvideActuationResponse







<a name="kuksa-val-v2-ProvideSignalRequest"></a>

### ProvideSignalRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signals_sample_intervals | [ProvideSignalRequest.SignalsSampleIntervalsEntry](#kuksa-val-v2-ProvideSignalRequest-SignalsSampleIntervalsEntry) | repeated |  |






<a name="kuksa-val-v2-ProvideSignalRequest-SignalsSampleIntervalsEntry"></a>

### ProvideSignalRequest.SignalsSampleIntervalsEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [int32](#int32) |  |  |
| value | [SampleInterval](#kuksa-val-v2-SampleInterval) |  |  |






<a name="kuksa-val-v2-ProvideSignalResponse"></a>

### ProvideSignalResponse







<a name="kuksa-val-v2-ProviderErrorIndication"></a>

### ProviderErrorIndication
Send to indicate an error on provider side


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| provider_error | [ProviderError](#kuksa-val-v2-ProviderError) |  |  |






<a name="kuksa-val-v2-PublishValueRequest"></a>

### PublishValueRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_id | [SignalID](#kuksa-val-v2-SignalID) |  |  |
| data_point | [Datapoint](#kuksa-val-v2-Datapoint) |  |  |






<a name="kuksa-val-v2-PublishValueResponse"></a>

### PublishValueResponse







<a name="kuksa-val-v2-PublishValuesRequest"></a>

### PublishValuesRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| request_id | [uint32](#uint32) |  | Unique request id for the stream that can be used to match the corresponding response. |
| data_points | [PublishValuesRequest.DataPointsEntry](#kuksa-val-v2-PublishValuesRequest-DataPointsEntry) | repeated |  |






<a name="kuksa-val-v2-PublishValuesRequest-DataPointsEntry"></a>

### PublishValuesRequest.DataPointsEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [int32](#int32) |  |  |
| value | [Datapoint](#kuksa-val-v2-Datapoint) |  |  |






<a name="kuksa-val-v2-PublishValuesResponse"></a>

### PublishValuesResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| request_id | [uint32](#uint32) |  | Unique request id for the stream that can be used to match the corresponding request. |
| status | [PublishValuesResponse.StatusEntry](#kuksa-val-v2-PublishValuesResponse-StatusEntry) | repeated |  |






<a name="kuksa-val-v2-PublishValuesResponse-StatusEntry"></a>

### PublishValuesResponse.StatusEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [int32](#int32) |  |  |
| value | [Error](#kuksa-val-v2-Error) |  |  |






<a name="kuksa-val-v2-SubscribeByIdRequest"></a>

### SubscribeByIdRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_ids | [int32](#int32) | repeated |  |
| buffer_size | [uint32](#uint32) |  | Specifies the number of messages that can be buffered for slow subscribers before the oldest messages are dropped. Default (0) results in that only latest message is kept. Maximum value supported is implementation dependent. |
| filter | [Filter](#kuksa-val-v2-Filter) |  |  |






<a name="kuksa-val-v2-SubscribeByIdResponse"></a>

### SubscribeByIdResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| entries | [SubscribeByIdResponse.EntriesEntry](#kuksa-val-v2-SubscribeByIdResponse-EntriesEntry) | repeated |  |






<a name="kuksa-val-v2-SubscribeByIdResponse-EntriesEntry"></a>

### SubscribeByIdResponse.EntriesEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [int32](#int32) |  |  |
| value | [Datapoint](#kuksa-val-v2-Datapoint) |  |  |






<a name="kuksa-val-v2-SubscribeRequest"></a>

### SubscribeRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| signal_paths | [string](#string) | repeated |  |
| buffer_size | [uint32](#uint32) |  | Specifies the number of messages that can be buffered for slow subscribers before the oldest messages are dropped. Default (0) results in that only latest message is kept. Maximum value supported is implementation dependent. |
| filter | [Filter](#kuksa-val-v2-Filter) |  |  |






<a name="kuksa-val-v2-SubscribeResponse"></a>

### SubscribeResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| entries | [SubscribeResponse.EntriesEntry](#kuksa-val-v2-SubscribeResponse-EntriesEntry) | repeated |  |






<a name="kuksa-val-v2-SubscribeResponse-EntriesEntry"></a>

### SubscribeResponse.EntriesEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [string](#string) |  |  |
| value | [Datapoint](#kuksa-val-v2-Datapoint) |  |  |






<a name="kuksa-val-v2-UpdateFilterRequest"></a>

### UpdateFilterRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| request_id | [uint32](#uint32) |  | Unique request id for the stream that can be used to match the corresponding response. |
| filters_update | [UpdateFilterRequest.FiltersUpdateEntry](#kuksa-val-v2-UpdateFilterRequest-FiltersUpdateEntry) | repeated | Databroker sends filters to provider. In case provider restarts, databroker will send local filters stored to continue the provider sending same signals with same filter. Filter value could be None, meaning all subscriptions were removed for that SignalId |






<a name="kuksa-val-v2-UpdateFilterRequest-FiltersUpdateEntry"></a>

### UpdateFilterRequest.FiltersUpdateEntry



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| key | [int32](#int32) |  |  |
| value | [Filter](#kuksa-val-v2-Filter) |  |  |






<a name="kuksa-val-v2-UpdateFilterResponse"></a>

### UpdateFilterResponse
Only returned if there is a filter error on provider side


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| request_id | [uint32](#uint32) |  | Unique request id for the stream that can be used to match the corresponding request. |
| filter_error | [FilterError](#kuksa-val-v2-FilterError) |  |  |












<a name="kuksa-val-v2-VAL"></a>

### VAL


| Method Name | Request Type | Response Type | Description |
| ----------- | ------------ | ------------- | ------------|
| GetValue | [GetValueRequest](#kuksa-val-v2-GetValueRequest) | [GetValueResponse](#kuksa-val-v2-GetValueResponse) | Get the latest value of a signal If the signal exist but does not have a valid value a DataPoint where value is None shall be returned. Returns (GRPC error code): NOT_FOUND if the requested signal doesn&#39;t exist UNAUTHENTICATED if no credentials provided or credentials has expired PERMISSION_DENIED if access is denied INVALID_ARGUMENT if the request is empty or provided path is too long - MAX_REQUEST_PATH_LENGTH: usize = 1000; |
| GetValues | [GetValuesRequest](#kuksa-val-v2-GetValuesRequest) | [GetValuesResponse](#kuksa-val-v2-GetValuesResponse) | Get the latest values of a set of signals. The returned list of data points has the same order as the list of the request. If a requested signal has no value a DataPoint where value is None will be returned. Returns (GRPC error code): NOT_FOUND if any of the requested signals doesn&#39;t exist. UNAUTHENTICATED if no credentials provided or credentials has expired PERMISSION_DENIED if access is denied for any of the requested signals. INVALID_ARGUMENT if the request is empty or provided path is too long - MAX_REQUEST_PATH_LENGTH: usize = 1000; |
| Subscribe | [SubscribeRequest](#kuksa-val-v2-SubscribeRequest) | [SubscribeResponse](#kuksa-val-v2-SubscribeResponse) stream | Subscribe to a set of signals using string path parameters Returns (GRPC error code): NOT_FOUND if any of the signals are non-existant. UNAUTHENTICATED if no credentials provided or credentials has expired PERMISSION_DENIED if access is denied for any of the signals. INVALID_ARGUMENT - if the request is empty or provided path is too long MAX_REQUEST_PATH_LENGTH: usize = 1000; - if buffer_size exceeds the maximum permitted MAX_BUFFER_SIZE: usize = 1000; When subscribing, Databroker shall immediately return the value for all subscribed entries. If a value isn&#39;t available when subscribing to a it, it should return None. If a subscriber is slow to consume signals, messages will be buffered up to the specified buffer_size before the oldest messages are dropped. |
| SubscribeById | [SubscribeByIdRequest](#kuksa-val-v2-SubscribeByIdRequest) | [SubscribeByIdResponse](#kuksa-val-v2-SubscribeByIdResponse) stream | Subscribe to a set of signals using i32 id parameters Returns (GRPC error code): NOT_FOUND if any of the signals are non-existant. UNAUTHENTICATED if no credentials provided or credentials has expired PERMISSION_DENIED if access is denied for any of the signals. INVALID_ARGUMENT - if the request is empty or provided path is too long MAX_REQUEST_PATH_LENGTH: usize = 1000; - if buffer_size exceeds the maximum permitted MAX_BUFFER_SIZE: usize = 1000; When subscribing, Databroker shall immediately return the value for all subscribed entries If a value isn&#39;t available when subscribing to a it, it should return None. If a subscriber is slow to consume signals, messages will be buffered up to the specified buffer_size before the oldest messages are dropped. |
| Actuate | [ActuateRequest](#kuksa-val-v2-ActuateRequest) | [ActuateResponse](#kuksa-val-v2-ActuateResponse) | Actuate a single actuator. Returns (GRPC error code): NOT_FOUND if the actuator does not exist. PERMISSION_DENIED if access is denied for the actuator. UNAUTHENTICATED if no credentials provided or credentials has expired UNAVAILABLE if there is no provider currently providing the actuator DATA_LOSS is there is a internal TransmissionFailure INVALID_ARGUMENT - if the provided path is not an actuator. - if the data type used in the request does not match the data type of the addressed signal - if the requested value is not accepted, e.g. if sending an unsupported enum value - if the provided value is out of the min/max range specified |
| ActuateStream | [ActuateRequest](#kuksa-val-v2-ActuateRequest) stream | [ActuateResponse](#kuksa-val-v2-ActuateResponse) | Actuate a single actuator in a gRPC stream -&gt; Use for low latency and high throughput. Returns (GRPC error code): NOT_FOUND if the actuator does not exist. PERMISSION_DENIED if access is denied for the actuator. UNAUTHENTICATED if no credentials provided or credentials has expired UNAVAILABLE if there is no provider currently providing the actuator DATA_LOSS is there is a internal TransmissionFailure INVALID_ARGUMENT - if the provided path is not an actuator. - if the data type used in the request does not match the data type of the addressed signal - if the requested value is not accepted, e.g. if sending an unsupported enum value - if the provided value is out of the min/max range specified |
| BatchActuate | [BatchActuateRequest](#kuksa-val-v2-BatchActuateRequest) | [BatchActuateResponse](#kuksa-val-v2-BatchActuateResponse) | Actuate simultaneously multiple actuators. If any error occurs, the entire operation will be aborted and no single actuator value will be forwarded to the provider. Returns (GRPC error code): NOT_FOUND if any of the actuators are non-existant. PERMISSION_DENIED if access is denied for any of the actuators. UNAUTHENTICATED if no credentials provided or credentials has expired UNAVAILABLE if there is no provider currently providing an actuator DATA_LOSS is there is a internal TransmissionFailure INVALID_ARGUMENT - if any of the provided path is not an actuator. - if the data type used in the request does not match the data type of the addressed signal - if the requested value is not accepted, e.g. if sending an unsupported enum value - if any of the provided actuators values are out of the min/max range specified |
| ListMetadata | [ListMetadataRequest](#kuksa-val-v2-ListMetadataRequest) | [ListMetadataResponse](#kuksa-val-v2-ListMetadataResponse) | List metadata of signals matching the request. Returns (GRPC error code): NOT_FOUND if the specified root branch does not exist. UNAUTHENTICATED if no credentials provided or credentials has expired INVALID_ARGUMENT if the provided path or wildcard is wrong. |
| PublishValue | [PublishValueRequest](#kuksa-val-v2-PublishValueRequest) | [PublishValueResponse](#kuksa-val-v2-PublishValueResponse) | Publish a signal value. Used for low frequency signals (e.g. attributes). Returns (GRPC error code): NOT_FOUND if any of the signals are non-existant. PERMISSION_DENIED - if access is denied for any of the signals. UNAUTHENTICATED if no credentials provided or credentials has expired INVALID_ARGUMENT - if the data type used in the request does not match the data type of the addressed signal - if the published value is not accepted, e.g. if sending an unsupported enum value - if the published value is out of the min/max range specified |
| OpenProviderStream | [OpenProviderStreamRequest](#kuksa-val-v2-OpenProviderStreamRequest) stream | [OpenProviderStreamResponse](#kuksa-val-v2-OpenProviderStreamResponse) stream | Open a stream used to provide actuation and/or publishing values using a streaming interface. Used to provide actuators and to enable high frequency updates of values. The open stream is used for request / response type communication between the provider and server (where the initiator of a request can vary). Errors: - Provider sends ProvideActuationRequest -&gt; Databroker returns ProvideActuationResponse - strict case Returns (GRPC error code) and closes the stream call NOT_FOUND if any of the signals are non-existant. PERMISSION_DENIED if access is denied for any of the signals. UNAUTHENTICATED if no credentials provided or credentials has expired ALREADY_EXISTS if a provider already claimed the ownership of an actuator: - Provider sends PublishValuesRequest -&gt; Databroker returns PublishValuesResponse upon error, and nothing upon success - permissive case GRPC errors are returned as messages in the stream response with the signal id `map&lt;int32, Error&gt; status = 2;` NOT_FOUND if a signal is non-existant. PERMISSION_DENIED - if access is denied for a signal. INVALID_ARGUMENT - if the data type used in the request does not match the data type of the addressed signal - if the published value is not accepted, e.g. if sending an unsupported enum value - if the published value is out of the min/max range specified - strict case Returns (GRPC error code) and closes the stream call. ALREADY_EXISTS if a provider already claimed the ownership of the signals ABORTED if provider has not claimed yet the signals: - Databroker sends BatchActuateStreamRequest -&gt; Provider shall return a BatchActuateStreamResponse, for every signal requested to indicate if the request was accepted or not. It is up to the provider to decide if the stream shall be closed, as of today Databroker will not react on the received error message: - Provider sends ProvideSignalRequest -&gt; Databroker returns ProvideSignalResponse - strict case Returns (GRPC error code) and closes the stream call. NOT_FOUND if any of the signals are non-existant. PERMISSION_DENIED if access is denied for any of the signals. UNAUTHENTICATED if no credentials provided or credentials has expired ALREADY_EXISTS if a provider already claimed the ownership of any signal: - Provider sends ProviderErrorIndication - strict case Returns (GRPC error code) and closes the stream call. ABORTED if provider has not claimed yet the signals |
| GetServerInfo | [GetServerInfoRequest](#kuksa-val-v2-GetServerInfoRequest) | [GetServerInfoResponse](#kuksa-val-v2-GetServerInfoResponse) | Get server information |





## Scalar Value Types

| .proto Type | Notes | C++ | Java | Python | Go | C# | PHP | Ruby |
| ----------- | ----- | --- | ---- | ------ | -- | -- | --- | ---- |
| <a name="double" /> double |  | double | double | float | float64 | double | float | Float |
| <a name="float" /> float |  | float | float | float | float32 | float | float | Float |
| <a name="int32" /> int32 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint32 instead. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="int64" /> int64 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint64 instead. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="uint32" /> uint32 | Uses variable-length encoding. | uint32 | int | int/long | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="uint64" /> uint64 | Uses variable-length encoding. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum or Fixnum (as required) |
| <a name="sint32" /> sint32 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int32s. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sint64" /> sint64 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int64s. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="fixed32" /> fixed32 | Always four bytes. More efficient than uint32 if values are often greater than 2^28. | uint32 | int | int | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="fixed64" /> fixed64 | Always eight bytes. More efficient than uint64 if values are often greater than 2^56. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum |
| <a name="sfixed32" /> sfixed32 | Always four bytes. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sfixed64" /> sfixed64 | Always eight bytes. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="bool" /> bool |  | bool | boolean | boolean | bool | bool | boolean | TrueClass/FalseClass |
| <a name="string" /> string | A string must always contain UTF-8 encoded or 7-bit ASCII text. | string | String | str/unicode | string | string | string | String (UTF-8) |
| <a name="bytes" /> bytes | May contain any arbitrary sequence of bytes. | string | ByteString | str | []byte | ByteString | string | String (ASCII-8BIT) |
