// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: src/proto/grpc/channelz/channelz.proto
// Original file comments:
// Copyright 2018 The gRPC Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// This file defines an interface for exporting monitoring information
// out of gRPC servers.  See the full design at
// https://github.com/grpc/proposal/blob/master/A14-channelz.md
//
// The canonical version of this proto can be found at
// https://github.com/grpc/grpc-proto/blob/master/grpc/channelz/v1/channelz.proto
//
#ifndef GRPC_src_2fproto_2fgrpc_2fchannelz_2fchannelz_2eproto__INCLUDED
#define GRPC_src_2fproto_2fgrpc_2fchannelz_2fchannelz_2eproto__INCLUDED

#include "src/proto/grpc/channelz/channelz.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>

namespace grpc {
namespace channelz {
namespace v1 {

// Channelz is a service exposed by gRPC servers that provides detailed debug
// information.
class Channelz final {
 public:
  static constexpr char const* service_full_name() {
    return "grpc.channelz.v1.Channelz";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Gets all root channels (i.e. channels the application has directly
    // created). This does not include subchannels nor non-top level channels.
    virtual ::grpc::Status GetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::channelz::v1::GetTopChannelsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetTopChannelsResponse>> AsyncGetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetTopChannelsResponse>>(AsyncGetTopChannelsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetTopChannelsResponse>> PrepareAsyncGetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetTopChannelsResponse>>(PrepareAsyncGetTopChannelsRaw(context, request, cq));
    }
    // Gets all servers that exist in the process.
    virtual ::grpc::Status GetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::channelz::v1::GetServersResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServersResponse>> AsyncGetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServersResponse>>(AsyncGetServersRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServersResponse>> PrepareAsyncGetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServersResponse>>(PrepareAsyncGetServersRaw(context, request, cq));
    }
    // Returns a single Server, or else a NOT_FOUND code.
    virtual ::grpc::Status GetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::channelz::v1::GetServerResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerResponse>> AsyncGetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerResponse>>(AsyncGetServerRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerResponse>> PrepareAsyncGetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerResponse>>(PrepareAsyncGetServerRaw(context, request, cq));
    }
    // Gets all server sockets that exist in the process.
    virtual ::grpc::Status GetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::channelz::v1::GetServerSocketsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerSocketsResponse>> AsyncGetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerSocketsResponse>>(AsyncGetServerSocketsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerSocketsResponse>> PrepareAsyncGetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerSocketsResponse>>(PrepareAsyncGetServerSocketsRaw(context, request, cq));
    }
    // Returns a single Channel, or else a NOT_FOUND code.
    virtual ::grpc::Status GetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::channelz::v1::GetChannelResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetChannelResponse>> AsyncGetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetChannelResponse>>(AsyncGetChannelRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetChannelResponse>> PrepareAsyncGetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetChannelResponse>>(PrepareAsyncGetChannelRaw(context, request, cq));
    }
    // Returns a single Subchannel, or else a NOT_FOUND code.
    virtual ::grpc::Status GetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::channelz::v1::GetSubchannelResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSubchannelResponse>> AsyncGetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSubchannelResponse>>(AsyncGetSubchannelRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSubchannelResponse>> PrepareAsyncGetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSubchannelResponse>>(PrepareAsyncGetSubchannelRaw(context, request, cq));
    }
    // Returns a single Socket or else a NOT_FOUND code.
    virtual ::grpc::Status GetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::channelz::v1::GetSocketResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSocketResponse>> AsyncGetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSocketResponse>>(AsyncGetSocketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSocketResponse>> PrepareAsyncGetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSocketResponse>>(PrepareAsyncGetSocketRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Gets all root channels (i.e. channels the application has directly
      // created). This does not include subchannels nor non-top level channels.
      virtual void GetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::channelz::v1::GetTopChannelsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::channelz::v1::GetTopChannelsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets all servers that exist in the process.
      virtual void GetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest* request, ::grpc::channelz::v1::GetServersResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest* request, ::grpc::channelz::v1::GetServersResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns a single Server, or else a NOT_FOUND code.
      virtual void GetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest* request, ::grpc::channelz::v1::GetServerResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest* request, ::grpc::channelz::v1::GetServerResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets all server sockets that exist in the process.
      virtual void GetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::channelz::v1::GetServerSocketsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::channelz::v1::GetServerSocketsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns a single Channel, or else a NOT_FOUND code.
      virtual void GetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::channelz::v1::GetChannelResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::channelz::v1::GetChannelResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns a single Subchannel, or else a NOT_FOUND code.
      virtual void GetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::channelz::v1::GetSubchannelResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::channelz::v1::GetSubchannelResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns a single Socket or else a NOT_FOUND code.
      virtual void GetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::channelz::v1::GetSocketResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::channelz::v1::GetSocketResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetTopChannelsResponse>* AsyncGetTopChannelsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetTopChannelsResponse>* PrepareAsyncGetTopChannelsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServersResponse>* AsyncGetServersRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServersResponse>* PrepareAsyncGetServersRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerResponse>* AsyncGetServerRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerResponse>* PrepareAsyncGetServerRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerSocketsResponse>* AsyncGetServerSocketsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetServerSocketsResponse>* PrepareAsyncGetServerSocketsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetChannelResponse>* AsyncGetChannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetChannelResponse>* PrepareAsyncGetChannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSubchannelResponse>* AsyncGetSubchannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSubchannelResponse>* PrepareAsyncGetSubchannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSocketResponse>* AsyncGetSocketRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::grpc::channelz::v1::GetSocketResponse>* PrepareAsyncGetSocketRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status GetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::channelz::v1::GetTopChannelsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetTopChannelsResponse>> AsyncGetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetTopChannelsResponse>>(AsyncGetTopChannelsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetTopChannelsResponse>> PrepareAsyncGetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetTopChannelsResponse>>(PrepareAsyncGetTopChannelsRaw(context, request, cq));
    }
    ::grpc::Status GetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::channelz::v1::GetServersResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServersResponse>> AsyncGetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServersResponse>>(AsyncGetServersRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServersResponse>> PrepareAsyncGetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServersResponse>>(PrepareAsyncGetServersRaw(context, request, cq));
    }
    ::grpc::Status GetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::channelz::v1::GetServerResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerResponse>> AsyncGetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerResponse>>(AsyncGetServerRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerResponse>> PrepareAsyncGetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerResponse>>(PrepareAsyncGetServerRaw(context, request, cq));
    }
    ::grpc::Status GetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::channelz::v1::GetServerSocketsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerSocketsResponse>> AsyncGetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerSocketsResponse>>(AsyncGetServerSocketsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerSocketsResponse>> PrepareAsyncGetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerSocketsResponse>>(PrepareAsyncGetServerSocketsRaw(context, request, cq));
    }
    ::grpc::Status GetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::channelz::v1::GetChannelResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetChannelResponse>> AsyncGetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetChannelResponse>>(AsyncGetChannelRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetChannelResponse>> PrepareAsyncGetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetChannelResponse>>(PrepareAsyncGetChannelRaw(context, request, cq));
    }
    ::grpc::Status GetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::channelz::v1::GetSubchannelResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSubchannelResponse>> AsyncGetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSubchannelResponse>>(AsyncGetSubchannelRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSubchannelResponse>> PrepareAsyncGetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSubchannelResponse>>(PrepareAsyncGetSubchannelRaw(context, request, cq));
    }
    ::grpc::Status GetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::channelz::v1::GetSocketResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSocketResponse>> AsyncGetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSocketResponse>>(AsyncGetSocketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSocketResponse>> PrepareAsyncGetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSocketResponse>>(PrepareAsyncGetSocketRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void GetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::channelz::v1::GetTopChannelsResponse* response, std::function<void(::grpc::Status)>) override;
      void GetTopChannels(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::channelz::v1::GetTopChannelsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest* request, ::grpc::channelz::v1::GetServersResponse* response, std::function<void(::grpc::Status)>) override;
      void GetServers(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest* request, ::grpc::channelz::v1::GetServersResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest* request, ::grpc::channelz::v1::GetServerResponse* response, std::function<void(::grpc::Status)>) override;
      void GetServer(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest* request, ::grpc::channelz::v1::GetServerResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::channelz::v1::GetServerSocketsResponse* response, std::function<void(::grpc::Status)>) override;
      void GetServerSockets(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::channelz::v1::GetServerSocketsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::channelz::v1::GetChannelResponse* response, std::function<void(::grpc::Status)>) override;
      void GetChannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::channelz::v1::GetChannelResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::channelz::v1::GetSubchannelResponse* response, std::function<void(::grpc::Status)>) override;
      void GetSubchannel(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::channelz::v1::GetSubchannelResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::channelz::v1::GetSocketResponse* response, std::function<void(::grpc::Status)>) override;
      void GetSocket(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::channelz::v1::GetSocketResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetTopChannelsResponse>* AsyncGetTopChannelsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetTopChannelsResponse>* PrepareAsyncGetTopChannelsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServersResponse>* AsyncGetServersRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServersResponse>* PrepareAsyncGetServersRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServersRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerResponse>* AsyncGetServerRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerResponse>* PrepareAsyncGetServerRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerSocketsResponse>* AsyncGetServerSocketsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetServerSocketsResponse>* PrepareAsyncGetServerSocketsRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetChannelResponse>* AsyncGetChannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetChannelResponse>* PrepareAsyncGetChannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetChannelRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSubchannelResponse>* AsyncGetSubchannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSubchannelResponse>* PrepareAsyncGetSubchannelRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSubchannelRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSocketResponse>* AsyncGetSocketRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::grpc::channelz::v1::GetSocketResponse>* PrepareAsyncGetSocketRaw(::grpc::ClientContext* context, const ::grpc::channelz::v1::GetSocketRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_GetTopChannels_;
    const ::grpc::internal::RpcMethod rpcmethod_GetServers_;
    const ::grpc::internal::RpcMethod rpcmethod_GetServer_;
    const ::grpc::internal::RpcMethod rpcmethod_GetServerSockets_;
    const ::grpc::internal::RpcMethod rpcmethod_GetChannel_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSubchannel_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSocket_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Gets all root channels (i.e. channels the application has directly
    // created). This does not include subchannels nor non-top level channels.
    virtual ::grpc::Status GetTopChannels(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::channelz::v1::GetTopChannelsResponse* response);
    // Gets all servers that exist in the process.
    virtual ::grpc::Status GetServers(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetServersRequest* request, ::grpc::channelz::v1::GetServersResponse* response);
    // Returns a single Server, or else a NOT_FOUND code.
    virtual ::grpc::Status GetServer(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetServerRequest* request, ::grpc::channelz::v1::GetServerResponse* response);
    // Gets all server sockets that exist in the process.
    virtual ::grpc::Status GetServerSockets(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::channelz::v1::GetServerSocketsResponse* response);
    // Returns a single Channel, or else a NOT_FOUND code.
    virtual ::grpc::Status GetChannel(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::channelz::v1::GetChannelResponse* response);
    // Returns a single Subchannel, or else a NOT_FOUND code.
    virtual ::grpc::Status GetSubchannel(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::channelz::v1::GetSubchannelResponse* response);
    // Returns a single Socket or else a NOT_FOUND code.
    virtual ::grpc::Status GetSocket(::grpc::ServerContext* context, const ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::channelz::v1::GetSocketResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_GetTopChannels : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetTopChannels() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_GetTopChannels() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopChannels(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetTopChannels(::grpc::ServerContext* context, ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetTopChannelsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetServers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetServers() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_GetServers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServers(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServers(::grpc::ServerContext* context, ::grpc::channelz::v1::GetServersRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetServersResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetServer : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetServer() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetServer() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServer(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServer(::grpc::ServerContext* context, ::grpc::channelz::v1::GetServerRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetServerResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetServerSockets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetServerSockets() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_GetServerSockets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServerSockets(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServerSockets(::grpc::ServerContext* context, ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetServerSocketsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetChannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetChannel() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_GetChannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetChannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetChannel(::grpc::ServerContext* context, ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetChannelResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSubchannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSubchannel() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_GetSubchannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubchannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSubchannel(::grpc::ServerContext* context, ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetSubchannelResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSocket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSocket() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_GetSocket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSocket(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSocket(::grpc::ServerContext* context, ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::ServerAsyncResponseWriter< ::grpc::channelz::v1::GetSocketResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_GetTopChannels<WithAsyncMethod_GetServers<WithAsyncMethod_GetServer<WithAsyncMethod_GetServerSockets<WithAsyncMethod_GetChannel<WithAsyncMethod_GetSubchannel<WithAsyncMethod_GetSocket<Service > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_GetTopChannels : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetTopChannels() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetTopChannelsRequest, ::grpc::channelz::v1::GetTopChannelsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetTopChannelsRequest* request, ::grpc::channelz::v1::GetTopChannelsResponse* response) { return this->GetTopChannels(context, request, response); }));}
    void SetMessageAllocatorFor_GetTopChannels(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetTopChannelsRequest, ::grpc::channelz::v1::GetTopChannelsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetTopChannelsRequest, ::grpc::channelz::v1::GetTopChannelsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetTopChannels() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopChannels(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetTopChannels(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetServers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetServers() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetServersRequest, ::grpc::channelz::v1::GetServersResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetServersRequest* request, ::grpc::channelz::v1::GetServersResponse* response) { return this->GetServers(context, request, response); }));}
    void SetMessageAllocatorFor_GetServers(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetServersRequest, ::grpc::channelz::v1::GetServersResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetServersRequest, ::grpc::channelz::v1::GetServersResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetServers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServers(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServers(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetServer : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetServer() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetServerRequest, ::grpc::channelz::v1::GetServerResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetServerRequest* request, ::grpc::channelz::v1::GetServerResponse* response) { return this->GetServer(context, request, response); }));}
    void SetMessageAllocatorFor_GetServer(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetServerRequest, ::grpc::channelz::v1::GetServerResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetServerRequest, ::grpc::channelz::v1::GetServerResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetServer() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServer(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServer(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetServerSockets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetServerSockets() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetServerSocketsRequest, ::grpc::channelz::v1::GetServerSocketsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetServerSocketsRequest* request, ::grpc::channelz::v1::GetServerSocketsResponse* response) { return this->GetServerSockets(context, request, response); }));}
    void SetMessageAllocatorFor_GetServerSockets(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetServerSocketsRequest, ::grpc::channelz::v1::GetServerSocketsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetServerSocketsRequest, ::grpc::channelz::v1::GetServerSocketsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetServerSockets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServerSockets(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServerSockets(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetChannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetChannel() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetChannelRequest, ::grpc::channelz::v1::GetChannelResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetChannelRequest* request, ::grpc::channelz::v1::GetChannelResponse* response) { return this->GetChannel(context, request, response); }));}
    void SetMessageAllocatorFor_GetChannel(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetChannelRequest, ::grpc::channelz::v1::GetChannelResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetChannelRequest, ::grpc::channelz::v1::GetChannelResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetChannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetChannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetChannel(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSubchannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSubchannel() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetSubchannelRequest, ::grpc::channelz::v1::GetSubchannelResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetSubchannelRequest* request, ::grpc::channelz::v1::GetSubchannelResponse* response) { return this->GetSubchannel(context, request, response); }));}
    void SetMessageAllocatorFor_GetSubchannel(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetSubchannelRequest, ::grpc::channelz::v1::GetSubchannelResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetSubchannelRequest, ::grpc::channelz::v1::GetSubchannelResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSubchannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubchannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSubchannel(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSocket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSocket() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetSocketRequest, ::grpc::channelz::v1::GetSocketResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::channelz::v1::GetSocketRequest* request, ::grpc::channelz::v1::GetSocketResponse* response) { return this->GetSocket(context, request, response); }));}
    void SetMessageAllocatorFor_GetSocket(
        ::grpc::MessageAllocator< ::grpc::channelz::v1::GetSocketRequest, ::grpc::channelz::v1::GetSocketResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::grpc::channelz::v1::GetSocketRequest, ::grpc::channelz::v1::GetSocketResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSocket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSocket(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSocket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_GetTopChannels<WithCallbackMethod_GetServers<WithCallbackMethod_GetServer<WithCallbackMethod_GetServerSockets<WithCallbackMethod_GetChannel<WithCallbackMethod_GetSubchannel<WithCallbackMethod_GetSocket<Service > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_GetTopChannels : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetTopChannels() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_GetTopChannels() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopChannels(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetServers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetServers() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_GetServers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServers(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetServer : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetServer() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetServer() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServer(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetServerSockets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetServerSockets() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_GetServerSockets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServerSockets(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetChannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetChannel() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_GetChannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetChannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSubchannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSubchannel() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_GetSubchannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubchannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSocket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSocket() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_GetSocket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSocket(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetTopChannels : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetTopChannels() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_GetTopChannels() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopChannels(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetTopChannels(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetServers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetServers() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_GetServers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServers(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServers(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetServer : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetServer() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetServer() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServer(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServer(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetServerSockets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetServerSockets() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_GetServerSockets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServerSockets(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServerSockets(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetChannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetChannel() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_GetChannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetChannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetChannel(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSubchannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSubchannel() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_GetSubchannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubchannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSubchannel(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSocket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSocket() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_GetSocket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSocket(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSocket(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetTopChannels : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetTopChannels() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetTopChannels(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetTopChannels() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopChannels(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetTopChannels(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetServers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetServers() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetServers(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetServers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServers(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServers(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetServer : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetServer() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetServer(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetServer() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServer(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServer(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetServerSockets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetServerSockets() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetServerSockets(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetServerSockets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServerSockets(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServerSockets(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetChannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetChannel() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetChannel(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetChannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetChannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetChannel(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSubchannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSubchannel() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSubchannel(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSubchannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubchannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSubchannel(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSocket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSocket() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSocket(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSocket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSocket(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSocket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetTopChannels : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetTopChannels() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetTopChannelsRequest, ::grpc::channelz::v1::GetTopChannelsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetTopChannelsRequest, ::grpc::channelz::v1::GetTopChannelsResponse>* streamer) {
                       return this->StreamedGetTopChannels(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetTopChannels() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetTopChannels(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetTopChannelsRequest* /*request*/, ::grpc::channelz::v1::GetTopChannelsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetTopChannels(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetTopChannelsRequest,::grpc::channelz::v1::GetTopChannelsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetServers : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetServers() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetServersRequest, ::grpc::channelz::v1::GetServersResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetServersRequest, ::grpc::channelz::v1::GetServersResponse>* streamer) {
                       return this->StreamedGetServers(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetServers() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetServers(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServersRequest* /*request*/, ::grpc::channelz::v1::GetServersResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetServers(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetServersRequest,::grpc::channelz::v1::GetServersResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetServer : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetServer() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetServerRequest, ::grpc::channelz::v1::GetServerResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetServerRequest, ::grpc::channelz::v1::GetServerResponse>* streamer) {
                       return this->StreamedGetServer(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetServer() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetServer(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerRequest* /*request*/, ::grpc::channelz::v1::GetServerResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetServer(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetServerRequest,::grpc::channelz::v1::GetServerResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetServerSockets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetServerSockets() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetServerSocketsRequest, ::grpc::channelz::v1::GetServerSocketsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetServerSocketsRequest, ::grpc::channelz::v1::GetServerSocketsResponse>* streamer) {
                       return this->StreamedGetServerSockets(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetServerSockets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetServerSockets(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetServerSocketsRequest* /*request*/, ::grpc::channelz::v1::GetServerSocketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetServerSockets(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetServerSocketsRequest,::grpc::channelz::v1::GetServerSocketsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetChannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetChannel() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetChannelRequest, ::grpc::channelz::v1::GetChannelResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetChannelRequest, ::grpc::channelz::v1::GetChannelResponse>* streamer) {
                       return this->StreamedGetChannel(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetChannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetChannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetChannelRequest* /*request*/, ::grpc::channelz::v1::GetChannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetChannel(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetChannelRequest,::grpc::channelz::v1::GetChannelResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSubchannel : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSubchannel() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetSubchannelRequest, ::grpc::channelz::v1::GetSubchannelResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetSubchannelRequest, ::grpc::channelz::v1::GetSubchannelResponse>* streamer) {
                       return this->StreamedGetSubchannel(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSubchannel() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSubchannel(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSubchannelRequest* /*request*/, ::grpc::channelz::v1::GetSubchannelResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSubchannel(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetSubchannelRequest,::grpc::channelz::v1::GetSubchannelResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSocket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSocket() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::grpc::channelz::v1::GetSocketRequest, ::grpc::channelz::v1::GetSocketResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::grpc::channelz::v1::GetSocketRequest, ::grpc::channelz::v1::GetSocketResponse>* streamer) {
                       return this->StreamedGetSocket(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSocket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSocket(::grpc::ServerContext* /*context*/, const ::grpc::channelz::v1::GetSocketRequest* /*request*/, ::grpc::channelz::v1::GetSocketResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSocket(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::grpc::channelz::v1::GetSocketRequest,::grpc::channelz::v1::GetSocketResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_GetTopChannels<WithStreamedUnaryMethod_GetServers<WithStreamedUnaryMethod_GetServer<WithStreamedUnaryMethod_GetServerSockets<WithStreamedUnaryMethod_GetChannel<WithStreamedUnaryMethod_GetSubchannel<WithStreamedUnaryMethod_GetSocket<Service > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_GetTopChannels<WithStreamedUnaryMethod_GetServers<WithStreamedUnaryMethod_GetServer<WithStreamedUnaryMethod_GetServerSockets<WithStreamedUnaryMethod_GetChannel<WithStreamedUnaryMethod_GetSubchannel<WithStreamedUnaryMethod_GetSocket<Service > > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace channelz
}  // namespace grpc


#endif  // GRPC_src_2fproto_2fgrpc_2fchannelz_2fchannelz_2eproto__INCLUDED
