/* Generated by wayland-scanner 1.22.0 */

#ifndef QT_SHELL_UNSTABLE_V1_SERVER_PROTOCOL_H
#define QT_SHELL_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_qt_shell_unstable_v1 The qt_shell_unstable_v1 protocol
 * @section page_ifaces_qt_shell_unstable_v1 Interfaces
 * - @subpage page_iface_zqt_shell_surface_v1 - create fully compliant surfaces for use with Qt applications
 * - @subpage page_iface_zqt_shell_v1 - interface for create qt_shell_surface objects
 * @section page_copyright_qt_shell_unstable_v1 Copyright
 * <pre>
 *
 * Copyright (C) 2021 The Qt Company Ltd.
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause
 * </pre>
 */
struct wl_surface;
struct zqt_shell_surface_v1;
struct zqt_shell_v1;

#ifndef ZQT_SHELL_SURFACE_V1_INTERFACE
#define ZQT_SHELL_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zqt_shell_surface_v1 zqt_shell_surface_v1
 * @section page_iface_zqt_shell_surface_v1_desc Description
 *
 * The qt_shell_surface interface is part of a shell extension which allows clients to
 * access all windowing system features in Qt. These include mechanisms that may only be
 * advisable for trusted applications, and not for arbitrary third-party applications. The
 * qt_shell_surface provides an interface to windowing system features for a surface.
 * @section page_iface_zqt_shell_surface_v1_api API
 * See @ref iface_zqt_shell_surface_v1.
 */
/**
 * @defgroup iface_zqt_shell_surface_v1 The zqt_shell_surface_v1 interface
 *
 * The qt_shell_surface interface is part of a shell extension which allows clients to
 * access all windowing system features in Qt. These include mechanisms that may only be
 * advisable for trusted applications, and not for arbitrary third-party applications. The
 * qt_shell_surface provides an interface to windowing system features for a surface.
 */
extern const struct wl_interface zqt_shell_surface_v1_interface;
#endif
#ifndef ZQT_SHELL_V1_INTERFACE
#define ZQT_SHELL_V1_INTERFACE
/**
 * @page page_iface_zqt_shell_v1 zqt_shell_v1
 * @section page_iface_zqt_shell_v1_desc Description
 *
 * This interface provides a way to request qt_shell_surface objects that correspond to
 * wl_surfaces.
 * @section page_iface_zqt_shell_v1_api API
 * See @ref iface_zqt_shell_v1.
 */
/**
 * @defgroup iface_zqt_shell_v1 The zqt_shell_v1 interface
 *
 * This interface provides a way to request qt_shell_surface objects that correspond to
 * wl_surfaces.
 */
extern const struct wl_interface zqt_shell_v1_interface;
#endif

#ifndef ZQT_SHELL_SURFACE_V1_WINDOW_STATE_ENUM
#define ZQT_SHELL_SURFACE_V1_WINDOW_STATE_ENUM
enum zqt_shell_surface_v1_window_state {
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_NO_STATE = 0,
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_MINIMIZED = 1,
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_MAXIMIZED = 2,
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_FULLSCREEN = 4,
};
#endif /* ZQT_SHELL_SURFACE_V1_WINDOW_STATE_ENUM */

#ifndef ZQT_SHELL_SURFACE_V1_CAPABILITIES_ENUM
#define ZQT_SHELL_SURFACE_V1_CAPABILITIES_ENUM
enum zqt_shell_surface_v1_capabilities {
	ZQT_SHELL_SURFACE_V1_CAPABILITIES_INTERACTIVE_MOVE = 1,
	ZQT_SHELL_SURFACE_V1_CAPABILITIES_INTERACTIVE_RESIZE = 2,
};
#endif /* ZQT_SHELL_SURFACE_V1_CAPABILITIES_ENUM */

/**
 * @ingroup iface_zqt_shell_surface_v1
 * @struct zqt_shell_surface_v1_interface
 */
struct zqt_shell_surface_v1_interface {
	/**
	 * destroy the qt_shell_surface
	 *
	 * Destroys the qt_shell_surface object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * requests a new position for the window
	 *
	 * A client can issue this to request a new position for the
	 * window. If the request is granted, the server will respond with
	 * a configuration event.
	 * @param x the requested horizontal position of the window
	 * @param y the requested vertical position of the window
	 */
	void (*reposition)(struct wl_client *client,
			   struct wl_resource *resource,
			   int32_t x,
			   int32_t y);
	/**
	 * requests that the window becomes active
	 *
	 * This requests that the window becomes active. The server may
	 * respond by giving keyboard focus to the window. Only a single
	 * window may be active at any given time.
	 */
	void (*request_activate)(struct wl_client *client,
				 struct wl_resource *resource);
	/**
	 * informs that the shell surface size has changed
	 *
	 * The client issues the set_size request when the window has
	 * been resized.
	 * @param width the new width of the window
	 * @param height the new height of the window
	 */
	void (*set_size)(struct wl_client *client,
			 struct wl_resource *resource,
			 int32_t width,
			 int32_t height);
	/**
	 * informs of the minimum size hint of the window
	 *
	 * The client issues this request to inform the server of the
	 * minimum size of the window. The server should not attempt to
	 * resize the window below this size.
	 * @param width the minimum width of the window
	 * @param height the minimum height of the window
	 */
	void (*set_minimum_size)(struct wl_client *client,
				 struct wl_resource *resource,
				 int32_t width,
				 int32_t height);
	/**
	 * informs of the maximum size hint of the window
	 *
	 * The client issues this request to inform the server of the
	 * maximum size of the window. The server should not attempt to
	 * resize the window above this size.
	 * @param width the maximum width of the window
	 * @param height the maximum height of the window
	 */
	void (*set_maximum_size)(struct wl_client *client,
				 struct wl_resource *resource,
				 int32_t width,
				 int32_t height);
	/**
	 * informs of the title of the window
	 *
	 * This request is issued to inform the server of the title of
	 * the window.
	 * @param window_title the title of the window
	 */
	void (*set_window_title)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *window_title);
	/**
	 * informs of the flags of the window
	 *
	 * The client issues this request to inform the server of the
	 * current window flags set on the window
	 * @param flags values defined by Qt::WindowFlags
	 */
	void (*set_window_flags)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t flags);
	/**
	 * starts a system resize
	 *
	 * This request is triggered when an application calls
	 * QWindow::startSystemResize() and should trigger interactive
	 * resizing on the server-side. Typical behavior is to have the
	 * selected edge follow the mouse.
	 * @param serial serial of the pointer event that triggered the resize.
	 * @param edge values defined by Qt::Edges
	 */
	void (*start_system_resize)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t serial,
				    uint32_t edge);
	/**
	 * starts a system resize
	 *
	 * This request is triggered when an application calls
	 * QWindow::startSystemMove() and should trigger interactive
	 * repositioning on the server-side. Typical behavior is to have
	 * the window follow the mouse.
	 * @param serial Serial of the pointer event that triggered the move.
	 */
	void (*start_system_move)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t serial);
	/**
	 * requests a new window state
	 *
	 * This requests the server to update the state of the window.
	 * The server may respond with a new configure event bundle that
	 * reflects all the changes in position, size and state that
	 * occurred.
	 * @param state a combinaion of the flags in the window_state enum
	 */
	void (*change_window_state)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t state);
	/**
	 * raises the window
	 *
	 * This requests that the window is brought to the top of the
	 * window stack, so that it is showing on top of all other windows.
	 */
	void (*raise)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * lowers the window
	 *
	 * This requests that the window is brought to the bottom of the
	 * window stack, so that it is showing below all other windows.
	 */
	void (*lower)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * acknowledges a given configure event
	 *
	 * This acknowledges that the given configure event bundle has
	 * been received and that the necessary changes have been applied.
	 * @param serial the serial of the configure event
	 */
	void (*ack_configure)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t serial);
};

#define ZQT_SHELL_SURFACE_V1_RESIZE 0
#define ZQT_SHELL_SURFACE_V1_SET_POSITION 1
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_STATE 2
#define ZQT_SHELL_SURFACE_V1_CONFIGURE 3
#define ZQT_SHELL_SURFACE_V1_SET_FRAME_MARGINS 4
#define ZQT_SHELL_SURFACE_V1_CLOSE 5
#define ZQT_SHELL_SURFACE_V1_SET_CAPABILITIES 6

/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_RESIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_CONFIGURE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_FRAME_MARGINS_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_CAPABILITIES_SINCE_VERSION 1

/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_REPOSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_REQUEST_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_MINIMUM_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_MAXIMUM_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_START_SYSTEM_RESIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_START_SYSTEM_MOVE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_CHANGE_WINDOW_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_RAISE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_LOWER_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_ACK_CONFIGURE_SINCE_VERSION 1

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an resize event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial the serial of the configuration
 * @param width the suggested width of the window
 * @param height the suggested height of the window
 */
static inline void
zqt_shell_surface_v1_send_resize(struct wl_resource *resource_, uint32_t serial, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_RESIZE, serial, width, height);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an set_position event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial the serial of the configuration
 * @param x the suggested horizontal position of the window
 * @param y the suggested vertical position of the window
 */
static inline void
zqt_shell_surface_v1_send_set_position(struct wl_resource *resource_, uint32_t serial, int32_t x, int32_t y)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_SET_POSITION, serial, x, y);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an set_window_state event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial the serial of the configuration
 * @param state a combination of the flags in the window_state enum
 */
static inline void
zqt_shell_surface_v1_send_set_window_state(struct wl_resource *resource_, uint32_t serial, uint32_t state)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_SET_WINDOW_STATE, serial, state);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zqt_shell_surface_v1_send_configure(struct wl_resource *resource_, uint32_t serial)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_CONFIGURE, serial);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an set_frame_margins event to the client owning the resource.
 * @param resource_ The client's resource
 * @param left the left frame margin
 * @param right the right frame margin
 * @param top the top frame margin
 * @param bottom the bottom frame margin
 */
static inline void
zqt_shell_surface_v1_send_set_frame_margins(struct wl_resource *resource_, uint32_t left, uint32_t right, uint32_t top, uint32_t bottom)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_SET_FRAME_MARGINS, left, right, top, bottom);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an close event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zqt_shell_surface_v1_send_close(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_CLOSE);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 * Sends an set_capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 * @param capabilities a mask of flags from the capabilities enum
 */
static inline void
zqt_shell_surface_v1_send_set_capabilities(struct wl_resource *resource_, uint32_t capabilities)
{
	wl_resource_post_event(resource_, ZQT_SHELL_SURFACE_V1_SET_CAPABILITIES, capabilities);
}

#ifndef ZQT_SHELL_V1_ERROR_ENUM
#define ZQT_SHELL_V1_ERROR_ENUM
enum zqt_shell_v1_error {
	/**
	 * wl_surface already has a different role
	 */
	ZQT_SHELL_V1_ERROR_ROLE = 0,
};
#endif /* ZQT_SHELL_V1_ERROR_ENUM */

/**
 * @ingroup iface_zqt_shell_v1
 * @struct zqt_shell_v1_interface
 */
struct zqt_shell_v1_interface {
	/**
	 * creates a new qt_shell_surface object
	 *
	 * Creates a qt_shell_surface object that corresponds to a
	 * surface. If the surface is already assigned a different role,
	 * this will issue a protocol error (see the error enum)
	 */
	void (*surface_create)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *surface,
			       uint32_t id);
};


/**
 * @ingroup iface_zqt_shell_v1
 */
#define ZQT_SHELL_V1_SURFACE_CREATE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
