---
title: "Related Standards"
date: 2023-05-18T13:29:46+0000
weight: 2
---

Other standards or specifications sometimes reference VSS.


### COVESA VISS
When using VSS in an automotive tech stack, a question is which protocols and technologies to use to *access* VSS signals.

The COVESA Vehicle Information Service Specification (**VISS**) is an open standard, specifying a protocol to access VSS data using JSON messages on transport protocols like websocket (VISSv1), HTTP, MQTT (+VISSv2), or gRPC (+VISSv3).

To learn more check

 - [Vehicle Information Service Specification (VISS) V1](https://www.w3.org/TR/vehicle-information-service/) published as a Discontinued Draft.
 - [Vehicle Information Service Specification (VISS) V2.0](https://github.com/COVESA/vehicle-information-service-specification/releases/tag/v2.0).
 - [Vehicle Information Service Specification (VISS) V3.0](https://github.com/COVESA/vehicle-information-service-specification/releases/tag/v3.0).

### W3C VSSo

If you want to interconnect VSS data with other domains, you might want to employ ontology-based tech stacks. The W3C VSS Ontology enables you to express VSS in form of an OWL ontology.

To learn more check

 - [VSSo Core: Vehicle Signal Specification Core Ontology](https://www.w3.org/TR/vsso-core/)
