---
title: "Default Values"
date: 2019-08-04T12:37:31+02:00
weight: 40
---

VSS supports default values by the `default` attribute.
The intention is to provide a mechanism to provide initial values for data entries already when loading a VSS catalog.
This could typically be useful for attributes that never or rarely change, like [vehicle VIN](https://en.wikipedia.org/wiki/Vehicle_identification_number) or vehicle color.

The standard Vehicle Signal Specification does not include default values for all attributes.
If a default value has not been specified then the OEM must define a default value matching the actual vehicle,
either by using the `default` concept, or by the same other mechanism.
If the standard defines a default value but it does not fit the actual vehicle,
then the OEM must override the standard default value.

Attribute values can also change, similar to sensor values.
The latter can be useful for attribute values that are likely to change during the lifetime of the vehicle.
However, attribute values should typically not change more than once per ignition cycle,
or else it should be defined as a sensor instead.

Below is an example of a complete attribute describing engine power

```yaml
MaxPower:
  datatype: uint16
  type: attribute
  default: 0
  unit: kW
  description: Peak power, in kilowatts, that engine can generate.
```

It is possible to give default values also for arrays. In this case square brackets shall be used. The value for each element in the array shall be specified. The size of the array is given by the number of elements specified within the square brackets.

Example 1: Empty Array

```yaml
  default: []
```

Example 2: Array with 3 elements, first element has value 1, second element value 2, third element value 0

```yaml
  default: [1, 2, 0]
```

Full example, array with two elements, first with value2, second with value 3:

```yaml
SeatPosCount:
  datatype: uint8[]
  type: attribute
  default: [2, 3]
  description: Number of seats across each row from the front to the rear
```

Default values can also be defined for [structs](/vehicle_signal_specification/rule_set/data_entry/data_types_struct/).
