
/* GENERATED CODE... DO NOT EDIT */

/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "mbim-ms-basic-connect-extensions.h"
#include "mbim-message-private.h"
#include "mbim-tlv-private.h"
#include "mbim-enum-types.h"
#include "mbim-flag-types.h"
#include "mbim-error-types.h"
#include "mbim-device.h"
#include "mbim-utils.h"

/*****************************************************************************/
/* Struct: MbimPcoValue */

static void
_mbim_pco_value_free (MbimPcoValue *var)
{
    if (!var)
        return;

    g_free (var->pco_data_buffer);
    g_free (var);
}

void
mbim_pco_value_free (MbimPcoValue *var)
{
    _mbim_pco_value_free (var);
}

static MbimPcoValue *
_mbim_message_read_mbim_pco_value_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimPcoValue *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimPcoValue, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->session_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->pco_data_size, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->pco_data_type, error))
        goto out;
    offset += 4;

    {
        const guint8 *tmp;

        if (!_mbim_message_read_byte_array (self, relative_offset, offset, FALSE, FALSE, out->pco_data_size, &tmp, NULL, error, FALSE))
            goto out;
        out->pco_data_buffer = g_malloc (out->pco_data_size);
        memcpy (out->pco_data_buffer, tmp, out->pco_data_size);
        offset += 4;
    }

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->pco_data_buffer);
    g_free (out);
    return NULL;
}

static gchar *
_mbim_message_print_mbim_pco_value_struct (
    const MbimPcoValue *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SessionId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->session_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PcoDataSize = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->pco_data_size);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PcoDataType = ", line_prefix);
    {
        {
#if defined __MBIM_PCO_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_pco_type_get_string ((MbimPcoType)self->pco_data_type));
#elif defined __MBIM_PCO_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_pco_type_build_string_from_mask ((MbimPcoType)self->pco_data_type);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PcoDataBuffer = ", line_prefix);
    {
        {
            guint i;
            guint array_size;

            array_size = self->pco_data_size;
            g_string_append (str, "'");
            for (i = 0; i < array_size; i++)
                g_string_append_printf (str, "%02x%s", self->pco_data_buffer[i], (i == (array_size - 1)) ? "" : ":" );
            g_string_append (str, "'");
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_pco_value_struct_new (const MbimPcoValue *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->session_id);
    _mbim_struct_builder_append_guint32 (builder, value->pco_data_size);
    _mbim_struct_builder_append_guint32 (builder, value->pco_data_type);
    _mbim_struct_builder_append_byte_array (builder, FALSE, FALSE, TRUE, value->pco_data_buffer, value->pco_data_size, FALSE);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_pco_value_struct (
    MbimStructBuilder *builder,
    const MbimPcoValue *value)
{
    GByteArray *raw;

    raw = _mbim_pco_value_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_pco_value_struct (
    MbimMessageCommandBuilder *builder,
    const MbimPcoValue *value)
{
    _mbim_struct_builder_append_mbim_pco_value_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimLteAttachConfiguration */

static void
_mbim_lte_attach_configuration_free (MbimLteAttachConfiguration *var)
{
    if (!var)
        return;

    g_free (var->access_string);
    g_free (var->user_name);
    g_free (var->password);
    g_free (var);
}

void
mbim_lte_attach_configuration_array_free (MbimLteAttachConfigurationArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_lte_attach_configuration_free (array[i]);
    g_free (array);
}

static MbimLteAttachConfiguration *
_mbim_message_read_mbim_lte_attach_configuration_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimLteAttachConfiguration *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimLteAttachConfiguration, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->ip_type, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->roaming, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->source, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->access_string, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->user_name, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->password, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->compression, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->auth_protocol, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->access_string);
    g_free (out->user_name);
    g_free (out->password);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_lte_attach_configuration_ref_struct_array (
    const MbimMessage *self,
    guint32 array_size,
    guint32 relative_offset_array_start,
    MbimLteAttachConfigurationArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 offset;

    if (!array_size) {
        *out_array = NULL;
        return TRUE;
    }

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_lte_attach_configuration_free);

    offset = relative_offset_array_start;
    for (i = 0; i < array_size; i++, offset += 8) {
        guint32 tmp_offset;
        MbimLteAttachConfiguration *array_item;

        if (!_mbim_message_read_guint32 (self, offset, &tmp_offset, error)) 
            return FALSE;

        array_item = _mbim_message_read_mbim_lte_attach_configuration_struct (self, tmp_offset, NULL, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array = (MbimLteAttachConfigurationArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_lte_attach_configuration_struct (
    const MbimLteAttachConfiguration *self,
    const gchar *line_prefix)
{
    GString *str;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    str = g_string_new ("");

    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)self->ip_type));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)self->ip_type);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Roaming = ", line_prefix);
    {
        {
#if defined __MBIM_LTE_ATTACH_CONTEXT_ROAMING_CONTROL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_lte_attach_context_roaming_control_get_string ((MbimLteAttachContextRoamingControl)self->roaming));
#elif defined __MBIM_LTE_ATTACH_CONTEXT_ROAMING_CONTROL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_lte_attach_context_roaming_control_build_string_from_mask ((MbimLteAttachContextRoamingControl)self->roaming);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Source = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_SOURCE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_source_get_string ((MbimContextSource)self->source));
#elif defined __MBIM_CONTEXT_SOURCE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_source_build_string_from_mask ((MbimContextSource)self->source);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->access_string);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        if (show_field) {
            g_string_append_printf (str, "'%s'", self->user_name);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        if (show_field) {
            g_string_append_printf (str, "'%s'", self->password);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)self->compression));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)self->compression);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)self->auth_protocol));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)self->auth_protocol);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_lte_attach_configuration_struct_new (const MbimLteAttachConfiguration *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->ip_type);
    _mbim_struct_builder_append_guint32 (builder, value->roaming);
    _mbim_struct_builder_append_guint32 (builder, value->source);
    _mbim_struct_builder_append_string (builder, value->access_string);
    _mbim_struct_builder_append_string (builder, value->user_name);
    _mbim_struct_builder_append_string (builder, value->password);
    _mbim_struct_builder_append_guint32 (builder, value->compression);
    _mbim_struct_builder_append_guint32 (builder, value->auth_protocol);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_lte_attach_configuration_struct (
    MbimStructBuilder *builder,
    const MbimLteAttachConfiguration *value)
{
    GByteArray *raw;

    raw = _mbim_lte_attach_configuration_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_lte_attach_configuration_struct (
    MbimMessageCommandBuilder *builder,
    const MbimLteAttachConfiguration *value)
{
    _mbim_struct_builder_append_mbim_lte_attach_configuration_struct (builder->contents_builder, value);
}

static void
_mbim_struct_builder_append_mbim_lte_attach_configuration_ref_struct_array (
    MbimStructBuilder *builder,
    const MbimLteAttachConfiguration *const *values,
    guint32 n_values)
{
    guint32 offset;
    guint32 i;

    for (i = 0; i < n_values; i++) {
        guint32 length;
        guint32 offset_offset;
        GByteArray *raw;

        raw = _mbim_lte_attach_configuration_struct_new (values[i]);
        g_assert (raw->len > 0);

        /* Offset of the offset */
        offset_offset = builder->fixed_buffer->len;

        /* Length *not* in LE yet */
        offset = builder->variable_buffer->len;
        /* Add the offset value */
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
        /* Configure the value to get updated */
        g_array_append_val (builder->offsets, offset_offset);

        /* Add the length value */
        length = GUINT32_TO_LE (raw->len);
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&length, sizeof (length));

        /* And finally, the bytearray itself to the variable buffer */
        g_byte_array_append (builder->variable_buffer, (const guint8 *)raw->data, (guint)raw->len);
        g_byte_array_unref (raw);
    }
}

static void
_mbim_message_command_builder_append_mbim_lte_attach_configuration_ref_struct_array (
    MbimMessageCommandBuilder *builder,
    const MbimLteAttachConfiguration *const *values,
    guint32 n_values)
{
    _mbim_struct_builder_append_mbim_lte_attach_configuration_ref_struct_array (builder->contents_builder, values, n_values);
}

/*****************************************************************************/
/* Struct: MbimSlot */

static void
_mbim_slot_free (MbimSlot *var)
{
    if (!var)
        return;

    g_free (var);
}

void
mbim_slot_array_free (MbimSlotArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_slot_free (array[i]);
    g_free (array);
}

static MbimSlot *
_mbim_message_read_mbim_slot_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimSlot *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimSlot, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->slot, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_slot_ref_struct_array (
    const MbimMessage *self,
    guint32 array_size,
    guint32 relative_offset_array_start,
    MbimSlotArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 offset;

    if (!array_size) {
        *out_array = NULL;
        return TRUE;
    }

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_slot_free);

    offset = relative_offset_array_start;
    for (i = 0; i < array_size; i++, offset += 8) {
        guint32 tmp_offset;
        MbimSlot *array_item;

        if (!_mbim_message_read_guint32 (self, offset, &tmp_offset, error)) 
            return FALSE;

        array_item = _mbim_message_read_mbim_slot_struct (self, tmp_offset, NULL, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array = (MbimSlotArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_slot_struct (
    const MbimSlot *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Slot = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->slot);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_slot_struct_new (const MbimSlot *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->slot);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_slot_struct (
    MbimStructBuilder *builder,
    const MbimSlot *value)
{
    GByteArray *raw;

    raw = _mbim_slot_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_slot_struct (
    MbimMessageCommandBuilder *builder,
    const MbimSlot *value)
{
    _mbim_struct_builder_append_mbim_slot_struct (builder->contents_builder, value);
}

static void
_mbim_struct_builder_append_mbim_slot_ref_struct_array (
    MbimStructBuilder *builder,
    const MbimSlot *const *values,
    guint32 n_values)
{
    guint32 offset;
    guint32 i;

    for (i = 0; i < n_values; i++) {
        guint32 length;
        guint32 offset_offset;
        GByteArray *raw;

        raw = _mbim_slot_struct_new (values[i]);
        g_assert (raw->len > 0);

        /* Offset of the offset */
        offset_offset = builder->fixed_buffer->len;

        /* Length *not* in LE yet */
        offset = builder->variable_buffer->len;
        /* Add the offset value */
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
        /* Configure the value to get updated */
        g_array_append_val (builder->offsets, offset_offset);

        /* Add the length value */
        length = GUINT32_TO_LE (raw->len);
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&length, sizeof (length));

        /* And finally, the bytearray itself to the variable buffer */
        g_byte_array_append (builder->variable_buffer, (const guint8 *)raw->data, (guint)raw->len);
        g_byte_array_unref (raw);
    }
}

static void
_mbim_message_command_builder_append_mbim_slot_ref_struct_array (
    MbimMessageCommandBuilder *builder,
    const MbimSlot *const *values,
    guint32 n_values)
{
    _mbim_struct_builder_append_mbim_slot_ref_struct_array (builder->contents_builder, values, n_values);
}

/*****************************************************************************/
/* Struct: MbimProvisionedContextElementV2 */

static void
_mbim_provisioned_context_element_v2_free (MbimProvisionedContextElementV2 *var)
{
    if (!var)
        return;

    g_free (var->access_string);
    g_free (var->user_name);
    g_free (var->password);
    g_free (var);
}

void
mbim_provisioned_context_element_v2_array_free (MbimProvisionedContextElementV2Array *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_provisioned_context_element_v2_free (array[i]);
    g_free (array);
}

static MbimProvisionedContextElementV2 *
_mbim_message_read_mbim_provisioned_context_element_v2_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimProvisionedContextElementV2 *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimProvisionedContextElementV2, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->context_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_uuid (self, offset, NULL, &(out->context_type), error))
        goto out;
    offset += 16;

    if (!_mbim_message_read_guint32 (self, offset, &out->ip_type, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->state, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->roaming, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->media_type, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->source, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->access_string, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->user_name, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->password, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->compression, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->auth_protocol, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->access_string);
    g_free (out->user_name);
    g_free (out->password);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_provisioned_context_element_v2_ref_struct_array (
    const MbimMessage *self,
    guint32 array_size,
    guint32 relative_offset_array_start,
    MbimProvisionedContextElementV2Array **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 offset;

    if (!array_size) {
        *out_array = NULL;
        return TRUE;
    }

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_provisioned_context_element_v2_free);

    offset = relative_offset_array_start;
    for (i = 0; i < array_size; i++, offset += 8) {
        guint32 tmp_offset;
        MbimProvisionedContextElementV2 *array_item;

        if (!_mbim_message_read_guint32 (self, offset, &tmp_offset, error)) 
            return FALSE;

        array_item = _mbim_message_read_mbim_provisioned_context_element_v2_struct (self, tmp_offset, NULL, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array = (MbimProvisionedContextElementV2Array *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_provisioned_context_element_v2_struct (
    const MbimProvisionedContextElementV2 *self,
    const gchar *line_prefix)
{
    GString *str;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ContextId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->context_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  ContextType = ", line_prefix);
    {
        {
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uuid_get_printable (&(self->context_type));
            g_string_append_printf (str, "'%s'", tmpstr);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)self->ip_type));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)self->ip_type);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  State = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_state_get_string ((MbimContextState)self->state));
#elif defined __MBIM_CONTEXT_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_state_build_string_from_mask ((MbimContextState)self->state);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Roaming = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_ROAMING_CONTROL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_roaming_control_get_string ((MbimContextRoamingControl)self->roaming));
#elif defined __MBIM_CONTEXT_ROAMING_CONTROL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_roaming_control_build_string_from_mask ((MbimContextRoamingControl)self->roaming);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  MediaType = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_MEDIA_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_media_type_get_string ((MbimContextMediaType)self->media_type));
#elif defined __MBIM_CONTEXT_MEDIA_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_media_type_build_string_from_mask ((MbimContextMediaType)self->media_type);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Source = ", line_prefix);
    {
        {
#if defined __MBIM_CONTEXT_SOURCE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_source_get_string ((MbimContextSource)self->source));
#elif defined __MBIM_CONTEXT_SOURCE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_source_build_string_from_mask ((MbimContextSource)self->source);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->access_string);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        if (show_field) {
            g_string_append_printf (str, "'%s'", self->user_name);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        if (show_field) {
            g_string_append_printf (str, "'%s'", self->password);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)self->compression));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)self->compression);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)self->auth_protocol));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)self->auth_protocol);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_provisioned_context_element_v2_struct_new (const MbimProvisionedContextElementV2 *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->context_id);
    _mbim_struct_builder_append_uuid (builder, &(value->context_type));
    _mbim_struct_builder_append_guint32 (builder, value->ip_type);
    _mbim_struct_builder_append_guint32 (builder, value->state);
    _mbim_struct_builder_append_guint32 (builder, value->roaming);
    _mbim_struct_builder_append_guint32 (builder, value->media_type);
    _mbim_struct_builder_append_guint32 (builder, value->source);
    _mbim_struct_builder_append_string (builder, value->access_string);
    _mbim_struct_builder_append_string (builder, value->user_name);
    _mbim_struct_builder_append_string (builder, value->password);
    _mbim_struct_builder_append_guint32 (builder, value->compression);
    _mbim_struct_builder_append_guint32 (builder, value->auth_protocol);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_provisioned_context_element_v2_struct (
    MbimStructBuilder *builder,
    const MbimProvisionedContextElementV2 *value)
{
    GByteArray *raw;

    raw = _mbim_provisioned_context_element_v2_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_provisioned_context_element_v2_struct (
    MbimMessageCommandBuilder *builder,
    const MbimProvisionedContextElementV2 *value)
{
    _mbim_struct_builder_append_mbim_provisioned_context_element_v2_struct (builder->contents_builder, value);
}

static void
_mbim_struct_builder_append_mbim_provisioned_context_element_v2_ref_struct_array (
    MbimStructBuilder *builder,
    const MbimProvisionedContextElementV2 *const *values,
    guint32 n_values)
{
    guint32 offset;
    guint32 i;

    for (i = 0; i < n_values; i++) {
        guint32 length;
        guint32 offset_offset;
        GByteArray *raw;

        raw = _mbim_provisioned_context_element_v2_struct_new (values[i]);
        g_assert (raw->len > 0);

        /* Offset of the offset */
        offset_offset = builder->fixed_buffer->len;

        /* Length *not* in LE yet */
        offset = builder->variable_buffer->len;
        /* Add the offset value */
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
        /* Configure the value to get updated */
        g_array_append_val (builder->offsets, offset_offset);

        /* Add the length value */
        length = GUINT32_TO_LE (raw->len);
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&length, sizeof (length));

        /* And finally, the bytearray itself to the variable buffer */
        g_byte_array_append (builder->variable_buffer, (const guint8 *)raw->data, (guint)raw->len);
        g_byte_array_unref (raw);
    }
}

static void
_mbim_message_command_builder_append_mbim_provisioned_context_element_v2_ref_struct_array (
    MbimMessageCommandBuilder *builder,
    const MbimProvisionedContextElementV2 *const *values,
    guint32 n_values)
{
    _mbim_struct_builder_append_mbim_provisioned_context_element_v2_ref_struct_array (builder->contents_builder, values, n_values);
}

/*****************************************************************************/
/* Struct: MbimCellInfoServingGsm */

static void
_mbim_cell_info_serving_gsm_free (MbimCellInfoServingGsm *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_serving_gsm_free (MbimCellInfoServingGsm *var)
{
    _mbim_cell_info_serving_gsm_free (var);
}

static MbimCellInfoServingGsm *
_mbim_message_read_mbim_cell_info_serving_gsm_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoServingGsm *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoServingGsm, 1);


    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->location_area_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->timing_advance, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->arfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->base_station_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rx_level, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_serving_gsm_ms_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    MbimCellInfoServingGsm **out_struct,
    GError **error)
{
    MbimCellInfoServingGsm *out;
    guint32 offset;
    guint32 size;

    g_assert (self != NULL);

    if (!_mbim_message_read_guint32 (self, relative_offset, &offset, error))
        return FALSE;
    relative_offset += 4;

    if (!_mbim_message_read_guint32 (self, relative_offset, &size, error))
        return FALSE;
    relative_offset += 4;

    if (!offset) {
        *out_struct = NULL;
        return TRUE;
    }

    out = _mbim_message_read_mbim_cell_info_serving_gsm_struct (self, offset, NULL, error);
    if (!out)
        return FALSE;
    *out_struct = out;
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_serving_gsm_struct (
    const MbimCellInfoServingGsm *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->location_area_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  TimingAdvance = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->timing_advance);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Arfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->arfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  BaseStationId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->base_station_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  RxLevel = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rx_level);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_serving_gsm_struct_new (const MbimCellInfoServingGsm *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->location_area_code);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->timing_advance);
    _mbim_struct_builder_append_guint32 (builder, value->arfcn);
    _mbim_struct_builder_append_guint32 (builder, value->base_station_id);
    _mbim_struct_builder_append_guint32 (builder, value->rx_level);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_serving_gsm_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoServingGsm *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_serving_gsm_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_serving_gsm_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoServingGsm *value)
{
    _mbim_struct_builder_append_mbim_cell_info_serving_gsm_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoServingUmts */

static void
_mbim_cell_info_serving_umts_free (MbimCellInfoServingUmts *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_serving_umts_free (MbimCellInfoServingUmts *var)
{
    _mbim_cell_info_serving_umts_free (var);
}

static MbimCellInfoServingUmts *
_mbim_message_read_mbim_cell_info_serving_umts_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoServingUmts *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoServingUmts, 1);


    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->location_area_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->frequency_info_ul, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->frequency_info_dl, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->frequency_info_nt, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->uarfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->primary_scrambling_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rscp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->ecno, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->path_loss, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_serving_umts_ms_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    MbimCellInfoServingUmts **out_struct,
    GError **error)
{
    MbimCellInfoServingUmts *out;
    guint32 offset;
    guint32 size;

    g_assert (self != NULL);

    if (!_mbim_message_read_guint32 (self, relative_offset, &offset, error))
        return FALSE;
    relative_offset += 4;

    if (!_mbim_message_read_guint32 (self, relative_offset, &size, error))
        return FALSE;
    relative_offset += 4;

    if (!offset) {
        *out_struct = NULL;
        return TRUE;
    }

    out = _mbim_message_read_mbim_cell_info_serving_umts_struct (self, offset, NULL, error);
    if (!out)
        return FALSE;
    *out_struct = out;
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_serving_umts_struct (
    const MbimCellInfoServingUmts *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->location_area_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  FrequencyInfoUL = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->frequency_info_ul);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  FrequencyInfoDL = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->frequency_info_dl);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  FrequencyInfoNT = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->frequency_info_nt);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Uarfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->uarfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PrimaryScramblingCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->primary_scrambling_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rscp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rscp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Ecno = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->ecno);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PathLoss = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->path_loss);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_serving_umts_struct_new (const MbimCellInfoServingUmts *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->location_area_code);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->frequency_info_ul);
    _mbim_struct_builder_append_guint32 (builder, value->frequency_info_dl);
    _mbim_struct_builder_append_guint32 (builder, value->frequency_info_nt);
    _mbim_struct_builder_append_guint32 (builder, value->uarfcn);
    _mbim_struct_builder_append_guint32 (builder, value->primary_scrambling_code);
    _mbim_struct_builder_append_gint32 (builder, value->rscp);
    _mbim_struct_builder_append_gint32 (builder, value->ecno);
    _mbim_struct_builder_append_guint32 (builder, value->path_loss);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_serving_umts_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoServingUmts *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_serving_umts_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_serving_umts_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoServingUmts *value)
{
    _mbim_struct_builder_append_mbim_cell_info_serving_umts_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoServingTdscdma */

static void
_mbim_cell_info_serving_tdscdma_free (MbimCellInfoServingTdscdma *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_serving_tdscdma_free (MbimCellInfoServingTdscdma *var)
{
    _mbim_cell_info_serving_tdscdma_free (var);
}

static MbimCellInfoServingTdscdma *
_mbim_message_read_mbim_cell_info_serving_tdscdma_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoServingTdscdma *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoServingTdscdma, 1);


    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->location_area_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->uarfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_parameter_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->timing_advance, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rscp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->path_loss, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_serving_tdscdma_ms_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    MbimCellInfoServingTdscdma **out_struct,
    GError **error)
{
    MbimCellInfoServingTdscdma *out;
    guint32 offset;
    guint32 size;

    g_assert (self != NULL);

    if (!_mbim_message_read_guint32 (self, relative_offset, &offset, error))
        return FALSE;
    relative_offset += 4;

    if (!_mbim_message_read_guint32 (self, relative_offset, &size, error))
        return FALSE;
    relative_offset += 4;

    if (!offset) {
        *out_struct = NULL;
        return TRUE;
    }

    out = _mbim_message_read_mbim_cell_info_serving_tdscdma_struct (self, offset, NULL, error);
    if (!out)
        return FALSE;
    *out_struct = out;
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_serving_tdscdma_struct (
    const MbimCellInfoServingTdscdma *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->location_area_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Uarfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->uarfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellParameterID = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_parameter_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  TimingAdvance = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->timing_advance);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rscp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rscp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PathLoss = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->path_loss);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_serving_tdscdma_struct_new (const MbimCellInfoServingTdscdma *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->location_area_code);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->uarfcn);
    _mbim_struct_builder_append_guint32 (builder, value->cell_parameter_id);
    _mbim_struct_builder_append_guint32 (builder, value->timing_advance);
    _mbim_struct_builder_append_gint32 (builder, value->rscp);
    _mbim_struct_builder_append_guint32 (builder, value->path_loss);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_serving_tdscdma_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoServingTdscdma *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_serving_tdscdma_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_serving_tdscdma_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoServingTdscdma *value)
{
    _mbim_struct_builder_append_mbim_cell_info_serving_tdscdma_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoServingLte */

static void
_mbim_cell_info_serving_lte_free (MbimCellInfoServingLte *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_serving_lte_free (MbimCellInfoServingLte *var)
{
    _mbim_cell_info_serving_lte_free (var);
}

static MbimCellInfoServingLte *
_mbim_message_read_mbim_cell_info_serving_lte_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoServingLte *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoServingLte, 1);


    if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, NULL, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->earfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->physical_cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->tac, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rsrp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rsrq, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->timing_advance, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_serving_lte_ms_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    MbimCellInfoServingLte **out_struct,
    GError **error)
{
    MbimCellInfoServingLte *out;
    guint32 offset;
    guint32 size;

    g_assert (self != NULL);

    if (!_mbim_message_read_guint32 (self, relative_offset, &offset, error))
        return FALSE;
    relative_offset += 4;

    if (!_mbim_message_read_guint32 (self, relative_offset, &size, error))
        return FALSE;
    relative_offset += 4;

    if (!offset) {
        *out_struct = NULL;
        return TRUE;
    }

    out = _mbim_message_read_mbim_cell_info_serving_lte_struct (self, offset, NULL, error);
    if (!out)
        return FALSE;
    *out_struct = out;
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_serving_lte_struct (
    const MbimCellInfoServingLte *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Earfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->earfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PhysicalCellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->physical_cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Tac = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->tac);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rsrp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrq = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rsrq);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  TimingAdvance = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->timing_advance);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_serving_lte_struct_new (const MbimCellInfoServingLte *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->earfcn);
    _mbim_struct_builder_append_guint32 (builder, value->physical_cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->tac);
    _mbim_struct_builder_append_gint32 (builder, value->rsrp);
    _mbim_struct_builder_append_gint32 (builder, value->rsrq);
    _mbim_struct_builder_append_guint32 (builder, value->timing_advance);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_serving_lte_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoServingLte *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_serving_lte_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_serving_lte_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoServingLte *value)
{
    _mbim_struct_builder_append_mbim_cell_info_serving_lte_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoNeighboringGsm */

static void
_mbim_cell_info_neighboring_gsm_free (MbimCellInfoNeighboringGsm *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_neighboring_gsm_array_free (MbimCellInfoNeighboringGsmArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_neighboring_gsm_free (array[i]);
    g_free (array);
}

static MbimCellInfoNeighboringGsm *
_mbim_message_read_mbim_cell_info_neighboring_gsm_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoNeighboringGsm *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoNeighboringGsm, 1);


    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    if (!_mbim_message_read_guint32 (self, offset, &out->location_area_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->arfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->base_station_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rx_level, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_neighboring_gsm_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoNeighboringGsmArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_neighboring_gsm_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoNeighboringGsm *array_item;

        array_item = _mbim_message_read_mbim_cell_info_neighboring_gsm_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoNeighboringGsmArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_neighboring_gsm_struct (
    const MbimCellInfoNeighboringGsm *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->location_area_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Arfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->arfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  BaseStationId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->base_station_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  RxLevel = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rx_level);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_neighboring_gsm_struct_new (const MbimCellInfoNeighboringGsm *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->location_area_code);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->arfcn);
    _mbim_struct_builder_append_guint32 (builder, value->base_station_id);
    _mbim_struct_builder_append_guint32 (builder, value->rx_level);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_neighboring_gsm_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoNeighboringGsm *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_neighboring_gsm_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_neighboring_gsm_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoNeighboringGsm *value)
{
    _mbim_struct_builder_append_mbim_cell_info_neighboring_gsm_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoNeighboringUmts */

static void
_mbim_cell_info_neighboring_umts_free (MbimCellInfoNeighboringUmts *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_neighboring_umts_array_free (MbimCellInfoNeighboringUmtsArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_neighboring_umts_free (array[i]);
    g_free (array);
}

static MbimCellInfoNeighboringUmts *
_mbim_message_read_mbim_cell_info_neighboring_umts_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoNeighboringUmts *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoNeighboringUmts, 1);


    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    if (!_mbim_message_read_guint32 (self, offset, &out->location_area_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->uarfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->primary_scrambling_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rscp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->ecno, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->path_loss, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_neighboring_umts_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoNeighboringUmtsArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_neighboring_umts_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoNeighboringUmts *array_item;

        array_item = _mbim_message_read_mbim_cell_info_neighboring_umts_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoNeighboringUmtsArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_neighboring_umts_struct (
    const MbimCellInfoNeighboringUmts *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->location_area_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Uarfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->uarfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PrimaryScramblingCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->primary_scrambling_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rscp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rscp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Ecno = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->ecno);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PathLoss = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->path_loss);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_neighboring_umts_struct_new (const MbimCellInfoNeighboringUmts *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->location_area_code);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->uarfcn);
    _mbim_struct_builder_append_guint32 (builder, value->primary_scrambling_code);
    _mbim_struct_builder_append_gint32 (builder, value->rscp);
    _mbim_struct_builder_append_gint32 (builder, value->ecno);
    _mbim_struct_builder_append_guint32 (builder, value->path_loss);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_neighboring_umts_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoNeighboringUmts *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_neighboring_umts_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_neighboring_umts_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoNeighboringUmts *value)
{
    _mbim_struct_builder_append_mbim_cell_info_neighboring_umts_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoNeighboringTdscdma */

static void
_mbim_cell_info_neighboring_tdscdma_free (MbimCellInfoNeighboringTdscdma *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_neighboring_tdscdma_array_free (MbimCellInfoNeighboringTdscdmaArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_neighboring_tdscdma_free (array[i]);
    g_free (array);
}

static MbimCellInfoNeighboringTdscdma *
_mbim_message_read_mbim_cell_info_neighboring_tdscdma_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoNeighboringTdscdma *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoNeighboringTdscdma, 1);


    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    if (!_mbim_message_read_guint32 (self, offset, &out->location_area_code, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->uarfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_parameter_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->timing_advance, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rscp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->path_loss, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_neighboring_tdscdma_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoNeighboringTdscdmaArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_neighboring_tdscdma_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoNeighboringTdscdma *array_item;

        array_item = _mbim_message_read_mbim_cell_info_neighboring_tdscdma_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoNeighboringTdscdmaArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_neighboring_tdscdma_struct (
    const MbimCellInfoNeighboringTdscdma *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->location_area_code);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Uarfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->uarfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellParameterID = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_parameter_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  TimingAdvance = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->timing_advance);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rscp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rscp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PathLoss = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->path_loss);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_neighboring_tdscdma_struct_new (const MbimCellInfoNeighboringTdscdma *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->location_area_code);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->uarfcn);
    _mbim_struct_builder_append_guint32 (builder, value->cell_parameter_id);
    _mbim_struct_builder_append_guint32 (builder, value->timing_advance);
    _mbim_struct_builder_append_gint32 (builder, value->rscp);
    _mbim_struct_builder_append_guint32 (builder, value->path_loss);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_neighboring_tdscdma_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoNeighboringTdscdma *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_neighboring_tdscdma_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_neighboring_tdscdma_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoNeighboringTdscdma *value)
{
    _mbim_struct_builder_append_mbim_cell_info_neighboring_tdscdma_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoNeighboringLte */

static void
_mbim_cell_info_neighboring_lte_free (MbimCellInfoNeighboringLte *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_neighboring_lte_array_free (MbimCellInfoNeighboringLteArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_neighboring_lte_free (array[i]);
    g_free (array);
}

static MbimCellInfoNeighboringLte *
_mbim_message_read_mbim_cell_info_neighboring_lte_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoNeighboringLte *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoNeighboringLte, 1);


    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    if (!_mbim_message_read_guint32 (self, offset, &out->cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->earfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->physical_cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->tac, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rsrp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_gint32 (self, offset, &out->rsrq, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_neighboring_lte_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoNeighboringLteArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_neighboring_lte_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoNeighboringLte *array_item;

        array_item = _mbim_message_read_mbim_cell_info_neighboring_lte_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoNeighboringLteArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_neighboring_lte_struct (
    const MbimCellInfoNeighboringLte *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Earfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->earfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PhysicalCellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->physical_cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Tac = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->tac);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rsrp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrq = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GINT32_FORMAT "'", self->rsrq);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_neighboring_lte_struct_new (const MbimCellInfoNeighboringLte *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint32 (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->earfcn);
    _mbim_struct_builder_append_guint32 (builder, value->physical_cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->tac);
    _mbim_struct_builder_append_gint32 (builder, value->rsrp);
    _mbim_struct_builder_append_gint32 (builder, value->rsrq);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_neighboring_lte_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoNeighboringLte *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_neighboring_lte_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_neighboring_lte_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoNeighboringLte *value)
{
    _mbim_struct_builder_append_mbim_cell_info_neighboring_lte_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoCdma */

static void
_mbim_cell_info_cdma_free (MbimCellInfoCdma *var)
{
    if (!var)
        return;

    g_free (var);
}

void
mbim_cell_info_cdma_array_free (MbimCellInfoCdmaArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_cdma_free (array[i]);
    g_free (array);
}

static MbimCellInfoCdma *
_mbim_message_read_mbim_cell_info_cdma_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoCdma *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoCdma, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->serving_cell_flag, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->nid, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->sid, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->base_station_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->base_latitude, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->base_longitude, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->ref_pn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->gps_seconds, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->pilot_strength, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_cdma_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoCdmaArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_cdma_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoCdma *array_item;

        array_item = _mbim_message_read_mbim_cell_info_cdma_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoCdmaArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_cdma_struct (
    const MbimCellInfoCdma *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ServingCellFlag = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->serving_cell_flag);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Nid = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->nid);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Sid = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->sid);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  BaseStationId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->base_station_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  BaseLatitude = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->base_latitude);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  BaseLongitude = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->base_longitude);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  RefPn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->ref_pn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  GpsSeconds = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->gps_seconds);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PilotStrength = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->pilot_strength);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_cdma_struct_new (const MbimCellInfoCdma *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->serving_cell_flag);
    _mbim_struct_builder_append_guint32 (builder, value->nid);
    _mbim_struct_builder_append_guint32 (builder, value->sid);
    _mbim_struct_builder_append_guint32 (builder, value->base_station_id);
    _mbim_struct_builder_append_guint32 (builder, value->base_latitude);
    _mbim_struct_builder_append_guint32 (builder, value->base_longitude);
    _mbim_struct_builder_append_guint32 (builder, value->ref_pn);
    _mbim_struct_builder_append_guint32 (builder, value->gps_seconds);
    _mbim_struct_builder_append_guint32 (builder, value->pilot_strength);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_cdma_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoCdma *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_cdma_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_cdma_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoCdma *value)
{
    _mbim_struct_builder_append_mbim_cell_info_cdma_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoServingNr */

static void
_mbim_cell_info_serving_nr_free (MbimCellInfoServingNr *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var);
}

void
mbim_cell_info_serving_nr_array_free (MbimCellInfoServingNrArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_serving_nr_free (array[i]);
    g_free (array);
}

static MbimCellInfoServingNr *
_mbim_message_read_mbim_cell_info_serving_nr_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoServingNr *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoServingNr, 1);


    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    if (!_mbim_message_read_guint64 (self, offset, &out->nci, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->physical_cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->nrarfcn, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->tac, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rsrp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rsrq, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->sinr, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint64 (self, offset, &out->timing_advance, error))
        goto out;
    offset += 8;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out->provider_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_serving_nr_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoServingNrArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_serving_nr_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoServingNr *array_item;

        array_item = _mbim_message_read_mbim_cell_info_serving_nr_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoServingNrArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_serving_nr_struct (
    const MbimCellInfoServingNr *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Nci = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT64_FORMAT "'", self->nci);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PhysicalCellID = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->physical_cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Nrarfcn = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->nrarfcn);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Tac = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->tac);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rsrp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrq = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rsrq);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Sinr = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->sinr);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  TimingAdvance = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT64_FORMAT "'", self->timing_advance);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_serving_nr_struct_new (const MbimCellInfoServingNr *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_guint64 (builder, value->nci);
    _mbim_struct_builder_append_guint32 (builder, value->physical_cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->nrarfcn);
    _mbim_struct_builder_append_guint32 (builder, value->tac);
    _mbim_struct_builder_append_guint32 (builder, value->rsrp);
    _mbim_struct_builder_append_guint32 (builder, value->rsrq);
    _mbim_struct_builder_append_guint32 (builder, value->sinr);
    _mbim_struct_builder_append_guint64 (builder, value->timing_advance);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_serving_nr_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoServingNr *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_serving_nr_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_serving_nr_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoServingNr *value)
{
    _mbim_struct_builder_append_mbim_cell_info_serving_nr_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Struct: MbimCellInfoNeighboringNr */

static void
_mbim_cell_info_neighboring_nr_free (MbimCellInfoNeighboringNr *var)
{
    if (!var)
        return;

    g_free (var->provider_id);
    g_free (var->cell_id);
    g_free (var);
}

void
mbim_cell_info_neighboring_nr_array_free (MbimCellInfoNeighboringNrArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_cell_info_neighboring_nr_free (array[i]);
    g_free (array);
}

static MbimCellInfoNeighboringNr *
_mbim_message_read_mbim_cell_info_neighboring_nr_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimCellInfoNeighboringNr *out;
    guint32 offset = relative_offset;
    guint32 extra_bytes_read = 0;

    g_assert (self != NULL);

    out = g_new0 (MbimCellInfoNeighboringNr, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->system_sub_type, error))
        goto out;
    offset += 4;

    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->provider_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    {
        guint32 str_bytes_read;

        if (!_mbim_message_read_string (self, relative_offset, offset, MBIM_STRING_ENCODING_UTF16, &out->cell_id, &str_bytes_read, error))
            goto out;
        if (str_bytes_read % 4)
            str_bytes_read = (str_bytes_read + (4 - (str_bytes_read % 4)));
        extra_bytes_read += str_bytes_read;
        offset += 8;
    }

    if (!_mbim_message_read_guint32 (self, offset, &out->physical_cell_id, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->tac, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rsrp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rsrq, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->sinr, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset) + extra_bytes_read;
        return out;
    }

    g_free (out->provider_id);
    g_free (out->cell_id);
    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_cell_info_neighboring_nr_ms_struct_array (
    const MbimMessage *self,
    guint32 offset,
    guint32 *out_array_size,
    MbimCellInfoNeighboringNrArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 intermediate_struct_offset;
    guint32 intermediate_struct_size;
    guint32 array_size;
    guint32 bytes_read = 0;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_offset, error))
        return FALSE;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &intermediate_struct_size, error))
        return FALSE;
    offset += 4;

    if (!intermediate_struct_offset) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    if (!_mbim_message_read_guint32 (self, intermediate_struct_offset, &array_size, error))
        return FALSE;

    if (!array_size) {
        *out_array_size = 0;
        *out_array = NULL;
        return TRUE;
    }

    intermediate_struct_offset += 4;

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_cell_info_neighboring_nr_free);

    for (i = 0; i < array_size; i++, intermediate_struct_offset += bytes_read) {
        MbimCellInfoNeighboringNr *array_item;

        array_item = _mbim_message_read_mbim_cell_info_neighboring_nr_struct (self, intermediate_struct_offset, &bytes_read, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array_size = array_size;
    *out_array = (MbimCellInfoNeighboringNrArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_cell_info_neighboring_nr_struct (
    const MbimCellInfoNeighboringNr *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SystemSubType = ", line_prefix);
    {
        {
#if defined __MBIM_DATA_SUBCLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_subclass_get_string ((MbimDataSubclass)self->system_sub_type));
#elif defined __MBIM_DATA_SUBCLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_subclass_build_string_from_mask ((MbimDataSubclass)self->system_sub_type);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  ProviderId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->provider_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CellId = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", self->cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  PhysicalCellID = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->physical_cell_id);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Tac = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->tac);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrp = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rsrp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Rsrq = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rsrq);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Sinr = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->sinr);
        }
    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_cell_info_neighboring_nr_struct_new (const MbimCellInfoNeighboringNr *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->system_sub_type);
    _mbim_struct_builder_append_string (builder, value->provider_id);
    _mbim_struct_builder_append_string (builder, value->cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->physical_cell_id);
    _mbim_struct_builder_append_guint32 (builder, value->tac);
    _mbim_struct_builder_append_guint32 (builder, value->rsrp);
    _mbim_struct_builder_append_guint32 (builder, value->rsrq);
    _mbim_struct_builder_append_guint32 (builder, value->sinr);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_cell_info_neighboring_nr_struct (
    MbimStructBuilder *builder,
    const MbimCellInfoNeighboringNr *value)
{
    GByteArray *raw;

    raw = _mbim_cell_info_neighboring_nr_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_cell_info_neighboring_nr_struct (
    MbimMessageCommandBuilder *builder,
    const MbimCellInfoNeighboringNr *value)
{
    _mbim_struct_builder_append_mbim_cell_info_neighboring_nr_struct (builder->contents_builder, value);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions PCO */

MbimMessage *
mbim_message_ms_basic_connect_extensions_pco_query_new (
    const MbimPcoValue *pco_value,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_PCO,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);
    {
        _mbim_message_command_builder_append_mbim_pco_value_struct (builder, pco_value);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_pco_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  PcoValue = ", line_prefix);
    {
        g_autoptr(MbimPcoValue) tmp = NULL;
        guint32 bytes_read = 0;

        tmp = _mbim_message_read_mbim_pco_value_struct (message, offset, &bytes_read, &inner_error);
        if (!tmp)
            goto out;
        offset += bytes_read;
        {
            g_autofree gchar *new_line_prefix = NULL;
            g_autofree gchar *struct_str = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            struct_str = _mbim_message_print_mbim_pco_value_struct (tmp, new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions PCO */

gboolean
mbim_message_ms_basic_connect_extensions_pco_response_parse (
    const MbimMessage *message,
    MbimPcoValue **out_pco_value,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    MbimPcoValue *_pco_value = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'PcoValue' variable */
    {
        MbimPcoValue *tmp;
        guint32 bytes_read = 0;

        tmp = _mbim_message_read_mbim_pco_value_struct (message, offset, &bytes_read, error);
        if (!tmp)
            goto out;
        if (out_pco_value != NULL)
            _pco_value = tmp;
        else
             _mbim_pco_value_free (tmp);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_pco_value != NULL)
            *out_pco_value = _pco_value;
    } else {
        mbim_pco_value_free (_pco_value);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_pco_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  PcoValue = ", line_prefix);
    {
        g_autoptr(MbimPcoValue) tmp = NULL;
        guint32 bytes_read = 0;

        tmp = _mbim_message_read_mbim_pco_value_struct (message, offset, &bytes_read, &inner_error);
        if (!tmp)
            goto out;
        offset += bytes_read;
        {
            g_autofree gchar *new_line_prefix = NULL;
            g_autofree gchar *struct_str = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            struct_str = _mbim_message_print_mbim_pco_value_struct (tmp, new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions PCO */

gboolean
mbim_message_ms_basic_connect_extensions_pco_notification_parse (
    const MbimMessage *message,
    MbimPcoValue **out_pco_value,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    MbimPcoValue *_pco_value = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'PcoValue' variable */
    {
        MbimPcoValue *tmp;
        guint32 bytes_read = 0;

        tmp = _mbim_message_read_mbim_pco_value_struct (message, offset, &bytes_read, error);
        if (!tmp)
            goto out;
        if (out_pco_value != NULL)
            _pco_value = tmp;
        else
             _mbim_pco_value_free (tmp);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_pco_value != NULL)
            *out_pco_value = _pco_value;
    } else {
        mbim_pco_value_free (_pco_value);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_pco_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  PcoValue = ", line_prefix);
    {
        g_autoptr(MbimPcoValue) tmp = NULL;
        guint32 bytes_read = 0;

        tmp = _mbim_message_read_mbim_pco_value_struct (message, offset, &bytes_read, &inner_error);
        if (!tmp)
            goto out;
        offset += bytes_read;
        {
            g_autofree gchar *new_line_prefix = NULL;
            g_autofree gchar *struct_str = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            struct_str = _mbim_message_print_mbim_pco_value_struct (tmp, new_line_prefix);
            g_string_append (str, struct_str);
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

MbimMessage *
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LTE_ATTACH_CONFIGURATION,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

MbimMessage *
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_set_new (
    MbimLteAttachContextOperation operation,
    guint32 configuration_count,
    const MbimLteAttachConfiguration *const *configurations,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LTE_ATTACH_CONFIGURATION,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, operation);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, configuration_count);
    }
    {
        _mbim_message_command_builder_append_mbim_lte_attach_configuration_ref_struct_array (builder, configurations, configuration_count);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _configuration_count;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Operation = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LTE_ATTACH_CONTEXT_OPERATION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_lte_attach_context_operation_get_string ((MbimLteAttachContextOperation)tmp));
#elif defined __MBIM_LTE_ATTACH_CONTEXT_OPERATION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_lte_attach_context_operation_build_string_from_mask ((MbimLteAttachContextOperation)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigurationCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_configuration_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _configuration_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Configurations = ", line_prefix);
    {
        g_autoptr(MbimLteAttachConfigurationArray) tmp = NULL;

        if (!_mbim_message_read_mbim_lte_attach_configuration_ref_struct_array (message, _configuration_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _configuration_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _configuration_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_lte_attach_configuration_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

gboolean
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_response_parse (
    const MbimMessage *message,
    guint32 *out_configuration_count,
    MbimLteAttachConfigurationArray **out_configurations,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _configuration_count;
    MbimLteAttachConfiguration **_configurations = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ConfigurationCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_configuration_count, error))
            goto out;
        if (out_configuration_count != NULL)
            *out_configuration_count = _configuration_count;
        offset += 4;
    }

    /* Read the 'Configurations' variable */
    {
        if ((out_configurations != NULL) && !_mbim_message_read_mbim_lte_attach_configuration_ref_struct_array (message, _configuration_count, offset, &_configurations, error))
            goto out;
        offset += (8 * _configuration_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_configurations != NULL)
            *out_configurations = _configurations;
    } else {
        mbim_lte_attach_configuration_array_free (_configurations);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _configuration_count;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ConfigurationCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_configuration_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _configuration_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Configurations = ", line_prefix);
    {
        g_autoptr(MbimLteAttachConfigurationArray) tmp = NULL;

        if (!_mbim_message_read_mbim_lte_attach_configuration_ref_struct_array (message, _configuration_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _configuration_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _configuration_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_lte_attach_configuration_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Lte Attach Configuration */

gboolean
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_notification_parse (
    const MbimMessage *message,
    guint32 *out_configuration_count,
    MbimLteAttachConfigurationArray **out_configurations,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _configuration_count;
    MbimLteAttachConfiguration **_configurations = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ConfigurationCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_configuration_count, error))
            goto out;
        if (out_configuration_count != NULL)
            *out_configuration_count = _configuration_count;
        offset += 4;
    }

    /* Read the 'Configurations' variable */
    {
        if ((out_configurations != NULL) && !_mbim_message_read_mbim_lte_attach_configuration_ref_struct_array (message, _configuration_count, offset, &_configurations, error))
            goto out;
        offset += (8 * _configuration_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_configurations != NULL)
            *out_configurations = _configurations;
    } else {
        mbim_lte_attach_configuration_array_free (_configurations);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_configuration_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _configuration_count;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ConfigurationCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_configuration_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _configuration_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Configurations = ", line_prefix);
    {
        g_autoptr(MbimLteAttachConfigurationArray) tmp = NULL;

        if (!_mbim_message_read_mbim_lte_attach_configuration_ref_struct_array (message, _configuration_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _configuration_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _configuration_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_lte_attach_configuration_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Lte Attach Info */

MbimMessage *
mbim_message_ms_basic_connect_extensions_lte_attach_info_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LTE_ATTACH_INFO,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_info_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Lte Attach Info */

gboolean
mbim_message_ms_basic_connect_extensions_lte_attach_info_response_parse (
    const MbimMessage *message,
    MbimLteAttachState *out_lte_attach_state,
    MbimContextIpType *out_ip_type,
    gchar **out_access_string,
    gchar **out_user_name,
    gchar **out_password,
    MbimCompression *out_compression,
    MbimAuthProtocol *out_auth_protocol,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_access_string = NULL;
    gchar *_user_name = NULL;
    gchar *_password = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'LteAttachState' variable */
    {
        if (out_lte_attach_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_lte_attach_state = (MbimLteAttachState)aux;
        }
        offset += 4;
    }

    /* Read the 'IpType' variable */
    {
        if (out_ip_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_ip_type = (MbimContextIpType)aux;
        }
        offset += 4;
    }

    /* Read the 'AccessString' variable */
    {
        if ((out_access_string != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_access_string, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'UserName' variable */
    {
        if ((out_user_name != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_user_name, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Password' variable */
    {
        if ((out_password != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_password, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Compression' variable */
    {
        if (out_compression != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_compression = (MbimCompression)aux;
        }
        offset += 4;
    }

    /* Read the 'AuthProtocol' variable */
    {
        if (out_auth_protocol != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_auth_protocol = (MbimAuthProtocol)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_access_string != NULL)
            *out_access_string = _access_string;
        if (out_user_name != NULL)
            *out_user_name = _user_name;
        if (out_password != NULL)
            *out_password = _password;
    } else {
        g_free (_access_string);
        g_free (_user_name);
        g_free (_password);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_info_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  LteAttachState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LTE_ATTACH_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_lte_attach_state_get_string ((MbimLteAttachState)tmp));
#elif defined __MBIM_LTE_ATTACH_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_lte_attach_state_build_string_from_mask ((MbimLteAttachState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)tmp));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)tmp));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)tmp));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Lte Attach Info */

gboolean
mbim_message_ms_basic_connect_extensions_lte_attach_info_notification_parse (
    const MbimMessage *message,
    MbimLteAttachState *out_lte_attach_state,
    MbimContextIpType *out_ip_type,
    gchar **out_access_string,
    gchar **out_user_name,
    gchar **out_password,
    MbimCompression *out_compression,
    MbimAuthProtocol *out_auth_protocol,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_access_string = NULL;
    gchar *_user_name = NULL;
    gchar *_password = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'LteAttachState' variable */
    {
        if (out_lte_attach_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_lte_attach_state = (MbimLteAttachState)aux;
        }
        offset += 4;
    }

    /* Read the 'IpType' variable */
    {
        if (out_ip_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_ip_type = (MbimContextIpType)aux;
        }
        offset += 4;
    }

    /* Read the 'AccessString' variable */
    {
        if ((out_access_string != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_access_string, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'UserName' variable */
    {
        if ((out_user_name != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_user_name, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Password' variable */
    {
        if ((out_password != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_password, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Compression' variable */
    {
        if (out_compression != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_compression = (MbimCompression)aux;
        }
        offset += 4;
    }

    /* Read the 'AuthProtocol' variable */
    {
        if (out_auth_protocol != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_auth_protocol = (MbimAuthProtocol)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_access_string != NULL)
            *out_access_string = _access_string;
        if (out_user_name != NULL)
            *out_user_name = _user_name;
        if (out_password != NULL)
            *out_password = _password;
    } else {
        g_free (_access_string);
        g_free (_user_name);
        g_free (_password);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_lte_attach_info_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  LteAttachState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LTE_ATTACH_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_lte_attach_state_get_string ((MbimLteAttachState)tmp));
#elif defined __MBIM_LTE_ATTACH_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_lte_attach_state_build_string_from_mask ((MbimLteAttachState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)tmp));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)tmp));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)tmp));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Sys Caps */

MbimMessage *
mbim_message_ms_basic_connect_extensions_sys_caps_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_SYS_CAPS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_sys_caps_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Sys Caps */

gboolean
mbim_message_ms_basic_connect_extensions_sys_caps_response_parse (
    const MbimMessage *message,
    guint32 *out_number_of_executors,
    guint32 *out_number_of_slots,
    guint32 *out_concurrency,
    guint64 *out_modem_id,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'NumberOfExecutors' variable */
    {
        if ((out_number_of_executors != NULL) && !_mbim_message_read_guint32 (message, offset, out_number_of_executors, error))
            goto out;
        offset += 4;
    }

    /* Read the 'NumberOfSlots' variable */
    {
        if ((out_number_of_slots != NULL) && !_mbim_message_read_guint32 (message, offset, out_number_of_slots, error))
            goto out;
        offset += 4;
    }

    /* Read the 'Concurrency' variable */
    {
        if ((out_concurrency != NULL) && !_mbim_message_read_guint32 (message, offset, out_concurrency, error))
            goto out;
        offset += 4;
    }

    /* Read the 'ModemId' variable */
    {
        if ((out_modem_id != NULL) && !_mbim_message_read_guint64 (message, offset, out_modem_id, error))
            goto out;
        offset += 8;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_sys_caps_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  NumberOfExecutors = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  NumberOfSlots = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Concurrency = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ModemId = ", line_prefix);
    {
        guint64 tmp;

        if (!_mbim_message_read_guint64 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%" G_GUINT64_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Slot Info Status */

MbimMessage *
mbim_message_ms_basic_connect_extensions_slot_info_status_query_new (
    guint32 slot_index,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_SLOT_INFO_STATUS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);
    {
        _mbim_message_command_builder_append_guint32 (builder, slot_index);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_slot_info_status_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SlotIndex = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Slot Info Status */

gboolean
mbim_message_ms_basic_connect_extensions_slot_info_status_response_parse (
    const MbimMessage *message,
    guint32 *out_slot_index,
    MbimUiccSlotState *out_state,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'SlotIndex' variable */
    {
        if ((out_slot_index != NULL) && !_mbim_message_read_guint32 (message, offset, out_slot_index, error))
            goto out;
        offset += 4;
    }

    /* Read the 'State' variable */
    {
        if (out_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_state = (MbimUiccSlotState)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_slot_info_status_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SlotIndex = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  State = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_UICC_SLOT_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_uicc_slot_state_get_string ((MbimUiccSlotState)tmp));
#elif defined __MBIM_UICC_SLOT_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uicc_slot_state_build_string_from_mask ((MbimUiccSlotState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Slot Info Status */

gboolean
mbim_message_ms_basic_connect_extensions_slot_info_status_notification_parse (
    const MbimMessage *message,
    guint32 *out_slot_index,
    MbimUiccSlotState *out_state,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'SlotIndex' variable */
    {
        if ((out_slot_index != NULL) && !_mbim_message_read_guint32 (message, offset, out_slot_index, error))
            goto out;
        offset += 4;
    }

    /* Read the 'State' variable */
    {
        if (out_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_state = (MbimUiccSlotState)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_slot_info_status_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SlotIndex = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  State = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_UICC_SLOT_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_uicc_slot_state_get_string ((MbimUiccSlotState)tmp));
#elif defined __MBIM_UICC_SLOT_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_uicc_slot_state_build_string_from_mask ((MbimUiccSlotState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Device Slot Mappings */

MbimMessage *
mbim_message_ms_basic_connect_extensions_device_slot_mappings_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_SLOT_MAPPINGS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_slot_mappings_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Ms Basic Connect Extensions Device Slot Mappings */

MbimMessage *
mbim_message_ms_basic_connect_extensions_device_slot_mappings_set_new (
    guint32 map_count,
    const MbimSlot *const *slot_map,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_SLOT_MAPPINGS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, map_count);
    }
    {
        _mbim_message_command_builder_append_mbim_slot_ref_struct_array (builder, slot_map, map_count);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_slot_mappings_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _map_count;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MapCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_map_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _map_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SlotMap = ", line_prefix);
    {
        g_autoptr(MbimSlotArray) tmp = NULL;

        if (!_mbim_message_read_mbim_slot_ref_struct_array (message, _map_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _map_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _map_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_slot_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Device Slot Mappings */

gboolean
mbim_message_ms_basic_connect_extensions_device_slot_mappings_response_parse (
    const MbimMessage *message,
    guint32 *out_map_count,
    MbimSlotArray **out_slot_map,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _map_count;
    MbimSlot **_slot_map = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'MapCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_map_count, error))
            goto out;
        if (out_map_count != NULL)
            *out_map_count = _map_count;
        offset += 4;
    }

    /* Read the 'SlotMap' variable */
    {
        if ((out_slot_map != NULL) && !_mbim_message_read_mbim_slot_ref_struct_array (message, _map_count, offset, &_slot_map, error))
            goto out;
        offset += (8 * _map_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_slot_map != NULL)
            *out_slot_map = _slot_map;
    } else {
        mbim_slot_array_free (_slot_map);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_slot_mappings_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _map_count;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MapCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_map_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _map_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SlotMap = ", line_prefix);
    {
        g_autoptr(MbimSlotArray) tmp = NULL;

        if (!_mbim_message_read_mbim_slot_ref_struct_array (message, _map_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _map_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _map_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_slot_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Device Caps */

MbimMessage *
mbim_message_ms_basic_connect_extensions_device_caps_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_CAPS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_caps_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Device Caps */

gboolean
mbim_message_ms_basic_connect_extensions_device_caps_response_parse (
    const MbimMessage *message,
    MbimDeviceType *out_device_type,
    MbimCellularClass *out_cellular_class,
    MbimVoiceClass *out_voice_class,
    MbimSimClass *out_sms_class,
    MbimDataClass *out_data_class,
    MbimSmsCaps *out_sms_caps,
    MbimCtrlCaps *out_control_caps,
    guint32 *out_max_sessions,
    gchar **out_custom_data_class,
    gchar **out_device_id,
    gchar **out_firmware_info,
    gchar **out_hardware_info,
    guint32 *out_executor_index,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_custom_data_class = NULL;
    gchar *_device_id = NULL;
    gchar *_firmware_info = NULL;
    gchar *_hardware_info = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'DeviceType' variable */
    {
        if (out_device_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_device_type = (MbimDeviceType)aux;
        }
        offset += 4;
    }

    /* Read the 'CellularClass' variable */
    {
        if (out_cellular_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_cellular_class = (MbimCellularClass)aux;
        }
        offset += 4;
    }

    /* Read the 'VoiceClass' variable */
    {
        if (out_voice_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_voice_class = (MbimVoiceClass)aux;
        }
        offset += 4;
    }

    /* Read the 'SmsClass' variable */
    {
        if (out_sms_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_sms_class = (MbimSimClass)aux;
        }
        offset += 4;
    }

    /* Read the 'DataClass' variable */
    {
        if (out_data_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_data_class = (MbimDataClass)aux;
        }
        offset += 4;
    }

    /* Read the 'SmsCaps' variable */
    {
        if (out_sms_caps != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_sms_caps = (MbimSmsCaps)aux;
        }
        offset += 4;
    }

    /* Read the 'ControlCaps' variable */
    {
        if (out_control_caps != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_control_caps = (MbimCtrlCaps)aux;
        }
        offset += 4;
    }

    /* Read the 'MaxSessions' variable */
    {
        if ((out_max_sessions != NULL) && !_mbim_message_read_guint32 (message, offset, out_max_sessions, error))
            goto out;
        offset += 4;
    }

    /* Read the 'CustomDataClass' variable */
    {
        if ((out_custom_data_class != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_custom_data_class, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'DeviceId' variable */
    {
        if ((out_device_id != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_device_id, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'FirmwareInfo' variable */
    {
        if ((out_firmware_info != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_firmware_info, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'HardwareInfo' variable */
    {
        if ((out_hardware_info != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_hardware_info, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'ExecutorIndex' variable */
    {
        if ((out_executor_index != NULL) && !_mbim_message_read_guint32 (message, offset, out_executor_index, error))
            goto out;
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_custom_data_class != NULL)
            *out_custom_data_class = _custom_data_class;
        if (out_device_id != NULL)
            *out_device_id = _device_id;
        if (out_firmware_info != NULL)
            *out_firmware_info = _firmware_info;
        if (out_hardware_info != NULL)
            *out_hardware_info = _hardware_info;
    } else {
        g_free (_custom_data_class);
        g_free (_device_id);
        g_free (_firmware_info);
        g_free (_hardware_info);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_caps_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  DeviceType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DEVICE_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_device_type_get_string ((MbimDeviceType)tmp));
#elif defined __MBIM_DEVICE_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_device_type_build_string_from_mask ((MbimDeviceType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CellularClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CELLULAR_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_cellular_class_get_string ((MbimCellularClass)tmp));
#elif defined __MBIM_CELLULAR_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_cellular_class_build_string_from_mask ((MbimCellularClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  VoiceClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_VOICE_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_voice_class_get_string ((MbimVoiceClass)tmp));
#elif defined __MBIM_VOICE_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_voice_class_build_string_from_mask ((MbimVoiceClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SmsClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_SIM_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_sim_class_get_string ((MbimSimClass)tmp));
#elif defined __MBIM_SIM_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sim_class_build_string_from_mask ((MbimSimClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DataClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_class_get_string ((MbimDataClass)tmp));
#elif defined __MBIM_DATA_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_class_build_string_from_mask ((MbimDataClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SmsCaps = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_SMS_CAPS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_sms_caps_get_string ((MbimSmsCaps)tmp));
#elif defined __MBIM_SMS_CAPS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sms_caps_build_string_from_mask ((MbimSmsCaps)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ControlCaps = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CTRL_CAPS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_ctrl_caps_get_string ((MbimCtrlCaps)tmp));
#elif defined __MBIM_CTRL_CAPS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_ctrl_caps_build_string_from_mask ((MbimCtrlCaps)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxSessions = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CustomDataClass = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DeviceId = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  FirmwareInfo = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  HardwareInfo = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ExecutorIndex = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Location Info Status */

MbimMessage *
mbim_message_ms_basic_connect_extensions_location_info_status_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LOCATION_INFO_STATUS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_location_info_status_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Location Info Status */

gboolean
mbim_message_ms_basic_connect_extensions_location_info_status_response_parse (
    const MbimMessage *message,
    guint32 *out_location_area_code,
    guint32 *out_tracking_area_code,
    guint32 *out_cell_id,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'LocationAreaCode' variable */
    {
        if ((out_location_area_code != NULL) && !_mbim_message_read_guint32 (message, offset, out_location_area_code, error))
            goto out;
        offset += 4;
    }

    /* Read the 'TrackingAreaCode' variable */
    {
        if ((out_tracking_area_code != NULL) && !_mbim_message_read_guint32 (message, offset, out_tracking_area_code, error))
            goto out;
        offset += 4;
    }

    /* Read the 'CellID' variable */
    {
        if ((out_cell_id != NULL) && !_mbim_message_read_guint32 (message, offset, out_cell_id, error))
            goto out;
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_location_info_status_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TrackingAreaCode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CellID = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Location Info Status */

gboolean
mbim_message_ms_basic_connect_extensions_location_info_status_notification_parse (
    const MbimMessage *message,
    guint32 *out_location_area_code,
    guint32 *out_tracking_area_code,
    guint32 *out_cell_id,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'LocationAreaCode' variable */
    {
        if ((out_location_area_code != NULL) && !_mbim_message_read_guint32 (message, offset, out_location_area_code, error))
            goto out;
        offset += 4;
    }

    /* Read the 'TrackingAreaCode' variable */
    {
        if ((out_tracking_area_code != NULL) && !_mbim_message_read_guint32 (message, offset, out_tracking_area_code, error))
            goto out;
        offset += 4;
    }

    /* Read the 'CellID' variable */
    {
        if ((out_cell_id != NULL) && !_mbim_message_read_guint32 (message, offset, out_cell_id, error))
            goto out;
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_location_info_status_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  LocationAreaCode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TrackingAreaCode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CellID = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Provisioned Contexts */

MbimMessage *
mbim_message_ms_basic_connect_extensions_provisioned_contexts_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_PROVISIONED_CONTEXTS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_provisioned_contexts_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Ms Basic Connect Extensions Provisioned Contexts */

MbimMessage *
mbim_message_ms_basic_connect_extensions_provisioned_contexts_set_new (
    MbimContextOperation operation,
    const MbimUuid *context_type,
    MbimContextIpType ip_type,
    MbimContextState state,
    MbimContextRoamingControl roaming,
    MbimContextMediaType media_type,
    MbimContextSource source,
    const gchar *access_string,
    const gchar *user_name,
    const gchar *password,
    MbimCompression compression,
    MbimAuthProtocol auth_protocol,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_PROVISIONED_CONTEXTS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, operation);
    }
    {
        _mbim_message_command_builder_append_uuid (builder, context_type);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, ip_type);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, state);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, roaming);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, media_type);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, source);
    }
    {
        _mbim_message_command_builder_append_string (builder, access_string);
    }
    {
        _mbim_message_command_builder_append_string (builder, user_name);
    }
    {
        _mbim_message_command_builder_append_string (builder, password);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, compression);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, auth_protocol);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_provisioned_contexts_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  Operation = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_OPERATION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_operation_get_string ((MbimContextOperation)tmp));
#elif defined __MBIM_CONTEXT_OPERATION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_operation_build_string_from_mask ((MbimContextOperation)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ContextType = ", line_prefix);
    {
        MbimUuid          tmp;
        g_autofree gchar *tmpstr = NULL;

        if (!_mbim_message_read_uuid (message, offset, NULL, &tmp, &inner_error))
            goto out;
        offset += 16;
        tmpstr = mbim_uuid_get_printable (&tmp);
        {
            g_string_append_printf (str, "'%s'", tmpstr);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)tmp));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  State = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_state_get_string ((MbimContextState)tmp));
#elif defined __MBIM_CONTEXT_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_state_build_string_from_mask ((MbimContextState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Roaming = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_ROAMING_CONTROL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_roaming_control_get_string ((MbimContextRoamingControl)tmp));
#elif defined __MBIM_CONTEXT_ROAMING_CONTROL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_roaming_control_build_string_from_mask ((MbimContextRoamingControl)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MediaType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_MEDIA_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_media_type_get_string ((MbimContextMediaType)tmp));
#elif defined __MBIM_CONTEXT_MEDIA_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_media_type_build_string_from_mask ((MbimContextMediaType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Source = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_SOURCE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_source_get_string ((MbimContextSource)tmp));
#elif defined __MBIM_CONTEXT_SOURCE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_source_build_string_from_mask ((MbimContextSource)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)tmp));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)tmp));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Provisioned Contexts */

gboolean
mbim_message_ms_basic_connect_extensions_provisioned_contexts_response_parse (
    const MbimMessage *message,
    guint32 *out_provisioned_contexts_count,
    MbimProvisionedContextElementV2Array **out_provisioned_contexts,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _provisioned_contexts_count;
    MbimProvisionedContextElementV2 **_provisioned_contexts = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ProvisionedContextsCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_provisioned_contexts_count, error))
            goto out;
        if (out_provisioned_contexts_count != NULL)
            *out_provisioned_contexts_count = _provisioned_contexts_count;
        offset += 4;
    }

    /* Read the 'ProvisionedContexts' variable */
    {
        if ((out_provisioned_contexts != NULL) && !_mbim_message_read_mbim_provisioned_context_element_v2_ref_struct_array (message, _provisioned_contexts_count, offset, &_provisioned_contexts, error))
            goto out;
        offset += (8 * _provisioned_contexts_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_provisioned_contexts != NULL)
            *out_provisioned_contexts = _provisioned_contexts;
    } else {
        mbim_provisioned_context_element_v2_array_free (_provisioned_contexts);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_provisioned_contexts_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _provisioned_contexts_count;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProvisionedContextsCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_provisioned_contexts_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _provisioned_contexts_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ProvisionedContexts = ", line_prefix);
    {
        g_autoptr(MbimProvisionedContextElementV2Array) tmp = NULL;

        if (!_mbim_message_read_mbim_provisioned_context_element_v2_ref_struct_array (message, _provisioned_contexts_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _provisioned_contexts_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _provisioned_contexts_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_provisioned_context_element_v2_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions Provisioned Contexts */

gboolean
mbim_message_ms_basic_connect_extensions_provisioned_contexts_notification_parse (
    const MbimMessage *message,
    guint32 *out_provisioned_contexts_count,
    MbimProvisionedContextElementV2Array **out_provisioned_contexts,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _provisioned_contexts_count;
    MbimProvisionedContextElementV2 **_provisioned_contexts = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ProvisionedContextsCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_provisioned_contexts_count, error))
            goto out;
        if (out_provisioned_contexts_count != NULL)
            *out_provisioned_contexts_count = _provisioned_contexts_count;
        offset += 4;
    }

    /* Read the 'ProvisionedContexts' variable */
    {
        if ((out_provisioned_contexts != NULL) && !_mbim_message_read_mbim_provisioned_context_element_v2_ref_struct_array (message, _provisioned_contexts_count, offset, &_provisioned_contexts, error))
            goto out;
        offset += (8 * _provisioned_contexts_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_provisioned_contexts != NULL)
            *out_provisioned_contexts = _provisioned_contexts;
    } else {
        mbim_provisioned_context_element_v2_array_free (_provisioned_contexts);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_provisioned_contexts_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _provisioned_contexts_count;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ProvisionedContextsCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_provisioned_contexts_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _provisioned_contexts_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ProvisionedContexts = ", line_prefix);
    {
        g_autoptr(MbimProvisionedContextElementV2Array) tmp = NULL;

        if (!_mbim_message_read_mbim_provisioned_context_element_v2_ref_struct_array (message, _provisioned_contexts_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _provisioned_contexts_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _provisioned_contexts_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_provisioned_context_element_v2_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions Base Stations Info */

MbimMessage *
mbim_message_ms_basic_connect_extensions_base_stations_info_query_new (
    guint32 max_gsm_count,
    guint32 max_umts_count,
    guint32 max_tdscdma_count,
    guint32 max_lte_count,
    guint32 max_cdma_count,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_BASE_STATIONS_INFO,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);
    {
        _mbim_message_command_builder_append_guint32 (builder, max_gsm_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_umts_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_tdscdma_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_lte_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_cdma_count);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_base_stations_info_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MaxGsmCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxUmtsCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxTdscdmaCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxLteCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxCdmaCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Base Stations Info */

gboolean
mbim_message_ms_basic_connect_extensions_base_stations_info_response_parse (
    const MbimMessage *message,
    MbimDataClass *out_system_type,
    MbimCellInfoServingGsm **out_gsm_serving_cell,
    MbimCellInfoServingUmts **out_umts_serving_cell,
    MbimCellInfoServingTdscdma **out_tdscdma_serving_cell,
    MbimCellInfoServingLte **out_lte_serving_cell,
    guint32 *out_gsm_neighboring_cells_count,
    MbimCellInfoNeighboringGsmArray **out_gsm_neighboring_cells,
    guint32 *out_umts_neighboring_cells_count,
    MbimCellInfoNeighboringUmtsArray **out_umts_neighboring_cells,
    guint32 *out_tdscdma_neighboring_cells_count,
    MbimCellInfoNeighboringTdscdmaArray **out_tdscdma_neighboring_cells,
    guint32 *out_lte_neighboring_cells_count,
    MbimCellInfoNeighboringLteArray **out_lte_neighboring_cells,
    guint32 *out_cdma_cells_count,
    MbimCellInfoCdmaArray **out_cdma_cells,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    MbimCellInfoServingGsm *_gsm_serving_cell = NULL;
    MbimCellInfoServingUmts *_umts_serving_cell = NULL;
    MbimCellInfoServingTdscdma *_tdscdma_serving_cell = NULL;
    MbimCellInfoServingLte *_lte_serving_cell = NULL;
    MbimCellInfoNeighboringGsm **_gsm_neighboring_cells = NULL;
    MbimCellInfoNeighboringUmts **_umts_neighboring_cells = NULL;
    MbimCellInfoNeighboringTdscdma **_tdscdma_neighboring_cells = NULL;
    MbimCellInfoNeighboringLte **_lte_neighboring_cells = NULL;
    MbimCellInfoCdma **_cdma_cells = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'SystemType' variable */
    {
        if (out_system_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_system_type = (MbimDataClass)aux;
        }
        offset += 4;
    }

    /* Read the 'GsmServingCell' variable */
    {
        MbimCellInfoServingGsm *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_gsm_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_gsm_serving_cell != NULL)
            _gsm_serving_cell = tmp;
        else
             _mbim_cell_info_serving_gsm_free (tmp);
        offset += 8;
    }

    /* Read the 'UmtsServingCell' variable */
    {
        MbimCellInfoServingUmts *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_umts_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_umts_serving_cell != NULL)
            _umts_serving_cell = tmp;
        else
             _mbim_cell_info_serving_umts_free (tmp);
        offset += 8;
    }

    /* Read the 'TdscdmaServingCell' variable */
    {
        MbimCellInfoServingTdscdma *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_tdscdma_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_tdscdma_serving_cell != NULL)
            _tdscdma_serving_cell = tmp;
        else
             _mbim_cell_info_serving_tdscdma_free (tmp);
        offset += 8;
    }

    /* Read the 'LteServingCell' variable */
    {
        MbimCellInfoServingLte *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_lte_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_lte_serving_cell != NULL)
            _lte_serving_cell = tmp;
        else
             _mbim_cell_info_serving_lte_free (tmp);
        offset += 8;
    }

    /* Read the 'GsmNeighboringCells' variable */
    {
        if ((out_gsm_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_gsm_ms_struct_array (message, offset, out_gsm_neighboring_cells_count, &_gsm_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'UmtsNeighboringCells' variable */
    {
        if ((out_umts_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_umts_ms_struct_array (message, offset, out_umts_neighboring_cells_count, &_umts_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'TdscdmaNeighboringCells' variable */
    {
        if ((out_tdscdma_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_tdscdma_ms_struct_array (message, offset, out_tdscdma_neighboring_cells_count, &_tdscdma_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'LteNeighboringCells' variable */
    {
        if ((out_lte_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_lte_ms_struct_array (message, offset, out_lte_neighboring_cells_count, &_lte_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'CdmaCells' variable */
    {
        if ((out_cdma_cells != NULL) && !_mbim_message_read_mbim_cell_info_cdma_ms_struct_array (message, offset, out_cdma_cells_count, &_cdma_cells, error))
            goto out;
        offset += 8;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_gsm_serving_cell != NULL)
            *out_gsm_serving_cell = _gsm_serving_cell;
        if (out_umts_serving_cell != NULL)
            *out_umts_serving_cell = _umts_serving_cell;
        if (out_tdscdma_serving_cell != NULL)
            *out_tdscdma_serving_cell = _tdscdma_serving_cell;
        if (out_lte_serving_cell != NULL)
            *out_lte_serving_cell = _lte_serving_cell;
        if (out_gsm_neighboring_cells != NULL)
            *out_gsm_neighboring_cells = _gsm_neighboring_cells;
        if (out_umts_neighboring_cells != NULL)
            *out_umts_neighboring_cells = _umts_neighboring_cells;
        if (out_tdscdma_neighboring_cells != NULL)
            *out_tdscdma_neighboring_cells = _tdscdma_neighboring_cells;
        if (out_lte_neighboring_cells != NULL)
            *out_lte_neighboring_cells = _lte_neighboring_cells;
        if (out_cdma_cells != NULL)
            *out_cdma_cells = _cdma_cells;
    } else {
        mbim_cell_info_serving_gsm_free (_gsm_serving_cell);
        mbim_cell_info_serving_umts_free (_umts_serving_cell);
        mbim_cell_info_serving_tdscdma_free (_tdscdma_serving_cell);
        mbim_cell_info_serving_lte_free (_lte_serving_cell);
        mbim_cell_info_neighboring_gsm_array_free (_gsm_neighboring_cells);
        mbim_cell_info_neighboring_umts_array_free (_umts_neighboring_cells);
        mbim_cell_info_neighboring_tdscdma_array_free (_tdscdma_neighboring_cells);
        mbim_cell_info_neighboring_lte_array_free (_lte_neighboring_cells);
        mbim_cell_info_cdma_array_free (_cdma_cells);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_base_stations_info_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SystemType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_class_get_string ((MbimDataClass)tmp));
#elif defined __MBIM_DATA_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_class_build_string_from_mask ((MbimDataClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  GsmServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingGsm) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_gsm_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_gsm_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UmtsServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingUmts) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_umts_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_umts_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TdscdmaServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingTdscdma) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_tdscdma_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_tdscdma_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LteServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingLte) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_lte_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_lte_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  GsmNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringGsmArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_gsm_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_gsm_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UmtsNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringUmtsArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_umts_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_umts_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TdscdmaNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringTdscdmaArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_tdscdma_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_tdscdma_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LteNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringLteArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_lte_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_lte_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CdmaCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoCdmaArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_cdma_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_cdma_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Ms Basic Connect Extensions Device Reset */

MbimMessage *
mbim_message_ms_basic_connect_extensions_device_reset_set_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_RESET,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_reset_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions Device Reset */

gboolean
mbim_message_ms_basic_connect_extensions_device_reset_response_parse (
    const MbimMessage *message,
    GError **error)
{

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    return TRUE;
}

static gchar *
mbim_message_ms_basic_connect_extensions_device_reset_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions V2 Version */

MbimMessage *
mbim_message_ms_basic_connect_extensions_v2_version_query_new (
    guint16 mbim_version,
    guint16 mbim_extended_version,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_VERSION,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);
    {
        _mbim_message_command_builder_append_guint16 (builder, mbim_version);
    }
    {
        _mbim_message_command_builder_append_guint16 (builder, mbim_extended_version);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_v2_version_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MbimVersion = ", line_prefix);
    {
        guint16 tmp;

        if (!_mbim_message_read_guint16 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 2;
        {
            g_string_append_printf (str, "'%" G_GUINT16_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MbimExtendedVersion = ", line_prefix);
    {
        guint16 tmp;

        if (!_mbim_message_read_guint16 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 2;
        {
            g_string_append_printf (str, "'%" G_GUINT16_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V2 Version */

gboolean
mbim_message_ms_basic_connect_extensions_v2_version_response_parse (
    const MbimMessage *message,
    guint16 *out_mbim_version,
    guint16 *out_mbim_extended_version,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'MbimVersion' variable */
    {
        if ((out_mbim_version != NULL) && !_mbim_message_read_guint16 (message, offset, out_mbim_version, error))
            goto out;
        offset += 2;
    }

    /* Read the 'MbimExtendedVersion' variable */
    {
        if ((out_mbim_extended_version != NULL) && !_mbim_message_read_guint16 (message, offset, out_mbim_extended_version, error))
            goto out;
        offset += 2;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:


    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v2_version_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MbimVersion = ", line_prefix);
    {
        guint16 tmp;

        if (!_mbim_message_read_guint16 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 2;
        {
            g_string_append_printf (str, "'%" G_GUINT16_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MbimExtendedVersion = ", line_prefix);
    {
        guint16 tmp;

        if (!_mbim_message_read_guint16 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 2;
        {
            g_string_append_printf (str, "'%" G_GUINT16_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V3 Device Caps */

gboolean
mbim_message_ms_basic_connect_extensions_v3_device_caps_response_parse (
    const MbimMessage *message,
    MbimDeviceType *out_device_type,
    MbimCellularClass *out_cellular_class,
    MbimVoiceClass *out_voice_class,
    MbimSimClass *out_sim_class,
    MbimDataClassV3 *out_data_class,
    MbimSmsCaps *out_sms_caps,
    MbimCtrlCaps *out_control_caps,
    MbimDataSubclass *out_data_subclass,
    guint32 *out_max_sessions,
    guint32 *out_executor_index,
    guint32 *out_wcdma_band_class,
    guint32 *out_lte_band_class_count,
    guint16 **out_lte_band_class,
    guint32 *out_nr_band_class_count,
    guint16 **out_nr_band_class,
    gchar **out_custom_data_class,
    gchar **out_device_id,
    gchar **out_firmware_info,
    gchar **out_hardware_info,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint16 *_lte_band_class = NULL;
    guint16 *_nr_band_class = NULL;
    gchar *_custom_data_class = NULL;
    gchar *_device_id = NULL;
    gchar *_firmware_info = NULL;
    gchar *_hardware_info = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'DeviceType' variable */
    {
        if (out_device_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_device_type = (MbimDeviceType)aux;
        }
        offset += 4;
    }

    /* Read the 'CellularClass' variable */
    {
        if (out_cellular_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_cellular_class = (MbimCellularClass)aux;
        }
        offset += 4;
    }

    /* Read the 'VoiceClass' variable */
    {
        if (out_voice_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_voice_class = (MbimVoiceClass)aux;
        }
        offset += 4;
    }

    /* Read the 'SimClass' variable */
    {
        if (out_sim_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_sim_class = (MbimSimClass)aux;
        }
        offset += 4;
    }

    /* Read the 'DataClass' variable */
    {
        if (out_data_class != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_data_class = (MbimDataClassV3)aux;
        }
        offset += 4;
    }

    /* Read the 'SmsCaps' variable */
    {
        if (out_sms_caps != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_sms_caps = (MbimSmsCaps)aux;
        }
        offset += 4;
    }

    /* Read the 'ControlCaps' variable */
    {
        if (out_control_caps != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_control_caps = (MbimCtrlCaps)aux;
        }
        offset += 4;
    }

    /* Read the 'DataSubclass' variable */
    {
        if (out_data_subclass != NULL) {
            guint64 aux;

            if (!_mbim_message_read_guint64 (message, offset, &aux, error))
                goto out;
            *out_data_subclass = (MbimDataSubclass)aux;
        }
        offset += 8;
    }

    /* Read the 'MaxSessions' variable */
    {
        if ((out_max_sessions != NULL) && !_mbim_message_read_guint32 (message, offset, out_max_sessions, error))
            goto out;
        offset += 4;
    }

    /* Read the 'ExecutorIndex' variable */
    {
        if ((out_executor_index != NULL) && !_mbim_message_read_guint32 (message, offset, out_executor_index, error))
            goto out;
        offset += 4;
    }

    /* Read the 'WcdmaBandClass' variable */
    {
        if ((out_wcdma_band_class != NULL) && !_mbim_message_read_guint32 (message, offset, out_wcdma_band_class, error))
            goto out;
        offset += 4;
    }

    /* Read the 'LteBandClass' variable */
    {
        guint16 *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_guint16_array (message, offset, out_lte_band_class_count, &tmp, &bytes_read, error))
            goto out;
        if (out_lte_band_class != NULL)
            _lte_band_class = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'NrBandClass' variable */
    {
        guint16 *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_guint16_array (message, offset, out_nr_band_class_count, &tmp, &bytes_read, error))
            goto out;
        if (out_nr_band_class != NULL)
            _nr_band_class = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'CustomDataClass' variable */
    {
        gchar *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_string (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_custom_data_class != NULL)
            _custom_data_class = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'DeviceId' variable */
    {
        gchar *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_string (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_device_id != NULL)
            _device_id = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'FirmwareInfo' variable */
    {
        gchar *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_string (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_firmware_info != NULL)
            _firmware_info = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'HardwareInfo' variable */
    {
        gchar *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_string (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_hardware_info != NULL)
            _hardware_info = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_lte_band_class != NULL)
            *out_lte_band_class = _lte_band_class;
        if (out_nr_band_class != NULL)
            *out_nr_band_class = _nr_band_class;
        if (out_custom_data_class != NULL)
            *out_custom_data_class = _custom_data_class;
        if (out_device_id != NULL)
            *out_device_id = _device_id;
        if (out_firmware_info != NULL)
            *out_firmware_info = _firmware_info;
        if (out_hardware_info != NULL)
            *out_hardware_info = _hardware_info;
    } else {
        g_free (_lte_band_class);
        g_free (_nr_band_class);
        g_free (_custom_data_class);
        g_free (_device_id);
        g_free (_firmware_info);
        g_free (_hardware_info);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_device_caps_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  DeviceType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DEVICE_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_device_type_get_string ((MbimDeviceType)tmp));
#elif defined __MBIM_DEVICE_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_device_type_build_string_from_mask ((MbimDeviceType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CellularClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CELLULAR_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_cellular_class_get_string ((MbimCellularClass)tmp));
#elif defined __MBIM_CELLULAR_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_cellular_class_build_string_from_mask ((MbimCellularClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  VoiceClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_VOICE_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_voice_class_get_string ((MbimVoiceClass)tmp));
#elif defined __MBIM_VOICE_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_voice_class_build_string_from_mask ((MbimVoiceClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SimClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_SIM_CLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_sim_class_get_string ((MbimSimClass)tmp));
#elif defined __MBIM_SIM_CLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sim_class_build_string_from_mask ((MbimSimClass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DataClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_CLASS_V3_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_class_v3_get_string ((MbimDataClassV3)tmp));
#elif defined __MBIM_DATA_CLASS_V3_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_class_v3_build_string_from_mask ((MbimDataClassV3)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SmsCaps = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_SMS_CAPS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_sms_caps_get_string ((MbimSmsCaps)tmp));
#elif defined __MBIM_SMS_CAPS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_sms_caps_build_string_from_mask ((MbimSmsCaps)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ControlCaps = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CTRL_CAPS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_ctrl_caps_get_string ((MbimCtrlCaps)tmp));
#elif defined __MBIM_CTRL_CAPS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_ctrl_caps_build_string_from_mask ((MbimCtrlCaps)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DataSubclass = ", line_prefix);
    {
        guint64 tmp;

        if (!_mbim_message_read_guint64 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
#if defined __MBIM_DATA_SUBCLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_subclass_get_string ((MbimDataSubclass)tmp));
#elif defined __MBIM_DATA_SUBCLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_subclass_build_string_from_mask ((MbimDataSubclass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxSessions = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ExecutorIndex = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  WcdmaBandClass = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LteBandClass = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  NrBandClass = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CustomDataClass = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DeviceId = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        if (show_field) {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  FirmwareInfo = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  HardwareInfo = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions V3 Modem Configuration */

MbimMessage *
mbim_message_ms_basic_connect_extensions_v3_modem_configuration_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_MODEM_CONFIGURATION,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_modem_configuration_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V3 Modem Configuration */

gboolean
mbim_message_ms_basic_connect_extensions_v3_modem_configuration_response_parse (
    const MbimMessage *message,
    MbimModemConfigurationStatus *out_configuration_status,
    gchar **out_configuration_name,
    GList **out_unnamed_ies,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_configuration_name = NULL;
    GList *_unnamed_ies = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ConfigurationStatus' variable */
    {
        if (out_configuration_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_configuration_status = (MbimModemConfigurationStatus)aux;
        }
        offset += 4;
    }

    /* Read the 'ConfigurationName' variable */
    {
        gchar *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_string (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_configuration_name != NULL)
            _configuration_name = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'UnnamedIes' variable */
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_unnamed_ies != NULL)
            _unnamed_ies = tmp;
        else
             g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_configuration_name != NULL)
            *out_configuration_name = _configuration_name;
        if (out_unnamed_ies != NULL)
            *out_unnamed_ies = _unnamed_ies;
    } else {
        g_free (_configuration_name);
        g_list_free_full (_unnamed_ies, (GDestroyNotify)mbim_tlv_unref);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_modem_configuration_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ConfigurationStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_MODEM_CONFIGURATION_STATUS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_modem_configuration_status_get_string ((MbimModemConfigurationStatus)tmp));
#elif defined __MBIM_MODEM_CONFIGURATION_STATUS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_modem_configuration_status_build_string_from_mask ((MbimModemConfigurationStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigurationName = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UnnamedIes = ", line_prefix);
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *new_line_prefix = NULL;
            GList *walker = NULL;

            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            g_string_append (str, "'[ ");
            for (walker = tmp; walker; walker = g_list_next (walker)) {
                g_autofree gchar *tlv_str = NULL;

                tlv_str = _mbim_tlv_print ((MbimTlv *)walker->data, new_line_prefix);
                g_string_append_printf (str, "%s,", tlv_str);
            }
            g_string_append_printf (str, "\n%s  ]'", line_prefix);
        }
        g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions V3 Modem Configuration */

gboolean
mbim_message_ms_basic_connect_extensions_v3_modem_configuration_notification_parse (
    const MbimMessage *message,
    MbimModemConfigurationStatus *out_modem_configuration_status,
    gchar **out_configuration_name,
    GList **out_unnamed_ies,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_configuration_name = NULL;
    GList *_unnamed_ies = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'ModemConfigurationStatus' variable */
    {
        if (out_modem_configuration_status != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_modem_configuration_status = (MbimModemConfigurationStatus)aux;
        }
        offset += 4;
    }

    /* Read the 'ConfigurationName' variable */
    {
        gchar *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_string (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_configuration_name != NULL)
            _configuration_name = tmp;
        else
             g_free (tmp);
        offset += bytes_read;
    }

    /* Read the 'UnnamedIes' variable */
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_unnamed_ies != NULL)
            _unnamed_ies = tmp;
        else
             g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_configuration_name != NULL)
            *out_configuration_name = _configuration_name;
        if (out_unnamed_ies != NULL)
            *out_unnamed_ies = _unnamed_ies;
    } else {
        g_free (_configuration_name);
        g_list_free_full (_unnamed_ies, (GDestroyNotify)mbim_tlv_unref);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_modem_configuration_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ModemConfigurationStatus = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_MODEM_CONFIGURATION_STATUS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_modem_configuration_status_get_string ((MbimModemConfigurationStatus)tmp));
#elif defined __MBIM_MODEM_CONFIGURATION_STATUS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_modem_configuration_status_build_string_from_mask ((MbimModemConfigurationStatus)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ConfigurationName = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UnnamedIes = ", line_prefix);
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *new_line_prefix = NULL;
            GList *walker = NULL;

            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            g_string_append (str, "'[ ");
            for (walker = tmp; walker; walker = g_list_next (walker)) {
                g_autofree gchar *tlv_str = NULL;

                tlv_str = _mbim_tlv_print ((MbimTlv *)walker->data, new_line_prefix);
                g_string_append_printf (str, "%s,", tlv_str);
            }
            g_string_append_printf (str, "\n%s  ]'", line_prefix);
        }
        g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions V3 Registration Parameters */

MbimMessage *
mbim_message_ms_basic_connect_extensions_v3_registration_parameters_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_REGISTRATION_PARAMETERS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_registration_parameters_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Ms Basic Connect Extensions V3 Registration Parameters */

MbimMessage *
mbim_message_ms_basic_connect_extensions_v3_registration_parameters_set_new (
    MbimMicoMode mico_mode,
    MbimDrxCycle drx_cycle,
    MbimLadnInfo ladn_info,
    MbimDefaultPduActivationHint default_pdu_activation_hint,
    gboolean re_register_if_nedeed,
    const GList *unnamed_ies,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_REGISTRATION_PARAMETERS,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, mico_mode);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, drx_cycle);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, ladn_info);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, default_pdu_activation_hint);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, re_register_if_nedeed);
    }
    {
        _mbim_message_command_builder_append_tlv_list (builder, unnamed_ies);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_registration_parameters_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MicoMode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_MICO_MODE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_mico_mode_get_string ((MbimMicoMode)tmp));
#elif defined __MBIM_MICO_MODE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_mico_mode_build_string_from_mask ((MbimMicoMode)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DrxCycle = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DRX_CYCLE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_drx_cycle_get_string ((MbimDrxCycle)tmp));
#elif defined __MBIM_DRX_CYCLE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_drx_cycle_build_string_from_mask ((MbimDrxCycle)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LadnInfo = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LADN_INFO_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_ladn_info_get_string ((MbimLadnInfo)tmp));
#elif defined __MBIM_LADN_INFO_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_ladn_info_build_string_from_mask ((MbimLadnInfo)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DefaultPduActivationHint = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DEFAULT_PDU_ACTIVATION_HINT_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_default_pdu_activation_hint_get_string ((MbimDefaultPduActivationHint)tmp));
#elif defined __MBIM_DEFAULT_PDU_ACTIVATION_HINT_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_default_pdu_activation_hint_build_string_from_mask ((MbimDefaultPduActivationHint)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ReRegisterIfNedeed = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%s'", tmp ? "true" : "false");
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UnnamedIes = ", line_prefix);
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *new_line_prefix = NULL;
            GList *walker = NULL;

            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            g_string_append (str, "'[ ");
            for (walker = tmp; walker; walker = g_list_next (walker)) {
                g_autofree gchar *tlv_str = NULL;

                tlv_str = _mbim_tlv_print ((MbimTlv *)walker->data, new_line_prefix);
                g_string_append_printf (str, "%s,", tlv_str);
            }
            g_string_append_printf (str, "\n%s  ]'", line_prefix);
        }
        g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V3 Registration Parameters */

gboolean
mbim_message_ms_basic_connect_extensions_v3_registration_parameters_response_parse (
    const MbimMessage *message,
    MbimMicoMode *out_mico_mode,
    MbimDrxCycle *out_drx_cycle,
    MbimLadnInfo *out_ladn_info,
    MbimDefaultPduActivationHint *out_default_pdu_activation_hint,
    gboolean *out_re_register_if_nedeed,
    GList **out_unnamed_ies,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    GList *_unnamed_ies = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'MicoMode' variable */
    {
        if (out_mico_mode != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_mico_mode = (MbimMicoMode)aux;
        }
        offset += 4;
    }

    /* Read the 'DrxCycle' variable */
    {
        if (out_drx_cycle != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_drx_cycle = (MbimDrxCycle)aux;
        }
        offset += 4;
    }

    /* Read the 'LadnInfo' variable */
    {
        if (out_ladn_info != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_ladn_info = (MbimLadnInfo)aux;
        }
        offset += 4;
    }

    /* Read the 'DefaultPduActivationHint' variable */
    {
        if (out_default_pdu_activation_hint != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_default_pdu_activation_hint = (MbimDefaultPduActivationHint)aux;
        }
        offset += 4;
    }

    /* Read the 'ReRegisterIfNedeed' variable */
    {
        if (out_re_register_if_nedeed != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_re_register_if_nedeed = (gboolean)aux;
        }
        offset += 4;
    }

    /* Read the 'UnnamedIes' variable */
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_unnamed_ies != NULL)
            _unnamed_ies = tmp;
        else
             g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_unnamed_ies != NULL)
            *out_unnamed_ies = _unnamed_ies;
    } else {
        g_list_free_full (_unnamed_ies, (GDestroyNotify)mbim_tlv_unref);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_registration_parameters_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MicoMode = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_MICO_MODE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_mico_mode_get_string ((MbimMicoMode)tmp));
#elif defined __MBIM_MICO_MODE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_mico_mode_build_string_from_mask ((MbimMicoMode)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DrxCycle = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DRX_CYCLE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_drx_cycle_get_string ((MbimDrxCycle)tmp));
#elif defined __MBIM_DRX_CYCLE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_drx_cycle_build_string_from_mask ((MbimDrxCycle)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LadnInfo = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LADN_INFO_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_ladn_info_get_string ((MbimLadnInfo)tmp));
#elif defined __MBIM_LADN_INFO_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_ladn_info_build_string_from_mask ((MbimLadnInfo)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  DefaultPduActivationHint = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DEFAULT_PDU_ACTIVATION_HINT_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_default_pdu_activation_hint_get_string ((MbimDefaultPduActivationHint)tmp));
#elif defined __MBIM_DEFAULT_PDU_ACTIVATION_HINT_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_default_pdu_activation_hint_build_string_from_mask ((MbimDefaultPduActivationHint)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  ReRegisterIfNedeed = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%s'", tmp ? "true" : "false");
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UnnamedIes = ", line_prefix);
    {
        GList *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv_list (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *new_line_prefix = NULL;
            GList *walker = NULL;

            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            g_string_append (str, "'[ ");
            for (walker = tmp; walker; walker = g_list_next (walker)) {
                g_autofree gchar *tlv_str = NULL;

                tlv_str = _mbim_tlv_print ((MbimTlv *)walker->data, new_line_prefix);
                g_string_append_printf (str, "%s,", tlv_str);
            }
            g_string_append_printf (str, "\n%s  ]'", line_prefix);
        }
        g_list_free_full (tmp, (GDestroyNotify)mbim_tlv_unref);
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V3 Lte Attach Info */

gboolean
mbim_message_ms_basic_connect_extensions_v3_lte_attach_info_response_parse (
    const MbimMessage *message,
    MbimLteAttachState *out_lte_attach_state,
    MbimNwError *out_nw_error,
    MbimContextIpType *out_ip_type,
    gchar **out_access_string,
    gchar **out_user_name,
    gchar **out_password,
    MbimCompression *out_compression,
    MbimAuthProtocol *out_auth_protocol,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_access_string = NULL;
    gchar *_user_name = NULL;
    gchar *_password = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'LteAttachState' variable */
    {
        if (out_lte_attach_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_lte_attach_state = (MbimLteAttachState)aux;
        }
        offset += 4;
    }

    /* Read the 'NwError' variable */
    {
        if (out_nw_error != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_nw_error = (MbimNwError)aux;
        }
        offset += 4;
    }

    /* Read the 'IpType' variable */
    {
        if (out_ip_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_ip_type = (MbimContextIpType)aux;
        }
        offset += 4;
    }

    /* Read the 'AccessString' variable */
    {
        if ((out_access_string != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_access_string, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'UserName' variable */
    {
        if ((out_user_name != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_user_name, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Password' variable */
    {
        if ((out_password != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_password, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Compression' variable */
    {
        if (out_compression != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_compression = (MbimCompression)aux;
        }
        offset += 4;
    }

    /* Read the 'AuthProtocol' variable */
    {
        if (out_auth_protocol != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_auth_protocol = (MbimAuthProtocol)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_access_string != NULL)
            *out_access_string = _access_string;
        if (out_user_name != NULL)
            *out_user_name = _user_name;
        if (out_password != NULL)
            *out_password = _password;
    } else {
        g_free (_access_string);
        g_free (_user_name);
        g_free (_password);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_lte_attach_info_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  LteAttachState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LTE_ATTACH_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_lte_attach_state_get_string ((MbimLteAttachState)tmp));
#elif defined __MBIM_LTE_ATTACH_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_lte_attach_state_build_string_from_mask ((MbimLteAttachState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  NwError = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_NW_ERROR_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_nw_error_get_string ((MbimNwError)tmp));
#elif defined __MBIM_NW_ERROR_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_nw_error_build_string_from_mask ((MbimNwError)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)tmp));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)tmp));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)tmp));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Ms Basic Connect Extensions V3 Lte Attach Info */

gboolean
mbim_message_ms_basic_connect_extensions_v3_lte_attach_info_notification_parse (
    const MbimMessage *message,
    MbimLteAttachState *out_lte_attach_state,
    MbimNwError *out_nw_error,
    MbimContextIpType *out_ip_type,
    gchar **out_access_string,
    gchar **out_user_name,
    gchar **out_password,
    MbimCompression *out_compression,
    MbimAuthProtocol *out_auth_protocol,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    gchar *_access_string = NULL;
    gchar *_user_name = NULL;
    gchar *_password = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'LteAttachState' variable */
    {
        if (out_lte_attach_state != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_lte_attach_state = (MbimLteAttachState)aux;
        }
        offset += 4;
    }

    /* Read the 'NwError' variable */
    {
        if (out_nw_error != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_nw_error = (MbimNwError)aux;
        }
        offset += 4;
    }

    /* Read the 'IpType' variable */
    {
        if (out_ip_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_ip_type = (MbimContextIpType)aux;
        }
        offset += 4;
    }

    /* Read the 'AccessString' variable */
    {
        if ((out_access_string != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_access_string, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'UserName' variable */
    {
        if ((out_user_name != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_user_name, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Password' variable */
    {
        if ((out_password != NULL) && !_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &_password, NULL, error))
            goto out;
        offset += 8;
    }

    /* Read the 'Compression' variable */
    {
        if (out_compression != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_compression = (MbimCompression)aux;
        }
        offset += 4;
    }

    /* Read the 'AuthProtocol' variable */
    {
        if (out_auth_protocol != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_auth_protocol = (MbimAuthProtocol)aux;
        }
        offset += 4;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_access_string != NULL)
            *out_access_string = _access_string;
        if (out_user_name != NULL)
            *out_user_name = _user_name;
        if (out_password != NULL)
            *out_password = _password;
    } else {
        g_free (_access_string);
        g_free (_user_name);
        g_free (_password);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_lte_attach_info_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    gboolean show_field;

    show_field = mbim_utils_get_show_personal_info ();

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  LteAttachState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_LTE_ATTACH_STATE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_lte_attach_state_get_string ((MbimLteAttachState)tmp));
#elif defined __MBIM_LTE_ATTACH_STATE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_lte_attach_state_build_string_from_mask ((MbimLteAttachState)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  NwError = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_NW_ERROR_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_nw_error_get_string ((MbimNwError)tmp));
#elif defined __MBIM_NW_ERROR_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_nw_error_build_string_from_mask ((MbimNwError)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  IpType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_CONTEXT_IP_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_context_ip_type_get_string ((MbimContextIpType)tmp));
#elif defined __MBIM_CONTEXT_IP_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_context_ip_type_build_string_from_mask ((MbimContextIpType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AccessString = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        {
            g_string_append_printf (str, "'%s'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UserName = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Password = ", line_prefix);
    {
        g_autofree gchar *tmp = NULL;

        if (!_mbim_message_read_string (message, 0, offset, MBIM_STRING_ENCODING_UTF16, &tmp, NULL, &inner_error))
            goto out;
        offset += 8;
        if (show_field) {
            g_string_append_printf (str, "'%s'", tmp);
        }
        if (!show_field)
           g_string_append (str, "'###'");
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  Compression = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_COMPRESSION_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_compression_get_string ((MbimCompression)tmp));
#elif defined __MBIM_COMPRESSION_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_compression_build_string_from_mask ((MbimCompression)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  AuthProtocol = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_AUTH_PROTOCOL_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_auth_protocol_get_string ((MbimAuthProtocol)tmp));
#elif defined __MBIM_AUTH_PROTOCOL_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_auth_protocol_build_string_from_mask ((MbimAuthProtocol)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions V3 Base Stations Info */

MbimMessage *
mbim_message_ms_basic_connect_extensions_v3_base_stations_info_query_new (
    guint32 max_gsm_count,
    guint32 max_umts_count,
    guint32 max_tdscdma_count,
    guint32 max_lte_count,
    guint32 max_cdma_count,
    guint32 max_nr_count,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_BASE_STATIONS_INFO,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);
    {
        _mbim_message_command_builder_append_guint32 (builder, max_gsm_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_umts_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_tdscdma_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_lte_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_cdma_count);
    }
    {
        _mbim_message_command_builder_append_guint32 (builder, max_nr_count);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_base_stations_info_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  MaxGsmCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxUmtsCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxTdscdmaCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxLteCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxCdmaCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  MaxNrCount = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V3 Base Stations Info */

gboolean
mbim_message_ms_basic_connect_extensions_v3_base_stations_info_response_parse (
    const MbimMessage *message,
    MbimDataClassV3 *out_system_type,
    MbimDataSubclass *out_system_sub_type,
    MbimCellInfoServingGsm **out_gsm_serving_cell,
    MbimCellInfoServingUmts **out_umts_serving_cell,
    MbimCellInfoServingTdscdma **out_tdscdma_serving_cell,
    MbimCellInfoServingLte **out_lte_serving_cell,
    guint32 *out_gsm_neighboring_cells_count,
    MbimCellInfoNeighboringGsmArray **out_gsm_neighboring_cells,
    guint32 *out_umts_neighboring_cells_count,
    MbimCellInfoNeighboringUmtsArray **out_umts_neighboring_cells,
    guint32 *out_tdscdma_neighboring_cells_count,
    MbimCellInfoNeighboringTdscdmaArray **out_tdscdma_neighboring_cells,
    guint32 *out_lte_neighboring_cells_count,
    MbimCellInfoNeighboringLteArray **out_lte_neighboring_cells,
    guint32 *out_cdma_cells_count,
    MbimCellInfoCdmaArray **out_cdma_cells,
    guint32 *out_nr_serving_cells_count,
    MbimCellInfoServingNrArray **out_nr_serving_cells,
    guint32 *out_nr_neighbor_cells_count,
    MbimCellInfoNeighboringNrArray **out_nr_neighbor_cells,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    MbimCellInfoServingGsm *_gsm_serving_cell = NULL;
    MbimCellInfoServingUmts *_umts_serving_cell = NULL;
    MbimCellInfoServingTdscdma *_tdscdma_serving_cell = NULL;
    MbimCellInfoServingLte *_lte_serving_cell = NULL;
    MbimCellInfoNeighboringGsm **_gsm_neighboring_cells = NULL;
    MbimCellInfoNeighboringUmts **_umts_neighboring_cells = NULL;
    MbimCellInfoNeighboringTdscdma **_tdscdma_neighboring_cells = NULL;
    MbimCellInfoNeighboringLte **_lte_neighboring_cells = NULL;
    MbimCellInfoCdma **_cdma_cells = NULL;
    MbimCellInfoServingNr **_nr_serving_cells = NULL;
    MbimCellInfoNeighboringNr **_nr_neighbor_cells = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'SystemType' variable */
    {
        if (out_system_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_system_type = (MbimDataClassV3)aux;
        }
        offset += 4;
    }

    /* Read the 'SystemSubType' variable */
    {
        if (out_system_sub_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_system_sub_type = (MbimDataSubclass)aux;
        }
        offset += 4;
    }

    /* Read the 'GsmServingCell' variable */
    {
        MbimCellInfoServingGsm *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_gsm_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_gsm_serving_cell != NULL)
            _gsm_serving_cell = tmp;
        else
             _mbim_cell_info_serving_gsm_free (tmp);
        offset += 8;
    }

    /* Read the 'UmtsServingCell' variable */
    {
        MbimCellInfoServingUmts *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_umts_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_umts_serving_cell != NULL)
            _umts_serving_cell = tmp;
        else
             _mbim_cell_info_serving_umts_free (tmp);
        offset += 8;
    }

    /* Read the 'TdscdmaServingCell' variable */
    {
        MbimCellInfoServingTdscdma *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_tdscdma_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_tdscdma_serving_cell != NULL)
            _tdscdma_serving_cell = tmp;
        else
             _mbim_cell_info_serving_tdscdma_free (tmp);
        offset += 8;
    }

    /* Read the 'LteServingCell' variable */
    {
        MbimCellInfoServingLte *tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_lte_ms_struct (message, offset, &tmp, error))
            goto out;
        if (out_lte_serving_cell != NULL)
            _lte_serving_cell = tmp;
        else
             _mbim_cell_info_serving_lte_free (tmp);
        offset += 8;
    }

    /* Read the 'GsmNeighboringCells' variable */
    {
        if ((out_gsm_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_gsm_ms_struct_array (message, offset, out_gsm_neighboring_cells_count, &_gsm_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'UmtsNeighboringCells' variable */
    {
        if ((out_umts_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_umts_ms_struct_array (message, offset, out_umts_neighboring_cells_count, &_umts_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'TdscdmaNeighboringCells' variable */
    {
        if ((out_tdscdma_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_tdscdma_ms_struct_array (message, offset, out_tdscdma_neighboring_cells_count, &_tdscdma_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'LteNeighboringCells' variable */
    {
        if ((out_lte_neighboring_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_lte_ms_struct_array (message, offset, out_lte_neighboring_cells_count, &_lte_neighboring_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'CdmaCells' variable */
    {
        if ((out_cdma_cells != NULL) && !_mbim_message_read_mbim_cell_info_cdma_ms_struct_array (message, offset, out_cdma_cells_count, &_cdma_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'NrServingCells' variable */
    {
        if ((out_nr_serving_cells != NULL) && !_mbim_message_read_mbim_cell_info_serving_nr_ms_struct_array (message, offset, out_nr_serving_cells_count, &_nr_serving_cells, error))
            goto out;
        offset += 8;
    }

    /* Read the 'NrNeighborCells' variable */
    {
        if ((out_nr_neighbor_cells != NULL) && !_mbim_message_read_mbim_cell_info_neighboring_nr_ms_struct_array (message, offset, out_nr_neighbor_cells_count, &_nr_neighbor_cells, error))
            goto out;
        offset += 8;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_gsm_serving_cell != NULL)
            *out_gsm_serving_cell = _gsm_serving_cell;
        if (out_umts_serving_cell != NULL)
            *out_umts_serving_cell = _umts_serving_cell;
        if (out_tdscdma_serving_cell != NULL)
            *out_tdscdma_serving_cell = _tdscdma_serving_cell;
        if (out_lte_serving_cell != NULL)
            *out_lte_serving_cell = _lte_serving_cell;
        if (out_gsm_neighboring_cells != NULL)
            *out_gsm_neighboring_cells = _gsm_neighboring_cells;
        if (out_umts_neighboring_cells != NULL)
            *out_umts_neighboring_cells = _umts_neighboring_cells;
        if (out_tdscdma_neighboring_cells != NULL)
            *out_tdscdma_neighboring_cells = _tdscdma_neighboring_cells;
        if (out_lte_neighboring_cells != NULL)
            *out_lte_neighboring_cells = _lte_neighboring_cells;
        if (out_cdma_cells != NULL)
            *out_cdma_cells = _cdma_cells;
        if (out_nr_serving_cells != NULL)
            *out_nr_serving_cells = _nr_serving_cells;
        if (out_nr_neighbor_cells != NULL)
            *out_nr_neighbor_cells = _nr_neighbor_cells;
    } else {
        mbim_cell_info_serving_gsm_free (_gsm_serving_cell);
        mbim_cell_info_serving_umts_free (_umts_serving_cell);
        mbim_cell_info_serving_tdscdma_free (_tdscdma_serving_cell);
        mbim_cell_info_serving_lte_free (_lte_serving_cell);
        mbim_cell_info_neighboring_gsm_array_free (_gsm_neighboring_cells);
        mbim_cell_info_neighboring_umts_array_free (_umts_neighboring_cells);
        mbim_cell_info_neighboring_tdscdma_array_free (_tdscdma_neighboring_cells);
        mbim_cell_info_neighboring_lte_array_free (_lte_neighboring_cells);
        mbim_cell_info_cdma_array_free (_cdma_cells);
        mbim_cell_info_serving_nr_array_free (_nr_serving_cells);
        mbim_cell_info_neighboring_nr_array_free (_nr_neighbor_cells);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_base_stations_info_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  SystemType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_CLASS_V3_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_class_v3_get_string ((MbimDataClassV3)tmp));
#elif defined __MBIM_DATA_CLASS_V3_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_class_v3_build_string_from_mask ((MbimDataClassV3)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SystemSubType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_DATA_SUBCLASS_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_data_subclass_get_string ((MbimDataSubclass)tmp));
#elif defined __MBIM_DATA_SUBCLASS_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_data_subclass_build_string_from_mask ((MbimDataSubclass)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  GsmServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingGsm) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_gsm_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_gsm_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UmtsServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingUmts) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_umts_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_umts_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TdscdmaServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingTdscdma) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_tdscdma_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_tdscdma_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LteServingCell = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingLte) tmp = NULL;

        if (!_mbim_message_read_mbim_cell_info_serving_lte_ms_struct (message, offset, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            g_autofree gchar *new_line_prefix = NULL;

            g_string_append (str, "{\n");
            new_line_prefix = g_strdup_printf ("%s    ", line_prefix);
            if (tmp) {
                g_autofree gchar *struct_str = NULL;
                struct_str = _mbim_message_print_mbim_cell_info_serving_lte_struct (tmp, new_line_prefix);
                g_string_append (str, struct_str);
            }
            g_string_append_printf (str, "%s  }", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  GsmNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringGsmArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_gsm_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_gsm_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  UmtsNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringUmtsArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_umts_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_umts_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  TdscdmaNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringTdscdmaArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_tdscdma_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_tdscdma_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  LteNeighboringCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringLteArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_lte_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_lte_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  CdmaCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoCdmaArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_cdma_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_cdma_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  NrServingCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoServingNrArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_serving_nr_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_serving_nr_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  NrNeighborCells = ", line_prefix);
    {
        g_autoptr(MbimCellInfoNeighboringNrArray) tmp = NULL;
        guint32 tmp_count = 0;

        if (!_mbim_message_read_mbim_cell_info_neighboring_nr_ms_struct_array (message, offset, &tmp_count, &tmp, &inner_error))
            goto out;
        offset += 8;
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < tmp_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_cell_info_neighboring_nr_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Ms Basic Connect Extensions V3 Wake Reason */

MbimMessage *
mbim_message_ms_basic_connect_extensions_v3_wake_reason_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_MS_BASIC_CONNECT_EXTENSIONS,
                                                 MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_WAKE_REASON,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_wake_reason_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Ms Basic Connect Extensions V3 Wake Reason */

gboolean
mbim_message_ms_basic_connect_extensions_v3_wake_reason_response_parse (
    const MbimMessage *message,
    MbimWakeType *out_wake_type,
    guint32 *out_session_id,
    MbimTlv **out_wake_tlv,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    MbimTlv *_wake_tlv = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'WakeType' variable */
    {
        if (out_wake_type != NULL) {
            guint32 aux;

            if (!_mbim_message_read_guint32 (message, offset, &aux, error))
                goto out;
            *out_wake_type = (MbimWakeType)aux;
        }
        offset += 4;
    }

    /* Read the 'SessionId' variable */
    {
        if ((out_session_id != NULL) && !_mbim_message_read_guint32 (message, offset, out_session_id, error))
            goto out;
        offset += 4;
    }

    /* Read the 'WakeTlv' variable */
    {
        MbimTlv *tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, error))
            goto out;
        if (out_wake_tlv != NULL)
            _wake_tlv = tmp;
        else
             mbim_tlv_unref (tmp);
        offset += bytes_read;
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_wake_tlv != NULL)
            *out_wake_tlv = _wake_tlv;
    } else {
        if (_wake_tlv)
            mbim_tlv_unref (_wake_tlv);
    }

    return success;
}

static gchar *
mbim_message_ms_basic_connect_extensions_v3_wake_reason_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  WakeType = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
#if defined __MBIM_WAKE_TYPE_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_wake_type_get_string ((MbimWakeType)tmp));
#elif defined __MBIM_WAKE_TYPE_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_wake_type_build_string_from_mask ((MbimWakeType)tmp);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  SessionId = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", tmp);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  WakeTlv = ", line_prefix);
    {
        g_autoptr(MbimTlv) tmp = NULL;
        guint32 bytes_read = 0;

        if (!_mbim_message_read_tlv (message, offset, &tmp, &bytes_read, &inner_error))
            goto out;
        offset += bytes_read;

        {
            g_autofree gchar *tlv_str = NULL;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s  ", line_prefix);
            tlv_str = _mbim_tlv_print (tmp, new_line_prefix);
            g_string_append_printf (str, "'%s'", tlv_str);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

typedef struct {
  gchar * (* query_cb)        (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* set_cb)          (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* response_cb)     (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* notification_cb) (const MbimMessage *message, const gchar *line_prefix, GError **error);
} GetPrintableCallbacks;

static const GetPrintableCallbacks ms_basic_connect_extensions_get_printable_callbacks[] = {
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_PCO] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_pco_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_pco_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_pco_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LTE_ATTACH_CONFIGURATION] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_lte_attach_configuration_query_get_printable,
        .set_cb = mbim_message_ms_basic_connect_extensions_lte_attach_configuration_set_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_lte_attach_configuration_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_lte_attach_configuration_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LTE_ATTACH_INFO] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_lte_attach_info_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_lte_attach_info_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_lte_attach_info_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_SYS_CAPS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_sys_caps_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_sys_caps_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_SLOT_INFO_STATUS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_slot_info_status_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_slot_info_status_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_slot_info_status_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_SLOT_MAPPINGS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_device_slot_mappings_query_get_printable,
        .set_cb = mbim_message_ms_basic_connect_extensions_device_slot_mappings_set_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_device_slot_mappings_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_CAPS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_device_caps_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_device_caps_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LOCATION_INFO_STATUS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_location_info_status_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_location_info_status_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_location_info_status_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_PROVISIONED_CONTEXTS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_provisioned_contexts_query_get_printable,
        .set_cb = mbim_message_ms_basic_connect_extensions_provisioned_contexts_set_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_provisioned_contexts_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_provisioned_contexts_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_BASE_STATIONS_INFO] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_base_stations_info_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_base_stations_info_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_RESET] = {
        .set_cb = mbim_message_ms_basic_connect_extensions_device_reset_set_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_device_reset_response_get_printable,
    },
};

gchar *
__mbim_message_ms_basic_connect_extensions_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (ms_basic_connect_extensions_get_printable_callbacks[cid].query_cb)
                            return ms_basic_connect_extensions_get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (ms_basic_connect_extensions_get_printable_callbacks[cid].set_cb)
                            return ms_basic_connect_extensions_get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_get_printable_callbacks)) {
                if (ms_basic_connect_extensions_get_printable_callbacks[cid].response_cb)
                    return ms_basic_connect_extensions_get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_get_printable_callbacks)) {
                if (ms_basic_connect_extensions_get_printable_callbacks[cid].notification_cb)
                    return ms_basic_connect_extensions_get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_UNSUPPORTED,
                 "Unsupported message");
    return NULL;
}

static const GetPrintableCallbacks ms_basic_connect_extensions_v2_get_printable_callbacks[] = {
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_VERSION] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_v2_version_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_v2_version_response_get_printable,
    },
};

gchar *
__mbim_message_ms_basic_connect_extensions_v2_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_v2_get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (ms_basic_connect_extensions_v2_get_printable_callbacks[cid].query_cb)
                            return ms_basic_connect_extensions_v2_get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (ms_basic_connect_extensions_v2_get_printable_callbacks[cid].set_cb)
                            return ms_basic_connect_extensions_v2_get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_v2_get_printable_callbacks)) {
                if (ms_basic_connect_extensions_v2_get_printable_callbacks[cid].response_cb)
                    return ms_basic_connect_extensions_v2_get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_v2_get_printable_callbacks)) {
                if (ms_basic_connect_extensions_v2_get_printable_callbacks[cid].notification_cb)
                    return ms_basic_connect_extensions_v2_get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_UNSUPPORTED,
                 "Unsupported message");
    return NULL;
}

static const GetPrintableCallbacks ms_basic_connect_extensions_v3_get_printable_callbacks[] = {
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_DEVICE_CAPS] = {
        .response_cb = mbim_message_ms_basic_connect_extensions_v3_device_caps_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_MODEM_CONFIGURATION] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_v3_modem_configuration_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_v3_modem_configuration_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_v3_modem_configuration_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_REGISTRATION_PARAMETERS] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_v3_registration_parameters_query_get_printable,
        .set_cb = mbim_message_ms_basic_connect_extensions_v3_registration_parameters_set_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_v3_registration_parameters_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_LTE_ATTACH_INFO] = {
        .response_cb = mbim_message_ms_basic_connect_extensions_v3_lte_attach_info_response_get_printable,
        .notification_cb = mbim_message_ms_basic_connect_extensions_v3_lte_attach_info_notification_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_BASE_STATIONS_INFO] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_v3_base_stations_info_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_v3_base_stations_info_response_get_printable,
    },
    [MBIM_CID_MS_BASIC_CONNECT_EXTENSIONS_WAKE_REASON] = {
        .query_cb = mbim_message_ms_basic_connect_extensions_v3_wake_reason_query_get_printable,
        .response_cb = mbim_message_ms_basic_connect_extensions_v3_wake_reason_response_get_printable,
    },
};

gchar *
__mbim_message_ms_basic_connect_extensions_v3_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_v3_get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (ms_basic_connect_extensions_v3_get_printable_callbacks[cid].query_cb)
                            return ms_basic_connect_extensions_v3_get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (ms_basic_connect_extensions_v3_get_printable_callbacks[cid].set_cb)
                            return ms_basic_connect_extensions_v3_get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_v3_get_printable_callbacks)) {
                if (ms_basic_connect_extensions_v3_get_printable_callbacks[cid].response_cb)
                    return ms_basic_connect_extensions_v3_get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (ms_basic_connect_extensions_v3_get_printable_callbacks)) {
                if (ms_basic_connect_extensions_v3_get_printable_callbacks[cid].notification_cb)
                    return ms_basic_connect_extensions_v3_get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_UNSUPPORTED,
                 "Unsupported message");
    return NULL;
}
