/* Generated by wayland-scanner 1.22.0 */

#ifndef AGL_SHELL_SERVER_PROTOCOL_H
#define AGL_SHELL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_agl_shell The agl_shell protocol
 * @section page_ifaces_agl_shell Interfaces
 * - @subpage page_iface_agl_shell - user interface for Automotive Grade Linux platform
 * - @subpage page_iface_agl_shell_ext - extended user interface for Automotive Grade Linux platform
 * @section page_copyright_agl_shell Copyright
 * <pre>
 *
 * Copyright © 2019, 2022 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct agl_shell;
struct agl_shell_ext;
struct wl_output;
struct wl_surface;

#ifndef AGL_SHELL_INTERFACE
#define AGL_SHELL_INTERFACE
/**
 * @page page_iface_agl_shell agl_shell
 * @section page_iface_agl_shell_desc Description
 *
 * Starting with version 2 of the protocol, the client is required to wait
 * for the 'bound_ok' or 'bound_fail' events in order to proceed further.
 *
 * In case the client gets a 'bound_fail' event then it should consider that
 * there's another client already bound to the agl_shell protocol.
 * A client that receives a 'bound_ok' event should consider that there's
 * no other client already bound to the interface and can proceed further.
 *
 * If the client uses an older version of the protocol it will receive
 * automatically an error and the compositor will terminate the connection,
 * if there's another client already bound the interface.
 *
 * If the client receives the 'bound_fail' event and attempts to use the
 * interface further it will receive an error and the compositor will
 * terminate the connection. After the 'bound_fail' event was received the
 * client should call the destructor, which has been added with version 2
 * of the protocol. The client is free to try at a later point in time to
 * see if it will receive the 'bound_ok' event, but there's no explicit way
 * of finding out when that event will be delivered.
 * It is assumed that it can infer that information through other
 * means/other channels.
 * @section page_iface_agl_shell_api API
 * See @ref iface_agl_shell.
 */
/**
 * @defgroup iface_agl_shell The agl_shell interface
 *
 * Starting with version 2 of the protocol, the client is required to wait
 * for the 'bound_ok' or 'bound_fail' events in order to proceed further.
 *
 * In case the client gets a 'bound_fail' event then it should consider that
 * there's another client already bound to the agl_shell protocol.
 * A client that receives a 'bound_ok' event should consider that there's
 * no other client already bound to the interface and can proceed further.
 *
 * If the client uses an older version of the protocol it will receive
 * automatically an error and the compositor will terminate the connection,
 * if there's another client already bound the interface.
 *
 * If the client receives the 'bound_fail' event and attempts to use the
 * interface further it will receive an error and the compositor will
 * terminate the connection. After the 'bound_fail' event was received the
 * client should call the destructor, which has been added with version 2
 * of the protocol. The client is free to try at a later point in time to
 * see if it will receive the 'bound_ok' event, but there's no explicit way
 * of finding out when that event will be delivered.
 * It is assumed that it can infer that information through other
 * means/other channels.
 */
extern const struct wl_interface agl_shell_interface;
#endif
#ifndef AGL_SHELL_EXT_INTERFACE
#define AGL_SHELL_EXT_INTERFACE
/**
 * @page page_iface_agl_shell_ext agl_shell_ext
 * @section page_iface_agl_shell_ext_desc Description
 *
 * This interface allows another client bind to the agl_shell interface,
 * while there's another shell client already present.
 *
 * The client should first bind to this interface and then inform the
 * compositor with the 'doas_shell_client' request and it wants to bind to
 * the agl_shell interface. The client is still expected, if using a new
 * version of the agl_shell interface, to wait for the 'bound_ok' and
 * 'bound_fail' events before issueing any other requests/events.
 *
 * Note that this interface has its limitations, and the compositor would
 * still refuse the act for 'set_panel' or 'set_background' requests
 * of the agl_shell interface if there's already a client that used them.
 *
 * Any other requests or events should be delievered and handled as it would
 * a client bound to the agl_shell interface.
 * @section page_iface_agl_shell_ext_api API
 * See @ref iface_agl_shell_ext.
 */
/**
 * @defgroup iface_agl_shell_ext The agl_shell_ext interface
 *
 * This interface allows another client bind to the agl_shell interface,
 * while there's another shell client already present.
 *
 * The client should first bind to this interface and then inform the
 * compositor with the 'doas_shell_client' request and it wants to bind to
 * the agl_shell interface. The client is still expected, if using a new
 * version of the agl_shell interface, to wait for the 'bound_ok' and
 * 'bound_fail' events before issueing any other requests/events.
 *
 * Note that this interface has its limitations, and the compositor would
 * still refuse the act for 'set_panel' or 'set_background' requests
 * of the agl_shell interface if there's already a client that used them.
 *
 * Any other requests or events should be delievered and handled as it would
 * a client bound to the agl_shell interface.
 */
extern const struct wl_interface agl_shell_ext_interface;
#endif

#ifndef AGL_SHELL_ERROR_ENUM
#define AGL_SHELL_ERROR_ENUM
enum agl_shell_error {
	AGL_SHELL_ERROR_INVALID_ARGUMENT = 0,
	AGL_SHELL_ERROR_BACKGROUND_EXISTS = 1,
	AGL_SHELL_ERROR_PANEL_EXISTS = 2,
};
#endif /* AGL_SHELL_ERROR_ENUM */

#ifndef AGL_SHELL_EDGE_ENUM
#define AGL_SHELL_EDGE_ENUM
enum agl_shell_edge {
	AGL_SHELL_EDGE_TOP = 0,
	AGL_SHELL_EDGE_BOTTOM = 1,
	AGL_SHELL_EDGE_LEFT = 2,
	AGL_SHELL_EDGE_RIGHT = 3,
};
#endif /* AGL_SHELL_EDGE_ENUM */

#ifndef AGL_SHELL_APP_STATE_ENUM
#define AGL_SHELL_APP_STATE_ENUM
enum agl_shell_app_state {
	AGL_SHELL_APP_STATE_STARTED = 0,
	AGL_SHELL_APP_STATE_TERMINATED = 1,
	AGL_SHELL_APP_STATE_ACTIVATED = 2,
	AGL_SHELL_APP_STATE_DEACTIVATED = 3,
};
#endif /* AGL_SHELL_APP_STATE_ENUM */

#ifndef AGL_SHELL_TILE_ORIENTATION_ENUM
#define AGL_SHELL_TILE_ORIENTATION_ENUM
enum agl_shell_tile_orientation {
	AGL_SHELL_TILE_ORIENTATION_NONE = 0,
	AGL_SHELL_TILE_ORIENTATION_LEFT = 1,
	AGL_SHELL_TILE_ORIENTATION_RIGHT = 2,
	AGL_SHELL_TILE_ORIENTATION_TOP = 3,
	AGL_SHELL_TILE_ORIENTATION_BOTTOM = 4,
};
#endif /* AGL_SHELL_TILE_ORIENTATION_ENUM */

/**
 * @ingroup iface_agl_shell
 * @struct agl_shell_interface
 */
struct agl_shell_interface {
	/**
	 * client is ready to be shown
	 *
	 * Tell the server that this client is ready to be shown. The
	 * server will delay presentation during start-up until all shell
	 * clients are ready to be shown, and will display a black screen
	 * instead. This gives the client an opportunity to set up and
	 * configure several surfaces into a coherent interface.
	 *
	 * The client that binds to this interface must send this request,
	 * otherwise they may stall the compositor unnecessarily.
	 *
	 * If this request is called after the compositor has already
	 * finished start-up, no operation is performed.
	 */
	void (*ready)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * set surface as output's background
	 *
	 * Set the surface to act as the background of an output. After
	 * this request, the server will immediately send a configure event
	 * with the dimensions the client should use to cover the entire
	 * output.
	 *
	 * The surface must have a "desktop" surface role, as supported by
	 * libweston-desktop.
	 *
	 * Only a single surface may be the background for any output. If a
	 * background surface already exists, a protocol error is raised.
	 */
	void (*set_background)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *surface,
			       struct wl_resource *output);
	/**
	 * set surface as panel
	 *
	 * Set the surface to act as a panel of an output. The 'edge'
	 * argument says what edge of the output the surface will be
	 * anchored to. After this request, the server will send a
	 * configure event with the corresponding width/height that the
	 * client should use, and 0 for the other dimension. E.g. if the
	 * edge is 'top', the width will be the output's width, and the
	 * height will be 0.
	 *
	 * The surface must have a "desktop" surface role, as supported by
	 * libweston-desktop.
	 *
	 * The compositor will take the panel's window geometry into
	 * account when positioning other windows, so the panels are not
	 * covered.
	 *
	 * XXX: What happens if e.g. both top and left are used at the same
	 * time? Who gets to have the corner?
	 *
	 * Only a single surface may be the panel for an output's edge. If
	 * a surface already exists on an edge, a protocol error is raised.
	 */
	void (*set_panel)(struct wl_client *client,
			  struct wl_resource *resource,
			  struct wl_resource *surface,
			  struct wl_resource *output,
			  uint32_t edge);
	/**
	 * make client current window
	 *
	 * Ask the compositor to make a toplevel to become the
	 * current/focused window for window management purposes.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 *
	 * If multiple toplevels have the same app_id, the result is
	 * unspecified.
	 *
	 * XXX: Do we need feedback to say it didn't work? (e.g. client
	 * does not exist)
	 */
	void (*activate_app)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *app_id,
			     struct wl_resource *output);
	/**
	 * destroys the factory object
	 *
	 * 
	 * @since 2
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * sets a specific region to activate
	 *
	 * A hint for the compositor to use a custom area, rather than
	 * inferring the activation area. If any panels are used the
	 * compositor computes the activation area by subtracting the
	 * panels geometry area. If no panels are used then the entire
	 * output is being used. This request changes that as to hint the
	 * compositor to use the supplied rectangle and ignore any
	 * potential panels that might been set-up previously.
	 *
	 * In order for this request to take effect it will need to happen
	 * before the 'ready' request in order for the compositor to make
	 * use of it. Note that any 'set_panel' request be will not be
	 * honored, if this request has been called.
	 *
	 * The x and y coordinates use the top-left corner as the origin.
	 * The rectangle area shouldn't exceed the output area, while an
	 * area smaller than the output, would basically result in showing
	 * up the background surface.
	 * @param x x position of rectangle
	 * @param y y position of rectangle
	 * @param width width of rectangle
	 * @param height height of rectangle
	 * @since 4
	 */
	void (*set_activate_region)(struct wl_client *client,
				    struct wl_resource *resource,
				    struct wl_resource *output,
				    int32_t x,
				    int32_t y,
				    int32_t width,
				    int32_t height);
	/**
	 * de-activate/hide window identified by app_id
	 *
	 * Ask the compositor to hide the toplevel window for window
	 * management purposes. Depending on the window role, this request
	 * will either display the previously active window (or the
	 * background in case there's no previously active surface) or
	 * temporarily (or until a 'activate_app' is called upon) hide the
	 * surface.
	 *
	 * All the surfaces are identifiable by using the app_id, and no
	 * actions are taken in case the app_id is not/was not present.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @since 5
	 */
	void (*deactivate_app)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *app_id);
	/**
	 * set the window identified by app_id as float
	 *
	 * Makes the application identified by app_id as floating. If the
	 * application's window is already mapped, in a maximized, normal
	 * state, it would transition to the float state.
	 *
	 * For applications that want to modify their own state, this
	 * request must be done before the initial surface commit in order
	 * to take effect.
	 *
	 * If the application is already in floating state, this request
	 * wouldn't do anything.
	 *
	 * There's no persistence of this request, once the application
	 * terminated you'll to issue this request again for that
	 * particular app_id.
	 *
	 * The x, and y values would be initial position of the window
	 * where the window surface will be placed.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @param x x position
	 * @param y y position
	 * @since 6
	 */
	void (*set_app_float)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *app_id,
			      int32_t x,
			      int32_t y);
	/**
	 * set the window identified by app_id as normally started
	 *
	 * Returns the application identified by app_id as it was in the
	 * normal state. This is useful to come back from other states to
	 * the maximized state, the normal state applications are started.
	 * @since 6
	 */
	void (*set_app_normal)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *app_id);
	/**
	 * 
	 *
	 * Makes the application identified by app_id as fullscreen. If
	 * the application's window is already mapped, in a maximized,
	 * normal state, it would transition to the fullscreen state.
	 *
	 * For applications that want to modify their own state, this
	 * request must be done before the initial surface commit in order
	 * to take effect.
	 *
	 * If the application is already in fullscreen state, this request
	 * wouldn't do anything.
	 *
	 * There's no persistence of this request, once the application
	 * terminated you'll to issue this request again for that
	 * particular app_id.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @since 7
	 */
	void (*set_app_fullscreen)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *app_id);
	/**
	 * assign an application to a particular output
	 *
	 * this would allow the compositor to place an application on a
	 * particular output, if that output is indeed available. this can
	 * happen before application is started which would make the
	 * application start on that particular output. if the application
	 * is already started it would move the application to that output.
	 *
	 * there's no persistence of this request, once the application
	 * terminated you'll need to issue this request again for that
	 * particular app_id.
	 *
	 * see xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @since 8
	 */
	void (*set_app_output)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *app_id,
			       struct wl_resource *output);
	/**
	 * move window to a specific position
	 *
	 * Clients can inform the compositor to position a floating type
	 * of window at the specific location, pointed by x and y value. If
	 * the window is not a floating type, the request will be
	 * discarded. Note that positioning doesn't take output into
	 * consideration nor does orientation of the outpus. It is expected
	 * that the client knows already where the position is localed in
	 * global coordonate space. If the window doesn't exist the
	 * compositor will ignore the request. For this request to function
	 * properly the window would first to be set as floating and then
	 * it can be moved using this request.
	 *
	 * see xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @since 9
	 */
	void (*set_app_position)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *app_id,
				 int32_t x,
				 int32_t y);
	/**
	 * scale window to a specific rectangle
	 *
	 * Clients can inform the compositor to scale a floating type of
	 * window to the values specified in width and height. If the
	 * window is not a floating type, the request will be discarded. If
	 * the window doesn't exist the compositor will ignore the request.
	 * For this request to function properly the window would first to
	 * be set as floating and then it can be moved using this request.
	 *
	 * see xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @since 10
	 */
	void (*set_app_scale)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *app_id,
			      int32_t width,
			      int32_t height);
	/**
	 * set the application with a split orientation
	 *
	 * This requests asks the compositor to change the application
	 * from the original mode (whatever that might be) to a split,
	 * tiled orientation mode defined in the tile orientation enum.
	 * Clients need to implement resizing (to handle xdg-shell
	 * configure events) for this to work correctly.
	 *
	 * This request only handles a single level of tiling for practical
	 * reasons: to keep implementation simple and straight forward. The
	 * compositor will ignore requests if there are already two windows
	 * present. The client can verify this request succeed by checking
	 * the xdg-shell configure event and with it, the states sent by
	 * the compositor.
	 *
	 * If there's no app_id with the supplied name, the compositor will
	 * add the app to a pending list in order to be applied when an
	 * application gets started, or if the application sets its
	 * application after the initial wl_surface.commit request.
	 *
	 * Applications can use this approach if they want to be started in
	 * a tiled orientation position, before creating the xdg-shell
	 * toplevel role.
	 *
	 * A none orientation type would make the window go back to the
	 * original maximized mode. If two windows are side by side,
	 * returning one of them back the original mode would mean the
	 * other one will be made hidden and the one doing the request for
	 * the none orientation will become the currently active window. A
	 * further activation, using activate_app request for the other
	 * window would make that one active.
	 *
	 * Closing the window in the tiled orientation state implies that
	 * either the background surface will displayed, or in case there
	 * was another applications being shown at that time, will make
	 * that application be returned to the original, maximized state.
	 *
	 * The tiled orientation could be applied independently of each
	 * other, such that a client can transition from one tiled
	 * orientation to another. Note that any other window already
	 * present would literally take the opposite orientation with the
	 * one currently being changed. So tiled orientation modification
	 * automatically implies a tile orientation for any other
	 * application already present/active at that time.
	 *
	 * In case there's already a client active at that time, it will be
	 * attributed automatically the opposite tiled orientation, such
	 * that two concurrent applications can be displayed at the same
	 * time.
	 *
	 * The orientation tiles can not be combined, and only state at a
	 * time can be active. Only horizontal and vertical tiling is
	 * possible. A horizontal and vertical tile orientation
	 * simultaneously is not possible.
	 *
	 * Input focus is being delivered to the last started/activated
	 * window, such that users can cycle between that one or the other,
	 * assumes there's another window in the first place.
	 *
	 * A width size can also be specified for the split window. Note
	 * that this width can't exceed the output width value, or the
	 * compositor can choose to ignore this value.
	 *
	 * Making the split window sticky would inform the compositor that
	 * the window should always be active when switching or when
	 * activating between other windows. This would allow navigating,
	 * starting and activating other windows while keeping the current
	 * window always in a split state.
	 *
	 * See xdg_toplevel.set_app_id from the xdg-shell protocol for a
	 * description of app_id.
	 * @param width width of the window being split
	 * @param sticky make the split window stiky
	 * @since 11
	 */
	void (*set_app_split)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *app_id,
			      uint32_t orientation,
			      int32_t width,
			      int32_t sticky,
			      struct wl_resource *output);
};

#define AGL_SHELL_BOUND_OK 0
#define AGL_SHELL_BOUND_FAIL 1
#define AGL_SHELL_APP_STATE 2
#define AGL_SHELL_APP_ON_OUTPUT 3

/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_BOUND_OK_SINCE_VERSION 2
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_BOUND_FAIL_SINCE_VERSION 2
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_APP_STATE_SINCE_VERSION 3
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_APP_ON_OUTPUT_SINCE_VERSION 8

/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_READY_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_BACKGROUND_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_ACTIVATE_APP_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_ACTIVATE_REGION_SINCE_VERSION 4
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_DEACTIVATE_APP_SINCE_VERSION 5
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_FLOAT_SINCE_VERSION 6
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_NORMAL_SINCE_VERSION 6
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_FULLSCREEN_SINCE_VERSION 7
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_OUTPUT_SINCE_VERSION 8
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_POSITION_SINCE_VERSION 9
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_SCALE_SINCE_VERSION 10
/**
 * @ingroup iface_agl_shell
 */
#define AGL_SHELL_SET_APP_SPLIT_SINCE_VERSION 11

/**
 * @ingroup iface_agl_shell
 * Sends an bound_ok event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_send_bound_ok(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, AGL_SHELL_BOUND_OK);
}

/**
 * @ingroup iface_agl_shell
 * Sends an bound_fail event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_send_bound_fail(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, AGL_SHELL_BOUND_FAIL);
}

/**
 * @ingroup iface_agl_shell
 * Sends an app_state event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_send_app_state(struct wl_resource *resource_, const char *app_id, uint32_t state)
{
	wl_resource_post_event(resource_, AGL_SHELL_APP_STATE, app_id, state);
}

/**
 * @ingroup iface_agl_shell
 * Sends an app_on_output event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_send_app_on_output(struct wl_resource *resource_, const char *app_id, const char *output_name)
{
	wl_resource_post_event(resource_, AGL_SHELL_APP_ON_OUTPUT, app_id, output_name);
}

#ifndef AGL_SHELL_EXT_DOAS_SHELL_CLIENT_STATUS_ENUM
#define AGL_SHELL_EXT_DOAS_SHELL_CLIENT_STATUS_ENUM
enum agl_shell_ext_doas_shell_client_status {
	AGL_SHELL_EXT_DOAS_SHELL_CLIENT_STATUS_SUCCESS = 0,
	AGL_SHELL_EXT_DOAS_SHELL_CLIENT_STATUS_FAILED = 1,
};
#endif /* AGL_SHELL_EXT_DOAS_SHELL_CLIENT_STATUS_ENUM */

/**
 * @ingroup iface_agl_shell_ext
 * @struct agl_shell_ext_interface
 */
struct agl_shell_ext_interface {
	/**
	 * destroys the factory object
	 *
	 * Call the destructor once you're ready with agl_shell_ext
	 * interface. This would reset the state and would make any
	 * requests made on the agl_shell interface be terminated. The
	 * client would need to bind again the agl_shell_ext and issue a
	 * 'doas_shell_client' request.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * Informs the compositor it wants to bind to the       agl_shell interface
	 *
	 * Prior to binding to agl_shell interface, this request would
	 * inform the compositor that it wants to gain access the agl_shell
	 * interface. The client is expected to wait for
	 * 'doas_shell_client_done' event and check for a successful status
	 * before going further with binding to the agl_shell interface.
	 */
	void (*doas_shell_client)(struct wl_client *client,
				  struct wl_resource *resource);
};

#define AGL_SHELL_EXT_DOAS_DONE 0

/**
 * @ingroup iface_agl_shell_ext
 */
#define AGL_SHELL_EXT_DOAS_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_agl_shell_ext
 */
#define AGL_SHELL_EXT_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_agl_shell_ext
 */
#define AGL_SHELL_EXT_DOAS_SHELL_CLIENT_SINCE_VERSION 1

/**
 * @ingroup iface_agl_shell_ext
 * Sends an doas_done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
agl_shell_ext_send_doas_done(struct wl_resource *resource_, uint32_t status)
{
	wl_resource_post_event(resource_, AGL_SHELL_EXT_DOAS_DONE, status);
}

#ifdef  __cplusplus
}
#endif

#endif
