// GENERATED CODE - DO NOT EDIT

// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'G'.
class PartG {
  /// Applies the GFS Didot font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/GFS+Didot
  static TextStyle gfsDidot({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26a132c2c19d36cd8846b819e1e979a5a8836d9714d864f5cadd1dc01081ea05',
        163848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GFSDidot',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the GFS Didot font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/GFS+Didot
  static TextTheme gfsDidotTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gfsDidot(textStyle: textTheme.displayLarge),
      displayMedium: gfsDidot(textStyle: textTheme.displayMedium),
      displaySmall: gfsDidot(textStyle: textTheme.displaySmall),
      headlineLarge: gfsDidot(textStyle: textTheme.headlineLarge),
      headlineMedium: gfsDidot(textStyle: textTheme.headlineMedium),
      headlineSmall: gfsDidot(textStyle: textTheme.headlineSmall),
      titleLarge: gfsDidot(textStyle: textTheme.titleLarge),
      titleMedium: gfsDidot(textStyle: textTheme.titleMedium),
      titleSmall: gfsDidot(textStyle: textTheme.titleSmall),
      bodyLarge: gfsDidot(textStyle: textTheme.bodyLarge),
      bodyMedium: gfsDidot(textStyle: textTheme.bodyMedium),
      bodySmall: gfsDidot(textStyle: textTheme.bodySmall),
      labelLarge: gfsDidot(textStyle: textTheme.labelLarge),
      labelMedium: gfsDidot(textStyle: textTheme.labelMedium),
      labelSmall: gfsDidot(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the GFS Neohellenic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/GFS+Neohellenic
  static TextStyle gfsNeohellenic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51ef8ebba4615300a1344d2e6eb9d03e72cd59657ec5dd2ad2a7a3ff9692d85f',
        176532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1d37ecc8bde6698ada5a81c147976a733f697d7e9bcd8de55affd556fd3515c7',
        157096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '656044652163515deaced16a281d1bef468d9f8e50f108306d4d7607c08f1b92',
        142840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fd025396d1711c7d766978f03b4daf801357e42f723ed3cd645496a82024a302',
        156680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GFSNeohellenic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the GFS Neohellenic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/GFS+Neohellenic
  static TextTheme gfsNeohellenicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gfsNeohellenic(textStyle: textTheme.displayLarge),
      displayMedium: gfsNeohellenic(textStyle: textTheme.displayMedium),
      displaySmall: gfsNeohellenic(textStyle: textTheme.displaySmall),
      headlineLarge: gfsNeohellenic(textStyle: textTheme.headlineLarge),
      headlineMedium: gfsNeohellenic(textStyle: textTheme.headlineMedium),
      headlineSmall: gfsNeohellenic(textStyle: textTheme.headlineSmall),
      titleLarge: gfsNeohellenic(textStyle: textTheme.titleLarge),
      titleMedium: gfsNeohellenic(textStyle: textTheme.titleMedium),
      titleSmall: gfsNeohellenic(textStyle: textTheme.titleSmall),
      bodyLarge: gfsNeohellenic(textStyle: textTheme.bodyLarge),
      bodyMedium: gfsNeohellenic(textStyle: textTheme.bodyMedium),
      bodySmall: gfsNeohellenic(textStyle: textTheme.bodySmall),
      labelLarge: gfsNeohellenic(textStyle: textTheme.labelLarge),
      labelMedium: gfsNeohellenic(textStyle: textTheme.labelMedium),
      labelSmall: gfsNeohellenic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ga Maamli font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ga+Maamli
  static TextStyle gaMaamli({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '039c6651538a098d08f13c348a54abef64ed76df3c4b5ecc687738fa22eb570a',
        277812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GaMaamli',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ga Maamli font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ga+Maamli
  static TextTheme gaMaamliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gaMaamli(textStyle: textTheme.displayLarge),
      displayMedium: gaMaamli(textStyle: textTheme.displayMedium),
      displaySmall: gaMaamli(textStyle: textTheme.displaySmall),
      headlineLarge: gaMaamli(textStyle: textTheme.headlineLarge),
      headlineMedium: gaMaamli(textStyle: textTheme.headlineMedium),
      headlineSmall: gaMaamli(textStyle: textTheme.headlineSmall),
      titleLarge: gaMaamli(textStyle: textTheme.titleLarge),
      titleMedium: gaMaamli(textStyle: textTheme.titleMedium),
      titleSmall: gaMaamli(textStyle: textTheme.titleSmall),
      bodyLarge: gaMaamli(textStyle: textTheme.bodyLarge),
      bodyMedium: gaMaamli(textStyle: textTheme.bodyMedium),
      bodySmall: gaMaamli(textStyle: textTheme.bodySmall),
      labelLarge: gaMaamli(textStyle: textTheme.labelLarge),
      labelMedium: gaMaamli(textStyle: textTheme.labelMedium),
      labelSmall: gaMaamli(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gabarito font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gabarito
  static TextStyle gabarito({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00bb7908a6561506f8ea24e72ed15a3686d3c9ba5ad75e04b920ff3f46eea0bb',
        100308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18ff7c69bea3ab359c8102b897ed1030c15febd5eaed1e1b924a759004fa433a',
        100664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b8d2212a360e0e7ff8a46768c159ec89c98690344dabc1b23f33999ee7ee14d',
        100656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efe5a216ede46e96501d9d5ca5087d7546f91e9a72f882082c0a0fcb7a5898fa',
        100532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b08bd09ac5e415dd3754929d32ac13ff8e2a6a4b0834094d91b2dfa288e25a25',
        100636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9dc1d2fbf744fdd87a41816c44732d23cfa8fb299f244e9f95b62c0b37b65d2',
        100272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gabarito',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gabarito font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gabarito
  static TextTheme gabaritoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gabarito(textStyle: textTheme.displayLarge),
      displayMedium: gabarito(textStyle: textTheme.displayMedium),
      displaySmall: gabarito(textStyle: textTheme.displaySmall),
      headlineLarge: gabarito(textStyle: textTheme.headlineLarge),
      headlineMedium: gabarito(textStyle: textTheme.headlineMedium),
      headlineSmall: gabarito(textStyle: textTheme.headlineSmall),
      titleLarge: gabarito(textStyle: textTheme.titleLarge),
      titleMedium: gabarito(textStyle: textTheme.titleMedium),
      titleSmall: gabarito(textStyle: textTheme.titleSmall),
      bodyLarge: gabarito(textStyle: textTheme.bodyLarge),
      bodyMedium: gabarito(textStyle: textTheme.bodyMedium),
      bodySmall: gabarito(textStyle: textTheme.bodySmall),
      labelLarge: gabarito(textStyle: textTheme.labelLarge),
      labelMedium: gabarito(textStyle: textTheme.labelMedium),
      labelSmall: gabarito(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gabriela font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gabriela
  static TextStyle gabriela({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92de66a9b820e83635ea00711c72480c451a998d325ac0c92e2a7e721c355a49',
        67780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gabriela',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gabriela font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gabriela
  static TextTheme gabrielaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gabriela(textStyle: textTheme.displayLarge),
      displayMedium: gabriela(textStyle: textTheme.displayMedium),
      displaySmall: gabriela(textStyle: textTheme.displaySmall),
      headlineLarge: gabriela(textStyle: textTheme.headlineLarge),
      headlineMedium: gabriela(textStyle: textTheme.headlineMedium),
      headlineSmall: gabriela(textStyle: textTheme.headlineSmall),
      titleLarge: gabriela(textStyle: textTheme.titleLarge),
      titleMedium: gabriela(textStyle: textTheme.titleMedium),
      titleSmall: gabriela(textStyle: textTheme.titleSmall),
      bodyLarge: gabriela(textStyle: textTheme.bodyLarge),
      bodyMedium: gabriela(textStyle: textTheme.bodyMedium),
      bodySmall: gabriela(textStyle: textTheme.bodySmall),
      labelLarge: gabriela(textStyle: textTheme.labelLarge),
      labelMedium: gabriela(textStyle: textTheme.labelMedium),
      labelSmall: gabriela(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gaegu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gaegu
  static TextStyle gaegu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa2586e5470c1e50ab9db4e5e45dc6163d4a283db19b96c7eb78410a272d0c3e',
        1665516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da0cb231768609aff6ce7e6cce0c05e7b3003f4cd6b1cb6ff0bd46c11daea268',
        1687664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b98eceffac8fecede0013304ef7e00761d570a0209a54769048573bcfceee1f6',
        1588556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gaegu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gaegu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gaegu
  static TextTheme gaeguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gaegu(textStyle: textTheme.displayLarge),
      displayMedium: gaegu(textStyle: textTheme.displayMedium),
      displaySmall: gaegu(textStyle: textTheme.displaySmall),
      headlineLarge: gaegu(textStyle: textTheme.headlineLarge),
      headlineMedium: gaegu(textStyle: textTheme.headlineMedium),
      headlineSmall: gaegu(textStyle: textTheme.headlineSmall),
      titleLarge: gaegu(textStyle: textTheme.titleLarge),
      titleMedium: gaegu(textStyle: textTheme.titleMedium),
      titleSmall: gaegu(textStyle: textTheme.titleSmall),
      bodyLarge: gaegu(textStyle: textTheme.bodyLarge),
      bodyMedium: gaegu(textStyle: textTheme.bodyMedium),
      bodySmall: gaegu(textStyle: textTheme.bodySmall),
      labelLarge: gaegu(textStyle: textTheme.labelLarge),
      labelMedium: gaegu(textStyle: textTheme.labelMedium),
      labelSmall: gaegu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gafata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gafata
  static TextStyle gafata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2130ba4f123fc0a44d8a6e7058c60425acb34fb2eb16102d8273c766340f9494',
        35284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gafata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gafata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gafata
  static TextTheme gafataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gafata(textStyle: textTheme.displayLarge),
      displayMedium: gafata(textStyle: textTheme.displayMedium),
      displaySmall: gafata(textStyle: textTheme.displaySmall),
      headlineLarge: gafata(textStyle: textTheme.headlineLarge),
      headlineMedium: gafata(textStyle: textTheme.headlineMedium),
      headlineSmall: gafata(textStyle: textTheme.headlineSmall),
      titleLarge: gafata(textStyle: textTheme.titleLarge),
      titleMedium: gafata(textStyle: textTheme.titleMedium),
      titleSmall: gafata(textStyle: textTheme.titleSmall),
      bodyLarge: gafata(textStyle: textTheme.bodyLarge),
      bodyMedium: gafata(textStyle: textTheme.bodyMedium),
      bodySmall: gafata(textStyle: textTheme.bodySmall),
      labelLarge: gafata(textStyle: textTheme.labelLarge),
      labelMedium: gafata(textStyle: textTheme.labelMedium),
      labelSmall: gafata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gajraj One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gajraj+One
  static TextStyle gajrajOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2f85fd98fca5765df195edde59d7e8efd7c5be77e4bbfcc58e01aca981171f7',
        148728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GajrajOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gajraj One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gajraj+One
  static TextTheme gajrajOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gajrajOne(textStyle: textTheme.displayLarge),
      displayMedium: gajrajOne(textStyle: textTheme.displayMedium),
      displaySmall: gajrajOne(textStyle: textTheme.displaySmall),
      headlineLarge: gajrajOne(textStyle: textTheme.headlineLarge),
      headlineMedium: gajrajOne(textStyle: textTheme.headlineMedium),
      headlineSmall: gajrajOne(textStyle: textTheme.headlineSmall),
      titleLarge: gajrajOne(textStyle: textTheme.titleLarge),
      titleMedium: gajrajOne(textStyle: textTheme.titleMedium),
      titleSmall: gajrajOne(textStyle: textTheme.titleSmall),
      bodyLarge: gajrajOne(textStyle: textTheme.bodyLarge),
      bodyMedium: gajrajOne(textStyle: textTheme.bodyMedium),
      bodySmall: gajrajOne(textStyle: textTheme.bodySmall),
      labelLarge: gajrajOne(textStyle: textTheme.labelLarge),
      labelMedium: gajrajOne(textStyle: textTheme.labelMedium),
      labelSmall: gajrajOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Galada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Galada
  static TextStyle galada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8432d507ffd003c422fe04c6b5df2f96bbc4268f5497689493933828bc5d931',
        149068,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Galada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Galada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Galada
  static TextTheme galadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: galada(textStyle: textTheme.displayLarge),
      displayMedium: galada(textStyle: textTheme.displayMedium),
      displaySmall: galada(textStyle: textTheme.displaySmall),
      headlineLarge: galada(textStyle: textTheme.headlineLarge),
      headlineMedium: galada(textStyle: textTheme.headlineMedium),
      headlineSmall: galada(textStyle: textTheme.headlineSmall),
      titleLarge: galada(textStyle: textTheme.titleLarge),
      titleMedium: galada(textStyle: textTheme.titleMedium),
      titleSmall: galada(textStyle: textTheme.titleSmall),
      bodyLarge: galada(textStyle: textTheme.bodyLarge),
      bodyMedium: galada(textStyle: textTheme.bodyMedium),
      bodySmall: galada(textStyle: textTheme.bodySmall),
      labelLarge: galada(textStyle: textTheme.labelLarge),
      labelMedium: galada(textStyle: textTheme.labelMedium),
      labelSmall: galada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Galdeano font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Galdeano
  static TextStyle galdeano({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '169c5f2ad71dfff02ee7bb190ea1a2dce2ae2c0439d9f0d5ac96bc3806f80ad2',
        22900,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Galdeano',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Galdeano font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Galdeano
  static TextTheme galdeanoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: galdeano(textStyle: textTheme.displayLarge),
      displayMedium: galdeano(textStyle: textTheme.displayMedium),
      displaySmall: galdeano(textStyle: textTheme.displaySmall),
      headlineLarge: galdeano(textStyle: textTheme.headlineLarge),
      headlineMedium: galdeano(textStyle: textTheme.headlineMedium),
      headlineSmall: galdeano(textStyle: textTheme.headlineSmall),
      titleLarge: galdeano(textStyle: textTheme.titleLarge),
      titleMedium: galdeano(textStyle: textTheme.titleMedium),
      titleSmall: galdeano(textStyle: textTheme.titleSmall),
      bodyLarge: galdeano(textStyle: textTheme.bodyLarge),
      bodyMedium: galdeano(textStyle: textTheme.bodyMedium),
      bodySmall: galdeano(textStyle: textTheme.bodySmall),
      labelLarge: galdeano(textStyle: textTheme.labelLarge),
      labelMedium: galdeano(textStyle: textTheme.labelMedium),
      labelSmall: galdeano(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Galindo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Galindo
  static TextStyle galindo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4e28b9c469bfbbf4e0c7b26e8feace2a49cc07820d008e4d1931a5a1fa5a00a',
        55584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Galindo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Galindo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Galindo
  static TextTheme galindoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: galindo(textStyle: textTheme.displayLarge),
      displayMedium: galindo(textStyle: textTheme.displayMedium),
      displaySmall: galindo(textStyle: textTheme.displaySmall),
      headlineLarge: galindo(textStyle: textTheme.headlineLarge),
      headlineMedium: galindo(textStyle: textTheme.headlineMedium),
      headlineSmall: galindo(textStyle: textTheme.headlineSmall),
      titleLarge: galindo(textStyle: textTheme.titleLarge),
      titleMedium: galindo(textStyle: textTheme.titleMedium),
      titleSmall: galindo(textStyle: textTheme.titleSmall),
      bodyLarge: galindo(textStyle: textTheme.bodyLarge),
      bodyMedium: galindo(textStyle: textTheme.bodyMedium),
      bodySmall: galindo(textStyle: textTheme.bodySmall),
      labelLarge: galindo(textStyle: textTheme.labelLarge),
      labelMedium: galindo(textStyle: textTheme.labelMedium),
      labelSmall: galindo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gamja Flower font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gamja+Flower
  static TextStyle gamjaFlower({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d9e0eba60b09fc0e5787971e046726e13d0f94149e47615c76ba3cbb34f0de2',
        6240100,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GamjaFlower',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gamja Flower font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gamja+Flower
  static TextTheme gamjaFlowerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gamjaFlower(textStyle: textTheme.displayLarge),
      displayMedium: gamjaFlower(textStyle: textTheme.displayMedium),
      displaySmall: gamjaFlower(textStyle: textTheme.displaySmall),
      headlineLarge: gamjaFlower(textStyle: textTheme.headlineLarge),
      headlineMedium: gamjaFlower(textStyle: textTheme.headlineMedium),
      headlineSmall: gamjaFlower(textStyle: textTheme.headlineSmall),
      titleLarge: gamjaFlower(textStyle: textTheme.titleLarge),
      titleMedium: gamjaFlower(textStyle: textTheme.titleMedium),
      titleSmall: gamjaFlower(textStyle: textTheme.titleSmall),
      bodyLarge: gamjaFlower(textStyle: textTheme.bodyLarge),
      bodyMedium: gamjaFlower(textStyle: textTheme.bodyMedium),
      bodySmall: gamjaFlower(textStyle: textTheme.bodySmall),
      labelLarge: gamjaFlower(textStyle: textTheme.labelLarge),
      labelMedium: gamjaFlower(textStyle: textTheme.labelMedium),
      labelSmall: gamjaFlower(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gantari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gantari
  static TextStyle gantari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a29bfb090f79bf09421b953eeb94b8c61aa65376dfe7b2fed2eb83be927c7624',
        38192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcff9241715699b4d7c6fb63b8520791abdca3b2605bedb3e6f5fdb3916ad12c',
        38208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db8cfe86ac2c1a33c04c3e079735138799266123f0613a014952a8714d51f8d8',
        38108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a95cfa960cf311af295254e180de9ae70bb380fc1064a244d52e04c15f44533b',
        38108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d143537c088372155e5633e1b1119ac23240e7972d0652c3541fb1f8c232776',
        38144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2b1f2938a4a32d58a3a1605f94b9427adb6ec1751b77f0e6ed8ee4e7f05ddb7',
        38100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c78fa010422173b924b21c4e13d042fe6e9c9bcc4874e5ffd18470372b6182d',
        37972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07f103849bd0d4aa2989b3cff7ad0b641695947f8b92cf8a34ae646969614ae2',
        38044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b2ecbcb0f1662df6c43312f05bd9774c516f249639c953dea9d0e5ac3c7db05',
        37904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '310d279864b4d619163027fe709f135c7a7c03b7a0e2f7d840302f747bfe9779',
        38848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7b8e0b9fb28bbe1788cfd0219b84bfd6c9a69867541e2ab16879ab73be89b9e9',
        38904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b621369f18b88db96b94de89ba698e1037f9da7a82a0e4de23d7d218a4933a15',
        38844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5470847ef5b183bd72be18fed0659fcbaea97dc5cf472cc2d88461f0d5ac2c16',
        38720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b9f0b97b7dbde764780b4bce0190969701aac81d858c315b7a25479b29af445d',
        38800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '781a62c179b5f30ad3459913aba958fd2c1e2cb7db44be18a77d533c5e90ca13',
        38824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '015f127c15b2643359d7ab9b22eca5ea70794dfa617991dd4b0057123312beba',
        38696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '708167c698ac6901a1494faba6aba135e3ccc1885237be4b29f0d767c551e6d7',
        38756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f0be3ed1977e7176119608b2d6deeb2926dfe9326e6e234a2782b6edc4d5f13d',
        38592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gantari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gantari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gantari
  static TextTheme gantariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gantari(textStyle: textTheme.displayLarge),
      displayMedium: gantari(textStyle: textTheme.displayMedium),
      displaySmall: gantari(textStyle: textTheme.displaySmall),
      headlineLarge: gantari(textStyle: textTheme.headlineLarge),
      headlineMedium: gantari(textStyle: textTheme.headlineMedium),
      headlineSmall: gantari(textStyle: textTheme.headlineSmall),
      titleLarge: gantari(textStyle: textTheme.titleLarge),
      titleMedium: gantari(textStyle: textTheme.titleMedium),
      titleSmall: gantari(textStyle: textTheme.titleSmall),
      bodyLarge: gantari(textStyle: textTheme.bodyLarge),
      bodyMedium: gantari(textStyle: textTheme.bodyMedium),
      bodySmall: gantari(textStyle: textTheme.bodySmall),
      labelLarge: gantari(textStyle: textTheme.labelLarge),
      labelMedium: gantari(textStyle: textTheme.labelMedium),
      labelSmall: gantari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gasoek One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gasoek+One
  static TextStyle gasoekOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61f2fc56f9d72d968f8dd834c7d24cb4b822eec52597656dd796feca7c121973',
        516100,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GasoekOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gasoek One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gasoek+One
  static TextTheme gasoekOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gasoekOne(textStyle: textTheme.displayLarge),
      displayMedium: gasoekOne(textStyle: textTheme.displayMedium),
      displaySmall: gasoekOne(textStyle: textTheme.displaySmall),
      headlineLarge: gasoekOne(textStyle: textTheme.headlineLarge),
      headlineMedium: gasoekOne(textStyle: textTheme.headlineMedium),
      headlineSmall: gasoekOne(textStyle: textTheme.headlineSmall),
      titleLarge: gasoekOne(textStyle: textTheme.titleLarge),
      titleMedium: gasoekOne(textStyle: textTheme.titleMedium),
      titleSmall: gasoekOne(textStyle: textTheme.titleSmall),
      bodyLarge: gasoekOne(textStyle: textTheme.bodyLarge),
      bodyMedium: gasoekOne(textStyle: textTheme.bodyMedium),
      bodySmall: gasoekOne(textStyle: textTheme.bodySmall),
      labelLarge: gasoekOne(textStyle: textTheme.labelLarge),
      labelMedium: gasoekOne(textStyle: textTheme.labelMedium),
      labelSmall: gasoekOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gayathri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gayathri
  static TextStyle gayathri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36b842b40f1fa5e3a255a7f703229a68e77aadb56ad9882fe759ee4cac03edcd',
        149780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '856ebe7b45457bcf480f5e18531f4fb35a2367b45e52a7d06c976f8c1494c0c3',
        148700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdf87794f44396d19dc08ae4ae81e6172e9b7ba47cb8f0484972120fbd8275dc',
        149624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gayathri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gayathri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gayathri
  static TextTheme gayathriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gayathri(textStyle: textTheme.displayLarge),
      displayMedium: gayathri(textStyle: textTheme.displayMedium),
      displaySmall: gayathri(textStyle: textTheme.displaySmall),
      headlineLarge: gayathri(textStyle: textTheme.headlineLarge),
      headlineMedium: gayathri(textStyle: textTheme.headlineMedium),
      headlineSmall: gayathri(textStyle: textTheme.headlineSmall),
      titleLarge: gayathri(textStyle: textTheme.titleLarge),
      titleMedium: gayathri(textStyle: textTheme.titleMedium),
      titleSmall: gayathri(textStyle: textTheme.titleSmall),
      bodyLarge: gayathri(textStyle: textTheme.bodyLarge),
      bodyMedium: gayathri(textStyle: textTheme.bodyMedium),
      bodySmall: gayathri(textStyle: textTheme.bodySmall),
      labelLarge: gayathri(textStyle: textTheme.labelLarge),
      labelMedium: gayathri(textStyle: textTheme.labelMedium),
      labelSmall: gayathri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gelasio font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gelasio
  static TextStyle gelasio({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e54c93dd37e3c47763f4aca59167b4f7fb366ab4f1117304b7c9659c49b8ef5d',
        100944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95f25d7700ba5e5c59fb61ae1ce1fb0cbcb6897093914ce51531aae908596732',
        101232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5929bf4f5f67f925ced7024d61106251d75a70618d50d2bc5d11de25794d16ba',
        101348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c587c3029f721f613d1609084a955f4297f5ec25126f69b184d2994b825731d3',
        101212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e26f9376a2e7b089aad19a53ad466214f4175a7bd0aefc2ffb7cbdfbdf2c037b',
        102612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9ca31f4126ce560e9fa1b4dc8908b51cdbbb4bca71ace8d5f76010f2d684ef9c',
        102960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6b1360202d546d7333dc6370af113311bb5fde3a0a3fa10913f10e2853a6e632',
        103024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f58b21049769a5afbadc91ec72ea8f221ce15f0d43021e577b8676b90fe6d9d8',
        102704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gelasio',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gelasio font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gelasio
  static TextTheme gelasioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gelasio(textStyle: textTheme.displayLarge),
      displayMedium: gelasio(textStyle: textTheme.displayMedium),
      displaySmall: gelasio(textStyle: textTheme.displaySmall),
      headlineLarge: gelasio(textStyle: textTheme.headlineLarge),
      headlineMedium: gelasio(textStyle: textTheme.headlineMedium),
      headlineSmall: gelasio(textStyle: textTheme.headlineSmall),
      titleLarge: gelasio(textStyle: textTheme.titleLarge),
      titleMedium: gelasio(textStyle: textTheme.titleMedium),
      titleSmall: gelasio(textStyle: textTheme.titleSmall),
      bodyLarge: gelasio(textStyle: textTheme.bodyLarge),
      bodyMedium: gelasio(textStyle: textTheme.bodyMedium),
      bodySmall: gelasio(textStyle: textTheme.bodySmall),
      labelLarge: gelasio(textStyle: textTheme.labelLarge),
      labelMedium: gelasio(textStyle: textTheme.labelMedium),
      labelSmall: gelasio(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gemunu Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gemunu+Libre
  static TextStyle gemunuLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ee58da2ea3ad0a30b053d24be3ecbfe343ea1ffcbdc9e354325dffdab140e30',
        145064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f9e4a4f2bc5babade37f64218625af24eecc921e5d3e7d518a7beecceaa571da',
        145056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fef849ad705564ed5616591c94b8243782ca9aab3f091c7dc6c41ad193958efd',
        145052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3a306074b241d73099495bb06453a955aabceb2195f9f78e33a82f27eee4f73',
        144916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7e07a234c1d33fde8a008a0831d40a4815cb01c9c31f2604353ee575cc1439b',
        144900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e274d4b3c3557a6befbe2dec456451a3dcd626bd8d5471c58ba7dd73bc0ec85',
        144788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9015ced8371fab9c58386b8eb712c846b0d387d6a36ead67034d2592ae0c1901',
        144544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GemunuLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gemunu Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gemunu+Libre
  static TextTheme gemunuLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gemunuLibre(textStyle: textTheme.displayLarge),
      displayMedium: gemunuLibre(textStyle: textTheme.displayMedium),
      displaySmall: gemunuLibre(textStyle: textTheme.displaySmall),
      headlineLarge: gemunuLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: gemunuLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: gemunuLibre(textStyle: textTheme.headlineSmall),
      titleLarge: gemunuLibre(textStyle: textTheme.titleLarge),
      titleMedium: gemunuLibre(textStyle: textTheme.titleMedium),
      titleSmall: gemunuLibre(textStyle: textTheme.titleSmall),
      bodyLarge: gemunuLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: gemunuLibre(textStyle: textTheme.bodyMedium),
      bodySmall: gemunuLibre(textStyle: textTheme.bodySmall),
      labelLarge: gemunuLibre(textStyle: textTheme.labelLarge),
      labelMedium: gemunuLibre(textStyle: textTheme.labelMedium),
      labelSmall: gemunuLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Genos font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Genos
  static TextStyle genos({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f1947c6488f2f2374cf8e452c419a42d8527c5e64d1607dd635b5bd8a5775ee',
        74604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33f993364ec57b5472b49fac667e6189c6b17c75d7d37875e6a5f844a1f556bd',
        74780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85c3297ad6544f3e1e59300868a2f67176b8276f2868809c0ba17548ba184fb4',
        74744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb5264344a445bb53d24c333e093b3310c3622c1353e94fb22087bdba2430464',
        74776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96d9450c96ad90cd640ba1c9840a23c5737119eba65dafe09d40752016c63517',
        74716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '682ff9de8f52d7149584bed1fbfaaf026324cd1743961d3e2860e004690ce07e',
        74744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4a827a9a0121ea3e4a4b40dd45ca5053df2a390c32ed0c15f8d798b9a1e0eb5',
        74804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ae69f53045828d9bc78c8cb7621e4b7a869174b8024dfedc141713c10c7b8e1',
        74828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e239ef48a6d42a0e09d95399cb385cbf0bc486028d998fe140a8e4e119f998ec',
        74456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0f69b5dadc4bcc2ca12e7fa0e2cd8f303c4f4c2a66f842c98c5614a29832d941',
        80660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fef217e5c95a44a79809edeee16b4a88562e026c5d1650a06da8be656d29a664',
        80788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a247bdcce8667f6ecde8e1c36cbd84121597afd58c835ec14f010d5a646b1ae1',
        80800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a0ca7355e46786d380da67530030ac11c08c6959497619665f7e75835f28aac1',
        80708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aaffea1580faf153648e06ae82cf7e8120b3e8fc09af22a30241d12b24455cef',
        80888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cf6e6226e7e31135153cfba0e7d6253d26a0c81aee542ca5f1b33406beeffd61',
        80924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aace9e8c585430d8e5f5e8b0868040cf8c94a62926da3ca1b2915ccf918aac11',
        80876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '965f1e1a19310a275f32f3aa52d992ac6436d6c42f8f761d9819978ac78f2143',
        80844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '73d9402317cc748500edd9280aedf2cb6abe9f796d224a7c6332e221f0763005',
        80636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Genos',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Genos font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Genos
  static TextTheme genosTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: genos(textStyle: textTheme.displayLarge),
      displayMedium: genos(textStyle: textTheme.displayMedium),
      displaySmall: genos(textStyle: textTheme.displaySmall),
      headlineLarge: genos(textStyle: textTheme.headlineLarge),
      headlineMedium: genos(textStyle: textTheme.headlineMedium),
      headlineSmall: genos(textStyle: textTheme.headlineSmall),
      titleLarge: genos(textStyle: textTheme.titleLarge),
      titleMedium: genos(textStyle: textTheme.titleMedium),
      titleSmall: genos(textStyle: textTheme.titleSmall),
      bodyLarge: genos(textStyle: textTheme.bodyLarge),
      bodyMedium: genos(textStyle: textTheme.bodyMedium),
      bodySmall: genos(textStyle: textTheme.bodySmall),
      labelLarge: genos(textStyle: textTheme.labelLarge),
      labelMedium: genos(textStyle: textTheme.labelMedium),
      labelSmall: genos(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gentium Book Plus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gentium+Book+Plus
  static TextStyle gentiumBookPlus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf47e63699ba03f44205881dd862e9127eec1d348c8907f2c15d877015af7ea6',
        422484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '17f2786f409895c81d67081ef9450c26f29009c1b784812f894e50295192cd48',
        453480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99aefcb41ae939044e6eed546579a017f0d8e49c3597b0d2c8f1d3c3518f9622',
        425744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a0d2139194cf21bfa5f0a7956f871206df60a33165e52007e6263afdf1e5896c',
        457732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GentiumBookPlus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gentium Book Plus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gentium+Book+Plus
  static TextTheme gentiumBookPlusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gentiumBookPlus(textStyle: textTheme.displayLarge),
      displayMedium: gentiumBookPlus(textStyle: textTheme.displayMedium),
      displaySmall: gentiumBookPlus(textStyle: textTheme.displaySmall),
      headlineLarge: gentiumBookPlus(textStyle: textTheme.headlineLarge),
      headlineMedium: gentiumBookPlus(textStyle: textTheme.headlineMedium),
      headlineSmall: gentiumBookPlus(textStyle: textTheme.headlineSmall),
      titleLarge: gentiumBookPlus(textStyle: textTheme.titleLarge),
      titleMedium: gentiumBookPlus(textStyle: textTheme.titleMedium),
      titleSmall: gentiumBookPlus(textStyle: textTheme.titleSmall),
      bodyLarge: gentiumBookPlus(textStyle: textTheme.bodyLarge),
      bodyMedium: gentiumBookPlus(textStyle: textTheme.bodyMedium),
      bodySmall: gentiumBookPlus(textStyle: textTheme.bodySmall),
      labelLarge: gentiumBookPlus(textStyle: textTheme.labelLarge),
      labelMedium: gentiumBookPlus(textStyle: textTheme.labelMedium),
      labelSmall: gentiumBookPlus(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gentium Plus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gentium+Plus
  static TextStyle gentiumPlus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28f2b4944e2a125cafd82fd90967a382e35b3e4a4232fb9ed0a4d5a2f7ed7bb4',
        419980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4f1327239df4342b6b1049ee6c6cc4a112226a2e98cd312b6e1ffd6f81539b64',
        451052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78c73cde2aaef84c82fa776ba70f73f8a84b1e80f926f69f884617730632b552',
        424176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9420052d0a15788273c42bc60a16edcaea50c80b2d6980849b8442df39a8ea1',
        455684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GentiumPlus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gentium Plus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gentium+Plus
  static TextTheme gentiumPlusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gentiumPlus(textStyle: textTheme.displayLarge),
      displayMedium: gentiumPlus(textStyle: textTheme.displayMedium),
      displaySmall: gentiumPlus(textStyle: textTheme.displaySmall),
      headlineLarge: gentiumPlus(textStyle: textTheme.headlineLarge),
      headlineMedium: gentiumPlus(textStyle: textTheme.headlineMedium),
      headlineSmall: gentiumPlus(textStyle: textTheme.headlineSmall),
      titleLarge: gentiumPlus(textStyle: textTheme.titleLarge),
      titleMedium: gentiumPlus(textStyle: textTheme.titleMedium),
      titleSmall: gentiumPlus(textStyle: textTheme.titleSmall),
      bodyLarge: gentiumPlus(textStyle: textTheme.bodyLarge),
      bodyMedium: gentiumPlus(textStyle: textTheme.bodyMedium),
      bodySmall: gentiumPlus(textStyle: textTheme.bodySmall),
      labelLarge: gentiumPlus(textStyle: textTheme.labelLarge),
      labelMedium: gentiumPlus(textStyle: textTheme.labelMedium),
      labelSmall: gentiumPlus(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Geo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geo
  static TextStyle geo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f79c41fa9c99729ae68689c8c66dcdf8718c2407e6b8fef7b9062ea8c16dfff',
        12944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9c70217473395a8c2dc83e04a633f34dba2de290c6d248b39428c1ffc735d89a',
        13868,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Geo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Geo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geo
  static TextTheme geoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: geo(textStyle: textTheme.displayLarge),
      displayMedium: geo(textStyle: textTheme.displayMedium),
      displaySmall: geo(textStyle: textTheme.displaySmall),
      headlineLarge: geo(textStyle: textTheme.headlineLarge),
      headlineMedium: geo(textStyle: textTheme.headlineMedium),
      headlineSmall: geo(textStyle: textTheme.headlineSmall),
      titleLarge: geo(textStyle: textTheme.titleLarge),
      titleMedium: geo(textStyle: textTheme.titleMedium),
      titleSmall: geo(textStyle: textTheme.titleSmall),
      bodyLarge: geo(textStyle: textTheme.bodyLarge),
      bodyMedium: geo(textStyle: textTheme.bodyMedium),
      bodySmall: geo(textStyle: textTheme.bodySmall),
      labelLarge: geo(textStyle: textTheme.labelLarge),
      labelMedium: geo(textStyle: textTheme.labelMedium),
      labelSmall: geo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Geologica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geologica
  static TextStyle geologica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7445bceffd7713d9f6def187ca05260aceb709ac3c2584f2567c7c0f5e61cc31',
        130168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '391e670e5904fae792b38258d5e370cc089d672f13dc496379107afb024725d7',
        130280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ecebed7d78eb5a5ab28ccd8793cd8e2d6171e2b2620d99cc7e546499d5f954a5',
        130196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83d23537037c9256b135cc8c48e023a7c9498273ca0a523f5cf65e4eedccf506',
        130188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c27f166004346bb9c55e2d7bbdfb616115dd44bb834063330a160da6e9a54b0',
        130436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0350e65c553ebc6e57b4629219c2db877868d2f7927e25a45ef723f805574795',
        130784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07d030de251a9902c8db2d7f012c88df106216167821ae1b3e0e391bbe73c270',
        130920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8886ad91f06114a2b20fea7b31a66995c84194fa73c91ed4c9d452b7eb241782',
        131124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2b700905bd17fc716309a2e69e062705d42db53494ad43fa3678dbd07399ffa',
        130972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Geologica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Geologica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geologica
  static TextTheme geologicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: geologica(textStyle: textTheme.displayLarge),
      displayMedium: geologica(textStyle: textTheme.displayMedium),
      displaySmall: geologica(textStyle: textTheme.displaySmall),
      headlineLarge: geologica(textStyle: textTheme.headlineLarge),
      headlineMedium: geologica(textStyle: textTheme.headlineMedium),
      headlineSmall: geologica(textStyle: textTheme.headlineSmall),
      titleLarge: geologica(textStyle: textTheme.titleLarge),
      titleMedium: geologica(textStyle: textTheme.titleMedium),
      titleSmall: geologica(textStyle: textTheme.titleSmall),
      bodyLarge: geologica(textStyle: textTheme.bodyLarge),
      bodyMedium: geologica(textStyle: textTheme.bodyMedium),
      bodySmall: geologica(textStyle: textTheme.bodySmall),
      labelLarge: geologica(textStyle: textTheme.labelLarge),
      labelMedium: geologica(textStyle: textTheme.labelMedium),
      labelSmall: geologica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Georama font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Georama
  static TextStyle georama({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a85db16048000054014a6acc549adf3ca07164b79e9a1eeee4a6688042f8d19',
        90444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f085b8fb5ad22473dafe2763d2eda07e1c1dc2731ad86243890ac48f1f1fcb53',
        92000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9131d1dbd381c8aaf3a22ec69fd0ce3e924795c2af07a632b5cb9a793b7995c4',
        91988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7568ebc8bfc028bdaa9d7666288e3c9050705fb270947c69dd45e66c1da97091',
        91976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aef804e8ede70545273e62430675fc650c78879a5b45ee5064944481cfafa635',
        91944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '909be55ad1e7d36267f19fb4882ee30d61bc5d25fb054e4456f004fa8373153f',
        91976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b72a8645304b864081aa9a82bef8ed376afe089ae2a73ccf12911609fa632ad5',
        91868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f351eaf34c7d7162b9c067c92731725fb3722faa6fb75730b471ccf638c87abb',
        91888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08bb4c0532b2e780789b1f10a982f2321c2afad8ab5759f1320f7546f7db4599',
        91804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd93a12185ee5e9bfe30e4956825aa07ecf1f7e458cf78afa87bb60247ede2ebc',
        92072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9aa40f5493ee87225f5dd89077b757a339dba11b9752cde7298dfd937ce7a137',
        92968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9a17935396354d329e614e1007c869c6f6c9e1e8fb66700f028b94f368b75004',
        92908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '67b2293594aff643c43e78e5a7a7639b05b4b65e3ee2dd55a9caf9a9e21444e5',
        92792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b24dfa77854fd3d6a59002464aa6e8da3f52f321b185d01056bd8dc26aeb08bc',
        92912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '63309ca304f27e90188a6a6f38c54f5ac9b44f8a66183b640df57e7fd9811b77',
        92916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e25970176fde26d926183f5f9c3c08e468d14b6d489d1590e977affc3302788e',
        92792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '90b7be79c3e3a2d380197acf969811aa937970af2709cee8949e4b0e252f8d33',
        92908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '41b99ab5c843f7795fa5684351efa107697fc701e4098c5d697cccf0ddc64212',
        92772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Georama',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Georama font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Georama
  static TextTheme georamaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: georama(textStyle: textTheme.displayLarge),
      displayMedium: georama(textStyle: textTheme.displayMedium),
      displaySmall: georama(textStyle: textTheme.displaySmall),
      headlineLarge: georama(textStyle: textTheme.headlineLarge),
      headlineMedium: georama(textStyle: textTheme.headlineMedium),
      headlineSmall: georama(textStyle: textTheme.headlineSmall),
      titleLarge: georama(textStyle: textTheme.titleLarge),
      titleMedium: georama(textStyle: textTheme.titleMedium),
      titleSmall: georama(textStyle: textTheme.titleSmall),
      bodyLarge: georama(textStyle: textTheme.bodyLarge),
      bodyMedium: georama(textStyle: textTheme.bodyMedium),
      bodySmall: georama(textStyle: textTheme.bodySmall),
      labelLarge: georama(textStyle: textTheme.labelLarge),
      labelMedium: georama(textStyle: textTheme.labelMedium),
      labelSmall: georama(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Geostar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geostar
  static TextStyle geostar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '995aecb87452c29ac77c82bbab6fb81c27eec88f83673c2cc8165e95d4c46706',
        38888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Geostar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Geostar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geostar
  static TextTheme geostarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: geostar(textStyle: textTheme.displayLarge),
      displayMedium: geostar(textStyle: textTheme.displayMedium),
      displaySmall: geostar(textStyle: textTheme.displaySmall),
      headlineLarge: geostar(textStyle: textTheme.headlineLarge),
      headlineMedium: geostar(textStyle: textTheme.headlineMedium),
      headlineSmall: geostar(textStyle: textTheme.headlineSmall),
      titleLarge: geostar(textStyle: textTheme.titleLarge),
      titleMedium: geostar(textStyle: textTheme.titleMedium),
      titleSmall: geostar(textStyle: textTheme.titleSmall),
      bodyLarge: geostar(textStyle: textTheme.bodyLarge),
      bodyMedium: geostar(textStyle: textTheme.bodyMedium),
      bodySmall: geostar(textStyle: textTheme.bodySmall),
      labelLarge: geostar(textStyle: textTheme.labelLarge),
      labelMedium: geostar(textStyle: textTheme.labelMedium),
      labelSmall: geostar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Geostar Fill font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geostar+Fill
  static TextStyle geostarFill({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56bf2d9632d27af78f21607c1dcfb05342285c80a7b81807bab9d53e9ecd52b6',
        36404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GeostarFill',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Geostar Fill font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Geostar+Fill
  static TextTheme geostarFillTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: geostarFill(textStyle: textTheme.displayLarge),
      displayMedium: geostarFill(textStyle: textTheme.displayMedium),
      displaySmall: geostarFill(textStyle: textTheme.displaySmall),
      headlineLarge: geostarFill(textStyle: textTheme.headlineLarge),
      headlineMedium: geostarFill(textStyle: textTheme.headlineMedium),
      headlineSmall: geostarFill(textStyle: textTheme.headlineSmall),
      titleLarge: geostarFill(textStyle: textTheme.titleLarge),
      titleMedium: geostarFill(textStyle: textTheme.titleMedium),
      titleSmall: geostarFill(textStyle: textTheme.titleSmall),
      bodyLarge: geostarFill(textStyle: textTheme.bodyLarge),
      bodyMedium: geostarFill(textStyle: textTheme.bodyMedium),
      bodySmall: geostarFill(textStyle: textTheme.bodySmall),
      labelLarge: geostarFill(textStyle: textTheme.labelLarge),
      labelMedium: geostarFill(textStyle: textTheme.labelMedium),
      labelSmall: geostarFill(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Germania One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Germania+One
  static TextStyle germaniaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf0d6476aeeece05b4e2b37641700d8e9811bd9aacd158a3127a49da5c92414c',
        29864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GermaniaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Germania One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Germania+One
  static TextTheme germaniaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: germaniaOne(textStyle: textTheme.displayLarge),
      displayMedium: germaniaOne(textStyle: textTheme.displayMedium),
      displaySmall: germaniaOne(textStyle: textTheme.displaySmall),
      headlineLarge: germaniaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: germaniaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: germaniaOne(textStyle: textTheme.headlineSmall),
      titleLarge: germaniaOne(textStyle: textTheme.titleLarge),
      titleMedium: germaniaOne(textStyle: textTheme.titleMedium),
      titleSmall: germaniaOne(textStyle: textTheme.titleSmall),
      bodyLarge: germaniaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: germaniaOne(textStyle: textTheme.bodyMedium),
      bodySmall: germaniaOne(textStyle: textTheme.bodySmall),
      labelLarge: germaniaOne(textStyle: textTheme.labelLarge),
      labelMedium: germaniaOne(textStyle: textTheme.labelMedium),
      labelSmall: germaniaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gideon Roman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gideon+Roman
  static TextStyle gideonRoman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5173dc53bc75a691071c98a79fc60aaba1e609e70e2968ab27a3a98d767f5e8',
        95056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GideonRoman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gideon Roman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gideon+Roman
  static TextTheme gideonRomanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gideonRoman(textStyle: textTheme.displayLarge),
      displayMedium: gideonRoman(textStyle: textTheme.displayMedium),
      displaySmall: gideonRoman(textStyle: textTheme.displaySmall),
      headlineLarge: gideonRoman(textStyle: textTheme.headlineLarge),
      headlineMedium: gideonRoman(textStyle: textTheme.headlineMedium),
      headlineSmall: gideonRoman(textStyle: textTheme.headlineSmall),
      titleLarge: gideonRoman(textStyle: textTheme.titleLarge),
      titleMedium: gideonRoman(textStyle: textTheme.titleMedium),
      titleSmall: gideonRoman(textStyle: textTheme.titleSmall),
      bodyLarge: gideonRoman(textStyle: textTheme.bodyLarge),
      bodyMedium: gideonRoman(textStyle: textTheme.bodyMedium),
      bodySmall: gideonRoman(textStyle: textTheme.bodySmall),
      labelLarge: gideonRoman(textStyle: textTheme.labelLarge),
      labelMedium: gideonRoman(textStyle: textTheme.labelMedium),
      labelSmall: gideonRoman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gidugu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gidugu
  static TextStyle gidugu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e56977e610db5fead3b74c54b9d4eb77dcc2f927653fe8e3e125c54263adb287',
        174000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gidugu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gidugu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gidugu
  static TextTheme giduguTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gidugu(textStyle: textTheme.displayLarge),
      displayMedium: gidugu(textStyle: textTheme.displayMedium),
      displaySmall: gidugu(textStyle: textTheme.displaySmall),
      headlineLarge: gidugu(textStyle: textTheme.headlineLarge),
      headlineMedium: gidugu(textStyle: textTheme.headlineMedium),
      headlineSmall: gidugu(textStyle: textTheme.headlineSmall),
      titleLarge: gidugu(textStyle: textTheme.titleLarge),
      titleMedium: gidugu(textStyle: textTheme.titleMedium),
      titleSmall: gidugu(textStyle: textTheme.titleSmall),
      bodyLarge: gidugu(textStyle: textTheme.bodyLarge),
      bodyMedium: gidugu(textStyle: textTheme.bodyMedium),
      bodySmall: gidugu(textStyle: textTheme.bodySmall),
      labelLarge: gidugu(textStyle: textTheme.labelLarge),
      labelMedium: gidugu(textStyle: textTheme.labelMedium),
      labelSmall: gidugu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gilda Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gilda+Display
  static TextStyle gildaDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd822bfbed1fd1d8c3e1f0d08550be22a66a893bb1a67db864227b6a5a20c02e',
        46028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GildaDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gilda Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gilda+Display
  static TextTheme gildaDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gildaDisplay(textStyle: textTheme.displayLarge),
      displayMedium: gildaDisplay(textStyle: textTheme.displayMedium),
      displaySmall: gildaDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: gildaDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: gildaDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: gildaDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: gildaDisplay(textStyle: textTheme.titleLarge),
      titleMedium: gildaDisplay(textStyle: textTheme.titleMedium),
      titleSmall: gildaDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: gildaDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: gildaDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: gildaDisplay(textStyle: textTheme.bodySmall),
      labelLarge: gildaDisplay(textStyle: textTheme.labelLarge),
      labelMedium: gildaDisplay(textStyle: textTheme.labelMedium),
      labelSmall: gildaDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Girassol font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Girassol
  static TextStyle girassol({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1192a737479de6f9241d0aceab300f1c131b5ad987c88cdfb0c17a7db296c43',
        31140,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Girassol',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Girassol font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Girassol
  static TextTheme girassolTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: girassol(textStyle: textTheme.displayLarge),
      displayMedium: girassol(textStyle: textTheme.displayMedium),
      displaySmall: girassol(textStyle: textTheme.displaySmall),
      headlineLarge: girassol(textStyle: textTheme.headlineLarge),
      headlineMedium: girassol(textStyle: textTheme.headlineMedium),
      headlineSmall: girassol(textStyle: textTheme.headlineSmall),
      titleLarge: girassol(textStyle: textTheme.titleLarge),
      titleMedium: girassol(textStyle: textTheme.titleMedium),
      titleSmall: girassol(textStyle: textTheme.titleSmall),
      bodyLarge: girassol(textStyle: textTheme.bodyLarge),
      bodyMedium: girassol(textStyle: textTheme.bodyMedium),
      bodySmall: girassol(textStyle: textTheme.bodySmall),
      labelLarge: girassol(textStyle: textTheme.labelLarge),
      labelMedium: girassol(textStyle: textTheme.labelMedium),
      labelSmall: girassol(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Give You Glory font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Give+You+Glory
  static TextStyle giveYouGlory({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da4d27e519ee851e9b034a7c494e78737f54418f6da2edcb78d98815d0199ada',
        39000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GiveYouGlory',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Give You Glory font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Give+You+Glory
  static TextTheme giveYouGloryTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: giveYouGlory(textStyle: textTheme.displayLarge),
      displayMedium: giveYouGlory(textStyle: textTheme.displayMedium),
      displaySmall: giveYouGlory(textStyle: textTheme.displaySmall),
      headlineLarge: giveYouGlory(textStyle: textTheme.headlineLarge),
      headlineMedium: giveYouGlory(textStyle: textTheme.headlineMedium),
      headlineSmall: giveYouGlory(textStyle: textTheme.headlineSmall),
      titleLarge: giveYouGlory(textStyle: textTheme.titleLarge),
      titleMedium: giveYouGlory(textStyle: textTheme.titleMedium),
      titleSmall: giveYouGlory(textStyle: textTheme.titleSmall),
      bodyLarge: giveYouGlory(textStyle: textTheme.bodyLarge),
      bodyMedium: giveYouGlory(textStyle: textTheme.bodyMedium),
      bodySmall: giveYouGlory(textStyle: textTheme.bodySmall),
      labelLarge: giveYouGlory(textStyle: textTheme.labelLarge),
      labelMedium: giveYouGlory(textStyle: textTheme.labelMedium),
      labelSmall: giveYouGlory(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Glass Antiqua font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Glass+Antiqua
  static TextStyle glassAntiqua({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '210409806b391c698a7e9c19378cbbb5cd95a22894639bf38ad0ea2304b57cea',
        60540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GlassAntiqua',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Glass Antiqua font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Glass+Antiqua
  static TextTheme glassAntiquaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: glassAntiqua(textStyle: textTheme.displayLarge),
      displayMedium: glassAntiqua(textStyle: textTheme.displayMedium),
      displaySmall: glassAntiqua(textStyle: textTheme.displaySmall),
      headlineLarge: glassAntiqua(textStyle: textTheme.headlineLarge),
      headlineMedium: glassAntiqua(textStyle: textTheme.headlineMedium),
      headlineSmall: glassAntiqua(textStyle: textTheme.headlineSmall),
      titleLarge: glassAntiqua(textStyle: textTheme.titleLarge),
      titleMedium: glassAntiqua(textStyle: textTheme.titleMedium),
      titleSmall: glassAntiqua(textStyle: textTheme.titleSmall),
      bodyLarge: glassAntiqua(textStyle: textTheme.bodyLarge),
      bodyMedium: glassAntiqua(textStyle: textTheme.bodyMedium),
      bodySmall: glassAntiqua(textStyle: textTheme.bodySmall),
      labelLarge: glassAntiqua(textStyle: textTheme.labelLarge),
      labelMedium: glassAntiqua(textStyle: textTheme.labelMedium),
      labelSmall: glassAntiqua(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Glegoo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Glegoo
  static TextStyle glegoo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '096d1d2c36a024898c7de0604dc7d3e43f36b5bb790a0df65d21c9ef3f59561f',
        111584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05f160a49db1fb37039edf46d5176558fa2dcaf135f262873dfaa2b1d20dce29',
        109420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Glegoo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Glegoo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Glegoo
  static TextTheme glegooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: glegoo(textStyle: textTheme.displayLarge),
      displayMedium: glegoo(textStyle: textTheme.displayMedium),
      displaySmall: glegoo(textStyle: textTheme.displaySmall),
      headlineLarge: glegoo(textStyle: textTheme.headlineLarge),
      headlineMedium: glegoo(textStyle: textTheme.headlineMedium),
      headlineSmall: glegoo(textStyle: textTheme.headlineSmall),
      titleLarge: glegoo(textStyle: textTheme.titleLarge),
      titleMedium: glegoo(textStyle: textTheme.titleMedium),
      titleSmall: glegoo(textStyle: textTheme.titleSmall),
      bodyLarge: glegoo(textStyle: textTheme.bodyLarge),
      bodyMedium: glegoo(textStyle: textTheme.bodyMedium),
      bodySmall: glegoo(textStyle: textTheme.bodySmall),
      labelLarge: glegoo(textStyle: textTheme.labelLarge),
      labelMedium: glegoo(textStyle: textTheme.labelMedium),
      labelSmall: glegoo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gloock font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gloock
  static TextStyle gloock({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25fa08cee3e78615e6bb2f8ea58dedf4b6fb0bad0e35a52bfb9e0c3d0afc5e97',
        64052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gloock',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gloock font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gloock
  static TextTheme gloockTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gloock(textStyle: textTheme.displayLarge),
      displayMedium: gloock(textStyle: textTheme.displayMedium),
      displaySmall: gloock(textStyle: textTheme.displaySmall),
      headlineLarge: gloock(textStyle: textTheme.headlineLarge),
      headlineMedium: gloock(textStyle: textTheme.headlineMedium),
      headlineSmall: gloock(textStyle: textTheme.headlineSmall),
      titleLarge: gloock(textStyle: textTheme.titleLarge),
      titleMedium: gloock(textStyle: textTheme.titleMedium),
      titleSmall: gloock(textStyle: textTheme.titleSmall),
      bodyLarge: gloock(textStyle: textTheme.bodyLarge),
      bodyMedium: gloock(textStyle: textTheme.bodyMedium),
      bodySmall: gloock(textStyle: textTheme.bodySmall),
      labelLarge: gloock(textStyle: textTheme.labelLarge),
      labelMedium: gloock(textStyle: textTheme.labelMedium),
      labelSmall: gloock(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gloria Hallelujah font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gloria+Hallelujah
  static TextStyle gloriaHallelujah({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a1e6858fb4cdffbd29a5489caf7f09977f20c8fbb5cc43d4f3dd2affd19d47b',
        42056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GloriaHallelujah',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gloria Hallelujah font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gloria+Hallelujah
  static TextTheme gloriaHallelujahTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gloriaHallelujah(textStyle: textTheme.displayLarge),
      displayMedium: gloriaHallelujah(textStyle: textTheme.displayMedium),
      displaySmall: gloriaHallelujah(textStyle: textTheme.displaySmall),
      headlineLarge: gloriaHallelujah(textStyle: textTheme.headlineLarge),
      headlineMedium: gloriaHallelujah(textStyle: textTheme.headlineMedium),
      headlineSmall: gloriaHallelujah(textStyle: textTheme.headlineSmall),
      titleLarge: gloriaHallelujah(textStyle: textTheme.titleLarge),
      titleMedium: gloriaHallelujah(textStyle: textTheme.titleMedium),
      titleSmall: gloriaHallelujah(textStyle: textTheme.titleSmall),
      bodyLarge: gloriaHallelujah(textStyle: textTheme.bodyLarge),
      bodyMedium: gloriaHallelujah(textStyle: textTheme.bodyMedium),
      bodySmall: gloriaHallelujah(textStyle: textTheme.bodySmall),
      labelLarge: gloriaHallelujah(textStyle: textTheme.labelLarge),
      labelMedium: gloriaHallelujah(textStyle: textTheme.labelMedium),
      labelSmall: gloriaHallelujah(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Glory font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Glory
  static TextStyle glory({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85e863ed32e02583e2ad7501dd33ff88909b0b352c6d51c5fa1551a1eb2c1c4a',
        52380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f394493b5bf59d19eb60d056a7a30183a7d946d0940a6549b12e35f5e9a5885c',
        52612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77ba5211f7f43ae6f8d2bb15bed0e9b010a2b272f808419c16e1cff70aa9e9f7',
        52640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd320ea5a026419dbdcfdb87ecf0c6849c35d72f35a129036baf9a49da76c348d',
        52668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '997d4740865ba97cabb27d27a2b9de5543f66938503d85d9767f9427fd33c193',
        52736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ea793d93bb79967b9ddaa280ed5fe006f80bc5e6cd970bdd938674b4fbf5283',
        52648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '153dd6ab3b3313d408287f2ce10cd9bd05927144f3af40703f8901fe4fbce5d7',
        52624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ef1afecf19db36ffe64f3dbb4f7bd15919e9b4450b6c587b8f995534216b21a',
        52700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3c3cd6e54fa3891972886e4cd0e447dcc093079e828eae2cc7bb576d655d2e2d',
        53992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3f252ac6a1e8c41bcdc0a6be3158c577f4b202be7cbf097b2be93460285f7612',
        54272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'af0ab316bc3583a5c75bc4b1d9a8c695e72c2f5a1376413f3fcf080ec57d103c',
        54312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '01c91f999e4c3c4042226f777e6e61cbdfe7eaaf820833bd2c1db9e0b55dbf25',
        54284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '066741486e9a1f0b20a67b9f0dd57c80423cc0ce31e8ea63f48d103470402021',
        54396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '514e63f230d90c2afae1046c73b563274b1c98175b49a7274040326579968905',
        54532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14f4cead7ec07acb9f606d5114a817cf421419e720f4bfa3e1685be50cfab748',
        54448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e362f1bea13bd59cb0b373fa89390cf0fd6622785d0e5b7fe1ff7d6d0e171c2b',
        54516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Glory',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Glory font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Glory
  static TextTheme gloryTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: glory(textStyle: textTheme.displayLarge),
      displayMedium: glory(textStyle: textTheme.displayMedium),
      displaySmall: glory(textStyle: textTheme.displaySmall),
      headlineLarge: glory(textStyle: textTheme.headlineLarge),
      headlineMedium: glory(textStyle: textTheme.headlineMedium),
      headlineSmall: glory(textStyle: textTheme.headlineSmall),
      titleLarge: glory(textStyle: textTheme.titleLarge),
      titleMedium: glory(textStyle: textTheme.titleMedium),
      titleSmall: glory(textStyle: textTheme.titleSmall),
      bodyLarge: glory(textStyle: textTheme.bodyLarge),
      bodyMedium: glory(textStyle: textTheme.bodyMedium),
      bodySmall: glory(textStyle: textTheme.bodySmall),
      labelLarge: glory(textStyle: textTheme.labelLarge),
      labelMedium: glory(textStyle: textTheme.labelMedium),
      labelSmall: glory(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gluten font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gluten
  static TextStyle gluten({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf5b7549a8dbb23d9bf0ea9129dbd66e8c1c610ba1dd323c0eb1b29f8f122a52',
        85956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdfbb288831d868550cd821009e37dfa6c197ae741f98532a6a5b02b613438a3',
        86528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ef3b4c381836ae652b3872cb9ab9f1c520a0c18ca5c7d78f5e54661cbba0ad1',
        86592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91203f1bc63ec423a00d7250d03cb26a687766454056de2f1253b6d82622b53e',
        86660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0292eb78093bf1a2888898c161b6b446dff2396a3dd982fb87ee782ba2836eed',
        86728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '363f9cc614948239fa720351844334fe4f7b06b2e211570ca08f995e9a6c545a',
        86776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6374244f4ceb36ba618e313b51f603faaa1188444d9801657a24cc5a4c806e1b',
        86772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34e8798451be8973392a00f4f7474e79dae41337447618ca1251f6c0c81eaee0',
        86848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '579cb7d343f6a4641287dd8cb2426758dcf43fdb2d4106abbdf2ad19629c3425',
        86732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gluten',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gluten font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gluten
  static TextTheme glutenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gluten(textStyle: textTheme.displayLarge),
      displayMedium: gluten(textStyle: textTheme.displayMedium),
      displaySmall: gluten(textStyle: textTheme.displaySmall),
      headlineLarge: gluten(textStyle: textTheme.headlineLarge),
      headlineMedium: gluten(textStyle: textTheme.headlineMedium),
      headlineSmall: gluten(textStyle: textTheme.headlineSmall),
      titleLarge: gluten(textStyle: textTheme.titleLarge),
      titleMedium: gluten(textStyle: textTheme.titleMedium),
      titleSmall: gluten(textStyle: textTheme.titleSmall),
      bodyLarge: gluten(textStyle: textTheme.bodyLarge),
      bodyMedium: gluten(textStyle: textTheme.bodyMedium),
      bodySmall: gluten(textStyle: textTheme.bodySmall),
      labelLarge: gluten(textStyle: textTheme.labelLarge),
      labelMedium: gluten(textStyle: textTheme.labelMedium),
      labelSmall: gluten(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Goblin One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Goblin+One
  static TextStyle goblinOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1814b2ff4e3cf66cf0a62c549cd26c9f530b423f6d452c28a162c312facd82b1',
        32924,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GoblinOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Goblin One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Goblin+One
  static TextTheme goblinOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: goblinOne(textStyle: textTheme.displayLarge),
      displayMedium: goblinOne(textStyle: textTheme.displayMedium),
      displaySmall: goblinOne(textStyle: textTheme.displaySmall),
      headlineLarge: goblinOne(textStyle: textTheme.headlineLarge),
      headlineMedium: goblinOne(textStyle: textTheme.headlineMedium),
      headlineSmall: goblinOne(textStyle: textTheme.headlineSmall),
      titleLarge: goblinOne(textStyle: textTheme.titleLarge),
      titleMedium: goblinOne(textStyle: textTheme.titleMedium),
      titleSmall: goblinOne(textStyle: textTheme.titleSmall),
      bodyLarge: goblinOne(textStyle: textTheme.bodyLarge),
      bodyMedium: goblinOne(textStyle: textTheme.bodyMedium),
      bodySmall: goblinOne(textStyle: textTheme.bodySmall),
      labelLarge: goblinOne(textStyle: textTheme.labelLarge),
      labelMedium: goblinOne(textStyle: textTheme.labelMedium),
      labelSmall: goblinOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gochi Hand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gochi+Hand
  static TextStyle gochiHand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e14027767a3e1882fe5134c51b348fa3f1283786a15bd03eec929f92adb77ed1',
        34972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GochiHand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gochi Hand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gochi+Hand
  static TextTheme gochiHandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gochiHand(textStyle: textTheme.displayLarge),
      displayMedium: gochiHand(textStyle: textTheme.displayMedium),
      displaySmall: gochiHand(textStyle: textTheme.displaySmall),
      headlineLarge: gochiHand(textStyle: textTheme.headlineLarge),
      headlineMedium: gochiHand(textStyle: textTheme.headlineMedium),
      headlineSmall: gochiHand(textStyle: textTheme.headlineSmall),
      titleLarge: gochiHand(textStyle: textTheme.titleLarge),
      titleMedium: gochiHand(textStyle: textTheme.titleMedium),
      titleSmall: gochiHand(textStyle: textTheme.titleSmall),
      bodyLarge: gochiHand(textStyle: textTheme.bodyLarge),
      bodyMedium: gochiHand(textStyle: textTheme.bodyMedium),
      bodySmall: gochiHand(textStyle: textTheme.bodySmall),
      labelLarge: gochiHand(textStyle: textTheme.labelLarge),
      labelMedium: gochiHand(textStyle: textTheme.labelMedium),
      labelSmall: gochiHand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Goldman font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Goldman
  static TextStyle goldman({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcc1f27a2032e81387715d774b1b846f8dcbfbb0addbc21ca60a20369c4910de',
        53520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ba145edd49915d8bcc291871f87a64e40ad57ff52187576e5ace029aba1d131',
        53308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Goldman',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Goldman font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Goldman
  static TextTheme goldmanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: goldman(textStyle: textTheme.displayLarge),
      displayMedium: goldman(textStyle: textTheme.displayMedium),
      displaySmall: goldman(textStyle: textTheme.displaySmall),
      headlineLarge: goldman(textStyle: textTheme.headlineLarge),
      headlineMedium: goldman(textStyle: textTheme.headlineMedium),
      headlineSmall: goldman(textStyle: textTheme.headlineSmall),
      titleLarge: goldman(textStyle: textTheme.titleLarge),
      titleMedium: goldman(textStyle: textTheme.titleMedium),
      titleSmall: goldman(textStyle: textTheme.titleSmall),
      bodyLarge: goldman(textStyle: textTheme.bodyLarge),
      bodyMedium: goldman(textStyle: textTheme.bodyMedium),
      bodySmall: goldman(textStyle: textTheme.bodySmall),
      labelLarge: goldman(textStyle: textTheme.labelLarge),
      labelMedium: goldman(textStyle: textTheme.labelMedium),
      labelSmall: goldman(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Golos Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Golos+Text
  static TextStyle golosText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a34a041c2ed926d1c781621175f6b1ab6a70fed65d6f1777f2c0dfbbc1edd3c7',
        64216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '893eac524d48cd54cfadfa74c7c82f1e406f71783eccb4f7dd9a8bbf6702d259',
        64184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ed3465fb39f5e3dc7e38b5eeb7831b84a3065268e63cf498f535b9a577d2414',
        64240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06f4f066bda306ade509c712adeda97b550ae24aabe326fc9ec5ccd45066665d',
        64084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05d4be9f34de382b3a97d797366a0f2c987102d360907e2d8e7bd6c1fa030a4e',
        64188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1dc5664d210a68f7ff504fada46b98f295b7f824034f7a81aa4a59cd200132d6',
        64068,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GolosText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Golos Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Golos+Text
  static TextTheme golosTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: golosText(textStyle: textTheme.displayLarge),
      displayMedium: golosText(textStyle: textTheme.displayMedium),
      displaySmall: golosText(textStyle: textTheme.displaySmall),
      headlineLarge: golosText(textStyle: textTheme.headlineLarge),
      headlineMedium: golosText(textStyle: textTheme.headlineMedium),
      headlineSmall: golosText(textStyle: textTheme.headlineSmall),
      titleLarge: golosText(textStyle: textTheme.titleLarge),
      titleMedium: golosText(textStyle: textTheme.titleMedium),
      titleSmall: golosText(textStyle: textTheme.titleSmall),
      bodyLarge: golosText(textStyle: textTheme.bodyLarge),
      bodyMedium: golosText(textStyle: textTheme.bodyMedium),
      bodySmall: golosText(textStyle: textTheme.bodySmall),
      labelLarge: golosText(textStyle: textTheme.labelLarge),
      labelMedium: golosText(textStyle: textTheme.labelMedium),
      labelSmall: golosText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gorditas font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gorditas
  static TextStyle gorditas({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '45b651d82f53948b18ef0930e52cc803ab811f6c483c1d16c95a14fb567a826d',
        56976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d777debf400c511a1efd40061b80d7645182e4cae45a6fb5dfd168bdf16bd54',
        57968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gorditas',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gorditas font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gorditas
  static TextTheme gorditasTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gorditas(textStyle: textTheme.displayLarge),
      displayMedium: gorditas(textStyle: textTheme.displayMedium),
      displaySmall: gorditas(textStyle: textTheme.displaySmall),
      headlineLarge: gorditas(textStyle: textTheme.headlineLarge),
      headlineMedium: gorditas(textStyle: textTheme.headlineMedium),
      headlineSmall: gorditas(textStyle: textTheme.headlineSmall),
      titleLarge: gorditas(textStyle: textTheme.titleLarge),
      titleMedium: gorditas(textStyle: textTheme.titleMedium),
      titleSmall: gorditas(textStyle: textTheme.titleSmall),
      bodyLarge: gorditas(textStyle: textTheme.bodyLarge),
      bodyMedium: gorditas(textStyle: textTheme.bodyMedium),
      bodySmall: gorditas(textStyle: textTheme.bodySmall),
      labelLarge: gorditas(textStyle: textTheme.labelLarge),
      labelMedium: gorditas(textStyle: textTheme.labelMedium),
      labelSmall: gorditas(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gothic A1 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gothic+A1
  static TextStyle gothicA1({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2344d0dfaed41c6aa2ad2e4c3a7cc1e3542488d80cf185add2cb5f376c565fb5',
        1315212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab8ea5d842f6fe59c01e9bb6565c63bf79dfe4c5c6437b2189a2a8f645329464',
        1313544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0befdd647051b924421c0c5b5528cc6aaf80b66c7a7b0073c2f55e924d904bd',
        1314200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c8517146924481477fbd92182e32ab65f415725277a50ba76d5c6613d6c7d42',
        1311204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93c6927eb1ea8f245a17922720c161d22e2f6fbcd78a2195bba5f0004c05493f',
        1311796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd30143d7bfb5faf291c2d26eacf27594738cbc1604915b641fe51cd12cbcd5b0',
        1311188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2114ec6ba9f1da8def89f6ff990edcc3b669f4a8eb1e604869ccb6f6d4a1b203',
        1310928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e883524fbd806a6c3de3f735880528da71b72984c850a194318130085032a0af',
        1310756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdf849a28c7ecce3f6eff2c28aab66403dd2f60dc1e51402f7700705f6b0a457',
        1312028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GothicA1',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gothic A1 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gothic+A1
  static TextTheme gothicA1TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gothicA1(textStyle: textTheme.displayLarge),
      displayMedium: gothicA1(textStyle: textTheme.displayMedium),
      displaySmall: gothicA1(textStyle: textTheme.displaySmall),
      headlineLarge: gothicA1(textStyle: textTheme.headlineLarge),
      headlineMedium: gothicA1(textStyle: textTheme.headlineMedium),
      headlineSmall: gothicA1(textStyle: textTheme.headlineSmall),
      titleLarge: gothicA1(textStyle: textTheme.titleLarge),
      titleMedium: gothicA1(textStyle: textTheme.titleMedium),
      titleSmall: gothicA1(textStyle: textTheme.titleSmall),
      bodyLarge: gothicA1(textStyle: textTheme.bodyLarge),
      bodyMedium: gothicA1(textStyle: textTheme.bodyMedium),
      bodySmall: gothicA1(textStyle: textTheme.bodySmall),
      labelLarge: gothicA1(textStyle: textTheme.labelLarge),
      labelMedium: gothicA1(textStyle: textTheme.labelMedium),
      labelSmall: gothicA1(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gotu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gotu
  static TextStyle gotu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98d4a3d184f0b26de233d2e9b6f51a705f62c76c4f2d5d2e52a83c9d94e05132',
        518800,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gotu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gotu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gotu
  static TextTheme gotuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gotu(textStyle: textTheme.displayLarge),
      displayMedium: gotu(textStyle: textTheme.displayMedium),
      displaySmall: gotu(textStyle: textTheme.displaySmall),
      headlineLarge: gotu(textStyle: textTheme.headlineLarge),
      headlineMedium: gotu(textStyle: textTheme.headlineMedium),
      headlineSmall: gotu(textStyle: textTheme.headlineSmall),
      titleLarge: gotu(textStyle: textTheme.titleLarge),
      titleMedium: gotu(textStyle: textTheme.titleMedium),
      titleSmall: gotu(textStyle: textTheme.titleSmall),
      bodyLarge: gotu(textStyle: textTheme.bodyLarge),
      bodyMedium: gotu(textStyle: textTheme.bodyMedium),
      bodySmall: gotu(textStyle: textTheme.bodySmall),
      labelLarge: gotu(textStyle: textTheme.labelLarge),
      labelMedium: gotu(textStyle: textTheme.labelMedium),
      labelSmall: gotu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Goudy Bookletter 1911 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Goudy+Bookletter+1911
  static TextStyle goudyBookletter1911({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9eaa28534e2332649b5b4cf8d9797691016bf271a83acf52faa1b36c8ab5d3c',
        36796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GoudyBookletter1911',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Goudy Bookletter 1911 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Goudy+Bookletter+1911
  static TextTheme goudyBookletter1911TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: goudyBookletter1911(textStyle: textTheme.displayLarge),
      displayMedium: goudyBookletter1911(textStyle: textTheme.displayMedium),
      displaySmall: goudyBookletter1911(textStyle: textTheme.displaySmall),
      headlineLarge: goudyBookletter1911(textStyle: textTheme.headlineLarge),
      headlineMedium: goudyBookletter1911(textStyle: textTheme.headlineMedium),
      headlineSmall: goudyBookletter1911(textStyle: textTheme.headlineSmall),
      titleLarge: goudyBookletter1911(textStyle: textTheme.titleLarge),
      titleMedium: goudyBookletter1911(textStyle: textTheme.titleMedium),
      titleSmall: goudyBookletter1911(textStyle: textTheme.titleSmall),
      bodyLarge: goudyBookletter1911(textStyle: textTheme.bodyLarge),
      bodyMedium: goudyBookletter1911(textStyle: textTheme.bodyMedium),
      bodySmall: goudyBookletter1911(textStyle: textTheme.bodySmall),
      labelLarge: goudyBookletter1911(textStyle: textTheme.labelLarge),
      labelMedium: goudyBookletter1911(textStyle: textTheme.labelMedium),
      labelSmall: goudyBookletter1911(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gowun Batang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gowun+Batang
  static TextStyle gowunBatang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1256292a2f7fb2f8f73d9e20030408aa2ff0c7e3fab8d1715dc094bb594fd5b0',
        8430916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c26cf829c92cef1c0d8cf6eeb6e99eacb9ea1021010b68922068062620e3314',
        8175220,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GowunBatang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gowun Batang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gowun+Batang
  static TextTheme gowunBatangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gowunBatang(textStyle: textTheme.displayLarge),
      displayMedium: gowunBatang(textStyle: textTheme.displayMedium),
      displaySmall: gowunBatang(textStyle: textTheme.displaySmall),
      headlineLarge: gowunBatang(textStyle: textTheme.headlineLarge),
      headlineMedium: gowunBatang(textStyle: textTheme.headlineMedium),
      headlineSmall: gowunBatang(textStyle: textTheme.headlineSmall),
      titleLarge: gowunBatang(textStyle: textTheme.titleLarge),
      titleMedium: gowunBatang(textStyle: textTheme.titleMedium),
      titleSmall: gowunBatang(textStyle: textTheme.titleSmall),
      bodyLarge: gowunBatang(textStyle: textTheme.bodyLarge),
      bodyMedium: gowunBatang(textStyle: textTheme.bodyMedium),
      bodySmall: gowunBatang(textStyle: textTheme.bodySmall),
      labelLarge: gowunBatang(textStyle: textTheme.labelLarge),
      labelMedium: gowunBatang(textStyle: textTheme.labelMedium),
      labelSmall: gowunBatang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gowun Dodum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gowun+Dodum
  static TextStyle gowunDodum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4f73f91c50079a3140edee56a09d818531340544221e32e70bcbc960a7969d7',
        7226720,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GowunDodum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gowun Dodum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gowun+Dodum
  static TextTheme gowunDodumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gowunDodum(textStyle: textTheme.displayLarge),
      displayMedium: gowunDodum(textStyle: textTheme.displayMedium),
      displaySmall: gowunDodum(textStyle: textTheme.displaySmall),
      headlineLarge: gowunDodum(textStyle: textTheme.headlineLarge),
      headlineMedium: gowunDodum(textStyle: textTheme.headlineMedium),
      headlineSmall: gowunDodum(textStyle: textTheme.headlineSmall),
      titleLarge: gowunDodum(textStyle: textTheme.titleLarge),
      titleMedium: gowunDodum(textStyle: textTheme.titleMedium),
      titleSmall: gowunDodum(textStyle: textTheme.titleSmall),
      bodyLarge: gowunDodum(textStyle: textTheme.bodyLarge),
      bodyMedium: gowunDodum(textStyle: textTheme.bodyMedium),
      bodySmall: gowunDodum(textStyle: textTheme.bodySmall),
      labelLarge: gowunDodum(textStyle: textTheme.labelLarge),
      labelMedium: gowunDodum(textStyle: textTheme.labelMedium),
      labelSmall: gowunDodum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Graduate font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Graduate
  static TextStyle graduate({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fdca8e407cce49d93b08f5c6d44dd1c79e66e36eb8a96d63b519d009fd5e7358',
        20784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Graduate',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Graduate font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Graduate
  static TextTheme graduateTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: graduate(textStyle: textTheme.displayLarge),
      displayMedium: graduate(textStyle: textTheme.displayMedium),
      displaySmall: graduate(textStyle: textTheme.displaySmall),
      headlineLarge: graduate(textStyle: textTheme.headlineLarge),
      headlineMedium: graduate(textStyle: textTheme.headlineMedium),
      headlineSmall: graduate(textStyle: textTheme.headlineSmall),
      titleLarge: graduate(textStyle: textTheme.titleLarge),
      titleMedium: graduate(textStyle: textTheme.titleMedium),
      titleSmall: graduate(textStyle: textTheme.titleSmall),
      bodyLarge: graduate(textStyle: textTheme.bodyLarge),
      bodyMedium: graduate(textStyle: textTheme.bodyMedium),
      bodySmall: graduate(textStyle: textTheme.bodySmall),
      labelLarge: graduate(textStyle: textTheme.labelLarge),
      labelMedium: graduate(textStyle: textTheme.labelMedium),
      labelSmall: graduate(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grand Hotel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grand+Hotel
  static TextStyle grandHotel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff1a0bf6514f70dff314a728275a77ae13cc84481727d49daa7700a1c77f4e24',
        60668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GrandHotel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grand Hotel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grand+Hotel
  static TextTheme grandHotelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grandHotel(textStyle: textTheme.displayLarge),
      displayMedium: grandHotel(textStyle: textTheme.displayMedium),
      displaySmall: grandHotel(textStyle: textTheme.displaySmall),
      headlineLarge: grandHotel(textStyle: textTheme.headlineLarge),
      headlineMedium: grandHotel(textStyle: textTheme.headlineMedium),
      headlineSmall: grandHotel(textStyle: textTheme.headlineSmall),
      titleLarge: grandHotel(textStyle: textTheme.titleLarge),
      titleMedium: grandHotel(textStyle: textTheme.titleMedium),
      titleSmall: grandHotel(textStyle: textTheme.titleSmall),
      bodyLarge: grandHotel(textStyle: textTheme.bodyLarge),
      bodyMedium: grandHotel(textStyle: textTheme.bodyMedium),
      bodySmall: grandHotel(textStyle: textTheme.bodySmall),
      labelLarge: grandHotel(textStyle: textTheme.labelLarge),
      labelMedium: grandHotel(textStyle: textTheme.labelMedium),
      labelSmall: grandHotel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grandiflora One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grandiflora+One
  static TextStyle grandifloraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1720ac1ad1ce936cf8066de63a4c0638a47a657e0e28e59a6b89f3458685656b',
        1028608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GrandifloraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grandiflora One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grandiflora+One
  static TextTheme grandifloraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grandifloraOne(textStyle: textTheme.displayLarge),
      displayMedium: grandifloraOne(textStyle: textTheme.displayMedium),
      displaySmall: grandifloraOne(textStyle: textTheme.displaySmall),
      headlineLarge: grandifloraOne(textStyle: textTheme.headlineLarge),
      headlineMedium: grandifloraOne(textStyle: textTheme.headlineMedium),
      headlineSmall: grandifloraOne(textStyle: textTheme.headlineSmall),
      titleLarge: grandifloraOne(textStyle: textTheme.titleLarge),
      titleMedium: grandifloraOne(textStyle: textTheme.titleMedium),
      titleSmall: grandifloraOne(textStyle: textTheme.titleSmall),
      bodyLarge: grandifloraOne(textStyle: textTheme.bodyLarge),
      bodyMedium: grandifloraOne(textStyle: textTheme.bodyMedium),
      bodySmall: grandifloraOne(textStyle: textTheme.bodySmall),
      labelLarge: grandifloraOne(textStyle: textTheme.labelLarge),
      labelMedium: grandifloraOne(textStyle: textTheme.labelMedium),
      labelSmall: grandifloraOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grandstander font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grandstander
  static TextStyle grandstander({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '174f03df5747ce3aa64b08774eff070b2e4973a1df414ff0d7b2ca8a56dd245b',
        83136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cae1b6e7a9235e085f6e16d814b762b45d5c89bb9e2fa076a90aef4fc0016a09',
        83324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c559c91ad8c22bedca60f66e6c77fd0f59c45be9dff91b291b19f4c4247ec18d',
        83344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3247fdea2eb17013563251ac6530d1d8325bcc669024d6833d6655fa09b9747',
        83344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9dacefb651d4378f15bf195656385739f91b53a19d28532332b8eac08b01c60d',
        83400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48acc6f54b31fd536d0c07d7ed80becad24cfdb4ccd93e146ec7d2eb7c2fdeca',
        83440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5e4bb92e49c0e38b6eca1e7b1e968f2be44afde53904ec215e902146ff6bdca',
        83416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59ac3e668e2f3bfb395feb4fee8916bfefdb16e904a20b42d2b045f01cc798f4',
        83480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'afb976b69cb35f9a01574e287ec897ec74b8cac960a23b0aa1a3f91cc1292971',
        83288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '91186cc13c420b72e76538be6eb9147c9d7c4749ed489215aad626d8075b66ea',
        83796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f07de16d8c271564fbedae441981349724d62766f4b0dced86d710f24c8e0236',
        83972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65e73ef71f4791d01c75e775920accb508b5fba8534a5fc72d557b09d5354c06',
        83852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '236b538161d3ca7bf62918cc7a6fc1733821549c8fbf5d8c12d5f2540d92dc7a',
        83728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18dca9f7a35c099363ae6d0000214b1a7d6d99b9f5a0025b0facf9d0594c0b04',
        83872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5764fb19704815b4e99063e2ae8758809403967a58af11da87c86de8c4e83c21',
        83872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c3fe9771999ee48eb09c8b83dc5c24430b009e711217c6d0fd87ac335fb326e2',
        83832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '894eae2d655ad3c57b6036b35a2bbec0d51083d535df1ceb7acf873fa4c4f237',
        83940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e278b0fae4ad4e437d2b3342fc4361696b38e08cd6fdeeccbeda3c3173618cdd',
        83784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Grandstander',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grandstander font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grandstander
  static TextTheme grandstanderTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grandstander(textStyle: textTheme.displayLarge),
      displayMedium: grandstander(textStyle: textTheme.displayMedium),
      displaySmall: grandstander(textStyle: textTheme.displaySmall),
      headlineLarge: grandstander(textStyle: textTheme.headlineLarge),
      headlineMedium: grandstander(textStyle: textTheme.headlineMedium),
      headlineSmall: grandstander(textStyle: textTheme.headlineSmall),
      titleLarge: grandstander(textStyle: textTheme.titleLarge),
      titleMedium: grandstander(textStyle: textTheme.titleMedium),
      titleSmall: grandstander(textStyle: textTheme.titleSmall),
      bodyLarge: grandstander(textStyle: textTheme.bodyLarge),
      bodyMedium: grandstander(textStyle: textTheme.bodyMedium),
      bodySmall: grandstander(textStyle: textTheme.bodySmall),
      labelLarge: grandstander(textStyle: textTheme.labelLarge),
      labelMedium: grandstander(textStyle: textTheme.labelMedium),
      labelSmall: grandstander(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grape Nuts font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grape+Nuts
  static TextStyle grapeNuts({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83ed4095cd2e5e95730d32b3dbc8e49736ed9a5af77909117b59c0b439f94b74',
        84952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GrapeNuts',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grape Nuts font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grape+Nuts
  static TextTheme grapeNutsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grapeNuts(textStyle: textTheme.displayLarge),
      displayMedium: grapeNuts(textStyle: textTheme.displayMedium),
      displaySmall: grapeNuts(textStyle: textTheme.displaySmall),
      headlineLarge: grapeNuts(textStyle: textTheme.headlineLarge),
      headlineMedium: grapeNuts(textStyle: textTheme.headlineMedium),
      headlineSmall: grapeNuts(textStyle: textTheme.headlineSmall),
      titleLarge: grapeNuts(textStyle: textTheme.titleLarge),
      titleMedium: grapeNuts(textStyle: textTheme.titleMedium),
      titleSmall: grapeNuts(textStyle: textTheme.titleSmall),
      bodyLarge: grapeNuts(textStyle: textTheme.bodyLarge),
      bodyMedium: grapeNuts(textStyle: textTheme.bodyMedium),
      bodySmall: grapeNuts(textStyle: textTheme.bodySmall),
      labelLarge: grapeNuts(textStyle: textTheme.labelLarge),
      labelMedium: grapeNuts(textStyle: textTheme.labelMedium),
      labelSmall: grapeNuts(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gravitas One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gravitas+One
  static TextStyle gravitasOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f88e7e5440ef2e1a3411bace216a316397ad8ecdb5aa2c70d630e27f1eed605',
        37360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GravitasOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gravitas One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gravitas+One
  static TextTheme gravitasOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gravitasOne(textStyle: textTheme.displayLarge),
      displayMedium: gravitasOne(textStyle: textTheme.displayMedium),
      displaySmall: gravitasOne(textStyle: textTheme.displaySmall),
      headlineLarge: gravitasOne(textStyle: textTheme.headlineLarge),
      headlineMedium: gravitasOne(textStyle: textTheme.headlineMedium),
      headlineSmall: gravitasOne(textStyle: textTheme.headlineSmall),
      titleLarge: gravitasOne(textStyle: textTheme.titleLarge),
      titleMedium: gravitasOne(textStyle: textTheme.titleMedium),
      titleSmall: gravitasOne(textStyle: textTheme.titleSmall),
      bodyLarge: gravitasOne(textStyle: textTheme.bodyLarge),
      bodyMedium: gravitasOne(textStyle: textTheme.bodyMedium),
      bodySmall: gravitasOne(textStyle: textTheme.bodySmall),
      labelLarge: gravitasOne(textStyle: textTheme.labelLarge),
      labelMedium: gravitasOne(textStyle: textTheme.labelMedium),
      labelSmall: gravitasOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Great Vibes font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Great+Vibes
  static TextStyle greatVibes({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d9df90fa57086aeb92149a4bec8b1e30c8a0e5ecc3a8b64663527eb6b935219',
        249728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GreatVibes',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Great Vibes font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Great+Vibes
  static TextTheme greatVibesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: greatVibes(textStyle: textTheme.displayLarge),
      displayMedium: greatVibes(textStyle: textTheme.displayMedium),
      displaySmall: greatVibes(textStyle: textTheme.displaySmall),
      headlineLarge: greatVibes(textStyle: textTheme.headlineLarge),
      headlineMedium: greatVibes(textStyle: textTheme.headlineMedium),
      headlineSmall: greatVibes(textStyle: textTheme.headlineSmall),
      titleLarge: greatVibes(textStyle: textTheme.titleLarge),
      titleMedium: greatVibes(textStyle: textTheme.titleMedium),
      titleSmall: greatVibes(textStyle: textTheme.titleSmall),
      bodyLarge: greatVibes(textStyle: textTheme.bodyLarge),
      bodyMedium: greatVibes(textStyle: textTheme.bodyMedium),
      bodySmall: greatVibes(textStyle: textTheme.bodySmall),
      labelLarge: greatVibes(textStyle: textTheme.labelLarge),
      labelMedium: greatVibes(textStyle: textTheme.labelMedium),
      labelSmall: greatVibes(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grechen Fuemen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grechen+Fuemen
  static TextStyle grechenFuemen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea8eb00e36e8e8795df92235b997968a91358b00a70d69f8d34039a3712c9961',
        90280,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GrechenFuemen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grechen Fuemen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grechen+Fuemen
  static TextTheme grechenFuemenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grechenFuemen(textStyle: textTheme.displayLarge),
      displayMedium: grechenFuemen(textStyle: textTheme.displayMedium),
      displaySmall: grechenFuemen(textStyle: textTheme.displaySmall),
      headlineLarge: grechenFuemen(textStyle: textTheme.headlineLarge),
      headlineMedium: grechenFuemen(textStyle: textTheme.headlineMedium),
      headlineSmall: grechenFuemen(textStyle: textTheme.headlineSmall),
      titleLarge: grechenFuemen(textStyle: textTheme.titleLarge),
      titleMedium: grechenFuemen(textStyle: textTheme.titleMedium),
      titleSmall: grechenFuemen(textStyle: textTheme.titleSmall),
      bodyLarge: grechenFuemen(textStyle: textTheme.bodyLarge),
      bodyMedium: grechenFuemen(textStyle: textTheme.bodyMedium),
      bodySmall: grechenFuemen(textStyle: textTheme.bodySmall),
      labelLarge: grechenFuemen(textStyle: textTheme.labelLarge),
      labelMedium: grechenFuemen(textStyle: textTheme.labelMedium),
      labelSmall: grechenFuemen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grenze font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grenze
  static TextStyle grenze({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd0905e69d662e40b0b0dea549c8fa228145e2fa4125fc27064f8cdffe9af26b',
        64780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a1a2ac0f009402544317fc095e345f1ceb85f5c49447230c4b8c15f2fbf17a7b',
        67292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4ff8ce6f5630f53d11e6a86692261fd7702cc5c4ca21b6e51bac40b4ae17d48',
        65072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b9d5a4c3f9363080973f3ae49eb5087940965c6ef61996c6bf6ff926e53c2e64',
        67476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92131b19b06aada699a0187b48052e7d6a9491aa3c1574bb38970748a60c43d2',
        64900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b63d3aaff65dcd4ab4f6c6292f60bf28a06397ad53ef58d18dbe3e94b296a71',
        67428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3305ec8eb951bd29fb71746197b927b1f2feaf490077b67f3b490303a96e028',
        64836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42270c99790b21b761ff5c305abdaf3674d665ce0a15df662e779ea28819d5fb',
        66872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1dd0a3c26198fdd67e6581955d977457d50edc1c4615e0775366d5394cdcc5a',
        64816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fb894d592d1560218faec92d2488da2eba2a69444300590d1f22395faa1e5cbb',
        67452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6bdaff28ee15712b870c55917481855920a6325e10db122795bc4451bc773d47',
        64676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6d3b44addb1c8fc89224922238ed34f499ff8b5beb6083bd3e0282c816c44663',
        67296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '044346f16d06d1b382b06ab8aa9684bb564024fc9855cc8df43d99aa97353553',
        64608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dda89bb95e9af4a570359e6ff4216165a9faddfaf851cb9acd04ba5ca5de769f',
        67244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a9c56a437eede48957fe3a7c56b8dc690dd9ec425c9b9aaf6ab2ed556f8c2c5',
        64744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '586237e591dae5714867e2eb76ec252cf52ac7e26968b712debbfc7a73993879',
        67164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc9f366a5ebbfc5539466b2c33aa01b06570d4df39a714ced551bb01bbc48ff0',
        64488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '83f0531867318d330f16049337b2a41839dc38738d8473106c7ee54ba4f98c15',
        67224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Grenze',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grenze font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grenze
  static TextTheme grenzeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grenze(textStyle: textTheme.displayLarge),
      displayMedium: grenze(textStyle: textTheme.displayMedium),
      displaySmall: grenze(textStyle: textTheme.displaySmall),
      headlineLarge: grenze(textStyle: textTheme.headlineLarge),
      headlineMedium: grenze(textStyle: textTheme.headlineMedium),
      headlineSmall: grenze(textStyle: textTheme.headlineSmall),
      titleLarge: grenze(textStyle: textTheme.titleLarge),
      titleMedium: grenze(textStyle: textTheme.titleMedium),
      titleSmall: grenze(textStyle: textTheme.titleSmall),
      bodyLarge: grenze(textStyle: textTheme.bodyLarge),
      bodyMedium: grenze(textStyle: textTheme.bodyMedium),
      bodySmall: grenze(textStyle: textTheme.bodySmall),
      labelLarge: grenze(textStyle: textTheme.labelLarge),
      labelMedium: grenze(textStyle: textTheme.labelMedium),
      labelSmall: grenze(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grenze Gotisch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grenze+Gotisch
  static TextStyle grenzeGotisch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6029df55008a55825cd2fae4e412f403ec20158d3dd969ea3cba82fb64158580',
        70456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ce905ba6529d7ae3611ad25cf486ca4ad0dd30c52c50732d6e2f96e3332a6cf',
        70596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02d43197687d8c97fd006ac0b7bbc6381c1b11fc5e7a3deae2bca8bb230c0aed',
        70620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54a398ed75e70e3f34828caef99fb97febc57d330b70c72377f7b007261a241a',
        70452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbade1ed7b7ee3b416eeb165e3bfca121f77e57ca7a874d6833dc053d86534c3',
        70580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb5bc0ccc959d5de9b83df015ce543831c0dfa3f7779b40c38ad871a11a6cbbd',
        70676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '599486e52453adf4d1bacb2614d59dce2b48ef483d1b8a2ad4c49876c2d37143',
        70624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2214d54a8b35e4c28d866e0eebb1f1e8c5c076e1f2cd9ad140a703960cd315b',
        70692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7a2c18ccca1f20b355c5e304bff8f0106801da7392d003e371f77533fb67c4c',
        70664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GrenzeGotisch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grenze Gotisch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grenze+Gotisch
  static TextTheme grenzeGotischTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: grenzeGotisch(textStyle: textTheme.displayLarge),
      displayMedium: grenzeGotisch(textStyle: textTheme.displayMedium),
      displaySmall: grenzeGotisch(textStyle: textTheme.displaySmall),
      headlineLarge: grenzeGotisch(textStyle: textTheme.headlineLarge),
      headlineMedium: grenzeGotisch(textStyle: textTheme.headlineMedium),
      headlineSmall: grenzeGotisch(textStyle: textTheme.headlineSmall),
      titleLarge: grenzeGotisch(textStyle: textTheme.titleLarge),
      titleMedium: grenzeGotisch(textStyle: textTheme.titleMedium),
      titleSmall: grenzeGotisch(textStyle: textTheme.titleSmall),
      bodyLarge: grenzeGotisch(textStyle: textTheme.bodyLarge),
      bodyMedium: grenzeGotisch(textStyle: textTheme.bodyMedium),
      bodySmall: grenzeGotisch(textStyle: textTheme.bodySmall),
      labelLarge: grenzeGotisch(textStyle: textTheme.labelLarge),
      labelMedium: grenzeGotisch(textStyle: textTheme.labelMedium),
      labelSmall: grenzeGotisch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Grey Qo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grey+Qo
  static TextStyle greyQo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5bcc4fd5ed622f6089b100c9872580d2799c1be14f70813a5df4af039b17ae19',
        110152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'GreyQo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Grey Qo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Grey+Qo
  static TextTheme greyQoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: greyQo(textStyle: textTheme.displayLarge),
      displayMedium: greyQo(textStyle: textTheme.displayMedium),
      displaySmall: greyQo(textStyle: textTheme.displaySmall),
      headlineLarge: greyQo(textStyle: textTheme.headlineLarge),
      headlineMedium: greyQo(textStyle: textTheme.headlineMedium),
      headlineSmall: greyQo(textStyle: textTheme.headlineSmall),
      titleLarge: greyQo(textStyle: textTheme.titleLarge),
      titleMedium: greyQo(textStyle: textTheme.titleMedium),
      titleSmall: greyQo(textStyle: textTheme.titleSmall),
      bodyLarge: greyQo(textStyle: textTheme.bodyLarge),
      bodyMedium: greyQo(textStyle: textTheme.bodyMedium),
      bodySmall: greyQo(textStyle: textTheme.bodySmall),
      labelLarge: greyQo(textStyle: textTheme.labelLarge),
      labelMedium: greyQo(textStyle: textTheme.labelMedium),
      labelSmall: greyQo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Griffy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Griffy
  static TextStyle griffy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b71c5cb9d4cb052c2e0cb638c1a718f132913acca52be1a89e9131ce2ed1f675',
        206436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Griffy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Griffy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Griffy
  static TextTheme griffyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: griffy(textStyle: textTheme.displayLarge),
      displayMedium: griffy(textStyle: textTheme.displayMedium),
      displaySmall: griffy(textStyle: textTheme.displaySmall),
      headlineLarge: griffy(textStyle: textTheme.headlineLarge),
      headlineMedium: griffy(textStyle: textTheme.headlineMedium),
      headlineSmall: griffy(textStyle: textTheme.headlineSmall),
      titleLarge: griffy(textStyle: textTheme.titleLarge),
      titleMedium: griffy(textStyle: textTheme.titleMedium),
      titleSmall: griffy(textStyle: textTheme.titleSmall),
      bodyLarge: griffy(textStyle: textTheme.bodyLarge),
      bodyMedium: griffy(textStyle: textTheme.bodyMedium),
      bodySmall: griffy(textStyle: textTheme.bodySmall),
      labelLarge: griffy(textStyle: textTheme.labelLarge),
      labelMedium: griffy(textStyle: textTheme.labelMedium),
      labelSmall: griffy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gruppo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gruppo
  static TextStyle gruppo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bf61db40ac76c7b402cb56e8df2f931acc704fd3fa1285e0cf0aa91cc9bf9d9',
        55892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gruppo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gruppo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gruppo
  static TextTheme gruppoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gruppo(textStyle: textTheme.displayLarge),
      displayMedium: gruppo(textStyle: textTheme.displayMedium),
      displaySmall: gruppo(textStyle: textTheme.displaySmall),
      headlineLarge: gruppo(textStyle: textTheme.headlineLarge),
      headlineMedium: gruppo(textStyle: textTheme.headlineMedium),
      headlineSmall: gruppo(textStyle: textTheme.headlineSmall),
      titleLarge: gruppo(textStyle: textTheme.titleLarge),
      titleMedium: gruppo(textStyle: textTheme.titleMedium),
      titleSmall: gruppo(textStyle: textTheme.titleSmall),
      bodyLarge: gruppo(textStyle: textTheme.bodyLarge),
      bodyMedium: gruppo(textStyle: textTheme.bodyMedium),
      bodySmall: gruppo(textStyle: textTheme.bodySmall),
      labelLarge: gruppo(textStyle: textTheme.labelLarge),
      labelMedium: gruppo(textStyle: textTheme.labelMedium),
      labelSmall: gruppo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gudea font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gudea
  static TextStyle gudea({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a8eed0542579b267b417f670cb4943d646fffbf41ec5f2c94acc1d4c74e931e',
        20716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53bb2dabce35d41e8b3ff19d7a98dc53718955c57114b27c908fd07fb1e7a56f',
        25040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66655779275cb8cd0af6eae0c90c6288d5bf9758bdd276242bf18eced4823e28',
        20240,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gudea',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gudea font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gudea
  static TextTheme gudeaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gudea(textStyle: textTheme.displayLarge),
      displayMedium: gudea(textStyle: textTheme.displayMedium),
      displaySmall: gudea(textStyle: textTheme.displaySmall),
      headlineLarge: gudea(textStyle: textTheme.headlineLarge),
      headlineMedium: gudea(textStyle: textTheme.headlineMedium),
      headlineSmall: gudea(textStyle: textTheme.headlineSmall),
      titleLarge: gudea(textStyle: textTheme.titleLarge),
      titleMedium: gudea(textStyle: textTheme.titleMedium),
      titleSmall: gudea(textStyle: textTheme.titleSmall),
      bodyLarge: gudea(textStyle: textTheme.bodyLarge),
      bodyMedium: gudea(textStyle: textTheme.bodyMedium),
      bodySmall: gudea(textStyle: textTheme.bodySmall),
      labelLarge: gudea(textStyle: textTheme.labelLarge),
      labelMedium: gudea(textStyle: textTheme.labelMedium),
      labelSmall: gudea(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gugi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gugi
  static TextStyle gugi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1aa1f1eae1b69f3cf4527611a667c96e14c3e5c9a5d9abe0a6b492d28cc2a5cf',
        552880,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gugi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gugi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gugi
  static TextTheme gugiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gugi(textStyle: textTheme.displayLarge),
      displayMedium: gugi(textStyle: textTheme.displayMedium),
      displaySmall: gugi(textStyle: textTheme.displaySmall),
      headlineLarge: gugi(textStyle: textTheme.headlineLarge),
      headlineMedium: gugi(textStyle: textTheme.headlineMedium),
      headlineSmall: gugi(textStyle: textTheme.headlineSmall),
      titleLarge: gugi(textStyle: textTheme.titleLarge),
      titleMedium: gugi(textStyle: textTheme.titleMedium),
      titleSmall: gugi(textStyle: textTheme.titleSmall),
      bodyLarge: gugi(textStyle: textTheme.bodyLarge),
      bodyMedium: gugi(textStyle: textTheme.bodyMedium),
      bodySmall: gugi(textStyle: textTheme.bodySmall),
      labelLarge: gugi(textStyle: textTheme.labelLarge),
      labelMedium: gugi(textStyle: textTheme.labelMedium),
      labelSmall: gugi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gulzar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gulzar
  static TextStyle gulzar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f7aad31bed9c50a2a5d10e7ba9b445ef6cabfc76798fa92d62ae99cb868347d',
        869992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gulzar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gulzar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gulzar
  static TextTheme gulzarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gulzar(textStyle: textTheme.displayLarge),
      displayMedium: gulzar(textStyle: textTheme.displayMedium),
      displaySmall: gulzar(textStyle: textTheme.displaySmall),
      headlineLarge: gulzar(textStyle: textTheme.headlineLarge),
      headlineMedium: gulzar(textStyle: textTheme.headlineMedium),
      headlineSmall: gulzar(textStyle: textTheme.headlineSmall),
      titleLarge: gulzar(textStyle: textTheme.titleLarge),
      titleMedium: gulzar(textStyle: textTheme.titleMedium),
      titleSmall: gulzar(textStyle: textTheme.titleSmall),
      bodyLarge: gulzar(textStyle: textTheme.bodyLarge),
      bodyMedium: gulzar(textStyle: textTheme.bodyMedium),
      bodySmall: gulzar(textStyle: textTheme.bodySmall),
      labelLarge: gulzar(textStyle: textTheme.labelLarge),
      labelMedium: gulzar(textStyle: textTheme.labelMedium),
      labelSmall: gulzar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gupter font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gupter
  static TextStyle gupter({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6a47ccf2a001dfa3229fe2c41f0601577c8c19f096dcb18bca6b6ecf29e6345',
        33868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f9e33c8a6c5fd7dc40e42e0b77460bdcc241c0b33eb9a20e0c12f95eea4642c',
        33688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17592a69f88d14b17f25a93d731d9d94557c377b2ebe18aee987e77dce05faa8',
        33692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gupter',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gupter font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gupter
  static TextTheme gupterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gupter(textStyle: textTheme.displayLarge),
      displayMedium: gupter(textStyle: textTheme.displayMedium),
      displaySmall: gupter(textStyle: textTheme.displaySmall),
      headlineLarge: gupter(textStyle: textTheme.headlineLarge),
      headlineMedium: gupter(textStyle: textTheme.headlineMedium),
      headlineSmall: gupter(textStyle: textTheme.headlineSmall),
      titleLarge: gupter(textStyle: textTheme.titleLarge),
      titleMedium: gupter(textStyle: textTheme.titleMedium),
      titleSmall: gupter(textStyle: textTheme.titleSmall),
      bodyLarge: gupter(textStyle: textTheme.bodyLarge),
      bodyMedium: gupter(textStyle: textTheme.bodyMedium),
      bodySmall: gupter(textStyle: textTheme.bodySmall),
      labelLarge: gupter(textStyle: textTheme.labelLarge),
      labelMedium: gupter(textStyle: textTheme.labelMedium),
      labelSmall: gupter(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gurajada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gurajada
  static TextStyle gurajada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7db822f22b585cba984a5aa1e4a9b1e40e54fe74a245df6e3358ff631f606209',
        226296,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gurajada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gurajada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gurajada
  static TextTheme gurajadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gurajada(textStyle: textTheme.displayLarge),
      displayMedium: gurajada(textStyle: textTheme.displayMedium),
      displaySmall: gurajada(textStyle: textTheme.displaySmall),
      headlineLarge: gurajada(textStyle: textTheme.headlineLarge),
      headlineMedium: gurajada(textStyle: textTheme.headlineMedium),
      headlineSmall: gurajada(textStyle: textTheme.headlineSmall),
      titleLarge: gurajada(textStyle: textTheme.titleLarge),
      titleMedium: gurajada(textStyle: textTheme.titleMedium),
      titleSmall: gurajada(textStyle: textTheme.titleSmall),
      bodyLarge: gurajada(textStyle: textTheme.bodyLarge),
      bodyMedium: gurajada(textStyle: textTheme.bodyMedium),
      bodySmall: gurajada(textStyle: textTheme.bodySmall),
      labelLarge: gurajada(textStyle: textTheme.labelLarge),
      labelMedium: gurajada(textStyle: textTheme.labelMedium),
      labelSmall: gurajada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Gwendolyn font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gwendolyn
  static TextStyle gwendolyn({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e8486cf425c881e11e0cd1bb650023902ccf514422734c6e7287baa98eb55ba',
        105932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04fcfc89e1b4704dd3e74ee9c164338a1e2214ed5a84e3b52ead33b48e52c50f',
        109084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Gwendolyn',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Gwendolyn font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Gwendolyn
  static TextTheme gwendolynTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: gwendolyn(textStyle: textTheme.displayLarge),
      displayMedium: gwendolyn(textStyle: textTheme.displayMedium),
      displaySmall: gwendolyn(textStyle: textTheme.displaySmall),
      headlineLarge: gwendolyn(textStyle: textTheme.headlineLarge),
      headlineMedium: gwendolyn(textStyle: textTheme.headlineMedium),
      headlineSmall: gwendolyn(textStyle: textTheme.headlineSmall),
      titleLarge: gwendolyn(textStyle: textTheme.titleLarge),
      titleMedium: gwendolyn(textStyle: textTheme.titleMedium),
      titleSmall: gwendolyn(textStyle: textTheme.titleSmall),
      bodyLarge: gwendolyn(textStyle: textTheme.bodyLarge),
      bodyMedium: gwendolyn(textStyle: textTheme.bodyMedium),
      bodySmall: gwendolyn(textStyle: textTheme.bodySmall),
      labelLarge: gwendolyn(textStyle: textTheme.labelLarge),
      labelMedium: gwendolyn(textStyle: textTheme.labelMedium),
      labelSmall: gwendolyn(textStyle: textTheme.labelSmall),
    );
  }
}
