// THIS FILE IS GENERATED BY impellerc.
// DO NOT EDIT OR CHECK THIS INTO SOURCE CONTROL

#pragma once

#include "impeller/core/buffer_view.h"                
#include "impeller/core/sampler.h"                    
#include "impeller/core/shader_types.h"               
#include "impeller/core/resource_binder.h"            
#include "impeller/core/texture.h"                    

namespace impeller {

struct ConicalGradientSsboFillFragmentShader {
  // ===========================================================================
  // Stage Info ================================================================
  // ===========================================================================
  static constexpr std::string_view kLabel = "ConicalGradientSsboFill";
  static constexpr std::string_view kEntrypointName = "conical_gradient_ssbo_fill_fragment_main";
  static constexpr ShaderStage kShaderStage = ShaderStage::kFragment;
  // The generator used to prepare these bindings. Metal generators may be used
  // by GLES backends but GLES generators are unsuitable for the metal backend.
  static constexpr std::string_view kGeneratorName = "OpenGL Shading Language (Relaxed Vulkan Semantics)";
  // ===========================================================================
  // Struct Definitions ========================================================
  // ===========================================================================

  struct FragInfo {
    Point center; // (offset 0, size 8)
    Scalar radius; // (offset 8, size 4)
    Scalar tile_mode; // (offset 12, size 4)
    Vector4 decal_border_color; // (offset 16, size 16)
    Scalar alpha; // (offset 32, size 4)
    int32_t colors_length; // (offset 36, size 4)
    Point focus; // (offset 40, size 8)
    Scalar focus_radius; // (offset 48, size 4)
    Padding<12> _PADDING_; // (offset 52, size 12)
  }; // struct FragInfo (size 64)

  struct ColorPoint {
    Vector4 color; // (offset 0, size 16)
    Scalar stop; // (offset 16, size 4)
    Padding<12> _PADDING_; // (offset 20, size 12)
  }; // struct ColorPoint (size 32)

  template <size_t FlexCount>
  struct ColorData {
    ColorPoint colors[FlexCount]; // (offset 0, size 0)
  }; // struct ColorData (size 0)

  // ===========================================================================
  // Stage Uniform & Storage Buffers ===========================================
  // ===========================================================================

  static constexpr auto kResourceFragInfo = ShaderUniformSlot { // FragInfo
    "FragInfo",     // name
    65u, // ext_res_0
    0u,       // set
    65u,   // binding
  };
  static ShaderMetadata kMetadataFragInfo;

  static constexpr auto kResourceColorData = ShaderUniformSlot { // ColorData
    "ColorData",     // name
    64u, // ext_res_0
    0u,       // set
    64u,   // binding
  };
  static ShaderMetadata kMetadataColorData;

  // ===========================================================================
  // Stage Inputs ==============================================================
  // ===========================================================================
  static constexpr auto kInputVPosition = ShaderStageIOSlot { // v_position
    "v_position",             // name
    0u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    2u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    false,  // relaxed precision
  };

  static constexpr std::array<const ShaderStageIOSlot*, 1> kAllShaderStageInputs = {
    &kInputVPosition, // v_position
  };


  // ===========================================================================
  // Stage Outputs =============================================================
  // ===========================================================================
  static constexpr auto kOutputFragColor = ShaderStageIOSlot { // frag_color
    "frag_color",             // name
    0u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    4u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    false,  // relaxed precision
  };
  static constexpr std::array<const ShaderStageIOSlot*, 1> kAllShaderStageOutputs = {
    &kOutputFragColor, // frag_color
  };

  // ===========================================================================
  // Resource Binding Utilities ================================================
  // ===========================================================================

  /// Bind uniform buffer for resource named FragInfo.
  static bool BindFragInfo(ResourceBinder& command, BufferView view) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kUniformBuffer, kResourceFragInfo, &kMetadataFragInfo, std::move(view));
  }

  /// Bind storage buffer for resource named ColorData.
  static bool BindColorData(ResourceBinder& command, BufferView view) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kStorageBuffer, kResourceColorData, &kMetadataColorData, std::move(view));
  }


  // ===========================================================================
  // Metadata for Vulkan =======================================================
  // ===========================================================================
  static constexpr std::array<DescriptorSetLayout,2> kDescriptorSetLayouts{
    DescriptorSetLayout{
      65, // binding = 65
      DescriptorType::kUniformBuffer, // descriptor_type = DescriptorType::kUniformBuffer
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
    DescriptorSetLayout{
      64, // binding = 64
      DescriptorType::kStorageBuffer, // descriptor_type = DescriptorType::kStorageBuffer
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
  };

};  // struct ConicalGradientSsboFillFragmentShader

}  // namespace impeller
