// Copyright (c) 2023, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// IMPORTANT: This file should only ever be modified by modifying the
// corresponding .proto file and then running
// `dart runtime/vm/protos/tools/compile_perfetto_protos.dart` from the SDK root
// directory.
// Autogenerated by the ProtoZero compiler plugin. DO NOT EDIT.

#ifndef PERFETTO_PROTOS_PROTOS_PERFETTO_TRACE_PROFILING_PROFILE_COMMON_PROTO_H_
#define PERFETTO_PROTOS_PROTOS_PERFETTO_TRACE_PROFILING_PROFILE_COMMON_PROTO_H_

#include <stddef.h>
#include <stdint.h>

#include "perfetto/protozero/field_writer.h"
#include "perfetto/protozero/message.h"
#include "perfetto/protozero/packed_repeated_fields.h"
#include "perfetto/protozero/proto_decoder.h"
#include "perfetto/protozero/proto_utils.h"

namespace perfetto {
namespace protos {
namespace pbzero {

class Callstack_Decoder : public ::protozero::TypedProtoDecoder<
                              /*MAX_FIELD_ID=*/2,
                              /*HAS_NONPACKED_REPEATED_FIELDS=*/true> {
 public:
  Callstack_Decoder(const uint8_t* data, size_t len)
      : TypedProtoDecoder(data, len) {}
  explicit Callstack_Decoder(const std::string& raw)
      : TypedProtoDecoder(reinterpret_cast<const uint8_t*>(raw.data()),
                          raw.size()) {}
  explicit Callstack_Decoder(const ::protozero::ConstBytes& raw)
      : TypedProtoDecoder(raw.data, raw.size) {}
  bool has_iid() const { return at<1>().valid(); }
  uint64_t iid() const { return at<1>().as_uint64(); }
  bool has_frame_ids() const { return at<2>().valid(); }
  ::protozero::RepeatedFieldIterator<uint64_t> frame_ids() const {
    return GetRepeated<uint64_t>(2);
  }
};

class Callstack : public ::protozero::Message {
 public:
  using Decoder = Callstack_Decoder;
  enum : int32_t {
    kIidFieldNumber = 1,
    kFrameIdsFieldNumber = 2,
  };
  static constexpr const char* GetName() {
    return ".perfetto.protos.Callstack";
  }

  using FieldMetadata_Iid = ::protozero::proto_utils::FieldMetadata<
      1,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Callstack>;

  static constexpr FieldMetadata_Iid kIid{};
  void set_iid(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_Iid::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_FrameIds = ::protozero::proto_utils::FieldMetadata<
      2,
      ::protozero::proto_utils::RepetitionType::kRepeatedNotPacked,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Callstack>;

  static constexpr FieldMetadata_FrameIds kFrameIds{};
  void add_frame_ids(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_FrameIds::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }
};

class Frame_Decoder : public ::protozero::TypedProtoDecoder<
                          /*MAX_FIELD_ID=*/4,
                          /*HAS_NONPACKED_REPEATED_FIELDS=*/false> {
 public:
  Frame_Decoder(const uint8_t* data, size_t len)
      : TypedProtoDecoder(data, len) {}
  explicit Frame_Decoder(const std::string& raw)
      : TypedProtoDecoder(reinterpret_cast<const uint8_t*>(raw.data()),
                          raw.size()) {}
  explicit Frame_Decoder(const ::protozero::ConstBytes& raw)
      : TypedProtoDecoder(raw.data, raw.size) {}
  bool has_iid() const { return at<1>().valid(); }
  uint64_t iid() const { return at<1>().as_uint64(); }
  bool has_function_name_id() const { return at<2>().valid(); }
  uint64_t function_name_id() const { return at<2>().as_uint64(); }
  bool has_mapping_id() const { return at<3>().valid(); }
  uint64_t mapping_id() const { return at<3>().as_uint64(); }
  bool has_rel_pc() const { return at<4>().valid(); }
  uint64_t rel_pc() const { return at<4>().as_uint64(); }
};

class Frame : public ::protozero::Message {
 public:
  using Decoder = Frame_Decoder;
  enum : int32_t {
    kIidFieldNumber = 1,
    kFunctionNameIdFieldNumber = 2,
    kMappingIdFieldNumber = 3,
    kRelPcFieldNumber = 4,
  };
  static constexpr const char* GetName() { return ".perfetto.protos.Frame"; }

  using FieldMetadata_Iid = ::protozero::proto_utils::FieldMetadata<
      1,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Frame>;

  static constexpr FieldMetadata_Iid kIid{};
  void set_iid(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_Iid::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_FunctionNameId = ::protozero::proto_utils::FieldMetadata<
      2,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Frame>;

  static constexpr FieldMetadata_FunctionNameId kFunctionNameId{};
  void set_function_name_id(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_FunctionNameId::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_MappingId = ::protozero::proto_utils::FieldMetadata<
      3,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Frame>;

  static constexpr FieldMetadata_MappingId kMappingId{};
  void set_mapping_id(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_MappingId::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_RelPc = ::protozero::proto_utils::FieldMetadata<
      4,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Frame>;

  static constexpr FieldMetadata_RelPc kRelPc{};
  void set_rel_pc(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_RelPc::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }
};

class Mapping_Decoder : public ::protozero::TypedProtoDecoder<
                            /*MAX_FIELD_ID=*/7,
                            /*HAS_NONPACKED_REPEATED_FIELDS=*/true> {
 public:
  Mapping_Decoder(const uint8_t* data, size_t len)
      : TypedProtoDecoder(data, len) {}
  explicit Mapping_Decoder(const std::string& raw)
      : TypedProtoDecoder(reinterpret_cast<const uint8_t*>(raw.data()),
                          raw.size()) {}
  explicit Mapping_Decoder(const ::protozero::ConstBytes& raw)
      : TypedProtoDecoder(raw.data, raw.size) {}
  bool has_iid() const { return at<1>().valid(); }
  uint64_t iid() const { return at<1>().as_uint64(); }
  bool has_path_string_ids() const { return at<7>().valid(); }
  ::protozero::RepeatedFieldIterator<uint64_t> path_string_ids() const {
    return GetRepeated<uint64_t>(7);
  }
};

class Mapping : public ::protozero::Message {
 public:
  using Decoder = Mapping_Decoder;
  enum : int32_t {
    kIidFieldNumber = 1,
    kPathStringIdsFieldNumber = 7,
  };
  static constexpr const char* GetName() { return ".perfetto.protos.Mapping"; }

  using FieldMetadata_Iid = ::protozero::proto_utils::FieldMetadata<
      1,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Mapping>;

  static constexpr FieldMetadata_Iid kIid{};
  void set_iid(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_Iid::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_PathStringIds = ::protozero::proto_utils::FieldMetadata<
      7,
      ::protozero::proto_utils::RepetitionType::kRepeatedNotPacked,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      Mapping>;

  static constexpr FieldMetadata_PathStringIds kPathStringIds{};
  void add_path_string_ids(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_PathStringIds::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }
};

class InternedString_Decoder : public ::protozero::TypedProtoDecoder<
                                   /*MAX_FIELD_ID=*/2,
                                   /*HAS_NONPACKED_REPEATED_FIELDS=*/false> {
 public:
  InternedString_Decoder(const uint8_t* data, size_t len)
      : TypedProtoDecoder(data, len) {}
  explicit InternedString_Decoder(const std::string& raw)
      : TypedProtoDecoder(reinterpret_cast<const uint8_t*>(raw.data()),
                          raw.size()) {}
  explicit InternedString_Decoder(const ::protozero::ConstBytes& raw)
      : TypedProtoDecoder(raw.data, raw.size) {}
  bool has_iid() const { return at<1>().valid(); }
  uint64_t iid() const { return at<1>().as_uint64(); }
  bool has_str() const { return at<2>().valid(); }
  ::protozero::ConstBytes str() const { return at<2>().as_bytes(); }
};

class InternedString : public ::protozero::Message {
 public:
  using Decoder = InternedString_Decoder;
  enum : int32_t {
    kIidFieldNumber = 1,
    kStrFieldNumber = 2,
  };
  static constexpr const char* GetName() {
    return ".perfetto.protos.InternedString";
  }

  using FieldMetadata_Iid = ::protozero::proto_utils::FieldMetadata<
      1,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      InternedString>;

  static constexpr FieldMetadata_Iid kIid{};
  void set_iid(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_Iid::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_Str = ::protozero::proto_utils::FieldMetadata<
      2,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kBytes,
      std::string,
      InternedString>;

  static constexpr FieldMetadata_Str kStr{};
  void set_str(const uint8_t* data, size_t size) {
    AppendBytes(FieldMetadata_Str::kFieldId, data, size);
  }
  void set_str(::protozero::ConstBytes bytes) {
    AppendBytes(FieldMetadata_Str::kFieldId, bytes.data, bytes.size);
  }
  void set_str(std::string value) {
    static constexpr uint32_t field_id = FieldMetadata_Str::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kBytes>::Append(*this,
                                                                   field_id,
                                                                   value);
  }
};

}  // namespace pbzero
}  // namespace protos
}  // namespace perfetto
#endif  // Include guard.
