/* Copyright 2020-2021 IGEL Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef DLM_PROTOCOL_H
#define DLM_PROTOCOL_H

#include <stdbool.h>

enum dlm_opcode {
	DLM_GET_LEASE,
	DLM_RELEASE_LEASE,
};

struct dlm_client_request {
	enum dlm_opcode opcode;
};

bool receive_dlm_client_request(int socket, struct dlm_client_request *request);
bool send_dlm_client_request(int socket, struct dlm_client_request *request);
int receive_lease_fd(int socket);
bool send_lease_fd(int socket, int lease);
#endif
