#!/usr/bin/env python3
# /********************************************************************************
# * Copyright (c) 2025 Contributors to the Eclipse Foundation
# *
# * See the NOTICE file(s) distributed with this work for additional
# * information regarding copyright ownership.
# *
# * This program and the accompanying materials are made available under the
# * terms of the Apache License 2.0 which is available at
# * http://www.apache.org/licenses/LICENSE-2.0
# *
# * SPDX-License-Identifier: Apache-2.0
# ********************************************************************************/
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from kuksa.val.v1 import val_pb2 as kuksa_dot_val_dot_v1_dot_val__pb2

GRPC_GENERATED_VERSION = '1.71.0'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in kuksa/val/v1/val_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class VALStub(object):
    """Note on authorization:
    Tokens (auth-token or auth-uuid) are sent as (GRPC / http2) metadata.

    The auth-token is a JWT compliant token as the examples found here:
    https://github.com/eclipse-kuksa/kuksa-databroker/tree/main/certificates/jwt

    See also https://github.com/eclipse-kuksa/kuksa-databroker/blob/main/doc/authorization.md#jwt-access-token

    Upon reception of auth-token, server shall generate an auth-uuid in metadata
    that the client can use instead of auth-token in subsequent calls.

    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Get = channel.unary_unary(
                '/kuksa.val.v1.VAL/Get',
                request_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetRequest.SerializeToString,
                response_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetResponse.FromString,
                _registered_method=True)
        self.Set = channel.unary_unary(
                '/kuksa.val.v1.VAL/Set',
                request_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.SetRequest.SerializeToString,
                response_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.SetResponse.FromString,
                _registered_method=True)
        self.StreamedUpdate = channel.stream_stream(
                '/kuksa.val.v1.VAL/StreamedUpdate',
                request_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.StreamedUpdateRequest.SerializeToString,
                response_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.StreamedUpdateResponse.FromString,
                _registered_method=True)
        self.Subscribe = channel.unary_stream(
                '/kuksa.val.v1.VAL/Subscribe',
                request_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.SubscribeRequest.SerializeToString,
                response_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.SubscribeResponse.FromString,
                _registered_method=True)
        self.GetServerInfo = channel.unary_unary(
                '/kuksa.val.v1.VAL/GetServerInfo',
                request_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetServerInfoRequest.SerializeToString,
                response_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetServerInfoResponse.FromString,
                _registered_method=True)


class VALServicer(object):
    """Note on authorization:
    Tokens (auth-token or auth-uuid) are sent as (GRPC / http2) metadata.

    The auth-token is a JWT compliant token as the examples found here:
    https://github.com/eclipse-kuksa/kuksa-databroker/tree/main/certificates/jwt

    See also https://github.com/eclipse-kuksa/kuksa-databroker/blob/main/doc/authorization.md#jwt-access-token

    Upon reception of auth-token, server shall generate an auth-uuid in metadata
    that the client can use instead of auth-token in subsequent calls.

    """

    def Get(self, request, context):
        """Get entries
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Set(self, request, context):
        """Set entries
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def StreamedUpdate(self, request_iterator, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Subscribe(self, request, context):
        """Subscribe to a set of entries

        Returns a stream of notifications.

        InvalidArgument is returned if the request is malformed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetServerInfo(self, request, context):
        """Shall return information that allows the client to determine
        what server/server implementation/version it is talking to
        eg. kuksa-databroker 0.5.1
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_VALServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetRequest.FromString,
                    response_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetResponse.SerializeToString,
            ),
            'Set': grpc.unary_unary_rpc_method_handler(
                    servicer.Set,
                    request_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.SetRequest.FromString,
                    response_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.SetResponse.SerializeToString,
            ),
            'StreamedUpdate': grpc.stream_stream_rpc_method_handler(
                    servicer.StreamedUpdate,
                    request_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.StreamedUpdateRequest.FromString,
                    response_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.StreamedUpdateResponse.SerializeToString,
            ),
            'Subscribe': grpc.unary_stream_rpc_method_handler(
                    servicer.Subscribe,
                    request_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.SubscribeRequest.FromString,
                    response_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.SubscribeResponse.SerializeToString,
            ),
            'GetServerInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetServerInfo,
                    request_deserializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetServerInfoRequest.FromString,
                    response_serializer=kuksa_dot_val_dot_v1_dot_val__pb2.GetServerInfoResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'kuksa.val.v1.VAL', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('kuksa.val.v1.VAL', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class VAL(object):
    """Note on authorization:
    Tokens (auth-token or auth-uuid) are sent as (GRPC / http2) metadata.

    The auth-token is a JWT compliant token as the examples found here:
    https://github.com/eclipse-kuksa/kuksa-databroker/tree/main/certificates/jwt

    See also https://github.com/eclipse-kuksa/kuksa-databroker/blob/main/doc/authorization.md#jwt-access-token

    Upon reception of auth-token, server shall generate an auth-uuid in metadata
    that the client can use instead of auth-token in subsequent calls.

    """

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/kuksa.val.v1.VAL/Get',
            kuksa_dot_val_dot_v1_dot_val__pb2.GetRequest.SerializeToString,
            kuksa_dot_val_dot_v1_dot_val__pb2.GetResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Set(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/kuksa.val.v1.VAL/Set',
            kuksa_dot_val_dot_v1_dot_val__pb2.SetRequest.SerializeToString,
            kuksa_dot_val_dot_v1_dot_val__pb2.SetResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def StreamedUpdate(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/kuksa.val.v1.VAL/StreamedUpdate',
            kuksa_dot_val_dot_v1_dot_val__pb2.StreamedUpdateRequest.SerializeToString,
            kuksa_dot_val_dot_v1_dot_val__pb2.StreamedUpdateResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Subscribe(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/kuksa.val.v1.VAL/Subscribe',
            kuksa_dot_val_dot_v1_dot_val__pb2.SubscribeRequest.SerializeToString,
            kuksa_dot_val_dot_v1_dot_val__pb2.SubscribeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetServerInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/kuksa.val.v1.VAL/GetServerInfo',
            kuksa_dot_val_dot_v1_dot_val__pb2.GetServerInfoRequest.SerializeToString,
            kuksa_dot_val_dot_v1_dot_val__pb2.GetServerInfoResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
