#!/usr/bin/env python3
# /********************************************************************************
# * Copyright (c) 2025 Contributors to the Eclipse Foundation
# *
# * See the NOTICE file(s) distributed with this work for additional
# * information regarding copyright ownership.
# *
# * This program and the accompanying materials are made available under the
# * terms of the Apache License 2.0 which is available at
# * http://www.apache.org/licenses/LICENSE-2.0
# *
# * SPDX-License-Identifier: Apache-2.0
# ********************************************************************************/
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*******************************************************************************
Copyright (c) 2022 Contributors to the Eclipse Foundation

See the NOTICE file(s) distributed with this work for additional
information regarding copyright ownership.

This program and the accompanying materials are made available under the
terms of the Apache License 2.0 which is available at
http://www.apache.org/licenses/LICENSE-2.0

SPDX-License-Identifier: Apache-2.0
******************************************************************************
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import gen_proto.sdv.databroker.v1.types_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetDatapointsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATAPOINTS_FIELD_NUMBER: builtins.int
    @property
    def datapoints(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of requested data points."""

    def __init__(
        self,
        *,
        datapoints: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["datapoints", b"datapoints"]) -> None: ...

global___GetDatapointsRequest = GetDatapointsRequest

@typing.final
class GetDatapointsReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DatapointsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> sdv.databroker.v1.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: sdv.databroker.v1.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATAPOINTS_FIELD_NUMBER: builtins.int
    @property
    def datapoints(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, sdv.databroker.v1.types_pb2.Datapoint]:
        """Contains the values of the requested data points.
        If a requested data point is not available, the corresponding Datapoint
        will have the respective failure value set.
        """

    def __init__(
        self,
        *,
        datapoints: collections.abc.Mapping[builtins.str, sdv.databroker.v1.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["datapoints", b"datapoints"]) -> None: ...

global___GetDatapointsReply = GetDatapointsReply

@typing.final
class SetDatapointsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DatapointsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> sdv.databroker.v1.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: sdv.databroker.v1.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DATAPOINTS_FIELD_NUMBER: builtins.int
    @property
    def datapoints(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, sdv.databroker.v1.types_pb2.Datapoint]:
        """A map of data points to set"""

    def __init__(
        self,
        *,
        datapoints: collections.abc.Mapping[builtins.str, sdv.databroker.v1.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["datapoints", b"datapoints"]) -> None: ...

global___SetDatapointsRequest = SetDatapointsRequest

@typing.final
class SetDatapointsReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ErrorsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: sdv.databroker.v1.types_pb2.DatapointError.ValueType
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: sdv.databroker.v1.types_pb2.DatapointError.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ERRORS_FIELD_NUMBER: builtins.int
    @property
    def errors(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, sdv.databroker.v1.types_pb2.DatapointError.ValueType]:
        """A map of errors (if any)"""

    def __init__(
        self,
        *,
        errors: collections.abc.Mapping[builtins.str, sdv.databroker.v1.types_pb2.DatapointError.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["errors", b"errors"]) -> None: ...

global___SetDatapointsReply = SetDatapointsReply

@typing.final
class SubscribeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_FIELD_NUMBER: builtins.int
    query: builtins.str
    """Subscribe to a set of data points (or expressions) described
    by the provided query.
    The query syntax is a subset of SQL and is described in more
    detail in the QUERY.md file.
    """
    def __init__(
        self,
        *,
        query: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["query", b"query"]) -> None: ...

global___SubscribeRequest = SubscribeRequest

@typing.final
class SubscribeReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FieldsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> sdv.databroker.v1.types_pb2.Datapoint: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: sdv.databroker.v1.types_pb2.Datapoint | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FIELDS_FIELD_NUMBER: builtins.int
    @property
    def fields(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, sdv.databroker.v1.types_pb2.Datapoint]:
        """Contains the fields specified by the query.
        If a requested data point value is not available, the corresponding
        Datapoint will have it's respective failure value set.
        """

    def __init__(
        self,
        *,
        fields: collections.abc.Mapping[builtins.str, sdv.databroker.v1.types_pb2.Datapoint] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["fields", b"fields"]) -> None: ...

global___SubscribeReply = SubscribeReply

@typing.final
class GetMetadataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMES_FIELD_NUMBER: builtins.int
    @property
    def names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Request metadata for a list of data points referenced by their names.
        e.g. "Vehicle.Cabin.Seat.Row1.Pos1.Position" or "Vehicle.Speed".

        If no names are provided, metadata for all known data points will be
        returned.
        """

    def __init__(
        self,
        *,
        names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["names", b"names"]) -> None: ...

global___GetMetadataRequest = GetMetadataRequest

@typing.final
class GetMetadataReply(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIST_FIELD_NUMBER: builtins.int
    @property
    def list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sdv.databroker.v1.types_pb2.Metadata]:
        """Contains metadata of the requested data points. If a data point
        doesn't exist (i.e. not known to the Data Broker) the corresponding
        Metadata isn't part of the returned list.
        """

    def __init__(
        self,
        *,
        list: collections.abc.Iterable[sdv.databroker.v1.types_pb2.Metadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["list", b"list"]) -> None: ...

global___GetMetadataReply = GetMetadataReply
