#!/usr/bin/env python3
# /********************************************************************************
# * Copyright (c) 2025 Contributors to the Eclipse Foundation
# *
# * See the NOTICE file(s) distributed with this work for additional
# * information regarding copyright ownership.
# *
# * This program and the accompanying materials are made available under the
# * terms of the Apache License 2.0 which is available at
# * http://www.apache.org/licenses/LICENSE-2.0
# *
# * SPDX-License-Identifier: Apache-2.0
# ********************************************************************************/
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from gen_proto.sdv.databroker.v1 import broker_pb2 as sdv_dot_databroker_dot_v1_dot_broker__pb2

GRPC_GENERATED_VERSION = '1.71.0'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in sdv/databroker/v1/broker_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class BrokerStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetDatapoints = channel.unary_unary(
                '/sdv.databroker.v1.Broker/GetDatapoints',
                request_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetDatapointsRequest.SerializeToString,
                response_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetDatapointsReply.FromString,
                _registered_method=True)
        self.SetDatapoints = channel.unary_unary(
                '/sdv.databroker.v1.Broker/SetDatapoints',
                request_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SetDatapointsRequest.SerializeToString,
                response_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SetDatapointsReply.FromString,
                _registered_method=True)
        self.Subscribe = channel.unary_stream(
                '/sdv.databroker.v1.Broker/Subscribe',
                request_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SubscribeRequest.SerializeToString,
                response_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SubscribeReply.FromString,
                _registered_method=True)
        self.GetMetadata = channel.unary_unary(
                '/sdv.databroker.v1.Broker/GetMetadata',
                request_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetMetadataRequest.SerializeToString,
                response_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetMetadataReply.FromString,
                _registered_method=True)


class BrokerServicer(object):
    """Missing associated documentation comment in .proto file."""

    def GetDatapoints(self, request, context):
        """Request a set of datapoints (values)

        Returns a list of requested data points.

        InvalidArgument is returned if the request is malformed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetDatapoints(self, request, context):
        """Set a datapoint (values)
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Subscribe(self, request, context):
        """Subscribe to a set of data points or conditional expressions
        using the Data Broker Query Syntax (described in QUERY.md)

        Returns a stream of replies.

        InvalidArgument is returned if the request is malformed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetMetadata(self, request, context):
        """Request the metadata of a set of datapoints

        Returns metadata of the requested data points that exist.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_BrokerServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetDatapoints': grpc.unary_unary_rpc_method_handler(
                    servicer.GetDatapoints,
                    request_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetDatapointsRequest.FromString,
                    response_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetDatapointsReply.SerializeToString,
            ),
            'SetDatapoints': grpc.unary_unary_rpc_method_handler(
                    servicer.SetDatapoints,
                    request_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SetDatapointsRequest.FromString,
                    response_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SetDatapointsReply.SerializeToString,
            ),
            'Subscribe': grpc.unary_stream_rpc_method_handler(
                    servicer.Subscribe,
                    request_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SubscribeRequest.FromString,
                    response_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.SubscribeReply.SerializeToString,
            ),
            'GetMetadata': grpc.unary_unary_rpc_method_handler(
                    servicer.GetMetadata,
                    request_deserializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetMetadataRequest.FromString,
                    response_serializer=sdv_dot_databroker_dot_v1_dot_broker__pb2.GetMetadataReply.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'sdv.databroker.v1.Broker', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('sdv.databroker.v1.Broker', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class Broker(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def GetDatapoints(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/sdv.databroker.v1.Broker/GetDatapoints',
            sdv_dot_databroker_dot_v1_dot_broker__pb2.GetDatapointsRequest.SerializeToString,
            sdv_dot_databroker_dot_v1_dot_broker__pb2.GetDatapointsReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SetDatapoints(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/sdv.databroker.v1.Broker/SetDatapoints',
            sdv_dot_databroker_dot_v1_dot_broker__pb2.SetDatapointsRequest.SerializeToString,
            sdv_dot_databroker_dot_v1_dot_broker__pb2.SetDatapointsReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Subscribe(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/sdv.databroker.v1.Broker/Subscribe',
            sdv_dot_databroker_dot_v1_dot_broker__pb2.SubscribeRequest.SerializeToString,
            sdv_dot_databroker_dot_v1_dot_broker__pb2.SubscribeReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetMetadata(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/sdv.databroker.v1.Broker/GetMetadata',
            sdv_dot_databroker_dot_v1_dot_broker__pb2.GetMetadataRequest.SerializeToString,
            sdv_dot_databroker_dot_v1_dot_broker__pb2.GetMetadataReply.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
