package org.maplibre.android.integration

import androidx.test.filters.LargeTest
import androidx.test.internal.runner.junit4.AndroidJUnit4ClassRunner
import androidx.test.rule.ActivityTestRule
import org.junit.Ignore
import org.maplibre.android.testapp.activity.textureview.TextureViewDebugModeActivity
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

/**
 * Regression test that validates reopening an Activity with a TextureView
 */
@RunWith(AndroidJUnit4ClassRunner::class)
class TextureViewReopenTest : BaseIntegrationTest() {

    @get:Rule
    var activityRule: ActivityTestRule<TextureViewDebugModeActivity> = ActivityTestRule(TextureViewDebugModeActivity::class.java)

    @Test
    @LargeTest
    fun reopenTextureViewDebugActivity() {
        device.waitForIdle()
        device.pressHome()
        device.waitForIdle()
        device.launchActivity(activityRule.activity, TextureViewDebugModeActivity::class.java)
        device.waitForIdle()
    }
}
