#!/usr/bin/env bash

set -u

LIST=(
    "Noto Sans Regular/0-255.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/0-255.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/256-511.pbf"
    "Roboto Medium,Noto Sans Regular/0-255.pbf"
    "Roboto Medium,Noto Sans Regular/65024-65279.pbf"
    "Roboto Medium,Noto Sans Regular/11520-11775.pbf"
    "Roboto Regular,Noto Sans Regular/0-255.pbf"
    "Roboto Regular,Noto Sans Regular/256-511.pbf"
    "Roboto Regular,Noto Sans Regular/512-767.pbf"
    "Roboto Regular,Noto Sans Regular/768-1023.pbf"
    "Roboto Regular,Noto Sans Regular/1024-1279.pbf"
    "Roboto Regular,Noto Sans Regular/8192-8447.pbf"
    "Roboto Medium,Noto Sans Regular/256-511.pbf"
    "Roboto Medium,Noto Sans Regular/512-767.pbf"
    "Roboto Medium,Noto Sans Regular/768-1023.pbf"
    "Roboto Medium,Noto Sans Regular/1024-1279.pbf"

    # Observed from dynamic benchmark
    "Noto Sans Regular/19968-20223.pbf"
    "Noto Sans Regular/22016-22271.pbf"
    "Noto Sans Regular/22272-22527.pbf"
    "Noto Sans Regular/26368-26623.pbf"
    "Noto Sans Regular/26624-26879.pbf"
    "Noto Sans Regular/27904-28159.pbf"
    "Noto Sans Regular/34304-34559.pbf"
    "Noto Sans Regular/38400-38655.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/512-767.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/7680-7935.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/8192-8447.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/19968-20223.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/20224-20479.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/20480-20735.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/20736-20991.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/20992-21247.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/21248-21503.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/21504-21759.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/22016-22271.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/22272-22527.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/22528-22783.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/22784-23039.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/23296-23551.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/23552-23807.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/23808-24063.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/24064-24319.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/24320-24575.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/25088-25343.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/25344-25599.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/25856-26111.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/26112-26367.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/26368-26623.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/26624-26879.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/26880-27135.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/27136-27391.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/27392-27647.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/27648-27903.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/27904-28159.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/28160-28415.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/28416-28671.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/29184-29439.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/29440-29695.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/29696-29951.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/29952-30207.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/30208-30463.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/30464-30719.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/30720-30975.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/30976-31231.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/31232-31487.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/31488-31743.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/31744-31999.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/32000-32255.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/32256-32511.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/32512-32767.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/32768-33023.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/33280-33535.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/33536-33791.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/34304-34559.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/34816-35071.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/35072-35327.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/35584-35839.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/35840-36095.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/36096-36351.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/36608-36863.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/36864-37119.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/37120-37375.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/37888-38143.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/38144-38399.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/38400-38655.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/38656-38911.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/38912-39167.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/39168-39423.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/39424-39679.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/39936-40191.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/40448-40703.pbf"
    "Roboto Condensed Italic,Noto Sans Italic/40704-40959.pbf"
    "Roboto Medium,Noto Sans Regular/1536-1791.pbf"
    "Roboto Medium,Noto Sans Regular/1792-2047.pbf"
    "Roboto Medium,Noto Sans Regular/2304-2559.pbf"
    "Roboto Medium,Noto Sans Regular/2816-3071.pbf"
    "Roboto Medium,Noto Sans Regular/3584-3839.pbf"
    "Roboto Medium,Noto Sans Regular/3840-4095.pbf"
    "Roboto Medium,Noto Sans Regular/4096-4351.pbf"
    "Roboto Medium,Noto Sans Regular/5888-6143.pbf"
    "Roboto Medium,Noto Sans Regular/6144-6399.pbf"
    "Roboto Medium,Noto Sans Regular/7680-7935.pbf"
    "Roboto Medium,Noto Sans Regular/8192-8447.pbf"
    "Roboto Medium,Noto Sans Regular/19968-20223.pbf"
    "Roboto Medium,Noto Sans Regular/20224-20479.pbf"
    "Roboto Medium,Noto Sans Regular/20736-20991.pbf"
    "Roboto Medium,Noto Sans Regular/20992-21247.pbf"
    "Roboto Medium,Noto Sans Regular/21248-21503.pbf"
    "Roboto Medium,Noto Sans Regular/21504-21759.pbf"
    "Roboto Medium,Noto Sans Regular/21760-22015.pbf"
    "Roboto Medium,Noto Sans Regular/22016-22271.pbf"
    "Roboto Medium,Noto Sans Regular/22272-22527.pbf"
    "Roboto Medium,Noto Sans Regular/22528-22783.pbf"
    "Roboto Medium,Noto Sans Regular/22784-23039.pbf"
    "Roboto Medium,Noto Sans Regular/23040-23295.pbf"
    "Roboto Medium,Noto Sans Regular/23296-23551.pbf"
    "Roboto Medium,Noto Sans Regular/23552-23807.pbf"
    "Roboto Medium,Noto Sans Regular/23808-24063.pbf"
    "Roboto Medium,Noto Sans Regular/24064-24319.pbf"
    "Roboto Medium,Noto Sans Regular/24320-24575.pbf"
    "Roboto Medium,Noto Sans Regular/24576-24831.pbf"
    "Roboto Medium,Noto Sans Regular/24832-25087.pbf"
    "Roboto Medium,Noto Sans Regular/25088-25343.pbf"
    "Roboto Medium,Noto Sans Regular/25856-26111.pbf"
    "Roboto Medium,Noto Sans Regular/26112-26367.pbf"
    "Roboto Medium,Noto Sans Regular/26368-26623.pbf"
    "Roboto Medium,Noto Sans Regular/26624-26879.pbf"
    "Roboto Medium,Noto Sans Regular/26880-27135.pbf"
    "Roboto Medium,Noto Sans Regular/27136-27391.pbf"
    "Roboto Medium,Noto Sans Regular/27392-27647.pbf"
    "Roboto Medium,Noto Sans Regular/27648-27903.pbf"
    "Roboto Medium,Noto Sans Regular/27904-28159.pbf"
    "Roboto Medium,Noto Sans Regular/28160-28415.pbf"
    "Roboto Medium,Noto Sans Regular/28416-28671.pbf"
    "Roboto Medium,Noto Sans Regular/28672-28927.pbf"
    "Roboto Medium,Noto Sans Regular/28928-29183.pbf"
    "Roboto Medium,Noto Sans Regular/29184-29439.pbf"
    "Roboto Medium,Noto Sans Regular/29440-29695.pbf"
    "Roboto Medium,Noto Sans Regular/29696-29951.pbf"
    "Roboto Medium,Noto Sans Regular/29952-30207.pbf"
    "Roboto Medium,Noto Sans Regular/30208-30463.pbf"
    "Roboto Medium,Noto Sans Regular/30464-30719.pbf"
    "Roboto Medium,Noto Sans Regular/30976-31231.pbf"
    "Roboto Medium,Noto Sans Regular/31232-31487.pbf"
    "Roboto Medium,Noto Sans Regular/32256-32511.pbf"
    "Roboto Medium,Noto Sans Regular/32512-32767.pbf"
    "Roboto Medium,Noto Sans Regular/32768-33023.pbf"
    "Roboto Medium,Noto Sans Regular/33024-33279.pbf"
    "Roboto Medium,Noto Sans Regular/33280-33535.pbf"
    "Roboto Medium,Noto Sans Regular/33536-33791.pbf"
    "Roboto Medium,Noto Sans Regular/33792-34047.pbf"
    "Roboto Medium,Noto Sans Regular/34048-34303.pbf"
    "Roboto Medium,Noto Sans Regular/34304-34559.pbf"
    "Roboto Medium,Noto Sans Regular/34816-35071.pbf"
    "Roboto Medium,Noto Sans Regular/35072-35327.pbf"
    "Roboto Medium,Noto Sans Regular/35584-35839.pbf"
    "Roboto Medium,Noto Sans Regular/36096-36351.pbf"
    "Roboto Medium,Noto Sans Regular/36608-36863.pbf"
    "Roboto Medium,Noto Sans Regular/36864-37119.pbf"
    "Roboto Medium,Noto Sans Regular/37120-37375.pbf"
    "Roboto Medium,Noto Sans Regular/37888-38143.pbf"
    "Roboto Medium,Noto Sans Regular/38144-38399.pbf"
    "Roboto Medium,Noto Sans Regular/38400-38655.pbf"
    "Roboto Medium,Noto Sans Regular/38656-38911.pbf"
    "Roboto Medium,Noto Sans Regular/38912-39167.pbf"
    "Roboto Medium,Noto Sans Regular/39168-39423.pbf"
    "Roboto Medium,Noto Sans Regular/39424-39679.pbf"
    "Roboto Medium,Noto Sans Regular/40448-40703.pbf"
    "Roboto Medium,Noto Sans Regular/40704-40959.pbf"
    "Roboto Medium,Noto Sans Regular/40960-41215.pbf"
    "Roboto Medium,Noto Sans Regular/41728-41983.pbf"
    "Roboto Medium,Noto Sans Regular/44032-44287.pbf"
    "Roboto Medium,Noto Sans Regular/44288-44543.pbf"
    "Roboto Medium,Noto Sans Regular/44544-44799.pbf"
    "Roboto Medium,Noto Sans Regular/45056-45311.pbf"
    "Roboto Medium,Noto Sans Regular/45824-46079.pbf"
    "Roboto Medium,Noto Sans Regular/46848-47103.pbf"
    "Roboto Medium,Noto Sans Regular/47616-47871.pbf"
    "Roboto Medium,Noto Sans Regular/48384-48639.pbf"
    "Roboto Medium,Noto Sans Regular/49152-49407.pbf"
    "Roboto Medium,Noto Sans Regular/49408-49663.pbf"
    "Roboto Medium,Noto Sans Regular/49664-49919.pbf"
    "Roboto Medium,Noto Sans Regular/50432-50687.pbf"
    "Roboto Medium,Noto Sans Regular/50688-50943.pbf"
    "Roboto Medium,Noto Sans Regular/50944-51199.pbf"
    "Roboto Medium,Noto Sans Regular/51200-51455.pbf"
    "Roboto Medium,Noto Sans Regular/52224-52479.pbf"
    "Roboto Medium,Noto Sans Regular/54016-54271.pbf"
    "Roboto Medium,Noto Sans Regular/54528-54783.pbf"
    "Roboto Medium,Noto Sans Regular/54784-55039.pbf"
    "Roboto Medium,Noto Sans Regular/55040-55295.pbf"
    "Roboto Medium,Noto Sans Regular/64256-64511.pbf"
    "Roboto Regular,Noto Sans Regular/2816-3071.pbf"
    "Roboto Regular,Noto Sans Regular/3072-3327.pbf"
    "Roboto Regular,Noto Sans Regular/7680-7935.pbf"
    "Roboto Regular,Noto Sans Regular/12288-12543.pbf"
    "Roboto Regular,Noto Sans Regular/19968-20223.pbf"
    "Roboto Regular,Noto Sans Regular/20224-20479.pbf"
    "Roboto Regular,Noto Sans Regular/20480-20735.pbf"
    "Roboto Regular,Noto Sans Regular/20736-20991.pbf"
    "Roboto Regular,Noto Sans Regular/20992-21247.pbf"
    "Roboto Regular,Noto Sans Regular/21248-21503.pbf"
    "Roboto Regular,Noto Sans Regular/21504-21759.pbf"
    "Roboto Regular,Noto Sans Regular/21760-22015.pbf"
    "Roboto Regular,Noto Sans Regular/22016-22271.pbf"
    "Roboto Regular,Noto Sans Regular/22272-22527.pbf"
    "Roboto Regular,Noto Sans Regular/22528-22783.pbf"
    "Roboto Regular,Noto Sans Regular/22784-23039.pbf"
    "Roboto Regular,Noto Sans Regular/23040-23295.pbf"
    "Roboto Regular,Noto Sans Regular/23296-23551.pbf"
    "Roboto Regular,Noto Sans Regular/23552-23807.pbf"
    "Roboto Regular,Noto Sans Regular/23808-24063.pbf"
    "Roboto Regular,Noto Sans Regular/24064-24319.pbf"
    "Roboto Regular,Noto Sans Regular/24320-24575.pbf"
    "Roboto Regular,Noto Sans Regular/24576-24831.pbf"
    "Roboto Regular,Noto Sans Regular/24832-25087.pbf"
    "Roboto Regular,Noto Sans Regular/25088-25343.pbf"
    "Roboto Regular,Noto Sans Regular/25344-25599.pbf"
    "Roboto Regular,Noto Sans Regular/25856-26111.pbf"
    "Roboto Regular,Noto Sans Regular/26112-26367.pbf"
    "Roboto Regular,Noto Sans Regular/26368-26623.pbf"
    "Roboto Regular,Noto Sans Regular/26624-26879.pbf"
    "Roboto Regular,Noto Sans Regular/26880-27135.pbf"
    "Roboto Regular,Noto Sans Regular/27136-27391.pbf"
    "Roboto Regular,Noto Sans Regular/27392-27647.pbf"
    "Roboto Regular,Noto Sans Regular/27648-27903.pbf"
    "Roboto Regular,Noto Sans Regular/27904-28159.pbf"
    "Roboto Regular,Noto Sans Regular/28160-28415.pbf"
    "Roboto Regular,Noto Sans Regular/28416-28671.pbf"
    "Roboto Regular,Noto Sans Regular/28672-28927.pbf"
    "Roboto Regular,Noto Sans Regular/28928-29183.pbf"
    "Roboto Regular,Noto Sans Regular/29184-29439.pbf"
    "Roboto Regular,Noto Sans Regular/29440-29695.pbf"
    "Roboto Regular,Noto Sans Regular/29696-29951.pbf"
    "Roboto Regular,Noto Sans Regular/29952-30207.pbf"
    "Roboto Regular,Noto Sans Regular/30208-30463.pbf"
    "Roboto Regular,Noto Sans Regular/30464-30719.pbf"
    "Roboto Regular,Noto Sans Regular/30720-30975.pbf"
    "Roboto Regular,Noto Sans Regular/30976-31231.pbf"
    "Roboto Regular,Noto Sans Regular/31232-31487.pbf"
    "Roboto Regular,Noto Sans Regular/31488-31743.pbf"
    "Roboto Regular,Noto Sans Regular/31744-31999.pbf"
    "Roboto Regular,Noto Sans Regular/32000-32255.pbf"
    "Roboto Regular,Noto Sans Regular/32256-32511.pbf"
    "Roboto Regular,Noto Sans Regular/32512-32767.pbf"
    "Roboto Regular,Noto Sans Regular/32768-33023.pbf"
    "Roboto Regular,Noto Sans Regular/33024-33279.pbf"
    "Roboto Regular,Noto Sans Regular/33280-33535.pbf"
    "Roboto Regular,Noto Sans Regular/33536-33791.pbf"
    "Roboto Regular,Noto Sans Regular/33792-34047.pbf"
    "Roboto Regular,Noto Sans Regular/34048-34303.pbf"
    "Roboto Regular,Noto Sans Regular/34304-34559.pbf"
    "Roboto Regular,Noto Sans Regular/34560-34815.pbf"
    "Roboto Regular,Noto Sans Regular/34816-35071.pbf"
    "Roboto Regular,Noto Sans Regular/35072-35327.pbf"
    "Roboto Regular,Noto Sans Regular/35584-35839.pbf"
    "Roboto Regular,Noto Sans Regular/35840-36095.pbf"
    "Roboto Regular,Noto Sans Regular/36096-36351.pbf"
    "Roboto Regular,Noto Sans Regular/36608-36863.pbf"
    "Roboto Regular,Noto Sans Regular/36864-37119.pbf"
    "Roboto Regular,Noto Sans Regular/37120-37375.pbf"
    "Roboto Regular,Noto Sans Regular/37888-38143.pbf"
    "Roboto Regular,Noto Sans Regular/38144-38399.pbf"
    "Roboto Regular,Noto Sans Regular/38400-38655.pbf"
    "Roboto Regular,Noto Sans Regular/38656-38911.pbf"
    "Roboto Regular,Noto Sans Regular/38912-39167.pbf"
    "Roboto Regular,Noto Sans Regular/39168-39423.pbf"
    "Roboto Regular,Noto Sans Regular/39424-39679.pbf"
    "Roboto Regular,Noto Sans Regular/39936-40191.pbf"
    "Roboto Regular,Noto Sans Regular/40448-40703.pbf"
    "Roboto Regular,Noto Sans Regular/40704-40959.pbf"
    "Roboto Regular,Noto Sans Regular/45824-46079.pbf"
    "Roboto Regular,Noto Sans Regular/50432-50687.pbf"
    "Roboto Regular,Noto Sans Regular/50688-50943.pbf"
    "Roboto Regular,Noto Sans Regular/50944-51199.pbf"
    "Roboto Regular,Noto Sans Regular/51200-51455.pbf"
    "Roboto Regular,Noto Sans Regular/65024-65279.pbf"
    "Roboto Regular,Noto Sans Regular/65280-65535.pbf"
)


urlencode() {
    echo $(sed -E "s/ /%20/g" <<< """$1""")
}

for i in "${LIST[@]}" ; do
    INPUT=$(urlencode "$i")
    OUTPUT="$i"
    OUTDIR=$(dirname "$OUTPUT")
    if [ ! -f "$OUTPUT" ] ; then
        mkdir -p "$OUTDIR"
        echo "Downloading glyph '$OUTPUT' from '$INPUT'"
        curl --compressed --progress-bar --output "${OUTPUT}" "https://api.maptiler.com/fonts/${INPUT}?key=${MLN_API_KEY}"
    fi
done
