/* Generated by wayland-scanner 1.22.0 */

#ifndef WESTON_OUTPUT_CAPTURE_SERVER_PROTOCOL_H
#define WESTON_OUTPUT_CAPTURE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_weston_output_capture The weston_output_capture protocol
 * @section page_ifaces_weston_output_capture Interfaces
 * - @subpage page_iface_weston_capture_v1 - image capture factory
 * - @subpage page_iface_weston_capture_source_v1 - image capturing source
 * @section page_copyright_weston_output_capture Copyright
 * <pre>
 *
 * Copyright 2020, 2022 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct weston_capture_source_v1;
struct weston_capture_v1;
struct wl_buffer;
struct wl_output;

#ifndef WESTON_CAPTURE_V1_INTERFACE
#define WESTON_CAPTURE_V1_INTERFACE
/**
 * @page page_iface_weston_capture_v1 weston_capture_v1
 * @section page_iface_weston_capture_v1_desc Description
 *
 * The global interface exposing Weston screenshooting functionality
 * intended for single shots.
 *
 * This is a privileged inteface.
 * @section page_iface_weston_capture_v1_api API
 * See @ref iface_weston_capture_v1.
 */
/**
 * @defgroup iface_weston_capture_v1 The weston_capture_v1 interface
 *
 * The global interface exposing Weston screenshooting functionality
 * intended for single shots.
 *
 * This is a privileged inteface.
 */
extern const struct wl_interface weston_capture_v1_interface;
#endif
#ifndef WESTON_CAPTURE_SOURCE_V1_INTERFACE
#define WESTON_CAPTURE_SOURCE_V1_INTERFACE
/**
 * @page page_iface_weston_capture_source_v1 weston_capture_source_v1
 * @section page_iface_weston_capture_source_v1_desc Description
 *
 * An object representing image capturing functionality for a single
 * source. When created, it sends the initial events if and only if the
 * output still exists and the specified pixel source is available on
 * the output.
 * @section page_iface_weston_capture_source_v1_api API
 * See @ref iface_weston_capture_source_v1.
 */
/**
 * @defgroup iface_weston_capture_source_v1 The weston_capture_source_v1 interface
 *
 * An object representing image capturing functionality for a single
 * source. When created, it sends the initial events if and only if the
 * output still exists and the specified pixel source is available on
 * the output.
 */
extern const struct wl_interface weston_capture_source_v1_interface;
#endif

#ifndef WESTON_CAPTURE_V1_ERROR_ENUM
#define WESTON_CAPTURE_V1_ERROR_ENUM
enum weston_capture_v1_error {
	/**
	 * invalid source enum value
	 */
	WESTON_CAPTURE_V1_ERROR_INVALID_SOURCE = 0,
};
#endif /* WESTON_CAPTURE_V1_ERROR_ENUM */

#ifndef WESTON_CAPTURE_V1_SOURCE_ENUM
#define WESTON_CAPTURE_V1_SOURCE_ENUM
enum weston_capture_v1_source {
	/**
	 * use hardware writeback
	 */
	WESTON_CAPTURE_V1_SOURCE_WRITEBACK = 0,
	/**
	 * copy from framebuffer, desktop area
	 */
	WESTON_CAPTURE_V1_SOURCE_FRAMEBUFFER = 1,
	/**
	 * copy whole framebuffer, including borders
	 */
	WESTON_CAPTURE_V1_SOURCE_FULL_FRAMEBUFFER = 2,
	/**
	 * copy from blending space
	 */
	WESTON_CAPTURE_V1_SOURCE_BLENDING = 3,
};
#endif /* WESTON_CAPTURE_V1_SOURCE_ENUM */

/**
 * @ingroup iface_weston_capture_v1
 * @struct weston_capture_v1_interface
 */
struct weston_capture_v1_interface {
	/**
	 * unbind image capture factory
	 *
	 * Affects no other protocol objects in any way.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create an object for capturing output images
	 *
	 * This creates a weston_capture_source_v1 object corresponding
	 * to the given wl_output. The object delivers information for
	 * allocating suitable buffers, and exposes the capture function.
	 *
	 * The object will be using the given pixel source for capturing
	 * images. If the source is not available, all attempts to capture
	 * will fail gracefully.
	 *
	 * 'writeback' source will use hardware writeback feature of DRM
	 * KMS for capturing. This may allow hardware planes to remain used
	 * during the capture. This source is often not available.
	 *
	 * 'framebuffer' source copies the contents of the final
	 * framebuffer. Using this source temporarily disables all use of
	 * hardware planes and DRM KMS color pipeline features. This source
	 * is always available.
	 *
	 * 'full_framebuffer' is otherwise the same as 'framebuffer' except
	 * it will include also any borders (decorations) that the
	 * framebuffer may contain.
	 *
	 * 'blending' source copies the contents of the intermediate
	 * blending buffer, which should be in linear-light format. Using
	 * this source temporarily disables all use of hardware planes.
	 * This source is only available when a blending buffer exists,
	 * e.g. when color management is active on the output.
	 *
	 * If the pixel source is not one of the defined enumeration
	 * values, 'invalid_source' protocol error is raised.
	 * @param output output to shoot
	 * @param source pixel source
	 * @param capture_source_new_id new object
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       struct wl_resource *output,
		       uint32_t source,
		       uint32_t capture_source_new_id);
};


/**
 * @ingroup iface_weston_capture_v1
 */
#define WESTON_CAPTURE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_v1
 */
#define WESTON_CAPTURE_V1_CREATE_SINCE_VERSION 1

#ifndef WESTON_CAPTURE_SOURCE_V1_ERROR_ENUM
#define WESTON_CAPTURE_SOURCE_V1_ERROR_ENUM
enum weston_capture_source_v1_error {
	/**
	 * the wl_buffer is not writable
	 */
	WESTON_CAPTURE_SOURCE_V1_ERROR_BAD_BUFFER = 0,
	/**
	 * capture requested again before previous retired
	 */
	WESTON_CAPTURE_SOURCE_V1_ERROR_SEQUENCE = 1,
};
#endif /* WESTON_CAPTURE_SOURCE_V1_ERROR_ENUM */

/**
 * @ingroup iface_weston_capture_source_v1
 * @struct weston_capture_source_v1_interface
 */
struct weston_capture_source_v1_interface {
	/**
	 * cancel the capture, and destroy
	 *
	 * If a capture is on-going on this object, this will cancel it
	 * and make the image buffer contents undefined.
	 *
	 * This object is destroyed.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * capture an image
	 *
	 * If the given wl_buffer is compatible, the associated output
	 * will go through a repaint some time after this request has been
	 * processed, and that repaint will execute the capture. Once the
	 * capture is complete, 'complete' event is emitted.
	 *
	 * If the given wl_buffer is incompatible, the event 'retry' is
	 * emitted.
	 *
	 * If the capture fails or the buffer type is unsupported, the
	 * event 'failed' is emitted.
	 *
	 * The client must wait for one of these events before attempting
	 * 'capture' on this object again. If 'capture' is requested again
	 * before any of those events, 'sequence' protocol error is raised.
	 *
	 * The wl_buffer object will not emit wl_buffer.release event due
	 * to this request.
	 *
	 * The wl_buffer must refer to compositor-writable storage. If
	 * buffer storage is not writable, either the protocol error
	 * bad_buffer or wl_shm.error.invalid_fd is raised.
	 *
	 * If the wl_buffer is destroyed before any event is emitted, the
	 * buffer contents become undefined.
	 *
	 * A compositor is required to implement capture into wl_shm
	 * buffers. Other buffer types may or may not be supported.
	 * @param buffer a writable image buffer
	 */
	void (*capture)(struct wl_client *client,
			struct wl_resource *resource,
			struct wl_resource *buffer);
};

#define WESTON_CAPTURE_SOURCE_V1_FORMAT 0
#define WESTON_CAPTURE_SOURCE_V1_SIZE 1
#define WESTON_CAPTURE_SOURCE_V1_COMPLETE 2
#define WESTON_CAPTURE_SOURCE_V1_RETRY 3
#define WESTON_CAPTURE_SOURCE_V1_FAILED 4

/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_COMPLETE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_RETRY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_weston_capture_source_v1
 */
#define WESTON_CAPTURE_SOURCE_V1_CAPTURE_SINCE_VERSION 1

/**
 * @ingroup iface_weston_capture_source_v1
 * Sends an format event to the client owning the resource.
 * @param resource_ The client's resource
 * @param drm_format DRM pixel format code
 */
static inline void
weston_capture_source_v1_send_format(struct wl_resource *resource_, uint32_t drm_format)
{
	wl_resource_post_event(resource_, WESTON_CAPTURE_SOURCE_V1_FORMAT, drm_format);
}

/**
 * @ingroup iface_weston_capture_source_v1
 * Sends an size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param width width in pixels
 * @param height height in pixels
 */
static inline void
weston_capture_source_v1_send_size(struct wl_resource *resource_, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, WESTON_CAPTURE_SOURCE_V1_SIZE, width, height);
}

/**
 * @ingroup iface_weston_capture_source_v1
 * Sends an complete event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_capture_source_v1_send_complete(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_CAPTURE_SOURCE_V1_COMPLETE);
}

/**
 * @ingroup iface_weston_capture_source_v1
 * Sends an retry event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
weston_capture_source_v1_send_retry(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WESTON_CAPTURE_SOURCE_V1_RETRY);
}

/**
 * @ingroup iface_weston_capture_source_v1
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param msg human-readable hint
 */
static inline void
weston_capture_source_v1_send_failed(struct wl_resource *resource_, const char *msg)
{
	wl_resource_post_event(resource_, WESTON_CAPTURE_SOURCE_V1_FAILED, msg);
}

#ifdef  __cplusplus
}
#endif

#endif
