/* DO NOT EDIT - This file is generated automatically by spirv_info_c.py script */

/*
 * Copyright (C) 2017 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#include "spirv_info.h"

#include "util/macros.h"

bool
spirv_capabilities_get(const struct spirv_capabilities *caps,
                       SpvCapability cap)
{
   switch (cap) {
   case SpvCapabilityMatrix: return caps->Matrix;
   case SpvCapabilityShader: return caps->Shader;
   case SpvCapabilityGeometry: return caps->Geometry;
   case SpvCapabilityTessellation: return caps->Tessellation;
   case SpvCapabilityAddresses: return caps->Addresses;
   case SpvCapabilityLinkage: return caps->Linkage;
   case SpvCapabilityKernel: return caps->Kernel;
   case SpvCapabilityVector16: return caps->Vector16;
   case SpvCapabilityFloat16Buffer: return caps->Float16Buffer;
   case SpvCapabilityFloat16: return caps->Float16;
   case SpvCapabilityFloat64: return caps->Float64;
   case SpvCapabilityInt64: return caps->Int64;
   case SpvCapabilityInt64Atomics: return caps->Int64Atomics;
   case SpvCapabilityImageBasic: return caps->ImageBasic;
   case SpvCapabilityImageReadWrite: return caps->ImageReadWrite;
   case SpvCapabilityImageMipmap: return caps->ImageMipmap;
   case SpvCapabilityPipes: return caps->Pipes;
   case SpvCapabilityGroups: return caps->Groups;
   case SpvCapabilityDeviceEnqueue: return caps->DeviceEnqueue;
   case SpvCapabilityLiteralSampler: return caps->LiteralSampler;
   case SpvCapabilityAtomicStorage: return caps->AtomicStorage;
   case SpvCapabilityInt16: return caps->Int16;
   case SpvCapabilityTessellationPointSize: return caps->TessellationPointSize;
   case SpvCapabilityGeometryPointSize: return caps->GeometryPointSize;
   case SpvCapabilityImageGatherExtended: return caps->ImageGatherExtended;
   case SpvCapabilityStorageImageMultisample: return caps->StorageImageMultisample;
   case SpvCapabilityUniformBufferArrayDynamicIndexing: return caps->UniformBufferArrayDynamicIndexing;
   case SpvCapabilitySampledImageArrayDynamicIndexing: return caps->SampledImageArrayDynamicIndexing;
   case SpvCapabilityStorageBufferArrayDynamicIndexing: return caps->StorageBufferArrayDynamicIndexing;
   case SpvCapabilityStorageImageArrayDynamicIndexing: return caps->StorageImageArrayDynamicIndexing;
   case SpvCapabilityClipDistance: return caps->ClipDistance;
   case SpvCapabilityCullDistance: return caps->CullDistance;
   case SpvCapabilityImageCubeArray: return caps->ImageCubeArray;
   case SpvCapabilitySampleRateShading: return caps->SampleRateShading;
   case SpvCapabilityImageRect: return caps->ImageRect;
   case SpvCapabilitySampledRect: return caps->SampledRect;
   case SpvCapabilityGenericPointer: return caps->GenericPointer;
   case SpvCapabilityInt8: return caps->Int8;
   case SpvCapabilityInputAttachment: return caps->InputAttachment;
   case SpvCapabilitySparseResidency: return caps->SparseResidency;
   case SpvCapabilityMinLod: return caps->MinLod;
   case SpvCapabilitySampled1D: return caps->Sampled1D;
   case SpvCapabilityImage1D: return caps->Image1D;
   case SpvCapabilitySampledCubeArray: return caps->SampledCubeArray;
   case SpvCapabilitySampledBuffer: return caps->SampledBuffer;
   case SpvCapabilityImageBuffer: return caps->ImageBuffer;
   case SpvCapabilityImageMSArray: return caps->ImageMSArray;
   case SpvCapabilityStorageImageExtendedFormats: return caps->StorageImageExtendedFormats;
   case SpvCapabilityImageQuery: return caps->ImageQuery;
   case SpvCapabilityDerivativeControl: return caps->DerivativeControl;
   case SpvCapabilityInterpolationFunction: return caps->InterpolationFunction;
   case SpvCapabilityTransformFeedback: return caps->TransformFeedback;
   case SpvCapabilityGeometryStreams: return caps->GeometryStreams;
   case SpvCapabilityStorageImageReadWithoutFormat: return caps->StorageImageReadWithoutFormat;
   case SpvCapabilityStorageImageWriteWithoutFormat: return caps->StorageImageWriteWithoutFormat;
   case SpvCapabilityMultiViewport: return caps->MultiViewport;
   case SpvCapabilitySubgroupDispatch: return caps->SubgroupDispatch;
   case SpvCapabilityNamedBarrier: return caps->NamedBarrier;
   case SpvCapabilityPipeStorage: return caps->PipeStorage;
   case SpvCapabilityGroupNonUniform: return caps->GroupNonUniform;
   case SpvCapabilityGroupNonUniformVote: return caps->GroupNonUniformVote;
   case SpvCapabilityGroupNonUniformArithmetic: return caps->GroupNonUniformArithmetic;
   case SpvCapabilityGroupNonUniformBallot: return caps->GroupNonUniformBallot;
   case SpvCapabilityGroupNonUniformShuffle: return caps->GroupNonUniformShuffle;
   case SpvCapabilityGroupNonUniformShuffleRelative: return caps->GroupNonUniformShuffleRelative;
   case SpvCapabilityGroupNonUniformClustered: return caps->GroupNonUniformClustered;
   case SpvCapabilityGroupNonUniformQuad: return caps->GroupNonUniformQuad;
   case SpvCapabilityShaderLayer: return caps->ShaderLayer;
   case SpvCapabilityShaderViewportIndex: return caps->ShaderViewportIndex;
   case SpvCapabilityUniformDecoration: return caps->UniformDecoration;
   case SpvCapabilityCoreBuiltinsARM: return caps->CoreBuiltinsARM;
   case SpvCapabilityTileImageColorReadAccessEXT: return caps->TileImageColorReadAccessEXT;
   case SpvCapabilityTileImageDepthReadAccessEXT: return caps->TileImageDepthReadAccessEXT;
   case SpvCapabilityTileImageStencilReadAccessEXT: return caps->TileImageStencilReadAccessEXT;
   case SpvCapabilityCooperativeMatrixLayoutsARM: return caps->CooperativeMatrixLayoutsARM;
   case SpvCapabilityFragmentShadingRateKHR: return caps->FragmentShadingRateKHR;
   case SpvCapabilitySubgroupBallotKHR: return caps->SubgroupBallotKHR;
   case SpvCapabilityDrawParameters: return caps->DrawParameters;
   case SpvCapabilityWorkgroupMemoryExplicitLayoutKHR: return caps->WorkgroupMemoryExplicitLayoutKHR;
   case SpvCapabilityWorkgroupMemoryExplicitLayout8BitAccessKHR: return caps->WorkgroupMemoryExplicitLayout8BitAccessKHR;
   case SpvCapabilityWorkgroupMemoryExplicitLayout16BitAccessKHR: return caps->WorkgroupMemoryExplicitLayout16BitAccessKHR;
   case SpvCapabilitySubgroupVoteKHR: return caps->SubgroupVoteKHR;
   case SpvCapabilityStorageBuffer16BitAccess: return caps->StorageBuffer16BitAccess;
   case SpvCapabilityUniformAndStorageBuffer16BitAccess: return caps->UniformAndStorageBuffer16BitAccess;
   case SpvCapabilityStoragePushConstant16: return caps->StoragePushConstant16;
   case SpvCapabilityStorageInputOutput16: return caps->StorageInputOutput16;
   case SpvCapabilityDeviceGroup: return caps->DeviceGroup;
   case SpvCapabilityMultiView: return caps->MultiView;
   case SpvCapabilityVariablePointersStorageBuffer: return caps->VariablePointersStorageBuffer;
   case SpvCapabilityVariablePointers: return caps->VariablePointers;
   case SpvCapabilityAtomicStorageOps: return caps->AtomicStorageOps;
   case SpvCapabilitySampleMaskPostDepthCoverage: return caps->SampleMaskPostDepthCoverage;
   case SpvCapabilityStorageBuffer8BitAccess: return caps->StorageBuffer8BitAccess;
   case SpvCapabilityUniformAndStorageBuffer8BitAccess: return caps->UniformAndStorageBuffer8BitAccess;
   case SpvCapabilityStoragePushConstant8: return caps->StoragePushConstant8;
   case SpvCapabilityDenormPreserve: return caps->DenormPreserve;
   case SpvCapabilityDenormFlushToZero: return caps->DenormFlushToZero;
   case SpvCapabilitySignedZeroInfNanPreserve: return caps->SignedZeroInfNanPreserve;
   case SpvCapabilityRoundingModeRTE: return caps->RoundingModeRTE;
   case SpvCapabilityRoundingModeRTZ: return caps->RoundingModeRTZ;
   case SpvCapabilityRayQueryProvisionalKHR: return caps->RayQueryProvisionalKHR;
   case SpvCapabilityRayQueryKHR: return caps->RayQueryKHR;
   case SpvCapabilityUntypedPointersKHR: return caps->UntypedPointersKHR;
   case SpvCapabilityRayTraversalPrimitiveCullingKHR: return caps->RayTraversalPrimitiveCullingKHR;
   case SpvCapabilityRayTracingKHR: return caps->RayTracingKHR;
   case SpvCapabilityTextureSampleWeightedQCOM: return caps->TextureSampleWeightedQCOM;
   case SpvCapabilityTextureBoxFilterQCOM: return caps->TextureBoxFilterQCOM;
   case SpvCapabilityTextureBlockMatchQCOM: return caps->TextureBlockMatchQCOM;
   case SpvCapabilityTextureBlockMatch2QCOM: return caps->TextureBlockMatch2QCOM;
   case SpvCapabilityFloat16ImageAMD: return caps->Float16ImageAMD;
   case SpvCapabilityImageGatherBiasLodAMD: return caps->ImageGatherBiasLodAMD;
   case SpvCapabilityFragmentMaskAMD: return caps->FragmentMaskAMD;
   case SpvCapabilityStencilExportEXT: return caps->StencilExportEXT;
   case SpvCapabilityImageReadWriteLodAMD: return caps->ImageReadWriteLodAMD;
   case SpvCapabilityInt64ImageEXT: return caps->Int64ImageEXT;
   case SpvCapabilityShaderClockKHR: return caps->ShaderClockKHR;
   case SpvCapabilityShaderEnqueueAMDX: return caps->ShaderEnqueueAMDX;
   case SpvCapabilityQuadControlKHR: return caps->QuadControlKHR;
   case SpvCapabilityBFloat16TypeKHR: return caps->BFloat16TypeKHR;
   case SpvCapabilityBFloat16DotProductKHR: return caps->BFloat16DotProductKHR;
   case SpvCapabilityBFloat16CooperativeMatrixKHR: return caps->BFloat16CooperativeMatrixKHR;
   case SpvCapabilitySampleMaskOverrideCoverageNV: return caps->SampleMaskOverrideCoverageNV;
   case SpvCapabilityGeometryShaderPassthroughNV: return caps->GeometryShaderPassthroughNV;
   case SpvCapabilityShaderViewportIndexLayerEXT: return caps->ShaderViewportIndexLayerEXT;
   case SpvCapabilityShaderViewportMaskNV: return caps->ShaderViewportMaskNV;
   case SpvCapabilityShaderStereoViewNV: return caps->ShaderStereoViewNV;
   case SpvCapabilityPerViewAttributesNV: return caps->PerViewAttributesNV;
   case SpvCapabilityFragmentFullyCoveredEXT: return caps->FragmentFullyCoveredEXT;
   case SpvCapabilityMeshShadingNV: return caps->MeshShadingNV;
   case SpvCapabilityImageFootprintNV: return caps->ImageFootprintNV;
   case SpvCapabilityMeshShadingEXT: return caps->MeshShadingEXT;
   case SpvCapabilityFragmentBarycentricKHR: return caps->FragmentBarycentricKHR;
   case SpvCapabilityComputeDerivativeGroupQuadsKHR: return caps->ComputeDerivativeGroupQuadsKHR;
   case SpvCapabilityFragmentDensityEXT: return caps->FragmentDensityEXT;
   case SpvCapabilityGroupNonUniformPartitionedNV: return caps->GroupNonUniformPartitionedNV;
   case SpvCapabilityShaderNonUniform: return caps->ShaderNonUniform;
   case SpvCapabilityRuntimeDescriptorArray: return caps->RuntimeDescriptorArray;
   case SpvCapabilityInputAttachmentArrayDynamicIndexing: return caps->InputAttachmentArrayDynamicIndexing;
   case SpvCapabilityUniformTexelBufferArrayDynamicIndexing: return caps->UniformTexelBufferArrayDynamicIndexing;
   case SpvCapabilityStorageTexelBufferArrayDynamicIndexing: return caps->StorageTexelBufferArrayDynamicIndexing;
   case SpvCapabilityUniformBufferArrayNonUniformIndexing: return caps->UniformBufferArrayNonUniformIndexing;
   case SpvCapabilitySampledImageArrayNonUniformIndexing: return caps->SampledImageArrayNonUniformIndexing;
   case SpvCapabilityStorageBufferArrayNonUniformIndexing: return caps->StorageBufferArrayNonUniformIndexing;
   case SpvCapabilityStorageImageArrayNonUniformIndexing: return caps->StorageImageArrayNonUniformIndexing;
   case SpvCapabilityInputAttachmentArrayNonUniformIndexing: return caps->InputAttachmentArrayNonUniformIndexing;
   case SpvCapabilityUniformTexelBufferArrayNonUniformIndexing: return caps->UniformTexelBufferArrayNonUniformIndexing;
   case SpvCapabilityStorageTexelBufferArrayNonUniformIndexing: return caps->StorageTexelBufferArrayNonUniformIndexing;
   case SpvCapabilityRayTracingPositionFetchKHR: return caps->RayTracingPositionFetchKHR;
   case SpvCapabilityRayTracingNV: return caps->RayTracingNV;
   case SpvCapabilityRayTracingMotionBlurNV: return caps->RayTracingMotionBlurNV;
   case SpvCapabilityVulkanMemoryModel: return caps->VulkanMemoryModel;
   case SpvCapabilityVulkanMemoryModelDeviceScope: return caps->VulkanMemoryModelDeviceScope;
   case SpvCapabilityPhysicalStorageBufferAddresses: return caps->PhysicalStorageBufferAddresses;
   case SpvCapabilityComputeDerivativeGroupLinearKHR: return caps->ComputeDerivativeGroupLinearKHR;
   case SpvCapabilityRayTracingProvisionalKHR: return caps->RayTracingProvisionalKHR;
   case SpvCapabilityCooperativeMatrixNV: return caps->CooperativeMatrixNV;
   case SpvCapabilityFragmentShaderSampleInterlockEXT: return caps->FragmentShaderSampleInterlockEXT;
   case SpvCapabilityFragmentShaderShadingRateInterlockEXT: return caps->FragmentShaderShadingRateInterlockEXT;
   case SpvCapabilityShaderSMBuiltinsNV: return caps->ShaderSMBuiltinsNV;
   case SpvCapabilityFragmentShaderPixelInterlockEXT: return caps->FragmentShaderPixelInterlockEXT;
   case SpvCapabilityDemoteToHelperInvocation: return caps->DemoteToHelperInvocation;
   case SpvCapabilityDisplacementMicromapNV: return caps->DisplacementMicromapNV;
   case SpvCapabilityRayTracingOpacityMicromapEXT: return caps->RayTracingOpacityMicromapEXT;
   case SpvCapabilityShaderInvocationReorderNV: return caps->ShaderInvocationReorderNV;
   case SpvCapabilityBindlessTextureNV: return caps->BindlessTextureNV;
   case SpvCapabilityRayQueryPositionFetchKHR: return caps->RayQueryPositionFetchKHR;
   case SpvCapabilityCooperativeVectorNV: return caps->CooperativeVectorNV;
   case SpvCapabilityAtomicFloat16VectorNV: return caps->AtomicFloat16VectorNV;
   case SpvCapabilityRayTracingDisplacementMicromapNV: return caps->RayTracingDisplacementMicromapNV;
   case SpvCapabilityRawAccessChainsNV: return caps->RawAccessChainsNV;
   case SpvCapabilityRayTracingSpheresGeometryNV: return caps->RayTracingSpheresGeometryNV;
   case SpvCapabilityRayTracingLinearSweptSpheresGeometryNV: return caps->RayTracingLinearSweptSpheresGeometryNV;
   case SpvCapabilityCooperativeMatrixReductionsNV: return caps->CooperativeMatrixReductionsNV;
   case SpvCapabilityCooperativeMatrixConversionsNV: return caps->CooperativeMatrixConversionsNV;
   case SpvCapabilityCooperativeMatrixPerElementOperationsNV: return caps->CooperativeMatrixPerElementOperationsNV;
   case SpvCapabilityCooperativeMatrixTensorAddressingNV: return caps->CooperativeMatrixTensorAddressingNV;
   case SpvCapabilityCooperativeMatrixBlockLoadsNV: return caps->CooperativeMatrixBlockLoadsNV;
   case SpvCapabilityCooperativeVectorTrainingNV: return caps->CooperativeVectorTrainingNV;
   case SpvCapabilityRayTracingClusterAccelerationStructureNV: return caps->RayTracingClusterAccelerationStructureNV;
   case SpvCapabilityTensorAddressingNV: return caps->TensorAddressingNV;
   case SpvCapabilitySubgroupShuffleINTEL: return caps->SubgroupShuffleINTEL;
   case SpvCapabilitySubgroupBufferBlockIOINTEL: return caps->SubgroupBufferBlockIOINTEL;
   case SpvCapabilitySubgroupImageBlockIOINTEL: return caps->SubgroupImageBlockIOINTEL;
   case SpvCapabilitySubgroupImageMediaBlockIOINTEL: return caps->SubgroupImageMediaBlockIOINTEL;
   case SpvCapabilityRoundToInfinityINTEL: return caps->RoundToInfinityINTEL;
   case SpvCapabilityFloatingPointModeINTEL: return caps->FloatingPointModeINTEL;
   case SpvCapabilityIntegerFunctions2INTEL: return caps->IntegerFunctions2INTEL;
   case SpvCapabilityFunctionPointersINTEL: return caps->FunctionPointersINTEL;
   case SpvCapabilityIndirectReferencesINTEL: return caps->IndirectReferencesINTEL;
   case SpvCapabilityAsmINTEL: return caps->AsmINTEL;
   case SpvCapabilityAtomicFloat32MinMaxEXT: return caps->AtomicFloat32MinMaxEXT;
   case SpvCapabilityAtomicFloat64MinMaxEXT: return caps->AtomicFloat64MinMaxEXT;
   case SpvCapabilityAtomicFloat16MinMaxEXT: return caps->AtomicFloat16MinMaxEXT;
   case SpvCapabilityVectorComputeINTEL: return caps->VectorComputeINTEL;
   case SpvCapabilityVectorAnyINTEL: return caps->VectorAnyINTEL;
   case SpvCapabilityExpectAssumeKHR: return caps->ExpectAssumeKHR;
   case SpvCapabilitySubgroupAvcMotionEstimationINTEL: return caps->SubgroupAvcMotionEstimationINTEL;
   case SpvCapabilitySubgroupAvcMotionEstimationIntraINTEL: return caps->SubgroupAvcMotionEstimationIntraINTEL;
   case SpvCapabilitySubgroupAvcMotionEstimationChromaINTEL: return caps->SubgroupAvcMotionEstimationChromaINTEL;
   case SpvCapabilityVariableLengthArrayINTEL: return caps->VariableLengthArrayINTEL;
   case SpvCapabilityFunctionFloatControlINTEL: return caps->FunctionFloatControlINTEL;
   case SpvCapabilityFPGAMemoryAttributesINTEL: return caps->FPGAMemoryAttributesINTEL;
   case SpvCapabilityFPFastMathModeINTEL: return caps->FPFastMathModeINTEL;
   case SpvCapabilityArbitraryPrecisionIntegersINTEL: return caps->ArbitraryPrecisionIntegersINTEL;
   case SpvCapabilityArbitraryPrecisionFloatingPointINTEL: return caps->ArbitraryPrecisionFloatingPointINTEL;
   case SpvCapabilityUnstructuredLoopControlsINTEL: return caps->UnstructuredLoopControlsINTEL;
   case SpvCapabilityFPGALoopControlsINTEL: return caps->FPGALoopControlsINTEL;
   case SpvCapabilityKernelAttributesINTEL: return caps->KernelAttributesINTEL;
   case SpvCapabilityFPGAKernelAttributesINTEL: return caps->FPGAKernelAttributesINTEL;
   case SpvCapabilityFPGAMemoryAccessesINTEL: return caps->FPGAMemoryAccessesINTEL;
   case SpvCapabilityFPGAClusterAttributesINTEL: return caps->FPGAClusterAttributesINTEL;
   case SpvCapabilityLoopFuseINTEL: return caps->LoopFuseINTEL;
   case SpvCapabilityFPGADSPControlINTEL: return caps->FPGADSPControlINTEL;
   case SpvCapabilityMemoryAccessAliasingINTEL: return caps->MemoryAccessAliasingINTEL;
   case SpvCapabilityFPGAInvocationPipeliningAttributesINTEL: return caps->FPGAInvocationPipeliningAttributesINTEL;
   case SpvCapabilityFPGABufferLocationINTEL: return caps->FPGABufferLocationINTEL;
   case SpvCapabilityArbitraryPrecisionFixedPointINTEL: return caps->ArbitraryPrecisionFixedPointINTEL;
   case SpvCapabilityUSMStorageClassesINTEL: return caps->USMStorageClassesINTEL;
   case SpvCapabilityRuntimeAlignedAttributeINTEL: return caps->RuntimeAlignedAttributeINTEL;
   case SpvCapabilityIOPipesINTEL: return caps->IOPipesINTEL;
   case SpvCapabilityBlockingPipesINTEL: return caps->BlockingPipesINTEL;
   case SpvCapabilityFPGARegINTEL: return caps->FPGARegINTEL;
   case SpvCapabilityDotProductInputAll: return caps->DotProductInputAll;
   case SpvCapabilityDotProductInput4x8Bit: return caps->DotProductInput4x8Bit;
   case SpvCapabilityDotProductInput4x8BitPacked: return caps->DotProductInput4x8BitPacked;
   case SpvCapabilityDotProduct: return caps->DotProduct;
   case SpvCapabilityRayCullMaskKHR: return caps->RayCullMaskKHR;
   case SpvCapabilityCooperativeMatrixKHR: return caps->CooperativeMatrixKHR;
   case SpvCapabilityReplicatedCompositesEXT: return caps->ReplicatedCompositesEXT;
   case SpvCapabilityBitInstructions: return caps->BitInstructions;
   case SpvCapabilityGroupNonUniformRotateKHR: return caps->GroupNonUniformRotateKHR;
   case SpvCapabilityFloatControls2: return caps->FloatControls2;
   case SpvCapabilityAtomicFloat32AddEXT: return caps->AtomicFloat32AddEXT;
   case SpvCapabilityAtomicFloat64AddEXT: return caps->AtomicFloat64AddEXT;
   case SpvCapabilityLongCompositesINTEL: return caps->LongCompositesINTEL;
   case SpvCapabilityOptNoneEXT: return caps->OptNoneEXT;
   case SpvCapabilityAtomicFloat16AddEXT: return caps->AtomicFloat16AddEXT;
   case SpvCapabilityDebugInfoModuleINTEL: return caps->DebugInfoModuleINTEL;
   case SpvCapabilityBFloat16ConversionINTEL: return caps->BFloat16ConversionINTEL;
   case SpvCapabilitySplitBarrierINTEL: return caps->SplitBarrierINTEL;
   case SpvCapabilityArithmeticFenceEXT: return caps->ArithmeticFenceEXT;
   case SpvCapabilityFPGAClusterAttributesV2INTEL: return caps->FPGAClusterAttributesV2INTEL;
   case SpvCapabilityFPGAKernelAttributesv2INTEL: return caps->FPGAKernelAttributesv2INTEL;
   case SpvCapabilityTaskSequenceINTEL: return caps->TaskSequenceINTEL;
   case SpvCapabilityFPMaxErrorINTEL: return caps->FPMaxErrorINTEL;
   case SpvCapabilityFPGALatencyControlINTEL: return caps->FPGALatencyControlINTEL;
   case SpvCapabilityFPGAArgumentInterfacesINTEL: return caps->FPGAArgumentInterfacesINTEL;
   case SpvCapabilityGlobalVariableHostAccessINTEL: return caps->GlobalVariableHostAccessINTEL;
   case SpvCapabilityGlobalVariableFPGADecorationsINTEL: return caps->GlobalVariableFPGADecorationsINTEL;
   case SpvCapabilitySubgroupBufferPrefetchINTEL: return caps->SubgroupBufferPrefetchINTEL;
   case SpvCapabilitySubgroup2DBlockIOINTEL: return caps->Subgroup2DBlockIOINTEL;
   case SpvCapabilitySubgroup2DBlockTransformINTEL: return caps->Subgroup2DBlockTransformINTEL;
   case SpvCapabilitySubgroup2DBlockTransposeINTEL: return caps->Subgroup2DBlockTransposeINTEL;
   case SpvCapabilitySubgroupMatrixMultiplyAccumulateINTEL: return caps->SubgroupMatrixMultiplyAccumulateINTEL;
   case SpvCapabilityGroupUniformArithmeticKHR: return caps->GroupUniformArithmeticKHR;
   case SpvCapabilityTensorFloat32RoundingINTEL: return caps->TensorFloat32RoundingINTEL;
   case SpvCapabilityMaskedGatherScatterINTEL: return caps->MaskedGatherScatterINTEL;
   case SpvCapabilityCacheControlsINTEL: return caps->CacheControlsINTEL;
   case SpvCapabilityRegisterLimitsINTEL: return caps->RegisterLimitsINTEL;
   default:
      return false;
   }
}

void
spirv_capabilities_set(struct spirv_capabilities *caps,
                       SpvCapability cap, bool enabled)
{
   switch (cap) {
   case SpvCapabilityMatrix: caps->Matrix = enabled; break;
   case SpvCapabilityShader: caps->Shader = enabled; break;
   case SpvCapabilityGeometry: caps->Geometry = enabled; break;
   case SpvCapabilityTessellation: caps->Tessellation = enabled; break;
   case SpvCapabilityAddresses: caps->Addresses = enabled; break;
   case SpvCapabilityLinkage: caps->Linkage = enabled; break;
   case SpvCapabilityKernel: caps->Kernel = enabled; break;
   case SpvCapabilityVector16: caps->Vector16 = enabled; break;
   case SpvCapabilityFloat16Buffer: caps->Float16Buffer = enabled; break;
   case SpvCapabilityFloat16: caps->Float16 = enabled; break;
   case SpvCapabilityFloat64: caps->Float64 = enabled; break;
   case SpvCapabilityInt64: caps->Int64 = enabled; break;
   case SpvCapabilityInt64Atomics: caps->Int64Atomics = enabled; break;
   case SpvCapabilityImageBasic: caps->ImageBasic = enabled; break;
   case SpvCapabilityImageReadWrite: caps->ImageReadWrite = enabled; break;
   case SpvCapabilityImageMipmap: caps->ImageMipmap = enabled; break;
   case SpvCapabilityPipes: caps->Pipes = enabled; break;
   case SpvCapabilityGroups: caps->Groups = enabled; break;
   case SpvCapabilityDeviceEnqueue: caps->DeviceEnqueue = enabled; break;
   case SpvCapabilityLiteralSampler: caps->LiteralSampler = enabled; break;
   case SpvCapabilityAtomicStorage: caps->AtomicStorage = enabled; break;
   case SpvCapabilityInt16: caps->Int16 = enabled; break;
   case SpvCapabilityTessellationPointSize: caps->TessellationPointSize = enabled; break;
   case SpvCapabilityGeometryPointSize: caps->GeometryPointSize = enabled; break;
   case SpvCapabilityImageGatherExtended: caps->ImageGatherExtended = enabled; break;
   case SpvCapabilityStorageImageMultisample: caps->StorageImageMultisample = enabled; break;
   case SpvCapabilityUniformBufferArrayDynamicIndexing: caps->UniformBufferArrayDynamicIndexing = enabled; break;
   case SpvCapabilitySampledImageArrayDynamicIndexing: caps->SampledImageArrayDynamicIndexing = enabled; break;
   case SpvCapabilityStorageBufferArrayDynamicIndexing: caps->StorageBufferArrayDynamicIndexing = enabled; break;
   case SpvCapabilityStorageImageArrayDynamicIndexing: caps->StorageImageArrayDynamicIndexing = enabled; break;
   case SpvCapabilityClipDistance: caps->ClipDistance = enabled; break;
   case SpvCapabilityCullDistance: caps->CullDistance = enabled; break;
   case SpvCapabilityImageCubeArray: caps->ImageCubeArray = enabled; break;
   case SpvCapabilitySampleRateShading: caps->SampleRateShading = enabled; break;
   case SpvCapabilityImageRect: caps->ImageRect = enabled; break;
   case SpvCapabilitySampledRect: caps->SampledRect = enabled; break;
   case SpvCapabilityGenericPointer: caps->GenericPointer = enabled; break;
   case SpvCapabilityInt8: caps->Int8 = enabled; break;
   case SpvCapabilityInputAttachment: caps->InputAttachment = enabled; break;
   case SpvCapabilitySparseResidency: caps->SparseResidency = enabled; break;
   case SpvCapabilityMinLod: caps->MinLod = enabled; break;
   case SpvCapabilitySampled1D: caps->Sampled1D = enabled; break;
   case SpvCapabilityImage1D: caps->Image1D = enabled; break;
   case SpvCapabilitySampledCubeArray: caps->SampledCubeArray = enabled; break;
   case SpvCapabilitySampledBuffer: caps->SampledBuffer = enabled; break;
   case SpvCapabilityImageBuffer: caps->ImageBuffer = enabled; break;
   case SpvCapabilityImageMSArray: caps->ImageMSArray = enabled; break;
   case SpvCapabilityStorageImageExtendedFormats: caps->StorageImageExtendedFormats = enabled; break;
   case SpvCapabilityImageQuery: caps->ImageQuery = enabled; break;
   case SpvCapabilityDerivativeControl: caps->DerivativeControl = enabled; break;
   case SpvCapabilityInterpolationFunction: caps->InterpolationFunction = enabled; break;
   case SpvCapabilityTransformFeedback: caps->TransformFeedback = enabled; break;
   case SpvCapabilityGeometryStreams: caps->GeometryStreams = enabled; break;
   case SpvCapabilityStorageImageReadWithoutFormat: caps->StorageImageReadWithoutFormat = enabled; break;
   case SpvCapabilityStorageImageWriteWithoutFormat: caps->StorageImageWriteWithoutFormat = enabled; break;
   case SpvCapabilityMultiViewport: caps->MultiViewport = enabled; break;
   case SpvCapabilitySubgroupDispatch: caps->SubgroupDispatch = enabled; break;
   case SpvCapabilityNamedBarrier: caps->NamedBarrier = enabled; break;
   case SpvCapabilityPipeStorage: caps->PipeStorage = enabled; break;
   case SpvCapabilityGroupNonUniform: caps->GroupNonUniform = enabled; break;
   case SpvCapabilityGroupNonUniformVote: caps->GroupNonUniformVote = enabled; break;
   case SpvCapabilityGroupNonUniformArithmetic: caps->GroupNonUniformArithmetic = enabled; break;
   case SpvCapabilityGroupNonUniformBallot: caps->GroupNonUniformBallot = enabled; break;
   case SpvCapabilityGroupNonUniformShuffle: caps->GroupNonUniformShuffle = enabled; break;
   case SpvCapabilityGroupNonUniformShuffleRelative: caps->GroupNonUniformShuffleRelative = enabled; break;
   case SpvCapabilityGroupNonUniformClustered: caps->GroupNonUniformClustered = enabled; break;
   case SpvCapabilityGroupNonUniformQuad: caps->GroupNonUniformQuad = enabled; break;
   case SpvCapabilityShaderLayer: caps->ShaderLayer = enabled; break;
   case SpvCapabilityShaderViewportIndex: caps->ShaderViewportIndex = enabled; break;
   case SpvCapabilityUniformDecoration: caps->UniformDecoration = enabled; break;
   case SpvCapabilityCoreBuiltinsARM: caps->CoreBuiltinsARM = enabled; break;
   case SpvCapabilityTileImageColorReadAccessEXT: caps->TileImageColorReadAccessEXT = enabled; break;
   case SpvCapabilityTileImageDepthReadAccessEXT: caps->TileImageDepthReadAccessEXT = enabled; break;
   case SpvCapabilityTileImageStencilReadAccessEXT: caps->TileImageStencilReadAccessEXT = enabled; break;
   case SpvCapabilityCooperativeMatrixLayoutsARM: caps->CooperativeMatrixLayoutsARM = enabled; break;
   case SpvCapabilityFragmentShadingRateKHR: caps->FragmentShadingRateKHR = enabled; break;
   case SpvCapabilitySubgroupBallotKHR: caps->SubgroupBallotKHR = enabled; break;
   case SpvCapabilityDrawParameters: caps->DrawParameters = enabled; break;
   case SpvCapabilityWorkgroupMemoryExplicitLayoutKHR: caps->WorkgroupMemoryExplicitLayoutKHR = enabled; break;
   case SpvCapabilityWorkgroupMemoryExplicitLayout8BitAccessKHR: caps->WorkgroupMemoryExplicitLayout8BitAccessKHR = enabled; break;
   case SpvCapabilityWorkgroupMemoryExplicitLayout16BitAccessKHR: caps->WorkgroupMemoryExplicitLayout16BitAccessKHR = enabled; break;
   case SpvCapabilitySubgroupVoteKHR: caps->SubgroupVoteKHR = enabled; break;
   case SpvCapabilityStorageBuffer16BitAccess: caps->StorageBuffer16BitAccess = enabled; break;
   case SpvCapabilityUniformAndStorageBuffer16BitAccess: caps->UniformAndStorageBuffer16BitAccess = enabled; break;
   case SpvCapabilityStoragePushConstant16: caps->StoragePushConstant16 = enabled; break;
   case SpvCapabilityStorageInputOutput16: caps->StorageInputOutput16 = enabled; break;
   case SpvCapabilityDeviceGroup: caps->DeviceGroup = enabled; break;
   case SpvCapabilityMultiView: caps->MultiView = enabled; break;
   case SpvCapabilityVariablePointersStorageBuffer: caps->VariablePointersStorageBuffer = enabled; break;
   case SpvCapabilityVariablePointers: caps->VariablePointers = enabled; break;
   case SpvCapabilityAtomicStorageOps: caps->AtomicStorageOps = enabled; break;
   case SpvCapabilitySampleMaskPostDepthCoverage: caps->SampleMaskPostDepthCoverage = enabled; break;
   case SpvCapabilityStorageBuffer8BitAccess: caps->StorageBuffer8BitAccess = enabled; break;
   case SpvCapabilityUniformAndStorageBuffer8BitAccess: caps->UniformAndStorageBuffer8BitAccess = enabled; break;
   case SpvCapabilityStoragePushConstant8: caps->StoragePushConstant8 = enabled; break;
   case SpvCapabilityDenormPreserve: caps->DenormPreserve = enabled; break;
   case SpvCapabilityDenormFlushToZero: caps->DenormFlushToZero = enabled; break;
   case SpvCapabilitySignedZeroInfNanPreserve: caps->SignedZeroInfNanPreserve = enabled; break;
   case SpvCapabilityRoundingModeRTE: caps->RoundingModeRTE = enabled; break;
   case SpvCapabilityRoundingModeRTZ: caps->RoundingModeRTZ = enabled; break;
   case SpvCapabilityRayQueryProvisionalKHR: caps->RayQueryProvisionalKHR = enabled; break;
   case SpvCapabilityRayQueryKHR: caps->RayQueryKHR = enabled; break;
   case SpvCapabilityUntypedPointersKHR: caps->UntypedPointersKHR = enabled; break;
   case SpvCapabilityRayTraversalPrimitiveCullingKHR: caps->RayTraversalPrimitiveCullingKHR = enabled; break;
   case SpvCapabilityRayTracingKHR: caps->RayTracingKHR = enabled; break;
   case SpvCapabilityTextureSampleWeightedQCOM: caps->TextureSampleWeightedQCOM = enabled; break;
   case SpvCapabilityTextureBoxFilterQCOM: caps->TextureBoxFilterQCOM = enabled; break;
   case SpvCapabilityTextureBlockMatchQCOM: caps->TextureBlockMatchQCOM = enabled; break;
   case SpvCapabilityTextureBlockMatch2QCOM: caps->TextureBlockMatch2QCOM = enabled; break;
   case SpvCapabilityFloat16ImageAMD: caps->Float16ImageAMD = enabled; break;
   case SpvCapabilityImageGatherBiasLodAMD: caps->ImageGatherBiasLodAMD = enabled; break;
   case SpvCapabilityFragmentMaskAMD: caps->FragmentMaskAMD = enabled; break;
   case SpvCapabilityStencilExportEXT: caps->StencilExportEXT = enabled; break;
   case SpvCapabilityImageReadWriteLodAMD: caps->ImageReadWriteLodAMD = enabled; break;
   case SpvCapabilityInt64ImageEXT: caps->Int64ImageEXT = enabled; break;
   case SpvCapabilityShaderClockKHR: caps->ShaderClockKHR = enabled; break;
   case SpvCapabilityShaderEnqueueAMDX: caps->ShaderEnqueueAMDX = enabled; break;
   case SpvCapabilityQuadControlKHR: caps->QuadControlKHR = enabled; break;
   case SpvCapabilityBFloat16TypeKHR: caps->BFloat16TypeKHR = enabled; break;
   case SpvCapabilityBFloat16DotProductKHR: caps->BFloat16DotProductKHR = enabled; break;
   case SpvCapabilityBFloat16CooperativeMatrixKHR: caps->BFloat16CooperativeMatrixKHR = enabled; break;
   case SpvCapabilitySampleMaskOverrideCoverageNV: caps->SampleMaskOverrideCoverageNV = enabled; break;
   case SpvCapabilityGeometryShaderPassthroughNV: caps->GeometryShaderPassthroughNV = enabled; break;
   case SpvCapabilityShaderViewportIndexLayerEXT: caps->ShaderViewportIndexLayerEXT = enabled; break;
   case SpvCapabilityShaderViewportMaskNV: caps->ShaderViewportMaskNV = enabled; break;
   case SpvCapabilityShaderStereoViewNV: caps->ShaderStereoViewNV = enabled; break;
   case SpvCapabilityPerViewAttributesNV: caps->PerViewAttributesNV = enabled; break;
   case SpvCapabilityFragmentFullyCoveredEXT: caps->FragmentFullyCoveredEXT = enabled; break;
   case SpvCapabilityMeshShadingNV: caps->MeshShadingNV = enabled; break;
   case SpvCapabilityImageFootprintNV: caps->ImageFootprintNV = enabled; break;
   case SpvCapabilityMeshShadingEXT: caps->MeshShadingEXT = enabled; break;
   case SpvCapabilityFragmentBarycentricKHR: caps->FragmentBarycentricKHR = enabled; break;
   case SpvCapabilityComputeDerivativeGroupQuadsKHR: caps->ComputeDerivativeGroupQuadsKHR = enabled; break;
   case SpvCapabilityFragmentDensityEXT: caps->FragmentDensityEXT = enabled; break;
   case SpvCapabilityGroupNonUniformPartitionedNV: caps->GroupNonUniformPartitionedNV = enabled; break;
   case SpvCapabilityShaderNonUniform: caps->ShaderNonUniform = enabled; break;
   case SpvCapabilityRuntimeDescriptorArray: caps->RuntimeDescriptorArray = enabled; break;
   case SpvCapabilityInputAttachmentArrayDynamicIndexing: caps->InputAttachmentArrayDynamicIndexing = enabled; break;
   case SpvCapabilityUniformTexelBufferArrayDynamicIndexing: caps->UniformTexelBufferArrayDynamicIndexing = enabled; break;
   case SpvCapabilityStorageTexelBufferArrayDynamicIndexing: caps->StorageTexelBufferArrayDynamicIndexing = enabled; break;
   case SpvCapabilityUniformBufferArrayNonUniformIndexing: caps->UniformBufferArrayNonUniformIndexing = enabled; break;
   case SpvCapabilitySampledImageArrayNonUniformIndexing: caps->SampledImageArrayNonUniformIndexing = enabled; break;
   case SpvCapabilityStorageBufferArrayNonUniformIndexing: caps->StorageBufferArrayNonUniformIndexing = enabled; break;
   case SpvCapabilityStorageImageArrayNonUniformIndexing: caps->StorageImageArrayNonUniformIndexing = enabled; break;
   case SpvCapabilityInputAttachmentArrayNonUniformIndexing: caps->InputAttachmentArrayNonUniformIndexing = enabled; break;
   case SpvCapabilityUniformTexelBufferArrayNonUniformIndexing: caps->UniformTexelBufferArrayNonUniformIndexing = enabled; break;
   case SpvCapabilityStorageTexelBufferArrayNonUniformIndexing: caps->StorageTexelBufferArrayNonUniformIndexing = enabled; break;
   case SpvCapabilityRayTracingPositionFetchKHR: caps->RayTracingPositionFetchKHR = enabled; break;
   case SpvCapabilityRayTracingNV: caps->RayTracingNV = enabled; break;
   case SpvCapabilityRayTracingMotionBlurNV: caps->RayTracingMotionBlurNV = enabled; break;
   case SpvCapabilityVulkanMemoryModel: caps->VulkanMemoryModel = enabled; break;
   case SpvCapabilityVulkanMemoryModelDeviceScope: caps->VulkanMemoryModelDeviceScope = enabled; break;
   case SpvCapabilityPhysicalStorageBufferAddresses: caps->PhysicalStorageBufferAddresses = enabled; break;
   case SpvCapabilityComputeDerivativeGroupLinearKHR: caps->ComputeDerivativeGroupLinearKHR = enabled; break;
   case SpvCapabilityRayTracingProvisionalKHR: caps->RayTracingProvisionalKHR = enabled; break;
   case SpvCapabilityCooperativeMatrixNV: caps->CooperativeMatrixNV = enabled; break;
   case SpvCapabilityFragmentShaderSampleInterlockEXT: caps->FragmentShaderSampleInterlockEXT = enabled; break;
   case SpvCapabilityFragmentShaderShadingRateInterlockEXT: caps->FragmentShaderShadingRateInterlockEXT = enabled; break;
   case SpvCapabilityShaderSMBuiltinsNV: caps->ShaderSMBuiltinsNV = enabled; break;
   case SpvCapabilityFragmentShaderPixelInterlockEXT: caps->FragmentShaderPixelInterlockEXT = enabled; break;
   case SpvCapabilityDemoteToHelperInvocation: caps->DemoteToHelperInvocation = enabled; break;
   case SpvCapabilityDisplacementMicromapNV: caps->DisplacementMicromapNV = enabled; break;
   case SpvCapabilityRayTracingOpacityMicromapEXT: caps->RayTracingOpacityMicromapEXT = enabled; break;
   case SpvCapabilityShaderInvocationReorderNV: caps->ShaderInvocationReorderNV = enabled; break;
   case SpvCapabilityBindlessTextureNV: caps->BindlessTextureNV = enabled; break;
   case SpvCapabilityRayQueryPositionFetchKHR: caps->RayQueryPositionFetchKHR = enabled; break;
   case SpvCapabilityCooperativeVectorNV: caps->CooperativeVectorNV = enabled; break;
   case SpvCapabilityAtomicFloat16VectorNV: caps->AtomicFloat16VectorNV = enabled; break;
   case SpvCapabilityRayTracingDisplacementMicromapNV: caps->RayTracingDisplacementMicromapNV = enabled; break;
   case SpvCapabilityRawAccessChainsNV: caps->RawAccessChainsNV = enabled; break;
   case SpvCapabilityRayTracingSpheresGeometryNV: caps->RayTracingSpheresGeometryNV = enabled; break;
   case SpvCapabilityRayTracingLinearSweptSpheresGeometryNV: caps->RayTracingLinearSweptSpheresGeometryNV = enabled; break;
   case SpvCapabilityCooperativeMatrixReductionsNV: caps->CooperativeMatrixReductionsNV = enabled; break;
   case SpvCapabilityCooperativeMatrixConversionsNV: caps->CooperativeMatrixConversionsNV = enabled; break;
   case SpvCapabilityCooperativeMatrixPerElementOperationsNV: caps->CooperativeMatrixPerElementOperationsNV = enabled; break;
   case SpvCapabilityCooperativeMatrixTensorAddressingNV: caps->CooperativeMatrixTensorAddressingNV = enabled; break;
   case SpvCapabilityCooperativeMatrixBlockLoadsNV: caps->CooperativeMatrixBlockLoadsNV = enabled; break;
   case SpvCapabilityCooperativeVectorTrainingNV: caps->CooperativeVectorTrainingNV = enabled; break;
   case SpvCapabilityRayTracingClusterAccelerationStructureNV: caps->RayTracingClusterAccelerationStructureNV = enabled; break;
   case SpvCapabilityTensorAddressingNV: caps->TensorAddressingNV = enabled; break;
   case SpvCapabilitySubgroupShuffleINTEL: caps->SubgroupShuffleINTEL = enabled; break;
   case SpvCapabilitySubgroupBufferBlockIOINTEL: caps->SubgroupBufferBlockIOINTEL = enabled; break;
   case SpvCapabilitySubgroupImageBlockIOINTEL: caps->SubgroupImageBlockIOINTEL = enabled; break;
   case SpvCapabilitySubgroupImageMediaBlockIOINTEL: caps->SubgroupImageMediaBlockIOINTEL = enabled; break;
   case SpvCapabilityRoundToInfinityINTEL: caps->RoundToInfinityINTEL = enabled; break;
   case SpvCapabilityFloatingPointModeINTEL: caps->FloatingPointModeINTEL = enabled; break;
   case SpvCapabilityIntegerFunctions2INTEL: caps->IntegerFunctions2INTEL = enabled; break;
   case SpvCapabilityFunctionPointersINTEL: caps->FunctionPointersINTEL = enabled; break;
   case SpvCapabilityIndirectReferencesINTEL: caps->IndirectReferencesINTEL = enabled; break;
   case SpvCapabilityAsmINTEL: caps->AsmINTEL = enabled; break;
   case SpvCapabilityAtomicFloat32MinMaxEXT: caps->AtomicFloat32MinMaxEXT = enabled; break;
   case SpvCapabilityAtomicFloat64MinMaxEXT: caps->AtomicFloat64MinMaxEXT = enabled; break;
   case SpvCapabilityAtomicFloat16MinMaxEXT: caps->AtomicFloat16MinMaxEXT = enabled; break;
   case SpvCapabilityVectorComputeINTEL: caps->VectorComputeINTEL = enabled; break;
   case SpvCapabilityVectorAnyINTEL: caps->VectorAnyINTEL = enabled; break;
   case SpvCapabilityExpectAssumeKHR: caps->ExpectAssumeKHR = enabled; break;
   case SpvCapabilitySubgroupAvcMotionEstimationINTEL: caps->SubgroupAvcMotionEstimationINTEL = enabled; break;
   case SpvCapabilitySubgroupAvcMotionEstimationIntraINTEL: caps->SubgroupAvcMotionEstimationIntraINTEL = enabled; break;
   case SpvCapabilitySubgroupAvcMotionEstimationChromaINTEL: caps->SubgroupAvcMotionEstimationChromaINTEL = enabled; break;
   case SpvCapabilityVariableLengthArrayINTEL: caps->VariableLengthArrayINTEL = enabled; break;
   case SpvCapabilityFunctionFloatControlINTEL: caps->FunctionFloatControlINTEL = enabled; break;
   case SpvCapabilityFPGAMemoryAttributesINTEL: caps->FPGAMemoryAttributesINTEL = enabled; break;
   case SpvCapabilityFPFastMathModeINTEL: caps->FPFastMathModeINTEL = enabled; break;
   case SpvCapabilityArbitraryPrecisionIntegersINTEL: caps->ArbitraryPrecisionIntegersINTEL = enabled; break;
   case SpvCapabilityArbitraryPrecisionFloatingPointINTEL: caps->ArbitraryPrecisionFloatingPointINTEL = enabled; break;
   case SpvCapabilityUnstructuredLoopControlsINTEL: caps->UnstructuredLoopControlsINTEL = enabled; break;
   case SpvCapabilityFPGALoopControlsINTEL: caps->FPGALoopControlsINTEL = enabled; break;
   case SpvCapabilityKernelAttributesINTEL: caps->KernelAttributesINTEL = enabled; break;
   case SpvCapabilityFPGAKernelAttributesINTEL: caps->FPGAKernelAttributesINTEL = enabled; break;
   case SpvCapabilityFPGAMemoryAccessesINTEL: caps->FPGAMemoryAccessesINTEL = enabled; break;
   case SpvCapabilityFPGAClusterAttributesINTEL: caps->FPGAClusterAttributesINTEL = enabled; break;
   case SpvCapabilityLoopFuseINTEL: caps->LoopFuseINTEL = enabled; break;
   case SpvCapabilityFPGADSPControlINTEL: caps->FPGADSPControlINTEL = enabled; break;
   case SpvCapabilityMemoryAccessAliasingINTEL: caps->MemoryAccessAliasingINTEL = enabled; break;
   case SpvCapabilityFPGAInvocationPipeliningAttributesINTEL: caps->FPGAInvocationPipeliningAttributesINTEL = enabled; break;
   case SpvCapabilityFPGABufferLocationINTEL: caps->FPGABufferLocationINTEL = enabled; break;
   case SpvCapabilityArbitraryPrecisionFixedPointINTEL: caps->ArbitraryPrecisionFixedPointINTEL = enabled; break;
   case SpvCapabilityUSMStorageClassesINTEL: caps->USMStorageClassesINTEL = enabled; break;
   case SpvCapabilityRuntimeAlignedAttributeINTEL: caps->RuntimeAlignedAttributeINTEL = enabled; break;
   case SpvCapabilityIOPipesINTEL: caps->IOPipesINTEL = enabled; break;
   case SpvCapabilityBlockingPipesINTEL: caps->BlockingPipesINTEL = enabled; break;
   case SpvCapabilityFPGARegINTEL: caps->FPGARegINTEL = enabled; break;
   case SpvCapabilityDotProductInputAll: caps->DotProductInputAll = enabled; break;
   case SpvCapabilityDotProductInput4x8Bit: caps->DotProductInput4x8Bit = enabled; break;
   case SpvCapabilityDotProductInput4x8BitPacked: caps->DotProductInput4x8BitPacked = enabled; break;
   case SpvCapabilityDotProduct: caps->DotProduct = enabled; break;
   case SpvCapabilityRayCullMaskKHR: caps->RayCullMaskKHR = enabled; break;
   case SpvCapabilityCooperativeMatrixKHR: caps->CooperativeMatrixKHR = enabled; break;
   case SpvCapabilityReplicatedCompositesEXT: caps->ReplicatedCompositesEXT = enabled; break;
   case SpvCapabilityBitInstructions: caps->BitInstructions = enabled; break;
   case SpvCapabilityGroupNonUniformRotateKHR: caps->GroupNonUniformRotateKHR = enabled; break;
   case SpvCapabilityFloatControls2: caps->FloatControls2 = enabled; break;
   case SpvCapabilityAtomicFloat32AddEXT: caps->AtomicFloat32AddEXT = enabled; break;
   case SpvCapabilityAtomicFloat64AddEXT: caps->AtomicFloat64AddEXT = enabled; break;
   case SpvCapabilityLongCompositesINTEL: caps->LongCompositesINTEL = enabled; break;
   case SpvCapabilityOptNoneEXT: caps->OptNoneEXT = enabled; break;
   case SpvCapabilityAtomicFloat16AddEXT: caps->AtomicFloat16AddEXT = enabled; break;
   case SpvCapabilityDebugInfoModuleINTEL: caps->DebugInfoModuleINTEL = enabled; break;
   case SpvCapabilityBFloat16ConversionINTEL: caps->BFloat16ConversionINTEL = enabled; break;
   case SpvCapabilitySplitBarrierINTEL: caps->SplitBarrierINTEL = enabled; break;
   case SpvCapabilityArithmeticFenceEXT: caps->ArithmeticFenceEXT = enabled; break;
   case SpvCapabilityFPGAClusterAttributesV2INTEL: caps->FPGAClusterAttributesV2INTEL = enabled; break;
   case SpvCapabilityFPGAKernelAttributesv2INTEL: caps->FPGAKernelAttributesv2INTEL = enabled; break;
   case SpvCapabilityTaskSequenceINTEL: caps->TaskSequenceINTEL = enabled; break;
   case SpvCapabilityFPMaxErrorINTEL: caps->FPMaxErrorINTEL = enabled; break;
   case SpvCapabilityFPGALatencyControlINTEL: caps->FPGALatencyControlINTEL = enabled; break;
   case SpvCapabilityFPGAArgumentInterfacesINTEL: caps->FPGAArgumentInterfacesINTEL = enabled; break;
   case SpvCapabilityGlobalVariableHostAccessINTEL: caps->GlobalVariableHostAccessINTEL = enabled; break;
   case SpvCapabilityGlobalVariableFPGADecorationsINTEL: caps->GlobalVariableFPGADecorationsINTEL = enabled; break;
   case SpvCapabilitySubgroupBufferPrefetchINTEL: caps->SubgroupBufferPrefetchINTEL = enabled; break;
   case SpvCapabilitySubgroup2DBlockIOINTEL: caps->Subgroup2DBlockIOINTEL = enabled; break;
   case SpvCapabilitySubgroup2DBlockTransformINTEL: caps->Subgroup2DBlockTransformINTEL = enabled; break;
   case SpvCapabilitySubgroup2DBlockTransposeINTEL: caps->Subgroup2DBlockTransposeINTEL = enabled; break;
   case SpvCapabilitySubgroupMatrixMultiplyAccumulateINTEL: caps->SubgroupMatrixMultiplyAccumulateINTEL = enabled; break;
   case SpvCapabilityGroupUniformArithmeticKHR: caps->GroupUniformArithmeticKHR = enabled; break;
   case SpvCapabilityTensorFloat32RoundingINTEL: caps->TensorFloat32RoundingINTEL = enabled; break;
   case SpvCapabilityMaskedGatherScatterINTEL: caps->MaskedGatherScatterINTEL = enabled; break;
   case SpvCapabilityCacheControlsINTEL: caps->CacheControlsINTEL = enabled; break;
   case SpvCapabilityRegisterLimitsINTEL: caps->RegisterLimitsINTEL = enabled; break;
   default:
      unreachable("Unknown capability");
   }
}


const char *
spirv_addressingmodel_to_string(SpvAddressingModel v)
{
   switch (v) {
   case SpvAddressingModelLogical: return "SpvAddressingModelLogical";
   case SpvAddressingModelPhysical32: return "SpvAddressingModelPhysical32";
   case SpvAddressingModelPhysical64: return "SpvAddressingModelPhysical64";
   case SpvAddressingModelPhysicalStorageBuffer64: return "SpvAddressingModelPhysicalStorageBuffer64";
   case SpvAddressingModelMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_builtin_to_string(SpvBuiltIn v)
{
   switch (v) {
   case SpvBuiltInPosition: return "SpvBuiltInPosition";
   case SpvBuiltInPointSize: return "SpvBuiltInPointSize";
   case SpvBuiltInClipDistance: return "SpvBuiltInClipDistance";
   case SpvBuiltInCullDistance: return "SpvBuiltInCullDistance";
   case SpvBuiltInVertexId: return "SpvBuiltInVertexId";
   case SpvBuiltInInstanceId: return "SpvBuiltInInstanceId";
   case SpvBuiltInPrimitiveId: return "SpvBuiltInPrimitiveId";
   case SpvBuiltInInvocationId: return "SpvBuiltInInvocationId";
   case SpvBuiltInLayer: return "SpvBuiltInLayer";
   case SpvBuiltInViewportIndex: return "SpvBuiltInViewportIndex";
   case SpvBuiltInTessLevelOuter: return "SpvBuiltInTessLevelOuter";
   case SpvBuiltInTessLevelInner: return "SpvBuiltInTessLevelInner";
   case SpvBuiltInTessCoord: return "SpvBuiltInTessCoord";
   case SpvBuiltInPatchVertices: return "SpvBuiltInPatchVertices";
   case SpvBuiltInFragCoord: return "SpvBuiltInFragCoord";
   case SpvBuiltInPointCoord: return "SpvBuiltInPointCoord";
   case SpvBuiltInFrontFacing: return "SpvBuiltInFrontFacing";
   case SpvBuiltInSampleId: return "SpvBuiltInSampleId";
   case SpvBuiltInSamplePosition: return "SpvBuiltInSamplePosition";
   case SpvBuiltInSampleMask: return "SpvBuiltInSampleMask";
   case SpvBuiltInFragDepth: return "SpvBuiltInFragDepth";
   case SpvBuiltInHelperInvocation: return "SpvBuiltInHelperInvocation";
   case SpvBuiltInNumWorkgroups: return "SpvBuiltInNumWorkgroups";
   case SpvBuiltInWorkgroupSize: return "SpvBuiltInWorkgroupSize";
   case SpvBuiltInWorkgroupId: return "SpvBuiltInWorkgroupId";
   case SpvBuiltInLocalInvocationId: return "SpvBuiltInLocalInvocationId";
   case SpvBuiltInGlobalInvocationId: return "SpvBuiltInGlobalInvocationId";
   case SpvBuiltInLocalInvocationIndex: return "SpvBuiltInLocalInvocationIndex";
   case SpvBuiltInWorkDim: return "SpvBuiltInWorkDim";
   case SpvBuiltInGlobalSize: return "SpvBuiltInGlobalSize";
   case SpvBuiltInEnqueuedWorkgroupSize: return "SpvBuiltInEnqueuedWorkgroupSize";
   case SpvBuiltInGlobalOffset: return "SpvBuiltInGlobalOffset";
   case SpvBuiltInGlobalLinearId: return "SpvBuiltInGlobalLinearId";
   case SpvBuiltInSubgroupSize: return "SpvBuiltInSubgroupSize";
   case SpvBuiltInSubgroupMaxSize: return "SpvBuiltInSubgroupMaxSize";
   case SpvBuiltInNumSubgroups: return "SpvBuiltInNumSubgroups";
   case SpvBuiltInNumEnqueuedSubgroups: return "SpvBuiltInNumEnqueuedSubgroups";
   case SpvBuiltInSubgroupId: return "SpvBuiltInSubgroupId";
   case SpvBuiltInSubgroupLocalInvocationId: return "SpvBuiltInSubgroupLocalInvocationId";
   case SpvBuiltInVertexIndex: return "SpvBuiltInVertexIndex";
   case SpvBuiltInInstanceIndex: return "SpvBuiltInInstanceIndex";
   case SpvBuiltInCoreIDARM: return "SpvBuiltInCoreIDARM";
   case SpvBuiltInCoreCountARM: return "SpvBuiltInCoreCountARM";
   case SpvBuiltInCoreMaxIDARM: return "SpvBuiltInCoreMaxIDARM";
   case SpvBuiltInWarpIDARM: return "SpvBuiltInWarpIDARM";
   case SpvBuiltInWarpMaxIDARM: return "SpvBuiltInWarpMaxIDARM";
   case SpvBuiltInSubgroupEqMask: return "SpvBuiltInSubgroupEqMask";
   case SpvBuiltInSubgroupGeMask: return "SpvBuiltInSubgroupGeMask";
   case SpvBuiltInSubgroupGtMask: return "SpvBuiltInSubgroupGtMask";
   case SpvBuiltInSubgroupLeMask: return "SpvBuiltInSubgroupLeMask";
   case SpvBuiltInSubgroupLtMask: return "SpvBuiltInSubgroupLtMask";
   case SpvBuiltInBaseVertex: return "SpvBuiltInBaseVertex";
   case SpvBuiltInBaseInstance: return "SpvBuiltInBaseInstance";
   case SpvBuiltInDrawIndex: return "SpvBuiltInDrawIndex";
   case SpvBuiltInPrimitiveShadingRateKHR: return "SpvBuiltInPrimitiveShadingRateKHR";
   case SpvBuiltInDeviceIndex: return "SpvBuiltInDeviceIndex";
   case SpvBuiltInViewIndex: return "SpvBuiltInViewIndex";
   case SpvBuiltInShadingRateKHR: return "SpvBuiltInShadingRateKHR";
   case SpvBuiltInBaryCoordNoPerspAMD: return "SpvBuiltInBaryCoordNoPerspAMD";
   case SpvBuiltInBaryCoordNoPerspCentroidAMD: return "SpvBuiltInBaryCoordNoPerspCentroidAMD";
   case SpvBuiltInBaryCoordNoPerspSampleAMD: return "SpvBuiltInBaryCoordNoPerspSampleAMD";
   case SpvBuiltInBaryCoordSmoothAMD: return "SpvBuiltInBaryCoordSmoothAMD";
   case SpvBuiltInBaryCoordSmoothCentroidAMD: return "SpvBuiltInBaryCoordSmoothCentroidAMD";
   case SpvBuiltInBaryCoordSmoothSampleAMD: return "SpvBuiltInBaryCoordSmoothSampleAMD";
   case SpvBuiltInBaryCoordPullModelAMD: return "SpvBuiltInBaryCoordPullModelAMD";
   case SpvBuiltInFragStencilRefEXT: return "SpvBuiltInFragStencilRefEXT";
   case SpvBuiltInRemainingRecursionLevelsAMDX: return "SpvBuiltInRemainingRecursionLevelsAMDX";
   case SpvBuiltInShaderIndexAMDX: return "SpvBuiltInShaderIndexAMDX";
   case SpvBuiltInViewportMaskNV: return "SpvBuiltInViewportMaskNV";
   case SpvBuiltInSecondaryPositionNV: return "SpvBuiltInSecondaryPositionNV";
   case SpvBuiltInSecondaryViewportMaskNV: return "SpvBuiltInSecondaryViewportMaskNV";
   case SpvBuiltInPositionPerViewNV: return "SpvBuiltInPositionPerViewNV";
   case SpvBuiltInViewportMaskPerViewNV: return "SpvBuiltInViewportMaskPerViewNV";
   case SpvBuiltInFullyCoveredEXT: return "SpvBuiltInFullyCoveredEXT";
   case SpvBuiltInTaskCountNV: return "SpvBuiltInTaskCountNV";
   case SpvBuiltInPrimitiveCountNV: return "SpvBuiltInPrimitiveCountNV";
   case SpvBuiltInPrimitiveIndicesNV: return "SpvBuiltInPrimitiveIndicesNV";
   case SpvBuiltInClipDistancePerViewNV: return "SpvBuiltInClipDistancePerViewNV";
   case SpvBuiltInCullDistancePerViewNV: return "SpvBuiltInCullDistancePerViewNV";
   case SpvBuiltInLayerPerViewNV: return "SpvBuiltInLayerPerViewNV";
   case SpvBuiltInMeshViewCountNV: return "SpvBuiltInMeshViewCountNV";
   case SpvBuiltInMeshViewIndicesNV: return "SpvBuiltInMeshViewIndicesNV";
   case SpvBuiltInBaryCoordKHR: return "SpvBuiltInBaryCoordKHR";
   case SpvBuiltInBaryCoordNoPerspKHR: return "SpvBuiltInBaryCoordNoPerspKHR";
   case SpvBuiltInFragSizeEXT: return "SpvBuiltInFragSizeEXT";
   case SpvBuiltInFragInvocationCountEXT: return "SpvBuiltInFragInvocationCountEXT";
   case SpvBuiltInPrimitivePointIndicesEXT: return "SpvBuiltInPrimitivePointIndicesEXT";
   case SpvBuiltInPrimitiveLineIndicesEXT: return "SpvBuiltInPrimitiveLineIndicesEXT";
   case SpvBuiltInPrimitiveTriangleIndicesEXT: return "SpvBuiltInPrimitiveTriangleIndicesEXT";
   case SpvBuiltInCullPrimitiveEXT: return "SpvBuiltInCullPrimitiveEXT";
   case SpvBuiltInLaunchIdKHR: return "SpvBuiltInLaunchIdKHR";
   case SpvBuiltInLaunchSizeKHR: return "SpvBuiltInLaunchSizeKHR";
   case SpvBuiltInWorldRayOriginKHR: return "SpvBuiltInWorldRayOriginKHR";
   case SpvBuiltInWorldRayDirectionKHR: return "SpvBuiltInWorldRayDirectionKHR";
   case SpvBuiltInObjectRayOriginKHR: return "SpvBuiltInObjectRayOriginKHR";
   case SpvBuiltInObjectRayDirectionKHR: return "SpvBuiltInObjectRayDirectionKHR";
   case SpvBuiltInRayTminKHR: return "SpvBuiltInRayTminKHR";
   case SpvBuiltInRayTmaxKHR: return "SpvBuiltInRayTmaxKHR";
   case SpvBuiltInInstanceCustomIndexKHR: return "SpvBuiltInInstanceCustomIndexKHR";
   case SpvBuiltInObjectToWorldKHR: return "SpvBuiltInObjectToWorldKHR";
   case SpvBuiltInWorldToObjectKHR: return "SpvBuiltInWorldToObjectKHR";
   case SpvBuiltInHitTNV: return "SpvBuiltInHitTNV";
   case SpvBuiltInHitKindKHR: return "SpvBuiltInHitKindKHR";
   case SpvBuiltInCurrentRayTimeNV: return "SpvBuiltInCurrentRayTimeNV";
   case SpvBuiltInHitTriangleVertexPositionsKHR: return "SpvBuiltInHitTriangleVertexPositionsKHR";
   case SpvBuiltInHitMicroTriangleVertexPositionsNV: return "SpvBuiltInHitMicroTriangleVertexPositionsNV";
   case SpvBuiltInHitMicroTriangleVertexBarycentricsNV: return "SpvBuiltInHitMicroTriangleVertexBarycentricsNV";
   case SpvBuiltInIncomingRayFlagsKHR: return "SpvBuiltInIncomingRayFlagsKHR";
   case SpvBuiltInRayGeometryIndexKHR: return "SpvBuiltInRayGeometryIndexKHR";
   case SpvBuiltInHitIsSphereNV: return "SpvBuiltInHitIsSphereNV";
   case SpvBuiltInHitIsLSSNV: return "SpvBuiltInHitIsLSSNV";
   case SpvBuiltInHitSpherePositionNV: return "SpvBuiltInHitSpherePositionNV";
   case SpvBuiltInWarpsPerSMNV: return "SpvBuiltInWarpsPerSMNV";
   case SpvBuiltInSMCountNV: return "SpvBuiltInSMCountNV";
   case SpvBuiltInWarpIDNV: return "SpvBuiltInWarpIDNV";
   case SpvBuiltInSMIDNV: return "SpvBuiltInSMIDNV";
   case SpvBuiltInHitLSSPositionsNV: return "SpvBuiltInHitLSSPositionsNV";
   case SpvBuiltInHitKindFrontFacingMicroTriangleNV: return "SpvBuiltInHitKindFrontFacingMicroTriangleNV";
   case SpvBuiltInHitKindBackFacingMicroTriangleNV: return "SpvBuiltInHitKindBackFacingMicroTriangleNV";
   case SpvBuiltInHitSphereRadiusNV: return "SpvBuiltInHitSphereRadiusNV";
   case SpvBuiltInHitLSSRadiiNV: return "SpvBuiltInHitLSSRadiiNV";
   case SpvBuiltInClusterIDNV: return "SpvBuiltInClusterIDNV";
   case SpvBuiltInCullMaskKHR: return "SpvBuiltInCullMaskKHR";
   case SpvBuiltInMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_capability_to_string(SpvCapability v)
{
   switch (v) {
   case SpvCapabilityMatrix: return "SpvCapabilityMatrix";
   case SpvCapabilityShader: return "SpvCapabilityShader";
   case SpvCapabilityGeometry: return "SpvCapabilityGeometry";
   case SpvCapabilityTessellation: return "SpvCapabilityTessellation";
   case SpvCapabilityAddresses: return "SpvCapabilityAddresses";
   case SpvCapabilityLinkage: return "SpvCapabilityLinkage";
   case SpvCapabilityKernel: return "SpvCapabilityKernel";
   case SpvCapabilityVector16: return "SpvCapabilityVector16";
   case SpvCapabilityFloat16Buffer: return "SpvCapabilityFloat16Buffer";
   case SpvCapabilityFloat16: return "SpvCapabilityFloat16";
   case SpvCapabilityFloat64: return "SpvCapabilityFloat64";
   case SpvCapabilityInt64: return "SpvCapabilityInt64";
   case SpvCapabilityInt64Atomics: return "SpvCapabilityInt64Atomics";
   case SpvCapabilityImageBasic: return "SpvCapabilityImageBasic";
   case SpvCapabilityImageReadWrite: return "SpvCapabilityImageReadWrite";
   case SpvCapabilityImageMipmap: return "SpvCapabilityImageMipmap";
   case SpvCapabilityPipes: return "SpvCapabilityPipes";
   case SpvCapabilityGroups: return "SpvCapabilityGroups";
   case SpvCapabilityDeviceEnqueue: return "SpvCapabilityDeviceEnqueue";
   case SpvCapabilityLiteralSampler: return "SpvCapabilityLiteralSampler";
   case SpvCapabilityAtomicStorage: return "SpvCapabilityAtomicStorage";
   case SpvCapabilityInt16: return "SpvCapabilityInt16";
   case SpvCapabilityTessellationPointSize: return "SpvCapabilityTessellationPointSize";
   case SpvCapabilityGeometryPointSize: return "SpvCapabilityGeometryPointSize";
   case SpvCapabilityImageGatherExtended: return "SpvCapabilityImageGatherExtended";
   case SpvCapabilityStorageImageMultisample: return "SpvCapabilityStorageImageMultisample";
   case SpvCapabilityUniformBufferArrayDynamicIndexing: return "SpvCapabilityUniformBufferArrayDynamicIndexing";
   case SpvCapabilitySampledImageArrayDynamicIndexing: return "SpvCapabilitySampledImageArrayDynamicIndexing";
   case SpvCapabilityStorageBufferArrayDynamicIndexing: return "SpvCapabilityStorageBufferArrayDynamicIndexing";
   case SpvCapabilityStorageImageArrayDynamicIndexing: return "SpvCapabilityStorageImageArrayDynamicIndexing";
   case SpvCapabilityClipDistance: return "SpvCapabilityClipDistance";
   case SpvCapabilityCullDistance: return "SpvCapabilityCullDistance";
   case SpvCapabilityImageCubeArray: return "SpvCapabilityImageCubeArray";
   case SpvCapabilitySampleRateShading: return "SpvCapabilitySampleRateShading";
   case SpvCapabilityImageRect: return "SpvCapabilityImageRect";
   case SpvCapabilitySampledRect: return "SpvCapabilitySampledRect";
   case SpvCapabilityGenericPointer: return "SpvCapabilityGenericPointer";
   case SpvCapabilityInt8: return "SpvCapabilityInt8";
   case SpvCapabilityInputAttachment: return "SpvCapabilityInputAttachment";
   case SpvCapabilitySparseResidency: return "SpvCapabilitySparseResidency";
   case SpvCapabilityMinLod: return "SpvCapabilityMinLod";
   case SpvCapabilitySampled1D: return "SpvCapabilitySampled1D";
   case SpvCapabilityImage1D: return "SpvCapabilityImage1D";
   case SpvCapabilitySampledCubeArray: return "SpvCapabilitySampledCubeArray";
   case SpvCapabilitySampledBuffer: return "SpvCapabilitySampledBuffer";
   case SpvCapabilityImageBuffer: return "SpvCapabilityImageBuffer";
   case SpvCapabilityImageMSArray: return "SpvCapabilityImageMSArray";
   case SpvCapabilityStorageImageExtendedFormats: return "SpvCapabilityStorageImageExtendedFormats";
   case SpvCapabilityImageQuery: return "SpvCapabilityImageQuery";
   case SpvCapabilityDerivativeControl: return "SpvCapabilityDerivativeControl";
   case SpvCapabilityInterpolationFunction: return "SpvCapabilityInterpolationFunction";
   case SpvCapabilityTransformFeedback: return "SpvCapabilityTransformFeedback";
   case SpvCapabilityGeometryStreams: return "SpvCapabilityGeometryStreams";
   case SpvCapabilityStorageImageReadWithoutFormat: return "SpvCapabilityStorageImageReadWithoutFormat";
   case SpvCapabilityStorageImageWriteWithoutFormat: return "SpvCapabilityStorageImageWriteWithoutFormat";
   case SpvCapabilityMultiViewport: return "SpvCapabilityMultiViewport";
   case SpvCapabilitySubgroupDispatch: return "SpvCapabilitySubgroupDispatch";
   case SpvCapabilityNamedBarrier: return "SpvCapabilityNamedBarrier";
   case SpvCapabilityPipeStorage: return "SpvCapabilityPipeStorage";
   case SpvCapabilityGroupNonUniform: return "SpvCapabilityGroupNonUniform";
   case SpvCapabilityGroupNonUniformVote: return "SpvCapabilityGroupNonUniformVote";
   case SpvCapabilityGroupNonUniformArithmetic: return "SpvCapabilityGroupNonUniformArithmetic";
   case SpvCapabilityGroupNonUniformBallot: return "SpvCapabilityGroupNonUniformBallot";
   case SpvCapabilityGroupNonUniformShuffle: return "SpvCapabilityGroupNonUniformShuffle";
   case SpvCapabilityGroupNonUniformShuffleRelative: return "SpvCapabilityGroupNonUniformShuffleRelative";
   case SpvCapabilityGroupNonUniformClustered: return "SpvCapabilityGroupNonUniformClustered";
   case SpvCapabilityGroupNonUniformQuad: return "SpvCapabilityGroupNonUniformQuad";
   case SpvCapabilityShaderLayer: return "SpvCapabilityShaderLayer";
   case SpvCapabilityShaderViewportIndex: return "SpvCapabilityShaderViewportIndex";
   case SpvCapabilityUniformDecoration: return "SpvCapabilityUniformDecoration";
   case SpvCapabilityCoreBuiltinsARM: return "SpvCapabilityCoreBuiltinsARM";
   case SpvCapabilityTileImageColorReadAccessEXT: return "SpvCapabilityTileImageColorReadAccessEXT";
   case SpvCapabilityTileImageDepthReadAccessEXT: return "SpvCapabilityTileImageDepthReadAccessEXT";
   case SpvCapabilityTileImageStencilReadAccessEXT: return "SpvCapabilityTileImageStencilReadAccessEXT";
   case SpvCapabilityCooperativeMatrixLayoutsARM: return "SpvCapabilityCooperativeMatrixLayoutsARM";
   case SpvCapabilityFragmentShadingRateKHR: return "SpvCapabilityFragmentShadingRateKHR";
   case SpvCapabilitySubgroupBallotKHR: return "SpvCapabilitySubgroupBallotKHR";
   case SpvCapabilityDrawParameters: return "SpvCapabilityDrawParameters";
   case SpvCapabilityWorkgroupMemoryExplicitLayoutKHR: return "SpvCapabilityWorkgroupMemoryExplicitLayoutKHR";
   case SpvCapabilityWorkgroupMemoryExplicitLayout8BitAccessKHR: return "SpvCapabilityWorkgroupMemoryExplicitLayout8BitAccessKHR";
   case SpvCapabilityWorkgroupMemoryExplicitLayout16BitAccessKHR: return "SpvCapabilityWorkgroupMemoryExplicitLayout16BitAccessKHR";
   case SpvCapabilitySubgroupVoteKHR: return "SpvCapabilitySubgroupVoteKHR";
   case SpvCapabilityStorageBuffer16BitAccess: return "SpvCapabilityStorageBuffer16BitAccess";
   case SpvCapabilityUniformAndStorageBuffer16BitAccess: return "SpvCapabilityUniformAndStorageBuffer16BitAccess";
   case SpvCapabilityStoragePushConstant16: return "SpvCapabilityStoragePushConstant16";
   case SpvCapabilityStorageInputOutput16: return "SpvCapabilityStorageInputOutput16";
   case SpvCapabilityDeviceGroup: return "SpvCapabilityDeviceGroup";
   case SpvCapabilityMultiView: return "SpvCapabilityMultiView";
   case SpvCapabilityVariablePointersStorageBuffer: return "SpvCapabilityVariablePointersStorageBuffer";
   case SpvCapabilityVariablePointers: return "SpvCapabilityVariablePointers";
   case SpvCapabilityAtomicStorageOps: return "SpvCapabilityAtomicStorageOps";
   case SpvCapabilitySampleMaskPostDepthCoverage: return "SpvCapabilitySampleMaskPostDepthCoverage";
   case SpvCapabilityStorageBuffer8BitAccess: return "SpvCapabilityStorageBuffer8BitAccess";
   case SpvCapabilityUniformAndStorageBuffer8BitAccess: return "SpvCapabilityUniformAndStorageBuffer8BitAccess";
   case SpvCapabilityStoragePushConstant8: return "SpvCapabilityStoragePushConstant8";
   case SpvCapabilityDenormPreserve: return "SpvCapabilityDenormPreserve";
   case SpvCapabilityDenormFlushToZero: return "SpvCapabilityDenormFlushToZero";
   case SpvCapabilitySignedZeroInfNanPreserve: return "SpvCapabilitySignedZeroInfNanPreserve";
   case SpvCapabilityRoundingModeRTE: return "SpvCapabilityRoundingModeRTE";
   case SpvCapabilityRoundingModeRTZ: return "SpvCapabilityRoundingModeRTZ";
   case SpvCapabilityRayQueryProvisionalKHR: return "SpvCapabilityRayQueryProvisionalKHR";
   case SpvCapabilityRayQueryKHR: return "SpvCapabilityRayQueryKHR";
   case SpvCapabilityUntypedPointersKHR: return "SpvCapabilityUntypedPointersKHR";
   case SpvCapabilityRayTraversalPrimitiveCullingKHR: return "SpvCapabilityRayTraversalPrimitiveCullingKHR";
   case SpvCapabilityRayTracingKHR: return "SpvCapabilityRayTracingKHR";
   case SpvCapabilityTextureSampleWeightedQCOM: return "SpvCapabilityTextureSampleWeightedQCOM";
   case SpvCapabilityTextureBoxFilterQCOM: return "SpvCapabilityTextureBoxFilterQCOM";
   case SpvCapabilityTextureBlockMatchQCOM: return "SpvCapabilityTextureBlockMatchQCOM";
   case SpvCapabilityTextureBlockMatch2QCOM: return "SpvCapabilityTextureBlockMatch2QCOM";
   case SpvCapabilityFloat16ImageAMD: return "SpvCapabilityFloat16ImageAMD";
   case SpvCapabilityImageGatherBiasLodAMD: return "SpvCapabilityImageGatherBiasLodAMD";
   case SpvCapabilityFragmentMaskAMD: return "SpvCapabilityFragmentMaskAMD";
   case SpvCapabilityStencilExportEXT: return "SpvCapabilityStencilExportEXT";
   case SpvCapabilityImageReadWriteLodAMD: return "SpvCapabilityImageReadWriteLodAMD";
   case SpvCapabilityInt64ImageEXT: return "SpvCapabilityInt64ImageEXT";
   case SpvCapabilityShaderClockKHR: return "SpvCapabilityShaderClockKHR";
   case SpvCapabilityShaderEnqueueAMDX: return "SpvCapabilityShaderEnqueueAMDX";
   case SpvCapabilityQuadControlKHR: return "SpvCapabilityQuadControlKHR";
   case SpvCapabilityBFloat16TypeKHR: return "SpvCapabilityBFloat16TypeKHR";
   case SpvCapabilityBFloat16DotProductKHR: return "SpvCapabilityBFloat16DotProductKHR";
   case SpvCapabilityBFloat16CooperativeMatrixKHR: return "SpvCapabilityBFloat16CooperativeMatrixKHR";
   case SpvCapabilitySampleMaskOverrideCoverageNV: return "SpvCapabilitySampleMaskOverrideCoverageNV";
   case SpvCapabilityGeometryShaderPassthroughNV: return "SpvCapabilityGeometryShaderPassthroughNV";
   case SpvCapabilityShaderViewportIndexLayerEXT: return "SpvCapabilityShaderViewportIndexLayerEXT";
   case SpvCapabilityShaderViewportMaskNV: return "SpvCapabilityShaderViewportMaskNV";
   case SpvCapabilityShaderStereoViewNV: return "SpvCapabilityShaderStereoViewNV";
   case SpvCapabilityPerViewAttributesNV: return "SpvCapabilityPerViewAttributesNV";
   case SpvCapabilityFragmentFullyCoveredEXT: return "SpvCapabilityFragmentFullyCoveredEXT";
   case SpvCapabilityMeshShadingNV: return "SpvCapabilityMeshShadingNV";
   case SpvCapabilityImageFootprintNV: return "SpvCapabilityImageFootprintNV";
   case SpvCapabilityMeshShadingEXT: return "SpvCapabilityMeshShadingEXT";
   case SpvCapabilityFragmentBarycentricKHR: return "SpvCapabilityFragmentBarycentricKHR";
   case SpvCapabilityComputeDerivativeGroupQuadsKHR: return "SpvCapabilityComputeDerivativeGroupQuadsKHR";
   case SpvCapabilityFragmentDensityEXT: return "SpvCapabilityFragmentDensityEXT";
   case SpvCapabilityGroupNonUniformPartitionedNV: return "SpvCapabilityGroupNonUniformPartitionedNV";
   case SpvCapabilityShaderNonUniform: return "SpvCapabilityShaderNonUniform";
   case SpvCapabilityRuntimeDescriptorArray: return "SpvCapabilityRuntimeDescriptorArray";
   case SpvCapabilityInputAttachmentArrayDynamicIndexing: return "SpvCapabilityInputAttachmentArrayDynamicIndexing";
   case SpvCapabilityUniformTexelBufferArrayDynamicIndexing: return "SpvCapabilityUniformTexelBufferArrayDynamicIndexing";
   case SpvCapabilityStorageTexelBufferArrayDynamicIndexing: return "SpvCapabilityStorageTexelBufferArrayDynamicIndexing";
   case SpvCapabilityUniformBufferArrayNonUniformIndexing: return "SpvCapabilityUniformBufferArrayNonUniformIndexing";
   case SpvCapabilitySampledImageArrayNonUniformIndexing: return "SpvCapabilitySampledImageArrayNonUniformIndexing";
   case SpvCapabilityStorageBufferArrayNonUniformIndexing: return "SpvCapabilityStorageBufferArrayNonUniformIndexing";
   case SpvCapabilityStorageImageArrayNonUniformIndexing: return "SpvCapabilityStorageImageArrayNonUniformIndexing";
   case SpvCapabilityInputAttachmentArrayNonUniformIndexing: return "SpvCapabilityInputAttachmentArrayNonUniformIndexing";
   case SpvCapabilityUniformTexelBufferArrayNonUniformIndexing: return "SpvCapabilityUniformTexelBufferArrayNonUniformIndexing";
   case SpvCapabilityStorageTexelBufferArrayNonUniformIndexing: return "SpvCapabilityStorageTexelBufferArrayNonUniformIndexing";
   case SpvCapabilityRayTracingPositionFetchKHR: return "SpvCapabilityRayTracingPositionFetchKHR";
   case SpvCapabilityRayTracingNV: return "SpvCapabilityRayTracingNV";
   case SpvCapabilityRayTracingMotionBlurNV: return "SpvCapabilityRayTracingMotionBlurNV";
   case SpvCapabilityVulkanMemoryModel: return "SpvCapabilityVulkanMemoryModel";
   case SpvCapabilityVulkanMemoryModelDeviceScope: return "SpvCapabilityVulkanMemoryModelDeviceScope";
   case SpvCapabilityPhysicalStorageBufferAddresses: return "SpvCapabilityPhysicalStorageBufferAddresses";
   case SpvCapabilityComputeDerivativeGroupLinearKHR: return "SpvCapabilityComputeDerivativeGroupLinearKHR";
   case SpvCapabilityRayTracingProvisionalKHR: return "SpvCapabilityRayTracingProvisionalKHR";
   case SpvCapabilityCooperativeMatrixNV: return "SpvCapabilityCooperativeMatrixNV";
   case SpvCapabilityFragmentShaderSampleInterlockEXT: return "SpvCapabilityFragmentShaderSampleInterlockEXT";
   case SpvCapabilityFragmentShaderShadingRateInterlockEXT: return "SpvCapabilityFragmentShaderShadingRateInterlockEXT";
   case SpvCapabilityShaderSMBuiltinsNV: return "SpvCapabilityShaderSMBuiltinsNV";
   case SpvCapabilityFragmentShaderPixelInterlockEXT: return "SpvCapabilityFragmentShaderPixelInterlockEXT";
   case SpvCapabilityDemoteToHelperInvocation: return "SpvCapabilityDemoteToHelperInvocation";
   case SpvCapabilityDisplacementMicromapNV: return "SpvCapabilityDisplacementMicromapNV";
   case SpvCapabilityRayTracingOpacityMicromapEXT: return "SpvCapabilityRayTracingOpacityMicromapEXT";
   case SpvCapabilityShaderInvocationReorderNV: return "SpvCapabilityShaderInvocationReorderNV";
   case SpvCapabilityBindlessTextureNV: return "SpvCapabilityBindlessTextureNV";
   case SpvCapabilityRayQueryPositionFetchKHR: return "SpvCapabilityRayQueryPositionFetchKHR";
   case SpvCapabilityCooperativeVectorNV: return "SpvCapabilityCooperativeVectorNV";
   case SpvCapabilityAtomicFloat16VectorNV: return "SpvCapabilityAtomicFloat16VectorNV";
   case SpvCapabilityRayTracingDisplacementMicromapNV: return "SpvCapabilityRayTracingDisplacementMicromapNV";
   case SpvCapabilityRawAccessChainsNV: return "SpvCapabilityRawAccessChainsNV";
   case SpvCapabilityRayTracingSpheresGeometryNV: return "SpvCapabilityRayTracingSpheresGeometryNV";
   case SpvCapabilityRayTracingLinearSweptSpheresGeometryNV: return "SpvCapabilityRayTracingLinearSweptSpheresGeometryNV";
   case SpvCapabilityCooperativeMatrixReductionsNV: return "SpvCapabilityCooperativeMatrixReductionsNV";
   case SpvCapabilityCooperativeMatrixConversionsNV: return "SpvCapabilityCooperativeMatrixConversionsNV";
   case SpvCapabilityCooperativeMatrixPerElementOperationsNV: return "SpvCapabilityCooperativeMatrixPerElementOperationsNV";
   case SpvCapabilityCooperativeMatrixTensorAddressingNV: return "SpvCapabilityCooperativeMatrixTensorAddressingNV";
   case SpvCapabilityCooperativeMatrixBlockLoadsNV: return "SpvCapabilityCooperativeMatrixBlockLoadsNV";
   case SpvCapabilityCooperativeVectorTrainingNV: return "SpvCapabilityCooperativeVectorTrainingNV";
   case SpvCapabilityRayTracingClusterAccelerationStructureNV: return "SpvCapabilityRayTracingClusterAccelerationStructureNV";
   case SpvCapabilityTensorAddressingNV: return "SpvCapabilityTensorAddressingNV";
   case SpvCapabilitySubgroupShuffleINTEL: return "SpvCapabilitySubgroupShuffleINTEL";
   case SpvCapabilitySubgroupBufferBlockIOINTEL: return "SpvCapabilitySubgroupBufferBlockIOINTEL";
   case SpvCapabilitySubgroupImageBlockIOINTEL: return "SpvCapabilitySubgroupImageBlockIOINTEL";
   case SpvCapabilitySubgroupImageMediaBlockIOINTEL: return "SpvCapabilitySubgroupImageMediaBlockIOINTEL";
   case SpvCapabilityRoundToInfinityINTEL: return "SpvCapabilityRoundToInfinityINTEL";
   case SpvCapabilityFloatingPointModeINTEL: return "SpvCapabilityFloatingPointModeINTEL";
   case SpvCapabilityIntegerFunctions2INTEL: return "SpvCapabilityIntegerFunctions2INTEL";
   case SpvCapabilityFunctionPointersINTEL: return "SpvCapabilityFunctionPointersINTEL";
   case SpvCapabilityIndirectReferencesINTEL: return "SpvCapabilityIndirectReferencesINTEL";
   case SpvCapabilityAsmINTEL: return "SpvCapabilityAsmINTEL";
   case SpvCapabilityAtomicFloat32MinMaxEXT: return "SpvCapabilityAtomicFloat32MinMaxEXT";
   case SpvCapabilityAtomicFloat64MinMaxEXT: return "SpvCapabilityAtomicFloat64MinMaxEXT";
   case SpvCapabilityAtomicFloat16MinMaxEXT: return "SpvCapabilityAtomicFloat16MinMaxEXT";
   case SpvCapabilityVectorComputeINTEL: return "SpvCapabilityVectorComputeINTEL";
   case SpvCapabilityVectorAnyINTEL: return "SpvCapabilityVectorAnyINTEL";
   case SpvCapabilityExpectAssumeKHR: return "SpvCapabilityExpectAssumeKHR";
   case SpvCapabilitySubgroupAvcMotionEstimationINTEL: return "SpvCapabilitySubgroupAvcMotionEstimationINTEL";
   case SpvCapabilitySubgroupAvcMotionEstimationIntraINTEL: return "SpvCapabilitySubgroupAvcMotionEstimationIntraINTEL";
   case SpvCapabilitySubgroupAvcMotionEstimationChromaINTEL: return "SpvCapabilitySubgroupAvcMotionEstimationChromaINTEL";
   case SpvCapabilityVariableLengthArrayINTEL: return "SpvCapabilityVariableLengthArrayINTEL";
   case SpvCapabilityFunctionFloatControlINTEL: return "SpvCapabilityFunctionFloatControlINTEL";
   case SpvCapabilityFPGAMemoryAttributesINTEL: return "SpvCapabilityFPGAMemoryAttributesINTEL";
   case SpvCapabilityFPFastMathModeINTEL: return "SpvCapabilityFPFastMathModeINTEL";
   case SpvCapabilityArbitraryPrecisionIntegersINTEL: return "SpvCapabilityArbitraryPrecisionIntegersINTEL";
   case SpvCapabilityArbitraryPrecisionFloatingPointINTEL: return "SpvCapabilityArbitraryPrecisionFloatingPointINTEL";
   case SpvCapabilityUnstructuredLoopControlsINTEL: return "SpvCapabilityUnstructuredLoopControlsINTEL";
   case SpvCapabilityFPGALoopControlsINTEL: return "SpvCapabilityFPGALoopControlsINTEL";
   case SpvCapabilityKernelAttributesINTEL: return "SpvCapabilityKernelAttributesINTEL";
   case SpvCapabilityFPGAKernelAttributesINTEL: return "SpvCapabilityFPGAKernelAttributesINTEL";
   case SpvCapabilityFPGAMemoryAccessesINTEL: return "SpvCapabilityFPGAMemoryAccessesINTEL";
   case SpvCapabilityFPGAClusterAttributesINTEL: return "SpvCapabilityFPGAClusterAttributesINTEL";
   case SpvCapabilityLoopFuseINTEL: return "SpvCapabilityLoopFuseINTEL";
   case SpvCapabilityFPGADSPControlINTEL: return "SpvCapabilityFPGADSPControlINTEL";
   case SpvCapabilityMemoryAccessAliasingINTEL: return "SpvCapabilityMemoryAccessAliasingINTEL";
   case SpvCapabilityFPGAInvocationPipeliningAttributesINTEL: return "SpvCapabilityFPGAInvocationPipeliningAttributesINTEL";
   case SpvCapabilityFPGABufferLocationINTEL: return "SpvCapabilityFPGABufferLocationINTEL";
   case SpvCapabilityArbitraryPrecisionFixedPointINTEL: return "SpvCapabilityArbitraryPrecisionFixedPointINTEL";
   case SpvCapabilityUSMStorageClassesINTEL: return "SpvCapabilityUSMStorageClassesINTEL";
   case SpvCapabilityRuntimeAlignedAttributeINTEL: return "SpvCapabilityRuntimeAlignedAttributeINTEL";
   case SpvCapabilityIOPipesINTEL: return "SpvCapabilityIOPipesINTEL";
   case SpvCapabilityBlockingPipesINTEL: return "SpvCapabilityBlockingPipesINTEL";
   case SpvCapabilityFPGARegINTEL: return "SpvCapabilityFPGARegINTEL";
   case SpvCapabilityDotProductInputAll: return "SpvCapabilityDotProductInputAll";
   case SpvCapabilityDotProductInput4x8Bit: return "SpvCapabilityDotProductInput4x8Bit";
   case SpvCapabilityDotProductInput4x8BitPacked: return "SpvCapabilityDotProductInput4x8BitPacked";
   case SpvCapabilityDotProduct: return "SpvCapabilityDotProduct";
   case SpvCapabilityRayCullMaskKHR: return "SpvCapabilityRayCullMaskKHR";
   case SpvCapabilityCooperativeMatrixKHR: return "SpvCapabilityCooperativeMatrixKHR";
   case SpvCapabilityReplicatedCompositesEXT: return "SpvCapabilityReplicatedCompositesEXT";
   case SpvCapabilityBitInstructions: return "SpvCapabilityBitInstructions";
   case SpvCapabilityGroupNonUniformRotateKHR: return "SpvCapabilityGroupNonUniformRotateKHR";
   case SpvCapabilityFloatControls2: return "SpvCapabilityFloatControls2";
   case SpvCapabilityAtomicFloat32AddEXT: return "SpvCapabilityAtomicFloat32AddEXT";
   case SpvCapabilityAtomicFloat64AddEXT: return "SpvCapabilityAtomicFloat64AddEXT";
   case SpvCapabilityLongCompositesINTEL: return "SpvCapabilityLongCompositesINTEL";
   case SpvCapabilityOptNoneEXT: return "SpvCapabilityOptNoneEXT";
   case SpvCapabilityAtomicFloat16AddEXT: return "SpvCapabilityAtomicFloat16AddEXT";
   case SpvCapabilityDebugInfoModuleINTEL: return "SpvCapabilityDebugInfoModuleINTEL";
   case SpvCapabilityBFloat16ConversionINTEL: return "SpvCapabilityBFloat16ConversionINTEL";
   case SpvCapabilitySplitBarrierINTEL: return "SpvCapabilitySplitBarrierINTEL";
   case SpvCapabilityArithmeticFenceEXT: return "SpvCapabilityArithmeticFenceEXT";
   case SpvCapabilityFPGAClusterAttributesV2INTEL: return "SpvCapabilityFPGAClusterAttributesV2INTEL";
   case SpvCapabilityFPGAKernelAttributesv2INTEL: return "SpvCapabilityFPGAKernelAttributesv2INTEL";
   case SpvCapabilityTaskSequenceINTEL: return "SpvCapabilityTaskSequenceINTEL";
   case SpvCapabilityFPMaxErrorINTEL: return "SpvCapabilityFPMaxErrorINTEL";
   case SpvCapabilityFPGALatencyControlINTEL: return "SpvCapabilityFPGALatencyControlINTEL";
   case SpvCapabilityFPGAArgumentInterfacesINTEL: return "SpvCapabilityFPGAArgumentInterfacesINTEL";
   case SpvCapabilityGlobalVariableHostAccessINTEL: return "SpvCapabilityGlobalVariableHostAccessINTEL";
   case SpvCapabilityGlobalVariableFPGADecorationsINTEL: return "SpvCapabilityGlobalVariableFPGADecorationsINTEL";
   case SpvCapabilitySubgroupBufferPrefetchINTEL: return "SpvCapabilitySubgroupBufferPrefetchINTEL";
   case SpvCapabilitySubgroup2DBlockIOINTEL: return "SpvCapabilitySubgroup2DBlockIOINTEL";
   case SpvCapabilitySubgroup2DBlockTransformINTEL: return "SpvCapabilitySubgroup2DBlockTransformINTEL";
   case SpvCapabilitySubgroup2DBlockTransposeINTEL: return "SpvCapabilitySubgroup2DBlockTransposeINTEL";
   case SpvCapabilitySubgroupMatrixMultiplyAccumulateINTEL: return "SpvCapabilitySubgroupMatrixMultiplyAccumulateINTEL";
   case SpvCapabilityGroupUniformArithmeticKHR: return "SpvCapabilityGroupUniformArithmeticKHR";
   case SpvCapabilityTensorFloat32RoundingINTEL: return "SpvCapabilityTensorFloat32RoundingINTEL";
   case SpvCapabilityMaskedGatherScatterINTEL: return "SpvCapabilityMaskedGatherScatterINTEL";
   case SpvCapabilityCacheControlsINTEL: return "SpvCapabilityCacheControlsINTEL";
   case SpvCapabilityRegisterLimitsINTEL: return "SpvCapabilityRegisterLimitsINTEL";
   case SpvCapabilityMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_decoration_to_string(SpvDecoration v)
{
   switch (v) {
   case SpvDecorationRelaxedPrecision: return "SpvDecorationRelaxedPrecision";
   case SpvDecorationSpecId: return "SpvDecorationSpecId";
   case SpvDecorationBlock: return "SpvDecorationBlock";
   case SpvDecorationBufferBlock: return "SpvDecorationBufferBlock";
   case SpvDecorationRowMajor: return "SpvDecorationRowMajor";
   case SpvDecorationColMajor: return "SpvDecorationColMajor";
   case SpvDecorationArrayStride: return "SpvDecorationArrayStride";
   case SpvDecorationMatrixStride: return "SpvDecorationMatrixStride";
   case SpvDecorationGLSLShared: return "SpvDecorationGLSLShared";
   case SpvDecorationGLSLPacked: return "SpvDecorationGLSLPacked";
   case SpvDecorationCPacked: return "SpvDecorationCPacked";
   case SpvDecorationBuiltIn: return "SpvDecorationBuiltIn";
   case SpvDecorationNoPerspective: return "SpvDecorationNoPerspective";
   case SpvDecorationFlat: return "SpvDecorationFlat";
   case SpvDecorationPatch: return "SpvDecorationPatch";
   case SpvDecorationCentroid: return "SpvDecorationCentroid";
   case SpvDecorationSample: return "SpvDecorationSample";
   case SpvDecorationInvariant: return "SpvDecorationInvariant";
   case SpvDecorationRestrict: return "SpvDecorationRestrict";
   case SpvDecorationAliased: return "SpvDecorationAliased";
   case SpvDecorationVolatile: return "SpvDecorationVolatile";
   case SpvDecorationConstant: return "SpvDecorationConstant";
   case SpvDecorationCoherent: return "SpvDecorationCoherent";
   case SpvDecorationNonWritable: return "SpvDecorationNonWritable";
   case SpvDecorationNonReadable: return "SpvDecorationNonReadable";
   case SpvDecorationUniform: return "SpvDecorationUniform";
   case SpvDecorationUniformId: return "SpvDecorationUniformId";
   case SpvDecorationSaturatedConversion: return "SpvDecorationSaturatedConversion";
   case SpvDecorationStream: return "SpvDecorationStream";
   case SpvDecorationLocation: return "SpvDecorationLocation";
   case SpvDecorationComponent: return "SpvDecorationComponent";
   case SpvDecorationIndex: return "SpvDecorationIndex";
   case SpvDecorationBinding: return "SpvDecorationBinding";
   case SpvDecorationDescriptorSet: return "SpvDecorationDescriptorSet";
   case SpvDecorationOffset: return "SpvDecorationOffset";
   case SpvDecorationXfbBuffer: return "SpvDecorationXfbBuffer";
   case SpvDecorationXfbStride: return "SpvDecorationXfbStride";
   case SpvDecorationFuncParamAttr: return "SpvDecorationFuncParamAttr";
   case SpvDecorationFPRoundingMode: return "SpvDecorationFPRoundingMode";
   case SpvDecorationFPFastMathMode: return "SpvDecorationFPFastMathMode";
   case SpvDecorationLinkageAttributes: return "SpvDecorationLinkageAttributes";
   case SpvDecorationNoContraction: return "SpvDecorationNoContraction";
   case SpvDecorationInputAttachmentIndex: return "SpvDecorationInputAttachmentIndex";
   case SpvDecorationAlignment: return "SpvDecorationAlignment";
   case SpvDecorationMaxByteOffset: return "SpvDecorationMaxByteOffset";
   case SpvDecorationAlignmentId: return "SpvDecorationAlignmentId";
   case SpvDecorationMaxByteOffsetId: return "SpvDecorationMaxByteOffsetId";
   case SpvDecorationNoSignedWrap: return "SpvDecorationNoSignedWrap";
   case SpvDecorationNoUnsignedWrap: return "SpvDecorationNoUnsignedWrap";
   case SpvDecorationWeightTextureQCOM: return "SpvDecorationWeightTextureQCOM";
   case SpvDecorationBlockMatchTextureQCOM: return "SpvDecorationBlockMatchTextureQCOM";
   case SpvDecorationBlockMatchSamplerQCOM: return "SpvDecorationBlockMatchSamplerQCOM";
   case SpvDecorationExplicitInterpAMD: return "SpvDecorationExplicitInterpAMD";
   case SpvDecorationNodeSharesPayloadLimitsWithAMDX: return "SpvDecorationNodeSharesPayloadLimitsWithAMDX";
   case SpvDecorationNodeMaxPayloadsAMDX: return "SpvDecorationNodeMaxPayloadsAMDX";
   case SpvDecorationTrackFinishWritingAMDX: return "SpvDecorationTrackFinishWritingAMDX";
   case SpvDecorationPayloadNodeNameAMDX: return "SpvDecorationPayloadNodeNameAMDX";
   case SpvDecorationPayloadNodeBaseIndexAMDX: return "SpvDecorationPayloadNodeBaseIndexAMDX";
   case SpvDecorationPayloadNodeSparseArrayAMDX: return "SpvDecorationPayloadNodeSparseArrayAMDX";
   case SpvDecorationPayloadNodeArraySizeAMDX: return "SpvDecorationPayloadNodeArraySizeAMDX";
   case SpvDecorationPayloadDispatchIndirectAMDX: return "SpvDecorationPayloadDispatchIndirectAMDX";
   case SpvDecorationOverrideCoverageNV: return "SpvDecorationOverrideCoverageNV";
   case SpvDecorationPassthroughNV: return "SpvDecorationPassthroughNV";
   case SpvDecorationViewportRelativeNV: return "SpvDecorationViewportRelativeNV";
   case SpvDecorationSecondaryViewportRelativeNV: return "SpvDecorationSecondaryViewportRelativeNV";
   case SpvDecorationPerPrimitiveEXT: return "SpvDecorationPerPrimitiveEXT";
   case SpvDecorationPerViewNV: return "SpvDecorationPerViewNV";
   case SpvDecorationPerTaskNV: return "SpvDecorationPerTaskNV";
   case SpvDecorationPerVertexKHR: return "SpvDecorationPerVertexKHR";
   case SpvDecorationNonUniform: return "SpvDecorationNonUniform";
   case SpvDecorationRestrictPointer: return "SpvDecorationRestrictPointer";
   case SpvDecorationAliasedPointer: return "SpvDecorationAliasedPointer";
   case SpvDecorationHitObjectShaderRecordBufferNV: return "SpvDecorationHitObjectShaderRecordBufferNV";
   case SpvDecorationBindlessSamplerNV: return "SpvDecorationBindlessSamplerNV";
   case SpvDecorationBindlessImageNV: return "SpvDecorationBindlessImageNV";
   case SpvDecorationBoundSamplerNV: return "SpvDecorationBoundSamplerNV";
   case SpvDecorationBoundImageNV: return "SpvDecorationBoundImageNV";
   case SpvDecorationSIMTCallINTEL: return "SpvDecorationSIMTCallINTEL";
   case SpvDecorationReferencedIndirectlyINTEL: return "SpvDecorationReferencedIndirectlyINTEL";
   case SpvDecorationClobberINTEL: return "SpvDecorationClobberINTEL";
   case SpvDecorationSideEffectsINTEL: return "SpvDecorationSideEffectsINTEL";
   case SpvDecorationVectorComputeVariableINTEL: return "SpvDecorationVectorComputeVariableINTEL";
   case SpvDecorationFuncParamIOKindINTEL: return "SpvDecorationFuncParamIOKindINTEL";
   case SpvDecorationVectorComputeFunctionINTEL: return "SpvDecorationVectorComputeFunctionINTEL";
   case SpvDecorationStackCallINTEL: return "SpvDecorationStackCallINTEL";
   case SpvDecorationGlobalVariableOffsetINTEL: return "SpvDecorationGlobalVariableOffsetINTEL";
   case SpvDecorationCounterBuffer: return "SpvDecorationCounterBuffer";
   case SpvDecorationUserSemantic: return "SpvDecorationUserSemantic";
   case SpvDecorationUserTypeGOOGLE: return "SpvDecorationUserTypeGOOGLE";
   case SpvDecorationFunctionRoundingModeINTEL: return "SpvDecorationFunctionRoundingModeINTEL";
   case SpvDecorationFunctionDenormModeINTEL: return "SpvDecorationFunctionDenormModeINTEL";
   case SpvDecorationRegisterINTEL: return "SpvDecorationRegisterINTEL";
   case SpvDecorationMemoryINTEL: return "SpvDecorationMemoryINTEL";
   case SpvDecorationNumbanksINTEL: return "SpvDecorationNumbanksINTEL";
   case SpvDecorationBankwidthINTEL: return "SpvDecorationBankwidthINTEL";
   case SpvDecorationMaxPrivateCopiesINTEL: return "SpvDecorationMaxPrivateCopiesINTEL";
   case SpvDecorationSinglepumpINTEL: return "SpvDecorationSinglepumpINTEL";
   case SpvDecorationDoublepumpINTEL: return "SpvDecorationDoublepumpINTEL";
   case SpvDecorationMaxReplicatesINTEL: return "SpvDecorationMaxReplicatesINTEL";
   case SpvDecorationSimpleDualPortINTEL: return "SpvDecorationSimpleDualPortINTEL";
   case SpvDecorationMergeINTEL: return "SpvDecorationMergeINTEL";
   case SpvDecorationBankBitsINTEL: return "SpvDecorationBankBitsINTEL";
   case SpvDecorationForcePow2DepthINTEL: return "SpvDecorationForcePow2DepthINTEL";
   case SpvDecorationStridesizeINTEL: return "SpvDecorationStridesizeINTEL";
   case SpvDecorationWordsizeINTEL: return "SpvDecorationWordsizeINTEL";
   case SpvDecorationTrueDualPortINTEL: return "SpvDecorationTrueDualPortINTEL";
   case SpvDecorationBurstCoalesceINTEL: return "SpvDecorationBurstCoalesceINTEL";
   case SpvDecorationCacheSizeINTEL: return "SpvDecorationCacheSizeINTEL";
   case SpvDecorationDontStaticallyCoalesceINTEL: return "SpvDecorationDontStaticallyCoalesceINTEL";
   case SpvDecorationPrefetchINTEL: return "SpvDecorationPrefetchINTEL";
   case SpvDecorationStallEnableINTEL: return "SpvDecorationStallEnableINTEL";
   case SpvDecorationFuseLoopsInFunctionINTEL: return "SpvDecorationFuseLoopsInFunctionINTEL";
   case SpvDecorationMathOpDSPModeINTEL: return "SpvDecorationMathOpDSPModeINTEL";
   case SpvDecorationAliasScopeINTEL: return "SpvDecorationAliasScopeINTEL";
   case SpvDecorationNoAliasINTEL: return "SpvDecorationNoAliasINTEL";
   case SpvDecorationInitiationIntervalINTEL: return "SpvDecorationInitiationIntervalINTEL";
   case SpvDecorationMaxConcurrencyINTEL: return "SpvDecorationMaxConcurrencyINTEL";
   case SpvDecorationPipelineEnableINTEL: return "SpvDecorationPipelineEnableINTEL";
   case SpvDecorationBufferLocationINTEL: return "SpvDecorationBufferLocationINTEL";
   case SpvDecorationIOPipeStorageINTEL: return "SpvDecorationIOPipeStorageINTEL";
   case SpvDecorationFunctionFloatingPointModeINTEL: return "SpvDecorationFunctionFloatingPointModeINTEL";
   case SpvDecorationSingleElementVectorINTEL: return "SpvDecorationSingleElementVectorINTEL";
   case SpvDecorationVectorComputeCallableFunctionINTEL: return "SpvDecorationVectorComputeCallableFunctionINTEL";
   case SpvDecorationMediaBlockIOINTEL: return "SpvDecorationMediaBlockIOINTEL";
   case SpvDecorationStallFreeINTEL: return "SpvDecorationStallFreeINTEL";
   case SpvDecorationFPMaxErrorDecorationINTEL: return "SpvDecorationFPMaxErrorDecorationINTEL";
   case SpvDecorationLatencyControlLabelINTEL: return "SpvDecorationLatencyControlLabelINTEL";
   case SpvDecorationLatencyControlConstraintINTEL: return "SpvDecorationLatencyControlConstraintINTEL";
   case SpvDecorationConduitKernelArgumentINTEL: return "SpvDecorationConduitKernelArgumentINTEL";
   case SpvDecorationRegisterMapKernelArgumentINTEL: return "SpvDecorationRegisterMapKernelArgumentINTEL";
   case SpvDecorationMMHostInterfaceAddressWidthINTEL: return "SpvDecorationMMHostInterfaceAddressWidthINTEL";
   case SpvDecorationMMHostInterfaceDataWidthINTEL: return "SpvDecorationMMHostInterfaceDataWidthINTEL";
   case SpvDecorationMMHostInterfaceLatencyINTEL: return "SpvDecorationMMHostInterfaceLatencyINTEL";
   case SpvDecorationMMHostInterfaceReadWriteModeINTEL: return "SpvDecorationMMHostInterfaceReadWriteModeINTEL";
   case SpvDecorationMMHostInterfaceMaxBurstINTEL: return "SpvDecorationMMHostInterfaceMaxBurstINTEL";
   case SpvDecorationMMHostInterfaceWaitRequestINTEL: return "SpvDecorationMMHostInterfaceWaitRequestINTEL";
   case SpvDecorationStableKernelArgumentINTEL: return "SpvDecorationStableKernelArgumentINTEL";
   case SpvDecorationHostAccessINTEL: return "SpvDecorationHostAccessINTEL";
   case SpvDecorationInitModeINTEL: return "SpvDecorationInitModeINTEL";
   case SpvDecorationImplementInRegisterMapINTEL: return "SpvDecorationImplementInRegisterMapINTEL";
   case SpvDecorationCacheControlLoadINTEL: return "SpvDecorationCacheControlLoadINTEL";
   case SpvDecorationCacheControlStoreINTEL: return "SpvDecorationCacheControlStoreINTEL";
   case SpvDecorationMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_dim_to_string(SpvDim v)
{
   switch (v) {
   case SpvDim1D: return "SpvDim1D";
   case SpvDim2D: return "SpvDim2D";
   case SpvDim3D: return "SpvDim3D";
   case SpvDimCube: return "SpvDimCube";
   case SpvDimRect: return "SpvDimRect";
   case SpvDimBuffer: return "SpvDimBuffer";
   case SpvDimSubpassData: return "SpvDimSubpassData";
   case SpvDimTileImageDataEXT: return "SpvDimTileImageDataEXT";
   case SpvDimMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_executionmode_to_string(SpvExecutionMode v)
{
   switch (v) {
   case SpvExecutionModeInvocations: return "SpvExecutionModeInvocations";
   case SpvExecutionModeSpacingEqual: return "SpvExecutionModeSpacingEqual";
   case SpvExecutionModeSpacingFractionalEven: return "SpvExecutionModeSpacingFractionalEven";
   case SpvExecutionModeSpacingFractionalOdd: return "SpvExecutionModeSpacingFractionalOdd";
   case SpvExecutionModeVertexOrderCw: return "SpvExecutionModeVertexOrderCw";
   case SpvExecutionModeVertexOrderCcw: return "SpvExecutionModeVertexOrderCcw";
   case SpvExecutionModePixelCenterInteger: return "SpvExecutionModePixelCenterInteger";
   case SpvExecutionModeOriginUpperLeft: return "SpvExecutionModeOriginUpperLeft";
   case SpvExecutionModeOriginLowerLeft: return "SpvExecutionModeOriginLowerLeft";
   case SpvExecutionModeEarlyFragmentTests: return "SpvExecutionModeEarlyFragmentTests";
   case SpvExecutionModePointMode: return "SpvExecutionModePointMode";
   case SpvExecutionModeXfb: return "SpvExecutionModeXfb";
   case SpvExecutionModeDepthReplacing: return "SpvExecutionModeDepthReplacing";
   case SpvExecutionModeDepthGreater: return "SpvExecutionModeDepthGreater";
   case SpvExecutionModeDepthLess: return "SpvExecutionModeDepthLess";
   case SpvExecutionModeDepthUnchanged: return "SpvExecutionModeDepthUnchanged";
   case SpvExecutionModeLocalSize: return "SpvExecutionModeLocalSize";
   case SpvExecutionModeLocalSizeHint: return "SpvExecutionModeLocalSizeHint";
   case SpvExecutionModeInputPoints: return "SpvExecutionModeInputPoints";
   case SpvExecutionModeInputLines: return "SpvExecutionModeInputLines";
   case SpvExecutionModeInputLinesAdjacency: return "SpvExecutionModeInputLinesAdjacency";
   case SpvExecutionModeTriangles: return "SpvExecutionModeTriangles";
   case SpvExecutionModeInputTrianglesAdjacency: return "SpvExecutionModeInputTrianglesAdjacency";
   case SpvExecutionModeQuads: return "SpvExecutionModeQuads";
   case SpvExecutionModeIsolines: return "SpvExecutionModeIsolines";
   case SpvExecutionModeOutputVertices: return "SpvExecutionModeOutputVertices";
   case SpvExecutionModeOutputPoints: return "SpvExecutionModeOutputPoints";
   case SpvExecutionModeOutputLineStrip: return "SpvExecutionModeOutputLineStrip";
   case SpvExecutionModeOutputTriangleStrip: return "SpvExecutionModeOutputTriangleStrip";
   case SpvExecutionModeVecTypeHint: return "SpvExecutionModeVecTypeHint";
   case SpvExecutionModeContractionOff: return "SpvExecutionModeContractionOff";
   case SpvExecutionModeInitializer: return "SpvExecutionModeInitializer";
   case SpvExecutionModeFinalizer: return "SpvExecutionModeFinalizer";
   case SpvExecutionModeSubgroupSize: return "SpvExecutionModeSubgroupSize";
   case SpvExecutionModeSubgroupsPerWorkgroup: return "SpvExecutionModeSubgroupsPerWorkgroup";
   case SpvExecutionModeSubgroupsPerWorkgroupId: return "SpvExecutionModeSubgroupsPerWorkgroupId";
   case SpvExecutionModeLocalSizeId: return "SpvExecutionModeLocalSizeId";
   case SpvExecutionModeLocalSizeHintId: return "SpvExecutionModeLocalSizeHintId";
   case SpvExecutionModeNonCoherentColorAttachmentReadEXT: return "SpvExecutionModeNonCoherentColorAttachmentReadEXT";
   case SpvExecutionModeNonCoherentDepthAttachmentReadEXT: return "SpvExecutionModeNonCoherentDepthAttachmentReadEXT";
   case SpvExecutionModeNonCoherentStencilAttachmentReadEXT: return "SpvExecutionModeNonCoherentStencilAttachmentReadEXT";
   case SpvExecutionModeSubgroupUniformControlFlowKHR: return "SpvExecutionModeSubgroupUniformControlFlowKHR";
   case SpvExecutionModePostDepthCoverage: return "SpvExecutionModePostDepthCoverage";
   case SpvExecutionModeDenormPreserve: return "SpvExecutionModeDenormPreserve";
   case SpvExecutionModeDenormFlushToZero: return "SpvExecutionModeDenormFlushToZero";
   case SpvExecutionModeSignedZeroInfNanPreserve: return "SpvExecutionModeSignedZeroInfNanPreserve";
   case SpvExecutionModeRoundingModeRTE: return "SpvExecutionModeRoundingModeRTE";
   case SpvExecutionModeRoundingModeRTZ: return "SpvExecutionModeRoundingModeRTZ";
   case SpvExecutionModeEarlyAndLateFragmentTestsAMD: return "SpvExecutionModeEarlyAndLateFragmentTestsAMD";
   case SpvExecutionModeStencilRefReplacingEXT: return "SpvExecutionModeStencilRefReplacingEXT";
   case SpvExecutionModeCoalescingAMDX: return "SpvExecutionModeCoalescingAMDX";
   case SpvExecutionModeIsApiEntryAMDX: return "SpvExecutionModeIsApiEntryAMDX";
   case SpvExecutionModeMaxNodeRecursionAMDX: return "SpvExecutionModeMaxNodeRecursionAMDX";
   case SpvExecutionModeStaticNumWorkgroupsAMDX: return "SpvExecutionModeStaticNumWorkgroupsAMDX";
   case SpvExecutionModeShaderIndexAMDX: return "SpvExecutionModeShaderIndexAMDX";
   case SpvExecutionModeMaxNumWorkgroupsAMDX: return "SpvExecutionModeMaxNumWorkgroupsAMDX";
   case SpvExecutionModeStencilRefUnchangedFrontAMD: return "SpvExecutionModeStencilRefUnchangedFrontAMD";
   case SpvExecutionModeStencilRefGreaterFrontAMD: return "SpvExecutionModeStencilRefGreaterFrontAMD";
   case SpvExecutionModeStencilRefLessFrontAMD: return "SpvExecutionModeStencilRefLessFrontAMD";
   case SpvExecutionModeStencilRefUnchangedBackAMD: return "SpvExecutionModeStencilRefUnchangedBackAMD";
   case SpvExecutionModeStencilRefGreaterBackAMD: return "SpvExecutionModeStencilRefGreaterBackAMD";
   case SpvExecutionModeStencilRefLessBackAMD: return "SpvExecutionModeStencilRefLessBackAMD";
   case SpvExecutionModeQuadDerivativesKHR: return "SpvExecutionModeQuadDerivativesKHR";
   case SpvExecutionModeRequireFullQuadsKHR: return "SpvExecutionModeRequireFullQuadsKHR";
   case SpvExecutionModeSharesInputWithAMDX: return "SpvExecutionModeSharesInputWithAMDX";
   case SpvExecutionModeOutputLinesEXT: return "SpvExecutionModeOutputLinesEXT";
   case SpvExecutionModeOutputPrimitivesEXT: return "SpvExecutionModeOutputPrimitivesEXT";
   case SpvExecutionModeDerivativeGroupQuadsKHR: return "SpvExecutionModeDerivativeGroupQuadsKHR";
   case SpvExecutionModeDerivativeGroupLinearKHR: return "SpvExecutionModeDerivativeGroupLinearKHR";
   case SpvExecutionModeOutputTrianglesEXT: return "SpvExecutionModeOutputTrianglesEXT";
   case SpvExecutionModePixelInterlockOrderedEXT: return "SpvExecutionModePixelInterlockOrderedEXT";
   case SpvExecutionModePixelInterlockUnorderedEXT: return "SpvExecutionModePixelInterlockUnorderedEXT";
   case SpvExecutionModeSampleInterlockOrderedEXT: return "SpvExecutionModeSampleInterlockOrderedEXT";
   case SpvExecutionModeSampleInterlockUnorderedEXT: return "SpvExecutionModeSampleInterlockUnorderedEXT";
   case SpvExecutionModeShadingRateInterlockOrderedEXT: return "SpvExecutionModeShadingRateInterlockOrderedEXT";
   case SpvExecutionModeShadingRateInterlockUnorderedEXT: return "SpvExecutionModeShadingRateInterlockUnorderedEXT";
   case SpvExecutionModeSharedLocalMemorySizeINTEL: return "SpvExecutionModeSharedLocalMemorySizeINTEL";
   case SpvExecutionModeRoundingModeRTPINTEL: return "SpvExecutionModeRoundingModeRTPINTEL";
   case SpvExecutionModeRoundingModeRTNINTEL: return "SpvExecutionModeRoundingModeRTNINTEL";
   case SpvExecutionModeFloatingPointModeALTINTEL: return "SpvExecutionModeFloatingPointModeALTINTEL";
   case SpvExecutionModeFloatingPointModeIEEEINTEL: return "SpvExecutionModeFloatingPointModeIEEEINTEL";
   case SpvExecutionModeMaxWorkgroupSizeINTEL: return "SpvExecutionModeMaxWorkgroupSizeINTEL";
   case SpvExecutionModeMaxWorkDimINTEL: return "SpvExecutionModeMaxWorkDimINTEL";
   case SpvExecutionModeNoGlobalOffsetINTEL: return "SpvExecutionModeNoGlobalOffsetINTEL";
   case SpvExecutionModeNumSIMDWorkitemsINTEL: return "SpvExecutionModeNumSIMDWorkitemsINTEL";
   case SpvExecutionModeSchedulerTargetFmaxMhzINTEL: return "SpvExecutionModeSchedulerTargetFmaxMhzINTEL";
   case SpvExecutionModeMaximallyReconvergesKHR: return "SpvExecutionModeMaximallyReconvergesKHR";
   case SpvExecutionModeFPFastMathDefault: return "SpvExecutionModeFPFastMathDefault";
   case SpvExecutionModeStreamingInterfaceINTEL: return "SpvExecutionModeStreamingInterfaceINTEL";
   case SpvExecutionModeRegisterMapInterfaceINTEL: return "SpvExecutionModeRegisterMapInterfaceINTEL";
   case SpvExecutionModeNamedBarrierCountINTEL: return "SpvExecutionModeNamedBarrierCountINTEL";
   case SpvExecutionModeMaximumRegistersINTEL: return "SpvExecutionModeMaximumRegistersINTEL";
   case SpvExecutionModeMaximumRegistersIdINTEL: return "SpvExecutionModeMaximumRegistersIdINTEL";
   case SpvExecutionModeNamedMaximumRegistersINTEL: return "SpvExecutionModeNamedMaximumRegistersINTEL";
   case SpvExecutionModeMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_executionmodel_to_string(SpvExecutionModel v)
{
   switch (v) {
   case SpvExecutionModelVertex: return "SpvExecutionModelVertex";
   case SpvExecutionModelTessellationControl: return "SpvExecutionModelTessellationControl";
   case SpvExecutionModelTessellationEvaluation: return "SpvExecutionModelTessellationEvaluation";
   case SpvExecutionModelGeometry: return "SpvExecutionModelGeometry";
   case SpvExecutionModelFragment: return "SpvExecutionModelFragment";
   case SpvExecutionModelGLCompute: return "SpvExecutionModelGLCompute";
   case SpvExecutionModelKernel: return "SpvExecutionModelKernel";
   case SpvExecutionModelTaskNV: return "SpvExecutionModelTaskNV";
   case SpvExecutionModelMeshNV: return "SpvExecutionModelMeshNV";
   case SpvExecutionModelRayGenerationKHR: return "SpvExecutionModelRayGenerationKHR";
   case SpvExecutionModelIntersectionKHR: return "SpvExecutionModelIntersectionKHR";
   case SpvExecutionModelAnyHitKHR: return "SpvExecutionModelAnyHitKHR";
   case SpvExecutionModelClosestHitKHR: return "SpvExecutionModelClosestHitKHR";
   case SpvExecutionModelMissKHR: return "SpvExecutionModelMissKHR";
   case SpvExecutionModelCallableKHR: return "SpvExecutionModelCallableKHR";
   case SpvExecutionModelTaskEXT: return "SpvExecutionModelTaskEXT";
   case SpvExecutionModelMeshEXT: return "SpvExecutionModelMeshEXT";
   case SpvExecutionModelMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_fproundingmode_to_string(SpvFPRoundingMode v)
{
   switch (v) {
   case SpvFPRoundingModeRTE: return "SpvFPRoundingModeRTE";
   case SpvFPRoundingModeRTZ: return "SpvFPRoundingModeRTZ";
   case SpvFPRoundingModeRTP: return "SpvFPRoundingModeRTP";
   case SpvFPRoundingModeRTN: return "SpvFPRoundingModeRTN";
   case SpvFPRoundingModeMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_functionparameterattribute_to_string(SpvFunctionParameterAttribute v)
{
   switch (v) {
   case SpvFunctionParameterAttributeZext: return "SpvFunctionParameterAttributeZext";
   case SpvFunctionParameterAttributeSext: return "SpvFunctionParameterAttributeSext";
   case SpvFunctionParameterAttributeByVal: return "SpvFunctionParameterAttributeByVal";
   case SpvFunctionParameterAttributeSret: return "SpvFunctionParameterAttributeSret";
   case SpvFunctionParameterAttributeNoAlias: return "SpvFunctionParameterAttributeNoAlias";
   case SpvFunctionParameterAttributeNoCapture: return "SpvFunctionParameterAttributeNoCapture";
   case SpvFunctionParameterAttributeNoWrite: return "SpvFunctionParameterAttributeNoWrite";
   case SpvFunctionParameterAttributeNoReadWrite: return "SpvFunctionParameterAttributeNoReadWrite";
   case SpvFunctionParameterAttributeRuntimeAlignedINTEL: return "SpvFunctionParameterAttributeRuntimeAlignedINTEL";
   case SpvFunctionParameterAttributeMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_imageformat_to_string(SpvImageFormat v)
{
   switch (v) {
   case SpvImageFormatUnknown: return "SpvImageFormatUnknown";
   case SpvImageFormatRgba32f: return "SpvImageFormatRgba32f";
   case SpvImageFormatRgba16f: return "SpvImageFormatRgba16f";
   case SpvImageFormatR32f: return "SpvImageFormatR32f";
   case SpvImageFormatRgba8: return "SpvImageFormatRgba8";
   case SpvImageFormatRgba8Snorm: return "SpvImageFormatRgba8Snorm";
   case SpvImageFormatRg32f: return "SpvImageFormatRg32f";
   case SpvImageFormatRg16f: return "SpvImageFormatRg16f";
   case SpvImageFormatR11fG11fB10f: return "SpvImageFormatR11fG11fB10f";
   case SpvImageFormatR16f: return "SpvImageFormatR16f";
   case SpvImageFormatRgba16: return "SpvImageFormatRgba16";
   case SpvImageFormatRgb10A2: return "SpvImageFormatRgb10A2";
   case SpvImageFormatRg16: return "SpvImageFormatRg16";
   case SpvImageFormatRg8: return "SpvImageFormatRg8";
   case SpvImageFormatR16: return "SpvImageFormatR16";
   case SpvImageFormatR8: return "SpvImageFormatR8";
   case SpvImageFormatRgba16Snorm: return "SpvImageFormatRgba16Snorm";
   case SpvImageFormatRg16Snorm: return "SpvImageFormatRg16Snorm";
   case SpvImageFormatRg8Snorm: return "SpvImageFormatRg8Snorm";
   case SpvImageFormatR16Snorm: return "SpvImageFormatR16Snorm";
   case SpvImageFormatR8Snorm: return "SpvImageFormatR8Snorm";
   case SpvImageFormatRgba32i: return "SpvImageFormatRgba32i";
   case SpvImageFormatRgba16i: return "SpvImageFormatRgba16i";
   case SpvImageFormatRgba8i: return "SpvImageFormatRgba8i";
   case SpvImageFormatR32i: return "SpvImageFormatR32i";
   case SpvImageFormatRg32i: return "SpvImageFormatRg32i";
   case SpvImageFormatRg16i: return "SpvImageFormatRg16i";
   case SpvImageFormatRg8i: return "SpvImageFormatRg8i";
   case SpvImageFormatR16i: return "SpvImageFormatR16i";
   case SpvImageFormatR8i: return "SpvImageFormatR8i";
   case SpvImageFormatRgba32ui: return "SpvImageFormatRgba32ui";
   case SpvImageFormatRgba16ui: return "SpvImageFormatRgba16ui";
   case SpvImageFormatRgba8ui: return "SpvImageFormatRgba8ui";
   case SpvImageFormatR32ui: return "SpvImageFormatR32ui";
   case SpvImageFormatRgb10a2ui: return "SpvImageFormatRgb10a2ui";
   case SpvImageFormatRg32ui: return "SpvImageFormatRg32ui";
   case SpvImageFormatRg16ui: return "SpvImageFormatRg16ui";
   case SpvImageFormatRg8ui: return "SpvImageFormatRg8ui";
   case SpvImageFormatR16ui: return "SpvImageFormatR16ui";
   case SpvImageFormatR8ui: return "SpvImageFormatR8ui";
   case SpvImageFormatR64ui: return "SpvImageFormatR64ui";
   case SpvImageFormatR64i: return "SpvImageFormatR64i";
   case SpvImageFormatMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_imageoperands_to_string(SpvImageOperandsMask v)
{
   switch (v) {
   case SpvImageOperandsMaskNone: return "SpvImageOperandsNone";
   case SpvImageOperandsBiasMask: return "SpvImageOperandsBias";
   case SpvImageOperandsLodMask: return "SpvImageOperandsLod";
   case SpvImageOperandsGradMask: return "SpvImageOperandsGrad";
   case SpvImageOperandsConstOffsetMask: return "SpvImageOperandsConstOffset";
   case SpvImageOperandsOffsetMask: return "SpvImageOperandsOffset";
   case SpvImageOperandsConstOffsetsMask: return "SpvImageOperandsConstOffsets";
   case SpvImageOperandsSampleMask: return "SpvImageOperandsSample";
   case SpvImageOperandsMinLodMask: return "SpvImageOperandsMinLod";
   case SpvImageOperandsMakeTexelAvailableMask: return "SpvImageOperandsMakeTexelAvailable";
   case SpvImageOperandsMakeTexelVisibleMask: return "SpvImageOperandsMakeTexelVisible";
   case SpvImageOperandsNonPrivateTexelMask: return "SpvImageOperandsNonPrivateTexel";
   case SpvImageOperandsVolatileTexelMask: return "SpvImageOperandsVolatileTexel";
   case SpvImageOperandsSignExtendMask: return "SpvImageOperandsSignExtend";
   case SpvImageOperandsZeroExtendMask: return "SpvImageOperandsZeroExtend";
   case SpvImageOperandsNontemporalMask: return "SpvImageOperandsNontemporal";
   case SpvImageOperandsOffsetsMask: return "SpvImageOperandsOffsets";
   }

   return "unknown";
}

const char *
spirv_memorymodel_to_string(SpvMemoryModel v)
{
   switch (v) {
   case SpvMemoryModelSimple: return "SpvMemoryModelSimple";
   case SpvMemoryModelGLSL450: return "SpvMemoryModelGLSL450";
   case SpvMemoryModelOpenCL: return "SpvMemoryModelOpenCL";
   case SpvMemoryModelVulkan: return "SpvMemoryModelVulkan";
   case SpvMemoryModelMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_storageclass_to_string(SpvStorageClass v)
{
   switch (v) {
   case SpvStorageClassUniformConstant: return "SpvStorageClassUniformConstant";
   case SpvStorageClassInput: return "SpvStorageClassInput";
   case SpvStorageClassUniform: return "SpvStorageClassUniform";
   case SpvStorageClassOutput: return "SpvStorageClassOutput";
   case SpvStorageClassWorkgroup: return "SpvStorageClassWorkgroup";
   case SpvStorageClassCrossWorkgroup: return "SpvStorageClassCrossWorkgroup";
   case SpvStorageClassPrivate: return "SpvStorageClassPrivate";
   case SpvStorageClassFunction: return "SpvStorageClassFunction";
   case SpvStorageClassGeneric: return "SpvStorageClassGeneric";
   case SpvStorageClassPushConstant: return "SpvStorageClassPushConstant";
   case SpvStorageClassAtomicCounter: return "SpvStorageClassAtomicCounter";
   case SpvStorageClassImage: return "SpvStorageClassImage";
   case SpvStorageClassStorageBuffer: return "SpvStorageClassStorageBuffer";
   case SpvStorageClassTileImageEXT: return "SpvStorageClassTileImageEXT";
   case SpvStorageClassNodePayloadAMDX: return "SpvStorageClassNodePayloadAMDX";
   case SpvStorageClassCallableDataKHR: return "SpvStorageClassCallableDataKHR";
   case SpvStorageClassIncomingCallableDataKHR: return "SpvStorageClassIncomingCallableDataKHR";
   case SpvStorageClassRayPayloadKHR: return "SpvStorageClassRayPayloadKHR";
   case SpvStorageClassHitAttributeKHR: return "SpvStorageClassHitAttributeKHR";
   case SpvStorageClassIncomingRayPayloadKHR: return "SpvStorageClassIncomingRayPayloadKHR";
   case SpvStorageClassShaderRecordBufferKHR: return "SpvStorageClassShaderRecordBufferKHR";
   case SpvStorageClassPhysicalStorageBuffer: return "SpvStorageClassPhysicalStorageBuffer";
   case SpvStorageClassHitObjectAttributeNV: return "SpvStorageClassHitObjectAttributeNV";
   case SpvStorageClassTaskPayloadWorkgroupEXT: return "SpvStorageClassTaskPayloadWorkgroupEXT";
   case SpvStorageClassCodeSectionINTEL: return "SpvStorageClassCodeSectionINTEL";
   case SpvStorageClassDeviceOnlyINTEL: return "SpvStorageClassDeviceOnlyINTEL";
   case SpvStorageClassHostOnlyINTEL: return "SpvStorageClassHostOnlyINTEL";
   case SpvStorageClassMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}

const char *
spirv_op_to_string(SpvOp v)
{
   switch (v) {
   case SpvOpNop: return "SpvOpNop";
   case SpvOpUndef: return "SpvOpUndef";
   case SpvOpSourceContinued: return "SpvOpSourceContinued";
   case SpvOpSource: return "SpvOpSource";
   case SpvOpSourceExtension: return "SpvOpSourceExtension";
   case SpvOpName: return "SpvOpName";
   case SpvOpMemberName: return "SpvOpMemberName";
   case SpvOpString: return "SpvOpString";
   case SpvOpLine: return "SpvOpLine";
   case SpvOpExtension: return "SpvOpExtension";
   case SpvOpExtInstImport: return "SpvOpExtInstImport";
   case SpvOpExtInst: return "SpvOpExtInst";
   case SpvOpMemoryModel: return "SpvOpMemoryModel";
   case SpvOpEntryPoint: return "SpvOpEntryPoint";
   case SpvOpExecutionMode: return "SpvOpExecutionMode";
   case SpvOpCapability: return "SpvOpCapability";
   case SpvOpTypeVoid: return "SpvOpTypeVoid";
   case SpvOpTypeBool: return "SpvOpTypeBool";
   case SpvOpTypeInt: return "SpvOpTypeInt";
   case SpvOpTypeFloat: return "SpvOpTypeFloat";
   case SpvOpTypeVector: return "SpvOpTypeVector";
   case SpvOpTypeMatrix: return "SpvOpTypeMatrix";
   case SpvOpTypeImage: return "SpvOpTypeImage";
   case SpvOpTypeSampler: return "SpvOpTypeSampler";
   case SpvOpTypeSampledImage: return "SpvOpTypeSampledImage";
   case SpvOpTypeArray: return "SpvOpTypeArray";
   case SpvOpTypeRuntimeArray: return "SpvOpTypeRuntimeArray";
   case SpvOpTypeStruct: return "SpvOpTypeStruct";
   case SpvOpTypeOpaque: return "SpvOpTypeOpaque";
   case SpvOpTypePointer: return "SpvOpTypePointer";
   case SpvOpTypeFunction: return "SpvOpTypeFunction";
   case SpvOpTypeEvent: return "SpvOpTypeEvent";
   case SpvOpTypeDeviceEvent: return "SpvOpTypeDeviceEvent";
   case SpvOpTypeReserveId: return "SpvOpTypeReserveId";
   case SpvOpTypeQueue: return "SpvOpTypeQueue";
   case SpvOpTypePipe: return "SpvOpTypePipe";
   case SpvOpTypeForwardPointer: return "SpvOpTypeForwardPointer";
   case SpvOpConstantTrue: return "SpvOpConstantTrue";
   case SpvOpConstantFalse: return "SpvOpConstantFalse";
   case SpvOpConstant: return "SpvOpConstant";
   case SpvOpConstantComposite: return "SpvOpConstantComposite";
   case SpvOpConstantSampler: return "SpvOpConstantSampler";
   case SpvOpConstantNull: return "SpvOpConstantNull";
   case SpvOpSpecConstantTrue: return "SpvOpSpecConstantTrue";
   case SpvOpSpecConstantFalse: return "SpvOpSpecConstantFalse";
   case SpvOpSpecConstant: return "SpvOpSpecConstant";
   case SpvOpSpecConstantComposite: return "SpvOpSpecConstantComposite";
   case SpvOpSpecConstantOp: return "SpvOpSpecConstantOp";
   case SpvOpFunction: return "SpvOpFunction";
   case SpvOpFunctionParameter: return "SpvOpFunctionParameter";
   case SpvOpFunctionEnd: return "SpvOpFunctionEnd";
   case SpvOpFunctionCall: return "SpvOpFunctionCall";
   case SpvOpVariable: return "SpvOpVariable";
   case SpvOpImageTexelPointer: return "SpvOpImageTexelPointer";
   case SpvOpLoad: return "SpvOpLoad";
   case SpvOpStore: return "SpvOpStore";
   case SpvOpCopyMemory: return "SpvOpCopyMemory";
   case SpvOpCopyMemorySized: return "SpvOpCopyMemorySized";
   case SpvOpAccessChain: return "SpvOpAccessChain";
   case SpvOpInBoundsAccessChain: return "SpvOpInBoundsAccessChain";
   case SpvOpPtrAccessChain: return "SpvOpPtrAccessChain";
   case SpvOpArrayLength: return "SpvOpArrayLength";
   case SpvOpGenericPtrMemSemantics: return "SpvOpGenericPtrMemSemantics";
   case SpvOpInBoundsPtrAccessChain: return "SpvOpInBoundsPtrAccessChain";
   case SpvOpDecorate: return "SpvOpDecorate";
   case SpvOpMemberDecorate: return "SpvOpMemberDecorate";
   case SpvOpDecorationGroup: return "SpvOpDecorationGroup";
   case SpvOpGroupDecorate: return "SpvOpGroupDecorate";
   case SpvOpGroupMemberDecorate: return "SpvOpGroupMemberDecorate";
   case SpvOpVectorExtractDynamic: return "SpvOpVectorExtractDynamic";
   case SpvOpVectorInsertDynamic: return "SpvOpVectorInsertDynamic";
   case SpvOpVectorShuffle: return "SpvOpVectorShuffle";
   case SpvOpCompositeConstruct: return "SpvOpCompositeConstruct";
   case SpvOpCompositeExtract: return "SpvOpCompositeExtract";
   case SpvOpCompositeInsert: return "SpvOpCompositeInsert";
   case SpvOpCopyObject: return "SpvOpCopyObject";
   case SpvOpTranspose: return "SpvOpTranspose";
   case SpvOpSampledImage: return "SpvOpSampledImage";
   case SpvOpImageSampleImplicitLod: return "SpvOpImageSampleImplicitLod";
   case SpvOpImageSampleExplicitLod: return "SpvOpImageSampleExplicitLod";
   case SpvOpImageSampleDrefImplicitLod: return "SpvOpImageSampleDrefImplicitLod";
   case SpvOpImageSampleDrefExplicitLod: return "SpvOpImageSampleDrefExplicitLod";
   case SpvOpImageSampleProjImplicitLod: return "SpvOpImageSampleProjImplicitLod";
   case SpvOpImageSampleProjExplicitLod: return "SpvOpImageSampleProjExplicitLod";
   case SpvOpImageSampleProjDrefImplicitLod: return "SpvOpImageSampleProjDrefImplicitLod";
   case SpvOpImageSampleProjDrefExplicitLod: return "SpvOpImageSampleProjDrefExplicitLod";
   case SpvOpImageFetch: return "SpvOpImageFetch";
   case SpvOpImageGather: return "SpvOpImageGather";
   case SpvOpImageDrefGather: return "SpvOpImageDrefGather";
   case SpvOpImageRead: return "SpvOpImageRead";
   case SpvOpImageWrite: return "SpvOpImageWrite";
   case SpvOpImage: return "SpvOpImage";
   case SpvOpImageQueryFormat: return "SpvOpImageQueryFormat";
   case SpvOpImageQueryOrder: return "SpvOpImageQueryOrder";
   case SpvOpImageQuerySizeLod: return "SpvOpImageQuerySizeLod";
   case SpvOpImageQuerySize: return "SpvOpImageQuerySize";
   case SpvOpImageQueryLod: return "SpvOpImageQueryLod";
   case SpvOpImageQueryLevels: return "SpvOpImageQueryLevels";
   case SpvOpImageQuerySamples: return "SpvOpImageQuerySamples";
   case SpvOpConvertFToU: return "SpvOpConvertFToU";
   case SpvOpConvertFToS: return "SpvOpConvertFToS";
   case SpvOpConvertSToF: return "SpvOpConvertSToF";
   case SpvOpConvertUToF: return "SpvOpConvertUToF";
   case SpvOpUConvert: return "SpvOpUConvert";
   case SpvOpSConvert: return "SpvOpSConvert";
   case SpvOpFConvert: return "SpvOpFConvert";
   case SpvOpQuantizeToF16: return "SpvOpQuantizeToF16";
   case SpvOpConvertPtrToU: return "SpvOpConvertPtrToU";
   case SpvOpSatConvertSToU: return "SpvOpSatConvertSToU";
   case SpvOpSatConvertUToS: return "SpvOpSatConvertUToS";
   case SpvOpConvertUToPtr: return "SpvOpConvertUToPtr";
   case SpvOpPtrCastToGeneric: return "SpvOpPtrCastToGeneric";
   case SpvOpGenericCastToPtr: return "SpvOpGenericCastToPtr";
   case SpvOpGenericCastToPtrExplicit: return "SpvOpGenericCastToPtrExplicit";
   case SpvOpBitcast: return "SpvOpBitcast";
   case SpvOpSNegate: return "SpvOpSNegate";
   case SpvOpFNegate: return "SpvOpFNegate";
   case SpvOpIAdd: return "SpvOpIAdd";
   case SpvOpFAdd: return "SpvOpFAdd";
   case SpvOpISub: return "SpvOpISub";
   case SpvOpFSub: return "SpvOpFSub";
   case SpvOpIMul: return "SpvOpIMul";
   case SpvOpFMul: return "SpvOpFMul";
   case SpvOpUDiv: return "SpvOpUDiv";
   case SpvOpSDiv: return "SpvOpSDiv";
   case SpvOpFDiv: return "SpvOpFDiv";
   case SpvOpUMod: return "SpvOpUMod";
   case SpvOpSRem: return "SpvOpSRem";
   case SpvOpSMod: return "SpvOpSMod";
   case SpvOpFRem: return "SpvOpFRem";
   case SpvOpFMod: return "SpvOpFMod";
   case SpvOpVectorTimesScalar: return "SpvOpVectorTimesScalar";
   case SpvOpMatrixTimesScalar: return "SpvOpMatrixTimesScalar";
   case SpvOpVectorTimesMatrix: return "SpvOpVectorTimesMatrix";
   case SpvOpMatrixTimesVector: return "SpvOpMatrixTimesVector";
   case SpvOpMatrixTimesMatrix: return "SpvOpMatrixTimesMatrix";
   case SpvOpOuterProduct: return "SpvOpOuterProduct";
   case SpvOpDot: return "SpvOpDot";
   case SpvOpIAddCarry: return "SpvOpIAddCarry";
   case SpvOpISubBorrow: return "SpvOpISubBorrow";
   case SpvOpUMulExtended: return "SpvOpUMulExtended";
   case SpvOpSMulExtended: return "SpvOpSMulExtended";
   case SpvOpAny: return "SpvOpAny";
   case SpvOpAll: return "SpvOpAll";
   case SpvOpIsNan: return "SpvOpIsNan";
   case SpvOpIsInf: return "SpvOpIsInf";
   case SpvOpIsFinite: return "SpvOpIsFinite";
   case SpvOpIsNormal: return "SpvOpIsNormal";
   case SpvOpSignBitSet: return "SpvOpSignBitSet";
   case SpvOpLessOrGreater: return "SpvOpLessOrGreater";
   case SpvOpOrdered: return "SpvOpOrdered";
   case SpvOpUnordered: return "SpvOpUnordered";
   case SpvOpLogicalEqual: return "SpvOpLogicalEqual";
   case SpvOpLogicalNotEqual: return "SpvOpLogicalNotEqual";
   case SpvOpLogicalOr: return "SpvOpLogicalOr";
   case SpvOpLogicalAnd: return "SpvOpLogicalAnd";
   case SpvOpLogicalNot: return "SpvOpLogicalNot";
   case SpvOpSelect: return "SpvOpSelect";
   case SpvOpIEqual: return "SpvOpIEqual";
   case SpvOpINotEqual: return "SpvOpINotEqual";
   case SpvOpUGreaterThan: return "SpvOpUGreaterThan";
   case SpvOpSGreaterThan: return "SpvOpSGreaterThan";
   case SpvOpUGreaterThanEqual: return "SpvOpUGreaterThanEqual";
   case SpvOpSGreaterThanEqual: return "SpvOpSGreaterThanEqual";
   case SpvOpULessThan: return "SpvOpULessThan";
   case SpvOpSLessThan: return "SpvOpSLessThan";
   case SpvOpULessThanEqual: return "SpvOpULessThanEqual";
   case SpvOpSLessThanEqual: return "SpvOpSLessThanEqual";
   case SpvOpFOrdEqual: return "SpvOpFOrdEqual";
   case SpvOpFUnordEqual: return "SpvOpFUnordEqual";
   case SpvOpFOrdNotEqual: return "SpvOpFOrdNotEqual";
   case SpvOpFUnordNotEqual: return "SpvOpFUnordNotEqual";
   case SpvOpFOrdLessThan: return "SpvOpFOrdLessThan";
   case SpvOpFUnordLessThan: return "SpvOpFUnordLessThan";
   case SpvOpFOrdGreaterThan: return "SpvOpFOrdGreaterThan";
   case SpvOpFUnordGreaterThan: return "SpvOpFUnordGreaterThan";
   case SpvOpFOrdLessThanEqual: return "SpvOpFOrdLessThanEqual";
   case SpvOpFUnordLessThanEqual: return "SpvOpFUnordLessThanEqual";
   case SpvOpFOrdGreaterThanEqual: return "SpvOpFOrdGreaterThanEqual";
   case SpvOpFUnordGreaterThanEqual: return "SpvOpFUnordGreaterThanEqual";
   case SpvOpShiftRightLogical: return "SpvOpShiftRightLogical";
   case SpvOpShiftRightArithmetic: return "SpvOpShiftRightArithmetic";
   case SpvOpShiftLeftLogical: return "SpvOpShiftLeftLogical";
   case SpvOpBitwiseOr: return "SpvOpBitwiseOr";
   case SpvOpBitwiseXor: return "SpvOpBitwiseXor";
   case SpvOpBitwiseAnd: return "SpvOpBitwiseAnd";
   case SpvOpNot: return "SpvOpNot";
   case SpvOpBitFieldInsert: return "SpvOpBitFieldInsert";
   case SpvOpBitFieldSExtract: return "SpvOpBitFieldSExtract";
   case SpvOpBitFieldUExtract: return "SpvOpBitFieldUExtract";
   case SpvOpBitReverse: return "SpvOpBitReverse";
   case SpvOpBitCount: return "SpvOpBitCount";
   case SpvOpDPdx: return "SpvOpDPdx";
   case SpvOpDPdy: return "SpvOpDPdy";
   case SpvOpFwidth: return "SpvOpFwidth";
   case SpvOpDPdxFine: return "SpvOpDPdxFine";
   case SpvOpDPdyFine: return "SpvOpDPdyFine";
   case SpvOpFwidthFine: return "SpvOpFwidthFine";
   case SpvOpDPdxCoarse: return "SpvOpDPdxCoarse";
   case SpvOpDPdyCoarse: return "SpvOpDPdyCoarse";
   case SpvOpFwidthCoarse: return "SpvOpFwidthCoarse";
   case SpvOpEmitVertex: return "SpvOpEmitVertex";
   case SpvOpEndPrimitive: return "SpvOpEndPrimitive";
   case SpvOpEmitStreamVertex: return "SpvOpEmitStreamVertex";
   case SpvOpEndStreamPrimitive: return "SpvOpEndStreamPrimitive";
   case SpvOpControlBarrier: return "SpvOpControlBarrier";
   case SpvOpMemoryBarrier: return "SpvOpMemoryBarrier";
   case SpvOpAtomicLoad: return "SpvOpAtomicLoad";
   case SpvOpAtomicStore: return "SpvOpAtomicStore";
   case SpvOpAtomicExchange: return "SpvOpAtomicExchange";
   case SpvOpAtomicCompareExchange: return "SpvOpAtomicCompareExchange";
   case SpvOpAtomicCompareExchangeWeak: return "SpvOpAtomicCompareExchangeWeak";
   case SpvOpAtomicIIncrement: return "SpvOpAtomicIIncrement";
   case SpvOpAtomicIDecrement: return "SpvOpAtomicIDecrement";
   case SpvOpAtomicIAdd: return "SpvOpAtomicIAdd";
   case SpvOpAtomicISub: return "SpvOpAtomicISub";
   case SpvOpAtomicSMin: return "SpvOpAtomicSMin";
   case SpvOpAtomicUMin: return "SpvOpAtomicUMin";
   case SpvOpAtomicSMax: return "SpvOpAtomicSMax";
   case SpvOpAtomicUMax: return "SpvOpAtomicUMax";
   case SpvOpAtomicAnd: return "SpvOpAtomicAnd";
   case SpvOpAtomicOr: return "SpvOpAtomicOr";
   case SpvOpAtomicXor: return "SpvOpAtomicXor";
   case SpvOpPhi: return "SpvOpPhi";
   case SpvOpLoopMerge: return "SpvOpLoopMerge";
   case SpvOpSelectionMerge: return "SpvOpSelectionMerge";
   case SpvOpLabel: return "SpvOpLabel";
   case SpvOpBranch: return "SpvOpBranch";
   case SpvOpBranchConditional: return "SpvOpBranchConditional";
   case SpvOpSwitch: return "SpvOpSwitch";
   case SpvOpKill: return "SpvOpKill";
   case SpvOpReturn: return "SpvOpReturn";
   case SpvOpReturnValue: return "SpvOpReturnValue";
   case SpvOpUnreachable: return "SpvOpUnreachable";
   case SpvOpLifetimeStart: return "SpvOpLifetimeStart";
   case SpvOpLifetimeStop: return "SpvOpLifetimeStop";
   case SpvOpGroupAsyncCopy: return "SpvOpGroupAsyncCopy";
   case SpvOpGroupWaitEvents: return "SpvOpGroupWaitEvents";
   case SpvOpGroupAll: return "SpvOpGroupAll";
   case SpvOpGroupAny: return "SpvOpGroupAny";
   case SpvOpGroupBroadcast: return "SpvOpGroupBroadcast";
   case SpvOpGroupIAdd: return "SpvOpGroupIAdd";
   case SpvOpGroupFAdd: return "SpvOpGroupFAdd";
   case SpvOpGroupFMin: return "SpvOpGroupFMin";
   case SpvOpGroupUMin: return "SpvOpGroupUMin";
   case SpvOpGroupSMin: return "SpvOpGroupSMin";
   case SpvOpGroupFMax: return "SpvOpGroupFMax";
   case SpvOpGroupUMax: return "SpvOpGroupUMax";
   case SpvOpGroupSMax: return "SpvOpGroupSMax";
   case SpvOpReadPipe: return "SpvOpReadPipe";
   case SpvOpWritePipe: return "SpvOpWritePipe";
   case SpvOpReservedReadPipe: return "SpvOpReservedReadPipe";
   case SpvOpReservedWritePipe: return "SpvOpReservedWritePipe";
   case SpvOpReserveReadPipePackets: return "SpvOpReserveReadPipePackets";
   case SpvOpReserveWritePipePackets: return "SpvOpReserveWritePipePackets";
   case SpvOpCommitReadPipe: return "SpvOpCommitReadPipe";
   case SpvOpCommitWritePipe: return "SpvOpCommitWritePipe";
   case SpvOpIsValidReserveId: return "SpvOpIsValidReserveId";
   case SpvOpGetNumPipePackets: return "SpvOpGetNumPipePackets";
   case SpvOpGetMaxPipePackets: return "SpvOpGetMaxPipePackets";
   case SpvOpGroupReserveReadPipePackets: return "SpvOpGroupReserveReadPipePackets";
   case SpvOpGroupReserveWritePipePackets: return "SpvOpGroupReserveWritePipePackets";
   case SpvOpGroupCommitReadPipe: return "SpvOpGroupCommitReadPipe";
   case SpvOpGroupCommitWritePipe: return "SpvOpGroupCommitWritePipe";
   case SpvOpEnqueueMarker: return "SpvOpEnqueueMarker";
   case SpvOpEnqueueKernel: return "SpvOpEnqueueKernel";
   case SpvOpGetKernelNDrangeSubGroupCount: return "SpvOpGetKernelNDrangeSubGroupCount";
   case SpvOpGetKernelNDrangeMaxSubGroupSize: return "SpvOpGetKernelNDrangeMaxSubGroupSize";
   case SpvOpGetKernelWorkGroupSize: return "SpvOpGetKernelWorkGroupSize";
   case SpvOpGetKernelPreferredWorkGroupSizeMultiple: return "SpvOpGetKernelPreferredWorkGroupSizeMultiple";
   case SpvOpRetainEvent: return "SpvOpRetainEvent";
   case SpvOpReleaseEvent: return "SpvOpReleaseEvent";
   case SpvOpCreateUserEvent: return "SpvOpCreateUserEvent";
   case SpvOpIsValidEvent: return "SpvOpIsValidEvent";
   case SpvOpSetUserEventStatus: return "SpvOpSetUserEventStatus";
   case SpvOpCaptureEventProfilingInfo: return "SpvOpCaptureEventProfilingInfo";
   case SpvOpGetDefaultQueue: return "SpvOpGetDefaultQueue";
   case SpvOpBuildNDRange: return "SpvOpBuildNDRange";
   case SpvOpImageSparseSampleImplicitLod: return "SpvOpImageSparseSampleImplicitLod";
   case SpvOpImageSparseSampleExplicitLod: return "SpvOpImageSparseSampleExplicitLod";
   case SpvOpImageSparseSampleDrefImplicitLod: return "SpvOpImageSparseSampleDrefImplicitLod";
   case SpvOpImageSparseSampleDrefExplicitLod: return "SpvOpImageSparseSampleDrefExplicitLod";
   case SpvOpImageSparseSampleProjImplicitLod: return "SpvOpImageSparseSampleProjImplicitLod";
   case SpvOpImageSparseSampleProjExplicitLod: return "SpvOpImageSparseSampleProjExplicitLod";
   case SpvOpImageSparseSampleProjDrefImplicitLod: return "SpvOpImageSparseSampleProjDrefImplicitLod";
   case SpvOpImageSparseSampleProjDrefExplicitLod: return "SpvOpImageSparseSampleProjDrefExplicitLod";
   case SpvOpImageSparseFetch: return "SpvOpImageSparseFetch";
   case SpvOpImageSparseGather: return "SpvOpImageSparseGather";
   case SpvOpImageSparseDrefGather: return "SpvOpImageSparseDrefGather";
   case SpvOpImageSparseTexelsResident: return "SpvOpImageSparseTexelsResident";
   case SpvOpNoLine: return "SpvOpNoLine";
   case SpvOpAtomicFlagTestAndSet: return "SpvOpAtomicFlagTestAndSet";
   case SpvOpAtomicFlagClear: return "SpvOpAtomicFlagClear";
   case SpvOpImageSparseRead: return "SpvOpImageSparseRead";
   case SpvOpSizeOf: return "SpvOpSizeOf";
   case SpvOpTypePipeStorage: return "SpvOpTypePipeStorage";
   case SpvOpConstantPipeStorage: return "SpvOpConstantPipeStorage";
   case SpvOpCreatePipeFromPipeStorage: return "SpvOpCreatePipeFromPipeStorage";
   case SpvOpGetKernelLocalSizeForSubgroupCount: return "SpvOpGetKernelLocalSizeForSubgroupCount";
   case SpvOpGetKernelMaxNumSubgroups: return "SpvOpGetKernelMaxNumSubgroups";
   case SpvOpTypeNamedBarrier: return "SpvOpTypeNamedBarrier";
   case SpvOpNamedBarrierInitialize: return "SpvOpNamedBarrierInitialize";
   case SpvOpMemoryNamedBarrier: return "SpvOpMemoryNamedBarrier";
   case SpvOpModuleProcessed: return "SpvOpModuleProcessed";
   case SpvOpExecutionModeId: return "SpvOpExecutionModeId";
   case SpvOpDecorateId: return "SpvOpDecorateId";
   case SpvOpGroupNonUniformElect: return "SpvOpGroupNonUniformElect";
   case SpvOpGroupNonUniformAll: return "SpvOpGroupNonUniformAll";
   case SpvOpGroupNonUniformAny: return "SpvOpGroupNonUniformAny";
   case SpvOpGroupNonUniformAllEqual: return "SpvOpGroupNonUniformAllEqual";
   case SpvOpGroupNonUniformBroadcast: return "SpvOpGroupNonUniformBroadcast";
   case SpvOpGroupNonUniformBroadcastFirst: return "SpvOpGroupNonUniformBroadcastFirst";
   case SpvOpGroupNonUniformBallot: return "SpvOpGroupNonUniformBallot";
   case SpvOpGroupNonUniformInverseBallot: return "SpvOpGroupNonUniformInverseBallot";
   case SpvOpGroupNonUniformBallotBitExtract: return "SpvOpGroupNonUniformBallotBitExtract";
   case SpvOpGroupNonUniformBallotBitCount: return "SpvOpGroupNonUniformBallotBitCount";
   case SpvOpGroupNonUniformBallotFindLSB: return "SpvOpGroupNonUniformBallotFindLSB";
   case SpvOpGroupNonUniformBallotFindMSB: return "SpvOpGroupNonUniformBallotFindMSB";
   case SpvOpGroupNonUniformShuffle: return "SpvOpGroupNonUniformShuffle";
   case SpvOpGroupNonUniformShuffleXor: return "SpvOpGroupNonUniformShuffleXor";
   case SpvOpGroupNonUniformShuffleUp: return "SpvOpGroupNonUniformShuffleUp";
   case SpvOpGroupNonUniformShuffleDown: return "SpvOpGroupNonUniformShuffleDown";
   case SpvOpGroupNonUniformIAdd: return "SpvOpGroupNonUniformIAdd";
   case SpvOpGroupNonUniformFAdd: return "SpvOpGroupNonUniformFAdd";
   case SpvOpGroupNonUniformIMul: return "SpvOpGroupNonUniformIMul";
   case SpvOpGroupNonUniformFMul: return "SpvOpGroupNonUniformFMul";
   case SpvOpGroupNonUniformSMin: return "SpvOpGroupNonUniformSMin";
   case SpvOpGroupNonUniformUMin: return "SpvOpGroupNonUniformUMin";
   case SpvOpGroupNonUniformFMin: return "SpvOpGroupNonUniformFMin";
   case SpvOpGroupNonUniformSMax: return "SpvOpGroupNonUniformSMax";
   case SpvOpGroupNonUniformUMax: return "SpvOpGroupNonUniformUMax";
   case SpvOpGroupNonUniformFMax: return "SpvOpGroupNonUniformFMax";
   case SpvOpGroupNonUniformBitwiseAnd: return "SpvOpGroupNonUniformBitwiseAnd";
   case SpvOpGroupNonUniformBitwiseOr: return "SpvOpGroupNonUniformBitwiseOr";
   case SpvOpGroupNonUniformBitwiseXor: return "SpvOpGroupNonUniformBitwiseXor";
   case SpvOpGroupNonUniformLogicalAnd: return "SpvOpGroupNonUniformLogicalAnd";
   case SpvOpGroupNonUniformLogicalOr: return "SpvOpGroupNonUniformLogicalOr";
   case SpvOpGroupNonUniformLogicalXor: return "SpvOpGroupNonUniformLogicalXor";
   case SpvOpGroupNonUniformQuadBroadcast: return "SpvOpGroupNonUniformQuadBroadcast";
   case SpvOpGroupNonUniformQuadSwap: return "SpvOpGroupNonUniformQuadSwap";
   case SpvOpCopyLogical: return "SpvOpCopyLogical";
   case SpvOpPtrEqual: return "SpvOpPtrEqual";
   case SpvOpPtrNotEqual: return "SpvOpPtrNotEqual";
   case SpvOpPtrDiff: return "SpvOpPtrDiff";
   case SpvOpColorAttachmentReadEXT: return "SpvOpColorAttachmentReadEXT";
   case SpvOpDepthAttachmentReadEXT: return "SpvOpDepthAttachmentReadEXT";
   case SpvOpStencilAttachmentReadEXT: return "SpvOpStencilAttachmentReadEXT";
   case SpvOpTerminateInvocation: return "SpvOpTerminateInvocation";
   case SpvOpTypeUntypedPointerKHR: return "SpvOpTypeUntypedPointerKHR";
   case SpvOpUntypedVariableKHR: return "SpvOpUntypedVariableKHR";
   case SpvOpUntypedAccessChainKHR: return "SpvOpUntypedAccessChainKHR";
   case SpvOpUntypedInBoundsAccessChainKHR: return "SpvOpUntypedInBoundsAccessChainKHR";
   case SpvOpSubgroupBallotKHR: return "SpvOpSubgroupBallotKHR";
   case SpvOpSubgroupFirstInvocationKHR: return "SpvOpSubgroupFirstInvocationKHR";
   case SpvOpUntypedPtrAccessChainKHR: return "SpvOpUntypedPtrAccessChainKHR";
   case SpvOpUntypedInBoundsPtrAccessChainKHR: return "SpvOpUntypedInBoundsPtrAccessChainKHR";
   case SpvOpUntypedArrayLengthKHR: return "SpvOpUntypedArrayLengthKHR";
   case SpvOpUntypedPrefetchKHR: return "SpvOpUntypedPrefetchKHR";
   case SpvOpSubgroupAllKHR: return "SpvOpSubgroupAllKHR";
   case SpvOpSubgroupAnyKHR: return "SpvOpSubgroupAnyKHR";
   case SpvOpSubgroupAllEqualKHR: return "SpvOpSubgroupAllEqualKHR";
   case SpvOpGroupNonUniformRotateKHR: return "SpvOpGroupNonUniformRotateKHR";
   case SpvOpSubgroupReadInvocationKHR: return "SpvOpSubgroupReadInvocationKHR";
   case SpvOpExtInstWithForwardRefsKHR: return "SpvOpExtInstWithForwardRefsKHR";
   case SpvOpTraceRayKHR: return "SpvOpTraceRayKHR";
   case SpvOpExecuteCallableKHR: return "SpvOpExecuteCallableKHR";
   case SpvOpConvertUToAccelerationStructureKHR: return "SpvOpConvertUToAccelerationStructureKHR";
   case SpvOpIgnoreIntersectionKHR: return "SpvOpIgnoreIntersectionKHR";
   case SpvOpTerminateRayKHR: return "SpvOpTerminateRayKHR";
   case SpvOpSDot: return "SpvOpSDot";
   case SpvOpUDot: return "SpvOpUDot";
   case SpvOpSUDot: return "SpvOpSUDot";
   case SpvOpSDotAccSat: return "SpvOpSDotAccSat";
   case SpvOpUDotAccSat: return "SpvOpUDotAccSat";
   case SpvOpSUDotAccSat: return "SpvOpSUDotAccSat";
   case SpvOpTypeCooperativeMatrixKHR: return "SpvOpTypeCooperativeMatrixKHR";
   case SpvOpCooperativeMatrixLoadKHR: return "SpvOpCooperativeMatrixLoadKHR";
   case SpvOpCooperativeMatrixStoreKHR: return "SpvOpCooperativeMatrixStoreKHR";
   case SpvOpCooperativeMatrixMulAddKHR: return "SpvOpCooperativeMatrixMulAddKHR";
   case SpvOpCooperativeMatrixLengthKHR: return "SpvOpCooperativeMatrixLengthKHR";
   case SpvOpConstantCompositeReplicateEXT: return "SpvOpConstantCompositeReplicateEXT";
   case SpvOpSpecConstantCompositeReplicateEXT: return "SpvOpSpecConstantCompositeReplicateEXT";
   case SpvOpCompositeConstructReplicateEXT: return "SpvOpCompositeConstructReplicateEXT";
   case SpvOpTypeRayQueryKHR: return "SpvOpTypeRayQueryKHR";
   case SpvOpRayQueryInitializeKHR: return "SpvOpRayQueryInitializeKHR";
   case SpvOpRayQueryTerminateKHR: return "SpvOpRayQueryTerminateKHR";
   case SpvOpRayQueryGenerateIntersectionKHR: return "SpvOpRayQueryGenerateIntersectionKHR";
   case SpvOpRayQueryConfirmIntersectionKHR: return "SpvOpRayQueryConfirmIntersectionKHR";
   case SpvOpRayQueryProceedKHR: return "SpvOpRayQueryProceedKHR";
   case SpvOpRayQueryGetIntersectionTypeKHR: return "SpvOpRayQueryGetIntersectionTypeKHR";
   case SpvOpImageSampleWeightedQCOM: return "SpvOpImageSampleWeightedQCOM";
   case SpvOpImageBoxFilterQCOM: return "SpvOpImageBoxFilterQCOM";
   case SpvOpImageBlockMatchSSDQCOM: return "SpvOpImageBlockMatchSSDQCOM";
   case SpvOpImageBlockMatchSADQCOM: return "SpvOpImageBlockMatchSADQCOM";
   case SpvOpImageBlockMatchWindowSSDQCOM: return "SpvOpImageBlockMatchWindowSSDQCOM";
   case SpvOpImageBlockMatchWindowSADQCOM: return "SpvOpImageBlockMatchWindowSADQCOM";
   case SpvOpImageBlockMatchGatherSSDQCOM: return "SpvOpImageBlockMatchGatherSSDQCOM";
   case SpvOpImageBlockMatchGatherSADQCOM: return "SpvOpImageBlockMatchGatherSADQCOM";
   case SpvOpGroupIAddNonUniformAMD: return "SpvOpGroupIAddNonUniformAMD";
   case SpvOpGroupFAddNonUniformAMD: return "SpvOpGroupFAddNonUniformAMD";
   case SpvOpGroupFMinNonUniformAMD: return "SpvOpGroupFMinNonUniformAMD";
   case SpvOpGroupUMinNonUniformAMD: return "SpvOpGroupUMinNonUniformAMD";
   case SpvOpGroupSMinNonUniformAMD: return "SpvOpGroupSMinNonUniformAMD";
   case SpvOpGroupFMaxNonUniformAMD: return "SpvOpGroupFMaxNonUniformAMD";
   case SpvOpGroupUMaxNonUniformAMD: return "SpvOpGroupUMaxNonUniformAMD";
   case SpvOpGroupSMaxNonUniformAMD: return "SpvOpGroupSMaxNonUniformAMD";
   case SpvOpFragmentMaskFetchAMD: return "SpvOpFragmentMaskFetchAMD";
   case SpvOpFragmentFetchAMD: return "SpvOpFragmentFetchAMD";
   case SpvOpReadClockKHR: return "SpvOpReadClockKHR";
   case SpvOpAllocateNodePayloadsAMDX: return "SpvOpAllocateNodePayloadsAMDX";
   case SpvOpEnqueueNodePayloadsAMDX: return "SpvOpEnqueueNodePayloadsAMDX";
   case SpvOpTypeNodePayloadArrayAMDX: return "SpvOpTypeNodePayloadArrayAMDX";
   case SpvOpFinishWritingNodePayloadAMDX: return "SpvOpFinishWritingNodePayloadAMDX";
   case SpvOpNodePayloadArrayLengthAMDX: return "SpvOpNodePayloadArrayLengthAMDX";
   case SpvOpIsNodePayloadValidAMDX: return "SpvOpIsNodePayloadValidAMDX";
   case SpvOpConstantStringAMDX: return "SpvOpConstantStringAMDX";
   case SpvOpSpecConstantStringAMDX: return "SpvOpSpecConstantStringAMDX";
   case SpvOpGroupNonUniformQuadAllKHR: return "SpvOpGroupNonUniformQuadAllKHR";
   case SpvOpGroupNonUniformQuadAnyKHR: return "SpvOpGroupNonUniformQuadAnyKHR";
   case SpvOpHitObjectRecordHitMotionNV: return "SpvOpHitObjectRecordHitMotionNV";
   case SpvOpHitObjectRecordHitWithIndexMotionNV: return "SpvOpHitObjectRecordHitWithIndexMotionNV";
   case SpvOpHitObjectRecordMissMotionNV: return "SpvOpHitObjectRecordMissMotionNV";
   case SpvOpHitObjectGetWorldToObjectNV: return "SpvOpHitObjectGetWorldToObjectNV";
   case SpvOpHitObjectGetObjectToWorldNV: return "SpvOpHitObjectGetObjectToWorldNV";
   case SpvOpHitObjectGetObjectRayDirectionNV: return "SpvOpHitObjectGetObjectRayDirectionNV";
   case SpvOpHitObjectGetObjectRayOriginNV: return "SpvOpHitObjectGetObjectRayOriginNV";
   case SpvOpHitObjectTraceRayMotionNV: return "SpvOpHitObjectTraceRayMotionNV";
   case SpvOpHitObjectGetShaderRecordBufferHandleNV: return "SpvOpHitObjectGetShaderRecordBufferHandleNV";
   case SpvOpHitObjectGetShaderBindingTableRecordIndexNV: return "SpvOpHitObjectGetShaderBindingTableRecordIndexNV";
   case SpvOpHitObjectRecordEmptyNV: return "SpvOpHitObjectRecordEmptyNV";
   case SpvOpHitObjectTraceRayNV: return "SpvOpHitObjectTraceRayNV";
   case SpvOpHitObjectRecordHitNV: return "SpvOpHitObjectRecordHitNV";
   case SpvOpHitObjectRecordHitWithIndexNV: return "SpvOpHitObjectRecordHitWithIndexNV";
   case SpvOpHitObjectRecordMissNV: return "SpvOpHitObjectRecordMissNV";
   case SpvOpHitObjectExecuteShaderNV: return "SpvOpHitObjectExecuteShaderNV";
   case SpvOpHitObjectGetCurrentTimeNV: return "SpvOpHitObjectGetCurrentTimeNV";
   case SpvOpHitObjectGetAttributesNV: return "SpvOpHitObjectGetAttributesNV";
   case SpvOpHitObjectGetHitKindNV: return "SpvOpHitObjectGetHitKindNV";
   case SpvOpHitObjectGetPrimitiveIndexNV: return "SpvOpHitObjectGetPrimitiveIndexNV";
   case SpvOpHitObjectGetGeometryIndexNV: return "SpvOpHitObjectGetGeometryIndexNV";
   case SpvOpHitObjectGetInstanceIdNV: return "SpvOpHitObjectGetInstanceIdNV";
   case SpvOpHitObjectGetInstanceCustomIndexNV: return "SpvOpHitObjectGetInstanceCustomIndexNV";
   case SpvOpHitObjectGetWorldRayDirectionNV: return "SpvOpHitObjectGetWorldRayDirectionNV";
   case SpvOpHitObjectGetWorldRayOriginNV: return "SpvOpHitObjectGetWorldRayOriginNV";
   case SpvOpHitObjectGetRayTMaxNV: return "SpvOpHitObjectGetRayTMaxNV";
   case SpvOpHitObjectGetRayTMinNV: return "SpvOpHitObjectGetRayTMinNV";
   case SpvOpHitObjectIsEmptyNV: return "SpvOpHitObjectIsEmptyNV";
   case SpvOpHitObjectIsHitNV: return "SpvOpHitObjectIsHitNV";
   case SpvOpHitObjectIsMissNV: return "SpvOpHitObjectIsMissNV";
   case SpvOpReorderThreadWithHitObjectNV: return "SpvOpReorderThreadWithHitObjectNV";
   case SpvOpReorderThreadWithHintNV: return "SpvOpReorderThreadWithHintNV";
   case SpvOpTypeHitObjectNV: return "SpvOpTypeHitObjectNV";
   case SpvOpImageSampleFootprintNV: return "SpvOpImageSampleFootprintNV";
   case SpvOpTypeCooperativeVectorNV: return "SpvOpTypeCooperativeVectorNV";
   case SpvOpCooperativeVectorMatrixMulNV: return "SpvOpCooperativeVectorMatrixMulNV";
   case SpvOpCooperativeVectorOuterProductAccumulateNV: return "SpvOpCooperativeVectorOuterProductAccumulateNV";
   case SpvOpCooperativeVectorReduceSumAccumulateNV: return "SpvOpCooperativeVectorReduceSumAccumulateNV";
   case SpvOpCooperativeVectorMatrixMulAddNV: return "SpvOpCooperativeVectorMatrixMulAddNV";
   case SpvOpCooperativeMatrixConvertNV: return "SpvOpCooperativeMatrixConvertNV";
   case SpvOpEmitMeshTasksEXT: return "SpvOpEmitMeshTasksEXT";
   case SpvOpSetMeshOutputsEXT: return "SpvOpSetMeshOutputsEXT";
   case SpvOpGroupNonUniformPartitionNV: return "SpvOpGroupNonUniformPartitionNV";
   case SpvOpWritePackedPrimitiveIndices4x8NV: return "SpvOpWritePackedPrimitiveIndices4x8NV";
   case SpvOpFetchMicroTriangleVertexPositionNV: return "SpvOpFetchMicroTriangleVertexPositionNV";
   case SpvOpFetchMicroTriangleVertexBarycentricNV: return "SpvOpFetchMicroTriangleVertexBarycentricNV";
   case SpvOpCooperativeVectorLoadNV: return "SpvOpCooperativeVectorLoadNV";
   case SpvOpCooperativeVectorStoreNV: return "SpvOpCooperativeVectorStoreNV";
   case SpvOpReportIntersectionKHR: return "SpvOpReportIntersectionKHR";
   case SpvOpIgnoreIntersectionNV: return "SpvOpIgnoreIntersectionNV";
   case SpvOpTerminateRayNV: return "SpvOpTerminateRayNV";
   case SpvOpTraceNV: return "SpvOpTraceNV";
   case SpvOpTraceMotionNV: return "SpvOpTraceMotionNV";
   case SpvOpTraceRayMotionNV: return "SpvOpTraceRayMotionNV";
   case SpvOpRayQueryGetIntersectionTriangleVertexPositionsKHR: return "SpvOpRayQueryGetIntersectionTriangleVertexPositionsKHR";
   case SpvOpTypeAccelerationStructureKHR: return "SpvOpTypeAccelerationStructureKHR";
   case SpvOpExecuteCallableNV: return "SpvOpExecuteCallableNV";
   case SpvOpRayQueryGetClusterIdNV: return "SpvOpRayQueryGetClusterIdNV";
   case SpvOpHitObjectGetClusterIdNV: return "SpvOpHitObjectGetClusterIdNV";
   case SpvOpTypeCooperativeMatrixNV: return "SpvOpTypeCooperativeMatrixNV";
   case SpvOpCooperativeMatrixLoadNV: return "SpvOpCooperativeMatrixLoadNV";
   case SpvOpCooperativeMatrixStoreNV: return "SpvOpCooperativeMatrixStoreNV";
   case SpvOpCooperativeMatrixMulAddNV: return "SpvOpCooperativeMatrixMulAddNV";
   case SpvOpCooperativeMatrixLengthNV: return "SpvOpCooperativeMatrixLengthNV";
   case SpvOpBeginInvocationInterlockEXT: return "SpvOpBeginInvocationInterlockEXT";
   case SpvOpEndInvocationInterlockEXT: return "SpvOpEndInvocationInterlockEXT";
   case SpvOpCooperativeMatrixReduceNV: return "SpvOpCooperativeMatrixReduceNV";
   case SpvOpCooperativeMatrixLoadTensorNV: return "SpvOpCooperativeMatrixLoadTensorNV";
   case SpvOpCooperativeMatrixStoreTensorNV: return "SpvOpCooperativeMatrixStoreTensorNV";
   case SpvOpCooperativeMatrixPerElementOpNV: return "SpvOpCooperativeMatrixPerElementOpNV";
   case SpvOpTypeTensorLayoutNV: return "SpvOpTypeTensorLayoutNV";
   case SpvOpTypeTensorViewNV: return "SpvOpTypeTensorViewNV";
   case SpvOpCreateTensorLayoutNV: return "SpvOpCreateTensorLayoutNV";
   case SpvOpTensorLayoutSetDimensionNV: return "SpvOpTensorLayoutSetDimensionNV";
   case SpvOpTensorLayoutSetStrideNV: return "SpvOpTensorLayoutSetStrideNV";
   case SpvOpTensorLayoutSliceNV: return "SpvOpTensorLayoutSliceNV";
   case SpvOpTensorLayoutSetClampValueNV: return "SpvOpTensorLayoutSetClampValueNV";
   case SpvOpCreateTensorViewNV: return "SpvOpCreateTensorViewNV";
   case SpvOpTensorViewSetDimensionNV: return "SpvOpTensorViewSetDimensionNV";
   case SpvOpTensorViewSetStrideNV: return "SpvOpTensorViewSetStrideNV";
   case SpvOpDemoteToHelperInvocation: return "SpvOpDemoteToHelperInvocation";
   case SpvOpIsHelperInvocationEXT: return "SpvOpIsHelperInvocationEXT";
   case SpvOpTensorViewSetClipNV: return "SpvOpTensorViewSetClipNV";
   case SpvOpTensorLayoutSetBlockSizeNV: return "SpvOpTensorLayoutSetBlockSizeNV";
   case SpvOpCooperativeMatrixTransposeNV: return "SpvOpCooperativeMatrixTransposeNV";
   case SpvOpConvertUToImageNV: return "SpvOpConvertUToImageNV";
   case SpvOpConvertUToSamplerNV: return "SpvOpConvertUToSamplerNV";
   case SpvOpConvertImageToUNV: return "SpvOpConvertImageToUNV";
   case SpvOpConvertSamplerToUNV: return "SpvOpConvertSamplerToUNV";
   case SpvOpConvertUToSampledImageNV: return "SpvOpConvertUToSampledImageNV";
   case SpvOpConvertSampledImageToUNV: return "SpvOpConvertSampledImageToUNV";
   case SpvOpSamplerImageAddressingModeNV: return "SpvOpSamplerImageAddressingModeNV";
   case SpvOpRawAccessChainNV: return "SpvOpRawAccessChainNV";
   case SpvOpRayQueryGetIntersectionSpherePositionNV: return "SpvOpRayQueryGetIntersectionSpherePositionNV";
   case SpvOpRayQueryGetIntersectionSphereRadiusNV: return "SpvOpRayQueryGetIntersectionSphereRadiusNV";
   case SpvOpRayQueryGetIntersectionLSSPositionsNV: return "SpvOpRayQueryGetIntersectionLSSPositionsNV";
   case SpvOpRayQueryGetIntersectionLSSRadiiNV: return "SpvOpRayQueryGetIntersectionLSSRadiiNV";
   case SpvOpRayQueryGetIntersectionLSSHitValueNV: return "SpvOpRayQueryGetIntersectionLSSHitValueNV";
   case SpvOpHitObjectGetSpherePositionNV: return "SpvOpHitObjectGetSpherePositionNV";
   case SpvOpHitObjectGetSphereRadiusNV: return "SpvOpHitObjectGetSphereRadiusNV";
   case SpvOpHitObjectGetLSSPositionsNV: return "SpvOpHitObjectGetLSSPositionsNV";
   case SpvOpHitObjectGetLSSRadiiNV: return "SpvOpHitObjectGetLSSRadiiNV";
   case SpvOpHitObjectIsSphereHitNV: return "SpvOpHitObjectIsSphereHitNV";
   case SpvOpHitObjectIsLSSHitNV: return "SpvOpHitObjectIsLSSHitNV";
   case SpvOpRayQueryIsSphereHitNV: return "SpvOpRayQueryIsSphereHitNV";
   case SpvOpRayQueryIsLSSHitNV: return "SpvOpRayQueryIsLSSHitNV";
   case SpvOpSubgroupShuffleINTEL: return "SpvOpSubgroupShuffleINTEL";
   case SpvOpSubgroupShuffleDownINTEL: return "SpvOpSubgroupShuffleDownINTEL";
   case SpvOpSubgroupShuffleUpINTEL: return "SpvOpSubgroupShuffleUpINTEL";
   case SpvOpSubgroupShuffleXorINTEL: return "SpvOpSubgroupShuffleXorINTEL";
   case SpvOpSubgroupBlockReadINTEL: return "SpvOpSubgroupBlockReadINTEL";
   case SpvOpSubgroupBlockWriteINTEL: return "SpvOpSubgroupBlockWriteINTEL";
   case SpvOpSubgroupImageBlockReadINTEL: return "SpvOpSubgroupImageBlockReadINTEL";
   case SpvOpSubgroupImageBlockWriteINTEL: return "SpvOpSubgroupImageBlockWriteINTEL";
   case SpvOpSubgroupImageMediaBlockReadINTEL: return "SpvOpSubgroupImageMediaBlockReadINTEL";
   case SpvOpSubgroupImageMediaBlockWriteINTEL: return "SpvOpSubgroupImageMediaBlockWriteINTEL";
   case SpvOpUCountLeadingZerosINTEL: return "SpvOpUCountLeadingZerosINTEL";
   case SpvOpUCountTrailingZerosINTEL: return "SpvOpUCountTrailingZerosINTEL";
   case SpvOpAbsISubINTEL: return "SpvOpAbsISubINTEL";
   case SpvOpAbsUSubINTEL: return "SpvOpAbsUSubINTEL";
   case SpvOpIAddSatINTEL: return "SpvOpIAddSatINTEL";
   case SpvOpUAddSatINTEL: return "SpvOpUAddSatINTEL";
   case SpvOpIAverageINTEL: return "SpvOpIAverageINTEL";
   case SpvOpUAverageINTEL: return "SpvOpUAverageINTEL";
   case SpvOpIAverageRoundedINTEL: return "SpvOpIAverageRoundedINTEL";
   case SpvOpUAverageRoundedINTEL: return "SpvOpUAverageRoundedINTEL";
   case SpvOpISubSatINTEL: return "SpvOpISubSatINTEL";
   case SpvOpUSubSatINTEL: return "SpvOpUSubSatINTEL";
   case SpvOpIMul32x16INTEL: return "SpvOpIMul32x16INTEL";
   case SpvOpUMul32x16INTEL: return "SpvOpUMul32x16INTEL";
   case SpvOpConstantFunctionPointerINTEL: return "SpvOpConstantFunctionPointerINTEL";
   case SpvOpFunctionPointerCallINTEL: return "SpvOpFunctionPointerCallINTEL";
   case SpvOpAsmTargetINTEL: return "SpvOpAsmTargetINTEL";
   case SpvOpAsmINTEL: return "SpvOpAsmINTEL";
   case SpvOpAsmCallINTEL: return "SpvOpAsmCallINTEL";
   case SpvOpAtomicFMinEXT: return "SpvOpAtomicFMinEXT";
   case SpvOpAtomicFMaxEXT: return "SpvOpAtomicFMaxEXT";
   case SpvOpAssumeTrueKHR: return "SpvOpAssumeTrueKHR";
   case SpvOpExpectKHR: return "SpvOpExpectKHR";
   case SpvOpDecorateString: return "SpvOpDecorateString";
   case SpvOpMemberDecorateString: return "SpvOpMemberDecorateString";
   case SpvOpVmeImageINTEL: return "SpvOpVmeImageINTEL";
   case SpvOpTypeVmeImageINTEL: return "SpvOpTypeVmeImageINTEL";
   case SpvOpTypeAvcImePayloadINTEL: return "SpvOpTypeAvcImePayloadINTEL";
   case SpvOpTypeAvcRefPayloadINTEL: return "SpvOpTypeAvcRefPayloadINTEL";
   case SpvOpTypeAvcSicPayloadINTEL: return "SpvOpTypeAvcSicPayloadINTEL";
   case SpvOpTypeAvcMcePayloadINTEL: return "SpvOpTypeAvcMcePayloadINTEL";
   case SpvOpTypeAvcMceResultINTEL: return "SpvOpTypeAvcMceResultINTEL";
   case SpvOpTypeAvcImeResultINTEL: return "SpvOpTypeAvcImeResultINTEL";
   case SpvOpTypeAvcImeResultSingleReferenceStreamoutINTEL: return "SpvOpTypeAvcImeResultSingleReferenceStreamoutINTEL";
   case SpvOpTypeAvcImeResultDualReferenceStreamoutINTEL: return "SpvOpTypeAvcImeResultDualReferenceStreamoutINTEL";
   case SpvOpTypeAvcImeSingleReferenceStreaminINTEL: return "SpvOpTypeAvcImeSingleReferenceStreaminINTEL";
   case SpvOpTypeAvcImeDualReferenceStreaminINTEL: return "SpvOpTypeAvcImeDualReferenceStreaminINTEL";
   case SpvOpTypeAvcRefResultINTEL: return "SpvOpTypeAvcRefResultINTEL";
   case SpvOpTypeAvcSicResultINTEL: return "SpvOpTypeAvcSicResultINTEL";
   case SpvOpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL";
   case SpvOpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL: return "SpvOpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL";
   case SpvOpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL";
   case SpvOpSubgroupAvcMceSetInterShapePenaltyINTEL: return "SpvOpSubgroupAvcMceSetInterShapePenaltyINTEL";
   case SpvOpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL";
   case SpvOpSubgroupAvcMceSetInterDirectionPenaltyINTEL: return "SpvOpSubgroupAvcMceSetInterDirectionPenaltyINTEL";
   case SpvOpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL";
   case SpvOpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL: return "SpvOpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL";
   case SpvOpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL: return "SpvOpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL";
   case SpvOpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL: return "SpvOpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL";
   case SpvOpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL: return "SpvOpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL";
   case SpvOpSubgroupAvcMceSetMotionVectorCostFunctionINTEL: return "SpvOpSubgroupAvcMceSetMotionVectorCostFunctionINTEL";
   case SpvOpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL";
   case SpvOpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL";
   case SpvOpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL: return "SpvOpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL";
   case SpvOpSubgroupAvcMceSetAcOnlyHaarINTEL: return "SpvOpSubgroupAvcMceSetAcOnlyHaarINTEL";
   case SpvOpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL: return "SpvOpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL";
   case SpvOpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL: return "SpvOpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL";
   case SpvOpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL: return "SpvOpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL";
   case SpvOpSubgroupAvcMceConvertToImePayloadINTEL: return "SpvOpSubgroupAvcMceConvertToImePayloadINTEL";
   case SpvOpSubgroupAvcMceConvertToImeResultINTEL: return "SpvOpSubgroupAvcMceConvertToImeResultINTEL";
   case SpvOpSubgroupAvcMceConvertToRefPayloadINTEL: return "SpvOpSubgroupAvcMceConvertToRefPayloadINTEL";
   case SpvOpSubgroupAvcMceConvertToRefResultINTEL: return "SpvOpSubgroupAvcMceConvertToRefResultINTEL";
   case SpvOpSubgroupAvcMceConvertToSicPayloadINTEL: return "SpvOpSubgroupAvcMceConvertToSicPayloadINTEL";
   case SpvOpSubgroupAvcMceConvertToSicResultINTEL: return "SpvOpSubgroupAvcMceConvertToSicResultINTEL";
   case SpvOpSubgroupAvcMceGetMotionVectorsINTEL: return "SpvOpSubgroupAvcMceGetMotionVectorsINTEL";
   case SpvOpSubgroupAvcMceGetInterDistortionsINTEL: return "SpvOpSubgroupAvcMceGetInterDistortionsINTEL";
   case SpvOpSubgroupAvcMceGetBestInterDistortionsINTEL: return "SpvOpSubgroupAvcMceGetBestInterDistortionsINTEL";
   case SpvOpSubgroupAvcMceGetInterMajorShapeINTEL: return "SpvOpSubgroupAvcMceGetInterMajorShapeINTEL";
   case SpvOpSubgroupAvcMceGetInterMinorShapeINTEL: return "SpvOpSubgroupAvcMceGetInterMinorShapeINTEL";
   case SpvOpSubgroupAvcMceGetInterDirectionsINTEL: return "SpvOpSubgroupAvcMceGetInterDirectionsINTEL";
   case SpvOpSubgroupAvcMceGetInterMotionVectorCountINTEL: return "SpvOpSubgroupAvcMceGetInterMotionVectorCountINTEL";
   case SpvOpSubgroupAvcMceGetInterReferenceIdsINTEL: return "SpvOpSubgroupAvcMceGetInterReferenceIdsINTEL";
   case SpvOpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL: return "SpvOpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL";
   case SpvOpSubgroupAvcImeInitializeINTEL: return "SpvOpSubgroupAvcImeInitializeINTEL";
   case SpvOpSubgroupAvcImeSetSingleReferenceINTEL: return "SpvOpSubgroupAvcImeSetSingleReferenceINTEL";
   case SpvOpSubgroupAvcImeSetDualReferenceINTEL: return "SpvOpSubgroupAvcImeSetDualReferenceINTEL";
   case SpvOpSubgroupAvcImeRefWindowSizeINTEL: return "SpvOpSubgroupAvcImeRefWindowSizeINTEL";
   case SpvOpSubgroupAvcImeAdjustRefOffsetINTEL: return "SpvOpSubgroupAvcImeAdjustRefOffsetINTEL";
   case SpvOpSubgroupAvcImeConvertToMcePayloadINTEL: return "SpvOpSubgroupAvcImeConvertToMcePayloadINTEL";
   case SpvOpSubgroupAvcImeSetMaxMotionVectorCountINTEL: return "SpvOpSubgroupAvcImeSetMaxMotionVectorCountINTEL";
   case SpvOpSubgroupAvcImeSetUnidirectionalMixDisableINTEL: return "SpvOpSubgroupAvcImeSetUnidirectionalMixDisableINTEL";
   case SpvOpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL: return "SpvOpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL";
   case SpvOpSubgroupAvcImeSetWeightedSadINTEL: return "SpvOpSubgroupAvcImeSetWeightedSadINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithSingleReferenceINTEL: return "SpvOpSubgroupAvcImeEvaluateWithSingleReferenceINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithDualReferenceINTEL: return "SpvOpSubgroupAvcImeEvaluateWithDualReferenceINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL: return "SpvOpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL: return "SpvOpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL: return "SpvOpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL: return "SpvOpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL: return "SpvOpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL";
   case SpvOpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL: return "SpvOpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL";
   case SpvOpSubgroupAvcImeConvertToMceResultINTEL: return "SpvOpSubgroupAvcImeConvertToMceResultINTEL";
   case SpvOpSubgroupAvcImeGetSingleReferenceStreaminINTEL: return "SpvOpSubgroupAvcImeGetSingleReferenceStreaminINTEL";
   case SpvOpSubgroupAvcImeGetDualReferenceStreaminINTEL: return "SpvOpSubgroupAvcImeGetDualReferenceStreaminINTEL";
   case SpvOpSubgroupAvcImeStripSingleReferenceStreamoutINTEL: return "SpvOpSubgroupAvcImeStripSingleReferenceStreamoutINTEL";
   case SpvOpSubgroupAvcImeStripDualReferenceStreamoutINTEL: return "SpvOpSubgroupAvcImeStripDualReferenceStreamoutINTEL";
   case SpvOpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL: return "SpvOpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL";
   case SpvOpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL: return "SpvOpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL";
   case SpvOpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL: return "SpvOpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL";
   case SpvOpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL: return "SpvOpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL";
   case SpvOpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL: return "SpvOpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL";
   case SpvOpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL: return "SpvOpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL";
   case SpvOpSubgroupAvcImeGetBorderReachedINTEL: return "SpvOpSubgroupAvcImeGetBorderReachedINTEL";
   case SpvOpSubgroupAvcImeGetTruncatedSearchIndicationINTEL: return "SpvOpSubgroupAvcImeGetTruncatedSearchIndicationINTEL";
   case SpvOpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL: return "SpvOpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL";
   case SpvOpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL: return "SpvOpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL";
   case SpvOpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL: return "SpvOpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL";
   case SpvOpSubgroupAvcFmeInitializeINTEL: return "SpvOpSubgroupAvcFmeInitializeINTEL";
   case SpvOpSubgroupAvcBmeInitializeINTEL: return "SpvOpSubgroupAvcBmeInitializeINTEL";
   case SpvOpSubgroupAvcRefConvertToMcePayloadINTEL: return "SpvOpSubgroupAvcRefConvertToMcePayloadINTEL";
   case SpvOpSubgroupAvcRefSetBidirectionalMixDisableINTEL: return "SpvOpSubgroupAvcRefSetBidirectionalMixDisableINTEL";
   case SpvOpSubgroupAvcRefSetBilinearFilterEnableINTEL: return "SpvOpSubgroupAvcRefSetBilinearFilterEnableINTEL";
   case SpvOpSubgroupAvcRefEvaluateWithSingleReferenceINTEL: return "SpvOpSubgroupAvcRefEvaluateWithSingleReferenceINTEL";
   case SpvOpSubgroupAvcRefEvaluateWithDualReferenceINTEL: return "SpvOpSubgroupAvcRefEvaluateWithDualReferenceINTEL";
   case SpvOpSubgroupAvcRefEvaluateWithMultiReferenceINTEL: return "SpvOpSubgroupAvcRefEvaluateWithMultiReferenceINTEL";
   case SpvOpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL: return "SpvOpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL";
   case SpvOpSubgroupAvcRefConvertToMceResultINTEL: return "SpvOpSubgroupAvcRefConvertToMceResultINTEL";
   case SpvOpSubgroupAvcSicInitializeINTEL: return "SpvOpSubgroupAvcSicInitializeINTEL";
   case SpvOpSubgroupAvcSicConfigureSkcINTEL: return "SpvOpSubgroupAvcSicConfigureSkcINTEL";
   case SpvOpSubgroupAvcSicConfigureIpeLumaINTEL: return "SpvOpSubgroupAvcSicConfigureIpeLumaINTEL";
   case SpvOpSubgroupAvcSicConfigureIpeLumaChromaINTEL: return "SpvOpSubgroupAvcSicConfigureIpeLumaChromaINTEL";
   case SpvOpSubgroupAvcSicGetMotionVectorMaskINTEL: return "SpvOpSubgroupAvcSicGetMotionVectorMaskINTEL";
   case SpvOpSubgroupAvcSicConvertToMcePayloadINTEL: return "SpvOpSubgroupAvcSicConvertToMcePayloadINTEL";
   case SpvOpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL: return "SpvOpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL";
   case SpvOpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL: return "SpvOpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL";
   case SpvOpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL: return "SpvOpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL";
   case SpvOpSubgroupAvcSicSetBilinearFilterEnableINTEL: return "SpvOpSubgroupAvcSicSetBilinearFilterEnableINTEL";
   case SpvOpSubgroupAvcSicSetSkcForwardTransformEnableINTEL: return "SpvOpSubgroupAvcSicSetSkcForwardTransformEnableINTEL";
   case SpvOpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL: return "SpvOpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL";
   case SpvOpSubgroupAvcSicEvaluateIpeINTEL: return "SpvOpSubgroupAvcSicEvaluateIpeINTEL";
   case SpvOpSubgroupAvcSicEvaluateWithSingleReferenceINTEL: return "SpvOpSubgroupAvcSicEvaluateWithSingleReferenceINTEL";
   case SpvOpSubgroupAvcSicEvaluateWithDualReferenceINTEL: return "SpvOpSubgroupAvcSicEvaluateWithDualReferenceINTEL";
   case SpvOpSubgroupAvcSicEvaluateWithMultiReferenceINTEL: return "SpvOpSubgroupAvcSicEvaluateWithMultiReferenceINTEL";
   case SpvOpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL: return "SpvOpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL";
   case SpvOpSubgroupAvcSicConvertToMceResultINTEL: return "SpvOpSubgroupAvcSicConvertToMceResultINTEL";
   case SpvOpSubgroupAvcSicGetIpeLumaShapeINTEL: return "SpvOpSubgroupAvcSicGetIpeLumaShapeINTEL";
   case SpvOpSubgroupAvcSicGetBestIpeLumaDistortionINTEL: return "SpvOpSubgroupAvcSicGetBestIpeLumaDistortionINTEL";
   case SpvOpSubgroupAvcSicGetBestIpeChromaDistortionINTEL: return "SpvOpSubgroupAvcSicGetBestIpeChromaDistortionINTEL";
   case SpvOpSubgroupAvcSicGetPackedIpeLumaModesINTEL: return "SpvOpSubgroupAvcSicGetPackedIpeLumaModesINTEL";
   case SpvOpSubgroupAvcSicGetIpeChromaModeINTEL: return "SpvOpSubgroupAvcSicGetIpeChromaModeINTEL";
   case SpvOpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL: return "SpvOpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL";
   case SpvOpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL: return "SpvOpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL";
   case SpvOpSubgroupAvcSicGetInterRawSadsINTEL: return "SpvOpSubgroupAvcSicGetInterRawSadsINTEL";
   case SpvOpVariableLengthArrayINTEL: return "SpvOpVariableLengthArrayINTEL";
   case SpvOpSaveMemoryINTEL: return "SpvOpSaveMemoryINTEL";
   case SpvOpRestoreMemoryINTEL: return "SpvOpRestoreMemoryINTEL";
   case SpvOpArbitraryFloatSinCosPiINTEL: return "SpvOpArbitraryFloatSinCosPiINTEL";
   case SpvOpArbitraryFloatCastINTEL: return "SpvOpArbitraryFloatCastINTEL";
   case SpvOpArbitraryFloatCastFromIntINTEL: return "SpvOpArbitraryFloatCastFromIntINTEL";
   case SpvOpArbitraryFloatCastToIntINTEL: return "SpvOpArbitraryFloatCastToIntINTEL";
   case SpvOpArbitraryFloatAddINTEL: return "SpvOpArbitraryFloatAddINTEL";
   case SpvOpArbitraryFloatSubINTEL: return "SpvOpArbitraryFloatSubINTEL";
   case SpvOpArbitraryFloatMulINTEL: return "SpvOpArbitraryFloatMulINTEL";
   case SpvOpArbitraryFloatDivINTEL: return "SpvOpArbitraryFloatDivINTEL";
   case SpvOpArbitraryFloatGTINTEL: return "SpvOpArbitraryFloatGTINTEL";
   case SpvOpArbitraryFloatGEINTEL: return "SpvOpArbitraryFloatGEINTEL";
   case SpvOpArbitraryFloatLTINTEL: return "SpvOpArbitraryFloatLTINTEL";
   case SpvOpArbitraryFloatLEINTEL: return "SpvOpArbitraryFloatLEINTEL";
   case SpvOpArbitraryFloatEQINTEL: return "SpvOpArbitraryFloatEQINTEL";
   case SpvOpArbitraryFloatRecipINTEL: return "SpvOpArbitraryFloatRecipINTEL";
   case SpvOpArbitraryFloatRSqrtINTEL: return "SpvOpArbitraryFloatRSqrtINTEL";
   case SpvOpArbitraryFloatCbrtINTEL: return "SpvOpArbitraryFloatCbrtINTEL";
   case SpvOpArbitraryFloatHypotINTEL: return "SpvOpArbitraryFloatHypotINTEL";
   case SpvOpArbitraryFloatSqrtINTEL: return "SpvOpArbitraryFloatSqrtINTEL";
   case SpvOpArbitraryFloatLogINTEL: return "SpvOpArbitraryFloatLogINTEL";
   case SpvOpArbitraryFloatLog2INTEL: return "SpvOpArbitraryFloatLog2INTEL";
   case SpvOpArbitraryFloatLog10INTEL: return "SpvOpArbitraryFloatLog10INTEL";
   case SpvOpArbitraryFloatLog1pINTEL: return "SpvOpArbitraryFloatLog1pINTEL";
   case SpvOpArbitraryFloatExpINTEL: return "SpvOpArbitraryFloatExpINTEL";
   case SpvOpArbitraryFloatExp2INTEL: return "SpvOpArbitraryFloatExp2INTEL";
   case SpvOpArbitraryFloatExp10INTEL: return "SpvOpArbitraryFloatExp10INTEL";
   case SpvOpArbitraryFloatExpm1INTEL: return "SpvOpArbitraryFloatExpm1INTEL";
   case SpvOpArbitraryFloatSinINTEL: return "SpvOpArbitraryFloatSinINTEL";
   case SpvOpArbitraryFloatCosINTEL: return "SpvOpArbitraryFloatCosINTEL";
   case SpvOpArbitraryFloatSinCosINTEL: return "SpvOpArbitraryFloatSinCosINTEL";
   case SpvOpArbitraryFloatSinPiINTEL: return "SpvOpArbitraryFloatSinPiINTEL";
   case SpvOpArbitraryFloatCosPiINTEL: return "SpvOpArbitraryFloatCosPiINTEL";
   case SpvOpArbitraryFloatASinINTEL: return "SpvOpArbitraryFloatASinINTEL";
   case SpvOpArbitraryFloatASinPiINTEL: return "SpvOpArbitraryFloatASinPiINTEL";
   case SpvOpArbitraryFloatACosINTEL: return "SpvOpArbitraryFloatACosINTEL";
   case SpvOpArbitraryFloatACosPiINTEL: return "SpvOpArbitraryFloatACosPiINTEL";
   case SpvOpArbitraryFloatATanINTEL: return "SpvOpArbitraryFloatATanINTEL";
   case SpvOpArbitraryFloatATanPiINTEL: return "SpvOpArbitraryFloatATanPiINTEL";
   case SpvOpArbitraryFloatATan2INTEL: return "SpvOpArbitraryFloatATan2INTEL";
   case SpvOpArbitraryFloatPowINTEL: return "SpvOpArbitraryFloatPowINTEL";
   case SpvOpArbitraryFloatPowRINTEL: return "SpvOpArbitraryFloatPowRINTEL";
   case SpvOpArbitraryFloatPowNINTEL: return "SpvOpArbitraryFloatPowNINTEL";
   case SpvOpLoopControlINTEL: return "SpvOpLoopControlINTEL";
   case SpvOpAliasDomainDeclINTEL: return "SpvOpAliasDomainDeclINTEL";
   case SpvOpAliasScopeDeclINTEL: return "SpvOpAliasScopeDeclINTEL";
   case SpvOpAliasScopeListDeclINTEL: return "SpvOpAliasScopeListDeclINTEL";
   case SpvOpFixedSqrtINTEL: return "SpvOpFixedSqrtINTEL";
   case SpvOpFixedRecipINTEL: return "SpvOpFixedRecipINTEL";
   case SpvOpFixedRsqrtINTEL: return "SpvOpFixedRsqrtINTEL";
   case SpvOpFixedSinINTEL: return "SpvOpFixedSinINTEL";
   case SpvOpFixedCosINTEL: return "SpvOpFixedCosINTEL";
   case SpvOpFixedSinCosINTEL: return "SpvOpFixedSinCosINTEL";
   case SpvOpFixedSinPiINTEL: return "SpvOpFixedSinPiINTEL";
   case SpvOpFixedCosPiINTEL: return "SpvOpFixedCosPiINTEL";
   case SpvOpFixedSinCosPiINTEL: return "SpvOpFixedSinCosPiINTEL";
   case SpvOpFixedLogINTEL: return "SpvOpFixedLogINTEL";
   case SpvOpFixedExpINTEL: return "SpvOpFixedExpINTEL";
   case SpvOpPtrCastToCrossWorkgroupINTEL: return "SpvOpPtrCastToCrossWorkgroupINTEL";
   case SpvOpCrossWorkgroupCastToPtrINTEL: return "SpvOpCrossWorkgroupCastToPtrINTEL";
   case SpvOpReadPipeBlockingINTEL: return "SpvOpReadPipeBlockingINTEL";
   case SpvOpWritePipeBlockingINTEL: return "SpvOpWritePipeBlockingINTEL";
   case SpvOpFPGARegINTEL: return "SpvOpFPGARegINTEL";
   case SpvOpRayQueryGetRayTMinKHR: return "SpvOpRayQueryGetRayTMinKHR";
   case SpvOpRayQueryGetRayFlagsKHR: return "SpvOpRayQueryGetRayFlagsKHR";
   case SpvOpRayQueryGetIntersectionTKHR: return "SpvOpRayQueryGetIntersectionTKHR";
   case SpvOpRayQueryGetIntersectionInstanceCustomIndexKHR: return "SpvOpRayQueryGetIntersectionInstanceCustomIndexKHR";
   case SpvOpRayQueryGetIntersectionInstanceIdKHR: return "SpvOpRayQueryGetIntersectionInstanceIdKHR";
   case SpvOpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR: return "SpvOpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR";
   case SpvOpRayQueryGetIntersectionGeometryIndexKHR: return "SpvOpRayQueryGetIntersectionGeometryIndexKHR";
   case SpvOpRayQueryGetIntersectionPrimitiveIndexKHR: return "SpvOpRayQueryGetIntersectionPrimitiveIndexKHR";
   case SpvOpRayQueryGetIntersectionBarycentricsKHR: return "SpvOpRayQueryGetIntersectionBarycentricsKHR";
   case SpvOpRayQueryGetIntersectionFrontFaceKHR: return "SpvOpRayQueryGetIntersectionFrontFaceKHR";
   case SpvOpRayQueryGetIntersectionCandidateAABBOpaqueKHR: return "SpvOpRayQueryGetIntersectionCandidateAABBOpaqueKHR";
   case SpvOpRayQueryGetIntersectionObjectRayDirectionKHR: return "SpvOpRayQueryGetIntersectionObjectRayDirectionKHR";
   case SpvOpRayQueryGetIntersectionObjectRayOriginKHR: return "SpvOpRayQueryGetIntersectionObjectRayOriginKHR";
   case SpvOpRayQueryGetWorldRayDirectionKHR: return "SpvOpRayQueryGetWorldRayDirectionKHR";
   case SpvOpRayQueryGetWorldRayOriginKHR: return "SpvOpRayQueryGetWorldRayOriginKHR";
   case SpvOpRayQueryGetIntersectionObjectToWorldKHR: return "SpvOpRayQueryGetIntersectionObjectToWorldKHR";
   case SpvOpRayQueryGetIntersectionWorldToObjectKHR: return "SpvOpRayQueryGetIntersectionWorldToObjectKHR";
   case SpvOpAtomicFAddEXT: return "SpvOpAtomicFAddEXT";
   case SpvOpTypeBufferSurfaceINTEL: return "SpvOpTypeBufferSurfaceINTEL";
   case SpvOpTypeStructContinuedINTEL: return "SpvOpTypeStructContinuedINTEL";
   case SpvOpConstantCompositeContinuedINTEL: return "SpvOpConstantCompositeContinuedINTEL";
   case SpvOpSpecConstantCompositeContinuedINTEL: return "SpvOpSpecConstantCompositeContinuedINTEL";
   case SpvOpCompositeConstructContinuedINTEL: return "SpvOpCompositeConstructContinuedINTEL";
   case SpvOpConvertFToBF16INTEL: return "SpvOpConvertFToBF16INTEL";
   case SpvOpConvertBF16ToFINTEL: return "SpvOpConvertBF16ToFINTEL";
   case SpvOpControlBarrierArriveINTEL: return "SpvOpControlBarrierArriveINTEL";
   case SpvOpControlBarrierWaitINTEL: return "SpvOpControlBarrierWaitINTEL";
   case SpvOpArithmeticFenceEXT: return "SpvOpArithmeticFenceEXT";
   case SpvOpTaskSequenceCreateINTEL: return "SpvOpTaskSequenceCreateINTEL";
   case SpvOpTaskSequenceAsyncINTEL: return "SpvOpTaskSequenceAsyncINTEL";
   case SpvOpTaskSequenceGetINTEL: return "SpvOpTaskSequenceGetINTEL";
   case SpvOpTaskSequenceReleaseINTEL: return "SpvOpTaskSequenceReleaseINTEL";
   case SpvOpTypeTaskSequenceINTEL: return "SpvOpTypeTaskSequenceINTEL";
   case SpvOpSubgroupBlockPrefetchINTEL: return "SpvOpSubgroupBlockPrefetchINTEL";
   case SpvOpSubgroup2DBlockLoadINTEL: return "SpvOpSubgroup2DBlockLoadINTEL";
   case SpvOpSubgroup2DBlockLoadTransformINTEL: return "SpvOpSubgroup2DBlockLoadTransformINTEL";
   case SpvOpSubgroup2DBlockLoadTransposeINTEL: return "SpvOpSubgroup2DBlockLoadTransposeINTEL";
   case SpvOpSubgroup2DBlockPrefetchINTEL: return "SpvOpSubgroup2DBlockPrefetchINTEL";
   case SpvOpSubgroup2DBlockStoreINTEL: return "SpvOpSubgroup2DBlockStoreINTEL";
   case SpvOpSubgroupMatrixMultiplyAccumulateINTEL: return "SpvOpSubgroupMatrixMultiplyAccumulateINTEL";
   case SpvOpGroupIMulKHR: return "SpvOpGroupIMulKHR";
   case SpvOpGroupFMulKHR: return "SpvOpGroupFMulKHR";
   case SpvOpGroupBitwiseAndKHR: return "SpvOpGroupBitwiseAndKHR";
   case SpvOpGroupBitwiseOrKHR: return "SpvOpGroupBitwiseOrKHR";
   case SpvOpGroupBitwiseXorKHR: return "SpvOpGroupBitwiseXorKHR";
   case SpvOpGroupLogicalAndKHR: return "SpvOpGroupLogicalAndKHR";
   case SpvOpGroupLogicalOrKHR: return "SpvOpGroupLogicalOrKHR";
   case SpvOpGroupLogicalXorKHR: return "SpvOpGroupLogicalXorKHR";
   case SpvOpRoundFToTF32INTEL: return "SpvOpRoundFToTF32INTEL";
   case SpvOpMaskedGatherINTEL: return "SpvOpMaskedGatherINTEL";
   case SpvOpMaskedScatterINTEL: return "SpvOpMaskedScatterINTEL";
   case SpvOpMax: break; /* silence warnings about unhandled enums. */
   }

   return "unknown";
}
