/* Generated by wayland-scanner 1.22.0 */

#ifndef QT_WINDOWMANAGER_SERVER_PROTOCOL_H
#define QT_WINDOWMANAGER_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_qt_windowmanager The qt_windowmanager protocol
 * @section page_ifaces_qt_windowmanager Interfaces
 * - @subpage page_iface_qt_windowmanager - 
 * @section page_copyright_qt_windowmanager Copyright
 * <pre>
 *
 * Copyright (C) 2015 The Qt Company Ltd.
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause
 * </pre>
 */
struct qt_windowmanager;

#ifndef QT_WINDOWMANAGER_INTERFACE
#define QT_WINDOWMANAGER_INTERFACE
/**
 * @page page_iface_qt_windowmanager qt_windowmanager
 * @section page_iface_qt_windowmanager_api API
 * See @ref iface_qt_windowmanager.
 */
/**
 * @defgroup iface_qt_windowmanager The qt_windowmanager interface
 */
extern const struct wl_interface qt_windowmanager_interface;
#endif

/**
 * @ingroup iface_qt_windowmanager
 * @struct qt_windowmanager_interface
 */
struct qt_windowmanager_interface {
	/**
	 * client requests a url to be opened
	 *
	 * If remaining is not 0 this is a multipart request, and the
	 * server must concatenate subsequent requst urls to and including
	 * a request where remaining is set to 0, before it can handle the
	 * url.
	 */
	void (*open_url)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t remaining,
			 const char *url);
};

#define QT_WINDOWMANAGER_HINTS 0
#define QT_WINDOWMANAGER_QUIT 1

/**
 * @ingroup iface_qt_windowmanager
 */
#define QT_WINDOWMANAGER_HINTS_SINCE_VERSION 1
/**
 * @ingroup iface_qt_windowmanager
 */
#define QT_WINDOWMANAGER_QUIT_SINCE_VERSION 1

/**
 * @ingroup iface_qt_windowmanager
 */
#define QT_WINDOWMANAGER_OPEN_URL_SINCE_VERSION 1

/**
 * @ingroup iface_qt_windowmanager
 * Sends an hints event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_windowmanager_send_hints(struct wl_resource *resource_, int32_t show_is_fullscreen)
{
	wl_resource_post_event(resource_, QT_WINDOWMANAGER_HINTS, show_is_fullscreen);
}

/**
 * @ingroup iface_qt_windowmanager
 * Sends an quit event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_windowmanager_send_quit(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, QT_WINDOWMANAGER_QUIT);
}

#ifdef  __cplusplus
}
#endif

#endif
