/* Generated by wayland-scanner 1.22.0 */

#ifndef WESTON_DIRECT_DISPLAY_CLIENT_PROTOCOL_H
#define WESTON_DIRECT_DISPLAY_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_weston_direct_display The weston_direct_display protocol
 * @section page_ifaces_weston_direct_display Interfaces
 * - @subpage page_iface_weston_direct_display_v1 - weston direct display
 * @section page_copyright_weston_direct_display Copyright
 * <pre>
 *
 * Copyright © 2019 Collabora Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct weston_direct_display_v1;
struct zwp_linux_buffer_params_v1;

#ifndef WESTON_DIRECT_DISPLAY_V1_INTERFACE
#define WESTON_DIRECT_DISPLAY_V1_INTERFACE
/**
 * @page page_iface_weston_direct_display_v1 weston_direct_display_v1
 * @section page_iface_weston_direct_display_v1_desc Description
 *
 * Weston extension to instruct the compositor to avoid any import
 * of the dmabuf created by 'linux-dmabuf' protocol other than the display
 * controller.
 *
 * Compositors are already going to use direct scan-out as much as possible but
 * there's no assurance that while doing so, they won't first import the dmabuf
 * in to the GPU. This extension assures the client that the compositor will
 * never attempt to import in to the GPU and pass it directly to the display
 * controller.
 *
 * Clients can make use of this extension to pass the dmabuf buffer to the
 * display controller, potentially increasing the performance and lowering the
 * bandwidth usage.
 *
 * Lastly, clients can make use of this extension in tandem with content-protection
 * one thus avoiding any GPU interaction and providing a secure-content path.
 * Also, in some cases, the memory where dmabuf are allocated are in specially
 * crafted memory zone which would be seen as an illegal memory access when the
 * GPU will attempt to read it.
 *
 * WARNING: This interface by design might break screenshoting functionality
 * as compositing might be involved while doing that. Also, do note, that in
 * case the dmabufer provided can't be imported by KMS, the client connection
 * will be terminated.
 *
 * WARNING: This extension requires 'linux-dmabuf' protocol and
 * 'zwp_linux_buffer_params_v1' be already created by 'zwp_linux_buffer_v1'.
 * @section page_iface_weston_direct_display_v1_api API
 * See @ref iface_weston_direct_display_v1.
 */
/**
 * @defgroup iface_weston_direct_display_v1 The weston_direct_display_v1 interface
 *
 * Weston extension to instruct the compositor to avoid any import
 * of the dmabuf created by 'linux-dmabuf' protocol other than the display
 * controller.
 *
 * Compositors are already going to use direct scan-out as much as possible but
 * there's no assurance that while doing so, they won't first import the dmabuf
 * in to the GPU. This extension assures the client that the compositor will
 * never attempt to import in to the GPU and pass it directly to the display
 * controller.
 *
 * Clients can make use of this extension to pass the dmabuf buffer to the
 * display controller, potentially increasing the performance and lowering the
 * bandwidth usage.
 *
 * Lastly, clients can make use of this extension in tandem with content-protection
 * one thus avoiding any GPU interaction and providing a secure-content path.
 * Also, in some cases, the memory where dmabuf are allocated are in specially
 * crafted memory zone which would be seen as an illegal memory access when the
 * GPU will attempt to read it.
 *
 * WARNING: This interface by design might break screenshoting functionality
 * as compositing might be involved while doing that. Also, do note, that in
 * case the dmabufer provided can't be imported by KMS, the client connection
 * will be terminated.
 *
 * WARNING: This extension requires 'linux-dmabuf' protocol and
 * 'zwp_linux_buffer_params_v1' be already created by 'zwp_linux_buffer_v1'.
 */
extern const struct wl_interface weston_direct_display_v1_interface;
#endif

#define WESTON_DIRECT_DISPLAY_V1_ENABLE 0
#define WESTON_DIRECT_DISPLAY_V1_DESTROY 1


/**
 * @ingroup iface_weston_direct_display_v1
 */
#define WESTON_DIRECT_DISPLAY_V1_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_weston_direct_display_v1
 */
#define WESTON_DIRECT_DISPLAY_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_weston_direct_display_v1 */
static inline void
weston_direct_display_v1_set_user_data(struct weston_direct_display_v1 *weston_direct_display_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) weston_direct_display_v1, user_data);
}

/** @ingroup iface_weston_direct_display_v1 */
static inline void *
weston_direct_display_v1_get_user_data(struct weston_direct_display_v1 *weston_direct_display_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) weston_direct_display_v1);
}

static inline uint32_t
weston_direct_display_v1_get_version(struct weston_direct_display_v1 *weston_direct_display_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) weston_direct_display_v1);
}

/**
 * @ingroup iface_weston_direct_display_v1
 *
 * This request tells the compositor not to import the dmabuf to the GPU
 * in order to bypass it entirely, such that the buffer will be directly
 * scanned-out by the display controller. If HW is not capable/or there
 * aren't any available resources to directly scan-out the buffer, a
 * placeholder should be installed in-place by the compositor. The
 * compositor may perform checks on the dmabuf and refuse to create a
 * wl_buffer if the dmabuf seems unusable for being used directly.
 *
 * Assumes that 'zwp_linux_buffer_params_v1' was already created
 * by 'zwp_linux_dmabuf_v1_create_params'.
 */
static inline void
weston_direct_display_v1_enable(struct weston_direct_display_v1 *weston_direct_display_v1, struct zwp_linux_buffer_params_v1 *dmabuf)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_direct_display_v1,
			 WESTON_DIRECT_DISPLAY_V1_ENABLE, NULL, wl_proxy_get_version((struct wl_proxy *) weston_direct_display_v1), 0, dmabuf);
}

/**
 * @ingroup iface_weston_direct_display_v1
 *
 * Destroys the factory object, but does not affect any other objects.
 */
static inline void
weston_direct_display_v1_destroy(struct weston_direct_display_v1 *weston_direct_display_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) weston_direct_display_v1,
			 WESTON_DIRECT_DISPLAY_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) weston_direct_display_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
