
#line 110 "../../../git/src/qml/parser/qqmljs.g"
// Copyright (C) 2016 The Qt Company Ltd.
// Contact: https://www.qt.io/licensing/
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#include <private/qqmljsengine_p.h>
#include <private/qqmljslexer_p.h>
#include <private/qqmljsast_p.h>
#include <private/qqmljsmemorypool_p.h>

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>


#line 417 "../../../git/src/qml/parser/qqmljs.g"


#include "qqmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qqmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qqmljs.g
//

#define UNIMPLEMENTED syntaxError(loc(1), "Unimplemented"); return false

using namespace QQmlJS;

QT_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<SourceLocation*> (realloc(location_stack, stack_size * sizeof(SourceLocation)));
    string_stack.resize(stack_size);
    rawString_stack.resize(stack_size);
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool())
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
    }
}

static inline SourceLocation location(Lexer *lexer)
{
    SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringView, 4> nameIds;
    QVarLengthArray<SourceLocation, 4> locations;
    QVarLengthArray<SourceLocation, 4> dotLocations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        dotLocations.append(m->dotToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
            currentId->dotToken = dotLocations[i];
        }

        return currentId->finish();
    }

    return 0;
}

void Parser::pushToken(int token)
{
    Q_ASSERT(last_token);
    Q_ASSERT(last_token < &token_buffer[TOKEN_BUFFER_SIZE]);
    last_token->token = yytoken;
    last_token->dval = yylval;
    last_token->spell = yytokenspell;
    last_token->raw = yytokenraw;
    last_token->loc = yylloc;
    ++last_token;
    yytoken = token;
}

void Parser::pushTokenWithEmptyLocation(int token)
{
    pushToken(token);
    yylloc = yyprevlloc;
    yylloc.offset += yylloc.length;
    yylloc.startColumn += yylloc.length;
    yylloc.length = 0;
}

int Parser::lookaheadToken(Lexer *lexer)
{
    if (yytoken < 0) {
        yyprevtoken = yytoken;
        yytoken = lexer->lex();
        yylval = lexer->tokenValue();
        yytokenspell = lexer->tokenSpell();
        yytokenraw = lexer->rawString();
        yylloc = location(lexer);
    }
    return yytoken;
}

bool Parser::ensureNoFunctionTypeAnnotations(AST::TypeAnnotation *returnValueAnnotation, AST::FormalParameterList *formals)
{
    for (auto formal = formals; formal; formal = formal->next) {
        if (formal->element && formal->element->typeAnnotation) {
            syntaxError(formal->element->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in function parameters in JavaScript functions");
            return false;
        }
    }
    if (returnValueAnnotation) {
        syntaxError(returnValueAnnotation->firstSourceLocation(), "Type annotations are not permitted for the return value of JavaScript functions");
        return false;
    }
    return true;
}

//#define PARSER_DEBUG

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_SCRIPT && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yytokenraw = lexer->rawString();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yytokenraw = first_token->raw;
                yylloc = first_token->loc;
                ++first_token;
                if (first_token == last_token)
                    first_token = last_token = &token_buffer[0];
            }
        }

#ifdef PARSER_DEBUG
       qDebug() << "   in state" << action;
#endif

        action = t_action(action, yytoken);
#ifdef PARSER_DEBUG
       qDebug() << "   current token" << yytoken << (yytoken >= 0 ? spell[yytoken] : "(null)") << "new state" << action;
#endif
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yyprevtoken = yytoken;
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                rawStringRef(1) = yytokenraw;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

#ifdef PARSER_DEBUG
          qDebug() << "        reducing through rule " << -action;
#endif

          switch (r) {

#line 658 "../../../git/src/qml/parser/qqmljs.g"

    case 0: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 666 "../../../git/src/qml/parser/qqmljs.g"

    case 1: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 674 "../../../git/src/qml/parser/qqmljs.g"

    case 2: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 682 "../../../git/src/qml/parser/qqmljs.g"

    case 3: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 690 "../../../git/src/qml/parser/qqmljs.g"

    case 4: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 698 "../../../git/src/qml/parser/qqmljs.g"

    case 5: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 707 "../../../git/src/qml/parser/qqmljs.g"

    case 6: {
        sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList, sym(2).UiObjectMemberList->finish());
    } break;

#line 715 "../../../git/src/qml/parser/qqmljs.g"

    case 8: {
        sym(1).Node = sym(1).UiHeaderItemList->finish();
    } break;

#line 722 "../../../git/src/qml/parser/qqmljs.g"

    case 9: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
    } break;

#line 729 "../../../git/src/qml/parser/qqmljs.g"

    case 10: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
    } break;

#line 736 "../../../git/src/qml/parser/qqmljs.g"

    case 11: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
    } break;

#line 743 "../../../git/src/qml/parser/qqmljs.g"

    case 12: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
    } break;

#line 757 "../../../git/src/qml/parser/qqmljs.g"

    case 18: {
        AST::UiPragmaValueList *list
            = new (pool) AST::UiPragmaValueList(stringRef(1));
        list->location = loc(1);
        sym(1).Node = list;
    } break;

#line 767 "../../../git/src/qml/parser/qqmljs.g"

    case 19: {
        AST::UiPragmaValueList *list
            = new (pool) AST::UiPragmaValueList(sym(1).UiPragmaValueList, stringRef(3));
        list->location = loc(3);
        sym(1).Node = list;
    } break;

#line 777 "../../../git/src/qml/parser/qqmljs.g"

    case 20: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2));
        pragma->pragmaToken = loc(1);
        pragma->semicolonToken = loc(3);
        sym(1).Node = pragma;
    } break;

#line 787 "../../../git/src/qml/parser/qqmljs.g"

    case 21: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(
                stringRef(2), sym(4).UiPragmaValueList->finish());
        pragma->pragmaToken = loc(1);
        pragma->colonToken = loc(3);
        pragma->semicolonToken = loc(5);
        sym(1).Node = pragma;
    } break;

#line 801 "../../../git/src/qml/parser/qqmljs.g"

    case 23: {
        sym(1).UiImport->semicolonToken = loc(2);
    } break;

#line 808 "../../../git/src/qml/parser/qqmljs.g"

    case 24: {
        const int major = sym(1).dval;
        const int minor = sym(3).dval;
        if (!QTypeRevision::isValidSegment(major) || !QTypeRevision::isValidSegment(minor)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(major, minor);
        version->majorToken = loc(1);
        version->minorToken = loc(3);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 827 "../../../git/src/qml/parser/qqmljs.g"

    case 25: {
        const int major = sym(1).dval;
        if (!QTypeRevision::isValidSegment(major)) {
            diagnostic_messages.append(
                    compileError(loc(1),
                    QLatin1String("Invalid major version. Version numbers must be >= 0 and < 255.")));
            return false;
        }
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval);
        version->majorToken = loc(1);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 843 "../../../git/src/qml/parser/qqmljs.g"

    case 26: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->semicolonToken = loc(3);
    } break;

#line 851 "../../../git/src/qml/parser/qqmljs.g"

    case 27: {
        sym(1).UiImport->version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->asToken = loc(3);
        sym(1).UiImport->importIdToken = loc(4);
        sym(1).UiImport->importId = stringRef(4);
        sym(1).UiImport->semicolonToken = loc(5);
    } break;

#line 862 "../../../git/src/qml/parser/qqmljs.g"

    case 28: {
        sym(1).UiImport->asToken = loc(2);
        sym(1).UiImport->importIdToken = loc(3);
        sym(1).UiImport->importId = stringRef(3);
        sym(1).UiImport->semicolonToken = loc(4);
    } break;

#line 872 "../../../git/src/qml/parser/qqmljs.g"

    case 29: {
        AST::UiImport *node = 0;

        if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
            node = new (pool) AST::UiImport(importIdLiteral->value);
            node->fileNameToken = loc(2);
        } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
            node = new (pool) AST::UiImport(qualifiedId);
            node->fileNameToken = loc(2);
        }

        sym(1).Node = node;

        if (node) {
            node->importToken = loc(1);
        } else {
            diagnostic_messages.append(compileError(loc(1),
             QLatin1String("Expected a qualified name id or a string literal")));

            return false; // ### remove me
        }
    } break;

#line 898 "../../../git/src/qml/parser/qqmljs.g"

    case 30: {
        sym(1).Node = nullptr;
    } break;

#line 905 "../../../git/src/qml/parser/qqmljs.g"

    case 31: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 912 "../../../git/src/qml/parser/qqmljs.g"

    case 32: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 921 "../../../git/src/qml/parser/qqmljs.g"

    case 33: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 931 "../../../git/src/qml/parser/qqmljs.g"

    case 34: {
        if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
            sym(1).UiQualifiedId = qualifiedId;
        } else {
            sym(1).UiQualifiedId = 0;

            diagnostic_messages.append(compileError(loc(1),
            QLatin1String("Expected a qualified name id")));

            return false;
        }
        AST::UiAnnotation *node = new (pool) AST::UiAnnotation(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 949 "../../../git/src/qml/parser/qqmljs.g"

case 35: {
    sym(1).Node = sym(2).Node;
} break;

#line 957 "../../../git/src/qml/parser/qqmljs.g"

    case 36: {
        sym(1).Node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotation);
    } break;

#line 964 "../../../git/src/qml/parser/qqmljs.g"

    case 37: {
        AST::UiAnnotationList *node = new (pool) AST::UiAnnotationList(sym(1).UiAnnotationList, sym(2).UiAnnotation);
        sym(1).Node = node;
    } break;

#line 972 "../../../git/src/qml/parser/qqmljs.g"

   case 38: {
       AST::UiObjectDefinition *node = sym(2).UiObjectDefinition;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = node;
   } break;

#line 983 "../../../git/src/qml/parser/qqmljs.g"

    case 40: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 990 "../../../git/src/qml/parser/qqmljs.g"

    case 41: {
        AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(sym(1).UiObjectMemberList, sym(2).UiObjectMember);
        sym(1).Node = node;
    } break;

#line 998 "../../../git/src/qml/parser/qqmljs.g"

    case 42: {
        sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
    } break;

#line 1005 "../../../git/src/qml/parser/qqmljs.g"

    case 43: {
        AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(sym(1).UiArrayMemberList, sym(3).UiObjectMember);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1014 "../../../git/src/qml/parser/qqmljs.g"

    case 44: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1024 "../../../git/src/qml/parser/qqmljs.g"

    case 45: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1034 "../../../git/src/qml/parser/qqmljs.g"

    case 46: {
        AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 1042 "../../../git/src/qml/parser/qqmljs.g"

   case 47: {
       AST::UiObjectMember *node = sym(2).UiObjectMember;
       node->annotations = sym(1).UiAnnotationList->finish();
       sym(1).Node = sym(2).Node;
   } break;

#line 1055 "../../../git/src/qml/parser/qqmljs.g"

    case 50: {
        AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(sym(1).UiQualifiedId, sym(5).UiArrayMemberList->finish());
        node->colonToken = loc(2);
        node->lbracketToken = loc(4);
        node->rbracketToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1066 "../../../git/src/qml/parser/qqmljs.g"

    case 51: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
            sym(1).UiQualifiedId, sym(4).UiQualifiedId, sym(5).UiObjectInitializer);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1076 "../../../git/src/qml/parser/qqmljs.g"

    case 52: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
          sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
        node->colonToken = loc(2);
        node->hasOnToken = true;
        sym(1).Node = node;
    } break;

#line 1088 "../../../git/src/qml/parser/qqmljs.g"

    case 53: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(4);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(5);
        sym(1).Node = node;
    } break;

#line 1101 "../../../git/src/qml/parser/qqmljs.g"

    case 54: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(5);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1114 "../../../git/src/qml/parser/qqmljs.g"
  case 55: Q_FALLTHROUGH(); 
#line 1116 "../../../git/src/qml/parser/qqmljs.g"
  case 56: Q_FALLTHROUGH(); 
#line 1118 "../../../git/src/qml/parser/qqmljs.g"

    case 57: {
        sym(1).Node = sym(3).Node;
    } break;

#line 1126 "../../../git/src/qml/parser/qqmljs.g"
  case 58: Q_FALLTHROUGH(); 
#line 1128 "../../../git/src/qml/parser/qqmljs.g"
  case 59: Q_FALLTHROUGH(); 
#line 1130 "../../../git/src/qml/parser/qqmljs.g"
  case 60: Q_FALLTHROUGH(); 
#line 1132 "../../../git/src/qml/parser/qqmljs.g"
  case 61: Q_FALLTHROUGH(); 
#line 1134 "../../../git/src/qml/parser/qqmljs.g"
  case 62: Q_FALLTHROUGH(); 
#line 1136 "../../../git/src/qml/parser/qqmljs.g"

    case 63: {
        sym(1).Node = sym(2).Node;
    } break;

#line 1143 "../../../git/src/qml/parser/qqmljs.g"

case 64:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
    } break;

#line 1153 "../../../git/src/qml/parser/qqmljs.g"

    case 65: {
    if (!m_enableIncompleteBindings) {
        diagnostic_messages.append(compileError(loc(1), QLatin1String("Incomplete binding, expected token `:` or `{`")));
        return false;
    }
    AST::EmptyStatement *statement = new (pool) AST::EmptyStatement;
    statement->semicolonToken = loc(2);
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, statement);
    sym(1).Node = node;
    } break;

#line 1167 "../../../git/src/qml/parser/qqmljs.g"
  case 66: Q_FALLTHROUGH(); 
#line 1169 "../../../git/src/qml/parser/qqmljs.g"
  case 67: Q_FALLTHROUGH(); 
#line 1171 "../../../git/src/qml/parser/qqmljs.g"

    case 68: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1180 "../../../git/src/qml/parser/qqmljs.g"

    case 69: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1189 "../../../git/src/qml/parser/qqmljs.g"

    case 70: {
        sym(1).Node = nullptr;
    } break;

#line 1196 "../../../git/src/qml/parser/qqmljs.g"

    case 71: {
        sym(1).Node = sym(1).UiParameterList->finish();
    } break;

#line 1203 "../../../git/src/qml/parser/qqmljs.g"

    case 72: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(3).Type, stringRef(1));
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        node->propertyTypeToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1214 "../../../git/src/qml/parser/qqmljs.g"

    case 73: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).Type, stringRef(2));
        node->propertyTypeToken = loc(1);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1224 "../../../git/src/qml/parser/qqmljs.g"

    case 74: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(5).Type, stringRef(3));
        node->propertyTypeToken = loc(5);
        node->commaToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1236 "../../../git/src/qml/parser/qqmljs.g"

    case 75: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).Type, stringRef(4));
        node->propertyTypeToken = loc(3);
        node->commaToken = loc(2);
        node->identifierToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1247 "../../../git/src/qml/parser/qqmljs.g"

    case 76: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->parameters = sym(4).UiParameterList;
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1261 "../../../git/src/qml/parser/qqmljs.g"

    case 77: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->setPropertyToken(loc(1));
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1287 "../../../git/src/qml/parser/qqmljs.g"

    case 81: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isRequired())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'required' attribute is not allowed."), QtCriticalMsg));
        node->m_requiredToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1298 "../../../git/src/qml/parser/qqmljs.g"

    case 82: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isDefaultMember())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'default' attribute is not allowed."), QtCriticalMsg));
        node->m_defaultToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1309 "../../../git/src/qml/parser/qqmljs.g"

    case 83: {
        AST::UiPropertyAttributes *node = sym(2).UiPropertyAttributes;
        if (node->isReadonly())
            diagnostic_messages.append(compileError(node->requiredToken(), QLatin1String("Duplicated 'readonly' attribute is not allowed."), QtCriticalMsg));
        node->m_readonlyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1320 "../../../git/src/qml/parser/qqmljs.g"

    case 84: {
        AST::UiPropertyAttributes *node = new (pool) AST::UiPropertyAttributes();
        node->m_propertyToken = loc(1);
        sym(1).UiPropertyAttributes = node;
    } break;

#line 1329 "../../../git/src/qml/parser/qqmljs.g"

    case 85: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        node->setAttributes(attributes);
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtWarningMsg));
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1348 "../../../git/src/qml/parser/qqmljs.g"

    case 87: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isReadonly())
            diagnostic_messages.append(compileError(attributes->readonlyToken(), QLatin1String("Read-only properties require an initializer."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1366 "../../../git/src/qml/parser/qqmljs.g"

/* we need OptionalSemicolon because UiScriptStatement might already parse the last semicolon
  and then we would miss a semicolon (see tests/auto/quick/qquickvisualdatamodel/data/objectlist.qml)*/
 
#line 1372 "../../../git/src/qml/parser/qqmljs.g"

    case 91: {
        AST::UiRequired *node = new (pool) AST::UiRequired(stringRef(2));
        node->requiredToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1384 "../../../git/src/qml/parser/qqmljs.g"

    case 93: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3), sym(5).Statement);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1399 "../../../git/src/qml/parser/qqmljs.g"

    case 94: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6), sym(8).Statement);
        node->typeModifier = stringRef(2);
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->colonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1418 "../../../git/src/qml/parser/qqmljs.g"

    case 96: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtCriticalMsg));
        node->setAttributes(attributes);
        node->typeModifier = stringRef(2);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7); // insert a fake ';' before ':'
        node->colonToken = loc(7);

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
        propertyName->identifierToken = loc(6);
        propertyName->next = nullptr;

        AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(propertyName, sym(10).UiArrayMemberList->finish());
        binding->colonToken = loc(7);
        binding->lbracketToken = loc(9);
        binding->rbracketToken = loc(11);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1450 "../../../git/src/qml/parser/qqmljs.g"

    case 98: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        auto attributes = sym(1).UiPropertyAttributes;
        if (attributes->isRequired())
            diagnostic_messages.append(compileError(attributes->requiredToken(), QLatin1String("Required properties with initializer do not make sense."), QtWarningMsg));
        node->setAttributes(attributes);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4); // insert a fake ';' before ':'
        node->colonToken = loc(4);

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
        propertyName->identifierToken = loc(3);
        propertyName->next = nullptr;

        AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
          propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
        binding->colonToken = loc(4);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1479 "../../../git/src/qml/parser/qqmljs.g"

    case 100: {
        auto node = new (pool) AST::UiSourceElement(sym(1).Node);
        sym(1).Node = node;
    } break;

#line 1487 "../../../git/src/qml/parser/qqmljs.g"

    case 101: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1494 "../../../git/src/qml/parser/qqmljs.g"

    case 102: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1501 "../../../git/src/qml/parser/qqmljs.g"

    case 103: {
      if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
        diagnostic_messages.append(compileError(mem->lbracketToken,
          QLatin1String("Ignored annotation"), QtWarningMsg));

        sym(1).Expression = mem->base;
      }

      if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
        sym(1).UiQualifiedId = qualifiedId;
      } else {
        sym(1).UiQualifiedId = 0;

        diagnostic_messages.append(compileError(loc(1),
          QLatin1String("Expected a qualified name id")));

        return false; // ### recover
      }
    } break;

#line 1524 "../../../git/src/qml/parser/qqmljs.g"

    case 104: {
        AST::UiEnumDeclaration *enumDeclaration = new (pool) AST::UiEnumDeclaration(stringRef(2), sym(4).UiEnumMemberList->finish());
        enumDeclaration->enumToken = loc(1);
        enumDeclaration->identifierToken = loc(2);
        enumDeclaration->lbraceToken = loc(3);
        enumDeclaration->rbraceToken = loc(5);
        sym(1).Node = enumDeclaration;
        break;
    }

#line 1537 "../../../git/src/qml/parser/qqmljs.g"

    case 105: {
        if (!stringRef(2).front().isUpper()) {
            diagnostic_messages.append(compileError(loc(2),
                QLatin1String("Type name must be upper case"), QtWarningMsg));
        }
        auto inlineComponent = new (pool) AST::UiInlineComponent(stringRef(2), sym(4).UiObjectDefinition);
        inlineComponent->componentToken = loc(1);
        inlineComponent->identifierToken = loc(2);
        sym(1).Node = inlineComponent;
    } break;

#line 1551 "../../../git/src/qml/parser/qqmljs.g"

    case 106: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1));
        node->memberToken = loc(1);
        sym(1).Node = node;
        break;
    }

#line 1561 "../../../git/src/qml/parser/qqmljs.g"

    case 107: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), sym(3).dval);
        node->memberToken = loc(1);
        node->valueToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1573 "../../../git/src/qml/parser/qqmljs.g"

    case 108: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), -sym(4).dval);
        node->memberToken = loc(1);
        node->valueToken = combine(loc(3), loc(4));
        sym(1).Node = node;
        break;
    }

#line 1584 "../../../git/src/qml/parser/qqmljs.g"

    case 109: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3));
        node->memberToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1594 "../../../git/src/qml/parser/qqmljs.g"

    case 110: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), sym(5).dval);
        node->memberToken = loc(3);
        node->valueToken = loc(5);
        sym(1).Node = node;
        break;
    }

#line 1606 "../../../git/src/qml/parser/qqmljs.g"

    case 111: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), -sym(6).dval);
        node->memberToken = loc(3);
        node->valueToken = combine(loc(5), loc(6));
        sym(1).Node = node;
        break;
    }

#line 1650 "../../../git/src/qml/parser/qqmljs.g"

    case 138: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId, sym(3).Type);
    } break;

#line 1659 "../../../git/src/qml/parser/qqmljs.g"

    case 140: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1668 "../../../git/src/qml/parser/qqmljs.g"

    case 141: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId);
    } break;

#line 1675 "../../../git/src/qml/parser/qqmljs.g"
  case 142: Q_FALLTHROUGH(); 
#line 1678 "../../../git/src/qml/parser/qqmljs.g"

    case 143: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1687 "../../../git/src/qml/parser/qqmljs.g"

    case 144: {
        sym(1).TypeAnnotation = new (pool) AST::TypeAnnotation(sym(2).Type);
        sym(1).TypeAnnotation->colonToken = loc(1);
    } break;

#line 1696 "../../../git/src/qml/parser/qqmljs.g"

    case 146: {
        sym(1).TypeAnnotation = nullptr;
    } break;

#line 1707 "../../../git/src/qml/parser/qqmljs.g"

    case 147: {
        AST::ThisExpression *node = new (pool) AST::ThisExpression();
        node->thisToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1716 "../../../git/src/qml/parser/qqmljs.g"

    case 148: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1734 "../../../git/src/qml/parser/qqmljs.g"

    case 157: {
        if (coverExpressionType != CE_ParenthesizedExpression) {
            syntaxError(coverExpressionErrorLocation, "Expected token ')'.");
            return false;
        }
    } break;

#line 1745 "../../../git/src/qml/parser/qqmljs.g"

    case 158: {
        AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
        node->lparenToken = loc(1);
        node->rparenToken = loc(3);
        sym(1).Node = node;
        coverExpressionType = CE_ParenthesizedExpression;
    } break;

#line 1756 "../../../git/src/qml/parser/qqmljs.g"

    case 159: {
        sym(1).Node = nullptr;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1765 "../../../git/src/qml/parser/qqmljs.g"

    case 160: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(2).PatternElement))->finish(pool);
        sym(1).Node = node;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1775 "../../../git/src/qml/parser/qqmljs.g"

    case 161: {
        AST::FormalParameterList *list = sym(2).Expression->reparseAsFormalParameterList(pool);
        if (!list) {
            syntaxError(loc(1), "Invalid Arrow parameter list.");
            return false;
        }
        if (sym(4).Node) {
            list = new (pool) AST::FormalParameterList(list, sym(4).PatternElement);
        }
        coverExpressionErrorLocation = loc(4);
        coverExpressionType = CE_FormalParameterList;
        sym(1).Node = list->finish(pool);
    } break;

#line 1792 "../../../git/src/qml/parser/qqmljs.g"

    case 162: {
        AST::NullExpression *node = new (pool) AST::NullExpression();
        node->nullToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1801 "../../../git/src/qml/parser/qqmljs.g"

    case 163: {
        AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
        node->trueToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1810 "../../../git/src/qml/parser/qqmljs.g"

    case 164: {
        AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
        node->falseToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1819 "../../../git/src/qml/parser/qqmljs.g"

    case 165: {
        AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1828 "../../../git/src/qml/parser/qqmljs.g"
  case 166: Q_FALLTHROUGH(); 
#line 1831 "../../../git/src/qml/parser/qqmljs.g"

    case 167: {
        AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1843 "../../../git/src/qml/parser/qqmljs.g"

{
    Lexer::RegExpBodyPrefix prefix;
    case 168:
        prefix = Lexer::NoPrefix;
        goto scan_regexp;

#line 1855 "../../../git/src/qml/parser/qqmljs.g"

    case 169:
        prefix = Lexer::EqualPrefix;
        goto scan_regexp;

    scan_regexp: {
        bool rx = lexer->scanRegExp(prefix);
        if (!rx) {
            diagnostic_messages.append(compileError(location(lexer), lexer->errorMessage()));
            return false;
        }

        loc(1).length = lexer->tokenLength();
        yylloc = loc(1); // adjust the location of the current token

        AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;
}

#line 1879 "../../../git/src/qml/parser/qqmljs.g"

    case 170: {
        AST::PatternElementList *list = nullptr;
        if (sym(2).Elision)
            list = (new (pool) AST::PatternElementList(sym(2).Elision, nullptr))->finish();
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1892 "../../../git/src/qml/parser/qqmljs.g"

    case 171: {
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList->finish());
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1902 "../../../git/src/qml/parser/qqmljs.g"

    case 172: {
        auto *list = sym(2).PatternElementList;
        if (sym(4).Elision) {
            AST::PatternElementList *l = new (pool) AST::PatternElementList(sym(4).Elision, nullptr);
            list = list->append(l);
        }
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list->finish());
        node->lbracketToken = loc(1);
        node->commaToken = loc(3);
        node->rbracketToken = loc(5);
        sym(1).Node = node;
        Q_ASSERT(node->isValidArrayLiteral());
    } break;

#line 1919 "../../../git/src/qml/parser/qqmljs.g"

    case 173: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(1).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(nullptr, e);
    } break;

#line 1927 "../../../git/src/qml/parser/qqmljs.g"

    case 174: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(2).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision->finish(), e);
    } break;

#line 1935 "../../../git/src/qml/parser/qqmljs.g"

    case 175: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
        sym(1).Node = node;
    } break;

#line 1943 "../../../git/src/qml/parser/qqmljs.g"

    case 176: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(4).Expression);
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, e);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 1952 "../../../git/src/qml/parser/qqmljs.g"

    case 177: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 1960 "../../../git/src/qml/parser/qqmljs.g"

    case 178: {
        AST::Elision *node = new (pool) AST::Elision();
        node->commaToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1969 "../../../git/src/qml/parser/qqmljs.g"

    case 179: {
        AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1978 "../../../git/src/qml/parser/qqmljs.g"

    case 180: {
        sym(1).Node = nullptr;
    } break;

#line 1985 "../../../git/src/qml/parser/qqmljs.g"

    case 181: {
        sym(1).Node = sym(1).Elision->finish();
    } break;

#line 1992 "../../../git/src/qml/parser/qqmljs.g"

    case 182: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Expression, AST::PatternElement::SpreadElement);
        sym(1).Node = node;
    } break;

#line 2000 "../../../git/src/qml/parser/qqmljs.g"

    case 183: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern();
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2010 "../../../git/src/qml/parser/qqmljs.g"

    case 184: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2020 "../../../git/src/qml/parser/qqmljs.g"

    case 185: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2031 "../../../git/src/qml/parser/qqmljs.g"
  case 186: Q_FALLTHROUGH(); 
#line 2033 "../../../git/src/qml/parser/qqmljs.g"

    case 187: {
      sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 2040 "../../../git/src/qml/parser/qqmljs.g"
  case 188: Q_FALLTHROUGH(); 
#line 2042 "../../../git/src/qml/parser/qqmljs.g"

    case 189: {
        AST::PatternPropertyList *node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
        sym(1).Node = node;
    } break;

#line 2050 "../../../git/src/qml/parser/qqmljs.g"

    case 190: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *expr = new (pool) AST::IdentifierExpression(stringRef(1));
        expr->identifierToken = loc(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, expr);
        sym(1).Node = node;
    } break;

#line 2065 "../../../git/src/qml/parser/qqmljs.g"

    case 192: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *left = new (pool) AST::IdentifierExpression(stringRef(1));
        left->identifierToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::BinaryExpression *assignment = new (pool) AST::BinaryExpression(left, QSOperator::Assign, sym(2).Expression);
        assignment->operatorToken = loc(2);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, assignment);
        sym(1).Node = node;

    } break;

#line 2085 "../../../git/src/qml/parser/qqmljs.g"
  case 193: Q_FALLTHROUGH(); 
#line 2087 "../../../git/src/qml/parser/qqmljs.g"

    case 194: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Expression);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (!AST::cast<AST::ComputedPropertyName *>(sym(1).PropertyName))
                c->name = driver->newStringRef(sym(1).PropertyName->asString());
        }
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2105 "../../../git/src/qml/parser/qqmljs.g"

    case 198: {
        AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2114 "../../../git/src/qml/parser/qqmljs.g"
  case 199: Q_FALLTHROUGH(); 
#line 2116 "../../../git/src/qml/parser/qqmljs.g"

    case 200: {
        AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2125 "../../../git/src/qml/parser/qqmljs.g"
  case 201: Q_FALLTHROUGH(); 
#line 2127 "../../../git/src/qml/parser/qqmljs.g"

    case 202: {
        AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2178 "../../../git/src/qml/parser/qqmljs.g"

    case 243: {
        AST::ComputedPropertyName *node = new (pool) AST::ComputedPropertyName(sym(2).Expression);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2187 "../../../git/src/qml/parser/qqmljs.g"
  case 244: Q_FALLTHROUGH(); 
#line 2189 "../../../git/src/qml/parser/qqmljs.g"

case 245: {
    auto node = new (pool) AST::InitializerExpression(sym(2).Expression);
    node->equalToken = loc(1);
    sym(1).Expression = node;
} break;

#line 2199 "../../../git/src/qml/parser/qqmljs.g"
  case 246: Q_FALLTHROUGH(); 
#line 2201 "../../../git/src/qml/parser/qqmljs.g"

    case 247: {
        sym(1).Node = nullptr;
    } break;

#line 2211 "../../../git/src/qml/parser/qqmljs.g"

    case 250: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        node->hasNoSubstitution = true;
        sym(1).Node = node;
    } break;

#line 2221 "../../../git/src/qml/parser/qqmljs.g"

    case 251: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2230 "../../../git/src/qml/parser/qqmljs.g"
  case 252: Q_FALLTHROUGH(); 
#line 2233 "../../../git/src/qml/parser/qqmljs.g"

    case 253: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), sym(2).Expression);
        node->next = sym(3).Template;
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2246 "../../../git/src/qml/parser/qqmljs.g"

    case 255: {
        AST::SuperLiteral *node = new (pool) AST::SuperLiteral();
        node->superToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2256 "../../../git/src/qml/parser/qqmljs.g"
  case 256: Q_FALLTHROUGH(); 
#line 2258 "../../../git/src/qml/parser/qqmljs.g"

    case 257: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2267 "../../../git/src/qml/parser/qqmljs.g"

    case 258: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2279 "../../../git/src/qml/parser/qqmljs.g"
  case 259:
    {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken= loc(1);
        sym(1).Node = node;
    } Q_FALLTHROUGH();

#line 2287 "../../../git/src/qml/parser/qqmljs.g"
  case 260: Q_FALLTHROUGH(); 
#line 2289 "../../../git/src/qml/parser/qqmljs.g"

    case 261: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2299 "../../../git/src/qml/parser/qqmljs.g"

    case 262: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2312 "../../../git/src/qml/parser/qqmljs.g"

    case 264: {
        AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
        node->newToken = loc(1);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        sym(1).Node = node;
    } break;

#line 2328 "../../../git/src/qml/parser/qqmljs.g"

    case 267: {
        AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
        node->newToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2338 "../../../git/src/qml/parser/qqmljs.g"
  case 268: Q_FALLTHROUGH(); 
#line 2340 "../../../git/src/qml/parser/qqmljs.g"

    case 269: {
        AST::TaggedTemplate *node = new (pool) AST::TaggedTemplate(sym(1).Expression, sym(2).Template);
        sym(1).Node = node;
    } break;

#line 2348 "../../../git/src/qml/parser/qqmljs.g"

    case 270: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2358 "../../../git/src/qml/parser/qqmljs.g"

    case 271: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2369 "../../../git/src/qml/parser/qqmljs.g"
  case 272: Q_FALLTHROUGH(); 
#line 2371 "../../../git/src/qml/parser/qqmljs.g"

    case 273: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2381 "../../../git/src/qml/parser/qqmljs.g"

    case 274: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(4).ArgumentList);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2393 "../../../git/src/qml/parser/qqmljs.g"

    case 275: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2403 "../../../git/src/qml/parser/qqmljs.g"

    case 276: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(4).Expression);
        node->lbracketToken = loc(3);
        node->rbracketToken = loc(5);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2414 "../../../git/src/qml/parser/qqmljs.g"

    case 277: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2424 "../../../git/src/qml/parser/qqmljs.g"

    case 278: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        node->isOptional = true;
        sym(1).Node = node;
    } break;

#line 2435 "../../../git/src/qml/parser/qqmljs.g"

    case 279: {
        sym(1).Node = nullptr;
    } break;

#line 2442 "../../../git/src/qml/parser/qqmljs.g"
  case 280: Q_FALLTHROUGH(); 
#line 2444 "../../../git/src/qml/parser/qqmljs.g"

    case 281: {
        sym(1).Node = sym(1).ArgumentList->finish();
    } break;

#line 2451 "../../../git/src/qml/parser/qqmljs.g"

    case 282: {
        sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
    } break;

#line 2458 "../../../git/src/qml/parser/qqmljs.g"

    case 283: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(2).Expression);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2467 "../../../git/src/qml/parser/qqmljs.g"

    case 284: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2476 "../../../git/src/qml/parser/qqmljs.g"

    case 285: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(4).Expression);
        node->commaToken = loc(2);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2491 "../../../git/src/qml/parser/qqmljs.g"

    case 289: {
        AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
        node->incrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2500 "../../../git/src/qml/parser/qqmljs.g"

    case 290: {
        AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
        node->decrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2509 "../../../git/src/qml/parser/qqmljs.g"

    case 291: {
        AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
        node->incrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2518 "../../../git/src/qml/parser/qqmljs.g"

    case 292: {
        AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
        node->decrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2529 "../../../git/src/qml/parser/qqmljs.g"

    case 294: {
        AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
        node->deleteToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2538 "../../../git/src/qml/parser/qqmljs.g"

    case 295: {
        AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
        node->voidToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2547 "../../../git/src/qml/parser/qqmljs.g"

    case 296: {
        AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
        node->typeofToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2556 "../../../git/src/qml/parser/qqmljs.g"

    case 297: {
        AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
        node->plusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2565 "../../../git/src/qml/parser/qqmljs.g"

    case 298: {
        AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
        node->minusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2574 "../../../git/src/qml/parser/qqmljs.g"

    case 299: {
        AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
        node->tildeToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2583 "../../../git/src/qml/parser/qqmljs.g"

    case 300: {
        AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
        node->notToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2594 "../../../git/src/qml/parser/qqmljs.g"

    case 302: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Exp, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2605 "../../../git/src/qml/parser/qqmljs.g"

    case 304: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2614 "../../../git/src/qml/parser/qqmljs.g"

    case 305: {
        sym(1).ival = QSOperator::Mul;
    } break;

#line 2621 "../../../git/src/qml/parser/qqmljs.g"

    case 306: {
        sym(1).ival = QSOperator::Div;
    } break;

#line 2628 "../../../git/src/qml/parser/qqmljs.g"

    case 307: {
        sym(1).ival = QSOperator::Mod;
    } break;

#line 2637 "../../../git/src/qml/parser/qqmljs.g"

    case 309: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Add, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2646 "../../../git/src/qml/parser/qqmljs.g"

    case 310: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Sub, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2657 "../../../git/src/qml/parser/qqmljs.g"

    case 312: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::LShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2666 "../../../git/src/qml/parser/qqmljs.g"

    case 313: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::RShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2675 "../../../git/src/qml/parser/qqmljs.g"

    case 314: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::URShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2687 "../../../git/src/qml/parser/qqmljs.g"
  case 317: Q_FALLTHROUGH(); 
#line 2689 "../../../git/src/qml/parser/qqmljs.g"

    case 318: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2698 "../../../git/src/qml/parser/qqmljs.g"

    case 319: {
        sym(1).ival = QSOperator::Lt;
    } break;

#line 2704 "../../../git/src/qml/parser/qqmljs.g"

    case 320: {
        sym(1).ival = QSOperator::Gt;
    } break;

#line 2710 "../../../git/src/qml/parser/qqmljs.g"

    case 321: {
        sym(1).ival = QSOperator::Le;
    } break;

#line 2716 "../../../git/src/qml/parser/qqmljs.g"

    case 322: {
        sym(1).ival = QSOperator::Ge;
    } break;

#line 2722 "../../../git/src/qml/parser/qqmljs.g"

    case 323: {
        sym(1).ival = QSOperator::InstanceOf;
    } break;

#line 2728 "../../../git/src/qml/parser/qqmljs.g"

    case 324: {
        sym(1).ival = QSOperator::As;
    } break;

#line 2735 "../../../git/src/qml/parser/qqmljs.g"

    case 325: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::In, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2747 "../../../git/src/qml/parser/qqmljs.g"
  case 328: Q_FALLTHROUGH(); 
#line 2749 "../../../git/src/qml/parser/qqmljs.g"

    case 329: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2758 "../../../git/src/qml/parser/qqmljs.g"

    case 330: {
        sym(1).ival = QSOperator::Equal;
    } break;

#line 2764 "../../../git/src/qml/parser/qqmljs.g"

    case 331: {
        sym(1).ival = QSOperator::NotEqual;
    } break;

#line 2770 "../../../git/src/qml/parser/qqmljs.g"

    case 332: {
        sym(1).ival = QSOperator::StrictEqual;
    } break;

#line 2776 "../../../git/src/qml/parser/qqmljs.g"

    case 333: {
        sym(1).ival = QSOperator::StrictNotEqual;
    } break;

#line 2787 "../../../git/src/qml/parser/qqmljs.g"
  case 336: Q_FALLTHROUGH(); 
#line 2789 "../../../git/src/qml/parser/qqmljs.g"

    case 337: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2802 "../../../git/src/qml/parser/qqmljs.g"
  case 340: Q_FALLTHROUGH(); 
#line 2804 "../../../git/src/qml/parser/qqmljs.g"

    case 341: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2816 "../../../git/src/qml/parser/qqmljs.g"
  case 344: Q_FALLTHROUGH(); 
#line 2818 "../../../git/src/qml/parser/qqmljs.g"

    case 345: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2830 "../../../git/src/qml/parser/qqmljs.g"
  case 348: Q_FALLTHROUGH(); 
#line 2832 "../../../git/src/qml/parser/qqmljs.g"

    case 349: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::And, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2844 "../../../git/src/qml/parser/qqmljs.g"
  case 352: Q_FALLTHROUGH(); 
#line 2846 "../../../git/src/qml/parser/qqmljs.g"

    case 353: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Or, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2858 "../../../git/src/qml/parser/qqmljs.g"
  case 356: Q_FALLTHROUGH(); 
#line 2860 "../../../git/src/qml/parser/qqmljs.g"

    case 357: {

        auto *lhs = sym(1).Expression;
        auto *rhs = sym(3).Expression;

        // Check if lhs or rhs contain || or &&

        if (lhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = lhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Left-hand side may not contain || or &&");
                return false;
            }
        }

        if (rhs->binaryExpressionCast() != nullptr) {
            auto *binaryExpr = rhs->binaryExpressionCast();
            if (binaryExpr->op == QSOperator::And || binaryExpr->op == QSOperator::Or) {
                syntaxError(binaryExpr->operatorToken, "Right-hand side may not contain || or &&");
                return false;
            }
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(lhs, QSOperator::Coalesce, rhs);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2894 "../../../git/src/qml/parser/qqmljs.g"
  case 360: Q_FALLTHROUGH(); 
#line 2896 "../../../git/src/qml/parser/qqmljs.g"

    case 361: {
        AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression, sym(3).Expression, sym(5).Expression);
        node->questionToken = loc(2);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2915 "../../../git/src/qml/parser/qqmljs.g"
  case 368: Q_FALLTHROUGH(); 
#line 2917 "../../../git/src/qml/parser/qqmljs.g"

    case 369: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(1).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                f->name = id->name;
        }
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                c->name = id->name;
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Assign, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2948 "../../../git/src/qml/parser/qqmljs.g"
  case 370: Q_FALLTHROUGH(); 
#line 2950 "../../../git/src/qml/parser/qqmljs.g"

    case 371: {
        if (sym(1).Expression->containsOptionalChain()) {
            syntaxError(loc(1), QStringLiteral("Optional chains are not permitted on the left-hand-side in assignments"));
        }
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2962 "../../../git/src/qml/parser/qqmljs.g"

    case 372: {
        sym(1).ival = QSOperator::InplaceMul;
    } break;

#line 2969 "../../../git/src/qml/parser/qqmljs.g"

    case 373: {
        sym(1).ival = QSOperator::InplaceExp;
    } break;

#line 2976 "../../../git/src/qml/parser/qqmljs.g"

    case 374: {
        sym(1).ival = QSOperator::InplaceDiv;
    } break;

#line 2983 "../../../git/src/qml/parser/qqmljs.g"

    case 375: {
        sym(1).ival = QSOperator::InplaceMod;
    } break;

#line 2990 "../../../git/src/qml/parser/qqmljs.g"

    case 376: {
        sym(1).ival = QSOperator::InplaceAdd;
    } break;

#line 2997 "../../../git/src/qml/parser/qqmljs.g"

    case 377: {
        sym(1).ival = QSOperator::InplaceSub;
    } break;

#line 3004 "../../../git/src/qml/parser/qqmljs.g"

    case 378: {
        sym(1).ival = QSOperator::InplaceLeftShift;
    } break;

#line 3011 "../../../git/src/qml/parser/qqmljs.g"

    case 379: {
        sym(1).ival = QSOperator::InplaceRightShift;
    } break;

#line 3018 "../../../git/src/qml/parser/qqmljs.g"

    case 380: {
        sym(1).ival = QSOperator::InplaceURightShift;
    } break;

#line 3025 "../../../git/src/qml/parser/qqmljs.g"

    case 381: {
        sym(1).ival = QSOperator::InplaceAnd;
    } break;

#line 3032 "../../../git/src/qml/parser/qqmljs.g"

    case 382: {
        sym(1).ival = QSOperator::InplaceXor;
    } break;

#line 3039 "../../../git/src/qml/parser/qqmljs.g"

    case 383: {
        sym(1).ival = QSOperator::InplaceOr;
    } break;

#line 3049 "../../../git/src/qml/parser/qqmljs.g"
  case 386: Q_FALLTHROUGH(); 
#line 3051 "../../../git/src/qml/parser/qqmljs.g"

    case 387: {
          AST::Expression *node = new (pool) AST::Expression(sym(1).Expression, sym(3).Expression);
          node->commaToken = loc(2);
          sym(1).Node = node;
    } break;

#line 3060 "../../../git/src/qml/parser/qqmljs.g"
  case 388: Q_FALLTHROUGH(); 
#line 3062 "../../../git/src/qml/parser/qqmljs.g"

    case 389: {
      sym(1).Node = nullptr;
    } break;

#line 3074 "../../../git/src/qml/parser/qqmljs.g"

    case 392: {
        sym(1).Node = sym(3).Node;
    } break;

#line 3081 "../../../git/src/qml/parser/qqmljs.g"
  case 393: Q_FALLTHROUGH(); 
#line 3083 "../../../git/src/qml/parser/qqmljs.g"
  case 394: Q_FALLTHROUGH(); 
#line 3085 "../../../git/src/qml/parser/qqmljs.g"
  case 395: Q_FALLTHROUGH(); 
#line 3087 "../../../git/src/qml/parser/qqmljs.g"
  case 396: Q_FALLTHROUGH(); 
#line 3089 "../../../git/src/qml/parser/qqmljs.g"
  case 397: Q_FALLTHROUGH(); 
#line 3091 "../../../git/src/qml/parser/qqmljs.g"
  case 398: Q_FALLTHROUGH(); 
#line 3093 "../../../git/src/qml/parser/qqmljs.g"
  case 399: Q_FALLTHROUGH(); 
#line 3095 "../../../git/src/qml/parser/qqmljs.g"
  case 400: Q_FALLTHROUGH(); 
#line 3097 "../../../git/src/qml/parser/qqmljs.g"
  case 401: Q_FALLTHROUGH(); 
#line 3099 "../../../git/src/qml/parser/qqmljs.g"
  case 402: Q_FALLTHROUGH(); 
#line 3101 "../../../git/src/qml/parser/qqmljs.g"
  case 403: Q_FALLTHROUGH(); 
#line 3103 "../../../git/src/qml/parser/qqmljs.g"
  case 404: Q_FALLTHROUGH(); 
#line 3105 "../../../git/src/qml/parser/qqmljs.g"

    case 405: {
        sym(1).Node = sym(2).Node;
    } break;

#line 3127 "../../../git/src/qml/parser/qqmljs.g"

    case 416: {
        AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3139 "../../../git/src/qml/parser/qqmljs.g"

    case 418: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 3146 "../../../git/src/qml/parser/qqmljs.g"

    case 419: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Statement);
    } break;

#line 3153 "../../../git/src/qml/parser/qqmljs.g"

    case 420: {
        sym(1).Node = new (pool) AST::StatementList(sym(3).FunctionDeclaration);
    } break;

#line 3160 "../../../git/src/qml/parser/qqmljs.g"

    case 421: {
        sym(1).Node = nullptr;
    } break;

#line 3167 "../../../git/src/qml/parser/qqmljs.g"

    case 422: {
        sym(1).Node = sym(1).StatementList->finish();
    } break;

#line 3174 "../../../git/src/qml/parser/qqmljs.g"

    case 423: {
        sym(1).scope = AST::VariableScope::Let;
    } break;

#line 3180 "../../../git/src/qml/parser/qqmljs.g"

    case 424: {
        sym(1).scope = AST::VariableScope::Const;
    } break;

#line 3187 "../../../git/src/qml/parser/qqmljs.g"

    case 425: {
        sym(1).scope = AST::VariableScope::Var;
    } break;

#line 3194 "../../../git/src/qml/parser/qqmljs.g"
  case 426: Q_FALLTHROUGH(); 
#line 3196 "../../../git/src/qml/parser/qqmljs.g"
  case 427: Q_FALLTHROUGH(); 
#line 3198 "../../../git/src/qml/parser/qqmljs.g"
  case 428: Q_FALLTHROUGH(); 
#line 3200 "../../../git/src/qml/parser/qqmljs.g"

    case 429: {
        AST::VariableDeclarationList *declarations = sym(2).VariableDeclarationList->finish(sym(1).scope);
        for (auto it = declarations; it; it = it->next) {
            if (it->declaration && it->declaration->typeAnnotation) {
                syntaxError(it->declaration->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
                return false;
            }
        }
        AST::VariableStatement *node = new (pool) AST::VariableStatement(declarations);
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3218 "../../../git/src/qml/parser/qqmljs.g"
  case 431: Q_FALLTHROUGH(); 
#line 3220 "../../../git/src/qml/parser/qqmljs.g"
  case 432: Q_FALLTHROUGH(); 
#line 3222 "../../../git/src/qml/parser/qqmljs.g"
  case 433: Q_FALLTHROUGH(); 
#line 3224 "../../../git/src/qml/parser/qqmljs.g"

    case 434: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).PatternElement);
    } break;

#line 3231 "../../../git/src/qml/parser/qqmljs.g"
  case 435: Q_FALLTHROUGH(); 
#line 3233 "../../../git/src/qml/parser/qqmljs.g"
  case 436: Q_FALLTHROUGH(); 
#line 3235 "../../../git/src/qml/parser/qqmljs.g"
  case 437: Q_FALLTHROUGH(); 
#line 3237 "../../../git/src/qml/parser/qqmljs.g"

    case 438: {
        AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3246 "../../../git/src/qml/parser/qqmljs.g"
  case 439: Q_FALLTHROUGH(); 
#line 3248 "../../../git/src/qml/parser/qqmljs.g"
  case 440: Q_FALLTHROUGH(); 
#line 3250 "../../../git/src/qml/parser/qqmljs.g"
  case 441: Q_FALLTHROUGH(); 
#line 3252 "../../../git/src/qml/parser/qqmljs.g"

    case 442: {
        auto *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
            c->name = stringRef(1);
    } break;

#line 3266 "../../../git/src/qml/parser/qqmljs.g"
  case 443: Q_FALLTHROUGH(); 
#line 3268 "../../../git/src/qml/parser/qqmljs.g"
  case 444: Q_FALLTHROUGH(); 
#line 3270 "../../../git/src/qml/parser/qqmljs.g"
  case 445: Q_FALLTHROUGH(); 
#line 3272 "../../../git/src/qml/parser/qqmljs.g"

    case 446: {
        auto *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3281 "../../../git/src/qml/parser/qqmljs.g"

    case 447: {
        auto *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3292 "../../../git/src/qml/parser/qqmljs.g"

    case 448: {
        auto *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3303 "../../../git/src/qml/parser/qqmljs.g"

    case 449: {
        sym(1).Node = nullptr;
    } break;

#line 3310 "../../../git/src/qml/parser/qqmljs.g"
 case 450: 
#line 3312 "../../../git/src/qml/parser/qqmljs.g"

    case 451: {
        sym(1).Node = sym(1).PatternPropertyList->finish();
    } break;

#line 3319 "../../../git/src/qml/parser/qqmljs.g"

    case 452: {
        if (sym(1).Elision || sym(2).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
            sym(1).Node = l->finish();
        } else {
            sym(1).Node = nullptr;
        }
    } break;

#line 3331 "../../../git/src/qml/parser/qqmljs.g"

    case 453: {
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3338 "../../../git/src/qml/parser/qqmljs.g"

    case 454: {
        if (sym(3).Elision || sym(4).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
            l = sym(1).PatternElementList->append(l);
            sym(1).Node = l;
        }
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3350 "../../../git/src/qml/parser/qqmljs.g"

    case 455: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 3357 "../../../git/src/qml/parser/qqmljs.g"

    case 456: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
    } break;

#line 3366 "../../../git/src/qml/parser/qqmljs.g"

    case 458: {
        sym(1).PatternElementList = sym(1).PatternElementList->append(sym(3).PatternElementList);
    } break;

#line 3373 "../../../git/src/qml/parser/qqmljs.g"

    case 459: {
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
    } break;

#line 3381 "../../../git/src/qml/parser/qqmljs.g"

    case 460: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, stringRef(1), sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3396 "../../../git/src/qml/parser/qqmljs.g"

    case 461: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, stringRef(3), sym(4).Expression);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3405 "../../../git/src/qml/parser/qqmljs.g"

    case 462: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Pattern, sym(4).Expression);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3414 "../../../git/src/qml/parser/qqmljs.g"

    case 463: {
      AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
      node->identifierToken = loc(1);
      // if initializer is an anonymous function expression, we need to assign identifierref as it's name
      if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
          f->name = stringRef(1);
      if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
          c->name = stringRef(1);
      sym(1).Node = node;
    } break;

#line 3428 "../../../git/src/qml/parser/qqmljs.g"

    case 464: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3436 "../../../git/src/qml/parser/qqmljs.g"

    case 465: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(2), /*type annotation*/nullptr, nullptr, AST::PatternElement::RestElement);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3445 "../../../git/src/qml/parser/qqmljs.g"

    case 466: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr, AST::PatternElement::RestElement);
        sym(1).Node = node;
    } break;

#line 3453 "../../../git/src/qml/parser/qqmljs.g"

    case 467: {
        sym(1).Node = nullptr;
    } break;

#line 3463 "../../../git/src/qml/parser/qqmljs.g"

    case 469: {
        AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
        node->semicolonToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3478 "../../../git/src/qml/parser/qqmljs.g"

    case 470: {
        int token = lookaheadToken(lexer);
        if (token == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
        else if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS || token == T_LET || token == T_CONST)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 3489 "../../../git/src/qml/parser/qqmljs.g"

    case 471: {
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3498 "../../../git/src/qml/parser/qqmljs.g"

    case 472: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->elseToken = loc(6);
        sym(1).Node = node;
    } break;

#line 3510 "../../../git/src/qml/parser/qqmljs.g"

    case 473: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3523 "../../../git/src/qml/parser/qqmljs.g"

    case 475: {
        AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
        node->doToken = loc(1);
        node->whileToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 3536 "../../../git/src/qml/parser/qqmljs.g"

    case 476: {
        AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
        node->whileToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3547 "../../../git/src/qml/parser/qqmljs.g"

    case 477: {
        AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3560 "../../../git/src/qml/parser/qqmljs.g"
  case 478: Q_FALLTHROUGH(); 
#line 3562 "../../../git/src/qml/parser/qqmljs.g"

    case 479: {
        // ### get rid of the static_cast!
        AST::ForStatement *node = new (pool) AST::ForStatement(
          static_cast<AST::VariableStatement *>(sym(3).Node)->declarations, sym(5).Expression,
          sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3578 "../../../git/src/qml/parser/qqmljs.g"

    case 480: {
        sym(1).forEachType = AST::ForEachType::In;
    } break;

#line 3585 "../../../git/src/qml/parser/qqmljs.g"

    case 481: {
        sym(1).forEachType = AST::ForEachType::Of;
    } break;

#line 3592 "../../../git/src/qml/parser/qqmljs.g"

    case 482: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(3).Expression->patternCast()) {
            SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3614 "../../../git/src/qml/parser/qqmljs.g"

    case 483: {
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).PatternElement, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3627 "../../../git/src/qml/parser/qqmljs.g"
  case 484: Q_FALLTHROUGH(); 
#line 3629 "../../../git/src/qml/parser/qqmljs.g"

    case 485: {
        if (auto typeAnnotation = sym(3).TypeAnnotation) {
            syntaxError(typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
            return false;
        }
        auto *node = new (pool) AST::PatternElement(stringRef(2), sym(3).TypeAnnotation, nullptr);
        node->identifierToken = loc(2);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3644 "../../../git/src/qml/parser/qqmljs.g"
  case 486: Q_FALLTHROUGH(); 
#line 3646 "../../../git/src/qml/parser/qqmljs.g"

    case 487: {
        auto *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3656 "../../../git/src/qml/parser/qqmljs.g"

    case 488: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
        node->continueToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3666 "../../../git/src/qml/parser/qqmljs.g"

    case 489: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
        node->continueToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3677 "../../../git/src/qml/parser/qqmljs.g"

    case 490: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringView());
        node->breakToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3687 "../../../git/src/qml/parser/qqmljs.g"

    case 491: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
        node->breakToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3698 "../../../git/src/qml/parser/qqmljs.g"

    case 492: {
        if (!functionNestingLevel) {
            syntaxError(loc(1), "Return statement not allowed outside of Function declaration.");
            return false;
        }
        AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
        node->returnToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3712 "../../../git/src/qml/parser/qqmljs.g"

    case 493: {
        AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
        node->withToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3723 "../../../git/src/qml/parser/qqmljs.g"

    case 494: {
        AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
        node->switchToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3734 "../../../git/src/qml/parser/qqmljs.g"

    case 495: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3744 "../../../git/src/qml/parser/qqmljs.g"

    case 496: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 3754 "../../../git/src/qml/parser/qqmljs.g"

    case 497: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
    } break;

#line 3761 "../../../git/src/qml/parser/qqmljs.g"

    case 498: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
    } break;

#line 3768 "../../../git/src/qml/parser/qqmljs.g"

    case 499: {
        sym(1).Node = nullptr;
    } break;

#line 3775 "../../../git/src/qml/parser/qqmljs.g"

    case 500: {
        sym(1).Node = sym(1).CaseClauses->finish();
    } break;

#line 3782 "../../../git/src/qml/parser/qqmljs.g"

    case 501: {
        AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
        node->caseToken = loc(1);
        node->colonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3792 "../../../git/src/qml/parser/qqmljs.g"

    case 502: {
        AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
        node->defaultToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3802 "../../../git/src/qml/parser/qqmljs.g"

    case 503: {
        AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3814 "../../../git/src/qml/parser/qqmljs.g"

    case 505: {
        syntaxError(loc(3), "FunctionDeclarations are not allowed after a label.");
        return false;
    } break;

#line 3822 "../../../git/src/qml/parser/qqmljs.g"

    case 506: {
        AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
        node->throwToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3832 "../../../git/src/qml/parser/qqmljs.g"

    case 507: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3841 "../../../git/src/qml/parser/qqmljs.g"

    case 508: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3850 "../../../git/src/qml/parser/qqmljs.g"

    case 509: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3859 "../../../git/src/qml/parser/qqmljs.g"

    case 510: {
        AST::Catch *node = new (pool) AST::Catch(sym(3).PatternElement, sym(5).Block);
        node->catchToken = loc(1);
        node->lparenToken = loc(2);
        node->identifierToken = loc(3);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3871 "../../../git/src/qml/parser/qqmljs.g"

    case 511: {
        AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
        node->finallyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3880 "../../../git/src/qml/parser/qqmljs.g"

    case 512: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1));
        node->identifierToken = loc(1);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3890 "../../../git/src/qml/parser/qqmljs.g"

    case 513: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3899 "../../../git/src/qml/parser/qqmljs.g"

    case 514: {
        AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
        node->debuggerToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3916 "../../../git/src/qml/parser/qqmljs.g"

    case 516: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3933 "../../../git/src/qml/parser/qqmljs.g"

    case 517: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3949 "../../../git/src/qml/parser/qqmljs.g"

    case 519: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3965 "../../../git/src/qml/parser/qqmljs.g"

    case 520: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        if (! stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3983 "../../../git/src/qml/parser/qqmljs.g"

    case 521: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 4001 "../../../git/src/qml/parser/qqmljs.g"

    case 523: {
        sym(1).Node = nullptr;
    } break;

#line 4008 "../../../git/src/qml/parser/qqmljs.g"

    case 524: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4016 "../../../git/src/qml/parser/qqmljs.g"
 case 525: 
#line 4018 "../../../git/src/qml/parser/qqmljs.g"

    case 526: {
        sym(1).Node = sym(1).FormalParameterList->finish(pool);
    } break;

#line 4025 "../../../git/src/qml/parser/qqmljs.g"

    case 527: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4033 "../../../git/src/qml/parser/qqmljs.g"

    case 528: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement);
        sym(1).Node = node;
    } break;

#line 4042 "../../../git/src/qml/parser/qqmljs.g"

    case 529: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement);
        sym(1).Node = node;
    } break;

#line 4052 "../../../git/src/qml/parser/qqmljs.g"

    case 531: {
        ++functionNestingLevel;
    } break;

#line 4059 "../../../git/src/qml/parser/qqmljs.g"

    case 532: {
        --functionNestingLevel;
    } break;

#line 4069 "../../../git/src/qml/parser/qqmljs.g"
  case 534: Q_FALLTHROUGH(); 
#line 4071 "../../../git/src/qml/parser/qqmljs.g"

    case 535: {
        AST::ReturnStatement *ret = new (pool) AST::ReturnStatement(sym(4).Expression);
        ret->returnToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        ret->semicolonToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        AST::StatementList *statements = (new (pool) AST::StatementList(ret))->finish();
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), sym(1).FormalParameterList, statements);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation().startZeroLengthLocation() : loc(1).startZeroLengthLocation();
        f->lbraceToken = sym(4).Node->firstSourceLocation().startZeroLengthLocation();
        f->rbraceToken = sym(4).Node->lastSourceLocation().endZeroLengthLocation(driver->code());
        sym(1).Node = f;
    } break;

#line 4087 "../../../git/src/qml/parser/qqmljs.g"
  case 536: Q_FALLTHROUGH(); 
#line 4089 "../../../git/src/qml/parser/qqmljs.g"

    case 537: {
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringView(), sym(1).FormalParameterList, sym(6).StatementList);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation().startZeroLengthLocation() : loc(1).startZeroLengthLocation();
        f->lbraceToken = loc(5);
        f->rbraceToken = loc(7);
        sym(1).Node = f;
    } break;

#line 4101 "../../../git/src/qml/parser/qqmljs.g"

    case 538: {
        AST::PatternElement *e = new (pool) AST::PatternElement(stringRef(1), /*type annotation*/nullptr, nullptr, AST::PatternElement::Binding);
        e->identifierToken = loc(1);
        sym(1).FormalParameterList = (new (pool) AST::FormalParameterList(nullptr, e))->finish(pool);
    } break;

#line 4112 "../../../git/src/qml/parser/qqmljs.g"

    case 539: {
        if (coverExpressionType != CE_FormalParameterList) {
            AST::NestedExpression *ne = static_cast<AST::NestedExpression *>(sym(1).Node);
            AST::FormalParameterList *list = ne->expression->reparseAsFormalParameterList(pool);
            if (!list) {
                syntaxError(loc(1), "Invalid Arrow parameter list.");
                return false;
            }
            sym(1).Node = list->finish(pool);
        }
    } break;

#line 4130 "../../../git/src/qml/parser/qqmljs.g"

    case 540: {
        if (lookaheadToken(lexer) == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
    } break;

#line 4138 "../../../git/src/qml/parser/qqmljs.g"

    case 541: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(1), sym(3).FormalParameterList, sym(7).StatementList);
        f->functionToken = sym(1).PropertyName->firstSourceLocation();
        f->lparenToken = loc(2);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 4155 "../../../git/src/qml/parser/qqmljs.g"

    case 542: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        f->isGenerator = true;
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Method);
        sym(1).Node = node;
    } break;

#line 4173 "../../../git/src/qml/parser/qqmljs.g"

    case 543: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, /*formals*/nullptr))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), nullptr, sym(7).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Getter);
        sym(1).Node = node;
    } break;

#line 4189 "../../../git/src/qml/parser/qqmljs.g"

    case 544: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Setter);
        sym(1).Node = node;
    } break;

#line 4206 "../../../git/src/qml/parser/qqmljs.g"

    case 545: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 4214 "../../../git/src/qml/parser/qqmljs.g"

    case 546: {
        lexer->enterGeneratorBody();
    } break;

#line 4221 "../../../git/src/qml/parser/qqmljs.g"

    case 547: {
        --functionNestingLevel;
        lexer->leaveGeneratorBody();
    } break;

#line 4231 "../../../git/src/qml/parser/qqmljs.g"

    case 549: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4247 "../../../git/src/qml/parser/qqmljs.g"

    case 551: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringView(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4261 "../../../git/src/qml/parser/qqmljs.g"

    case 552: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        if (!stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4277 "../../../git/src/qml/parser/qqmljs.g"

    case 553: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringView(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4293 "../../../git/src/qml/parser/qqmljs.g"
  case 555: Q_FALLTHROUGH(); 
#line 4295 "../../../git/src/qml/parser/qqmljs.g"

    case 556: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression();
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4304 "../../../git/src/qml/parser/qqmljs.g"
  case 557: Q_FALLTHROUGH(); 
#line 4306 "../../../git/src/qml/parser/qqmljs.g"

    case 558: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(3).Expression);
        node->yieldToken = loc(1);
        node->isYieldStar = true;
        sym(1).Node = node;
    } break;

#line 4316 "../../../git/src/qml/parser/qqmljs.g"
  case 559: Q_FALLTHROUGH(); 
#line 4318 "../../../git/src/qml/parser/qqmljs.g"

    case 560: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(2).Expression);
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4328 "../../../git/src/qml/parser/qqmljs.g"

    case 561: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4340 "../../../git/src/qml/parser/qqmljs.g"

    case 562: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4352 "../../../git/src/qml/parser/qqmljs.g"

    case 563: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4363 "../../../git/src/qml/parser/qqmljs.g"

    case 564: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(QStringView(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4376 "../../../git/src/qml/parser/qqmljs.g"

    case 566: {
        if (++classNestingLevel == 1)
            lexer->setStaticIsKeyword(true);
    } break;

#line 4384 "../../../git/src/qml/parser/qqmljs.g"

    case 567: {
        if (--classNestingLevel == 0)
            lexer->setStaticIsKeyword(false);
    } break;

#line 4392 "../../../git/src/qml/parser/qqmljs.g"

    case 568: {
        sym(1).Node = nullptr;
    } break;

#line 4399 "../../../git/src/qml/parser/qqmljs.g"

    case 569: {
        sym(1).Node = sym(2).Node;
    } break;

#line 4406 "../../../git/src/qml/parser/qqmljs.g"

    case 570: {
        sym(1).Node = nullptr;
    } break;

#line 4413 "../../../git/src/qml/parser/qqmljs.g"

    case 571: {
        if (sym(1).Node)
            sym(1).Node = sym(1).ClassElementList->finish();
    } break;

#line 4423 "../../../git/src/qml/parser/qqmljs.g"

    case 573: {
        if (sym(1).Node) {
            if (sym(2).Node)
                sym(1).ClassElementList = sym(1).ClassElementList->append(sym(2).ClassElementList);
        } else if (sym(2).Node) {
            sym(1).Node = sym(2).Node;
        }
    } break;

#line 4435 "../../../git/src/qml/parser/qqmljs.g"

    case 574: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(1).PatternProperty, false);
        sym(1).Node = node;
    } break;

#line 4443 "../../../git/src/qml/parser/qqmljs.g"

    case 575: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(2).PatternProperty, true);
        sym(1).Node = node;
    } break;

#line 4451 "../../../git/src/qml/parser/qqmljs.g"

    case 576: {
        sym(1).Node = nullptr;
    } break;

#line 4460 "../../../git/src/qml/parser/qqmljs.g"

    case 577: {
        sym(1).Node = nullptr;
    } break;

#line 4469 "../../../git/src/qml/parser/qqmljs.g"

    case 579: {
        sym(1).Node = new (pool) AST::Program(sym(1).StatementList->finish());
    } break;

#line 4476 "../../../git/src/qml/parser/qqmljs.g"
  case 580: {
        sym(1).Node = new (pool) AST::ESModule(sym(1).StatementList);
    } break;

#line 4482 "../../../git/src/qml/parser/qqmljs.g"

    case 581: {
        sym(1).StatementList = sym(1).StatementList->finish();
    } break;

#line 4489 "../../../git/src/qml/parser/qqmljs.g"

    case 582: {
        sym(1).StatementList = nullptr;
    } break;

#line 4499 "../../../git/src/qml/parser/qqmljs.g"

    case 585: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 4507 "../../../git/src/qml/parser/qqmljs.g"
 case 586:  Q_FALLTHROUGH(); 
#line 4509 "../../../git/src/qml/parser/qqmljs.g"

    case 587: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Node);
    } break;

#line 4518 "../../../git/src/qml/parser/qqmljs.g"

    case 589: {
        auto decl = new (pool) AST::ImportDeclaration(sym(2).ImportClause, sym(3).FromClause);
        decl->importToken = loc(1);
        sym(1).Node = decl;
    } break;

#line 4526 "../../../git/src/qml/parser/qqmljs.g"

    case 590: {
        auto decl = new (pool) AST::ImportDeclaration(stringRef(2));
        decl->importToken = loc(1);
        decl->moduleSpecifierToken = loc(2);
        sym(1).Node = decl;
    } break;

#line 4536 "../../../git/src/qml/parser/qqmljs.g"

    case 591: {
        auto clause = new (pool) AST::ImportClause(stringRef(1));
        clause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = clause;
    } break;

#line 4544 "../../../git/src/qml/parser/qqmljs.g"

    case 592: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NameSpaceImport);
    } break;

#line 4550 "../../../git/src/qml/parser/qqmljs.g"

    case 593: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NamedImports);
    } break;

#line 4556 "../../../git/src/qml/parser/qqmljs.g"

    case 594: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NameSpaceImport);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4564 "../../../git/src/qml/parser/qqmljs.g"

    case 595: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NamedImports);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4575 "../../../git/src/qml/parser/qqmljs.g"

    case 597: {
        auto import = new (pool) AST::NameSpaceImport(stringRef(3));
        import->starToken = loc(1);
        import->importedBindingToken = loc(3);
        sym(1).NameSpaceImport = import;
    } break;

#line 4585 "../../../git/src/qml/parser/qqmljs.g"

    case 598: {
        auto namedImports = new (pool) AST::NamedImports();
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(2);
        sym(1).NamedImports = namedImports;
    } break;

#line 4594 "../../../git/src/qml/parser/qqmljs.g"

    case 599: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(3);
        sym(1).NamedImports = namedImports;
    } break;

#line 4603 "../../../git/src/qml/parser/qqmljs.g"

    case 600: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(4);
        sym(1).NamedImports = namedImports;
    } break;

#line 4613 "../../../git/src/qml/parser/qqmljs.g"

    case 601: {
        auto clause = new (pool) AST::FromClause(stringRef(2));
        clause->fromToken = loc(1);
        clause->moduleSpecifierToken = loc(2);
        sym(1).FromClause = clause;
    } break;

#line 4623 "../../../git/src/qml/parser/qqmljs.g"

    case 602: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportSpecifier);
        importsList->importSpecifierToken = loc(1);
        sym(1).ImportsList = importsList;
    } break;

#line 4631 "../../../git/src/qml/parser/qqmljs.g"

    case 603: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportsList, sym(3).ImportSpecifier);
        importsList->importSpecifierToken = loc(3);
        sym(1).ImportsList = importsList;
    } break;

#line 4643 "../../../git/src/qml/parser/qqmljs.g"

    case 604: {
        auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1));
        importSpecifier->importedBindingToken = loc(1);
        sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4651 "../../../git/src/qml/parser/qqmljs.g"

    case 605: {
    auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1), stringRef(3));
    importSpecifier->identifierToken = loc(1);
    importSpecifier->importedBindingToken = loc(3);
    sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4668 "../../../git/src/qml/parser/qqmljs.g"

    case 608: {
        int token = lookaheadToken(lexer);
        if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 4677 "../../../git/src/qml/parser/qqmljs.g"

    case 609: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4685 "../../../git/src/qml/parser/qqmljs.g"

    case 610: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause, sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4693 "../../../git/src/qml/parser/qqmljs.g"

    case 611: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4701 "../../../git/src/qml/parser/qqmljs.g"
 case 612:  Q_FALLTHROUGH(); 
#line 4703 "../../../git/src/qml/parser/qqmljs.g"

    case 613: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/false, sym(2).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4711 "../../../git/src/qml/parser/qqmljs.g"

    case 614: {
        if (auto *f = AST::cast<AST::FunctionDeclaration*>(sym(5).Node)) {
            if (f->name.isEmpty()) {
                f->name = stringRef(2);
                f->identifierToken = loc(2);
            }
        }
    } Q_FALLTHROUGH();

#line 4722 "../../../git/src/qml/parser/qqmljs.g"

    case 615: {
        // Emulate 15.2.3.11
        if (auto *cls = AST::cast<AST::ClassDeclaration*>(sym(5).Node)) {
            if (cls->name.isEmpty()) {
                cls->name = stringRef(2);
                cls->identifierToken = loc(2);
            }
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(5).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4738 "../../../git/src/qml/parser/qqmljs.g"

    case 616: {
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(4).Node)) {
            f->name = stringRef(2);
        }
        if (auto *c = asAnonymousClassDefinition(sym(4).Expression)) {
            c->name = stringRef(2);
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(4).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4755 "../../../git/src/qml/parser/qqmljs.g"

    case 617: {
        auto exportClause = new (pool) AST::ExportClause();
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(2);
        sym(1).ExportClause = exportClause;
    } break;

#line 4764 "../../../git/src/qml/parser/qqmljs.g"

    case 618: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(3);
        sym(1).ExportClause = exportClause;
    } break;

#line 4773 "../../../git/src/qml/parser/qqmljs.g"

    case 619: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(4);
        sym(1).ExportClause = exportClause;
    } break;

#line 4783 "../../../git/src/qml/parser/qqmljs.g"

    case 620: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportSpecifier);
    } break;

#line 4789 "../../../git/src/qml/parser/qqmljs.g"

    case 621: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportsList, sym(3).ExportSpecifier);
    } break;

#line 4796 "../../../git/src/qml/parser/qqmljs.g"

    case 622: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1));
        exportSpecifier->identifierToken = loc(1);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4804 "../../../git/src/qml/parser/qqmljs.g"

    case 623: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1), stringRef(3));
        exportSpecifier->identifierToken = loc(1);
        exportSpecifier->exportedIdentifierToken = loc(3);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4815 "../../../git/src/qml/parser/qqmljs.g"

    // ------------ end of switch statement
            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

#ifdef PARSER_DEBUG
    qDebug() << "Done or error.";
#endif

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of missing identifiers after dots
        if (yytoken != -1 && m_enableIdentifierInsertion && t_action(errorState, T_IDENTIFIER) && yyprevtoken == T_DOT) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting missing identifier between" << spell[yyprevtoken] << "and"
                     << spell[yytoken];
#endif
            pushTokenWithEmptyLocation(T_IDENTIFIER);
            action = errorState;
            goto _Lcheck_token;
        }


        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting automatic semicolon.";
#endif
            pushTokenWithEmptyLocation(T_SEMICOLON);
            action = errorState;
            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].raw = yytokenraw;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].raw   = yytokenraw    = lexer->rawString();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
#ifdef PARSER_DEBUG
            qDebug() << "Parse error, trying to recover.";
#endif
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
#ifdef PARSER_DEBUG
                qDebug() << "Parse error, trying to recover (2).";
#endif
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(*tk);
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(tk);
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(compileError(token_buffer[0].loc, msg));
    }

    return false;
}

QT_END_NAMESPACE


