
/* GENERATED CODE... DO NOT EDIT */

/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2013 - 2018 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "mbim-intel-thermal-rf.h"
#include "mbim-message-private.h"
#include "mbim-tlv-private.h"
#include "mbim-enum-types.h"
#include "mbim-flag-types.h"
#include "mbim-error-types.h"
#include "mbim-device.h"
#include "mbim-utils.h"

/*****************************************************************************/
/* Struct: MbimIntelRfimFrequencyValue */

static void
_mbim_intel_rfim_frequency_value_free (MbimIntelRfimFrequencyValue *var)
{
    if (!var)
        return;

    g_free (var);
}

void
mbim_intel_rfim_frequency_value_array_free (MbimIntelRfimFrequencyValueArray *array)
{
    guint32 i;

    if (!array)
        return;

    for (i = 0; array[i]; i++)
        _mbim_intel_rfim_frequency_value_free (array[i]);
    g_free (array);
}

static MbimIntelRfimFrequencyValue *
_mbim_message_read_mbim_intel_rfim_frequency_value_struct (
    const MbimMessage *self,
    guint32 relative_offset,
    guint32 *bytes_read,
    GError **error)
{
    gboolean success = FALSE;
    MbimIntelRfimFrequencyValue *out;
    guint32 offset = relative_offset;

    g_assert (self != NULL);

    out = g_new0 (MbimIntelRfimFrequencyValue, 1);


    if (!_mbim_message_read_guint32 (self, offset, &out->serving_cell_info, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint64 (self, offset, &out->center_frequency, error))
        goto out;
    offset += 8;

    if (!_mbim_message_read_guint32 (self, offset, &out->bandwidth, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rsrp, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rsrq, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->sinr, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->rssi, error))
        goto out;
    offset += 4;

    if (!_mbim_message_read_guint32 (self, offset, &out->connection_status, error))
        goto out;
    offset += 4;

    success = TRUE;

 out:
    if (success) {
        if (bytes_read)
            *bytes_read = (offset - relative_offset);
        return out;
    }

    g_free (out);
    return NULL;
}

static gboolean
_mbim_message_read_mbim_intel_rfim_frequency_value_ref_struct_array (
    const MbimMessage *self,
    guint32 array_size,
    guint32 relative_offset_array_start,
    MbimIntelRfimFrequencyValueArray **out_array,
    GError **error)
{
    g_autoptr(GPtrArray) out = NULL;
    guint32 i;
    guint32 offset;

    if (!array_size) {
        *out_array = NULL;
        return TRUE;
    }

    out = g_ptr_array_new_with_free_func ((GDestroyNotify)_mbim_intel_rfim_frequency_value_free);

    offset = relative_offset_array_start;
    for (i = 0; i < array_size; i++, offset += 8) {
        guint32 tmp_offset;
        MbimIntelRfimFrequencyValue *array_item;

        if (!_mbim_message_read_guint32 (self, offset, &tmp_offset, error)) 
            return FALSE;

        array_item = _mbim_message_read_mbim_intel_rfim_frequency_value_struct (self, tmp_offset, NULL, error);
        if (!array_item)
            return FALSE;
        g_ptr_array_add (out, array_item);
    }

    g_ptr_array_add (out, NULL);
    *out_array = (MbimIntelRfimFrequencyValueArray *) g_ptr_array_free (g_steal_pointer (&out), FALSE);
    return TRUE;
}

static gchar *
_mbim_message_print_mbim_intel_rfim_frequency_value_struct (
    const MbimIntelRfimFrequencyValue *self,
    const gchar *line_prefix)
{
    GString *str;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ServingCellInfo = ", line_prefix);
    {
        {
#if defined __MBIM_INTEL_SERVING_CELL_INFO_IS_ENUM__
            g_string_append_printf (str, "'%s'", mbim_intel_serving_cell_info_get_string ((MbimIntelServingCellInfo)self->serving_cell_info));
#elif defined __MBIM_INTEL_SERVING_CELL_INFO_IS_FLAGS__
            g_autofree gchar *tmpstr = NULL;

            tmpstr = mbim_intel_serving_cell_info_build_string_from_mask ((MbimIntelServingCellInfo)self->serving_cell_info);
            g_string_append_printf (str, "'%s'", tmpstr);
#else
# error neither enum nor flags
#endif
        }

    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  CenterFrequency = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT64_FORMAT "'", self->center_frequency);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  Bandwidth = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->bandwidth);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  RSRP = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rsrp);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  RSRQ = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rsrq);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  SINR = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->sinr);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  RSSI = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", self->rssi);
        }
    }
    g_string_append (str, "\n");
    g_string_append_printf (str, "%s  ConnectionStatus = ", line_prefix);
    {
        {
            g_string_append_printf (str, "'%s'", (gboolean)self->connection_status ? "true" : "false");
        }

    }
    g_string_append (str, "\n");
    return g_string_free (str, FALSE);
}

static GByteArray *
_mbim_intel_rfim_frequency_value_struct_new (const MbimIntelRfimFrequencyValue *value)
{
    MbimStructBuilder *builder;

    g_assert (value != NULL);

    builder = _mbim_struct_builder_new ();
    _mbim_struct_builder_append_guint32 (builder, value->serving_cell_info);
    _mbim_struct_builder_append_guint64 (builder, value->center_frequency);
    _mbim_struct_builder_append_guint32 (builder, value->bandwidth);
    _mbim_struct_builder_append_guint32 (builder, value->rsrp);
    _mbim_struct_builder_append_guint32 (builder, value->rsrq);
    _mbim_struct_builder_append_guint32 (builder, value->sinr);
    _mbim_struct_builder_append_guint32 (builder, value->rssi);
    _mbim_struct_builder_append_guint32 (builder, value->connection_status);

    return _mbim_struct_builder_complete (builder);
}

static void
_mbim_struct_builder_append_mbim_intel_rfim_frequency_value_struct (
    MbimStructBuilder *builder,
    const MbimIntelRfimFrequencyValue *value)
{
    GByteArray *raw;

    raw = _mbim_intel_rfim_frequency_value_struct_new (value);
    g_byte_array_append (builder->fixed_buffer, raw->data, raw->len);
    g_byte_array_unref (raw);
}

static void
_mbim_message_command_builder_append_mbim_intel_rfim_frequency_value_struct (
    MbimMessageCommandBuilder *builder,
    const MbimIntelRfimFrequencyValue *value)
{
    _mbim_struct_builder_append_mbim_intel_rfim_frequency_value_struct (builder->contents_builder, value);
}

static void
_mbim_struct_builder_append_mbim_intel_rfim_frequency_value_ref_struct_array (
    MbimStructBuilder *builder,
    const MbimIntelRfimFrequencyValue *const *values,
    guint32 n_values)
{
    guint32 offset;
    guint32 i;

    for (i = 0; i < n_values; i++) {
        guint32 length;
        guint32 offset_offset;
        GByteArray *raw;

        raw = _mbim_intel_rfim_frequency_value_struct_new (values[i]);
        g_assert (raw->len > 0);

        /* Offset of the offset */
        offset_offset = builder->fixed_buffer->len;

        /* Length *not* in LE yet */
        offset = builder->variable_buffer->len;
        /* Add the offset value */
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&offset, sizeof (offset));
        /* Configure the value to get updated */
        g_array_append_val (builder->offsets, offset_offset);

        /* Add the length value */
        length = GUINT32_TO_LE (raw->len);
        g_byte_array_append (builder->fixed_buffer, (guint8 *)&length, sizeof (length));

        /* And finally, the bytearray itself to the variable buffer */
        g_byte_array_append (builder->variable_buffer, (const guint8 *)raw->data, (guint)raw->len);
        g_byte_array_unref (raw);
    }
}

static void
_mbim_message_command_builder_append_mbim_intel_rfim_frequency_value_ref_struct_array (
    MbimMessageCommandBuilder *builder,
    const MbimIntelRfimFrequencyValue *const *values,
    guint32 n_values)
{
    _mbim_struct_builder_append_mbim_intel_rfim_frequency_value_ref_struct_array (builder->contents_builder, values, n_values);
}

/*****************************************************************************/
/* Message (Query): MBIM Message Intel Thermal RF RFIM */

MbimMessage *
mbim_message_intel_thermal_rf_rfim_query_new (
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_INTEL_THERMAL_RF,
                                                 MBIM_CID_INTEL_THERMAL_RF_RFIM,
                                                 MBIM_MESSAGE_COMMAND_TYPE_QUERY);

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_intel_thermal_rf_rfim_query_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;

    str = g_string_new ("");

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Set): MBIM Message Intel Thermal RF RFIM */

MbimMessage *
mbim_message_intel_thermal_rf_rfim_set_new (
    gboolean activation_state,
    GError **error)
{
    MbimMessageCommandBuilder *builder;

    builder = _mbim_message_command_builder_new (0,
                                                 MBIM_SERVICE_INTEL_THERMAL_RF,
                                                 MBIM_CID_INTEL_THERMAL_RF_RFIM,
                                                 MBIM_MESSAGE_COMMAND_TYPE_SET);
    {
        _mbim_message_command_builder_append_guint32 (builder, activation_state);
    }

    return _mbim_message_command_builder_complete (builder);
}

static gchar *
mbim_message_intel_thermal_rf_rfim_set_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;

    if (!mbim_message_command_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  ActivationState = ", line_prefix);
    {
        guint32 tmp;

        if (!_mbim_message_read_guint32 (message, offset, &tmp, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%s'", tmp ? "true" : "false");
        }

    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Response): MBIM Message Intel Thermal RF RFIM */

gboolean
mbim_message_intel_thermal_rf_rfim_response_parse (
    const MbimMessage *message,
    guint32 *out_rfim_frequency_values_count,
    MbimIntelRfimFrequencyValueArray **out_rfim_frequency_values,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _rfim_frequency_values_count;
    MbimIntelRfimFrequencyValue **_rfim_frequency_values = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_COMMAND_DONE) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a response");
        return FALSE;
    }

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'RfimFrequencyValuesCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_rfim_frequency_values_count, error))
            goto out;
        if (out_rfim_frequency_values_count != NULL)
            *out_rfim_frequency_values_count = _rfim_frequency_values_count;
        offset += 4;
    }

    /* Read the 'RfimFrequencyValues' variable */
    {
        if ((out_rfim_frequency_values != NULL) && !_mbim_message_read_mbim_intel_rfim_frequency_value_ref_struct_array (message, _rfim_frequency_values_count, offset, &_rfim_frequency_values, error))
            goto out;
        offset += (8 * _rfim_frequency_values_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_rfim_frequency_values != NULL)
            *out_rfim_frequency_values = _rfim_frequency_values;
    } else {
        mbim_intel_rfim_frequency_value_array_free (_rfim_frequency_values);
    }

    return success;
}

static gchar *
mbim_message_intel_thermal_rf_rfim_response_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _rfim_frequency_values_count;

    if (!mbim_message_command_done_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  RfimFrequencyValuesCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_rfim_frequency_values_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _rfim_frequency_values_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  RfimFrequencyValues = ", line_prefix);
    {
        g_autoptr(MbimIntelRfimFrequencyValueArray) tmp = NULL;

        if (!_mbim_message_read_mbim_intel_rfim_frequency_value_ref_struct_array (message, _rfim_frequency_values_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _rfim_frequency_values_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _rfim_frequency_values_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_intel_rfim_frequency_value_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

/*****************************************************************************/
/* Message (Notification): MBIM Message Intel Thermal RF RFIM */

gboolean
mbim_message_intel_thermal_rf_rfim_notification_parse (
    const MbimMessage *message,
    guint32 *out_rfim_frequency_values_count,
    MbimIntelRfimFrequencyValueArray **out_rfim_frequency_values,
    GError **error)
{
    gboolean success = FALSE;
    guint32 offset = 0;
    guint32 _rfim_frequency_values_count;
    MbimIntelRfimFrequencyValue **_rfim_frequency_values = NULL;

    if (mbim_message_get_message_type (message) != MBIM_MESSAGE_TYPE_INDICATE_STATUS) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message is not a notification");
        return FALSE;
    }

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL)) {
        g_set_error (error,
                     MBIM_CORE_ERROR,
                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                     "Message does not have information buffer");
        return FALSE;
    }

    /* Read the 'RfimFrequencyValuesCount' variable */
    {
        if (!_mbim_message_read_guint32 (message, offset, &_rfim_frequency_values_count, error))
            goto out;
        if (out_rfim_frequency_values_count != NULL)
            *out_rfim_frequency_values_count = _rfim_frequency_values_count;
        offset += 4;
    }

    /* Read the 'RfimFrequencyValues' variable */
    {
        if ((out_rfim_frequency_values != NULL) && !_mbim_message_read_mbim_intel_rfim_frequency_value_ref_struct_array (message, _rfim_frequency_values_count, offset, &_rfim_frequency_values, error))
            goto out;
        offset += (8 * _rfim_frequency_values_count);
    }

    /* All variables successfully parsed */
    success = TRUE;

 out:

    if (success) {
        /* Memory allocated variables as output */
        if (out_rfim_frequency_values != NULL)
            *out_rfim_frequency_values = _rfim_frequency_values;
    } else {
        mbim_intel_rfim_frequency_value_array_free (_rfim_frequency_values);
    }

    return success;
}

static gchar *
mbim_message_intel_thermal_rf_rfim_notification_get_printable (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    GString *str;
    GError *inner_error = NULL;
    guint32 offset = 0;
    guint32 _rfim_frequency_values_count;

    if (!mbim_message_indicate_status_get_raw_information_buffer (message, NULL))
        return NULL;

    str = g_string_new ("");

    g_string_append_printf (str, "%s  RfimFrequencyValuesCount = ", line_prefix);
    {
        if (!_mbim_message_read_guint32 (message, offset, &_rfim_frequency_values_count, &inner_error))
            goto out;
        offset += 4;
        {
            g_string_append_printf (str, "'%" G_GUINT32_FORMAT "'", _rfim_frequency_values_count);
        }
    }
    g_string_append (str, "\n");

    g_string_append_printf (str, "%s  RfimFrequencyValues = ", line_prefix);
    {
        g_autoptr(MbimIntelRfimFrequencyValueArray) tmp = NULL;

        if (!_mbim_message_read_mbim_intel_rfim_frequency_value_ref_struct_array (message, _rfim_frequency_values_count, offset, &tmp, &inner_error))
            goto out;
        offset += (8 * _rfim_frequency_values_count);
        {
            guint i;
            g_autofree gchar *new_line_prefix = NULL;

            new_line_prefix = g_strdup_printf ("%s        ", line_prefix);
            g_string_append (str, "'{\n");
            for (i = 0; i < _rfim_frequency_values_count; i++) {
                g_autofree gchar *struct_str = NULL;

                g_string_append_printf (str, "%s    [%u] = {\n", line_prefix, i);
                struct_str = _mbim_message_print_mbim_intel_rfim_frequency_value_struct (tmp[i], new_line_prefix);
                g_string_append (str, struct_str);
                g_string_append_printf (str, "%s    },\n", line_prefix);
            }
            g_string_append_printf (str, "%s  }'", line_prefix);
        }
    }
    g_string_append (str, "\n");

 out:
    if (inner_error) {
        g_string_append_printf (str, "n/a: %s", inner_error->message);
        g_clear_error (&inner_error);
    }

    return g_string_free (str, FALSE);
}

typedef struct {
  gchar * (* query_cb)        (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* set_cb)          (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* response_cb)     (const MbimMessage *message, const gchar *line_prefix, GError **error);
  gchar * (* notification_cb) (const MbimMessage *message, const gchar *line_prefix, GError **error);
} GetPrintableCallbacks;

static const GetPrintableCallbacks intel_thermal_rf_get_printable_callbacks[] = {
    [MBIM_CID_INTEL_THERMAL_RF_RFIM] = {
        .query_cb = mbim_message_intel_thermal_rf_rfim_query_get_printable,
        .set_cb = mbim_message_intel_thermal_rf_rfim_set_get_printable,
        .response_cb = mbim_message_intel_thermal_rf_rfim_response_get_printable,
        .notification_cb = mbim_message_intel_thermal_rf_rfim_notification_get_printable,
    },
};

gchar *
__mbim_message_intel_thermal_rf_get_printable_fields (
    const MbimMessage *message,
    const gchar *line_prefix,
    GError **error)
{
    guint32 cid;

    switch (mbim_message_get_message_type (message)) {
        case MBIM_MESSAGE_TYPE_COMMAND: {
            cid = mbim_message_command_get_cid (message);
            if (cid < G_N_ELEMENTS (intel_thermal_rf_get_printable_callbacks)) {
                switch (mbim_message_command_get_command_type (message)) {
                    case MBIM_MESSAGE_COMMAND_TYPE_QUERY:
                        if (intel_thermal_rf_get_printable_callbacks[cid].query_cb)
                            return intel_thermal_rf_get_printable_callbacks[cid].query_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_SET:
                        if (intel_thermal_rf_get_printable_callbacks[cid].set_cb)
                            return intel_thermal_rf_get_printable_callbacks[cid].set_cb (message, line_prefix, error);
                        break;
                    case MBIM_MESSAGE_COMMAND_TYPE_UNKNOWN:
                    default:
                        g_set_error (error,
                                     MBIM_CORE_ERROR,
                                     MBIM_CORE_ERROR_INVALID_MESSAGE,
                                     "Invalid command type");
                        return NULL;
                }
            }
            break;
        }

        case MBIM_MESSAGE_TYPE_COMMAND_DONE:
            cid = mbim_message_command_done_get_cid (message);
            if (cid < G_N_ELEMENTS (intel_thermal_rf_get_printable_callbacks)) {
                if (intel_thermal_rf_get_printable_callbacks[cid].response_cb)
                    return intel_thermal_rf_get_printable_callbacks[cid].response_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_INDICATE_STATUS:
            cid = mbim_message_indicate_status_get_cid (message);
            if (cid < G_N_ELEMENTS (intel_thermal_rf_get_printable_callbacks)) {
                if (intel_thermal_rf_get_printable_callbacks[cid].notification_cb)
                    return intel_thermal_rf_get_printable_callbacks[cid].notification_cb (message, line_prefix, error);
            }
            break;

        case MBIM_MESSAGE_TYPE_OPEN: 
        case MBIM_MESSAGE_TYPE_CLOSE: 
        case MBIM_MESSAGE_TYPE_INVALID: 
        case MBIM_MESSAGE_TYPE_HOST_ERROR: 
        case MBIM_MESSAGE_TYPE_OPEN_DONE: 
        case MBIM_MESSAGE_TYPE_CLOSE_DONE: 
        case MBIM_MESSAGE_TYPE_FUNCTION_ERROR: 
        default:
            g_set_error (error,
                         MBIM_CORE_ERROR,
                         MBIM_CORE_ERROR_INVALID_MESSAGE,
                         "No contents expected in this message type");
            return NULL;
    }

    g_set_error (error,
                 MBIM_CORE_ERROR,
                 MBIM_CORE_ERROR_UNSUPPORTED,
                 "Unsupported message");
    return NULL;
}
