// THIS FILE IS GENERATED BY impellerc.
// DO NOT EDIT OR CHECK THIS INTO SOURCE CONTROL

#pragma once

#include "impeller/core/buffer_view.h"                
#include "impeller/core/sampler.h"                    
#include "impeller/core/shader_types.h"               
#include "impeller/core/resource_binder.h"            
#include "impeller/core/texture.h"                    

namespace impeller {

struct TextureFillStrictSrcFragmentShader {
  // ===========================================================================
  // Stage Info ================================================================
  // ===========================================================================
  static constexpr std::string_view kLabel = "TextureFillStrictSrc";
  static constexpr std::string_view kEntrypointName = "texture_fill_strict_src_fragment_main";
  static constexpr ShaderStage kShaderStage = ShaderStage::kFragment;
  // The generator used to prepare these bindings. Metal generators may be used
  // by GLES backends but GLES generators are unsuitable for the metal backend.
  static constexpr std::string_view kGeneratorName = "OpenGL Shading Language (Relaxed Vulkan Semantics)";
  // ===========================================================================
  // Struct Definitions ========================================================
  // ===========================================================================

  struct FragInfo {
    Vector4 source_rect; // (offset 0, size 16)
    Scalar alpha; // (offset 16, size 4)
    Padding<12> _PADDING_; // (offset 20, size 12)
  }; // struct FragInfo (size 32)

  // ===========================================================================
  // Stage Uniform & Storage Buffers ===========================================
  // ===========================================================================

  static constexpr auto kResourceFragInfo = ShaderUniformSlot { // FragInfo
    "FragInfo",     // name
    65u, // ext_res_0
    0u,       // set
    65u,   // binding
  };
  static ShaderMetadata kMetadataFragInfo;

  // ===========================================================================
  // Stage Inputs ==============================================================
  // ===========================================================================
  static constexpr auto kInputVTextureCoords = ShaderStageIOSlot { // v_texture_coords
    "v_texture_coords",             // name
    0u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    2u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    false,  // relaxed precision
  };

  static constexpr std::array<const ShaderStageIOSlot*, 1> kAllShaderStageInputs = {
    &kInputVTextureCoords, // v_texture_coords
  };


  // ===========================================================================
  // Sampled Images ============================================================
  // ===========================================================================

  static constexpr auto kResourceTextureSampler = SampledImageSlot { // texture_sampler
    "texture_sampler",      // name
    64u,  // ext_res_0
    0u,        // set
    64u,    // binding
  };
  static ShaderMetadata kMetadataTextureSampler;
  // ===========================================================================
  // Stage Outputs =============================================================
  // ===========================================================================
  static constexpr auto kOutputFragColor = ShaderStageIOSlot { // frag_color
    "frag_color",             // name
    0u,          // attribute location
    0u,    // attribute set
    0u,           // attribute binding
    ShaderType::kFloat,     // type
    32u,    // bit width of type
    4u,     // vec size
    1u,      // number of columns
    0u,            // offset for interleaved layout
    true,  // relaxed precision
  };
  static constexpr std::array<const ShaderStageIOSlot*, 1> kAllShaderStageOutputs = {
    &kOutputFragColor, // frag_color
  };

  // ===========================================================================
  // Resource Binding Utilities ================================================
  // ===========================================================================

  /// Bind uniform buffer for resource named FragInfo.
  static bool BindFragInfo(ResourceBinder& command, BufferView view) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kUniformBuffer, kResourceFragInfo, &kMetadataFragInfo, std::move(view));
  }

  /// Bind combined image sampler for resource named texture_sampler.
  static bool BindTextureSampler(ResourceBinder& command, std::shared_ptr<const Texture> texture, raw_ptr<const Sampler> sampler) {
    return command.BindResource(ShaderStage::kFragment, DescriptorType::kSampledImage, kResourceTextureSampler, &kMetadataTextureSampler, std::move(texture), std::move(sampler));
  }


  // ===========================================================================
  // Metadata for Vulkan =======================================================
  // ===========================================================================
  static constexpr std::array<DescriptorSetLayout,2> kDescriptorSetLayouts{
    DescriptorSetLayout{
      65, // binding = 65
      DescriptorType::kUniformBuffer, // descriptor_type = DescriptorType::kUniformBuffer
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
    DescriptorSetLayout{
      64, // binding = 64
      DescriptorType::kSampledImage, // descriptor_type = DescriptorType::kSampledImage
      ShaderStage::kFragment, // shader_stage = ShaderStage::kFragment
    },
  };

};  // struct TextureFillStrictSrcFragmentShader

}  // namespace impeller
