/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;

public class NavigationChannel {
    private static final String TAG = "NavigationChannel";
    @NonNull
    public final MethodChannel channel;
    private final MethodChannel.MethodCallHandler defaultHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            result.success(null);
        }
    };

    public NavigationChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/navigation", JSONMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.defaultHandler);
    }

    public void setInitialRoute(@NonNull String initialRoute) {
        Log.v(TAG, "Sending message to set initial route to '" + initialRoute + "'");
        this.channel.invokeMethod("setInitialRoute", initialRoute);
    }

    public void pushRoute(@NonNull String route) {
        Log.v(TAG, "Sending message to push route '" + route + "'");
        this.channel.invokeMethod("pushRoute", route);
    }

    public void popRoute() {
        Log.v(TAG, "Sending message to pop route.");
        this.channel.invokeMethod("popRoute", null);
    }

    public void setMethodCallHandler(@Nullable MethodChannel.MethodCallHandler handler) {
        this.channel.setMethodCallHandler(handler);
    }
}

