/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import io.flutter.Log;
import io.flutter.embedding.android.DrawableSplashScreen;
import io.flutter.embedding.android.ExclusiveAppComponent;
import io.flutter.embedding.android.FlutterActivityAndFragmentDelegate;
import io.flutter.embedding.android.FlutterActivityLaunchConfigs;
import io.flutter.embedding.android.FlutterSurfaceView;
import io.flutter.embedding.android.FlutterTextureView;
import io.flutter.embedding.android.RenderMode;
import io.flutter.embedding.android.SplashScreen;
import io.flutter.embedding.android.TransparencyMode;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterShellArgs;
import io.flutter.embedding.engine.plugins.util.GeneratedPluginRegister;
import io.flutter.plugin.platform.PlatformPlugin;
import io.flutter.util.ViewUtils;
import java.util.ArrayList;
import java.util.List;

public class FlutterActivity
extends Activity
implements FlutterActivityAndFragmentDelegate.Host,
LifecycleOwner {
    private static final String TAG = "FlutterActivity";
    public static final int FLUTTER_VIEW_ID = ViewUtils.generateViewId(61938);
    @VisibleForTesting
    protected FlutterActivityAndFragmentDelegate delegate;
    @NonNull
    private LifecycleRegistry lifecycle = new LifecycleRegistry((LifecycleOwner)this);

    @NonNull
    public static Intent createDefaultIntent(@NonNull Context launchContext) {
        return FlutterActivity.withNewEngine().build(launchContext);
    }

    @NonNull
    public static NewEngineIntentBuilder withNewEngine() {
        return new NewEngineIntentBuilder(FlutterActivity.class);
    }

    public static CachedEngineIntentBuilder withCachedEngine(@NonNull String cachedEngineId) {
        return new CachedEngineIntentBuilder(FlutterActivity.class, cachedEngineId);
    }

    @VisibleForTesting
    void setDelegate(@NonNull FlutterActivityAndFragmentDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExclusiveAppComponent<Activity> getExclusiveAppComponent() {
        return this.delegate;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.switchLaunchThemeForNormalTheme();
        super.onCreate(savedInstanceState);
        this.delegate = new FlutterActivityAndFragmentDelegate(this);
        this.delegate.onAttach((Context)this);
        this.delegate.onRestoreInstanceState(savedInstanceState);
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        this.configureWindowForTransparency();
        this.setContentView(this.createFlutterView());
        this.configureStatusBarForFullscreenFlutterExperience();
    }

    private void switchLaunchThemeForNormalTheme() {
        try {
            Bundle metaData = this.getMetaData();
            if (metaData != null) {
                int normalThemeRID = metaData.getInt("io.flutter.embedding.android.NormalTheme", -1);
                if (normalThemeRID != -1) {
                    this.setTheme(normalThemeRID);
                }
            } else {
                Log.v(TAG, "Using the launch theme as normal theme.");
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e(TAG, "Could not read meta-data for FlutterActivity. Using the launch theme as normal theme.");
        }
    }

    @Override
    @Nullable
    public SplashScreen provideSplashScreen() {
        Drawable manifestSplashDrawable = this.getSplashScreenFromManifest();
        if (manifestSplashDrawable != null) {
            return new DrawableSplashScreen(manifestSplashDrawable);
        }
        return null;
    }

    @Nullable
    private Drawable getSplashScreenFromManifest() {
        try {
            Bundle metaData = this.getMetaData();
            int splashScreenId = metaData != null ? metaData.getInt("io.flutter.embedding.android.SplashScreenDrawable") : 0;
            return splashScreenId != 0 ? ResourcesCompat.getDrawable((Resources)this.getResources(), (int)splashScreenId, (Resources.Theme)this.getTheme()) : null;
        }
        catch (Resources.NotFoundException e) {
            Log.e(TAG, "Splash screen not found. Ensure the drawable exists and that it's valid.");
            throw e;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private void configureWindowForTransparency() {
        FlutterActivityLaunchConfigs.BackgroundMode backgroundMode = this.getBackgroundMode();
        if (backgroundMode == FlutterActivityLaunchConfigs.BackgroundMode.transparent) {
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    @NonNull
    private View createFlutterView() {
        return this.delegate.onCreateView(null, null, null, FLUTTER_VIEW_ID, this.getRenderMode() == RenderMode.surface);
    }

    private void configureStatusBarForFullscreenFlutterExperience() {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0x40000000);
            window.getDecorView().setSystemUiVisibility(1280);
        }
    }

    protected void onStart() {
        super.onStart();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_START);
        if (this.stillAttachedForEvent("onStart")) {
            this.delegate.onStart();
        }
    }

    protected void onResume() {
        super.onResume();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        if (this.stillAttachedForEvent("onResume")) {
            this.delegate.onResume();
        }
    }

    public void onPostResume() {
        super.onPostResume();
        if (this.stillAttachedForEvent("onPostResume")) {
            this.delegate.onPostResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.stillAttachedForEvent("onPause")) {
            this.delegate.onPause();
        }
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
    }

    protected void onStop() {
        super.onStop();
        if (this.stillAttachedForEvent("onStop")) {
            this.delegate.onStop();
        }
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.stillAttachedForEvent("onSaveInstanceState")) {
            this.delegate.onSaveInstanceState(outState);
        }
    }

    private void release() {
        if (this.delegate != null) {
            this.delegate.release();
            this.delegate = null;
        }
    }

    @Override
    public void detachFromFlutterEngine() {
        Log.w(TAG, "FlutterActivity " + this + " connection to the engine " + this.getFlutterEngine() + " evicted by another attaching activity");
        if (this.delegate != null) {
            this.delegate.onDestroyView();
            this.delegate.onDetach();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.stillAttachedForEvent("onDestroy")) {
            this.delegate.onDestroyView();
            this.delegate.onDetach();
        }
        this.release();
        this.lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.stillAttachedForEvent("onActivityResult")) {
            this.delegate.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        if (this.stillAttachedForEvent("onNewIntent")) {
            this.delegate.onNewIntent(intent);
        }
    }

    public void onBackPressed() {
        if (this.stillAttachedForEvent("onBackPressed")) {
            this.delegate.onBackPressed();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (this.stillAttachedForEvent("onRequestPermissionsResult")) {
            this.delegate.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void onUserLeaveHint() {
        if (this.stillAttachedForEvent("onUserLeaveHint")) {
            this.delegate.onUserLeaveHint();
        }
    }

    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.stillAttachedForEvent("onTrimMemory")) {
            this.delegate.onTrimMemory(level);
        }
    }

    @Override
    @NonNull
    public Context getContext() {
        return this;
    }

    @Override
    @NonNull
    public Activity getActivity() {
        return this;
    }

    @Override
    @NonNull
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @NonNull
    public FlutterShellArgs getFlutterShellArgs() {
        return FlutterShellArgs.fromIntent(this.getIntent());
    }

    @Override
    @Nullable
    public String getCachedEngineId() {
        return this.getIntent().getStringExtra("cached_engine_id");
    }

    @Override
    public boolean shouldDestroyEngineWithHost() {
        boolean explicitDestructionRequested = this.getIntent().getBooleanExtra("destroy_engine_with_activity", false);
        if (this.getCachedEngineId() != null || this.delegate.isFlutterEngineFromHost()) {
            return explicitDestructionRequested;
        }
        return this.getIntent().getBooleanExtra("destroy_engine_with_activity", true);
    }

    @Override
    @NonNull
    public String getDartEntrypointFunctionName() {
        try {
            Bundle metaData = this.getMetaData();
            String desiredDartEntrypoint = metaData != null ? metaData.getString("io.flutter.Entrypoint") : null;
            return desiredDartEntrypoint != null ? desiredDartEntrypoint : "main";
        }
        catch (PackageManager.NameNotFoundException e) {
            return "main";
        }
    }

    @Override
    @Nullable
    public List<String> getDartEntrypointArgs() {
        return (List)((Object)this.getIntent().getSerializableExtra("dart_entrypoint_args"));
    }

    @Override
    @Nullable
    public String getDartEntrypointLibraryUri() {
        try {
            Bundle metaData = this.getMetaData();
            String desiredDartLibraryUri = metaData != null ? metaData.getString("io.flutter.EntrypointUri") : null;
            return desiredDartLibraryUri;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    @Override
    public String getInitialRoute() {
        if (this.getIntent().hasExtra("route")) {
            return this.getIntent().getStringExtra("route");
        }
        try {
            Bundle metaData = this.getMetaData();
            String desiredInitialRoute = metaData != null ? metaData.getString("io.flutter.InitialRoute") : null;
            return desiredInitialRoute;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    @Override
    @NonNull
    public String getAppBundlePath() {
        String appBundlePath;
        if (this.isDebuggable() && "android.intent.action.RUN".equals(this.getIntent().getAction()) && (appBundlePath = this.getIntent().getDataString()) != null) {
            return appBundlePath;
        }
        return null;
    }

    private boolean isDebuggable() {
        return (this.getApplicationInfo().flags & 2) != 0;
    }

    @Override
    @NonNull
    public RenderMode getRenderMode() {
        return this.getBackgroundMode() == FlutterActivityLaunchConfigs.BackgroundMode.opaque ? RenderMode.surface : RenderMode.texture;
    }

    @Override
    @NonNull
    public TransparencyMode getTransparencyMode() {
        return this.getBackgroundMode() == FlutterActivityLaunchConfigs.BackgroundMode.opaque ? TransparencyMode.opaque : TransparencyMode.transparent;
    }

    @NonNull
    protected FlutterActivityLaunchConfigs.BackgroundMode getBackgroundMode() {
        if (this.getIntent().hasExtra("background_mode")) {
            return FlutterActivityLaunchConfigs.BackgroundMode.valueOf(this.getIntent().getStringExtra("background_mode"));
        }
        return FlutterActivityLaunchConfigs.BackgroundMode.opaque;
    }

    @Override
    @Nullable
    public FlutterEngine provideFlutterEngine(@NonNull Context context) {
        return null;
    }

    @Nullable
    protected FlutterEngine getFlutterEngine() {
        return this.delegate.getFlutterEngine();
    }

    @Nullable
    protected Bundle getMetaData() throws PackageManager.NameNotFoundException {
        ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 128);
        return activityInfo.metaData;
    }

    @Override
    @Nullable
    public PlatformPlugin providePlatformPlugin(@Nullable Activity activity, @NonNull FlutterEngine flutterEngine) {
        return new PlatformPlugin(this.getActivity(), flutterEngine.getPlatformChannel(), this);
    }

    @Override
    public void configureFlutterEngine(@NonNull FlutterEngine flutterEngine) {
        if (this.delegate.isFlutterEngineFromHost()) {
            return;
        }
        GeneratedPluginRegister.registerGeneratedPlugins(flutterEngine);
    }

    @Override
    public void cleanUpFlutterEngine(@NonNull FlutterEngine flutterEngine) {
    }

    @Override
    public boolean shouldAttachEngineToActivity() {
        return true;
    }

    @Override
    public boolean shouldHandleDeeplinking() {
        try {
            Bundle metaData = this.getMetaData();
            boolean shouldHandleDeeplinking = metaData != null ? metaData.getBoolean("flutter_deeplinking_enabled") : false;
            return shouldHandleDeeplinking;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    public void onFlutterSurfaceViewCreated(@NonNull FlutterSurfaceView flutterSurfaceView) {
    }

    @Override
    public void onFlutterTextureViewCreated(@NonNull FlutterTextureView flutterTextureView) {
    }

    @Override
    public void onFlutterUiDisplayed() {
        if (Build.VERSION.SDK_INT >= 29) {
            this.reportFullyDrawn();
        }
    }

    @Override
    public void onFlutterUiNoLongerDisplayed() {
    }

    @Override
    public boolean shouldRestoreAndSaveState() {
        if (this.getIntent().hasExtra("enable_state_restoration")) {
            return this.getIntent().getBooleanExtra("enable_state_restoration", false);
        }
        return this.getCachedEngineId() == null;
    }

    @Override
    public boolean shouldDispatchAppLifecycleState() {
        return true;
    }

    @Override
    public boolean popSystemNavigator() {
        return false;
    }

    @Override
    public void updateSystemUiOverlays() {
        if (this.delegate != null) {
            this.delegate.updateSystemUiOverlays();
        }
    }

    private boolean stillAttachedForEvent(String event) {
        if (this.delegate == null) {
            Log.w(TAG, "FlutterActivity " + this.hashCode() + " " + event + " called after release.");
            return false;
        }
        if (!this.delegate.isAttached()) {
            Log.w(TAG, "FlutterActivity " + this.hashCode() + " " + event + " called after detach.");
            return false;
        }
        return true;
    }

    public static class CachedEngineIntentBuilder {
        private final Class<? extends FlutterActivity> activityClass;
        private final String cachedEngineId;
        private boolean destroyEngineWithActivity = false;
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;

        public CachedEngineIntentBuilder(@NonNull Class<? extends FlutterActivity> activityClass, @NonNull String engineId) {
            this.activityClass = activityClass;
            this.cachedEngineId = engineId;
        }

        public CachedEngineIntentBuilder destroyEngineWithActivity(boolean destroyEngineWithActivity) {
            this.destroyEngineWithActivity = destroyEngineWithActivity;
            return this;
        }

        @NonNull
        public CachedEngineIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            return new Intent(context, this.activityClass).putExtra("cached_engine_id", this.cachedEngineId).putExtra("destroy_engine_with_activity", this.destroyEngineWithActivity).putExtra("background_mode", this.backgroundMode);
        }
    }

    public static class NewEngineIntentBuilder {
        private final Class<? extends FlutterActivity> activityClass;
        private String initialRoute = "/";
        private String backgroundMode = FlutterActivityLaunchConfigs.DEFAULT_BACKGROUND_MODE;
        @Nullable
        private List<String> dartEntrypointArgs;

        public NewEngineIntentBuilder(@NonNull Class<? extends FlutterActivity> activityClass) {
            this.activityClass = activityClass;
        }

        @NonNull
        public NewEngineIntentBuilder initialRoute(@NonNull String initialRoute) {
            this.initialRoute = initialRoute;
            return this;
        }

        @NonNull
        public NewEngineIntentBuilder backgroundMode(@NonNull FlutterActivityLaunchConfigs.BackgroundMode backgroundMode) {
            this.backgroundMode = backgroundMode.name();
            return this;
        }

        @NonNull
        public NewEngineIntentBuilder dartEntrypointArgs(@Nullable List<String> dartEntrypointArgs) {
            this.dartEntrypointArgs = dartEntrypointArgs;
            return this;
        }

        @NonNull
        public Intent build(@NonNull Context context) {
            Intent intent = new Intent(context, this.activityClass).putExtra("route", this.initialRoute).putExtra("background_mode", this.backgroundMode).putExtra("destroy_engine_with_activity", true);
            if (this.dartEntrypointArgs != null) {
                intent.putExtra("dart_entrypoint_args", new ArrayList<String>(this.dartEntrypointArgs));
            }
            return intent;
        }
    }
}

